-- **************************************************
-- Provide Moho with the name of this script object
-- **************************************************

ScriptName = "AE_PlaceLayerInGroup"

-- **************************************************
-- General information about this script
-- **************************************************

AE_PlaceLayerInGroup = {}

function AE_PlaceLayerInGroup:Name()
	return 'Place layer in/out group'
end

function AE_PlaceLayerInGroup:Version()
	return '1.2'
end

function AE_PlaceLayerInGroup:UILabel()
	return 'Place layer in/out group'
end

function AE_PlaceLayerInGroup:Creator()
	return 'Alexandra Evseeva'
end

function AE_PlaceLayerInGroup:Description()
	return 'Select layer and group to put in in, or only layer to put it out (to the root)'
end


-- **************************************************
-- Is Relevant / Is Enabled
-- **************************************************

function AE_PlaceLayerInGroup:IsRelevant(moho)
	return true
end

function AE_PlaceLayerInGroup:IsEnabled(moho)
	return true
end

-- **************************************************
-- The guts of this script
-- **************************************************

function AE_PlaceLayerInGroup:Run(moho)
	moho.document:SetDirty()
	moho.document:PrepUndo(nil)

	local selCount = moho.document:CountSelectedLayers()
	if selCount == 1 then
		if not moho.layer:Parent() then return LM.GUI.Alert(LM.GUI.ALERT_WARNING, "The only selected layer is allways in root group") end
		return self:PutLayerIntoGroup(moho, moho.layer)
	end
	if selCount > 2 then return LM.GUI.Alert(LM.GUI.ALERT_WARNING, "Select one or two layers") end
	local layer1 = moho.document:GetSelectedLayer(0)
	local layer2 = moho.document:GetSelectedLayer(1)
	if moho:LayerAsGroup(layer1) and moho:LayerAsGroup(layer2) then
		local askText = string.format("%s and %s are both groups. What do you want to move?", layer1:Name(), layer2:Name())
		local answer = LM.GUI.Alert(LM.GUI.ALERT_INFO, askText, '', '', layer1:Name(), layer2:Name(), 'CANCEL')
		if answer == 0 then return self:PutLayerIntoGroup(moho, layer1, moho:LayerAsGroup(layer2)) end
		if answer == 1 then return self:PutLayerIntoGroup(moho, layer2, moho:LayerAsGroup(layer1)) end
		if answer == 2 then return end
	end
	if moho:LayerAsGroup(layer1) then return self:PutLayerIntoGroup(moho, layer2, moho:LayerAsGroup(layer1)) end
	if moho:LayerAsGroup(layer2) then return self:PutLayerIntoGroup(moho, layer1, moho:LayerAsGroup(layer2)) end
	return LM.GUI.Alert(LM.GUI.ALERT_WARNING, "No one of selected layers is of group type")
end

function AE_PlaceLayerInGroup:PutLayerIntoGroup(moho, layer, group)
	if group and AE_Utilities:IsAncestor(layer, group) then return LM.GUI.Alert(LM.GUI.ALERT_WARNING, "Can not put parent into its child") end
	local oldLayerMatrix = AE_Utilities:GetGlobalLayerMatrix(moho, layer, moho.frame)
	local hiestLayer = moho.document:Layer(moho.document:CountLayers()-1)
	if group then 
		if group:CountLayers() > 0 then hiestLayer = group:Layer(group:CountLayers()-1)
		else hiestLayer = nil end
		local newParentMatrix = AE_Utilities:GetGlobalLayerMatrix(moho, group, moho.frame)
		newParentMatrix:Invert()	
		newParentMatrix:Multiply(oldLayerMatrix)	
		oldLayerMatrix:Set(newParentMatrix)
	end
	if not hiestLayer then moho:PlaceLayerInGroup(layer, group) 
	else 
		moho:PlaceLayerBehindAnother(layer, hiestLayer)
		moho:PlaceLayerBehindAnother(hiestLayer, layer)
	end

	local translation, rotationZ, scale, flip = AE_Utilities:Matrix2transform(oldLayerMatrix)
	layer.fTranslation:SetValue(moho.frame, translation)
	layer.fRotationZ:SetValue(moho.frame, rotationZ)
	layer.fScale:SetValue(moho.frame, scale)
	layer.fFlipH:SetValue(moho.frame, flip)
	
	if group and moho:LayerAsSwitch(group) then moho:LayerAsSwitch(group):SetValue(moho.frame, layer:Name()) end
	
	--fix Origin
	local oldOrigin = layer:Origin()
	local newOrigin = LM.Vector3:new_local()
	layer:SetOrigin(newOrigin)
	local matrix = LM.Matrix:new_local()


	local beforeVec = LM.Vector3:new_local()
	local afterVec = LM.Vector3:new_local()

	layer:GetFullTransform(moho.frame, matrix, nil)
	matrix:Transform(beforeVec)
	
	layer:SetOrigin(oldOrigin)
	
	layer:GetFullTransform(moho.frame, matrix, nil)
	matrix:Transform(afterVec)
	
	local newLayerPos = layer.fTranslation.value + beforeVec - afterVec
	local v = newLayerPos - layer.fTranslation.value
	layer.fTranslation:SetValue(moho.layerFrame, newLayerPos)
	
end
