-- **************************************************
-- Provide Moho with the name of this scrippt object
-- ***************************************************

ScriptName = "CC_CENTER_VECTOR_LAYER_TO_POINTS"

-- ***************************************************
-- General information about this script
-- ***************************************************

CC_LuaUtils = {}

CC_CENTER_VECTOR_LAYER_TO_POINTS   = {}
CC_CENTER_VECTOR_LAYER_TO_POINTS.MAJOR_VERSION = 1
CC_CENTER_VECTOR_LAYER_TO_POINTS.MINOR_VERSION = 1

function CC_CENTER_VECTOR_LAYER_TO_POINTS:Name()
	return("CC_CENTER_VECTOR_LAYER_TO_POINTS")
end

function CC_CENTER_VECTOR_LAYER_TO_POINTS:Version()
	return "" .. CC_CENTER_VECTOR_LAYER_TO_POINTS.MAJOR_VERSION .. ".".. CC_CENTER_VECTOR_LAYER_TO_POINTS.MINOR_VERSION
end

function CC_CENTER_VECTOR_LAYER_TO_POINTS:Description()
	return "Set the origin of the vector layers to the center of the points"
end

function CC_CENTER_VECTOR_LAYER_TO_POINTS:Creator()
	return "Crashcore"
end

function CC_CENTER_VECTOR_LAYER_TO_POINTS:UILabel()
	return "CC: Selected Vector Layers - Center to points"
end

-- ***************************************************
-- Recurring values
-- ***************************************************

CC_CENTER_VECTOR_LAYER_TO_POINTS.file = {}

-- ***************************************************
-- The guts of this script
-- ***************************************************
--
function CC_CENTER_VECTOR_LAYER_TO_POINTS:OnGenericLayer( moho, layer )
end

function CC_CENTER_VECTOR_LAYER_TO_POINTS:OnVectorLayer( moho, layer )
	local prevLayer
	local mesh
	local pointCount
	local i
	local cx
	local cy
	local origin

	prevLayer  = moho.fLayer
	moho:SetSelLayer( layer )

	mesh       = moho:Mesh()
	pointCount = mesh:CountPoints()

	cx = 0.0
	cy = 0.0

	for i = 0, pointCount-1 do
		local point  = mesh:Point(i)
		
		cx = cx + point.fPos.x
		cy = cy + point.fPos.y
	end

	origin   = layer:Origin()
	origin.x = cx / pointCount
	origin.y = cy / pointCount

	layer:SetOrigin( origin )

	moho:SetSelLayer( prevLayer )
end

function CC_CENTER_VECTOR_LAYER_TO_POINTS:OnGroupLayer( moho, layer )
	local layerCount
	local i

	layerCount = layer:CountLayers()

	if ( layerCount == 0 ) then
		return
	end

	for i = 0, layerCount-1 do
		local childLayer 	   = layer:Layer(i)
		local childLayerType       = childLayer:LayerType()

		if ( childLayer:IsBoneType() ) then
			CC_CENTER_VECTOR_LAYER_TO_POINTS:OnGroupLayer( moho, moho:LayerAsGroup(childLayer) )
		else
			if ( childLayerType == MOHO.LT_UNKNOWN ) then
			        CC_CENTER_VECTOR_LAYER_TO_POINTS:OnGenericLayer( moho, moho:LayerAsGroup(childLayer) )
			elseif ( childLayerType == MOHO.LT_VECTOR ) then
			        CC_CENTER_VECTOR_LAYER_TO_POINTS:OnVectorLayer( moho, childLayer )
			elseif ( childLayerType == MOHO.LT_IMAGE ) then
			        CC_CENTER_VECTOR_LAYER_TO_POINTS:OnGenericLayer( moho, moho:LayerAsGroup(childLayer) )
			elseif ( childLayerType == MOHO.LT_GROUP) then
			        CC_CENTER_VECTOR_LAYER_TO_POINTS:OnGroupLayer( moho, moho:LayerAsGroup(childLayer) )
			elseif ( childLayerType == MOHO.LT_SWITCH) then
			        CC_CENTER_VECTOR_LAYER_TO_POINTS:OnGenericLayer( moho, moho:LayerAsGroup(childLayer) )
			elseif ( childLayerType == MOHO.LT_PARTICLE) then
			        CC_CENTER_VECTOR_LAYER_TO_POINTS:OnGenericLayer( moho, moho:LayerAsGroup(childLayer) )
			elseif ( childLayerType == MOHO.LT_NOTE) then
			        CC_CENTER_VECTOR_LAYER_TO_POINTS:OnGenericLayer( moho, moho:LayerAsGroup(childLayer) )
			elseif ( childLayerType == MOHO.LT_3D) then
			        CC_CENTER_VECTOR_LAYER_TO_POINTS:OnGenericLayer( moho, moho:LayerAsGroup(childLayer) )
			end
		end

	end
end

function CC_CENTER_VECTOR_LAYER_TO_POINTS:Run(moho)

	local curLayer = moho.layer

	if ( curLayer == nil ) then
		return
	end

	local curLayerType = curLayer:LayerType()

		if ( curLayer:IsBoneType() ) then
			CC_CENTER_VECTOR_LAYER_TO_POINTS:OnGroupLayer( moho, moho:LayerAsGroup(curLayer) )
		else
			if ( curLayerType == MOHO.LT_UNKNOWN ) then
			        CC_CENTER_VECTOR_LAYER_TO_POINTS:OnGenericLayer( moho, moho:LayerAsGroup(curLayer) )
			elseif ( curLayerType == MOHO.LT_VECTOR ) then
			        CC_CENTER_VECTOR_LAYER_TO_POINTS:OnVectorLayer( moho, curLayer )
			elseif ( curLayerType == MOHO.LT_IMAGE ) then
			        CC_CENTER_VECTOR_LAYER_TO_POINTS:OnGenericLayer( moho, moho:LayerAsGroup(curLayer) )
			elseif ( curLayerType == MOHO.LT_GROUP) then
			        CC_CENTER_VECTOR_LAYER_TO_POINTS:OnGroupLayer( moho, moho:LayerAsGroup(curLayer) )
			elseif ( curLayerType == MOHO.LT_SWITCH) then
			        CC_CENTER_VECTOR_LAYER_TO_POINTS:OnGenericLayer( moho, moho:LayerAsGroup(curLayer) )
			elseif ( curLayerType == MOHO.LT_PARTICLE) then
			        CC_CENTER_VECTOR_LAYER_TO_POINTS:OnGenericLayer( moho, moho:LayerAsGroup(curLayer) )
			elseif ( curLayerType == MOHO.LT_NOTE) then
			        CC_CENTER_VECTOR_LAYER_TO_POINTS:OnGenericLayer( moho, moho:LayerAsGroup(curLayer) )
			elseif ( curLayerType == MOHO.LT_3D) then
			        CC_CENTER_VECTOR_LAYER_TO_POINTS:OnGenericLayer( moho, moho:LayerAsGroup(curLayer) )
			end
		end
end
