-- Reassign one style with another

ScriptName = "msReassignStyles"
msReassignStyles = {}

function msReassignStyles:Name()
	return "Reassign styles ... "
end

function msReassignStyles:UILabel()
	return("Reassign styles ... ")
end

function msReassignStyles:Version()
	return "1.0"
end

function msReassignStyles:Description()
	return MOHO.Localize("/Scripts/Menu/MinimalScript/Description=Reassigns styles.")
end

function msReassignStyles:Creator()
	return "Mitchel Soltys"
end

msReassignStyles.searchString = ""
msReassignStyles.replacementString = ""

local msReassignStylesDialog = {}

function msReassignStylesDialog:new(moho)
	local self, l = msDialog:SimpleDialog("RenameLayers", self)
	self.moho = moho
	l:PushH(LM.GUI.ALIGN_CENTER)
	l:PushV()
	msDialog:AddText("Search Style:")
	msDialog:AddText("Replacement Style:")
	l:Pop()
	l:PushV()
	self.searchMenu = self:CreateDropDownMenu("Search Style:")
	self.replaceMenu = self:CreateDropDownMenu("Replacement Style:")
	l:Pop()
	return self
end

function msReassignStylesDialog:CreateDropDownMenu(title)
	local menu = LM.GUI.Menu(title)

	for i = 0, self.moho.document:CountStyles()-1 do
		menu:AddItem(self.moho.document:StyleByID(i).fName:Buffer(), 0, MOHO.MSG_BASE + i)
	end
	menu:SetChecked(MOHO.MSG_BASE, true)

	msDialog:MakePopup(menu)
	return menu
end

function msReassignStylesDialog:UpdateWidgets()
	self:SetCheckedState(self.searchMenu, msReassignStyles.searchString)
	self:SetCheckedState(self.replaceMenu, msReassignStyles.replacementString)
end

function msReassignStylesDialog:SetCheckedState(menu, string)
	menu:UncheckAll()
	if(string == "") then
		menu:SetChecked(MOHO.MSG_BASE, true)
	else
		menu:SetCheckedLabel(string, true)
	end
end


function msReassignStylesDialog:OnOK()
	msReassignStyles.searchString = self.searchMenu:FirstCheckedLabel()
	msReassignStyles.replacementString = self.replaceMenu:FirstCheckedLabel();
end

function msReassignStyles:GetStyleIDs(moho)
	self.idsFound = false
	local style = moho.document:Style(msReassignStyles.searchString)
	if(style == nil) then
		print("search style not found")
		return
	end

	self.searchStyleID = style.fUUID
	style = moho.document:Style(msReassignStyles.replacementString)
	if(style == nil) then
		print("replacement style not found")
		return
	end
	self.replacementStyleID = style.fUUID
	self.idsFound = true
end

function msReassignStyles:ProcessShapes(layer)
	if layer:LayerType() ~= MOHO.LT_VECTOR then
		return
	end

	local vectorLayer = self.moho:LayerAsVector(layer)
	local mesh = vectorLayer:Mesh()
	for i = 0, mesh:CountShapes()-1 do
		if(mesh:Shape(i).fInheritedStyleName:Buffer() == self.searchStyleID:Buffer()) then
			mesh:Shape(i).fInheritedStyleName = self.replacementStyleID
		end
	end
	self.moho.document:RelinkStyles(vectorLayer)
end

function msReassignStyles:ReplaceStyles()
	local count =0
	repeat
		local layer = self.moho.document:LayerByAbsoluteID(count)
		if layer then
			count = count + 1
			self:ProcessShapes(layer)
		end
	until not layer
end


-- **************************************************
-- The guts of this script
-- **************************************************
function msReassignStyles:Run(moho)
	self.moho = moho
	msDialog:Display(moho, msReassignStylesDialog)
	if msDialog.cancelled then
		return
	end	
	moho.document:SetDirty()
	moho.document:PrepUndo(moho.layer)
	self:GetStyleIDs(moho)
	if(self.idsFound)then
		self:ReplaceStyles()
	end
end
