-- Renames styles.
-- You can replace a search string (case sensitive) 
-- with a replacement string or prepend all styles with 
-- a replacement string and a space

ScriptName = "msStylesRename"
msStylesRename = {}

function msStylesRename:Name()
	return "Renames all styles ... "
end

function msStylesRename:UILabel()
	return("Rename styles ... ")
end

function msStylesRename:Version()
	return "1.0"
end

function msStylesRename:Description()
	return "Renames all styles based on search string and replacement string."
end

function msStylesRename:Creator()
	return "Mitchel Soltys"
end

msStylesRename.searchString = ""
msStylesRename.replacementString = ""
msStylesRename.renameType = nil

local msStylesRenameDialog = {}

function msStylesRenameDialog:new(moho)
	local self, l = msDialog:SimpleDialog("Rename Styles", self)

	self.moho = moho
	self.renameTypeMenu = msDialog:CreateDropDownMenu("Rename Type",{"Rename by String",
		"Prepend with replacement string and space"})
	self.searchString = msDialog:AddTextBox("Search String")
	self.replacementString = msDialog:AddTextBox("Replacement String")

	return self
end

function msStylesRenameDialog:UpdateWidgets()
	msDialog:SetMenuByLabel(self.renameTypeMenu,msStylesRename.renameType)
	self.searchString:SetValue(msStylesRename.searchString)
	self.replacementString:SetValue(msStylesRename.replacementString)
end


function msStylesRenameDialog:OnOK()
	msStylesRename.renameType = self.renameTypeMenu:FirstCheckedLabel()
	msStylesRename.searchString = self.searchString:Value()
	msStylesRename.replacementString = self.replacementString:Value();
end


function msStylesRename:ReplaceStyleName()
	local myString = self.moho.document:StyleByID(self.styleIndex).fName:Buffer()
	local newString, length = string.gsub(myString, self.searchString, self.replacementString)
	if(length > 0) then
		self.moho.document:StyleByID(self.styleIndex).fName:Set(newString)
	end
end

function msStylesRename:PrependStyleNameWithSpace()
	local newName = self.replacementString .. " " .. self.moho.document:StyleByID(self.styleIndex).fName:Buffer()
	self.moho.document:StyleByID(self.styleIndex).fName:Set(newName)
end

function msStylesRename:RenameStyleByType()
	if self.renameType == "Prepend with replacement string and space" then
		self:PrependStyleNameWithSpace()
	elseif self.renameType == "Rename by String" then
		self:ReplaceStyleName()
	end
end

-- **************************************************
-- The guts of this script
-- **************************************************
function msStylesRename:Run(moho)
	self.moho = moho
	msDialog:Display(moho, msStylesRenameDialog)
	if (msDialog.cancelled) then
		return
	end	
	
	moho.document:SetDirty()
	moho.document:PrepUndo(moho.layer)

	for i = 0, self.moho.document:CountStyles()-1 do
		self.styleIndex = i
		self:RenameStyleByType()
	end
end
