-- **************************************************
-- Provide Moho with the name of this script object
-- **************************************************

ScriptName = "Syn_NegativeKeys"

-- **************************************************
-- General information about this script
-- **************************************************

Syn_NegativeKeys = {}

function Syn_NegativeKeys:Name()
	return "Negative keys"
end

function Syn_NegativeKeys:Version()
	return "0.2"
end

function Syn_NegativeKeys:Description()
	return "Find any negative keyframes"
end

function Syn_NegativeKeys:Creator()
	return "(c)2019 J.Wesley Fowler (SynthSin75)"
end

function Syn_NegativeKeys:UILabel()
	return "SYN: Negative Keys"
end

-- **************************************************
-- The guts of this script
-- **************************************************

function Syn_NegativeKeys:Run(moho)
	
	moho.document:PrepUndo(moho.layer)
	moho.document:SetDirty()
	
	local doc = moho.document
	
	---[=[--find negative keyframes, channel, and layer
	local ch = MOHO.MohoLayerChannel:new_local()
	local count = 0
	local layer, name, once
	local msg, keys = "", {}
	repeat
		layer = doc:LayerByAbsoluteID(count)
		if (layer) then
			count = count+1
			lt = layer:LayerType()
			if (lt == 0) then
				lt = "UNKNOWN"
			elseif (lt == 1) then
				lt = "VECTOR"
			elseif (lt == 2) then
				lt = "IMAGE"
			elseif (lt == 3) then
				lt = "GROUP"
			elseif (lt == 4) then
				lt = "BONE"
			elseif (lt == 5) then
				lt = "SWITCH"
			elseif (lt == 6) then
				lt = "PARTICLE"
			elseif (lt == 7) then
				lt = "NOTE"
			elseif (lt == 8) then
				lt = "3D"
			elseif (lt == 9) then
				lt = "AUDIO"
			elseif (lt == 10) then
				lt = "PATCH"
			else
				lt = "TEXT"
			end
			local chanCnt = layer:CountChannels()-1
			for i=0, chanCnt do
				layer:GetChannelInfo(i, ch)
				--print(ch.name:Buffer(), "    ", ch.subChannelCount)
				if (ch.subChannelCount > 0) then
					for j=0, ch.subChannelCount-1 do
						local chan = layer:Channel(i, j, moho.document)
						local type = chan:ChannelType()
						if (type == 0) then
							type = "UNKNOWN"
						elseif (type == 1) then
							type = "VAL"
						elseif (type == 2) then
							type = "VEC2"
						elseif (type == 3) then
							type = "COLOR"
						elseif (type == 4) then
							type = "BOOL"
						elseif (type == 5) then
							type = "STRING"
						else
							type = "VEC3"
						end
						if (chan) and (chan:CountKeys() > 1) then
							for k=chan:CountKeys()-1, 0, -1 do
								local when = chan:GetKeyWhen(k)
								if (when < 0) and (when > -1000000) then
									name = layer:Name()
									--print(when, "    ", ch.name:Buffer(), "    ", type, "    ", name)
									if (once ~= i) then
										once = i
										--print("Deleted frame "..when.." in the "..ch.name:Buffer().." channel, on the "..lt.." layer named \""..name.."\"")
										msg = msg.."Frame "..when.." in the "..ch.name:Buffer().." channel, on the "..lt.." layer named \""..name.."\"               \n"
									end
									--chan:DeleteKey(when)
									table.insert(keys, {chan, when})
								end
							end
						end
					end
				end
			end
		end
	until (not layer)
	if (msg == "") then
		LM.GUI.Alert(LM.GUI.ALERT_INFO, "There were no keyframes found in the negative timeline.", nil, nil, "OK")
	else
		local button = LM.GUI.Alert(LM.GUI.ALERT_QUESTION, "These keyframes were found in the negative timeline:", msg.."\n", "Do you want to DELETE these now?", "YES", "NO")
		if (button == 0) then
			for i,v in ipairs(keys) do
				v[1]:DeleteKey(v[2])
			end
		end
	end
	--]=]
end
