-- **************************************************
-- Provide Moho with the name of this script object
-- **************************************************

ScriptName = "SZ_ImagesRenderQuality"

-- **************************************************
-- General information about this script
-- **************************************************

SZ_ImagesRenderQuality = {}

function SZ_ImagesRenderQuality:Name()
    return self:Localize("Name")
end

function SZ_ImagesRenderQuality:Version()
    return "1.0"
end

function SZ_ImagesRenderQuality:UILabel()
    return self:Localize("Name")
end

function SZ_ImagesRenderQuality:Creator()
    return "Stan from 2danimator.ru"
end

function SZ_ImagesRenderQuality:Description()
    return self:Localize("Description")
end

-- **************************************************
-- Recurring values
-- **************************************************

SZ_ImagesRenderQuality.modifySampling = false
SZ_ImagesRenderQuality.nearestNeighbor = false
SZ_ImagesRenderQuality.modifyQuality = true
SZ_ImagesRenderQuality.highQuality = true

SZ_ImagesRenderQuality.displayMessage = true

-- **************************************************
-- Is Enabled
-- **************************************************

function SZ_ImagesRenderQuality:IsEnabled(moho)
    return true
end

-- **************************************************
-- Dialog
-- **************************************************

local SZ_ImagesRenderQualityDialog = {}

function SZ_ImagesRenderQualityDialog:new(moho)
    local d = LM.GUI.SimpleDialog(SZ_ImagesRenderQuality:Localize("Name"), SZ_ImagesRenderQualityDialog)
    local l = d:GetLayout()
    
    d.moho = moho
    
    l:PushV()
        l:AddChild(LM.GUI.StaticText(SZ_ImagesRenderQuality:Localize("GUIDescription")), LM.GUI.ALIGN_LEFT)
        l:AddPadding(20)
        l:AddChild(LM.GUI.StaticText(SZ_ImagesRenderQuality:Localize("Sampling")), LM.GUI.ALIGN_LEFT)
        l:PushH()
            l:AddPadding(30)
            d.samplingOn = LM.GUI.RadioButton(SZ_ImagesRenderQuality:Localize("TurnOn"))
            l:AddChild(d.samplingOn, LM.GUI.ALIGN_LEFT)
            d.samplingOff = LM.GUI.RadioButton(SZ_ImagesRenderQuality:Localize("TurnOff"))
            l:AddChild(d.samplingOff, LM.GUI.ALIGN_LEFT)
            d.samplingLeave = LM.GUI.RadioButton(SZ_ImagesRenderQuality:Localize("LeaveAsIs"))
            l:AddChild(d.samplingLeave, LM.GUI.ALIGN_LEFT)
        l:Pop()
        l:AddPadding(20)
        l:AddChild(LM.GUI.StaticText(SZ_ImagesRenderQuality:Localize("Quality")), LM.GUI.ALIGN_LEFT)
        l:PushH()
            l:AddPadding(30)
            d.qualityOn = LM.GUI.RadioButton(SZ_ImagesRenderQuality:Localize("TurnOn"))
            l:AddChild(d.qualityOn, LM.GUI.ALIGN_LEFT)
            d.qualityOff = LM.GUI.RadioButton(SZ_ImagesRenderQuality:Localize("TurnOff"))
            l:AddChild(d.qualityOff, LM.GUI.ALIGN_LEFT)
            d.qualityLeave = LM.GUI.RadioButton(SZ_ImagesRenderQuality:Localize("LeaveAsIs"))
            l:AddChild(d.qualityLeave, LM.GUI.ALIGN_LEFT)
        l:Pop()
        l:AddPadding(10)
    l:Pop()
    
    return d
end

function SZ_ImagesRenderQualityDialog:UpdateWidgets()
    if SZ_ImagesRenderQuality.modifySampling then
        if SZ_ImagesRenderQuality.nearestNeighbor then
            self.samplingOn:SetValue(true)
        else
            self.samplingOff:SetValue(true)		
        end
    else
        self.samplingLeave:SetValue(true)
    end
        
    if SZ_ImagesRenderQuality.modifyQuality then
        if SZ_ImagesRenderQuality.highQuality then
            self.qualityOn:SetValue(true)
        else
            self.qualityOff:SetValue(true)		
        end
    else
        self.qualityLeave:SetValue(true)
    end
end

function SZ_ImagesRenderQualityDialog:OnOK()
    SZ_ImagesRenderQuality.modifySampling = not self.samplingLeave:Value()
    SZ_ImagesRenderQuality.nearestNeighbor = self.samplingOn:Value()
    SZ_ImagesRenderQuality.modifyQuality = not self.qualityLeave:Value()
    SZ_ImagesRenderQuality.highQuality = self.qualityOn:Value()
end

-- **************************************************
-- The guts of this script
-- **************************************************

function SZ_ImagesRenderQuality:Run(moho)
    local dlog = SZ_ImagesRenderQualityDialog:new(moho)
    if (dlog:DoModal() == LM.GUI.MSG_CANCEL) then
        return
    end

    moho.document:PrepMultiUndo(true)
    moho.document:SetDirty()
    
    local samplingMode = self.nearestNeighbor and MOHO.SM_NEAREST or MOHO.SM_BILINEAR
    local qualityLevel = self.highQuality and 2 or 1
    
    local numberOfAffectedLayers = 0
    
    local count = 0
    repeat
        local layer = moho.document:LayerByAbsoluteID(count)
        if layer then
            count = count + 1
            local imageLayer = moho:LayerAsImage(layer)
            if imageLayer then
                local modified = false -- a flag to indicate if the numberOfAffectedLayers should be incremented
                
                if self.modifySampling then
                    imageLayer:SetSamplingMode(samplingMode)
                    modified = true
                end
                
                if self.modifyQuality then
                    imageLayer:SetQualityLevel(qualityLevel)
                    modified = true
                end
                
                if modified then
                    numberOfAffectedLayers = numberOfAffectedLayers + 1
                end
            end
        end
    until not layer
    
    if self.displayMessage then
        LM.GUI.Alert(LM.GUI.ALERT_INFO, self:Localize("Message1"), self:Localize("Message2")..numberOfAffectedLayers, nil, "OK", nil, nil)
    end
end

function SZ_ImagesRenderQuality:Localize(text)
    local fileWord = MOHO.Localize("/Menus/File/File=File")
    
    local phrase = {}
    
    phrase["Name"] = "Images Render Quality"
    phrase["Description"] = "Modifies all image layers' render quality settings"
    phrase["GUIDescription"] = "WARNING! This will modify all image layers in the project!"
    phrase["Sampling"] = "Nearest neighbor sampling:"
    phrase["Quality"] = "Higher quality rendering:"
    phrase["TurnOn"] = "Turn ON"
    phrase["TurnOff"] = "Turn OFF"
    phrase["LeaveAsIs"] = "Leave as is"
    phrase["Message1"] = "Operation complete"
    phrase["Message2"] = "Number of layers changed: "
    
    if fileWord == "Файл" then
        phrase["Name"] = "Качество рендера растра"
        phrase["Description"] = "Изменяет настройки качества рендера для всех растровых слоев"
        phrase["GUIDescription"] = "ВНИМАНИЕ! Будут изменены настройки всех растровых слоев!"
        phrase["Sampling"] = "Не сглаживать:"
        phrase["Quality"] = "Рендер высокого качества:"
        phrase["TurnOn"] = "Включить"
        phrase["TurnOff"] = "Выключить"
        phrase["LeaveAsIs"] = "Оставить как есть"
        phrase["Message1"] = "Операция завершена"
        phrase["Message2"] = "Изменено слоев: "
    end
    
    return phrase[text];
end