-- **************************************************
-- Provide Moho with the name of this script object
-- **************************************************

ScriptName = "SZ_RemoveAllActionsFromLayer"

-- **************************************************
-- General information about this script
-- **************************************************

SZ_RemoveAllActionsFromLayer = {}

function SZ_RemoveAllActionsFromLayer:Name()
	return "Remove all actions from layer"
end

function SZ_RemoveAllActionsFromLayer:Version()
	return "1.0"
end

function SZ_RemoveAllActionsFromLayer:Description()
	return "Removes all actions from the selected layer(s)"
end

function SZ_RemoveAllActionsFromLayer:Creator()
	return "Stan from 2danimator.ru"
end

function SZ_RemoveAllActionsFromLayer:UILabel()
	return "Remove all actions from layer(s)"
end


-- **************************************************
-- Recurring values
-- **************************************************

-- **************************************************
-- The guts of this script
-- **************************************************

function SZ_RemoveAllActionsFromLayer:IsEnabled(moho)
	return true
end

function SZ_RemoveAllActionsFromLayer:IsRelevant(moho)
	return true
end

function SZ_RemoveAllActionsFromLayer:Run(moho)
	if  LM.GUI.Alert(LM.GUI.ALERT_INFO, "This will delete ALL actions from the current layer(s). Proceed?", nil, nil, "Cancel", "OK", nil) == 0 then return end
	
	local ScanDoc, ScanGroup, Clear
	local count = 0
	local showProgress = true
	
	Clear = function(layer)
		local actionsToRemove = {}
		local actions = layer:CountActions()
		local actionName
		if actions == 0 then return end
		for a=0, actions-1 do
			actionName = layer:ActionName(a)
			table.insert(actionsToRemove, actionName)
		end
		for _,name in ipairs(actionsToRemove) do
			layer:DeleteAction(name)
		end
		count = count + actions
		if showProgress then print(actions.." actions deleted from layer '"..layer:Name().."'") end
	end
	
	ScanGroup = function(group)
		local groupLayer = moho:LayerAsGroup(group)
		local layer
		for i=0, groupLayer:CountLayers()-1 do
			layer = group:Layer(i)
			if layer:CountActions()>0 then
				Clear(layer)
			end
			if layer:IsGroupType() then
				ScanGroup(layer) -- recursion
			end
		end
	end 

	ScanDoc = function()
		for i = 0, moho.document:CountSelectedLayers()-1 do
			local layer = moho.document:GetSelectedLayer(i)
			if layer:CountActions()>0 then
				Clear(layer)
			end
			if layer:IsGroupType() then
				ScanGroup(layer)
			end
		end
	end
	
	moho.document:PrepMultiUndo()
	moho.document:SetDirty()
	ScanDoc()
	
	if showProgress then
		print("    >>> Total: "..count)
		print("___________________")
	end
end
