-- **************************************************
-- Provide Moho with the name of this script object
-- **************************************************

ScriptName = "SZ_RemoveEmptyActions"

-- **************************************************
-- General information about this script
-- **************************************************

SZ_RemoveEmptyActions = {}

function SZ_RemoveEmptyActions:Name()
	return "Remove empty actions"
end

function SZ_RemoveEmptyActions:Version()
	return "2.0"
end

function SZ_RemoveEmptyActions:Description()
	return "Removes all empty actions from the project"
end

function SZ_RemoveEmptyActions:Creator()
	return "Stan from 2danimator.ru"
end

function SZ_RemoveEmptyActions:UILabel()
	return "Remove empty actions"
end


-- **************************************************
-- Recurring values
-- **************************************************

-- **************************************************
-- The guts of this script
-- **************************************************

function SZ_RemoveEmptyActions:IsEnabled(moho)
	return true
end

function SZ_RemoveEmptyActions:IsRelevant(moho)
	return true
end

function SZ_RemoveEmptyActions:Run(moho)
	local ScanDoc, ScanGroup, Clear
	local count = 0
	local showProgress = true
	
	Clear = function(layer)
		local actionsToRemove = {}
		local actionName
		for a=0, layer:CountActions()-1 do
			actionName = layer:ActionName(a)
			if layer:ActionDuration(actionName) < 1 then
				table.insert(actionsToRemove, actionName)
			end
		end
		if #actionsToRemove > 0 then 
			for _,name in ipairs(actionsToRemove) do
				count = count + 1
				layer:DeleteAction(name)
			end
			if showProgress then print (#actionsToRemove.." actions removed from layer '"..layer:Name().."'") end
		end
	end
	
	ScanGroup = function(group)
		local groupLayer = moho:LayerAsGroup(group)
		local layer
		for i=0, groupLayer:CountLayers()-1 do
			layer = group:Layer(i)
			if layer:CountActions()>0 then
				Clear(layer)
			end
			if layer:IsGroupType() then
				ScanGroup(layer) -- recursion
			end
		end
	end 

	ScanDoc = function()
		for l = 0, moho.document:CountLayers()-1 do
			local layer = moho.document:Layer(l)
			if layer:CountActions()>0 then
				Clear(layer)
			end
			if layer:IsGroupType() then
				ScanGroup(layer)
			end
		end
	end
	
	moho.document:PrepMultiUndo()
	moho.document:SetDirty()
	ScanDoc()
	
	if showProgress then
		print("    >>> Total: "..count)
		print("___________________")
	end
end
