-- **************************************************
-- Provide Moho with the name of this script object
-- **************************************************

ScriptName = "SZ_RenameSmartBone"

-- **************************************************
-- General information about this script
-- **************************************************

SZ_RenameSmartBone = {}

function SZ_RenameSmartBone:Name()
    return self:Localize('UILabel')
end

function SZ_RenameSmartBone:Version()
    return "1.0"
end

function SZ_RenameSmartBone:Description()
    return self:Localize("description")
end

function SZ_RenameSmartBone:Creator()
    return "Stan from 2danimator.ru"
end

function SZ_RenameSmartBone:UILabel()
    return self:Localize('UILabel')
end


-- **************************************************
-- Recurring values
-- **************************************************
SZ_RenameSmartBone.newName = ""

-- **************************************************
-- The guts of this script
-- **************************************************

function SZ_RenameSmartBone:IsEnabled(moho)
    if self:GetAllWhatNeeded(moho, moho.layer) then
        return true
    end
    return false
end

function SZ_RenameSmartBone:IsRelevant(moho)
    return true
end


-- *** Dialog: ***
local SZ_RenameSmartBoneDialog = {} 

function SZ_RenameSmartBoneDialog:new(moho, name)
    local d = LM.GUI.SimpleDialog(SZ_RenameSmartBone:Localize('UILabel') .. ' v' .. SZ_RenameSmartBone:Version(), SZ_RenameSmartBoneDialog)
    local l = d:GetLayout()
    l:AddChild(LM.GUI.StaticText(SZ_RenameSmartBone:Localize('enterNewName') .. name .."':"), LM.GUI.ALIGN_LEFT)
    d.textInput = LM.GUI.TextControl(400, name)
    l:AddChild(d.textInput, LM.GUI.ALIGN_LEFT)	
    return d
end

function SZ_RenameSmartBoneDialog:UpdateWidgets()
    
end

function SZ_RenameSmartBoneDialog:OnValidate()
    local b = true
    if self.textInput:Value() == "" then
        b = false
    end
    return b
end

function SZ_RenameSmartBoneDialog:OnOK()
    SZ_RenameSmartBone.newName = self.textInput:Value()
end


function SZ_RenameSmartBone:Run(moho)
    local layer, bone, name = self:GetAllWhatNeeded(moho, moho.layer)
    local dlog = SZ_RenameSmartBoneDialog:new(moho, name)
    if (dlog:DoModal() == LM.GUI.MSG_CANCEL) then
        return
    end
    
    moho.document:PrepMultiUndo()
    moho.document:SetDirty()
    
    bone:SetName(self.newName)
    layer:RenameAction(name, self.newName)
    layer:RenameAction(name..' 2', self.newName..' 2')
end


function SZ_RenameSmartBone:GetAllWhatNeeded(moho, layer)
    local boneLayer, skeleton, id, bone, name, parent
    boneLayer = moho:LayerAsBone(layer)
    if boneLayer then
        skeleton = layer:Skeleton()
        if skeleton then
            id = skeleton:SelectedBoneID()
        end
    end
    if layer and skeleton and id > -1 then
        bone = skeleton:Bone(id)
        name = bone:Name()
        return boneLayer, bone, name
    else
        parent = layer:Parent()
        if not parent then
            return false
        else
            return SZ_RenameSmartBone:GetAllWhatNeeded(moho, parent) -- recursion
        end
    end
end

function SZ_RenameSmartBone:Localize(text)
    local phrase = {}

    phrase['description'] = "Renames the selected bone and all corresponding actions"
    phrase['UILabel'] = "Rename Smart Bone"
    phrase['enterNewName'] = "Enter a new name for '"

    local fileWord = MOHO.Localize("/Menus/File/File=File")
    if fileWord == "Файл" then
        phrase['description'] = "Переименовывает смарт кость и ее действия"
        phrase['UILabel'] = "Переименовать смарт кость"
        phrase['enterNewName'] = "Введите новое имя для кости '"
    end

    return phrase[text]
end