-- AE_meshinstance version 2.0 --
-- AE_utilities version 1.34 --

function LayerScript(moho)
    --if moho.frame == 0 then return true end
	local ownMesh = moho:Mesh()
	if not ownMesh then return end
	local ownLayer = moho.layer
	local ownName = ownLayer:Name()
	local srcLayer = AE_GetInstSrcLayer(moho, ownLayer)
	

	
	if srcLayer then 
		local srcMeshLayer = moho:LayerAsVector(srcLayer)
		if not srcMeshLayer then return end
		local srcMesh = srcMeshLayer:Mesh()
		if not srcMesh then return end
		if ownMesh:CountPoints() ~= srcMesh:CountPoints() then return end
		for p=0, ownMesh:CountPoints()-1 do
			ownMesh:Point(p).fPos = srcMesh:Point(p).fPos
		end

		--local batFile = io.open("D:\\temp\\log.txt", "a")
		--io.output(batFile)		
		
		for subID, chID, channel, chInfo in AE_Utilities:IterateAllChannels(moho, moho.layer) do			
			if not chInfo.selectionBased then
				if chInfo.channelID == CHANNEL_CURVE then				
					local derChannel = moho:ChannelAsAnimVal(channel)
					if not derChannel then return end
					local srcChInfo = MOHO.MohoLayerChannel:new_local()	
					srcLayer:GetChannelInfo(chID, srcChInfo)
					local srcChannel = srcLayer:Channel(chID, subID, moho.document)
					if not srcChannel then return end
					srcDerChannel = moho:ChannelAsAnimVal(srcChannel)	
					if not srcDerChannel then return end
					local val = srcDerChannel:GetValue(moho.frame)
					local infl = 0
					if moho.document:CurrentDocAction() == '' then
						infl = AE_Utilities:SumActionInfluences(moho, moho.frame, srcDerChannel, srcLayer)
					end
					derChannel.value = (val + infl)
				
				end
			end
		end
		--io.close(batFile)
	--[[
	elseif AE_Utilities.constructionTime == true then 
		for i, nextLayer in AE_Utilities:IterateAllLayers(moho) do
			if nextLayer:Name() == ownName .. ".dup" or AE_GetInstSrcLayer(moho, nextLayer) == ownLayer then
				nextLayer:RunLayerScript()
				nextLayer:UpdateCurFrame()
			end
		end
	end
	--]]
	end
end

function AE_GetInstSrcLayer(moho, childLayer)
	local srcLayer = nil
	local srcKeyName = "AE_MeshinstSrc"
	local scriptInfo = childLayer:ScriptData()
	if scriptInfo:HasKey(srcKeyName) then
		local uuid = scriptInfo:GetString(srcKeyName)
		for i, nextLayer in AE_Utilities:IterateAllLayers(moho) do
			if nextLayer:UUID() == uuid then 
				srcLayer = nextLayer
				return srcLayer
			end
		end
	end	
	if childLayer:Name():sub(-4) == ".dup" then 
		local srcName = childLayer:Name():sub(1, -5)		
		for i, nextLayer in AE_Utilities:IterateAllLayers(moho) do
			if nextLayer:Name() == srcName then 
				srcLayer = nextLayer
				return srcLayer
			end
		end 
	end
	return srcLayer
end

if not AE_Utilities then 
	AE_Utilities = {}
	
	function AE_Utilities:IterateAllLayers(moho, from, to)
		local iterateLayersFn = function(condition, counter)
			counter = counter + 1
			if not condition or counter <= condition then
				local layer = moho.document:LayerByAbsoluteID(counter)
				if layer then					
					return counter, layer
				end
			end
		end
		return iterateLayersFn, to, (from and from-1 or -1) 
	end
	
	function AE_Utilities:IterateAllChannels(moho, layer)
		local chInfo = MOHO.MohoLayerChannel:new_local()
		local channelCounter = 0
		local maxChannel = layer:CountChannels()-6
		layer:GetChannelInfo(0, chInfo)
		
		
		local iterateFn = function(condition, subCounter)
			subCounter = subCounter + 1
			if subCounter >= chInfo.subChannelCount then			
				repeat   
					channelCounter = channelCounter + 1
					if channelCounter <= maxChannel then
						layer:GetChannelInfo(channelCounter, chInfo)
						subCounter = 0
					end
				until channelCounter > maxChannel or chInfo.subChannelCount > 0			
			end
			if channelCounter <= maxChannel and not chInfo.selectionBased then
				local channel = layer:Channel(channelCounter, subCounter, moho.document)				
				return subCounter, channelCounter, channel, chInfo
			end
		end
		
		return iterateFn, nil, -1

	end
	
	function AE_Utilities:FindControllingSkeleton(moho, layer)
		local boneLayer = nil	
		if layer:LayerType() == MOHO.LT_BONE then
			boneLayer = moho:LayerAsBone(layer)
			return boneLayer:Skeleton(), boneLayer
		end
		local parent = layer

		while parent:Parent() do
			parent = parent:Parent()
			if parent:LayerType() == MOHO.LT_BONE then
				local boneLayer = moho:LayerAsBone(parent)
				if boneLayer and boneLayer:Skeleton():CountBones()>0 then
					return boneLayer:Skeleton(), boneLayer
				end
			end
		end
		if boneLayer then return boneLayer:Skeleton(), boneLayer end
		return nil
	end
	
	function AE_Utilities:SumActionInfluences(moho, frame, derivedChannel, layer)
	   local sum = 0
	   local defaultValue = derivedChannel:GetValue(0)
	   local parentSceleton = self:FindControllingSkeleton(moho, layer)
	   if not parentSceleton then return 0 end
	   
	   for actID = 0, derivedChannel:CountActions()-1 do
		   local actName = derivedChannel:ActionName(actID)
		   local actChannel = moho:ChannelAsAnimVal(derivedChannel:Action(actID))
		   local boneName = actName
		   if string.sub(boneName, string.len(boneName)-1) == " 2" then boneName = string.sub(boneName, 1, string.len(boneName)-2) end
		   local smartBone = parentSceleton:BoneByName(boneName)
		   if smartBone and actName ~= layer:CurrentAction() then
			  local boneTrack = smartBone.fAnimAngle:ActionByName(actName)
			  if boneTrack then
				local curSmartboneValue = smartBone.fAnimAngle:GetValue(frame) -- bad for nested smartbones
				curSmartboneValue = smartBone.fAngle -- better for nested smartbones
				local smartBoneFrame, smartBoneSubFrame = self:FindSmartBoneFrame(curSmartboneValue, moho:ChannelAsAnimVal(boneTrack))
				if(smartBoneFrame>0 or smartBoneSubFrame ~= smartBoneFrame) then
				  local nextVal = actChannel:GetValue(smartBoneFrame) - defaultValue
				  if smartBoneSubFrame == 0 and smartBoneSubFrame ~= smartBoneFrame then
					nextVal = (actChannel:GetValue(1) - defaultValue)*smartBoneSubFrame  
				  end
				  sum = sum + nextVal 
				end      
			  end
		   end
	   end
	   return sum
	end

	function AE_Utilities:FindSmartBoneFrame(angle, smartBoneTrack, ignoreZeroFrame)
	  --ignoreZeroFrame and startFrame added for KuzmaProduction; Remove if work incorrect

	  local foundFrame = -1
	  local foundSubFrame = -1
	  local defAngle = smartBoneTrack:GetValue(0)
	  if not ignoreZeroFrame and defAngle == angle then 
		return 0,0
	  end
	  local startFrame = 1
	  if smartBoneTrack:Duration()>1 then startFrame = 2 end
	  for f=startFrame, smartBoneTrack:Duration() do
		local curVal = smartBoneTrack:GetValue(f)
		local preVal = smartBoneTrack:GetValue(f-1)
		if ((curVal-angle)*(preVal-angle)) <= 0 then
		   foundFrame = f-1
		   foundSubFrame = f-1+(angle-preVal)/(curVal-preVal)
		   if foundSubFrame == f then foundFrame = f end
			--print("between ", preVal*180/math.pi, " and ", curVal*180/math.pi)
		end
		if f==smartBoneTrack:Duration() and foundFrame == -1 and math.abs(curVal-angle)<math.abs(preVal-angle) then 
		  foundFrame = f 
		  foundSubFrame = f
		end 
	  end
	  if smartBoneTrack:Duration() == 1 then return foundFrame, foundSubFrame end
	  return foundFrame, foundSubFrame
	end
	
	AE_Utilities.constructionTime = false
	CHANNEL_CURVE = 10032
end


