-- **************************************************
-- LK_Origin_Bone
-- Animate origin point of a layer by animating a bone called "Origin"
-- **************************************************

function LayerScript(moho)
	-- * Only run on bone/switch/fbf layer:
	local skel = moho:Skeleton()
	if (skel == nil) then
		print("No skeleton found in layer")
		return
	end
	local originBone
	local originTag = "origin" -- * Don't use FO_Utilities in layerscript.
	-- * Find all control and switch bones and put them in tables:
	for i=0, skel:CountBones()-1 do
		local bone = skel:Bone(i)
		local boneName = string.lower(bone:Name())
		if string.match (boneName, originTag) then
			originBone = bone
			if originBone.fParent ~= -1 then
				originBone.fParent = -1
			end
			local pos = originBone.fPos
			moho.layer:SetOrigin(pos)
			return
		end
	end
	if originBone == nil then
		originBone = skel:AddBone(0)
		originBone.fLength = 0
		originBone.fStrength = 0
		originBone.fAnimPos:SetValue(0, moho.layer:Origin())
		originBone:SetName("Origin")
		originBone:SetTags(7) -- * 7 = Tan
	end
end