-- **************************************************
-- LK_Origin_Switch
-- Origin of a switchlayer will be set to its current active layer's origin.
-- **************************************************

function LayerScript(moho)
	local originTag = "origin"
	-- * Only run on switch/fbf layer:
	local switchLayer
	if moho.layer:LayerType() == MOHO.LT_SWITCH then
		switchLayer = moho:LayerAsSwitch(moho.layer)
	else
		-- * Go to child layers and look for switch with a certain name?
		for i = moho.layer:CountLayers()-1, 0, -1 do
			local layer = moho.layer:Layer(i)
			local tags = layer:UserTags()
			if layer:LayerType() == MOHO.LT_SWITCH and string.match(string.lower(tags), "origin") then
				switchLayer = layer
				break
			end
		end
	end
	if switchLayer == nil then
		print("LK_Origin_Switch should be embedded on a switchlayer or a layer with a child-switchlayer tagged 'Origin'.")
		return
	end
	local activeChildName = switchLayer:GetValue(moho.frame)
	for i = switchLayer:CountLayers()-1, 0, -1 do
		local layer = switchLayer:Layer(i)
		if layer:Name() == activeChildName then
			local pos = layer:Origin()
			moho.layer:SetOrigin(pos)
		end
	end
end