--[[
    This script is for embedding into bone layers. It finds any bones named "Wheel",
    and adjusts the angle of those bones to their parent's X-position, according to
    their length.
    
    Этот скрипт предназначен для внедрения в костяной слой (в свойствах слоя опция 
    Embedded script file). Скрипт находит кости с именем "Wheel", и вращает их, в 
    зависимости от родительской координаты по оси Х. Скорость вращения зависит от длины кости-колеса.
    
    Author: Stan (2danimator.ru, mohoscripting.com)
    Version: 2.22 (Sep 25 2019)
]]

function LayerScript(moho)
    if (moho.frame == 0) then
        return
    end
    local skel = moho:Skeleton()
    if (skel == nil) then
        print("No skeleton found in layer:", moho.layer:Name())
        return
    end
    local matrix = LM.Matrix:new_local()
    moho.layer:GetFullTransform(moho.frame, matrix, nil)
    for i = 0, skel:CountBones() - 1 do
        local bone = skel:Bone(i)
        local boneName = bone:Name()
        if (string.sub(boneName, 1, 5) == "Wheel") then
            local parent_id = bone.fParent
            if parent_id < 0 then
                print('Bone "' .. boneName .. '" does not have any parent bone!')
            else
                local origin = LM.Vector2:new_local()
                local tip = LM.Vector2:new_local()
                origin:Set(0, 0)
                bone.fMovedMatrix:Transform(origin)
                matrix:Transform(origin)
                tip:Set(0, 0.1)
                bone.fMovedMatrix:Transform(tip)
                matrix:Transform(tip)
                local bone_position = skel:Bone(parent_id).fPos.x - bone.fPos.x
                local angle = 0 - (bone_position * (1/bone.fLength))
                local parent = skel:Bone(parent_id)
                if parent.fFlipH.value then
                    angle = 0 - angle
                end
                bone.fAngle = angle
            end
        end
    end
    skel:UpdateBoneMatrix()
end