-- **************************************************
-- Provide Moho with the name of this script object
-- **************************************************

ScriptName = "LK_CutToNewLayer"

-- **************************************************
-- General information about this script
-- **************************************************

LK_CutToNewLayer = {}

function LK_CutToNewLayer:Name()
	return "Cut to new Layer"
end

function LK_CutToNewLayer:Version()
	return "0.2"
end

function LK_CutToNewLayer:Description()
	return "Cuts selected mesh and pastes it into a new Layer."
end

function LK_CutToNewLayer:Creator()
	return "Lukas Krepel, Breinmonster"
end

function LK_CutToNewLayer:UILabel()
	return "Cut mesh and paste to new Layer."
end

function LK_CutToNewLayer:ColorizeIcon()
	return true
end

-- **************************************************
-- The guts of this script
-- **************************************************

function LK_CutToNewLayer:IsEnabled(moho)
	if (moho:CountSelectedPoints() > 1) then
		return true
	end
	if (moho.layer:CurrentAction() ~= "") then
		return false -- * Creating new objects in the middle of an action can lead to unexpected results
	end
	return false
end

function LK_CutToNewLayer:IsRelevant(moho)
	if MohoMode ~= nil then
		if not MohoMode.rigging then
			return false
		end
	end
	local mesh = moho:Mesh()
	if (mesh == nil) then
		return false
	end
	return true
end

function LK_CutToNewLayer:Run(moho)
	-- * Prep undo:
	moho.document:PrepMultiUndo()
	moho.document:SetDirty()
	-- * Copy selected points from original layer to clipboard:
	local originalLayer = moho.layer
	local mesh = moho:Mesh()
	moho:Copy(mesh)
	-- * Create new layer:
	moho:CreateNewLayer(0)
	local newLayer = moho.layer
	newLayer:SetName(originalLayer:Name().." copy")
	-- * Paste points from clipboard to new layer:
	moho:Paste()
	-- * Select original layer and delete selected points:
	moho:SetSelLayer(originalLayer)
	mesh = moho:Mesh()
	local selList = MOHO.SelectedPointList(mesh)
	for i = 1, #selList do
		local point = selList[i]
		local pointID = mesh:PointID(point)
		if pointID ~= -1 then
			mesh:DeletePoint(pointID)
		end
	end
	-- * Select new layer:
	moho:SetSelLayer(newLayer)
end