-- **************************************************
-- Provide Moho with the name of this script object
-- **************************************************

ScriptName = "LK_LayerVisibility"

-- **************************************************
-- General information about this script
-- **************************************************

LK_LayerVisibility = {}

function LK_LayerVisibility:ColorizeIcon()
	return true
end

function LK_LayerVisibility:Name()
	return "Toggle Layer Visibility"
end

function LK_LayerVisibility:Version()
	return "2.0"
end

function LK_LayerVisibility:Description()
	return ("Toggle the visibility of all selected layers.")
end

function LK_LayerVisibility:Creator()
	return "Lukas Krepel"
end

function LK_LayerVisibility:UILabel()
	return("Toggle Layer Visibility")
end

function LK_LayerVisibility:IsRelevant()
	if MohoMode ~= nil then
		if not (MohoMode.animation or MohoMode.raymond) then
			return false
		end
	end
	return true
end

-- **************************************************
-- The guts of this script
-- **************************************************

function LK_LayerVisibility:Run(moho)
	moho.document:PrepMultiUndo()
	moho.document:SetDirty()
	--
	local anySelectedLayerVisible = false -- * Because we want to set all selected layers to the same value.
	for i = 0, moho.document:CountSelectedLayers() - 1 do
		local layer = moho.document:GetSelectedLayer(i)
		local frame = layer:TotalTimingOffset() + moho.frame
		local channel = layer.fVisibility
		if channel:GetValue(frame) == true then
			anySelectedLayerVisible = true
			break
		end
	end
	for i = 0, moho.document:CountSelectedLayers() - 1 do
		local layer = moho.document:GetSelectedLayer(i)
		local frame = layer:TotalTimingOffset() + moho.frame
		local channel = layer.fVisibility
		if anySelectedLayerVisible then
			if channel:GetValue(frame) == anySelectedLayerVisible then
				-- * Remove key at frame 1 in specific case:
				if channel:CountKeys() > 2 and channel:GetKeyWhen(2) == frame and channel:GetValue(1) == false then
					channel:DeleteKey(1)
				end
				-- * Toggle current frame:
				channel:SetValue(frame, false)
			end
		else
			if channel:GetValue(frame) == anySelectedLayerVisible then
				-- * Add key frame 1 in specific case:
				if channel:GetKeyWhen(1) == frame then
					channel:SetValue(1, false)
				end
				-- * Toggle current frame:
				channel:SetValue(frame, true)
			end
		end
		moho:NewKeyframe(channel)
		local interp = MOHO.InterpSetting:new_local()
		channel:GetKeyInterp(frame, interp)
		interp.interpMode = 3 -- * 3 = INTERP_STEP
		if channel:GetValue(frame) then
			interp.tags = 4 -- * 4 = Green
		else
			interp.tags = 1 -- * 1 = Red
		end
		channel:SetKeyInterp(frame, interp)
	end
	FO_Utilities:StepBools(moho)
end