-- **************************************************
-- Provide Moho with the name of this script object
-- **************************************************

ScriptName = "LK_MaskSettings"

-- **************************************************
-- General information about this script
-- **************************************************

LK_MaskSettings = {}

LK_MaskSettings.BASE_STR = 56780 --BASE_STR is a number to be used into the position value of "MOHO.Localize(position, default)", a function that returns a string located "in AnimeStudioProX.X.strings" file at the value given by "position" that returns the "default" string if it's not found.

function LK_MaskSettings:ColorizeIcon()
	return true
end

function LK_MaskSettings:Name()
	return "Quickly set up masks"
end

function LK_MaskSettings:Version()
	return "0.1"
end

function LK_MaskSettings:Description()
	return "Quickly set up and check mask settings"
end

function LK_MaskSettings:Creator()
	return "Lukas Krepel Frame Order"
end

function LK_MaskSettings:UILabel()
	return "Mask Settings"
end

function LK_MaskSettings:IsRelevant()
	if MohoMode ~= nil then
		return MohoMode.rigging
	else
		return true
	end
end

-- **************************************************
-- The guts of this script
-- **************************************************

function LK_MaskSettings:OnMouseDown(moho, mouseEvent)
	--moho.document:PrepMultiUndo()
	--moho.document:SetDirty()
end

-- **************************************************
-- Tool options - create and respond to tool's UI
-- **************************************************
LK_MaskSettings.NO_MASKING_IN_THIS_GROUP = MOHO.MSG_BASE + 1
LK_MaskSettings.REVEAL_ALL = MOHO.MSG_BASE + 2
LK_MaskSettings.HIDE_ALL = MOHO.MSG_BASE + 3
LK_MaskSettings.TOGGLECLEARALPHA = MOHO.MSG_BASE + 4
LK_MaskSettings.ADDLAYERALPHA = MOHO.MSG_BASE + 5
LK_MaskSettings.SUBTRACTLAYERALPHA = MOHO.MSG_BASE + 6
LK_MaskSettings.TOGGLEINVISIBLE = MOHO.MSG_BASE + 7
LK_MaskSettings.TOGGLEEXCLUDESTROKES = MOHO.MSG_BASE + 8
LK_MaskSettings.TOGGLEEXPANDBYAPIXEL = MOHO.MSG_BASE + 9
LK_MaskSettings.TOGGLEMASKLAYER = MOHO.MSG_BASE + 10
LK_MaskSettings.DONTMASKTHISLAYER = MOHO.MSG_BASE + 11

function LK_MaskSettings:DoLayout(moho, layout)
	-- *** GROUP ALPHA: ***
	local layer = moho.document:GetSelectedLayer()
	local parentLayer = moho.layer:Parent()
	local parentName = ""
	self.MaskGroupLayerName = LM.GUI.DynamicText("Masking only available within a group.")
	if parentLayer ~= nil then
		parentName = parentLayer:Name()
		self.MaskGroupLayerName:SetValue(parentName .. " base alpha:")
	end
	layout:AddChild(self.MaskGroupLayerName)
	-- *** Group Mask Buttons ***
	layout:PushH(LM.GUI.ALIGN_CENTER, 2)
	-- * No Masking Button:
	self.NoMaskingButton = LM.GUI.ImageButton("ScriptResources/FO_icons/txt_no_masking", "No Masking in this group", true, self.NO_MASKING_IN_THIS_GROUP, true)
	layout:AddChild(self.NoMaskingButton)
	-- * Reveal All Button:
	self.RevealAllButton = LM.GUI.ImageButton("ScriptResources/FO_icons/masking_reveal_all", "Reveal all", true, self.REVEAL_ALL, false)
	layout:AddChild(self.RevealAllButton)
	-- * Hide All Button:
	self.HideAllButton = LM.GUI.ImageButton("ScriptResources/FO_icons/masking_hide_all", "Hide all", true, self.HIDE_ALL, false)
	layout:AddChild(self.HideAllButton)
	layout:Pop()
	--- *** Clear alpha before adding/subtracting? ***
	FO_Utilities:Divider(layout, "Clear mask")
	self.clearAlphaCheckButton = LM.GUI.ImageButton("ScriptResources/FO_icons/masking_hide_all", "Hide all", true, self.TOGGLECLEARALPHA, false)
  	layout:AddChild(self.clearAlphaCheckButton)
	-- *** Add/subtract alpha: ***
	FO_Utilities:Divider(layout, "Add/Subtract alpha")
	layout:PushH(LM.GUI.ALIGN_CENTER, 2)
	-- * Add Button:
	self.AddLayerAlphaButton = LM.GUI.ImageButton("ScriptResources/FO_icons/masking_add_alpha", "Add layer alpha", true, self.ADDLAYERALPHA, false)
	layout:AddChild(self.AddLayerAlphaButton)
	-- * Subtract Button:
	self.SubtractLayerAlphaButton = LM.GUI.ImageButton("ScriptResources/FO_icons/masking_subtract_alpha", "Subtract layer alpha", true, self.SUBTRACTLAYERALPHA, false)
	layout:AddChild(self.SubtractLayerAlphaButton)
	layout:Pop()
	--- *** Layer invisible ***
	layout:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL, 0)
	self.invisibleCheck = LM.GUI.CheckBox("Invisible mask", self.TOGGLEINVISIBLE)
  	layout:AddChild(self.invisibleCheck)
	
	--- *** Exclude strokes: ***
	layout:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL, 0)
	self.excludeStrokesCheck = LM.GUI.CheckBox("Exclude strokes", self.TOGGLEEXCLUDESTROKES)
  	layout:AddChild(self.excludeStrokesCheck)
	
  	--- *** Expand by a pixel: ***
	layout:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL, 0)
	self.expandByAPixelCheck = LM.GUI.CheckBox("Expand by a pixel", self.TOGGLEEXPANDBYAPIXEL)
  	layout:AddChild(self.expandByAPixelCheck)
	
	-- *** Mask layer? ***
	layout:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL, 0)
	self.maskLayerCheck = LM.GUI.CheckBox("Mask this layer", self.TOGGLEMASKLAYER)
  	layout:AddChild(self.maskLayerCheck)

  	-- *** Don't mask layer ***
  	layout:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL, 0)
	self.dontMaskLayer = LM.GUI.ImageButton("ScriptResources/FO_icons/trashcan", "Remove any masking involvement", false, self.DONTMASKTHISLAYER, true)
  	layout:AddChild(self.dontMaskLayer)
end

function LK_MaskSettings:UpdateWidgets(moho)
	--- *** Update Group masking buttons ***
	local layer = moho.document:GetSelectedLayer(i)
	local parentLayer = layer:Parent()
	local inMaskableGroup = false
	if parentLayer ~= nil and parentLayer:IsGroupType() and parentLayer:LayerType() ~= MOHO.LT_SWITCH and parentLayer:LayerType() ~= MOHO.LT_PARTICLE then
		-- IN A GROUP
		inMaskableGroup = true
	  	if parentLayer ~= nil and (parentLayer:GetGroupMask() == MOHO.GROUP_MASK_NONE) then -- 0 = GROUP_MASK_NONE
			layer:SetMaskingMode(MOHO.MM_NOTMASKED) -- 1 = MOHO.MM_NOTMASKED
		end
		-- No masking, Hide, Reveal knoppen beschikbaar maken
		self.NoMaskingButton:Enable(true)
		self.RevealAllButton:Enable(true)
		self.HideAllButton:Enable(true)
		--
		self.dontMaskLayer:Enable(true)
		-- No masking, Hide, Reveal knoppen kleuren
		if (parentLayer:GetGroupMask() == MOHO.GROUP_MASK_NONE) then -- 0 = GROUP_MASK_NONE
			self.NoMaskingButton:SetValue(true)
			self.RevealAllButton:SetValue(false)
			self.HideAllButton:SetValue(false)
		elseif (parentLayer:GetGroupMask() == MOHO.GROUP_MASK_SHOW_ALL) then -- 1 = GROUP_MASK_SHOW_ALL
			self.NoMaskingButton:SetValue(false)
			self.RevealAllButton:SetValue(true)
			self.HideAllButton:SetValue(false)
		elseif (parentLayer:GetGroupMask() == MOHO.GROUP_MASK_HIDE_ALL) then -- 2 = GROUP_MASK_HIDE_ALL
			self.NoMaskingButton:SetValue(false)
			self.RevealAllButton:SetValue(false)
			self.HideAllButton:SetValue(true)
		end
	else
		-- NOT IN A GROUP
		layer:SetMaskingMode(MOHO.MM_NOTMASKED) -- 1 = MOHO.MM_NOTMASKED
		self.NoMaskingButton:Enable(false)
		self.NoMaskingButton:SetValue(false)
		self.RevealAllButton:Enable(false)
		self.RevealAllButton:SetValue(false)
		self.HideAllButton:Enable(false)
		self.HideAllButton:SetValue(false)
		--
		self.dontMaskLayer:Enable(false)
	end
	local maskMode = moho.layer:MaskingMode()
	-- *** Update Clear Button ***
	if maskMode == MOHO.MM_CLEAR_ADD_MASK or maskMode == MOHO.MM_CLEAR_ADD_MASK_INVIS then
		self.clearAlphaCheckButton:Enable(true)
		self.clearAlphaCheckButton:SetValue(true)
	elseif maskMode == MOHO.MM_ADD_MASK or maskMode == MOHO.MM_ADD_MASK_INVIS then
		self.clearAlphaCheckButton:Enable(true)
		self.clearAlphaCheckButton:SetValue(false)
	else
		self.clearAlphaCheckButton:Enable(false)
		self.clearAlphaCheckButton:SetValue(false)
	end
	-- *** Update Add alpha Button ***
	if maskMode == MOHO.MM_ADD_MASK or maskMode == MOHO.MM_ADD_MASK_INVIS or maskMode == MOHO.MM_CLEAR_ADD_MASK or maskMode == MOHO.MM_CLEAR_ADD_MASK_INVIS then
		self.AddLayerAlphaButton:Enable(true)
		self.AddLayerAlphaButton:SetValue(true)
	elseif maskMode == MOHO.MM_MASKED or inMaskableGroup == false then
		self.AddLayerAlphaButton:Enable(false)
		self.AddLayerAlphaButton:SetValue(false)
	elseif maskMode == MOHO.MM_NOTMASKED or MOHO.MM_SUB_MASK_INVIS then
		self.AddLayerAlphaButton:Enable(true)
		self.AddLayerAlphaButton:SetValue(false)
	end
	-- *** Update Subtract alpha Button ***
	if maskMode == MOHO.MM_SUB_MASK_INVIS then
		self.SubtractLayerAlphaButton:Enable(true)
		self.SubtractLayerAlphaButton:SetValue(true)
	elseif maskMode == MOHO.MM_MASKED or inMaskableGroup == false then
		self.SubtractLayerAlphaButton:Enable(false)
		self.SubtractLayerAlphaButton:SetValue(false)
	else
		self.SubtractLayerAlphaButton:Enable(true)
		self.SubtractLayerAlphaButton:SetValue(false)
	end
	-- *** Update Invisible Button ***
	if maskMode == MOHO.MM_SUB_MASK_INVIS then
		self.invisibleCheck:Enable(false)
		self.invisibleCheck:SetValue(true)
	elseif moho.layer:MaskingMode() == MOHO.MM_ADD_MASK_INVIS or moho.layer:MaskingMode() == MOHO.MM_SUB_MASK_INVIS or moho.layer:MaskingMode() == MOHO.MM_CLEAR_ADD_MASK_INVIS then
		self.invisibleCheck:Enable(true)
		self.invisibleCheck:SetValue(true)
	elseif maskMode == MOHO.MM_MASKED or maskMode == MOHO.MM_NOTMASKED then
		self.invisibleCheck:Enable(false)
		self.invisibleCheck:SetValue(false)
	elseif maskMode == MOHO.MM_ADD_MASK or maskMode == MOHO.MM_ADD_MASK_INVIS or maskMode == MOHO.MM_CLEAR_ADD_MASK then
		self.invisibleCheck:Enable(true)
		self.invisibleCheck:SetValue(false)
	end
	-- *** Update Exclude Strokes Button ***
	if (moho:LayerAsVector(moho.layer)) and ((moho.layer:MaskingMode() == MOHO.MM_ADD_MASK) or (moho.layer:MaskingMode() == MOHO.MM_ADD_MASK_INVIS) or (moho.layer:MaskingMode() == MOHO.MM_CLEAR_ADD_MASK) or (moho.layer:MaskingMode() == MOHO.MM_CLEAR_ADD_MASK_INVIS)) then
		self.excludeStrokesCheck:Enable(true)
		if (moho.layer.fExcludeLinesFromMask == true) then
			self.excludeStrokesCheck:SetValue(true)
		else
			self.excludeStrokesCheck:SetValue(false)
			local vectorLayer = moho:LayerAsVector(moho.layer)
			if vectorLayer then
				vectorLayer.fExcludeLinesFromMask = false
			end
		end
	else
		self.excludeStrokesCheck:Enable(false)
		self.excludeStrokesCheck:SetValue(false)
		local vectorLayer = moho:LayerAsVector(moho.layer)
		if vectorLayer then
			vectorLayer.fExcludeLinesFromMask = false
		end
	end
	-- *** Update Expand Pixel Button *** --???
	if moho.layer:MaskingMode() == MOHO.MM_ADD_MASK or moho.layer:MaskingMode() == MOHO.MM_CLEAR_ADD_MASK then
		self.expandByAPixelCheck:Enable(true)
		if (layer:MaskExpansion() == true) then
			self.expandByAPixelCheck:SetValue(true)
		else
			self.expandByAPixelCheck:SetValue(false)
			layer:SetMaskExpansion(false)
		end
	else
		self.expandByAPixelCheck:Enable(false)
		self.expandByAPixelCheck:SetValue(false)
		layer:SetMaskExpansion(false)
	end
	-- *** Update Mask this layer Button ***
	if (moho.layer:MaskingMode() == MOHO.MM_MASKED) then --Opt.
		self.maskLayerCheck:Enable(true)
		self.maskLayerCheck:SetValue(true)
	elseif parentLayer ~= nil then
		self.maskLayerCheck:Enable(true)
		self.maskLayerCheck:SetValue(false)
	else
		self.maskLayerCheck:Enable(false)
		self.maskLayerCheck:SetValue(false)
	end
	-- *** All buttons updated according to layer settings***


  	--- *** Disable buttons if group is set to No Masking
  	if parentLayer ~= nil and (parentLayer:GetGroupMask() == MOHO.GROUP_MASK_NONE) then -- 0 = GROUP_MASK_NONE
		-- Clear
		self.clearAlphaCheckButton:Enable(false)
		self.clearAlphaCheckButton:SetValue(false)
		-- Add/Subtract
		self.AddLayerAlphaButton:Enable(false)
		self.AddLayerAlphaButton:SetValue(false)
		self.SubtractLayerAlphaButton:Enable(false)
		self.SubtractLayerAlphaButton:SetValue(false)
		-- Invisible
		self.invisibleCheck:Enable(false)
		self.invisibleCheck:SetValue(false)
		-- Mask layer
		self.maskLayerCheck:Enable(false)
		self.maskLayerCheck:SetValue(false)
	end
end

function LK_MaskSettings:HandleMessage(moho, view, msg)
	moho.document:PrepMultiUndo()
	moho.document:SetDirty()
	local layer = moho.layer
	local parentLayer = moho.layer:Parent()
	local maskMode = moho.layer:MaskingMode()
	--
	if msg == self.NO_MASKING_IN_THIS_GROUP then -- *** No masking ***
		parentLayer:SetGroupMask(MOHO.GROUP_MASK_NONE) -- 0 = GROUP_MASK_NONE		
	elseif msg == self.REVEAL_ALL then -- *** Reveal all ***
		parentLayer:SetGroupMask(MOHO.GROUP_MASK_SHOW_ALL) -- 1 = GROUP_MASK_SHOW_ALL
	elseif msg == self.HIDE_ALL then -- *** Hide all ***
		parentLayer:SetGroupMask(MOHO.GROUP_MASK_HIDE_ALL) -- 2 = MOHO.GROUP_MASK_HIDE_ALL
	elseif msg == self.TOGGLEMASKLAYER then -- *** Mask this layer ***
		if (self.maskLayerCheck:Value() == true) then -- returns omgekeerd van wat je verwacht?
			layer:SetMaskingMode(MOHO.MM_MASKED)
		else
			layer:SetMaskingMode(MOHO.MM_NOTMASKED)
		end
	elseif (msg == self.TOGGLECLEARALPHA) then -- *** Clear ***
		if maskMode == MOHO.MM_ADD_MASK then
			layer:SetMaskingMode(MOHO.MM_CLEAR_ADD_MASK)
		elseif maskMode == MOHO.MM_ADD_MASK_INVIS then
			layer:SetMaskingMode(MOHO.MM_CLEAR_ADD_MASK_INVIS)
		elseif maskMode == MOHO.MM_CLEAR_ADD_MASK then
			layer:SetMaskingMode(MOHO.MM_ADD_MASK)
		elseif maskMode == MOHO.MM_CLEAR_ADD_MASK_INVIS then
			layer:SetMaskingMode(MOHO.MM_ADD_MASK_INVIS)
		end
	elseif (msg == self.ADDLAYERALPHA) then -- *** Add ***
		if maskMode == MOHO.MM_NOTMASKED or maskMode == MOHO.MM_SUB_MASK_INVIS then
			layer:SetMaskingMode(MOHO.MM_ADD_MASK)
		elseif maskMode == MOHO.MM_ADD_MASK or maskMode == MOHO.MM_ADD_MASK_INVIS or maskMode == MOHO.MM_CLEAR_ADD_MASK or maskMode == MOHO.MM_CLEAR_ADD_MASK_INVIS then
			layer:SetMaskingMode(MOHO.MM_NOTMASKED)
		end
	elseif (msg == self.SUBTRACTLAYERALPHA) then -- *** Subtract ***
		if maskMode == MOHO.MM_SUB_MASK_INVIS then
			layer:SetMaskingMode(MOHO.MM_NOTMASKED)
		else
			layer:SetMaskingMode(MOHO.MM_SUB_MASK_INVIS)
			layer:SetMaskExpansion(false)
			if vectorLayer then
				vectorLayer.fExcludeLinesFromMask = false
			end
		end
	elseif (msg == self.TOGGLEINVISIBLE) then -- *** Invisible ***
		if maskMode == MOHO.MM_ADD_MASK then
			layer:SetMaskingMode(MOHO.MM_ADD_MASK_INVIS)
		elseif maskMode == MOHO.MM_ADD_MASK_INVIS then
			layer:SetMaskingMode(MOHO.MM_ADD_MASK)
		elseif maskMode == MOHO.MM_CLEAR_ADD_MASK then
			layer:SetMaskingMode(MOHO.MM_CLEAR_ADD_MASK_INVIS)
		elseif maskMode == MOHO.MM_CLEAR_ADD_MASK_INVIS then
			layer:SetMaskingMode(MOHO.MM_CLEAR_ADD_MASK)
		end
	elseif (msg == self.TOGGLEEXCLUDESTROKES) then
		local vectorLayer = moho:LayerAsVector(moho.layer)
		if vectorLayer then
			vectorLayer.fExcludeLinesFromMask = not vectorLayer.fExcludeLinesFromMask
		end
	elseif (msg == self.TOGGLEEXPANDBYAPIXEL) then
		layer:SetMaskExpansion(not (layer:MaskExpansion()))
	elseif (msg == self.DONTMASKTHISLAYER) then
		layer:SetMaskingMode(MOHO.MM_NOTMASKED)
	end

	-- *** In case there's more than 1 layer selected
	local selCount = moho.document:CountSelectedLayers()
	if selCount > 1 then
		--
		maskMode = layer:MaskingMode()
		local excludeLines = false
		if vectorLayer then
			local excludeLines = vectorLayer.fExcludeLinesFromMask
		end
		local expandMask = layer:MaskExpansion()
		--
		for i = 0, selCount - 1 do -- !!
			local layer = moho.document:GetSelectedLayer(i) -- !!
			--
			layer:SetMaskingMode(maskMode)
			if vectorLayer then
				vectorLayer.fExcludeLinesFromMask = excludeLines
			end
			layer:SetMaskExpansion(expandMask)
		end
	end
	--
	moho:UpdateUI()
end