-- **************************************************
-- Provide Moho with the name of this script object
-- **************************************************

ScriptName = "LK_SelectedKeysToZero"

-- **************************************************
-- General information about this script
-- **************************************************

LK_SelectedKeysToZero = {}

function LK_SelectedKeysToZero:Name()
	return "Move selected keys to frame 0"
end

function LK_SelectedKeysToZero:Version()
	return "0.0"
end

function LK_SelectedKeysToZero:Description()
	return "Move selected keys to frame 0"
end

function LK_SelectedKeysToZero:Creator()
	return "Lukas Krepel, Frame Order"
end

function LK_SelectedKeysToZero:UILabel()
	return "Move selected keys to frame 0"
end

function LK_SelectedKeysToZero:ColorizeIcon()
	return true
end

function LK_SelectedKeysToZero:IsRelevant()
	if MohoMode ~= nil then
		return MohoMode.animation
	else
		return true
	end
end

-- **************************************************
-- The guts of this script
-- **************************************************
function LK_SelectedKeysToZero:Run(moho)
	-- *
	moho.document:PrepMultiUndo(true)
	moho.document:SetDirty()
	-- *
	local layers = FO_Utilities:AllLayers(moho)
	for i = 1, #layers do
		local layer = layers[i]
		if layer:IsShownOnTimeline() or layer == moho.layer then
			local layerFrameZero = 0 -- * No need to calculate offset in this case, 0 is fine!
			-- *
			local chInfo  =  MOHO.MohoLayerChannel:new_local()
			-- * Iterate channels:
			for i = 0, layer:CountChannels()-1 do
				layer:GetChannelInfo(i, chInfo)
				if not chInfo.selectionBased then
					for j=0, chInfo.subChannelCount-1 do
						local subChannel = layer:Channel(i, j, moho.document)
						local channel = nil 
						if subChannel:ChannelType() == MOHO.CHANNEL_VAL then channel = moho:ChannelAsAnimVal(subChannel)
						elseif subChannel:ChannelType() == MOHO.CHANNEL_VEC2  then channel = moho:ChannelAsAnimVec2(subChannel)
						elseif subChannel:ChannelType() == MOHO.CHANNEL_VEC3  then channel = moho:ChannelAsAnimVec3(subChannel)
						elseif subChannel:ChannelType() == MOHO.CHANNEL_BOOL  then channel = moho:ChannelAsAnimBool(subChannel)
						elseif subChannel:ChannelType() == MOHO.CHANNEL_COLOR  then channel = moho:ChannelAsAnimColor(subChannel)
						elseif subChannel:ChannelType() == MOHO.CHANNEL_STRING  then channel = moho:ChannelAsAnimString(subChannel)
						end
						if channel then
							-- * Do it:
							local endKey = channel:Duration()
							local thisKey = 0 -- * ID of the key being processed.
							local keyCount = channel:CountKeys() - 1 -- * Ignore the key on frame 0.
							local keysFound = 0
							local frameNum = endKey
							local selected = false
							local frameList = {}
							local ctSel = 0
							while keysFound < keyCount do
								thisKey = channel:GetClosestKeyID(frameNum)
								frameNum = channel:GetKeyWhen(thisKey)
								selected = channel:IsKeySelected(frameNum)
								keysFound = 1 + keysFound
								if selected then
									local currentVal = channel:GetValue(frameNum)
									local interp = MOHO.InterpSetting:new_local()
									channel:GetKeyInterp(frameNum, interp)
									channel:SetValue(layerFrameZero, currentVal)
									channel:SetKeyInterp(layerFrameZero, interp)
									channel:DeleteKey(frameNum)
									channel:SetKeySelected(layerFrameZero, false)
								end
								frameNum = frameNum - 1
							end
							--
						end
					end
				end
			end
		end
	end
	-- * Trick to force viewport to properly update:
	moho:SetCurFrame(moho.frame+1)
	moho:SetCurFrame(moho.frame-1)
end