-- **************************************************
-- Provide Moho with the name of this script object
-- **************************************************

ScriptName = "AE_LuaConsole"

-- **************************************************
-- General information about this script
-- **************************************************

AE_LuaConsole = {}

function AE_LuaConsole:Name()
	return 'Lua Console'
end

function AE_LuaConsole:Version()
	return '1.6'
end

function AE_LuaConsole:UILabel()
	return 'Lua Console'
end

function AE_LuaConsole:Creator()
	return 'Alexandra Evseeva'
end

function AE_LuaConsole:Description()
	return ''
end

-- **************************************************
-- Is Relevant / Is Enabled
-- **************************************************

function AE_LuaConsole:IsRelevant(moho)
	return true
end

function AE_LuaConsole:IsEnabled(moho)
	return true
end

-- **************************************************
-- Recurring Values
-- **************************************************


AE_LuaConsole.history = {}
AE_LuaConsole.historyPointer = 0
AE_LuaConsole.infoText = {}



-- **************************************************
-- Prefs
-- **************************************************

function AE_LuaConsole:LoadPrefs(prefs)
	--self.enterCommands = prefs:GetString("AE_LuaConsole.enterCommands", '"Hello world"')
end

function AE_LuaConsole:SavePrefs(prefs)
	--prefs:SetString("AE_LuaConsole.enterCommands", self.enterCommands)
end

function AE_LuaConsole:ResetPrefs()
	--self.enterCommands = '"Hello world"'
end

-- **************************************************
-- Keyboard/Mouse Control
-- **************************************************

function AE_LuaConsole:OnMouseDown(moho, mouseEvent)
	
end

function AE_LuaConsole:OnKeyDown(moho, keyEvent)

end

-- **************************************************
-- Tool Panel Layout
-- **************************************************

AE_LuaConsole.ENTER_COMMANDS = MOHO.MSG_BASE
AE_LuaConsole.HISTORY_BUTTON = MOHO.MSG_BASE + 1
AE_LuaConsole.INFO_LIST = MOHO.MSG_BASE + 2
AE_LuaConsole.HISTORY_LOG = MOHO.MSG_BASE + 3

local AE_LuaConsoleDialog = {}


function AE_LuaConsole:DoLayout(moho, layout)
	self.enterCommandsInput = LM.GUI.TextControl(480, '"Hello world!"', self.ENTER_COMMANDS, LM.GUI.FIELD_TEXT, 'Enter commands:')
	layout:AddChild(self.enterCommandsInput, LM.GUI.ALIGN_LEFT, 0)
	
	self.historyButton = LM.GUI.Button("â†‘", self.HISTORY_BUTTON)
	layout:AddChild(self.historyButton)
	self.enterButton = LM.GUI.Button("â†’", self.ENTER_COMMANDS)
	layout:AddChild(self.enterButton)	
	
	self.outputText = LM.GUI.TextControl(200, '', 0, LM.GUI.FIELD_TEXT, 'Output:')
	layout:AddChild(self.outputText, LM.GUI.ALIGN_LEFT, 0)	
	
	self.historyMenu = LM.GUI.Menu("History...")
    self.historyPopup = LM.GUI.PopupMenu(200, true)
    self.historyPopup:SetMenu(self.historyMenu)
    layout:AddChild(self.historyPopup)	
	for i=1, #self.history do
		self.historyMenu:InsertItem(0, self.history[i], 0, self.HISTORY_LOG + i)
	end	

	self.dlog = AE_LuaConsoleDialog:new(moho)
    self.popupDialogPopup = LM.GUI.PopupDialog("Info...", false, 0)
    self.popupDialogPopup:SetDialog(self.dlog)
    layout:AddChild(self.popupDialogPopup, LM.GUI.ALIGN_LEFT, 0)


end

function AE_LuaConsole:UpdateWidgets(moho)
	self:PopulateList(moho)
	--AE_LuaConsole.enterCommandsInput:SetValue(self.enterCommands)
end

function AE_LuaConsole:HandleMessage(moho, view, msg)
	if msg == self.ENTER_COMMANDS then
		local text = self.enterCommandsInput:Value()
		self.enterCommandsInput:SetValue("")
		self:EvalCommand(moho, text)		
	elseif msg == self.HISTORY_BUTTON then
		local index = self.historyPointer % #self.history
		local nextCommand = self.history[#self.history - index]
		self.enterCommandsInput:SetValue(nextCommand)
		self.historyPointer = self.historyPointer + 1
	elseif msg >= self.HISTORY_LOG then
		local text = self.history[msg - self.HISTORY_LOG]
		self.enterCommandsInput:SetValue(text)
	end
end

function AE_LuaConsole:DrawMe(moho, view)
	if self.point2display then
		local g = view:Graphics()
		local layerMatrix = LM.Matrix:new_local()	
	
		moho.layer:GetFullTransform(moho.frame, layerMatrix, moho.document)
		g:Push()
		g:ApplyMatrix(layerMatrix)
		g:SetSmoothing(true)
		g:SetBezierTolerance(2)	
	
		g:SetColor(MOHO.MohoGlobals.SelCol)
		
		local size = 0.1
		g:DrawLine(self.point2display.x - size, self.point2display.y, self.point2display.x + size, self.point2display.y)
		g:DrawLine(self.point2display.x, self.point2display.y - size, self.point2display.x, self.point2display.y + size)
		g:FrameCircle(self.point2display, size/2)

	end
end

function AE_LuaConsole:EvalCommand(moho, text)
	if text == "" then return end
	local command = text
	table.insert(self.history, command)
	self.historyMenu:InsertItem(0, command, 0, self.HISTORY_LOG + #self.history)
	local split1, split2 = string.find(command, "[^=]=[^=]")
	if split1 then
		local assigned_value = string.sub(command, split1+2)
		assigned_value = string.gsub(assigned_value, "^%s*", "")
		local thevar = string.sub(command, 1, split1)
		command = command .. "\nreturn(" .. thevar .. ")"
	elseif string.find(command, "^for%s") then
		command = command .. "\nreturn nil"
	else 
		command = "local result = " .. command .. "\nreturn result"
	end
	command = "function AE_LuaConsole:Main(moho)\n" .. command .. "\n end"
	load(command)()
	
	moho.document:PrepUndo(moho.layer)
	moho.document:SetDirty()
	
	
	local result = {self:Main(moho)}
	if result[1] and type(result[1]) == "userdata" and type(result[1].x) == "number" and type(result[1].y) == "number" then
		self.point2display = LM.Vector2:new_local()
		self.point2display:Set(result[1].x, result[1].y)
	else 
		self.point2display = nil
	end
	
	if type(result[1]) == "table" then 
		self:PrintTable(result[1], 0)
	else
		self:PopulateList(moho)
	end
	--if self.dlog then self.dlog:PopulateList()
	
	local printableResult = ""
	for i,v in pairs(result) do printableResult = printableResult .. tostring(v) .. " " end
	print(printableResult)
	self.outputText:SetValue(printableResult)
	self.enterCommandsInput:SetValue("")
	self.historyPointer = 0
end

function AE_LuaConsole:PrintTable(t, level, preambula)
	self.infoText = {}
	local counter = 0
	for i, v in pairs(t) do
		local text = ""
		if preambula and counter == 0 then
			text = preambula
		else 
			for j = 1, level do text = text .. "  " end
		end
		text = text .. i .. ": "		
		if type(v) == "table" then
			self:PrintTable(v, level + 1, text)
		else
			if type(v) == "userdata" and type(v.x) == "number" and type(v.y) == "number" then
				text = text .. string.format("%.4f, %.4f", v.x, v.y)
			else
				text = text .. tostring(v)
			end
			table.insert(self.infoText, text)
		end
		counter = counter + 1
	end
end

function AE_LuaConsole:PopulateList(moho)
	
	if moho:Mesh() then
		self.infoText = {}
		local mesh = moho:Mesh()
		for i=0, mesh:CountPoints()-1 do
			if mesh:Point(i).fSelected then
				local p = mesh:Point(i)
				table.insert(self.infoText, string.format("Point %s at %.4f, %.4f", i, p.fPos.x, p.fPos.y))
				if p.fParent >= 0 then
					local skel = moho.layer:ControllingSkeleton()
					if skel and skel:Bone(p.fParent) then
						table.insert(self.infoText, string.format('bind to bone #%s "%s"', p.fParent, skel:Bone(p.fParent):Name()))
					end
				end
				local a = p.fAnimPos:GetValue(moho.frame)
				table.insert(self.infoText, string.format("anim val %.4f, %.4f", a.x, a.y))
				table.insert(self.infoText, string.format("used in %s curves", p:CountCurves()))
				for c=0, p:CountCurves()-1 do
					local crv, where = p:Curve(c)
					local curvNo = mesh:CurveID(crv)
					local percent = where <= crv:CountSegments() and crv:GetSegmentRange(where) or 1
					local curvature = crv:GetCurvature(where, moho.frame)
					table.insert(self.infoText, string.format("curve %s as point %s at %.5f crv %.2f", curvNo, where, percent, curvature))
					local inW = crv:GetWeight(where, moho.frame, true)
					local inO = crv:GetOffset(where, moho.frame, true)
					local inH = crv:GetControlHandle(where, moho.frame, true)
					local outW = crv:GetWeight(where, moho.frame, false)
					local outO = crv:GetOffset(where, moho.frame, false)	
					local outH = crv:GetControlHandle(where, moho.frame, false)
					table.insert(self.infoText, string.format("    IN weight %.2f offset %.2f", inW, inO))
					table.insert(self.infoText, string.format("    handle %.4f, %.4f", inH.x, inH.y))
					table.insert(self.infoText, string.format("    OUT weight %.2f offset %.2f", outW, outO))
					table.insert(self.infoText, string.format("    handle %.4f, %.4f", outH.x, outH.y))
					table.insert(self.infoText, "")
				end
			end
		end
	elseif moho:Skeleton() then
		self.infoText = {}
		local skel = moho:Skeleton()
		for i=0, skel:CountBones()-1 do
			if skel:Bone(i).fSelected then
				local b = skel:Bone(i)
				table.insert(self.infoText, string.format('Bone %s "%s"', i, b:Name()))
				if b.fParent > -1 then 
					table.insert(self.infoText, string.format('parented by bone %s (%s)', b.fParent, skel:Bone(b.fParent):Name()))
				else table.insert(self.infoText, 'not parented')
				end
				local numChildren = 0
				for j=0, skel:CountBones()-1 do
					if skel:Bone(j).fParent == i then numChildren = numChildren + 1 end
				end
				table.insert(self.infoText, string.format('having %s child bones', numChildren))
			end
		end
	end

end

-- **************************************************
-- popupDialog1Dialog
-- **************************************************




function AE_LuaConsoleDialog:new(moho)
	
    local d = LM.GUI.SimpleDialog('Info', AE_LuaConsoleDialog)
    local l = d:GetLayout()
	
	d.copyFunc = moho.CopyText
	
	d.textList = LM.GUI.TextList(300, 300, AE_LuaConsole.INFO_LIST)
	l:AddChild(d.textList)
	
	d:PopulateList(moho)

    return d
end

function AE_LuaConsoleDialog:UpdateWidgets()
	self:PopulateList(moho)
end

function AE_LuaConsoleDialog:HandleMessage(msg)
    if msg == AE_LuaConsole.INFO_LIST then
		local text = self.textList:SelItemLabel()
        AE_LuaConsole.outputText:SetValue(text)	
    else
        
    end
end

function AE_LuaConsoleDialog:OnOK(moho)

end



function AE_LuaConsoleDialog:PopulateList(moho)
	local d = self
	while d.textList:CountItems() > 0 do d.textList:RemoveItem(0) end 
	for i,v in pairs(AE_LuaConsole.infoText) do
		d.textList:AddItem(v)
	end
end

--[[

--]]