-- **************************************************
-- Provide Moho with the name of this script object
-- **************************************************

ScriptName = "AM_SelectBonelayer"

-- **************************************************
-- General information about this script
-- **************************************************

AM_SelectBonelayer = {}

function AM_SelectBonelayer:Name()
	return 'Select Bonelayer'
end

function AM_SelectBonelayer:Version()
	return '1.4'
end

function AM_SelectBonelayer:UILabel()
	return 'Select Bonelayer'
end

function AM_SelectBonelayer:Creator()
	return 'Aleksei Maletin'
end

function AM_SelectBonelayer:Description()
	return 'Select Bonelayer'
end


-- **************************************************
-- Is Relevant / Is Enabled
-- **************************************************

function AM_SelectBonelayer:IsRelevant(moho)
	local hasParent = moho.layer:Parent()
	if hasParent then
		return true 
	end
	return false
end

function AM_SelectBonelayer:IsEnabled(moho)
	if moho.layer:LayerType() ~= MOHO.LT_BONE then
		return true
	end
end

-- **************************************************
-- The guts of this script
-- **************************************************

function AM_SelectBonelayer:Run(moho)
  local layerToSearchForBoneParent = moho.layer
  local layerParentBone = layerToSearchForBoneParent:ControllingBoneLayer()
  if layerParentBone then
    moho:SetSelLayer(layerParentBone)
  else
    repeat
      local parent = layerToSearchForBoneParent:Parent()
      if parent then
        if parent:LayerType() == MOHO.LT_BONE then
          moho:SetSelLayer(parent)
          moho:ShowLayerInLayersPalette(parent)
          break
        else
          layerToSearchForBoneParent = parent
        end
      end	
     until not parent
  end
end
