-- **************************************************
-- Provide Moho with the name of this script object
-- **************************************************

ScriptName = "AM_SetDynamicSkeleton"

-- **************************************************
-- General information about this script
-- **************************************************

AM_SetDynamicSkeleton = {}

function AM_SetDynamicSkeleton:Name()
	return 'Set Dynamic Skeleton'
end

function AM_SetDynamicSkeleton:Version()
	return '1.0'
end

function AM_SetDynamicSkeleton:UILabel()
	return 'Set Dynamic Skeleton'
end

function AM_SetDynamicSkeleton:Creator()
	return 'Aleksei Maletin'
end

function AM_SetDynamicSkeleton:Description()
	return ''
end


-- **************************************************
-- Is Relevant / Is Enabled
-- **************************************************

function AM_SetDynamicSkeleton:IsRelevant(moho)
	if moho:Mesh() then return true else return false end
end

function AM_SetDynamicSkeleton:IsEnabled(moho)
	if moho:Mesh() then return true else return false end
end

-- **************************************************
-- The guts of this script
-- **************************************************

function AM_SetDynamicSkeleton:Run(moho)
	moho.document:SetDirty()
	moho.document:PrepUndo(nil)
	
	-- Your code here:
	local layer = moho.layer
	local mesh = moho:Mesh()
	local myTable = {}

	for i=0, mesh:CountPoints()-1 do
		local point = mesh:Point(i)
		table.insert(myTable, point.fAnimPos:GetValue(0))
	end

	for i = 1, 10 do

		for a = 0, mesh:CountPoints()-1 do
			local point = mesh:Point(a)
			point.fPos:Set(myTable[a+1])
		end

		mesh:SelectAll()
		moho:AddPointKeyframe(1, layer, false)
		layer:CopyFrame(1, 0, false)
	end

	layer:DeleteFrame(1, false)

end
