-- **************************************************
-- Provide Moho with the name of this script object
-- **************************************************

ScriptName = "MR_AnimatePoints"

-- **************************************************
-- General information about this script
-- **************************************************

MR_AnimatePoints = {}

MR_AnimatePoints.BASE_STR = 2145

function MR_AnimatePoints:Name()
	return self:Localize('UILabel')
end

function MR_AnimatePoints:Version()
	return "1.0.1"
end

function MR_AnimatePoints:Description()
	return self:Localize('Description')
end

function MR_AnimatePoints:Creator()
	return "Eugene Babich, Sam Cogheil (SimplSam)"
end

function MR_AnimatePoints:UILabel()
	return self:Localize('UILabel')
end

function MR_AnimatePoints:LoadPrefs(prefs)
	self.transformBoxMode = prefs:GetBool("MR_AnimatePoints.transformBoxMode", true)
	self.warpMode = prefs:GetBool("MR_AnimatePoints.warpMode", false)
	self.magnetRadius = prefs:GetFloat("MR_AnimatePoints.magnetRadius", 0.5)
	self.innerRadius = prefs:GetFloat("MR_AnimatePoints.innerRadius", 0)
	self.isolateLayers = prefs:GetBool("MR_AnimatePoints.isolateLayers", false)
	self.selectPoints = prefs:GetBool("MR_AnimatePoints.selectPoints", true)
	self.selectedOnly = prefs:GetBool("MR_AnimatePoints.selectedOnly", false)
	self.lassoMode = prefs:GetBool("MR_AnimatePoints.lassoMode", false)
	self.showHandles = prefs:GetBool("MR_AnimatePoints.showHandles", false)
	self.fixedHandles = prefs:GetBool("MR_AnimatePoints.fixedHandles", false)
	self.autoConnectSelected = prefs:GetBool("MR_AnimatePoints.autoConnectSelected", false)
	self.twosMode = prefs:GetBool("MR_AnimatePoints.twosMode", false)
	self.smartBake = prefs:GetBool("MR_AnimatePoints.smartBake", false)
	self.smartBakeInterval = prefs:GetInt("MR_AnimatePoints.smartBakeInterval", 2)

	self.visibleLayersOnly = prefs:GetBool("MR_AnimatePoints.visibleLayersOnly", true)
	self.visibleLayersOnlyKeyframing = prefs:GetBool("MR_AnimatePoints.visibleLayersOnlyKeyframing", true)
	self.hideCurvesWhileDragging = prefs:GetBool("MR_AnimatePoints.hideCurvesWhileDragging", true)
	self.drawPoints = prefs:GetBool("MR_AnimatePoints.drawPoints", true)
	self.drawPointsdrawPointsWhileDragging = prefs:GetBool("MR_AnimatePoints.drawPointsdrawPointsWhileDragging", true)
	self.useSingleColor = prefs:GetBool("MR_AnimatePoints.useSingleColor", false)
	self.pointsColorR = prefs:GetInt("MR_AnimatePoints.pointsColorR", 224)
	self.pointsColorG = prefs:GetInt("MR_AnimatePoints.pointsColorG", 0)
	self.pointsColorB = prefs:GetInt("MR_AnimatePoints.pointsColorB", 82)
	self.pointsColorA = prefs:GetInt("MR_AnimatePoints.pointsColorA", 255)
	self.guiColorR = prefs:GetInt("MR_AnimatePoints.guiColorR", 224)
	self.guiColorG = prefs:GetInt("MR_AnimatePoints.guiColorG", 0)
	self.guiColorB = prefs:GetInt("MR_AnimatePoints.guiColorB", 82)
	self.guiColorA = prefs:GetInt("MR_AnimatePoints.guiColorA", 255)
	self.sensitivity = prefs:GetFloat("MR_AnimatePoints.sensitivity", 1)
	self.warpOpacity = prefs:GetFloat("MR_AnimatePoints.warpOpacity", 1)
	self.pointsOpacity = prefs:GetFloat("MR_AnimatePoints.pointsOpacity", 1)
	self.pointsSize = prefs:GetFloat("MR_AnimatePoints.pointsSize", 1)
	self.blendSensitivity = prefs:GetFloat("MR_AnimatePoints.blendSensitivity", 1)
	self.blockOnEvenFrames = prefs:GetBool("MR_AnimatePoints.blockOnEvenFrames", true)
	self.blockOnOddFrames = prefs:GetBool("MR_AnimatePoints.blockOnOddFrames", false)
	self.ignoreReferenceLayers = prefs:GetBool("MR_AnimatePoints.ignoreReferenceLayers", false)
	self.autoUpdateReferenceLayers = prefs:GetBool("MR_AnimatePoints.autoUpdateReferenceLayers", true)
	self.longPressTime = prefs:GetFloat("MR_AnimatePoints.longPressTime", 0.5)
	self.transformBoxExtraHandles = prefs:GetBool("MR_AnimatePoints.transformBoxExtraHandles", true)
	self.drawPoints = prefs:GetBool("MR_AnimatePoints.drawPoints", true)

	self.processSelectedPointsOnly = prefs:GetBool("MR_AnimatePoints.processSelectedPointsOnly", false)
	self.processIsolatedLayersOnly = prefs:GetBool("MR_AnimatePoints.processIsolatedLayersOnly", false)
	self.considerWarpMode = prefs:GetBool("MR_AnimatePoints.considerWarpMode", true)

	self.smooth = prefs:GetBool("MR_AnimatePoints.smooth", true)
	self.linear = prefs:GetBool("MR_AnimatePoints.linear", false)
	self.step = prefs:GetBool("MR_AnimatePoints.step", false)
	self.noisy = prefs:GetBool("MR_AnimatePoints.noisy", false)
	self.interval = prefs:GetInt("MR_AnimatePoints.interval", 1)
end

function MR_AnimatePoints:SavePrefs(prefs)
	prefs:SetBool("MR_AnimatePoints.transformBoxMode", self.transformBoxMode)
	prefs:SetBool("MR_AnimatePoints.warpMode", self.warpMode)
	prefs:SetFloat("MR_AnimatePoints.magnetRadius", self.magnetRadius)
	prefs:SetFloat("MR_AnimatePoints.innerRadius", self.innerRadius)
	prefs:SetBool("MR_AnimatePoints.isolateLayers", self.isolateLayers)
	prefs:SetBool("MR_AnimatePoints.selectPoints", self.selectPoints)
	prefs:SetBool("MR_AnimatePoints.selectedOnly", self.selectedOnly)
	prefs:SetBool("MR_AnimatePoints.lassoMode", self.lassoMode)
	prefs:SetBool("MR_AnimatePoints.showHandles", self.showHandles)
	prefs:SetBool("MR_AnimatePoints.fixedHandles", self.fixedHandles)
	prefs:SetBool("MR_AnimatePoints.autoConnectSelected", self.autoConnectSelected)
	prefs:SetBool("MR_AnimatePoints.twosMode", self.twosMode)
	prefs:SetBool("MR_AnimatePoints.smartBake", self.smartBake)
	prefs:SetInt("MR_AnimatePoints.smartBakeInterval", self.smartBakeInterval)

	prefs:SetBool("MR_AnimatePoints.visibleLayersOnly", self.visibleLayersOnly)
	prefs:SetBool("MR_AnimatePoints.visibleLayersOnlyKeyframing", self.visibleLayersOnlyKeyframing)
	prefs:SetBool("MR_AnimatePoints.hideCurvesWhileDragging", self.hideCurvesWhileDragging)
	prefs:SetBool("MR_AnimatePoints.drawPoints", self.drawPoints)
	prefs:SetBool("MR_AnimatePoints.drawPointsdrawPointsWhileDragging", self.drawPointsdrawPointsWhileDragging)
	prefs:SetBool("MR_AnimatePoints.useSingleColor", self.useSingleColor)
	prefs:SetInt("MR_AnimatePoints.pointsColorR", self.pointsColorR)
	prefs:SetInt("MR_AnimatePoints.pointsColorG", self.pointsColorG)
	prefs:SetInt("MR_AnimatePoints.pointsColorB", self.pointsColorB)
	prefs:SetInt("MR_AnimatePoints.pointsColorA", self.pointsColorA)
	prefs:SetInt("MR_AnimatePoints.guiColorR", self.guiColorR)
	prefs:SetInt("MR_AnimatePoints.guiColorG", self.guiColorG)
	prefs:SetInt("MR_AnimatePoints.guiColorB", self.guiColorB)
	prefs:SetInt("MR_AnimatePoints.guiColorA", self.guiColorA)
	prefs:SetFloat("MR_AnimatePoints.sensitivity", self.sensitivity)
	prefs:SetFloat("MR_AnimatePoints.warpOpacity", self.warpOpacity)
	prefs:SetFloat("MR_AnimatePoints.pointsOpacity", self.pointsOpacity)
	prefs:SetFloat("MR_AnimatePoints.pointsSize", self.pointsSize)
	prefs:SetFloat("MR_AnimatePoints.blendSensitivity", self.blendSensitivity)
	prefs:SetBool("MR_AnimatePoints.blockOnEvenFrames", self.blockOnEvenFrames)
	prefs:SetBool("MR_AnimatePoints.blockOnOddFrames", self.blockOnOddFrames)
	prefs:SetBool("MR_AnimatePoints.ignoreReferenceLayers", self.ignoreReferenceLayers)
	prefs:SetBool("MR_AnimatePoints.autoUpdateReferenceLayers", self.autoUpdateReferenceLayers)
	prefs:SetFloat("MR_AnimatePoints.longPressTime", self.longPressTime)
	prefs:SetBool("MR_AnimatePoints.transformBoxExtraHandles", self.transformBoxExtraHandles)
	prefs:SetBool("MR_AnimatePoints.drawPoints", self.drawPoints)

	prefs:SetBool("MR_AnimatePoints.processSelectedPointsOnly", self.processSelectedPointsOnly)
	prefs:SetBool("MR_AnimatePoints.processIsolatedLayersOnly", self.processIsolatedLayersOnly)
	prefs:SetBool("MR_AnimatePoints.considerWarpMode", self.considerWarpMode)

	prefs:SetBool("MR_AnimatePoints.smooth", self.smooth)
	prefs:SetBool("MR_AnimatePoints.linear", self.linear)
	prefs:SetBool("MR_AnimatePoints.step", self.step)
	prefs:SetBool("MR_AnimatePoints.noisy", self.noisy)
	prefs:SetInt("MR_AnimatePoints.interval", self.interval)
end

function MR_AnimatePoints:NonDragMouseMove()
	return true -- Call MouseMoved() even if the mouse button is not down
end

function MR_AnimatePoints:ResetPrefs()
	self.transformBoxMode = true
	self.warpMode = false
	self.magnetRadius = 0.5
	self.innerRadius = 0
	self.isolateLayers = false
	self.selectPoints = true
	self.selectedOnly = false
	self.lassoMode = false
	self.showHandles = false
	self.fixedHandles = false
	self.autoConnectSelected = false
	self.twosMode = false
	self.smartBake = false
	self.smartBakeInterval = 2

	self.visibleLayersOnly = true
	self.visibleLayersOnlyKeyframing = true
	self.hideCurvesWhileDragging = true
	self.drawPoints = true
	self.drawPointsdrawPointsWhileDragging = true
	self.useSingleColor = false
	self.pointsColorR = 224
	self.pointsColorG = 0
	self.pointsColorB = 82
	self.pointsColorA = 255
	self.guiColorR = 224
	self.guiColorG = 0
	self.guiColorB = 82
	self.guiColorA = 255
	self.warpOpacity = 1
	self.pointsOpacity = 1
	self.pointsSize = 1
	self.sensitivity = 1
	self.blendSensitivity = 1
	self.blockOnEvenFrames = true
	self.blockOnOddFrames = false
	self.ignoreReferenceLayers = false
	self.autoUpdateReferenceLayers = true
	self.longPressTime = 0.5
	self.transformBoxExtraHandles = true
	self.drawPoints = true

	self.processSelectedPointsOnly = false
	self.processIsolatedLayersOnly = false
	self.considerWarpMode = true

	self.smooth = true
	self.linear = false
	self.step = false
	self.noisy = false
	self.interval = 1
end

-- **************************************************
-- Recurring values
-- **************************************************

MR_AnimatePoints.transformBoxMode = true
MR_AnimatePoints.warpMode = false
MR_AnimatePoints.magnetRadius = 0.5
MR_AnimatePoints.innerRadius = 0
MR_AnimatePoints.isolateLayers = false
MR_AnimatePoints.selectPoints = true
MR_AnimatePoints.selectedOnly = false
MR_AnimatePoints.lassoMode = false
MR_AnimatePoints.showHandles = false
MR_AnimatePoints.fixedHandles = false
MR_AnimatePoints.autoConnectSelected = false
MR_AnimatePoints.twosMode = false
MR_AnimatePoints.smartBake = false
MR_AnimatePoints.smartBakeInterval = 2
MR_AnimatePoints.dragging = false
MR_AnimatePoints.dragVec = LM.Vector2:new_local()
MR_AnimatePoints.dragVec:Set(10000.0, 10000.0)
MR_AnimatePoints.dragResize = false
MR_AnimatePoints.selectionMode = false
MR_AnimatePoints.startRadius = 0
MR_AnimatePoints.inProgressIconRadius = 0.05
MR_AnimatePoints.inProgressIcon = false

MR_AnimatePoints.visibleLayersOnly = true
MR_AnimatePoints.visibleLayersOnlyKeyframing = true
MR_AnimatePoints.hideCurvesWhileDragging = true
MR_AnimatePoints.drawPoints = true
MR_AnimatePoints.drawPointsdrawPointsWhileDragging = true
MR_AnimatePoints.useSingleColor = false
MR_AnimatePoints.pointsColorR = 224
MR_AnimatePoints.pointsColorG = 0
MR_AnimatePoints.pointsColorB = 82
MR_AnimatePoints.pointsColorA = 255
MR_AnimatePoints.guiColorR = 224
MR_AnimatePoints.guiColorG = 0
MR_AnimatePoints.guiColorB = 82
MR_AnimatePoints.guiColorA = 255
MR_AnimatePoints.warpOpacity = 1
MR_AnimatePoints.pointsOpacity = 1
MR_AnimatePoints.pointsSize = 1
MR_AnimatePoints.sensitivity = 1
MR_AnimatePoints.blendSensitivity = 1
MR_AnimatePoints.blockOnEvenFrames = true
MR_AnimatePoints.blockOnOddFrames = false
MR_AnimatePoints.ignoreReferenceLayers = false
MR_AnimatePoints.autoUpdateReferenceLayers = true
MR_AnimatePoints.longPressTime = 0.5
MR_AnimatePoints.transformBoxExtraHandles = true
MR_AnimatePoints.drawPoints = true

MR_AnimatePoints.processSelectedPointsOnly = false
MR_AnimatePoints.processIsolatedLayersOnly = false
MR_AnimatePoints.considerWarpMode = true

MR_AnimatePoints.smooth = true
MR_AnimatePoints.linear = false
MR_AnimatePoints.step = false
MR_AnimatePoints.noisy = false
MR_AnimatePoints.interval = 1

MR_AnimatePoints.minVec = LM.Vector2:new_local()
MR_AnimatePoints.maxVec = LM.Vector2:new_local()
MR_AnimatePoints.cursorPosition = LM.Vector2:new_local()
MR_AnimatePoints.mouseStartVec = LM.Vector2:new_local()
MR_AnimatePoints.lastVec = LM.Vector2:new_local()
MR_AnimatePoints.drawHandles = false
MR_AnimatePoints.drawLongArrow = false
MR_AnimatePoints.twosModeValid = true
MR_AnimatePoints.selRect = LM.Rect:new_local()
MR_AnimatePoints.previousX = 0
MR_AnimatePoints.previousY = 0
MR_AnimatePoints.lassoList = {}
MR_AnimatePoints.layersPointsList = {}
MR_AnimatePoints.handlesActive = false
MR_AnimatePoints.handlesTransformationActive = false
MR_AnimatePoints.copiedFrame = nil

MR_AnimatePoints.isolatedLayerUUIDList = {}
MR_AnimatePoints.handleList = {}
MR_AnimatePoints.axisMove = 0 -- 0 - none, 1 - x+, 2 - x-, 3 - y+, 4 - y-
MR_AnimatePoints.layersIsolation = false

MR_AnimatePoints.scriptDataName = 'MR_AnimatePoints'
MR_AnimatePoints.deselectedPointsAlpha = 150

MR_AnimatePoints.selectedPointsCount = 0
MR_AnimatePoints.markerR = 9
MR_AnimatePoints.centerVec = LM.Vector2:new_local()
MR_AnimatePoints.globalCenterVec = LM.Vector2:new_local()
MR_AnimatePoints.pivotOffset = LM.Vector2:new_local()
MR_AnimatePoints.pivotOffsetPt = LM.Point:new_local()
MR_AnimatePoints.globalPivotOffset = LM.Vector2:new_local()
MR_AnimatePoints.selectionBBox = LM.BBox:new_local()
MR_AnimatePoints.globalBBox = LM.BBox:new_local()
MR_AnimatePoints.lastVecPt = LM.Point:new_local()
MR_AnimatePoints.offsetCenter = LM.Vector2:new_local()
MR_AnimatePoints.centerVecPt = LM.Point:new_local()
MR_AnimatePoints.offsetCenterPt = LM.Point:new_local()
MR_AnimatePoints.pivotCenterVec = LM.Vector2:new_local()
MR_AnimatePoints.selectedMin = LM.Vector2:new_local()
MR_AnimatePoints.selectedMax = LM.Vector2:new_local()
MR_AnimatePoints.lastScaling = LM.Vector2:new_local()
MR_AnimatePoints.timeTreshold = 1.5
MR_AnimatePoints.time = os.clock()
MR_AnimatePoints.updateTime = os.clock()
MR_AnimatePoints.updateInterval = 1
MR_AnimatePoints.bboxLength = 0
MR_AnimatePoints.cursorToPointDistance = 18
MR_AnimatePoints.selectedPointM = 0.25
MR_AnimatePoints.selectedCurverM = 0.3
MR_AnimatePoints.selectedWarpM = 0.24
MR_AnimatePoints.nonSelectedM = 0.2

-- **************************************************
-- The guts of this script
-- **************************************************

function MR_AnimatePoints:IsEnabled(moho)
	return true
end

function MR_AnimatePoints:IsRelevant(moho)
	return true
end

-- **************************************************
-- ConvertInterpolationDialog
-- **************************************************

local MR_ConvertInterpolationDialog = {}

MR_ConvertInterpolationDialog.SMOOTH = MOHO.MSG_BASE
MR_ConvertInterpolationDialog.LINEAR = MOHO.MSG_BASE + 1
MR_ConvertInterpolationDialog.STEP = MOHO.MSG_BASE + 2
MR_ConvertInterpolationDialog.NOISY = MOHO.MSG_BASE + 3
MR_ConvertInterpolationDialog.CONVERT_INTERPOLATION = MOHO.MSG_BASE + 4
MR_ConvertInterpolationDialog.INTERVAL_1 = MOHO.MSG_BASE + 5
MR_ConvertInterpolationDialog.INTERVAL_2 = MOHO.MSG_BASE + 6
MR_ConvertInterpolationDialog.INTERVAL_3 = MOHO.MSG_BASE + 7
MR_ConvertInterpolationDialog.INTERVAL_4 = MOHO.MSG_BASE + 8
MR_ConvertInterpolationDialog.CONVERT_INTERVAL = MOHO.MSG_BASE + 9

function MR_ConvertInterpolationDialog:new()
	local d = LM.GUI.SimpleDialog(MR_AnimatePoints:Localize('UILabel'), MR_ConvertInterpolationDialog)
	local l = d:GetLayout()

	l:PushH()
	l:PushV()
	l:AddChild(LM.GUI.StaticText(MR_AnimatePoints:Localize('Interpolation')), LM.GUI.ALIGN_LEFT, 0)

	l:AddPadding(-10)

	d.smoothRadioButton = LM.GUI.RadioButton(MR_AnimatePoints:Localize('Smooth'), d.SMOOTH)
	l:AddChild(d.smoothRadioButton, LM.GUI.ALIGN_LEFT, 0)

	l:AddPadding(-10)

	d.linearRadioButton = LM.GUI.RadioButton(MR_AnimatePoints:Localize('Linear'), d.LINEAR)
	l:AddChild(d.linearRadioButton, LM.GUI.ALIGN_LEFT, 0)

	l:AddPadding(-10)

	d.stepRadioButton = LM.GUI.RadioButton(MR_AnimatePoints:Localize('Step'), d.STEP)
	l:AddChild(d.stepRadioButton, LM.GUI.ALIGN_LEFT, 0)

	l:AddPadding(-10)

	d.noisyRadioButton = LM.GUI.RadioButton(MR_AnimatePoints:Localize('Noisy'), d.NOISY)
	l:AddChild(d.noisyRadioButton, LM.GUI.ALIGN_LEFT, 0)

	l:AddPadding(-10)

	d.convertInterpolationButton = LM.GUI.Button(MR_AnimatePoints:Localize('Convert'), d.CONVERT_INTERPOLATION)
	l:AddChild(d.convertInterpolationButton, LM.GUI.ALIGN_FILL, 0)
	l:Pop()

	l:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL)

	l:PushV()
	l:AddChild(LM.GUI.StaticText(MR_AnimatePoints:Localize('Interval')), LM.GUI.ALIGN_CENTER, 0)

	l:AddPadding(-10)

	d.interval1RadioButton = LM.GUI.RadioButton(MR_AnimatePoints:Localize('Inteval ')..1, d.INTERVAL_1)
	l:AddChild(d.interval1RadioButton, LM.GUI.ALIGN_LEFT, 0)

	l:AddPadding(-10)

	d.interval2RadioButton = LM.GUI.RadioButton(MR_AnimatePoints:Localize('Inteval ')..2, d.INTERVAL_2)
	l:AddChild(d.interval2RadioButton, LM.GUI.ALIGN_LEFT, 0)

	l:AddPadding(-10)

	d.interval3RadioButton = LM.GUI.RadioButton(MR_AnimatePoints:Localize('Inteval ')..3, d.INTERVAL_3)
	l:AddChild(d.interval3RadioButton, LM.GUI.ALIGN_LEFT, 0)

	l:AddPadding(-10)

	d.interval4RadioButton = LM.GUI.RadioButton(MR_AnimatePoints:Localize('Inteval ')..4, d.INTERVAL_4)
	l:AddChild(d.interval4RadioButton, LM.GUI.ALIGN_FILL, 0)

	l:AddPadding(-10)

	d.convertIntervalButton = LM.GUI.Button(MR_AnimatePoints:Localize('Convert'), d.CONVERT_INTERVAL)
	l:AddChild(d.convertIntervalButton, LM.GUI.ALIGN_FILL, 0)
	l:Pop()
	l:Pop()

	return d
end

function MR_ConvertInterpolationDialog:UpdateWidgets(moho)
	self.smoothRadioButton:SetValue(MR_AnimatePoints.smooth)
	self.linearRadioButton:SetValue(MR_AnimatePoints.linear)
	self.stepRadioButton:SetValue(MR_AnimatePoints.step)
	self.noisyRadioButton:SetValue(MR_AnimatePoints.noisy)

	self.interval1RadioButton:SetValue(MR_AnimatePoints.interval == 1)
	self.interval2RadioButton:SetValue(MR_AnimatePoints.interval == 2)
	self.interval3RadioButton:SetValue(MR_AnimatePoints.interval == 3)
	self.interval4RadioButton:SetValue(MR_AnimatePoints.interval == 4)
end

function MR_ConvertInterpolationDialog:OnOK(moho)
	MR_AnimatePoints.smooth = self.smoothRadioButton:Value()
	MR_AnimatePoints.linear = self.linearRadioButton:Value()
	MR_AnimatePoints.step = self.stepRadioButton:Value()
	MR_AnimatePoints.noisy = self.noisyRadioButton:Value()

	if self.interval1RadioButton:Value() == 1 then
		MR_AnimatePoints.interval = 1
	elseif self.interval2RadioButton:Value() == 2 then
		MR_AnimatePoints.interval = 2
	elseif self.interval3RadioButton:Value() == 3 then
		MR_AnimatePoints.interval = 3
	elseif self.interval4RadioButton:Value() == 4 then
		MR_AnimatePoints.interval = 4
	end
end

function MR_ConvertInterpolationDialog:HandleMessage(msg)
	if msg == self.SMOOTH then
		MR_AnimatePoints.smooth = self.smoothRadioButton:Value()
	elseif msg == self.LINEAR then
		MR_AnimatePoints.linear = self.linearRadioButton:Value()
	elseif msg == self.STEP then
		MR_AnimatePoints.step = self.stepRadioButton:Value()
	elseif msg == self.NOISY then
		MR_AnimatePoints.noisy = self.noisyRadioButton:Value()
	elseif msg == self.CONVERT_INTERPOLATION then
		MR_AnimatePoints.smooth = self.smoothRadioButton:Value()
		MR_AnimatePoints.linear = self.linearRadioButton:Value()
		MR_AnimatePoints.step = self.stepRadioButton:Value()
		MR_AnimatePoints.noisy = self.noisyRadioButton:Value()

		MR_AnimatePoints:ConvertInterpolation(false)
	elseif msg == self.CONVERT_INTERVAL then
		if self.interval1RadioButton:Value() == 1 then
			MR_AnimatePoints.interval = 1
		elseif self.interval2RadioButton:Value() == 2 then
			MR_AnimatePoints.interval = 2
		elseif self.interval3RadioButton:Value() == 3 then
			MR_AnimatePoints.interval = 3
		elseif self.interval4RadioButton:Value() == 4 then
			MR_AnimatePoints.interval = 4
		end

		MR_AnimatePoints:ConvertInterpolation(true)
	elseif msg == self.INTERVAL_1 then
		MR_AnimatePoints.interval = 1
	elseif msg == self.INTERVAL_2 then
		MR_AnimatePoints.interval = 2
	elseif msg == self.INTERVAL_3 then
		MR_AnimatePoints.interval = 3
	elseif msg == self.INTERVAL_4 then
		MR_AnimatePoints.interval = 4
	end
end

-- **************************************************
-- KeyframseSettingsDialog
-- **************************************************

local KeyframseSettingsDialog = {}

KeyframseSettingsDialog.PROCESS_ISOLATED_LAYERS_ONLY = MOHO.MSG_BASE
KeyframseSettingsDialog.PROCESS_SELECTED_POINTS_ONLY = MOHO.MSG_BASE + 1
KeyframseSettingsDialog.PROCESS_VISIBLE_LAYERS_ONLY_KEYFRAMING = MOHO.MSG_BASE + 2
KeyframseSettingsDialog.CONSIDER_WARP_MODE = MOHO.MSG_BASE + 3

function KeyframseSettingsDialog:new()
	local d = LM.GUI.SimpleDialog(MR_AnimatePoints:Localize('UILabel'), KeyframseSettingsDialog)
	local l = d:GetLayout()

	d.processSelectedPointsOnlyCheck = LM.GUI.CheckBox(MR_AnimatePoints:Localize("Process selected points only"), self.PROCESS_SELECTED_POINTS_ONLY)
	l:AddChild(d.processSelectedPointsOnlyCheck, LM.GUI.ALIGN_LEFT, 0)

	d.processIsolatedLayersOnlyCheck = LM.GUI.CheckBox(MR_AnimatePoints:Localize("Process isolated layers only"), self.PROCESS_ISOLATED_LAYERS_ONLY)
	l:AddChild(d.processIsolatedLayersOnlyCheck, LM.GUI.ALIGN_LEFT, 0)

	d.processVisibleLayersOnlyKeyframingCheck = LM.GUI.CheckBox(MR_AnimatePoints:Localize("Process visible layers only"), self.PROCESS_VISIBLE_LAYERS_ONLY_KEYFRAMING)
	l:AddChild(d.processVisibleLayersOnlyKeyframingCheck, LM.GUI.ALIGN_LEFT, 0)

	d.considerWarpModeCheck = LM.GUI.CheckBox(MR_AnimatePoints:Localize("Consider warp mode"), self.CONSIDER_WARP_MODE)
	l:AddChild(d.considerWarpModeCheck, LM.GUI.ALIGN_LEFT, 0)

	return d
end

function KeyframseSettingsDialog:UpdateWidgets(moho)
	self.processSelectedPointsOnlyCheck:SetValue(MR_AnimatePoints.processSelectedPointsOnly)
	self.processIsolatedLayersOnlyCheck:SetValue(MR_AnimatePoints.processIsolatedLayersOnly)
	self.processVisibleLayersOnlyKeyframingCheck:SetValue(MR_AnimatePoints.visibleLayersOnlyKeyframing)
	self.considerWarpModeCheck:SetValue(MR_AnimatePoints.considerWarpMode)
end

function KeyframseSettingsDialog:OnOK(moho)
	self.processSelectedPointsOnlyCheck:SetValue(MR_AnimatePoints.processSelectedPointsOnly)
	self.processIsolatedLayersOnlyCheck:SetValue(MR_AnimatePoints.processIsolatedLayersOnly)
	self.processVisibleLayersOnlyKeyframingCheck:SetValue(MR_AnimatePoints.visibleLayersOnlyKeyframing)
	self.considerWarpModeCheck:SetValue(MR_AnimatePoints.considerWarpMode)
end

function KeyframseSettingsDialog:HandleMessage(msg)
	if msg == self.PROCESS_SELECTED_POINTS_ONLY then
		MR_AnimatePoints.processSelectedPointsOnly = self.processSelectedPointsOnlyCheck:Value()
	elseif msg == self.PROCESS_ISOLATED_LAYERS_ONLY then
		MR_AnimatePoints.processIsolatedLayersOnly = self.processIsolatedLayersOnlyCheck:Value()
	elseif msg == self.PROCESS_VISIBLE_LAYERS_ONLY_KEYFRAMING then
		MR_AnimatePoints.visibleLayersOnlyKeyframing = self.processVisibleLayersOnlyKeyframingCheck:Value()
	elseif msg == self.CONSIDER_WARP_MODE then
		MR_AnimatePoints.considerWarpMode = self.considerWarpModeCheck:Value()
	end
end

-- **************************************************
-- MR_AnimatePointsPanelDialog
-- **************************************************

local MR_AnimatePointsPanelDialog = {}
MR_AnimatePointsPanelDialog.UPDATE_REFERENCE_LAYERS = MOHO.MSG_BASE
MR_AnimatePointsPanelDialog.UPDATE_CACHED_LAYERS = MOHO.MSG_BASE + 1
MR_AnimatePointsPanelDialog.KEYFRAMES_TO_MARKERS = MOHO.MSG_BASE + 2
MR_AnimatePointsPanelDialog.MARKERS_TO_KEYFRAMES = MOHO.MSG_BASE + 3
MR_AnimatePointsPanelDialog.COPY_FRAME = MOHO.MSG_BASE + 4
MR_AnimatePointsPanelDialog.PASTE_FRAME = MOHO.MSG_BASE + 5
MR_AnimatePointsPanelDialog.PASTE_FRAME_ALT = MOHO.MSG_BASE + 6
MR_AnimatePointsPanelDialog.COPY_PREVIOUS_KEY = MOHO.MSG_BASE + 7
MR_AnimatePointsPanelDialog.COPY_PREVIOUS_KEY_ALT = MOHO.MSG_BASE + 8
MR_AnimatePointsPanelDialog.CREATE_KEY = MOHO.MSG_BASE + 9
MR_AnimatePointsPanelDialog.CREATE_KEY_ALT = MOHO.MSG_BASE + 10
MR_AnimatePointsPanelDialog.COPY_NEXT_KEY = MOHO.MSG_BASE + 11
MR_AnimatePointsPanelDialog.COPY_NEXT_KEY_ALT = MOHO.MSG_BASE + 12
MR_AnimatePointsPanelDialog.RESET_POINTS = MOHO.MSG_BASE + 13
MR_AnimatePointsPanelDialog.RESET_POINTS_ALT = MOHO.MSG_BASE + 14
MR_AnimatePointsPanelDialog.DELETE_POINTS_KEYFRAME = MOHO.MSG_BASE + 15
MR_AnimatePointsPanelDialog.CLEAR_POINTS_ANIMATION = MOHO.MSG_BASE + 16
MR_AnimatePointsPanelDialog.CLEAR_POINTS_ANIMATION_ALT = MOHO.MSG_BASE + 17

MR_AnimatePointsPanelDialog.SELECTION_SLOT_1 = MOHO.MSG_BASE + 18
MR_AnimatePointsPanelDialog.SELECTION_SLOT_1_ALT = MOHO.MSG_BASE + 19
MR_AnimatePointsPanelDialog.SELECTION_SLOT_2 = MOHO.MSG_BASE + 20
MR_AnimatePointsPanelDialog.SELECTION_SLOT_2_ALT = MOHO.MSG_BASE + 21
MR_AnimatePointsPanelDialog.SELECTION_SLOT_3 = MOHO.MSG_BASE + 22
MR_AnimatePointsPanelDialog.SELECTION_SLOT_3_ALT = MOHO.MSG_BASE + 23
MR_AnimatePointsPanelDialog.SELECTION_SLOT_4 = MOHO.MSG_BASE + 24
MR_AnimatePointsPanelDialog.SELECTION_SLOT_4_ALT = MOHO.MSG_BASE + 25
MR_AnimatePointsPanelDialog.SELECTION_SLOT_5 = MOHO.MSG_BASE + 26
MR_AnimatePointsPanelDialog.SELECTION_SLOT_5_ALT = MOHO.MSG_BASE + 27

MR_AnimatePointsPanelDialog.SELECT_CONNECTED = MOHO.MSG_BASE + 28
MR_AnimatePointsPanelDialog.SELECT_CONNECTED_ALT = MOHO.MSG_BASE + 29

function MR_AnimatePointsPanelDialog:new()
	local d = LM.GUI.SimpleDialog(MR_AnimatePoints:Localize('UILabel'), MR_AnimatePointsPanelDialog)
	local l = d:GetLayout()

	l:PushH()
		d.selectConnectedCheck = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_select_connected", MR_AnimatePoints:Localize('Select connected points'), true, d.SELECT_CONNECTED, false)
		d.selectConnectedCheck:SetAlternateMessage(d.SELECT_CONNECTED_ALT)
		l:AddChild(d.selectConnectedCheck)

		d.updateReferenceLayersButton = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_update_ref", MR_AnimatePoints:Localize('Update reference layers'), false, d.UPDATE_REFERENCE_LAYERS, false)
		l:AddChild(d.updateReferenceLayersButton)
	
		d.updateCachedLayersButton = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_update_cache", MR_AnimatePoints:Localize('Update cached layers'), false, d.UPDATE_CACHED_LAYERS, false)
		l:AddChild(d.updateCachedLayersButton)

		l:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL)

		d.keyframesSettingsDialog = KeyframseSettingsDialog:new()
		d.keyframesSettingsPopup = LM.GUI.PopupDialog(MR_AnimatePoints:Localize('Keyframes settings'), false, 0)
		d.keyframesSettingsPopup:SetDialog(d.keyframesSettingsDialog)
		l:AddChild(d.keyframesSettingsPopup, LM.GUI.ALIGN_LEFT, 0)

		d.keyframesToMarkersButton = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_keyframes_to_markers", MR_AnimatePoints:Localize('Keyframes to markers'), false, d.KEYFRAMES_TO_MARKERS, false)
		l:AddChild(d.keyframesToMarkersButton)

		d.markersToKeyframesButton = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_markers_to_keyframes", MR_AnimatePoints:Localize('Markers to keyframes'), false, d.MARKERS_TO_KEYFRAMES, false)
		l:AddChild(d.markersToKeyframesButton)

		d.convertInterpolationDialog = MR_ConvertInterpolationDialog:new()
		d.convertInterpolationPopup = LM.GUI.PopupDialog(MR_AnimatePoints:Localize('Convert interpolation'), false, 0)
		d.convertInterpolationPopup:SetDialog(d.convertInterpolationDialog)
		l:AddChild(d.convertInterpolationPopup, LM.GUI.ALIGN_LEFT, 0)
	l:Pop()

	l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

	l:PushH()
		l:AddPadding(8)

		d.copyFrameButton = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_copy", MR_AnimatePoints:Localize('Copy frame'), false, d.COPY_FRAME, false)
		l:AddChild(d.copyFrameButton)

		d.pasteFrameButton = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_paste", MR_AnimatePoints:Localize('Paste frame'), false, d.PASTE_FRAME, false)
		d.pasteFrameButton:SetAlternateMessage(d.PASTE_FRAME_ALT)
		l:AddChild(d.pasteFrameButton)

		l:AddPadding(4)

		d.copyPreviousKeyButton = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_copy_prev", MR_AnimatePoints:Localize('Copy previous key'), false, d.COPY_PREVIOUS_KEY, false)
		d.copyPreviousKeyButton:SetAlternateMessage(d.COPY_PREVIOUS_KEY_ALT)
		l:AddChild(d.copyPreviousKeyButton)

		d.createKeyButton = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_create_key", MR_AnimatePoints:Localize('Create key'), false, d.CREATE_KEY, false)
		d.createKeyButton:SetAlternateMessage(d.CREATE_KEY_ALT)
		l:AddChild(d.createKeyButton)

		d.copyNextKeyButton = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_copy_next", MR_AnimatePoints:Localize('Copy next key'), false, d.COPY_NEXT_KEY, false)
		d.copyNextKeyButton:SetAlternateMessage(d.COPY_NEXT_KEY_ALT)
		l:AddChild(d.copyNextKeyButton)

		l:AddPadding(4)

		d.resetPointsButton = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_reset_points", MR_AnimatePoints:Localize('Reset points'), false, d.RESET_POINTS, false)
		d.resetPointsButton:SetAlternateMessage(d.RESET_POINTS_ALT)
		l:AddChild(d.resetPointsButton)

		d.deletePointsKeyframeButton = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_delete_points_keyframe", MR_AnimatePoints:Localize('Delete points keyframe'), false, d.DELETE_POINTS_KEYFRAME, false)
		l:AddChild(d.deletePointsKeyframeButton)

		d.clearPointsAnimationButton = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_clear_points_animation", MR_AnimatePoints:Localize('Clear points animation'), false, d.CLEAR_POINTS_ANIMATION, false)
		d.clearPointsAnimationButton:SetAlternateMessage(d.CLEAR_POINTS_ANIMATION_ALT)
		l:AddChild(d.clearPointsAnimationButton)

		l:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL)

		d.selectionSlot1Button = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_slot_button_1", MR_AnimatePoints:Localize('Selection slot 1'), false, d.SELECTION_SLOT_1, false)
		d.selectionSlot1Button:SetAlternateMessage(d.SELECTION_SLOT_1_ALT)
		l:AddChild(d.selectionSlot1Button)

		l:AddPadding(-14)

		d.selectionSlot2Button = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_slot_button_2", MR_AnimatePoints:Localize('Selection slot 2'), false, d.SELECTION_SLOT_2, false)
		d.selectionSlot2Button:SetAlternateMessage(d.SELECTION_SLOT_2_ALT)
		l:AddChild(d.selectionSlot2Button)

		l:AddPadding(-14)

		d.selectionSlot3Button = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_slot_button_3", MR_AnimatePoints:Localize('Selection slot 3'), false, d.SELECTION_SLOT_3, false)
		d.selectionSlot3Button:SetAlternateMessage(d.SELECTION_SLOT_3_ALT)
		l:AddChild(d.selectionSlot3Button)

		l:AddPadding(-14)

		d.selectionSlot4Button = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_slot_button_4", MR_AnimatePoints:Localize('Selection slot 4'), false, d.SELECTION_SLOT_4, false)
		d.selectionSlot4Button:SetAlternateMessage(d.SELECTION_SLOT_4_ALT)
		l:AddChild(d.selectionSlot4Button)

		l:AddPadding(-14)

		d.selectionSlot5Button = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_slot_button_5", MR_AnimatePoints:Localize('Selection slot 5'), false, d.SELECTION_SLOT_5, false)
		d.selectionSlot5Button:SetAlternateMessage(d.SELECTION_SLOT_5_ALT)
		l:AddChild(d.selectionSlot5Button)
	l:Pop()

	return d
end

function MR_AnimatePointsPanelDialog:UpdateWidgets(moho)
	self.selectConnectedCheck:SetValue(MR_AnimatePoints.autoConnectSelected)
	self.selectConnectedCheck:Enable(MR_AnimatePoints.selectPoints)

	if MR_AnimatePoints.copiedFrame then
		self.pasteFrameButton:Enable(true)
	else
		self.pasteFrameButton:Enable(false)	
	end
end

function MR_AnimatePointsPanelDialog:OnOK(moho)
	MR_AnimatePoints.animatePointsPanelDlog = nil
end

function MR_AnimatePointsPanelDialog:HandleMessage(msg)
	local helper = MOHO.ScriptInterfaceHelper:new_local()
	local moho = helper:MohoObject()
	if moho.document == nil then
		helper:delete()
		return
	end
	if msg == self.UPDATE_REFERENCE_LAYERS then
		MR_AnimatePoints:UpdateReferenceLayers(moho)
	elseif msg == self.UPDATE_CACHED_LAYERS then
		self.currentQualityFlags = moho.view:QualityFlags()
		local wireframe = MOHO.hasbit(moho.view:QualityFlags(), MOHO.LDQ_WIREFRAME)
		if wireframe then
			moho.view:SetQualityFlags(self.currentQualityFlags - MOHO.LDQ_WIREFRAME)
		end
		local curLayer = moho.layer
		local layersList = {}
		local count = 0
		repeat
			local layer = moho.document:LayerByAbsoluteID(count)
			if layer then
				if layer:SecondarySelection() or layer:IsAncestorSelected() or layer == moho.layer then
					local vectorLayer = moho:LayerAsVector(layer)
					if vectorLayer then
						table.insert(layersList, count)
					end
				end
			end
			count = count + 1
		until not layer

		for i, layerIndex in ipairs(layersList) do
			local layer = moho.document:LayerByAbsoluteID(layerIndex)
			moho:SetSelLayer(layer)
			moho.view:DrawMe()
			layer:FreeCachedImage()
		end
		moho.view:SetQualityFlags(self.currentQualityFlags)

		moho:SetSelLayer(curLayer)
		moho:UpdateUI()
	elseif msg == self.KEYFRAMES_TO_MARKERS then
		MR_AnimatePoints:KeyframesToMarkers(moho)
	elseif msg == self.MARKERS_TO_KEYFRAMES then
		MR_AnimatePoints:MarkersToKeyframes(moho)
	elseif msg == self.COPY_FRAME then
		MR_AnimatePoints.copiedFrame = moho.frame
		self.pasteFrameButton:Enable(true)
		if moho:CurrentTool() == 'MR_AnimatePoints' then
			MR_AnimatePoints:UpdateWidgets(moho)
		end
		self:UpdateWidgets(moho)
	elseif msg == self.PASTE_FRAME then
		MR_AnimatePoints:PasteFrame(moho, false)
	elseif msg == self.PASTE_FRAME_ALT then
		MR_AnimatePoints:PasteFrame(moho, true)
	elseif msg == self.COPY_PREVIOUS_KEY then
		MR_AnimatePoints:CreateKey(moho, 0, false)
	elseif msg == self.COPY_PREVIOUS_KEY_ALT then
		MR_AnimatePoints:CreateKey(moho, 0, true)
	elseif msg == self.CREATE_KEY then
		MR_AnimatePoints:CreateKey(moho, 1, false)
	elseif msg == self.CREATE_KEY_ALT then
		MR_AnimatePoints:CreateKey(moho, 1, true)
	elseif msg == self.COPY_NEXT_KEY then
		MR_AnimatePoints:CreateKey(moho, 2, false)
	elseif msg == self.COPY_NEXT_KEY_ALT then
		MR_AnimatePoints:CreateKey(moho, 2, true)
	elseif msg == self.RESET_POINTS then
		MR_AnimatePoints:ResetPointsInLayers(moho, false)
	elseif msg == self.RESET_POINTS_ALT then
		MR_AnimatePoints:ResetPointsInLayers(moho, true)
	elseif msg == self.DELETE_POINTS_KEYFRAME then
		MR_AnimatePoints:DeletePointsKeys(moho, false)
	elseif msg == self.DELETE_POINTS_KEYFRAME_ALT then
		MR_AnimatePoints:DeletePointsKeys(moho, true)
	elseif msg == self.CLEAR_POINTS_ANIMATION then
		MR_AnimatePoints:ClearKeyframes(moho, false)
	elseif msg == self.CLEAR_POINTS_ANIMATION_ALT then
		MR_AnimatePoints:ClearKeyframes(moho, true)
	elseif msg == self.SELECTION_SLOT_1 then
		MR_AnimatePoints:SetSelection(moho, 1)
		moho.view:DrawMe()
	elseif msg == self.SELECTION_SLOT_1_ALT then
		MR_AnimatePoints:GetSelection(moho, 1)
	elseif msg == self.SELECTION_SLOT_2 then
		MR_AnimatePoints:SetSelection(moho, 2)
		moho.view:DrawMe()
	elseif msg == self.SELECTION_SLOT_2_ALT then
		MR_AnimatePoints:GetSelection(moho, 2)
	elseif msg == self.SELECTION_SLOT_3 then
		MR_AnimatePoints:SetSelection(moho, 3)
		moho.view:DrawMe()
	elseif msg == self.SELECTION_SLOT_3_ALT then
		MR_AnimatePoints:GetSelection(moho, 3)
	elseif msg == self.SELECTION_SLOT_4 then
		MR_AnimatePoints:SetSelection(moho, 4)
		moho.view:DrawMe()
	elseif msg == self.SELECTION_SLOT_4_ALT then
		MR_AnimatePoints:GetSelection(moho, 4)
	elseif msg == self.SELECTION_SLOT_5 then
		MR_AnimatePoints:SetSelection(moho, 5)
		moho.view:DrawMe()
	elseif msg == self.SELECTION_SLOT_5_ALT then
		MR_AnimatePoints:GetSelection(moho, 5)
	elseif msg == self.SELECT_CONNECTED then
		MR_AnimatePoints:SelectConnectedPoints(moho)
		self.selectConnectedCheck:SetValue(MR_AnimatePoints.autoConnectSelected)
	elseif msg == self.SELECT_CONNECTED_ALT then
		MR_AnimatePoints.autoConnectSelected = not MR_AnimatePoints.autoConnectSelected
		self.selectConnectedCheck:SetValue(MR_AnimatePoints.autoConnectSelected)
		if moho:CurrentTool() == 'MR_AnimatePoints' then
			MR_AnimatePoints:UpdateWidgets(moho)
		end
	end
	helper:delete()
end

-- **************************************************
-- SettingsDialog
-- **************************************************

local MR_SettingsDialog = {}

MR_SettingsDialog.VISIBLE_LAYERS_ONLY = MOHO.MSG_BASE
MR_SettingsDialog.HIDE_CURVES_WHILE_DRAGGING = MOHO.MSG_BASE + 1
MR_SettingsDialog.EXTRA_HANDLES = MOHO.MSG_BASE + 2
MR_SettingsDialog.GUI_COLOR = MOHO.MSG_BASE + 3
MR_SettingsDialog.DRAW_POINTS = MOHO.MSG_BASE + 4
MR_SettingsDialog.DRAW_POINTS_WHILE_DRAGGING = MOHO.MSG_BASE + 5
MR_SettingsDialog.USE_SINGLE_COLOR = MOHO.MSG_BASE + 6
MR_SettingsDialog.POINTS_COLOR = MOHO.MSG_BASE + 7
MR_SettingsDialog.WARP_OPACITY = MOHO.MSG_BASE + 8
MR_SettingsDialog.POINTS_OPACITY = MOHO.MSG_BASE + 9
MR_SettingsDialog.POINTS_SIZE = MOHO.MSG_BASE + 10
MR_SettingsDialog.SENSITIVITY = MOHO.MSG_BASE + 11
MR_SettingsDialog.BLEND_SENSITIVITY = MOHO.MSG_BASE + 12
MR_SettingsDialog.BLOCK_ON_EVEN_FRAMES = MOHO.MSG_BASE + 13
MR_SettingsDialog.BLOCK_ON_ODD_FRAMES = MOHO.MSG_BASE + 14
MR_SettingsDialog.IGNORE_REFERENCE_LAYERS = MOHO.MSG_BASE + 15
MR_SettingsDialog.AUTO_UPDATE_REFERENCE_LAYERS = MOHO.MSG_BASE + 16
MR_SettingsDialog.LONG_PRESS_TIME = MOHO.MSG_BASE + 17
MR_SettingsDialog.RESET_SETTINGS = MOHO.MSG_BASE + 18

function MR_SettingsDialog:new()
	local d = LM.GUI.SimpleDialog(MR_AnimatePoints:Localize('UILabel'), MR_SettingsDialog)
	local l = d:GetLayout()

	d.visibleLayersOnlyCheck = LM.GUI.CheckBox(MR_AnimatePoints:Localize('Visible layers only'), self.VISIBLE_LAYERS_ONLY)
	l:AddChild(d.visibleLayersOnlyCheck, LM.GUI.ALIGN_LEFT, 0)

	l:AddPadding(-10)

	d.hideCurvesWhileDraggingCheck = LM.GUI.CheckBox(MR_AnimatePoints:Localize('Hide curves while dragging'), self.HIDE_CURVES_WHILE_DRAGGING)
	l:AddChild(d.hideCurvesWhileDraggingCheck, LM.GUI.ALIGN_LEFT, 0)

	l:AddPadding(-10)

	d.extraHandlesCheck = LM.GUI.CheckBox(MR_AnimatePoints:Localize('Extra handles'), self.EXTRA_HANDLES)
	l:AddChild(d.extraHandlesCheck, LM.GUI.ALIGN_LEFT, 0)

	l:AddPadding(-10)

	l:PushH()
		d.guiColorText = LM.GUI.DynamicText(MR_AnimatePoints:Localize('GUI color:'), 0)
		l:AddChild(d.guiColorText, LM.GUI.ALIGN_CENTER, 0)

		d.guiColorSwatch = LM.GUI.ShortColorSwatch(true, self.GUI_COLOR)
		l:AddChild(d.guiColorSwatch, LM.GUI.ALIGN_LEFT)
	l:Pop()

	l:AddPadding(-10)

	l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

	l:AddPadding(-10)

	d.drawPointsCheck = LM.GUI.CheckBox(MR_AnimatePoints:Localize('Draw points'), self.DRAW_POINTS)
	l:AddChild(d.drawPointsCheck, LM.GUI.ALIGN_LEFT, 0)

	l:AddPadding(-10)

	d.drawPointsWhileDraggingCheck = LM.GUI.CheckBox(MR_AnimatePoints:Localize('Draw points while dragging'), self.DRAW_POINTS_WHILE_DRAGGING)
	l:AddChild(d.drawPointsWhileDraggingCheck, LM.GUI.ALIGN_LEFT, 0)

	l:PushH()
		d.useSingleColorCheck = LM.GUI.CheckBox(MR_AnimatePoints:Localize('Use single color'), self.USE_SINGLE_COLOR)
		l:AddChild(d.useSingleColorCheck, LM.GUI.ALIGN_LEFT, 0)

		d.pointsColorSwatch = LM.GUI.ShortColorSwatch(true, self.POINTS_COLOR)
		l:AddChild(d.pointsColorSwatch, LM.GUI.ALIGN_LEFT)
	l:Pop()

	l:AddPadding(-10)

	l:PushH()
		l:AddChild(LM.GUI.StaticText(MR_AnimatePoints:Localize('Warp opacity')))
		d.warpOpacityInput = LM.GUI.TextControl(133, '', self.WARP_OPACITY, LM.GUI.FIELD_UFLOAT)
		d.warpOpacityInput:SetWheelInc(0.01)
		d.warpOpacityInput:SetMaxDecimalPlaces(1)
		l:AddChild(d.warpOpacityInput)
	l:Pop()

	l:AddPadding(-10)

	l:PushH()
		l:AddChild(LM.GUI.StaticText(MR_AnimatePoints:Localize('Points opacity')))
		d.pointsOpacityInput = LM.GUI.TextControl(121, '', self.POINTS_OPACITY, LM.GUI.FIELD_UFLOAT)
		d.pointsOpacityInput:SetWheelInc(0.01)
		d.pointsOpacityInput:SetMaxDecimalPlaces(1)
		l:AddChild(d.pointsOpacityInput)
	l:Pop()

	l:AddPadding(-10)

	l:PushH()
		l:AddChild(LM.GUI.StaticText(MR_AnimatePoints:Localize('Points size')))
		d.pointsSizeInput = LM.GUI.TextControl(148, '', self.POINTS_SIZE, LM.GUI.FIELD_UFLOAT)
		d.pointsSizeInput:SetWheelInc(0.1)
		d.pointsSizeInput:SetMaxDecimalPlaces(1)
		l:AddChild(d.pointsSizeInput)
	l:Pop()

	l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

	l:AddPadding(-10)

	l:PushH()
		l:AddChild(LM.GUI.StaticText(MR_AnimatePoints:Localize('Sensitivity')))
		d.sensitivityInput = LM.GUI.TextControl(150, '', self.SENSITIVITY, LM.GUI.FIELD_UFLOAT)
		d.sensitivityInput:SetWheelInc(0.01)
		d.sensitivityInput:SetMaxDecimalPlaces(1)
		l:AddChild(d.sensitivityInput)
	l:Pop()

	l:AddPadding(-10)

	l:PushH()
		l:AddChild(LM.GUI.StaticText(MR_AnimatePoints:Localize('Blend sensitivity')))
		d.blendSensitivityInput = LM.GUI.TextControl(118, '', self.BLEND_SENSITIVITY, LM.GUI.FIELD_UFLOAT)
		d.blendSensitivityInput:SetWheelInc(0.01)
		d.blendSensitivityInput:SetMaxDecimalPlaces(1)
		l:AddChild(d.blendSensitivityInput)
	l:Pop()

	l:AddPadding(-10)

	l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

	l:AddPadding(-10)

	d.blockOnEvenFramesCheck = LM.GUI.CheckBox(MR_AnimatePoints:Localize('Block on even frames'), self.BLOCK_ON_EVEN_FRAMES)
	l:AddChild(d.blockOnEvenFramesCheck, LM.GUI.ALIGN_LEFT, 0)

	l:AddPadding(-10)

	d.blockOnOddFramesCheck = LM.GUI.CheckBox(MR_AnimatePoints:Localize('Block on odd frames'), self.BLOCK_ON_ODD_FRAMES)
	l:AddChild(d.blockOnOddFramesCheck, LM.GUI.ALIGN_LEFT, 0)

	l:AddPadding(-10)

	l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

	l:AddPadding(-10)

	d.ignoreReferenceLayersCheck = LM.GUI.CheckBox(MR_AnimatePoints:Localize('Ignore reference layers'), self.IGNORE_REFERENCE_LAYERS)
	l:AddChild(d.ignoreReferenceLayersCheck, LM.GUI.ALIGN_LEFT, 0)

	l:AddPadding(-10)

	d.autoUpdateReferenceLayersCheck = LM.GUI.CheckBox(MR_AnimatePoints:Localize('Auto update reference layers'), self.AUTO_UPDATE_REFERENCE_LAYERS)
	l:AddChild(d.autoUpdateReferenceLayersCheck, LM.GUI.ALIGN_LEFT, 0)

	l:AddPadding(-10)

	l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

	l:AddPadding(-10)

	l:PushH()
		l:AddChild(LM.GUI.StaticText(MR_AnimatePoints:Localize('Long press time')))
		d.longPressTimeInput = LM.GUI.TextControl(119, '', self.LONG_PRESS_TIME, LM.GUI.FIELD_UFLOAT)
		d.longPressTimeInput:SetWheelInc(0.01)
		d.longPressTimeInput:SetMaxDecimalPlaces(1)
		l:AddChild(d.longPressTimeInput)
	l:Pop()

	d.resetSettingsButton = LM.GUI.Button(MR_AnimatePoints:Localize('Reset settings'), self.RESET_SETTINGS)
	l:AddChild(d.resetSettingsButton, LM.GUI.ALIGN_FILL, 0)

	return d
end

function MR_SettingsDialog:UpdateWidgets(moho)
	self.visibleLayersOnlyCheck:SetValue(MR_AnimatePoints.visibleLayersOnly)
	self.hideCurvesWhileDraggingCheck:SetValue(MR_AnimatePoints.hideCurvesWhileDragging)
	self.extraHandlesCheck:SetValue(MR_AnimatePoints.transformBoxExtraHandles)
	self.drawPointsCheck:SetValue(MR_AnimatePoints.drawPoints)
	self.drawPointsWhileDraggingCheck:SetValue(MR_AnimatePoints.drawPointsdrawPointsWhileDragging)
	self.drawPointsWhileDraggingCheck:Enable(MR_AnimatePoints.drawPoints)
	self.useSingleColorCheck:SetValue(MR_AnimatePoints.useSingleColor)
	self.useSingleColorCheck:Enable(MR_AnimatePoints.drawPoints)
	self.warpOpacityInput:SetValue(MR_AnimatePoints.warpOpacity)
	self.warpOpacityInput:Enable(MR_AnimatePoints.drawPoints)
	self.pointsSizeInput:SetValue(MR_AnimatePoints.pointsSize)
	self.pointsSizeInput:Enable(MR_AnimatePoints.drawPoints)
	self.pointsOpacityInput:SetValue(MR_AnimatePoints.pointsOpacity)
	self.pointsOpacityInput:Enable(MR_AnimatePoints.drawPoints)
	self.sensitivityInput:SetValue(MR_AnimatePoints.sensitivity)
	self.blendSensitivityInput:SetValue(MR_AnimatePoints.blendSensitivity)
	self.blockOnEvenFramesCheck:SetValue(MR_AnimatePoints.blockOnEvenFrames)
	self.blockOnOddFramesCheck:SetValue(MR_AnimatePoints.blockOnOddFrames)
	self.ignoreReferenceLayersCheck:SetValue(MR_AnimatePoints.ignoreReferenceLayers)
	self.autoUpdateReferenceLayersCheck:SetValue(MR_AnimatePoints.autoUpdateReferenceLayers)
	self.autoUpdateReferenceLayersCheck:Enable(MR_AnimatePoints.ignoreReferenceLayers)
	self.longPressTimeInput:SetValue(MR_AnimatePoints.longPressTime)

	local guiColor = LM.rgb_color:new_local()
	guiColor.r = MR_AnimatePoints.guiColorR
	guiColor.g = MR_AnimatePoints.guiColorG
	guiColor.b = MR_AnimatePoints.guiColorB
	guiColor.a = MR_AnimatePoints.guiColorA
	self.guiColorSwatch:SetValue(guiColor)

	local pointsColor = LM.rgb_color:new_local()
	pointsColor.r = MR_AnimatePoints.pointsColorR
	pointsColor.g = MR_AnimatePoints.pointsColorG
	pointsColor.b = MR_AnimatePoints.pointsColorB
	pointsColor.a = MR_AnimatePoints.pointsColorA

	self.pointsColorSwatch:SetValue(pointsColor)
	self.pointsColorSwatch:Enable(MR_AnimatePoints.drawPoints and MR_AnimatePoints.useSingleColor)
end

function MR_SettingsDialog:OnOK(moho)
	MR_AnimatePoints.visibleLayersOnly = self.visibleLayersOnlyCheck:Value()
	MR_AnimatePoints.hideCurvesWhileDragging = self.hideCurvesWhileDraggingCheck:Value()
	MR_AnimatePoints.transformBoxExtraHandles = self.extraHandlesCheck:Value()
	MR_AnimatePoints.drawPoints = self.drawPointsCheck:Value()
	MR_AnimatePoints.drawPointsdrawPointsWhileDragging = self.drawPointsWhileDraggingCheck:Value()
	MR_AnimatePoints.useSingleColor = self.useSingleColorCheck:Value()
	MR_AnimatePoints.warpOpacity = self.warpOpacityInput:Value()
	MR_AnimatePoints.pointsOpacity = self.pointsOpacityInput:Value()
	MR_AnimatePoints.pointsSize = self.pointsSizeInput:Value()
	MR_AnimatePoints.sensitivity = self.sensitivityInput:Value()
	MR_AnimatePoints.blendSensitivity = self.blendSensitivityInput:Value()
	MR_AnimatePoints.blockOnEvenFrames = self.blockOnEvenFramesCheck:Value()
	MR_AnimatePoints.blockOnOddFrames = self.blockOnOddFramesCheck:Value()
	MR_AnimatePoints.ignoreReferenceLayers = self.ignoreReferenceLayersCheck:Value()
	MR_AnimatePoints.autoUpdateReferenceLayers = self.autoUpdateReferenceLayersCheck:Value()
	MR_AnimatePoints.longPressTime = self.longPressTimeInput:FloatValue()
end

function MR_SettingsDialog:HandleMessage(msg)
	if msg == self.VISIBLE_LAYERS_ONLY then
		local helper = MOHO.ScriptInterfaceHelper:new_local()
		local moho = helper:MohoObject()
		MR_AnimatePoints.visibleLayersOnly = self.visibleLayersOnlyCheck:Value()
		MR_AnimatePoints:UpdateWidgets(moho)
		moho.view:DrawMe()
		helper:delete()
	elseif msg == self.HIDE_CURVES_WHILE_DRAGGING then
		MR_AnimatePoints.hideCurvesWhileDragging = self.hideCurvesWhileDraggingCheck:Value()
	elseif msg == self.EXTRA_HANDLES then
		local helper = MOHO.ScriptInterfaceHelper:new_local()
		local moho = helper:MohoObject()
		MR_AnimatePoints.transformBoxExtraHandles = self.extraHandlesCheck:Value()
		MR_AnimatePoints:UpdateWidgets(moho)
		moho.view:DrawMe()
		helper:delete()
	elseif msg == self.GUI_COLOR then
		local helper = MOHO.ScriptInterfaceHelper:new_local()
		local moho = helper:MohoObject()
		local colorSwatchValue = self.guiColorSwatch:Value()
		MR_AnimatePoints.guiColorR = colorSwatchValue.r
		MR_AnimatePoints.guiColorG = colorSwatchValue.g
		MR_AnimatePoints.guiColorB = colorSwatchValue.b
		MR_AnimatePoints.guiColorA = colorSwatchValue.a
		MR_AnimatePoints.guiColor = LM.rgb_color:new_local()
		MR_AnimatePoints.guiColor.r = MR_AnimatePoints.guiColorR
		MR_AnimatePoints.guiColor.g = MR_AnimatePoints.guiColorG
		MR_AnimatePoints.guiColor.b = MR_AnimatePoints.guiColorB
		MR_AnimatePoints.guiColor.a = MR_AnimatePoints.guiColorA
		MR_AnimatePoints:UpdateWidgets(moho)
		moho.view:DrawMe()
		helper:delete()
	elseif msg == self.DRAW_POINTS then
		local helper = MOHO.ScriptInterfaceHelper:new_local()
		local moho = helper:MohoObject()
		MR_AnimatePoints.drawPoints = self.drawPointsCheck:Value()
		self.drawPointsWhileDraggingCheck:Enable(MR_AnimatePoints.drawPoints)
		self.useSingleColorCheck:Enable(MR_AnimatePoints.drawPoints)
		self.pointsColorSwatch:Enable(MR_AnimatePoints.drawPoints and MR_AnimatePoints.useSingleColor)
		self.warpOpacityInput:Enable(MR_AnimatePoints.drawPoints)
		self.pointsOpacityInput:Enable(MR_AnimatePoints.drawPoints)
		self.pointsSizeInput:Enable(MR_AnimatePoints.drawPoints)
		MR_AnimatePoints:UpdateWidgets(moho)
		moho.view:DrawMe()
		helper:delete()
	elseif msg == self.DRAW_POINTS_WHILE_DRAGGING then
		MR_AnimatePoints.drawPointsdrawPointsWhileDragging = self.drawPointsWhileDraggingCheck:Value()
	elseif msg == self.USE_SINGLE_COLOR then
		local helper = MOHO.ScriptInterfaceHelper:new_local()
		local moho = helper:MohoObject()
		MR_AnimatePoints.useSingleColor = self.useSingleColorCheck:Value()
		self.pointsColorSwatch:Enable(MR_AnimatePoints.drawPoints and MR_AnimatePoints.useSingleColor)
		MR_AnimatePoints:UpdateWidgets(moho)
		moho.view:DrawMe()
		helper:delete()
	elseif msg == self.POINTS_COLOR then
		local helper = MOHO.ScriptInterfaceHelper:new_local()
		local moho = helper:MohoObject()
		local colorSwatchValue = self.pointsColorSwatch:Value()
		MR_AnimatePoints.pointsColorR = colorSwatchValue.r
		MR_AnimatePoints.pointsColorG = colorSwatchValue.g
		MR_AnimatePoints.pointsColorB = colorSwatchValue.b
		MR_AnimatePoints.pointsColorA = colorSwatchValue.a
		MR_AnimatePoints.pointsColor = LM.rgb_color:new_local()
		MR_AnimatePoints.pointsColor.r = MR_AnimatePoints.pointsColorR
		MR_AnimatePoints.pointsColor.g = MR_AnimatePoints.pointsColorG
		MR_AnimatePoints.pointsColor.b = MR_AnimatePoints.pointsColorB
		MR_AnimatePoints.pointsColor.a = MR_AnimatePoints.pointsColorA
		MR_AnimatePoints:UpdateWidgets(moho)
		moho.view:DrawMe()
		helper:delete()
	elseif msg == self.WARP_OPACITY then
		MR_AnimatePoints.warpOpacity = LM.Clamp(self.warpOpacityInput:Value(), 0.1, 1)
		self.warpOpacityInput:SetValue(MR_AnimatePoints.warpOpacity)
		local helper = MOHO.ScriptInterfaceHelper:new_local()
		local moho = helper:MohoObject()
		moho.view:DrawMe()
		helper:delete()
	elseif msg == self.POINTS_OPACITY then
		MR_AnimatePoints.pointsOpacity = LM.Clamp(self.pointsOpacityInput:Value(), 0.1, 1)
		self.pointsOpacityInput:SetValue(MR_AnimatePoints.pointsOpacity)
		local helper = MOHO.ScriptInterfaceHelper:new_local()
		local moho = helper:MohoObject()
		moho.view:DrawMe()
		helper:delete()
	elseif msg == self.POINTS_SIZE then
		MR_AnimatePoints.pointsSize = LM.Clamp(self.pointsSizeInput:Value(), 0.3, 5)
		self.pointsSizeInput:SetValue(MR_AnimatePoints.pointsSize)
		local helper = MOHO.ScriptInterfaceHelper:new_local()
		local moho = helper:MohoObject()
		moho.view:DrawMe()
		helper:delete()
	elseif msg == self.SENSITIVITY then
		MR_AnimatePoints.sensitivity = LM.Clamp(self.sensitivityInput:Value(), 0.1, 5)
		self.sensitivityInput:SetValue(MR_AnimatePoints.sensitivity)
	elseif msg == self.BLEND_SENSITIVITY then
		MR_AnimatePoints.blendSensitivity = LM.Clamp(self.blendSensitivityInput:Value(), 0.1, 5)
		self.blendSensitivityInput:SetValue(MR_AnimatePoints.blendSensitivity)
	elseif msg == self.BLOCK_ON_EVEN_FRAMES then
		MR_AnimatePoints.blockOnEvenFrames = self.blockOnEvenFramesCheck:Value()
	elseif msg == self.BLOCK_ON_ODD_FRAMES then
		MR_AnimatePoints.blockOnOddFrames = self.blockOnOddFramesCheck:Value()
	elseif msg == self.IGNORE_REFERENCE_LAYERS then
		MR_AnimatePoints.ignoreReferenceLayers = self.ignoreReferenceLayersCheck:Value()
		self.autoUpdateReferenceLayersCheck:Enable(MR_AnimatePoints.ignoreReferenceLayers)
	elseif msg == self.AUTO_UPDATE_REFERENCE_LAYERS then
		MR_AnimatePoints.autoUpdateReferenceLayers = self.autoUpdateReferenceLayersCheck:Value()
	elseif msg == self.LONG_PRESS_TIME then
		MR_AnimatePoints.longPressTime = LM.Clamp(self.longPressTimeInput:FloatValue(), 0.1, 5)
		self.longPressTimeInput:SetValue(MR_AnimatePoints.longPressTime)
	elseif msg == self.RESET_SETTINGS then
		local helper = MOHO.ScriptInterfaceHelper:new_local()
		local moho = helper:MohoObject()
		MR_AnimatePoints.visibleLayersOnly = true
		MR_AnimatePoints.hideCurvesWhileDragging = true
		MR_AnimatePoints.extraHandles = true

		MR_AnimatePoints.pointsColorR = 224
		MR_AnimatePoints.pointsColorG = 0
		MR_AnimatePoints.pointsColorB = 82
		MR_AnimatePoints.pointsColorA = 255
		MR_AnimatePoints.pointsColor = LM.rgb_color:new_local()
		MR_AnimatePoints.pointsColor.r = MR_AnimatePoints.pointsColorR
		MR_AnimatePoints.pointsColor.g = MR_AnimatePoints.pointsColorG
		MR_AnimatePoints.pointsColor.b = MR_AnimatePoints.pointsColorB
		MR_AnimatePoints.pointsColor.a = MR_AnimatePoints.pointsColorA

		MR_AnimatePoints.guiColorR = 224
		MR_AnimatePoints.guiColorG = 0
		MR_AnimatePoints.guiColorB = 82
		MR_AnimatePoints.guiColorA = 255
		MR_AnimatePoints.guiColor = LM.rgb_color:new_local()
		MR_AnimatePoints.guiColor.r = MR_AnimatePoints.guiColorR
		MR_AnimatePoints.guiColor.g = MR_AnimatePoints.guiColorG
		MR_AnimatePoints.guiColor.b = MR_AnimatePoints.guiColorB
		MR_AnimatePoints.guiColor.a = MR_AnimatePoints.guiColorA

		MR_AnimatePoints.drawPoints = true
		MR_AnimatePoints.drawPointsdrawPointsWhileDragging = true
		MR_AnimatePoints.useSingleColor = false
		MR_AnimatePoints.warpOpacity = 1
		MR_AnimatePoints.pointsOpacity = 1
		MR_AnimatePoints.pointsSize = 1
		MR_AnimatePoints.sensitivity = 1
		MR_AnimatePoints.blendSensitivity = 1
		MR_AnimatePoints.blockOnEvenFrames = true
		MR_AnimatePoints.blockOnOddFrames = false
		MR_AnimatePoints.ignoreReferenceLayers = false
		MR_AnimatePoints.autoUpdateReferenceLayers = true
		MR_AnimatePoints.longPressTime = 0.5
		self:UpdateWidgets(moho)
		MR_AnimatePoints:UpdateWidgets(moho)
		moho.view:DrawMe()
		helper:delete()
	end
end

function MR_AnimatePoints:OnMouseDown(moho, mouseEvent)
	self.twosModeValid = true
	if self.twosMode and moho.frame > 0 then
		if self.blockOnEvenFrames and moho.frame % 2 == 0 or self.blockOnOddFrames and not (moho.frame % 2 == 0) then
			self.twosModeValid = false
			return
		end
	end

	self.handlesTransformationActive = false

	if self.transformBoxMode then
		if self.bboxLength == 0 and self.showHandles then
			local closestHandle = self:TestForClosestHandle(moho, mouseEvent)

			if closestHandle == -1 or closestHandle == 1 then
				self.inProgressIcon = true
				mouseEvent.view:DrawMe()
				self.handlesTransformationActive = true
				if moho.document:CountSelectedLayers() > 1 then
					moho.document:PrepMultiUndo(false)
					moho.document:SetDirty()
				else
					local layersCount = 0
					self:UpdateVectorList(moho, false)

					local firstLayer = -1
					local layersList = {}

					for i = 1, #self.vectorLayersList do
						local layer = moho.document:LayerByAbsoluteID(self.vectorLayersList[i])
						if layer ~= nil then
							local vectorLayer = moho:LayerAsVector(layer)
							if vectorLayer then
								local mesh = vectorLayer:Mesh()
								for p = 0, mesh:CountPoints() - 1 do
									local pt = mesh:Point(p)
									if pt.fSelected then
										if not layersList[i] then
											layersCount = layersCount + 1
											layersList[i] = true
											firstLayer = self.vectorLayersList[i]
										end
									end
								end
							end
						end
					end
					
					if layersCount == 1 then
						if firstLayer and firstLayer >= 0 then
							local layer = moho.document:LayerByAbsoluteID(firstLayer)
							if layer then
								moho.document:PrepUndo(layer, false)
								moho.document:SetDirty()
							else
								moho.document:PrepUndo(moho.layer, false)
								moho.document:SetDirty()
							end
						else
							moho.document:PrepUndo(moho.layer, false)
							moho.document:SetDirty()
						end
					elseif #self.layersList == 1 then
						local layer = moho.document:LayerByAbsoluteID(self.layersList[1])
						if layer then
							moho.document:PrepUndo(layer, false)
							moho.document:SetDirty()
						else
							moho.document:PrepUndo(moho.layer, false)
							moho.document:SetDirty()
						end
					else
						moho.document:PrepUndo(moho.layer, false)
						moho.document:SetDirty()
					end
				end
				self.inProgressIcon = false
				mouseEvent.view:DrawMe()
				return
			end
		end
	end

	if mouseEvent.altKey and not mouseEvent.ctrlKey and not self.transformBoxMode then
		self.dragResize = true
		self.startRadius = self.magnetRadius
		self.startInnerRadius = self.innerRadius
		self.dragVec:Set(mouseEvent.vec)
		mouseEvent.view:DrawMe()
		self.handlesActive = false
		return
	elseif mouseEvent.ctrlKey then
		if self.selectPoints then
			if self.handlesActive and self.showHandles then
				if not self.transformBoxMode then
					if self:TestForClosestHandle(moho, mouseEvent) then
						self.inProgressIcon = true
						mouseEvent.view:DrawMe()
						self.handlesTransformationActive = true

						if moho.document:CountSelectedLayers() > 1 then
							moho.document:PrepMultiUndo(false)
							moho.document:SetDirty()
						else
							local layersCount = 0
							local layerIndex = -1
							if next(self.isolatedLayerUUIDList) then
								for i, layerUUID in pairs(self.isolatedLayerUUIDList) do
									local targetLayerIndex = tonumber(i)-1
									local layer = moho.document:LayerByAbsoluteID(targetLayerIndex)
									if layer then
										if layer:UUID() == layerUUID then
											if self:IsLayerValidForWarpMode(moho, layer) then
												local isLayerOk = true
												if layer == moho.layer then
													isLayerOk = true
												elseif layer:IsWarpLayer() and self.warpMode then
													local layerSkeleton = layer:ControllingSkeleton()
													isLayerOk = MR_Utilities:IsLayerActive(moho, layer, layerSkeleton)
												elseif self.visibleLayersOnly then
													local layerSkeleton = layer:ControllingSkeleton()
													isLayerOk = MR_Utilities:IsLayerVisible(moho, layer, layerSkeleton, true)
												end
												if isLayerOk then
													layersCount = layersCount + 1
													layerIndex = targetLayerIndex
												end
											end
										end
									end
								end
							end
							if layersCount == 1 then
								if layerIndex and layerIndex >= 0 then
									local layer = moho.document:LayerByAbsoluteID(layerIndex)
									if layer then
										moho.document:PrepUndo(layer, false)
										moho.document:SetDirty()
									else
										moho.document:PrepUndo(moho.layer, false)
										moho.document:SetDirty()
									end
								else
									moho.document:PrepUndo(moho.layer, false)
									moho.document:SetDirty()
								end
							elseif #self.layersList == 1 then
								local layer = moho.document:LayerByAbsoluteID(self.layersList[1])
								if layer then
									moho.document:PrepUndo(layer, false)
									moho.document:SetDirty()
								else
									moho.document:PrepUndo(moho.layer, false)
									moho.document:SetDirty()
								end
							else
								moho.document:PrepUndo(moho.layer, false)
								moho.document:SetDirty()
							end
						end
						self.inProgressIcon = false
						mouseEvent.view:DrawMe()
						return
					end
				end
			end

			self.time = os.clock()
			self.movement = false
			self.selectionMode = true
			self.handlesActive = false
			mouseEvent.ctrlKey = false

			if self.lassoMode then
				self.lassoList = { { mouseEvent.startPt.x, mouseEvent.startPt.y } }
				self.previousX = mouseEvent.startPt.x
				self.previousY = mouseEvent.startPt.y
			else
				self.selRect.left = mouseEvent.startPt.x
				self.selRect.top = mouseEvent.startPt.y
				self.selRect.right = mouseEvent.pt.x
				self.selRect.bottom = mouseEvent.pt.y
				mouseEvent.view:Graphics():SelectionRect(self.selRect)
			end

			self.layersPointsList = {}
			self.layersList = {}

			local radius = 18

			local layersList = {}
			if next(self.isolatedLayerUUIDList) then
				for i, layerUUID in pairs(self.isolatedLayerUUIDList) do
					local targetLayerIndex = tonumber(i)-1
					local layer = moho.document:LayerByAbsoluteID(targetLayerIndex)
					if layer then
						if layer:UUID() == layerUUID then
							if self:IsLayerValidForWarpMode(moho, layer) then
								local isLayerOk = true
								if layer == moho.layer then
									isLayerOk = true
								elseif layer:IsWarpLayer() and self.warpMode then
									local layerSkeleton = layer:ControllingSkeleton()
									isLayerOk = MR_Utilities:IsLayerActive(moho, layer, layerSkeleton)
								elseif self.visibleLayersOnly then
									local layerSkeleton = layer:ControllingSkeleton()
									isLayerOk = MR_Utilities:IsLayerVisible(moho, layer, layerSkeleton, true)
								end
								if isLayerOk then
									table.insert(layersList, targetLayerIndex)
								end
							end
						end
					end
				end
			else
				layersList = self:ScanLayers(moho, true)
			end

			for l, layerIndex in ipairs(layersList) do
				local layer = moho.document:LayerByAbsoluteID(layerIndex)
				table.insert(self.layersList, layerIndex)
				local layersPointsList = {}
				layersPointsList.pos = {}
				layersPointsList.col = {}
				layersPointsList.a = {}
				layersPointsList.radius = {}
				layersPointsList.isSelected = {}

				local layerColorChanged = false
				local vectorLayer = moho:LayerAsVector(layer)
				local mesh = vectorLayer:Mesh()

				local opacityMultiplier = 1
				local selectedRadiusMultiplier = self.selectedPointM
				radius = 18
				if self.warpMode and vectorLayer:IsCurver() then
					selectedRadiusMultiplier = self.selectedCurverM
					opacityMultiplier = self.warpOpacity
					radius = 28
				elseif self.warpMode and vectorLayer:IsWarpLayer() then
					selectedRadiusMultiplier = self.selectedWarpM
					opacityMultiplier = self.warpOpacity
					radius = 19
				else
					opacityMultiplier = self.pointsOpacity
				end
				
				for i = 0, mesh:CountPoints() - 1 do
					local pt = mesh:Point(i)
					if not pt.fHidden then
						if self.useSingleColor then
							table.insert(layersPointsList.col, self.pointsColor)

							if self.selectPoints and not pt.fSelected then
								table.insert(layersPointsList.a, self.deselectedPointsAlpha * opacityMultiplier)
								table.insert(layersPointsList.isSelected, false)
							else
								table.insert(layersPointsList.a, 255 * opacityMultiplier)
								table.insert(layersPointsList.isSelected, true)
							end
						else
							local idx = (math.floor(layerIndex) % 20) + 1
							table.insert(layersPointsList.col, idx)

							if self.selectPoints and not pt.fSelected then
								table.insert(layersPointsList.a, self.deselectedPointsAlpha * opacityMultiplier)
								table.insert(layersPointsList.isSelected, false)
							else
								table.insert(layersPointsList.a, 255 * opacityMultiplier)
								table.insert(layersPointsList.isSelected, true)
							end
						end
						layerColorChanged = true

						local v1 = LM.Vector2:new_local()
						v1:Set(pt.fPos)
						v1 = MR_Utilities:GetGlobalPos(moho, layer, v1, true)
						table.insert(layersPointsList.pos, v1)
						if self.selectPoints then
							if pt.fSelected then
								table.insert(layersPointsList.radius, (radius * selectedRadiusMultiplier) * self.pointsSize)
							else
								table.insert(layersPointsList.radius, (radius * self.nonSelectedM) * self.pointsSize)
							end
						else
							table.insert(layersPointsList.radius, (radius * self.nonSelectedM) * self.pointsSize)
						end
					end
				end
				table.insert(self.layersPointsList, layersPointsList)
			end

			if mouseEvent.doubleClick then
				if mouseEvent.altKey then
					self:SelectAllPoints(moho, true)
				else
					self:SelectAllPoints(moho, false)
				end
			end

			mouseEvent.view:DrawMe()
			return
		else
			self.movement = false
			self.selectionMode = true
			self.handlesActive = false
			mouseEvent.ctrlKey = false

			if self.lassoMode then
				self.lassoList = { { mouseEvent.startPt.x, mouseEvent.startPt.y } }
				self.previousX = mouseEvent.startPt.x
				self.previousY = mouseEvent.startPt.y
			else
				self.selRect.left = mouseEvent.startPt.x
				self.selRect.top = mouseEvent.startPt.y
				self.selRect.right = mouseEvent.pt.x
				self.selRect.bottom = mouseEvent.pt.y
				mouseEvent.view:Graphics():SelectionRect(self.selRect)
			end

			self.layersPointsList = {}
			self.layersList = {}

			local radius = 18

			local layersList = self:ScanLayers(moho, true)
			for l, layerIndex in ipairs(layersList) do
				local layer = moho.document:LayerByAbsoluteID(layerIndex)
				table.insert(self.layersList, layerIndex)
				local layersPointsList = {}
				layersPointsList.pos = {}
				layersPointsList.col = {}
				layersPointsList.a = {}
				layersPointsList.radius = {}
				layersPointsList.isSelected = {}

				local vectorLayer = moho:LayerAsVector(layer)
				local mesh = vectorLayer:Mesh()
				local layerIsolated = self.isolatedLayerUUIDList[layerIndex+1]

				local opacityMultiplier = 1
				local selectedRadiusMultiplier = self.selectedPointM
				radius = 18
				if self.warpMode and vectorLayer:IsCurver() then
					selectedRadiusMultiplier = self.selectedCurverM
					opacityMultiplier = self.warpOpacity
					radius = 28
				elseif self.warpMode and vectorLayer:IsWarpLayer() then
					selectedRadiusMultiplier = self.selectedWarpM
					opacityMultiplier = self.warpOpacity
					radius = 19
				else
					opacityMultiplier = self.pointsOpacity
				end
				for i = 0, mesh:CountPoints() - 1 do
					local pt = mesh:Point(i)
					if not pt.fHidden then
						if self.useSingleColor then
							table.insert(layersPointsList.col, self.pointsColor)
							if not layerIsolated then
								table.insert(layersPointsList.a, self.deselectedPointsAlpha * opacityMultiplier)
								table.insert(layersPointsList.isSelected, false)
							else
								table.insert(layersPointsList.a, 255 * opacityMultiplier)
								table.insert(layersPointsList.isSelected, true)
							end
						else
							local idx = (math.floor(layerIndex) % 20) + 1
							table.insert(layersPointsList.col, idx)

							if not layerIsolated then
								table.insert(layersPointsList.a, self.deselectedPointsAlpha * opacityMultiplier)
								table.insert(layersPointsList.isSelected, false)
							else
								table.insert(layersPointsList.a, 255 * opacityMultiplier)
								table.insert(layersPointsList.isSelected, true)
							end
						end
						layerColorChanged = true

						local v1 = LM.Vector2:new_local()
						v1:Set(pt.fPos)
						v1 = MR_Utilities:GetGlobalPos(moho, layer, v1, true)
						table.insert(layersPointsList.pos, v1)

						if layerIsolated then
							table.insert(layersPointsList.radius, (radius * selectedRadiusMultiplier) * self.pointsSize)
						else
							table.insert(layersPointsList.radius, (radius * self.nonSelectedM) * self.pointsSize)
						end
					end
				end
				table.insert(self.layersPointsList, layersPointsList)
			end
			if mouseEvent.doubleClick then
				if mouseEvent.altKey then
					self:IsolateAllLayers(moho, true)
				else
					self:IsolateAllLayers(moho, false)
				end
			end

			self.movement = false
			mouseEvent.view:DrawMe()
			return
		end
	end

	self.dragVec:Set(mouseEvent.vec)

	self.scaleList = {}
	self.layersList = {}
	self.selList = {}
	self.selectionList = {}
	self.posList = {}
	self.startPosList = {}
	self.clusterList = {}
	self.curvatureLayerList = {}
	self.pointsLayerList = {}
	self.angle = 0
	self.lastVec = LM.Vector2:new_local()
	self.axisMove = 0
	self.testPos = nil
	self.curvatureChannelsList = {}

	self.handleList = {}

	self.curvatureStartList = {}
	self.offsetTrueStartList = {}
	self.offsetFalseStartList = {}
	self.weightTrueStartList = {}
	self.weightFalseStartList = {}

	self.lastVec:Set(MR_Utilities:GetGlobalPos(moho, moho.layer, mouseEvent.vec, false))
	self.singlePos = true

	if self.hideCurvesWhileDragging then
		self.currentQualityFlags = moho.view:QualityFlags()
		local wireframe = MOHO.hasbit(moho.view:QualityFlags(), MOHO.LDQ_WIREFRAME)
		if wireframe then
			moho.view:SetQualityFlags(self.currentQualityFlags - MOHO.LDQ_WIREFRAME)
		end
	end

	local layersList = {}
	if next(self.isolatedLayerUUIDList) and not mouseEvent.ctrlKey then
		for i, layerUUID in pairs(self.isolatedLayerUUIDList) do
			local targetLayerIndex = tonumber(i)-1
			local layer = moho.document:LayerByAbsoluteID(targetLayerIndex)
			if layer then
				if layer:UUID() == layerUUID then
					if self:IsLayerValidForWarpMode(moho, layer) then
						local isLayerOk = true
						if layer == moho.layer then
							isLayerOk = true
						elseif layer:IsWarpLayer() and self.warpMode then
							local layerSkeleton = layer:ControllingSkeleton()
							isLayerOk = MR_Utilities:IsLayerActive(moho, layer, layerSkeleton)
						elseif self.visibleLayersOnly then
							local layerSkeleton = layer:ControllingSkeleton()
							isLayerOk = MR_Utilities:IsLayerVisible(moho, layer, layerSkeleton, true)
						end
						if isLayerOk then
							table.insert(layersList, targetLayerIndex)
						end
					end
				end
			end
		end
	else
		layersList = self:ScanLayers(moho, true)
	end

	if self.transformBoxMode then
		self:OnMouseDownTransformMode(moho, mouseEvent)
		return
	else
		self.inProgressIcon = true
		mouseEvent.view:DrawMe()
		if not mouseEvent.ctrlKey then
			self.dragging = true
		end
		for l, layerIndex in ipairs(layersList) do
			local layer = moho.document:LayerByAbsoluteID(layerIndex)
			local layerFrame = layer:DocToLayerFrame(moho.frame)
			local vectorLayer = moho:LayerAsVector(layer)
			local mesh = vectorLayer:Mesh()
			local scaleList = {}
			local selList = {}
			local selectionList = {}
			local posList = {}
			local startPosList = {}
			local isPointSelected = false
			local layerCurvatureList = {}
			local pointsLayerList = {}

			local mouseVec = LM.Vector2:new_local()
			mouseVec:Set(mouseEvent.vec)

			if not self.selectedOnly then
				mesh:SelectNone()
			end
			local pointCurvatureChannelsList = {}

			local curvaturePointStartList = {}
			local offsetTruePointStartList = {}
			local offsetFalsePointStartList = {}
			local weightTruePointStartList = {}
			local weightFalsePointStartList = {}

			for i = 0, mesh:CountPoints() - 1 do
				local pt = mesh:Point(i)
				selectionList[i+1] = pt.fSelected
				if not pt.fHidden and not (self.selectedOnly and not pt.fSelected) then
					local v = MR_Utilities:GetGlobalPos(moho, layer, pt.fPos, false)
					v = MR_Utilities:GetLocalPos(moho, moho.layer, v, false) - mouseVec
					local magInfluence = v:Mag()
					if magInfluence <= self.magnetRadius then
						pt.fSelected = true
						if not self.testPos then
							self.testPos = MR_Utilities:GetGlobalPos(moho, layer, pt.fPos, false)
						else
							local globalPos = MR_Utilities:GetGlobalPos(moho, layer, pt.fPos, false)
							if self.testPos.x ~= globalPos.x or self.testPos.y ~= globalPos.y then
								self.singlePos = false
							end
						end
						
						if (self.magnetRadius * self.innerRadius) and magInfluence <= (self.magnetRadius * self.innerRadius) then
							magInfluence = 0
						else
							magInfluence = (magInfluence - (self.magnetRadius * self.innerRadius)) / (self.magnetRadius - (self.magnetRadius * self.innerRadius))
							if magInfluence > 1.0 then
								magInfluence = 1.0
							end
						end
						table.insert(scaleList, LM.Slerp(magInfluence, 1, 0))
						isPointSelected = true
						table.insert(selList, pt)
						local pos = LM.Vector2:new_local()
						pos:Set(pt.fPos)
						table.insert(posList, pos)
						table.insert(startPosList, pt.fAnimPos:GetValue(layerFrame))

						local curveCurvatureChannelsList = {}
						curveCurvatureChannelsList.curvature = {}
						curveCurvatureChannelsList.weightTrue = {}
						curveCurvatureChannelsList.weightFalse = {}
						curveCurvatureChannelsList.offsetTrue = {}
						curveCurvatureChannelsList.offsetFalse = {}

						local curvatureCurveStartList = {}
						local offsetTrueCurveStartList = {}
						local offsetFalseCurveStartList = {}
						local weightTrueCurveStartList = {}
						local weightFalseCurveStartList = {}

						for j = 0, pt:CountCurves() - 1 do
							local curve, ptPos = pt:Curve(j, -1)

							local curvatureChannel = curve:Curvature(ptPos)
							local offsetTrueChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, true)
							local offsetFalseChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, false)
							local weightTrueChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, true)
							local weightFalseChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, false)

							table.insert(curveCurvatureChannelsList.curvature, curvatureChannel)
							table.insert(curveCurvatureChannelsList.weightTrue, weightTrueChannel)
							table.insert(curveCurvatureChannelsList.weightFalse, weightFalseChannel)
							table.insert(curveCurvatureChannelsList.offsetTrue, offsetTrueChannel)
							table.insert(curveCurvatureChannelsList.offsetFalse, offsetFalseChannel)
							if self.singlePos or MOHO.MohoGlobals.EditMultipleKeys then
								table.insert(curvatureCurveStartList, curvatureChannel:GetValue(layerFrame))
								table.insert(offsetTrueCurveStartList, offsetTrueChannel:GetValue(layerFrame))
								table.insert(offsetFalseCurveStartList, offsetFalseChannel:GetValue(layerFrame))
								table.insert(weightTrueCurveStartList, weightTrueChannel:GetValue(layerFrame))
								table.insert(weightFalseCurveStartList, weightFalseChannel:GetValue(layerFrame))
							end
						end

						table.insert(pointCurvatureChannelsList, curveCurvatureChannelsList)

						if self.singlePos or MOHO.MohoGlobals.EditMultipleKeys then
							table.insert(curvaturePointStartList, curvatureCurveStartList)
							table.insert(offsetTruePointStartList, offsetTrueCurveStartList)
							table.insert(offsetFalsePointStartList, offsetFalseCurveStartList)
							table.insert(weightTruePointStartList, weightTrueCurveStartList)
							table.insert(weightFalsePointStartList, weightFalseCurveStartList)
						end

						if self.smartBake and not MOHO.MohoGlobals.EditMultipleKeys then
							local pointCurvatureList = {}
							pointCurvatureList.baked = false
							table.insert(pointsLayerList, pointCurvatureList)

							local pointCurvatureList = {}
							pointCurvatureList.baked = false
							table.insert(layerCurvatureList, pointCurvatureList)
						end
					elseif self.selectedOnly then
						pt.fSelected = false
					end
				end
			end
			if isPointSelected then
				mesh:PrepMovePoints()
				local isShapesInCluster = false
				for i = 0, mesh:CountShapes() - 1 do
					local shape = mesh:Shape(i)
					if shape:IsInCluster() then
						isShapesInCluster = true
						break
					end
				end

				table.insert(self.clusterList, isShapesInCluster)
				table.insert(self.layersList, layerIndex)
				table.insert(self.scaleList, scaleList)
				table.insert(self.selList, selList)
				table.insert(self.selectionList, selectionList)
				table.insert(self.posList, posList)
				table.insert(self.startPosList, startPosList)
				table.insert(self.curvatureChannelsList, pointCurvatureChannelsList)

				if self.singlePos or MOHO.MohoGlobals.EditMultipleKeys then
					table.insert(self.curvatureStartList, curvaturePointStartList)
					table.insert(self.offsetTrueStartList, offsetTruePointStartList)
					table.insert(self.offsetFalseStartList, offsetFalsePointStartList)
					table.insert(self.weightTrueStartList, weightTruePointStartList)
					table.insert(self.weightFalseStartList, weightFalsePointStartList)
				end

				if self.smartBake and not MOHO.MohoGlobals.EditMultipleKeys then
					table.insert(self.pointsLayerList, pointsLayerList)
					table.insert(self.curvatureLayerList, layerCurvatureList)
				end
			end
		end
	end

	if moho.document:CountSelectedLayers() > 1 then
		moho.document:PrepMultiUndo(false)
		moho.document:SetDirty()
	else
		local layersCount = 0
		local layerIndex = -1
		if next(self.isolatedLayerUUIDList) then
			for i, layerUUID in pairs(self.isolatedLayerUUIDList) do
				local targetLayerIndex = tonumber(i)-1
				local layer = moho.document:LayerByAbsoluteID(targetLayerIndex)
				if layer then
					if layer:UUID() == layerUUID then
						if self:IsLayerValidForWarpMode(moho, layer) then
							local isLayerOk = true
							if layer == moho.layer then
								isLayerOk = true
							elseif layer:IsWarpLayer() and self.warpMode then
								local layerSkeleton = layer:ControllingSkeleton()
								isLayerOk = MR_Utilities:IsLayerActive(moho, layer, layerSkeleton)
							elseif self.visibleLayersOnly then
								local layerSkeleton = layer:ControllingSkeleton()
								isLayerOk = MR_Utilities:IsLayerVisible(moho, layer, layerSkeleton, true)
							end
							if isLayerOk then
								layersCount = layersCount + 1
								layerIndex = targetLayerIndex
							end
						end
					end
				end
			end
		end
		
		if layersCount == 1 then
			if layerIndex and layerIndex >= 0 then
				local layer = moho.document:LayerByAbsoluteID(layerIndex)
				if layer then
					moho.document:PrepUndo(layer, false)
					moho.document:SetDirty()
				else
					moho.document:PrepUndo(moho.layer, false)
					moho.document:SetDirty()
				end
			else
				moho.document:PrepUndo(moho.layer, false)
				moho.document:SetDirty()
			end
		elseif #self.layersList == 1 then
			local layer = moho.document:LayerByAbsoluteID(self.layersList[1])
			if layer then
				moho.document:PrepUndo(layer, false)
				moho.document:SetDirty()
			else
				moho.document:PrepUndo(moho.layer, false)
				moho.document:SetDirty()
			end
		else
			moho.document:PrepUndo(moho.layer, false)
			moho.document:SetDirty()
		end
	end
	
	self.inProgressIcon = false
	self.movement = false
	mouseEvent.view:DrawMe()
end

function MR_AnimatePoints:OnMouseMoved(moho, mouseEvent)
	if self.twosMode and moho.frame > 0 then
		if self.blockOnEvenFrames and moho.frame % 2 == 0 or self.blockOnOddFrames and not (moho.frame % 2 == 0) then
			return
		end
	end
	if not self.twosModeValid then
		return
	end

	if (self.dragResize) then
		local factor = 600
		
		if mouseEvent.ctrlKey and not self.lastCtrlState then
			self.startRadius = self.magnetRadius
			self.startInnerRadius = self.innerRadius
			mouseEvent.startPt.x = mouseEvent.pt.x
		elseif not mouseEvent.ctrlKey and self.lastCtrlState then
			self.startRadius = self.magnetRadius
			self.startInnerRadius = self.innerRadius
			mouseEvent.startPt.x = mouseEvent.pt.x
		end
		
		self.lastCtrlState = mouseEvent.ctrlKey
		
		if mouseEvent.ctrlKey then
			factor = 3200
		end

		if mouseEvent.shiftKey then
			self.innerRadius = LM.Clamp(self.startInnerRadius + (mouseEvent.pt.x - mouseEvent.startPt.x) / factor, 0, 1)
		else
			self.magnetRadius = self.startRadius + (mouseEvent.pt.x - mouseEvent.startPt.x) / factor
			if self.magnetRadius < 0.001 then
				self.magnetRadius = 0.001
			end
			if self.magnetRadius > 5.0 then
				self.magnetRadius = 5.0
			end
		end
		
		mouseEvent.view:DrawMe()
		return
	elseif self.selectionMode then
		if self.lassoMode then
			local g = mouseEvent.view:Graphics()

			g:SetSmoothing(true)
			g:Push()
			local m = g:CurrentTransform()
			m:Invert()
			g:ApplyMatrix(m)
			g:SetColor(MOHO.MohoGlobals.SelCol)
			g:MoveTo(self.previousX, self.previousY)
			g:LineTo(mouseEvent.pt.x, mouseEvent.pt.y)
			g:Pop()
			g:SetSmoothing(false)
			mouseEvent.view:RefreshView()

			table.insert(self.lassoList, { mouseEvent.pt.x, mouseEvent.pt.y })
			self.previousX = mouseEvent.pt.x
			self.previousY = mouseEvent.pt.y
		else
			mouseEvent.ctrlKey = false
			mouseEvent.view:Graphics():SelectionRect(self.selRect)
			self.selRect.right = mouseEvent.pt.x
			self.selRect.bottom = mouseEvent.pt.y
			mouseEvent.view:Graphics():SelectionRect(self.selRect)
			mouseEvent.view:RefreshView()
		end
		mouseEvent.view:DrawMe()
		self.movement = true
		return
	end

	if self.handlesTransformationActive then
		for i, layerIndex in ipairs(self.layersList) do
			local layer = moho.document:LayerByAbsoluteID(layerIndex)
			local layerFrame = layer:DocToLayerFrame(moho.frame)
			local vectorLayer = moho:LayerAsVector(layer)
			local mesh = vectorLayer:Mesh()

			local newVal = (mouseEvent.pt.x - mouseEvent.startPt.x) / mouseEvent.view:Graphics():Width()
			local curve = nil
			local ptPos = -1

			local pointPosList = {}
			pointPosList.handleTrue = {}
			pointPosList.handleFalse = {}
			pointPosList.point = {}

			local curve = mesh:Curve(self.bezierHandleList[i].handleCurveID)
			local syncHandles = true
			if (mouseEvent.altKey) then
				syncHandles = false
			end

			local vec = mouseEvent.vec
			local startVec = mouseEvent.startVec

			if layer ~= moho.layer then
				vec = MR_Utilities:GetGlobalPos(moho, moho.layer, mouseEvent.vec, false)
				startVec = MR_Utilities:GetGlobalPos(moho, moho.layer, mouseEvent.startVec, false)
				vec = MR_Utilities:GetLocalPos(moho, layer, vec, false)
				startVec = MR_Utilities:GetLocalPos(moho, layer, startVec, false)
			end

			local handlePt = self.bezierHandleList[i].startHandle + (vec - startVec)
			if (moho.gridOn) then
				moho:SnapToGrid(handlePt)
			end

			local pt = mesh:Point(self.selList[i])

			if self.smartBake and moho.frame > 0 and not MOHO.MohoGlobals.EditMultipleKeys then
				if self.curvatureLayerList[i] then
					local pointCurvatureList = self.curvatureLayerList[i]
					if pointCurvatureList and not pointCurvatureList.baked then
						local prevFrame = layerFrame - self.smartBakeInterval
						local nextFrame = layerFrame + self.smartBakeInterval
						self:BakePointCurvature(moho, layer, pt, prevFrame, nextFrame)
						pointCurvatureList.baked = true
					end
				end
			end

			if (math.abs(curve:GetCurvature(self.bezierHandleList[i].handlePointID, layerFrame)) < 0.001) then
				curve:SetCurvature(self.bezierHandleList[i].handlePointID, 0.001, layerFrame)
			end

			local offsetTrueChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, self.bezierHandleList[i].handlePointID, true)
			local offsetFalseChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, self.bezierHandleList[i].handlePointID, false)
			local weightTrueChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, self.bezierHandleList[i].handlePointID, true)
			local weightFalseChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, self.bezierHandleList[i].handlePointID, false)

			local startHandle = self.bezierHandleList[i].startHandle
			local startVector = startHandle - pt.fPos

			local oldOffset = curve:GetOffset(self.bezierHandleList[i].handlePointID, layerFrame, (self.bezierHandleList[i].handleSide == -1))
			local oldOppOffset = curve:GetOffset(self.bezierHandleList[i].handlePointID, layerFrame, (self.bezierHandleList[i].handleSide == 1))

			if math.abs(oldOffset - oldOppOffset) > 0.01 then
				syncHandles = false
			end

			local newVector = handlePt - pt.fPos
			local weightMultiply = newVector:Mag() / startVector:Mag()

			local angleAdd = AE_Utilities:GetAngleBetween(startVector, newVector)

			if self.flipDirectionList[i] then
				angleAdd = -angleAdd
			end

			local newOffset = self.startOffsetList[i] + angleAdd

			local newWeight = newVector:Mag()/self.weightMultiplierList[i] - self.weightDeltaList[i]
			newWeight = newWeight - self.weightStartDeltaList[i]

			curve:SetWeight(self.bezierHandleList[i].handlePointID, newWeight, layerFrame, (self.bezierHandleList[i].handleSide == -1))
			curve:SetOffset(self.bezierHandleList[i].handlePointID, newOffset, layerFrame, (self.bezierHandleList[i].handleSide == -1))

			if syncHandles then
				curve:SetOffset(self.bezierHandleList[i].handlePointID, newOffset, layerFrame, (self.bezierHandleList[i].handleSide == 1))
			end

			local handlePosTrue = curve:GetControlHandle(self.bezierHandleList[i].handlePointID, layerFrame, true)
			local handlePosFalse = curve:GetControlHandle(self.bezierHandleList[i].handlePointID, layerFrame, false)
			local pointPos = MR_Utilities:GetGlobalPos(moho, layer, pt.fPos, true)

			if curve:GetCurvature(self.bezierHandleList[i].handlePointID, layerFrame) == 0 then
				table.insert(pointPosList.handleTrue, pointPos)
				table.insert(pointPosList.handleFalse, pointPos)
			else
				table.insert(pointPosList.handleTrue, MR_Utilities:GetGlobalPos(moho, layer, handlePosTrue, true))
				table.insert(pointPosList.handleFalse, MR_Utilities:GetGlobalPos(moho, layer, handlePosFalse, true))
			end
			table.insert(self.handleList, pointPosList)

			self.savedVal = newVal
			layer:UpdateCurFrame()
		end

		self.dragVec:Set(mouseEvent.vec)
		self.cursorPosition:Set(MR_Utilities:GetGlobalPos(moho, moho.layer, self.dragVec, true))
		mouseEvent.view:DrawMe()
		return
	end

	self.dragVec:Set(mouseEvent.vec)
	self.cursorPosition:Set(MR_Utilities:GetGlobalPos(moho, moho.layer, self.dragVec, true))
	self.ctrlPressed = mouseEvent.ctrlKey

	if self.transformBoxMode then
		self:OnMouseMovedTransformMode(moho, mouseEvent)
		return
	end

	if (not self.dragging) then
		mouseEvent.view:DrawMe()
		return
	end

	if not mouseEvent.shiftKey then
		self.axisMove = 0
	end

	self.rotating = false

	if ((mouseEvent.shiftKey and mouseEvent.ctrlKey) or (mouseEvent.shiftKey and not mouseEvent.ctrlKey)) and not mouseEvent.altKey and moho.frame > 0 then
		for i, layerIndex in ipairs(self.layersList) do
			local layer = moho.document:LayerByAbsoluteID(layerIndex)
			local layerFrame = layer:DocToLayerFrame(moho.frame)
			local mouseVec = LM.Vector2:new_local()
			mouseVec:Set(mouseEvent.vec)
			local mouseStartVec = LM.Vector2:new_local()
			mouseStartVec:Set(mouseEvent.startVec)
			mouseVec = MR_Utilities:GetGlobalPos(moho, moho.layer, mouseVec, false)
			mouseStartVec = MR_Utilities:GetGlobalPos(moho, moho.layer, mouseStartVec, false)

			local dx = mouseVec.x - mouseStartVec.x
			local dy = mouseVec.y - mouseStartVec.y
			self.axisMove = 0
			if math.abs(dx) > math.abs(dy) then
				if dx > 0 then
					self.axisMove = 1
				else
					self.axisMove = 2
				end
			else
				if dy > 0 then
					self.axisMove = 3
				else
					self.axisMove = 4
				end
			end

			local distance = MR_Utilities:GetDistance(mouseEvent.startPt, mouseEvent.pt)
			if distance < 32 then
				self.axisMove = 5
			end
			
			self.mouseStartVec:Set(MR_Utilities:GetGlobalPos(moho, moho.layer, mouseEvent.startVec, true))
			if self.axisMove == 1 or self.axisMove == 2 or self.axisMove == 4 then
				for p, pt in ipairs(self.selList[i]) do
					if self.smartBake and moho.frame > 0 and not MOHO.MohoGlobals.EditMultipleKeys then
						local layerPointsList = self.pointsLayerList[i]
						if layerPointsList then
							local pointPointsList = layerPointsList[p]
							if pointPointsList and not pointPointsList.baked then
								local prevFrame = layerFrame- self.smartBakeInterval
								local nextFrame = layerFrame + self.smartBakeInterval
								if prevFrame > 0 then
									pt.fAnimPos:SetValue(prevFrame, pt.fAnimPos:GetValue(prevFrame))
								end
								pt.fAnimPos:SetValue(nextFrame, pt.fAnimPos:GetValue(nextFrame))
								pointPointsList.baked = true
							end
						end
					end

					local targetPos = LM.Vector2:new_local()
					local newPos = LM.Vector2:new_local()
					if self.axisMove == 4 then
						targetPos:Set(pt.fAnimPos:GetValue(0))
					elseif self.axisMove == 1 then
						local channel = pt.fAnimPos
						local curFrame = layerFrame
						local currentKeyID = channel:GetClosestKeyID(curFrame)
						local nextKey = currentKeyID + 1
						if(channel:HasKey(curFrame)) then
							nextKey = currentKeyID + 1
						end
						local nextFrame = curFrame
						if nextKey < channel:CountKeys() then
							nextFrame = channel:GetKeyWhen(nextKey)
						end

						targetPos:Set(channel:GetValue(nextFrame))
					elseif self.axisMove == 2 then
						local channel = pt.fAnimPos
						local curFrame = layerFrame
						local currentKeyID = channel:GetClosestKeyID(curFrame)
						local prewKey = currentKeyID

						if(channel:HasKey(curFrame)) then
							prewKey = currentKeyID - 1
						end

						targetPos:Set(channel:GetValue(channel:GetKeyWhen(prewKey)))
					end
					local curPos = pt.fAnimPos:GetValue(layerFrame)
					local multiplier = self.scaleList[i][p]
					if mouseEvent.ctrlKey then
						multiplier = 1
					end

					newPos:Set(curPos + ((targetPos - curPos) * (0.01 * self.blendSensitivity) * multiplier))
					pt.fAnimPos:SetValue(layerFrame, newPos)

					self.movement = true
					for j = 0, pt:CountCurves() - 1 do
						local curve, ptPos = pt:Curve(j, -1)
						local channel = self.curvatureChannelsList[i][p].curvature[j+1]
						local noNextKey = false
						if channel:CountKeys() > 1 then
							local targetCurvature = 0
							if self.axisMove == 4 then
								targetCurvature = curve:GetCurvature(ptPos, 0)
							elseif self.axisMove == 1 then
								local curFrame = layerFrame
								local currentKeyID = channel:GetClosestKeyID(curFrame)
								local nextKey = currentKeyID + 1
								if channel:HasKey(curFrame) then
									nextKey = currentKeyID + 1
								end
								local nextFrame = curFrame
								if nextKey < channel:CountKeys() then
									nextFrame = channel:GetKeyWhen(nextKey)
								else
									noNextKey = true
								end

								targetCurvature = channel:GetValue(nextFrame)
							elseif self.axisMove == 2 then
								local curFrame = layerFrame
								local currentKeyID = channel:GetClosestKeyID(curFrame)
								local prewKey = currentKeyID
								if channel:HasKey(curFrame) then
									prewKey = currentKeyID - 1
								end
								targetCurvature = channel:GetValue(channel:GetKeyWhen(prewKey))
							end
							if not noNextKey then
								local curCurvature = curve:GetCurvature(ptPos, layerFrame)
								local newCurvature = curCurvature + ((targetCurvature - curCurvature) * (0.01 * self.blendSensitivity) * multiplier)
								newCurvature = LM.Clamp(newCurvature, 0, math.huge)

								if self.smartBake and moho.frame > 0 and not MOHO.MohoGlobals.EditMultipleKeys then
									local layerCurvatureList = self.curvatureLayerList[i]
									if layerCurvatureList then
										local pointCurvatureList = layerCurvatureList[p]
										if pointCurvatureList and not pointCurvatureList.baked then
											local prevFrame = layerFrame - self.smartBakeInterval
											local nextFrame = layerFrame + self.smartBakeInterval
											self:BakePointCurvature(moho, layer, pt, prevFrame, nextFrame)
											pointCurvatureList.baked = true
										end
									end
								end
								curve:SetCurvature(ptPos, newCurvature, moho.frame)
							end
						end
						
						-- offset true
						channel = self.curvatureChannelsList[i][p].offsetTrue[j+1]
						noNextKey = false
						if channel:CountKeys() > 1 then
							local targetOffsetTrue = 0
							if self.axisMove == 4 then
								targetOffsetTrue = curve:GetOffset(ptPos, 0, true)
							elseif self.axisMove == 1 then
								local curFrame = layerFrame
								local currentKeyID = channel:GetClosestKeyID(curFrame)
								local nextKey = currentKeyID + 1
								if channel:HasKey(curFrame) then
									nextKey = currentKeyID + 1
								end

								local nextFrame = curFrame
								if nextKey < channel:CountKeys() then
									nextFrame = channel:GetKeyWhen(nextKey)
								else
									noNextKey = true
								end

								targetOffsetTrue = channel:GetValue(nextFrame)
							elseif self.axisMove == 2 then
								local curFrame = layerFrame
								local currentKeyID = channel:GetClosestKeyID(curFrame)
								local prewKey = currentKeyID
								if channel:HasKey(curFrame) then
									prewKey = currentKeyID - 1
								end
								targetOffsetTrue = channel:GetValue(channel:GetKeyWhen(prewKey))
							end
							if not noNextKey then
								local curOffsetTrue = curve:GetOffset(ptPos, layerFrame, true)
								local newOffsetTrue = curOffsetTrue + ((targetOffsetTrue - curOffsetTrue) * (0.01 * self.blendSensitivity) * multiplier)

								if self.smartBake and moho.frame > 0 and not MOHO.MohoGlobals.EditMultipleKeys then
									local layerCurvatureList = self.curvatureLayerList[i]
									if layerCurvatureList then
										local pointCurvatureList = layerCurvatureList[p]
										if pointCurvatureList and not pointCurvatureList.baked then
											local prevFrame = layerFrame - self.smartBakeInterval
											local nextFrame = layerFrame + self.smartBakeInterval
											self:BakePointCurvature(moho, layer, pt, prevFrame, nextFrame)
											pointCurvatureList.baked = true
										end
									end
								end
								curve:SetOffset(ptPos, newOffsetTrue, layerFrame, true)
							end
						end
					
						-- offset false
						channel = self.curvatureChannelsList[i][p].offsetFalse[j+1]
						noNextKey = false
						if channel:CountKeys() > 1 then
							local targetOffsetFalse = 0
							if self.axisMove == 4 then
								targetOffsetFalse = curve:GetOffset(ptPos, 0, false)
							elseif self.axisMove == 1 then
								local curFrame = layerFrame
								local currentKeyID = channel:GetClosestKeyID(curFrame)
								local nextKey = currentKeyID + 1
								if channel:HasKey(curFrame) then
									nextKey = currentKeyID + 1
								else
									noNextKey = true
								end

								local nextFrame = curFrame
								if nextKey < channel:CountKeys() then
									nextFrame = channel:GetKeyWhen(nextKey)
								end

								targetOffsetFalse = channel:GetValue(nextFrame)
							elseif self.axisMove == 2 then
								local curFrame = layerFrame
								local currentKeyID = channel:GetClosestKeyID(curFrame)
								local prewKey = currentKeyID
								if channel:HasKey(curFrame) then
									prewKey = currentKeyID - 1
								end
								targetOffsetFalse = channel:GetValue(channel:GetKeyWhen(prewKey))
							end
							if not noNextKey then
								local curOffsetFalse = curve:GetOffset(ptPos, layerFrame, false)
								local newOffsetFalse = curOffsetFalse + ((targetOffsetFalse - curOffsetFalse) * (0.01 * self.blendSensitivity) * multiplier)

								if self.smartBake and moho.frame > 0 and not MOHO.MohoGlobals.EditMultipleKeys then
									local layerCurvatureList = self.curvatureLayerList[i]
									if layerCurvatureList then
										local pointCurvatureList = layerCurvatureList[p]
										if pointCurvatureList and not pointCurvatureList.baked then
											local prevFrame = layerFrame - self.smartBakeInterval
											local nextFrame = layerFrame + self.smartBakeInterval
											self:BakePointCurvature(moho, layer, pt, prevFrame, nextFrame)
											pointCurvatureList.baked = true
										end
									end
								end
								curve:SetOffset(ptPos, newOffsetFalse, layerFrame, false)
							end
						end
					
						-- weight true
						channel = self.curvatureChannelsList[i][p].weightTrue[j+1]
						if channel:CountKeys() > 1 then
							local targetWeightTrue = 0
							if self.axisMove == 4 then
								targetWeightTrue = curve:GetWeight(ptPos, 0, true)
							elseif self.axisMove == 1 then
								local curFrame = layerFrame
								local currentKeyID = channel:GetClosestKeyID(curFrame)
								local nextKey = currentKeyID + 1
								if channel:HasKey(curFrame) then
									nextKey = currentKeyID + 1
								else
									noNextKey = true
								end

								local nextFrame = curFrame
								if nextKey < channel:CountKeys() then
									nextFrame = channel:GetKeyWhen(nextKey)
								end

								targetWeightTrue = channel:GetValue(nextFrame)
							elseif self.axisMove == 2 then
								local curFrame = layerFrame
								local currentKeyID = channel:GetClosestKeyID(curFrame)
								local prewKey = currentKeyID
								if channel:HasKey(curFrame) then
									prewKey = currentKeyID - 1
								end
								targetWeightTrue = channel:GetValue(channel:GetKeyWhen(prewKey))
							end
							if not noNextKey then
								local curWeightTrue = curve:GetWeight(ptPos, layerFrame, true)
								local newWeightTrue = curWeightTrue + ((targetWeightTrue - curWeightTrue) * (0.01 * self.blendSensitivity) * multiplier)
								newWeightTrue = LM.Clamp(newWeightTrue, 0, math.huge)

								if self.smartBake and moho.frame > 0 and not MOHO.MohoGlobals.EditMultipleKeys then
									local layerCurvatureList = self.curvatureLayerList[i]
									if layerCurvatureList then
										local pointCurvatureList = layerCurvatureList[p]
										if pointCurvatureList and not pointCurvatureList.baked then
											local prevFrame = layerFrame - self.smartBakeInterval
											local nextFrame = layerFrame + self.smartBakeInterval
											self:BakePointCurvature(moho, layer, pt, prevFrame, nextFrame)
											pointCurvatureList.baked = true
										end
									end
								end
								curve:SetWeight(ptPos, newWeightTrue, layerFrame, true)
							end
						end
						-- weight false
						channel = self.curvatureChannelsList[i][p].weightFalse[j+1]
						if channel:CountKeys() > 1 then
							local targetWeightFalse = 0
							if self.axisMove == 4 then
								targetWeightFalse = curve:GetWeight(ptPos, 0, false)
							elseif self.axisMove == 1 then
								local curFrame = layerFrame
								local currentKeyID = channel:GetClosestKeyID(curFrame)
								local nextKey = currentKeyID + 1
								if channel:HasKey(curFrame) then
									nextKey = currentKeyID + 1
								end

								local nextFrame = curFrame
								if nextKey < channel:CountKeys() then
									nextFrame = channel:GetKeyWhen(nextKey)
								else
									noNextKey = true
								end

								targetWeightFalse = channel:GetValue(nextFrame)
							elseif self.axisMove == 2 then
								local curFrame = layerFrame
								local currentKeyID = channel:GetClosestKeyID(curFrame)
								local prewKey = currentKeyID
								if channel:HasKey(curFrame) then
									prewKey = currentKeyID - 1
								end
								targetWeightFalse = channel:GetValue(channel:GetKeyWhen(prewKey))
							end
							if not noNextKey then
								local curWeightFalse = curve:GetWeight(ptPos, layerFrame, false)
								local newWeightFalse = curWeightFalse + ((targetWeightFalse - curWeightFalse) * (0.01 * self.blendSensitivity) * multiplier)
								newWeightFalse = LM.Clamp(newWeightFalse, 0, math.huge)

								if self.smartBake and moho.frame > 0 and not MOHO.MohoGlobals.EditMultipleKeys then
									local layerCurvatureList = self.curvatureLayerList[i]
									if layerCurvatureList then
										local pointCurvatureList = layerCurvatureList[p]
										if pointCurvatureList and not pointCurvatureList.baked then
											local prevFrame = layerFrame - self.smartBakeInterval
											local nextFrame = layerFrame + self.smartBakeInterval
											self:BakePointCurvature(moho, layer, pt, prevFrame, nextFrame)
											pointCurvatureList.baked = true
										end
									end
								end
								curve:SetWeight(ptPos, newWeightFalse, layerFrame, false)
							end
						end
					end
				end
				layer:UpdateCurFrame()
				layer:FreeCachedImage()
			end
		end
	else
		local curVec = MR_Utilities:GetGlobalPos(moho, moho.layer, mouseEvent.vec, false)

		local angle = 0
		if mouseEvent.altKey or mouseEvent.ctrlKey then
			if math.abs(curVec.x - self.lastVec.x) > math.abs(curVec.y - self.lastVec.y) then
				if curVec.x > self.lastVec.x then
					self.angle = self.angle + math.rad(1 * self.sensitivity)
					angle = math.rad(1 * self.sensitivity)
				else
					self.angle = self.angle - math.rad(1 * self.sensitivity)
					angle = math.rad(-1 * self.sensitivity)
				end
			end
		end
		self.lastVec:Set(curVec)
		self.handleList = {}

		for i, layerIndex in ipairs(self.layersList) do
			local layer = moho.document:LayerByAbsoluteID(layerIndex)
			local layerFrame = layer:DocToLayerFrame(moho.frame)
			local vectorLayer = moho:LayerAsVector(layer)
			local mouseVec = LM.Vector2:new_local()
			mouseVec:Set(mouseEvent.vec)
			local mouseStartVec = LM.Vector2:new_local()
			mouseStartVec:Set(mouseEvent.startVec)
			if layer ~= moho.layer then
				mouseVec = MR_Utilities:GetGlobalPos(moho, moho.layer, mouseVec, false)
				mouseVec = MR_Utilities:GetLocalPos(moho, layer, mouseVec, false)
				mouseStartVec = MR_Utilities:GetGlobalPos(moho, moho.layer, mouseStartVec, false)
				mouseStartVec = MR_Utilities:GetLocalPos(moho, layer, mouseStartVec, false)
			end
			local offset = mouseVec - mouseStartVec

			local pointPosList = {}
			pointPosList.handleTrue = {}
			pointPosList.handleFalse = {}
			pointPosList.point = {}
			for p, pt in ipairs(self.selList[i]) do
				local newPos = LM.Vector2:new_local()
				local multiplier = self.scaleList[i][p]

				newPos:Set(pt.fTempPos + offset * multiplier)
				
				if mouseEvent.ctrlKey and not mouseEvent.altKey then
					if self.smartBake and moho.frame > 0 and not MOHO.MohoGlobals.EditMultipleKeys then
						local layerCurvatureList = self.curvatureLayerList[i]
						if layerCurvatureList then
							local pointCurvatureList = layerCurvatureList[p]
							if pointCurvatureList and not pointCurvatureList.baked then
								local prevFrame = layerFrame - self.smartBakeInterval
								local nextFrame = layerFrame + self.smartBakeInterval
								self:BakePointCurvature(moho, layer, pt, prevFrame, nextFrame)
								pointCurvatureList.baked = true
							end
						end
					end
					self.movement = true
					self.rotating = true
					self.mouseStartVec:Set(MR_Utilities:GetGlobalPos(moho, moho.layer, mouseEvent.startVec, true))
					newPos:Set(pt.fTempPos)
					local scale = math.exp(self.angle * 0.5)
					local scalePos = MR_Utilities:ScaleVector2(newPos, mouseStartVec, scale)
					local delta = scalePos - newPos
					newPos:Set(pt.fTempPos + delta * multiplier)
					pt.fPos = newPos
					self.posList[i][p]:Set(newPos)
				elseif mouseEvent.altKey then
					if self.singlePos then
						if self.smartBake and moho.frame > 0 and not MOHO.MohoGlobals.EditMultipleKeys then
							local layerCurvatureList = self.curvatureLayerList[i]
							if layerCurvatureList then
								local pointCurvatureList = layerCurvatureList[p]
								if pointCurvatureList and not pointCurvatureList.baked then
									local prevFrame = layerFrame - self.smartBakeInterval
									local nextFrame = layerFrame + self.smartBakeInterval
									self:BakePointCurvature(moho, layer, pt, prevFrame, nextFrame)
									pointCurvatureList.baked = true
								end
							end
						end

						self.rotating = true
						self.mouseStartVec:Set(MR_Utilities:GetGlobalPos(moho, moho.layer, mouseEvent.startVec, true))

						for j = 0, pt:CountCurves() - 1 do
							local curve, ptPos = pt:Curve(j, -1)
							if not mouseEvent.ctrlKey and not mouseEvent.shiftKey then
								local originalOffsetTrue = curve:GetOffset(ptPos, layerFrame, true)
								local originalOffsetFalse = curve:GetOffset(ptPos, layerFrame, false)
								curve:SetOffset(ptPos, originalOffsetTrue + angle, layerFrame, true)
								curve:SetOffset(ptPos, originalOffsetFalse + angle, layerFrame, false)
							elseif mouseEvent.ctrlKey and not mouseEvent.shiftKey then
								local curvature = curve:GetCurvature(ptPos, layerFrame)
								local weight = (curve:GetWeight(ptPos, layerFrame, true) + curve:GetWeight(ptPos, layerFrame, false)) / 2.0
								local newVal = curvature + ((math.deg(angle) * 0.01) / weight)
								newVal = LM.Clamp(newVal, 0, 1)
								curve:SetCurvature(ptPos, newVal, layerFrame)
							end

							local handlePosTrue = curve:GetControlHandle(ptPos, layerFrame, true)
							local handlePosFalse = curve:GetControlHandle(ptPos, layerFrame, false)
							local pointPos = MR_Utilities:GetGlobalPos(moho, layer, pt.fPos, true)
							if curve:GetCurvature(ptPos, layerFrame) == 0 then
								table.insert(pointPosList.handleTrue, pointPos)
								table.insert(pointPosList.handleFalse, pointPos)
							else
								table.insert(pointPosList.handleTrue, MR_Utilities:GetGlobalPos(moho, layer, handlePosTrue, true))
								table.insert(pointPosList.handleFalse, MR_Utilities:GetGlobalPos(moho, layer, handlePosFalse, true))
							end
							table.insert(pointPosList.point, pointPos)
							self.drawHandles = true
						end
						table.insert(self.handleList, pointPosList)
					else
						self.movement = true
						self.rotating = true
						self.mouseStartVec:Set(MR_Utilities:GetGlobalPos(moho, moho.layer, mouseEvent.startVec, true))
						newPos:Set(pt.fTempPos)
						local rotatePos = MR_Utilities:RotateVector2(newPos, mouseStartVec, self.angle)
						local delta = rotatePos - newPos
						newPos:Set(pt.fTempPos + delta * multiplier)
						pt.fPos = newPos
						self.posList[i][p]:Set(newPos)
					end
				else
					if self.smartBake and moho.frame > 0 and not MOHO.MohoGlobals.EditMultipleKeys then
						local layerPointsList = self.pointsLayerList[i]
						if layerPointsList then
							local pointPointsList = layerPointsList[p]
							if pointPointsList and not pointPointsList.baked then
								local prevFrame = layerFrame - self.smartBakeInterval
								local nextFrame = layerFrame + self.smartBakeInterval
								if prevFrame > 0 then
									pt.fAnimPos:SetValue(prevFrame, pt.fAnimPos:GetValue(prevFrame))
								end
								pt.fAnimPos:SetValue(nextFrame, pt.fAnimPos:GetValue(nextFrame))
								pointPointsList.baked = true
							end
						end
					end

					self.movement = true

					self.drawHandles = false
					pt.fPos = newPos
					self.posList[i][p]:Set(newPos)
				end
			end
			if self.clusterList[i] then
				layer:UpdateCurFrame()
				for p, pt in ipairs(self.selList[i]) do
					pt.fPos = self.posList[i][p]
				end
			end
			if vectorLayer:IsWarpLayer() then
				moho:AddPointKeyframe(moho.frame, layer)
				for p, pt in ipairs(self.selList[i]) do
					local delta = self.posList[i][p] - pt.fPos
					pt.fPos = self.posList[i][p] + delta
				end
				moho:AddPointKeyframe(moho.frame, layer)
			end
		end
	end

	mouseEvent.view:DrawMe()
end

function MR_AnimatePoints:OnMouseUp(moho, mouseEvent)
	if not self.twosModeValid then
		self.twosModeValid = true
		return
	end

	if self.handlesTransformationActive then
		self.handlesTransformationActive = false

		self.inProgressIcon = true
		mouseEvent.view:DrawMe()

		if MOHO.MohoGlobals.EditMultipleKeys then
			local markersChannel = moho:ChannelAsAnimString(moho.layer.fTimelineMarkers)

			local targetFrames = {}
			for i = 0, markersChannel:CountKeys() - 1 do
				if markersChannel:IsKeySelectedByID(i) then
					local frame = math.floor(markersChannel:GetKeyWhen(i))
					if frame > 0 then
						local markerText = markersChannel:GetValue(frame)
						local markerVal = tonumber(string.match(markerText, "%d+"))
						markerVal = math.floor(markerVal)
						targetFrames[markerVal] = true
					end
				end
			end

			if next(targetFrames) then
				for i, layerIndex in ipairs(self.layersList) do
					local layer = moho.document:LayerByAbsoluteID(layerIndex)
					local layerFrame = layer:DocToLayerFrame(moho.frame)
					local vectorLayer = moho:LayerAsVector(layer)
					local mesh = vectorLayer:Mesh()

					local pt = mesh:Point(self.selList[i])

					for j = 0, pt:CountCurves() - 1 do
						local curve, ptPos = pt:Curve(j, -1)

						local curvatureChannel = curve:Curvature(ptPos)
						local offsetTrueChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, true)
						local offsetFalseChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, false)
						local weightTrueChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, true)
						local weightFalseChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, false)

						local curvatureStart = self.curvatureStartList[i][1][j+1]
						local weightTrueStart = self.weightTrueStartList[i][1][j+1]
						local weightFalseStart = self.weightFalseStartList[i][1][j+1]
						local offsetTrueStart = self.offsetTrueStartList[i][1][j+1]
						local offsetFalseStart = self.offsetFalseStartList[i][1][j+1]

						local currentCurvature = curvatureChannel:GetValue(layerFrame)
						local currentWeightTrue = weightTrueChannel:GetValue(layerFrame)
						local currentWeightFalse = weightFalseChannel:GetValue(layerFrame)
						local currentOffsetTrue = offsetTrueChannel:GetValue(layerFrame)
						local currentOffsetFalse = offsetFalseChannel:GetValue(layerFrame)

						local curvatureDelta = curvatureStart - currentCurvature
						local weightTrueDelta = weightTrueStart - currentWeightTrue
						local weightFalseDelta = weightFalseStart - currentWeightFalse
						local offsetTrueDelta = offsetTrueStart - currentOffsetTrue
						local offsetFalseDelta = offsetFalseStart - currentOffsetFalse

						self:ApplyPosToRelativeKeys(moho, layer, curvatureChannel, curvatureDelta, targetFrames)
						self:ApplyPosToRelativeKeys(moho, layer, weightTrueChannel, weightTrueDelta, targetFrames)
						self:ApplyPosToRelativeKeys(moho, layer, weightFalseChannel, weightFalseDelta, targetFrames)
						self:ApplyPosToRelativeKeys(moho, layer, offsetTrueChannel, offsetTrueDelta, targetFrames)
						self:ApplyPosToRelativeKeys(moho, layer, offsetFalseChannel, offsetFalseDelta, targetFrames)
					end
				end
				self.curvatureChannelsList = {}
				self.curvatureStartList = {}
				self.offsetTrueStartList = {}
				self.offsetFalseStartList = {}
				self.weightTrueStartList = {}
				self.weightFalseStartList = {}
			end
		end

		self.scaleList = nil
		self.layersList = nil
		self.selList = nil
		self.posList = nil
		self.startPosList = nil
		self.clusterList = nil
		self.curvatureLayerList = nil
		self.curvatureChannelsList = nil
		self.pointsLayerList = nil
		self.handleList = nil
		self.curvatureStartList = nil
		self.offsetTrueStartList = nil
		self.offsetFalseStartList = nil
		self.weightTrueStartList = nil
		self.weightFalseStartList = nil
		moho:UpdateSelectedChannels()
		moho:UpdateUI()
		self.inProgressIcon = false
		mouseEvent.view:DrawMe()
		return
	end

	self.handlesTransformationActive = false
	self.handleList = {}

	self.dragging = false
	self.dragVec:Set(mouseEvent.vec)
	self.axisMove = 0
	self.drawHandles = false
	self.rotating = false
	
	if self.layersIsolation then
		moho:UpdateSelectedChannels()
		self.selectionMode = false
		self.layersIsolation = false
		mouseEvent.view:DrawMe()
		return
	end

	if (self.dragResize) then
		self.dragResize = false
		mouseEvent.view:DrawMe()
		return
	elseif self.selectionMode and self.selectPoints then
		mouseEvent.ctrlKey = false

		local layersList = {}
		if next(self.isolatedLayerUUIDList) then
			for i, layerUUID in pairs(self.isolatedLayerUUIDList) do
				local targetLayerIndex = tonumber(i)-1
				local layer = moho.document:LayerByAbsoluteID(targetLayerIndex)
				if layer then
					if layer:UUID() == layerUUID then
						if self:IsLayerValidForWarpMode(moho, layer) then
							local isLayerOk = true
							if layer == moho.layer then
								isLayerOk = true
							elseif layer:IsWarpLayer() and self.warpMode then
								local layerSkeleton = layer:ControllingSkeleton()
								isLayerOk = MR_Utilities:IsLayerActive(moho, layer, layerSkeleton)
							elseif self.visibleLayersOnly then
								local layerSkeleton = layer:ControllingSkeleton()
								isLayerOk = MR_Utilities:IsLayerVisible(moho, layer, layerSkeleton, true)
							end
							if isLayerOk then
								table.insert(layersList, targetLayerIndex)
							end
						end
					end
				end
			end
		else
			layersList = self:ScanLayers(moho, true)
		end

		for l, layerIndex in ipairs(layersList) do
			local layer = moho.document:LayerByAbsoluteID(layerIndex)
			if layer then
				local vectorLayer = moho:LayerAsVector(layer)
				local mesh = vectorLayer:Mesh()

				local mouseVec = LM.Vector2:new_local()
				mouseVec:Set(mouseEvent.vec)
				if layer ~= moho.layer then
					mouseVec = MR_Utilities:GetGlobalPos(moho, moho.layer, mouseVec, false)
					mouseVec = MR_Utilities:GetLocalPos(moho, layer, mouseVec, false)
				end
				local pointID = mesh:ClosestPoint(mouseVec)
				if pointID > -1 then
					local pt = mesh:Point(pointID)
					local pointPos = LM.Vector2:new_local()
					pointPos:Set(pt.fPos)
					local p1 = LM.Point:new_local()
					local p2 = LM.Point:new_local()

					if layer ~= moho.layer then
						pointPos = MR_Utilities:GetGlobalPos(moho, layer, pointPos, false)
						pointPos = MR_Utilities:GetLocalPos(moho, moho.layer, pointPos, false)
					end

					mouseEvent.view:Graphics():WorldToScreen(self.dragVec, p1)
					mouseEvent.view:Graphics():WorldToScreen(pointPos, p2)
					p2.x = p1.x - p2.x
					p2.y = p1.y - p2.y
					local dist = (p2.x * p2.x) + (p2.y * p2.y)
					if dist <= self.cursorToPointDistance then
						if not mouseEvent.shiftKey and not mouseEvent.altKey then
							mesh:SelectNone()
						end
						if pointID ~= -1 then
							local point = mesh:Point(pointID)
							if os.clock() - self.time >= tonumber(self.longPressTime) then
								if mouseEvent.altKey then
									for j = 0, point:CountCurves() - 1 do
										local curve, ptPos = point:Curve(j, -1)
										curve:DeselectCurvePoints()
									end
								else	
									for j = 0, point:CountCurves() - 1 do
										local curve, ptPos = point:Curve(j, -1)
										curve:SelectCurvePoints()
									end
								end
							else
								point.fSelected = not mouseEvent.altKey
								if self.autoConnectSelected then
									if mouseEvent.altKey then
										for j = 0, point:CountCurves() - 1 do
											local curve, ptPos = point:Curve(j, -1)
											curve:DeselectCurvePoints()
										end
									else
										for j = 0, point:CountCurves() - 1 do
											local curve, ptPos = point:Curve(j, -1)
											curve:SelectCurvePoints()
										end
									end
								end
							end
						end
					else
						if not mouseEvent.shiftKey and not mouseEvent.altKey then
							mesh:SelectNone()
						end
					end
				end

				self.isMouseDragging = false

				if self.lassoMode then
					local g = mouseEvent.view:Graphics()

					local end1 = LM.Vector2:new_local()
					local end2 = LM.Vector2:new_local()
					g:Clear(0, 0, 0, 0)
					g:Push()
					local m = g:CurrentTransform()
					m:Invert()
					g:ApplyMatrix(m)
					g:SetColor(255, 255, 255, 255)
					g:BeginShape()
					for i = 1, #self.lassoList - 1 do
						end1:Set(self.lassoList[i][1], self.lassoList[i][2])
						end2:Set(self.lassoList[i + 1][1], self.lassoList[i + 1][2])
						g:AddLine(end1, end2)
					end
					end1:Set(self.lassoList[#self.lassoList][1], self.lassoList[#self.lassoList][2])
					end2:Set(self.lassoList[1][1], self.lassoList[1][2])
					g:AddLine(end1, end2)
					g:EndShape()
					g:Pop()

					local v = LM.Vector2:new_local()
					local screenPt = LM.Point:new_local()
					local m = LM.Matrix:new_local()

					layer:GetFullTransform(moho.frame, m, moho.document)
					for i = 0, mesh:CountPoints() - 1 do
						local pt = mesh:Point(i)

						if (not pt.fHidden) then
							v:Set(pt.fPos)
							m:Transform(v)
							g:WorldToScreen(v, screenPt)
							if (g:IsFullWhite(screenPt)) then
								if (mouseEvent.altKey) then
									pt.fSelected = false
								else
									pt.fSelected = true
								end
								if self.autoConnectSelected then
									if mouseEvent.altKey then
										for j = 0, pt:CountCurves() - 1 do
											local curve, ptPos = pt:Curve(j, -1)
											curve:DeselectCurvePoints()
										end
									else
										for j = 0, pt:CountCurves() - 1 do
											local curve, ptPos = pt:Curve(j, -1)
											curve:SelectCurvePoints()
										end
									end
								end
							end
						end
					end
				else
					local screenPt = LM.Point:new_local()
					local m = LM.Matrix:new_local()
					self.selRect:Normalize()
					layer:GetFullTransform(moho.frame, m, moho.document)
					local v = LM.Vector2:new_local()
					for i = 0, mesh:CountPoints() - 1 do
						local pt = mesh:Point(i)
						if (not pt.fHidden) then
							v:Set(pt.fPos)
							m:Transform(v)
							mouseEvent.view:Graphics():WorldToScreen(v, screenPt)
							if (self.selRect:Contains(screenPt)) then
								if (mouseEvent.altKey) then
									pt.fSelected = false
								else
									pt.fSelected = true
								end
								if self.autoConnectSelected then
									if mouseEvent.altKey then
										for j = 0, pt:CountCurves() - 1 do
											local curve, ptPos = pt:Curve(j, -1)
											curve:DeselectCurvePoints()
										end
									else
										for j = 0, pt:CountCurves() - 1 do
											local curve, ptPos = pt:Curve(j, -1)
											curve:SelectCurvePoints()
										end
									end
								end
							end
						end
					end
				end
			end
		end

		self.lassoList = nil
		moho:UpdateSelectedChannels()
		self.selectionMode = false
		mouseEvent.view:DrawMe()
		return
	elseif self.selectionMode and not self.selectPoints then --
		mouseEvent.ctrlKey = false

		if not mouseEvent.shiftKey and not mouseEvent.altKey then
			self.isolatedLayerUUIDList = {}
		end

		local layersList = self:ScanLayers(moho, true)
		for l, layerIndex in ipairs(layersList) do
			local layer = moho.document:LayerByAbsoluteID(layerIndex)
			if layer then
				local vectorLayer = moho:LayerAsVector(layer)
				local mesh = vectorLayer:Mesh()

				local mouseVec = LM.Vector2:new_local()
				mouseVec:Set(mouseEvent.vec)
				if layer ~= moho.layer then
					mouseVec = MR_Utilities:GetGlobalPos(moho, moho.layer, mouseVec, false)
					mouseVec = MR_Utilities:GetLocalPos(moho, layer, mouseVec, false)
				end
				local pointID = mesh:ClosestPoint(mouseVec)
				if pointID > -1 then
					local pt = mesh:Point(pointID)
					local pointPos = LM.Vector2:new_local()
					pointPos:Set(pt.fPos)
					local p1 = LM.Point:new_local()
					local p2 = LM.Point:new_local()

					if layer ~= moho.layer then
						pointPos = MR_Utilities:GetGlobalPos(moho, layer, pointPos, false)
						pointPos = MR_Utilities:GetLocalPos(moho, moho.layer, pointPos, false)
					end

					mouseEvent.view:Graphics():WorldToScreen(self.dragVec, p1)
					mouseEvent.view:Graphics():WorldToScreen(pointPos, p2)
					p2.x = p1.x - p2.x
					p2.y = p1.y - p2.y
					local dist = (p2.x * p2.x) + (p2.y * p2.y)
					if dist <= self.cursorToPointDistance then
						local layerUUID = layer:UUID()
						if mouseEvent.shiftKey and not mouseEvent.altKey then
							self.isolatedLayerUUIDList[layerIndex+1] = layerUUID
						elseif not mouseEvent.shiftKey and mouseEvent.altKey then
							self.isolatedLayerUUIDList[layerIndex+1] = nil
						else
							if not listCleared then
								self.isolatedLayerUUIDList = {}
								listCleared = true
							end
							self.isolatedLayerUUIDList[layerIndex+1] = layerUUID
						end
					end
				end

				self.isMouseDragging = false

				if self.lassoMode then
					local g = mouseEvent.view:Graphics()

					local end1 = LM.Vector2:new_local()
					local end2 = LM.Vector2:new_local()
					g:Clear(0, 0, 0, 0)
					g:Push()
					local m = g:CurrentTransform()
					m:Invert()
					g:ApplyMatrix(m)
					g:SetColor(255, 255, 255, 255)
					g:BeginShape()
					for i = 1, #self.lassoList - 1 do
						end1:Set(self.lassoList[i][1], self.lassoList[i][2])
						end2:Set(self.lassoList[i + 1][1], self.lassoList[i + 1][2])
						g:AddLine(end1, end2)
					end
					end1:Set(self.lassoList[#self.lassoList][1], self.lassoList[#self.lassoList][2])
					end2:Set(self.lassoList[1][1], self.lassoList[1][2])
					g:AddLine(end1, end2)
					g:EndShape()
					g:Pop()

					local v = LM.Vector2:new_local()
					local screenPt = LM.Point:new_local()
					local m = LM.Matrix:new_local()

					layer:GetFullTransform(moho.frame, m, moho.document)
					for i = 0, mesh:CountPoints() - 1 do
						local pt = mesh:Point(i)

						if (not pt.fHidden) then
							v:Set(pt.fPos)
							m:Transform(v)
							g:WorldToScreen(v, screenPt)
							if (g:IsFullWhite(screenPt)) then
								local layerUUID = layer:UUID()
								if mouseEvent.shiftKey and not mouseEvent.altKey then
									self.isolatedLayerUUIDList[layerIndex+1] = layerUUID
								elseif not mouseEvent.shiftKey and mouseEvent.altKey then
									self.isolatedLayerUUIDList[layerIndex+1] = nil
								else
									if not listCleared then
										self.isolatedLayerUUIDList = {}
										listCleared = true
									end

									self.isolatedLayerUUIDList[layerIndex+1] = layerUUID
								end
							end
						end
					end
				else
					local screenPt = LM.Point:new_local()
					local m = LM.Matrix:new_local()
					self.selRect:Normalize()
					layer:GetFullTransform(moho.frame, m, moho.document)
					local v = LM.Vector2:new_local()
					for i = 0, mesh:CountPoints() - 1 do
						local pt = mesh:Point(i)
						if (not pt.fHidden) then
							v:Set(pt.fPos)
							m:Transform(v)
							mouseEvent.view:Graphics():WorldToScreen(v, screenPt)
							if (self.selRect:Contains(screenPt)) then
								local layerUUID = layer:UUID()
								if mouseEvent.shiftKey and not mouseEvent.altKey then
									self.isolatedLayerUUIDList[layerIndex+1] = layerUUID
								elseif not mouseEvent.shiftKey and mouseEvent.altKey then
									self.isolatedLayerUUIDList[layerIndex+1] = nil
								else
									if not listCleared then
										self.isolatedLayerUUIDList = {}
										listCleared = true
									end
									self.isolatedLayerUUIDList[layerIndex+1] = layerUUID
								end
							end
						end
					end
				end
			end
		end

		self.lassoList = nil
		moho:UpdateSelectedChannels()
		self.selectionMode = false
		mouseEvent.view:DrawMe()
		return
	end

	if self.transformBoxMode then
		self:OnMouseUpTransformBoxMode(moho, mouseEvent)
		return
	end

	local targetFrames = {}

	self.inProgressIcon = true
	mouseEvent.view:DrawMe()

	if MOHO.MohoGlobals.EditMultipleKeys then
		local markersChannel = moho:ChannelAsAnimString(moho.layer.fTimelineMarkers)
		local timingOffset = moho.layer:TotalTimingOffset()

		for i = 0, markersChannel:CountKeys() - 1 do
			if markersChannel:IsKeySelectedByID(i) then
				local frame = math.floor(markersChannel:GetKeyWhen(i))
				if frame > 0 then
					local markerText = markersChannel:GetValue(frame)
					local markerVal = tonumber(string.match(markerText, "%d+"))
					markerVal = math.floor(markerVal)
					targetFrames[markerVal] = true
				end
			end
		end
	end

	if self.singlePos and MOHO.MohoGlobals.EditMultipleKeys then
		if next(targetFrames) then
			for i, layerIndex in ipairs(self.layersList) do
				local layer = moho.document:LayerByAbsoluteID(layerIndex)
				local layerFrame = layer:DocToLayerFrame(moho.frame)

				for p, pt in ipairs(self.selList[i]) do
					local pointCurvatureChannelsList = self.curvatureChannelsList[i][p]
					local curvatureStartList = self.curvatureStartList[i][p]
					local offsetTrueStartList = self.offsetTrueStartList[i][p]
					local offsetFalseStartList = self.offsetFalseStartList[i][p]
					local weightTrueStartList = self.weightTrueStartList[i][p]
					local weightFalseStartList = self.weightFalseStartList[i][p]
					
					for j = 0, pt:CountCurves() - 1 do
						local curve, ptPos = pt:Curve(j, -1)
						
						local curvatureChannel = pointCurvatureChannelsList.curvature[j+1]
						local weightTrueChannel = pointCurvatureChannelsList.weightTrue[j+1]
						local weightFalseChannel = pointCurvatureChannelsList.weightFalse[j+1]
						local offsetTrueChannel = pointCurvatureChannelsList.offsetTrue[j+1]
						local offsetFalseChannel = pointCurvatureChannelsList.offsetFalse[j+1]
						
						local curvatureStart = curvatureStartList[j+1]
						local weightTrueStart = weightTrueStartList[j+1]
						local weightFalseStart = weightFalseStartList[j+1]
						local offsetTrueStart = offsetTrueStartList[j+1]
						local offsetFalseStart = offsetFalseStartList[j+1]
						
						local currentCurvature = curvatureChannel:GetValue(layerFrame)
						local currentWeightTrue = weightTrueChannel:GetValue(layerFrame)
						local currentWeightFalse = weightFalseChannel:GetValue(layerFrame)
						local currentOffsetTrue = offsetTrueChannel:GetValue(layerFrame)
						local currentOffsetFalse = offsetFalseChannel:GetValue(layerFrame)
						
						local curvatureDelta = curvatureStart - currentCurvature
						local weightTrueDelta = weightTrueStart - currentWeightTrue
						local weightFalseDelta = weightFalseStart - currentWeightFalse
						local offsetTrueDelta = offsetTrueStart - currentOffsetTrue
						local offsetFalseDelta = offsetFalseStart - currentOffsetFalse
						
						self:ApplyPosToRelativeKeys(moho, layer, curvatureChannel, curvatureDelta, targetFrames)
						self:ApplyPosToRelativeKeys(moho, layer, weightTrueChannel, weightTrueDelta, targetFrames)
						self:ApplyPosToRelativeKeys(moho, layer, weightFalseChannel, weightFalseDelta, targetFrames)
						self:ApplyPosToRelativeKeys(moho, layer, offsetTrueChannel, offsetTrueDelta, targetFrames)
						self:ApplyPosToRelativeKeys(moho, layer, offsetFalseChannel, offsetFalseDelta, targetFrames)
					end
				end
			end
			self.curvatureChannelsList = {}
			self.curvatureStartList = {}
			self.offsetTrueStartList = {}
			self.offsetFalseStartList = {}
			self.weightTrueStartList = {}
			self.weightFalseStartList = {}

			self.singlePos = false
		end
	end

	self.singlePos = false

	if mouseEvent.shiftKey then
		moho:AddPointKeyframe(moho.frame, nil, false)
		if MOHO.MohoGlobals.EditMultipleKeys then
			for i, layerIndex in ipairs(self.layersList) do
				local layer = moho.document:LayerByAbsoluteID(layerIndex)
				local layerFrame = layer:DocToLayerFrame(moho.frame)
				local vectorLayer = moho:LayerAsVector(layer)
				local mesh = vectorLayer:Mesh()
				for p, pt in ipairs(self.selList[i]) do
					local startPos = self.startPosList[i][p]
					local delta = LM.Vector2:new_local()
					delta:Set(startPos - pt.fAnimPos:GetValue(layerFrame))
					local channel = moho:ChannelAsAnimVec2(pt.fAnimPos)
					self:ApplyPosToRelativeKeys(moho, layer, channel, delta, targetFrames)

					for j = 0, pt:CountCurves() - 1 do
						local curve, ptPos = pt:Curve(j, -1)

						local curvatureChannel = curve:Curvature(ptPos)
						local offsetTrueChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, true)
						local offsetFalseChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, false)
						local weightTrueChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, true)
						local weightFalseChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, false)

						local curvatureStart = self.curvatureStartList[i][p][j+1]
						local weightTrueStart = self.weightTrueStartList[i][p][j+1]
						local weightFalseStart = self.weightFalseStartList[i][p][j+1]
						local offsetTrueStart = self.offsetTrueStartList[i][p][j+1]
						local offsetFalseStart = self.offsetFalseStartList[i][p][j+1]

						local currentCurvature = curvatureChannel:GetValue(layerFrame)
						local currentWeightTrue = weightTrueChannel:GetValue(layerFrame)
						local currentWeightFalse = weightFalseChannel:GetValue(layerFrame)
						local currentOffsetTrue = offsetTrueChannel:GetValue(layerFrame)
						local currentOffsetFalse = offsetFalseChannel:GetValue(layerFrame)

						local curvatureDelta = curvatureStart - currentCurvature
						local weightTrueDelta = weightTrueStart - currentWeightTrue
						local weightFalseDelta = weightFalseStart - currentWeightFalse
						local offsetTrueDelta = offsetTrueStart - currentOffsetTrue
						local offsetFalseDelta = offsetFalseStart - currentOffsetFalse

						self:ApplyPosToRelativeKeys(moho, layer, curvatureChannel, curvatureDelta, targetFrames)
						self:ApplyPosToRelativeKeys(moho, layer, weightTrueChannel, weightTrueDelta, targetFrames)
						self:ApplyPosToRelativeKeys(moho, layer, weightFalseChannel, weightFalseDelta, targetFrames)
						self:ApplyPosToRelativeKeys(moho, layer, offsetTrueChannel, offsetTrueDelta, targetFrames)
						self:ApplyPosToRelativeKeys(moho, layer, offsetFalseChannel, offsetFalseDelta, targetFrames)
					end
				end
			end
		end
		moho:UpdateUI()
	else
		if self.movement then
			for i, layerIndex in ipairs(self.layersList) do
				local layer = moho.document:LayerByAbsoluteID(layerIndex)
				local layerFrame = layer:DocToLayerFrame(moho.frame)
				local vectorLayer = moho:LayerAsVector(layer)
				local mesh = vectorLayer:Mesh()

				moho:AddPointKeyframe(moho.frame, layer)

				for p, pt in ipairs(self.selList[i]) do
					local delta = self.posList[i][p] - pt.fPos
					pt.fPos = self.posList[i][p] + delta
				end
				moho:AddPointKeyframe(moho.frame, layer)

				local treshold = 0.00001
				for p, pt in ipairs(self.selList[i]) do
					if math.abs(self.posList[i][p].x - pt.fPos.x) >= treshold or math.abs(self.posList[i][p].y - pt.fPos.y) >= treshold then
						local startPos = self.startPosList[i][p]
						local delta = LM.Vector2:new_local()
						delta:Set(startPos - pt.fAnimPos:GetValue(moho.frame))
						pt.fAnimPos:SetValue(layerFrame, pt.fAnimPos:GetValue(layerFrame) + delta / 2)
					end
				end

				if MOHO.MohoGlobals.EditMultipleKeys then
					for p, pt in ipairs(self.selList[i]) do
						local startPos = self.startPosList[i][p]
						local delta = LM.Vector2:new_local()
						delta:Set(startPos - pt.fAnimPos:GetValue(layerFrame))
						local channel = moho:ChannelAsAnimVec2(pt.fAnimPos)
						self:ApplyPosToRelativeKeys(moho, layer, channel, delta, targetFrames)
					end
				end

				layer:FreeCachedImage()
			end
		end
	end

	self.movement = false

	if self.selectedOnly then
		for l, layerIndex in ipairs(self.layersList) do
			local layer = moho.document:LayerByAbsoluteID(layerIndex)
			if layer then
				local vectorLayer = moho:LayerAsVector(layer)
				local mesh = vectorLayer:Mesh()

				for p = 0, mesh:CountPoints() - 1 do
					local point = mesh:Point(p)
					point.fSelected = self.selectionList[l][p+1]
				end
			end
		end
	end

	for l = 0, moho.document:CountSelectedLayers()-1 do
		local layer = moho.document:GetSelectedLayer(l)
		layer:UpdateCurFrame()
	end

	if self.ignoreReferenceLayers and self.autoUpdateReferenceLayers then
		local count = 0
		repeat
			local layer = moho.document:LayerByAbsoluteID(count)
			if layer then
				if layer:IsReferencedLayer() then
					layer:MarkReferenceOutdated()
					layer:UpdateCurFrame()
				end
				count = count + 1
			end
		until not layer
	end

	if self.hideCurvesWhileDragging then
		moho.view:SetQualityFlags(self.currentQualityFlags)
	end

	self.scaleList = nil
	self.layersList = nil
	self.selList = nil
	self.posList = nil
	self.startPosList = nil
	self.clusterList = nil
	self.curvatureLayerList = nil
	self.curvatureChannelsList = nil
	self.pointsLayerList = nil
	self.handleList = nil
	self.curvatureStartList = nil
	self.offsetTrueStartList = nil
	self.offsetFalseStartList = nil
	self.weightTrueStartList = nil
	self.weightFalseStartList = nil

	self.inProgressIcon = false
	mouseEvent.view:DrawMe()
	moho:UpdateUI()
end

function MR_AnimatePoints:OnKeyDown(moho, keyEvent)
	if keyEvent.keyCode == LM.GUI.KEY_BIND then
		self:SelectConnectedPoints(moho)
	end
	if keyEvent.keyCode == 96 then -- tilta
		self.selectPoints = not self.selectPoints
		self.isolateLayers = not self.isolateLayers
	end
	if keyEvent.keyCode == LM.GUI.KEY_BIND and keyEvent.shiftKey then
		self:KeyframesToMarkers(moho)
	end
end

function MR_AnimatePoints:DrawMe(moho, view)
	if moho:IsPlaying() then
		return
	end

	if (self.blockOnEvenFrames and moho.frame % 2 == 0 or self.blockOnOddFrames and not (moho.frame % 2 == 0)) and self.twosMode and moho.frame > 0 then
		return
	end

	if self.selectionMode then
		if self.lassoMode then
			local g = view:Graphics()
			g:SetSmoothing(true)
			g:SetPenWidth(2)
			g:Push()
			local m = g:CurrentTransform()
			m:Invert()
			g:ApplyMatrix(m)
			g:SetColor(MOHO.MohoGlobals.SelCol)
			g:MoveTo(self.lassoList[1][1], self.lassoList[1][2])
			for i = 2, #self.lassoList do
				g:LineTo(self.lassoList[i][1], self.lassoList[i][2])
			end
			g:Pop()
		else
			local g = view:Graphics()
			local matrix = LM.Matrix:new_local()
			moho.layer:GetFullTransform(moho.frame, matrix, moho.document)
			g:Push()
			g:ApplyMatrix(matrix)
			g:SelectionRect(self.selRect)
			g:Pop()
		end
	end

	if not self.transformBoxMode then
		if not self.rotating and not self.selectionMode and not self.handlesTransformationActive and not self.ctrlPressed then
			self:DrawToolSizeCircle(moho, view, self.dragVec, self.magnetRadius, self.dragResize)
			self:DrawToolSizeCircle(moho, view, self.dragVec, self.magnetRadius * self.innerRadius, self.dragResize)
		end
	end

	if self.selectionMode then
		local g = view:Graphics()
		g:SetSmoothing(true)
		g:Push()

		for i, layersPointsList in ipairs(self.layersPointsList) do
			local layerIndex = self.layersList[i]
			local col = LM.rgb_color:new_local()
			for j = 1, #layersPointsList.pos do
				local idx = layersPointsList.col[j]

				if layersPointsList.isSelected[j] then
					if self.useSingleColor then
						col.r = self.pointsColor.r
						col.g = self.pointsColor.g
						col.b = self.pointsColor.b
						col.a = layersPointsList.a[j]
						g:SetColor(col)
					else
						col.r = self["color"..idx].r
						col.g = self["color"..idx].g
						col.b = self["color"..idx].b
						col.a = layersPointsList.a[j]
						g:SetColor(col)
					end
				elseif not layersPointsList.isSelected[j] then
					if self.useSingleColor then
						g:SetColor(self.pointsColor.r, self.pointsColor.g, self.pointsColor.b, layersPointsList.a[j])
						col.r = self.pointsColor.r
						col.g = self.pointsColor.g
						col.b = self.pointsColor.b
						col.a = layersPointsList.a[j]
					else
						g:SetColor(self["color"..idx].r, self["color"..idx].g, self["color"..idx].b, layersPointsList.a[j])
						col.r = self["color"..idx].r
						col.g = self["color"..idx].g
						col.b = self["color"..idx].b
						col.a = layersPointsList.a[j]
					end
				end

				g:FillCirclePixelRadius(layersPointsList.pos[j], layersPointsList.radius[j])
				if self.warpMode and j == 1 then
					local layer = moho.document:LayerByAbsoluteID(layerIndex)
					local vectorLayer = moho:LayerAsVector(layer)
					local mesh = vectorLayer:Mesh()
					local opacityMultiplier = 1
					if self.warpMode and vectorLayer:IsCurver() then
						opacityMultiplier = self.warpOpacity
					elseif self.warpMode and vectorLayer:IsWarpLayer() then
						opacityMultiplier = self.warpOpacity
					else
						opacityMultiplier = self.pointsOpacity
					end
					self:DrawCurve(moho, mouseEvent, layer, g, mesh, col, opacityMultiplier)
				end
			end
		end
		g:Pop()
		return
	end

	local isHandlesValid = true
	local arePointsSelected = false
	local testPos = nil

	if not self.dragging and self.selectPoints and self.showHandles then
		self.handleList = {}
	end

	if self.transformBoxMode and ((not self.ctrlPressed and not self.transformBoxDragging) or self.transformBoxDragging) then
		if self.drawPoints then
			if (self.transformBoxDragging and self.drawPointsdrawPointsWhileDragging) or not self.transformBoxDragging then
				local g = view:Graphics()
				self:DrawPoints(moho, view, g)
			end
		end
	else
		if self.drawPoints and not self.dragResize then
			local g = view:Graphics()
			local currentScale = g:CurrentScale(false)
			local height = g:Height() / 1080
			g:SetSmoothing(true)
			local radius = 18
			
			if self.pointsColor then
				g:SetColor(self.pointsColor)
			end

			if self.dragging then
				if self.layersList and self.drawPointsdrawPointsWhileDragging then
					for i, layerIndex in ipairs(self.layersList) do
						local layer = moho.document:LayerByAbsoluteID(layerIndex)
						if layer then
							local vectorLayer = moho:LayerAsVector(layer)

							local opacityMultiplier = 1
							local selectedRadiusMultiplier = self.selectedPointM
							radius = 18
							if self.warpMode and vectorLayer:IsCurver() then
								selectedRadiusMultiplier = self.selectedCurverM
								opacityMultiplier = self.warpOpacity
								radius = 28
							elseif self.warpMode and vectorLayer:IsWarpLayer() then
								selectedRadiusMultiplier = self.selectedWarpM
								opacityMultiplier = self.warpOpacity
								radius = 19
							else
								opacityMultiplier = self.pointsOpacity
							end

							local col = LM.rgb_color:new_local()
							for p, pt in ipairs(self.selList[i]) do
								if self.useSingleColor then
									col.r = self.pointsColorR
									col.g = self.pointsColorG
									col.b = self.pointsColorB
									col.a = self.pointsColorA
								else
									local idx = (math.floor(layerIndex) % 20) + 1
									col.r = self["color"..idx].r
									col.g = self["color"..idx].g
									col.b = self["color"..idx].b
									col.a = self["color"..idx].a
								end
								if col then
									if pt.fSelected then
										g:SetColor(col.r, col.g, col.b, 255 * opacityMultiplier)
									else
										g:SetColor(col.r, col.g, col.b, 150 * opacityMultiplier)
									end
								end
								local v1 = LM.Vector2:new_local()
								v1:Set(pt.fPos)
								v1 = MR_Utilities:GetGlobalPos(moho, layer, v1, true)
								g:FillCirclePixelRadius(v1, (radius * selectedRadiusMultiplier) * self.pointsSize)
							end

							if self.warpMode then
								local mesh = vectorLayer:Mesh()
								local opacityMultiplier = 1
								if self.warpMode and vectorLayer:IsCurver() then
									opacityMultiplier = self.warpOpacity
								elseif self.warpMode and vectorLayer:IsWarpLayer() then
									opacityMultiplier = self.warpOpacity
								else
									opacityMultiplier = self.pointsOpacity
								end
								self:DrawCurve(moho, mouseEvent, layer, g, mesh, col, opacityMultiplier)
							end
						end
					end
				end
			else
				local areIsolatedLayers = next(self.isolatedLayerUUIDList)
				if next(self.isolatedLayerUUIDList) and ((not self.ctrlPressed and not self.selectPoints) or self.selectPoints) then
					for i, layerUUID in pairs(self.isolatedLayerUUIDList) do
						local layerIndex = tonumber(i)-1
						local layer = moho.document:LayerByAbsoluteID(layerIndex)
						if layer then
							if layer:UUID() == layerUUID then
								if self:IsLayerValidForWarpMode(moho, layer) then
									local isLayerOk = true
									if layer == moho.layer then
										isLayerOk = true
									elseif layer:IsWarpLayer() and self.warpMode then
										local layerSkeleton = layer:ControllingSkeleton()
										isLayerOk = MR_Utilities:IsLayerActive(moho, layer, layerSkeleton)
									elseif self.visibleLayersOnly then
										local layerSkeleton = layer:ControllingSkeleton()
										isLayerOk = MR_Utilities:IsLayerVisible(moho, layer, layerSkeleton, true)
									end

									if isLayerOk then
										local layerFrame = layer:DocToLayerFrame(moho.frame)
										local layerIndex = math.floor(moho.document:LayerAbsoluteID(layer))
										local vectorLayer = moho:LayerAsVector(layer)
										if vectorLayer and (self.ignoreReferenceLayers and not layer:IsReferencedLayer() or not self.ignoreReferenceLayers) then
											local mesh = vectorLayer:Mesh()
											local mouseVec = LM.Vector2:new_local()
											mouseVec:Set(self.dragVec)

											local layerColorChanged = false

											local pointPosList = {}
											pointPosList.handleTrue = {}
											pointPosList.handleFalse = {}
											pointPosList.point = {}

											local opacityMultiplier = 1
											local selectedRadiusMultiplier = self.selectedPointM
											radius = 18
											if self.warpMode and vectorLayer:IsCurver() then
												selectedRadiusMultiplier = self.selectedCurverM
												opacityMultiplier = self.warpOpacity
												radius = 28
											elseif self.warpMode and vectorLayer:IsWarpLayer() then
												selectedRadiusMultiplier = self.selectedWarpM
												opacityMultiplier = self.warpOpacity
												radius = 19
											else
												opacityMultiplier = self.pointsOpacity
											end

											local col = LM.ColorVector:new_local()
											for i = 0, mesh:CountPoints() - 1 do
												local pt = mesh:Point(i)
												if not pt.fHidden then
													if self.showHandles and self.selectPoints then
														if pt.fSelected then
															arePointsSelected = true
															if not testPos then
																testPos = MR_Utilities:GetGlobalPos(moho, layer, pt.fPos, false)
															else
																local globalPos = MR_Utilities:GetGlobalPos(moho, layer, pt.fPos, false)
																if testPos.x ~= globalPos.x or testPos.y ~= globalPos.y then
																	isHandlesValid = false
																end
															end

															if not self.dragging and isHandlesValid then
																for j = 0, pt:CountCurves() - 1 do
																	local curve, ptPos = pt:Curve(j, -1)

																	local handlePosTrue = curve:GetControlHandle(ptPos, layerFrame, true)
																	local handlePosFalse = curve:GetControlHandle(ptPos, layerFrame, false)
																	local pointPos = MR_Utilities:GetGlobalPos(moho, layer, pt.fPos, true)
																	if curve:GetCurvature(ptPos, layerFrame) == 0 then
																		table.insert(pointPosList.handleTrue, pointPos)
																		table.insert(pointPosList.handleFalse, pointPos)
																	else
																		table.insert(pointPosList.handleTrue, MR_Utilities:GetGlobalPos(moho, layer, handlePosTrue, true))
																		table.insert(pointPosList.handleFalse, MR_Utilities:GetGlobalPos(moho, layer, handlePosFalse, true))
																	end
																	table.insert(pointPosList.point, pointPos)
																end
																table.insert(self.handleList, pointPosList)
															end
														end
													end

													local v = MR_Utilities:GetGlobalPos(moho, layer, pt.fPos, false)
													v = MR_Utilities:GetLocalPos(moho, moho.layer, v, false) - mouseVec
													local magInfluence = v:Mag()

													if magInfluence <= self.magnetRadius or (self.ctrlPressed and self.selectPoints) then
														if not layerColorChanged or self.selectPoints then
															if not self.useSingleColor then
																local idx = (math.floor(layerIndex) % 20) + 1
																col = self["color"..idx]
															else
																col.r = self.pointsColorR
																col.g = self.pointsColorG
																col.b = self.pointsColorB
																col.a = self.pointsColorA * opacityMultiplier
															end
															layerColorChanged = true
														end
														if col then
															if self.ctrlPressed then
																if self.selectPoints and not pt.fSelected then
																	g:SetColor(col.r, col.g, col.b, 150 * opacityMultiplier)
																else
																	g:SetColor(col.r, col.g, col.b, 255 * opacityMultiplier)
																end
															else
																if (self.selectPoints or self.selectedOnly) and not pt.fSelected then
																	g:SetColor(col.r, col.g, col.b, 150 * opacityMultiplier)
																else
																	g:SetColor(col.r, col.g, col.b, 255 * opacityMultiplier)
																end
															end
														end

														local v1 = LM.Vector2:new_local()
														v1:Set(pt.fPos)
														v1 = MR_Utilities:GetGlobalPos(moho, layer, v1, true)
														if (self.selectPoints or self.selectedOnly and not self.ctrlPressed) or self.selectPoints then
															if pt.fSelected then
																g:FillCirclePixelRadius(v1, (radius * selectedRadiusMultiplier) * self.pointsSize)
															else
																g:FillCirclePixelRadius(v1, (radius * self.nonSelectedM) * self.pointsSize)
															end
														else
															if layerIsolated then
																g:FillCirclePixelRadius(v1, (radius * selectedRadiusMultiplier) * self.pointsSize)
															else
																g:FillCirclePixelRadius(v1, (radius * self.nonSelectedM) * self.pointsSize)
															end
														end
													end
												end
											end
											if self.warpMode then
												if not self.ctrlPressed then
													if not self.useSingleColor then
														local idx = (math.floor(layerIndex) % 20) + 1
														col = self["color"..idx]
													else
														col.r = self.pointsColorR
														col.g = self.pointsColorG
														col.b = self.pointsColorB
														col.a = self.pointsColorA
													end
												end
												self:DrawCurve(moho, mouseEvent, layer, g, mesh, col, opacityMultiplier)
												local mouseVec = LM.Vector2:new_local()
												mouseVec:Set(self.dragVec)
												if layer ~= moho.layer then
													mouseVec = MR_Utilities:GetGlobalPos(moho, moho.layer, mouseVec, false)
													mouseVec = MR_Utilities:GetLocalPos(moho, layer, mouseVec, false)
												end
												local pointID = mesh:ClosestPoint(mouseVec)
												if pointID > -1 then
													local v1 = LM.Vector2:new_local()
													local pt = mesh:Point(pointID)
													local pointPos = LM.Vector2:new_local()
													pointPos:Set(pt.fPos)

													if layer ~= moho.layer then
														pointPos = MR_Utilities:GetGlobalPos(moho, layer, pointPos, false)
														pointPos = MR_Utilities:GetLocalPos(moho, moho.layer, pointPos, false)
													end

													local p1 = LM.Point:new_local()
													local p2 = LM.Point:new_local()
													moho.view:Graphics():WorldToScreen(self.dragVec, p1)
													moho.view:Graphics():WorldToScreen(pointPos, p2)
													p2.x = p1.x - p2.x
													p2.y = p1.y - p2.y
													local dist = (p2.x * p2.x) + (p2.y * p2.y)
													if dist <= self.cursorToPointDistance then
														g:SetColor(col.r, col.g, col.b, 200)
														g:SetColor(col)
														v1:Set(pt.fPos)
														v1 = MR_Utilities:GetGlobalPos(moho, layer, v1, true)
														g:FillCirclePixelRadius(v1, radius * (selectedRadiusMultiplier * 1.2))
													end
												end
											elseif self.ctrlPressed then
												local mouseVec = LM.Vector2:new_local()
												mouseVec:Set(self.dragVec)
												if layer ~= moho.layer then
													mouseVec = MR_Utilities:GetGlobalPos(moho, moho.layer, mouseVec, false)
													mouseVec = MR_Utilities:GetLocalPos(moho, layer, mouseVec, false)
												end
												local pointID = mesh:ClosestPoint(mouseVec)
												if pointID > -1 then
													local v1 = LM.Vector2:new_local()
													local pt = mesh:Point(pointID)
													local pointPos = LM.Vector2:new_local()
													pointPos:Set(pt.fPos)
													local p1 = LM.Point:new_local()
													local p2 = LM.Point:new_local()

													if layer ~= moho.layer then
														pointPos = MR_Utilities:GetGlobalPos(moho, layer, pointPos, false)
														pointPos = MR_Utilities:GetLocalPos(moho, moho.layer, pointPos, false)
													end

													moho.view:Graphics():WorldToScreen(self.dragVec, p1)
													moho.view:Graphics():WorldToScreen(pointPos, p2)
													p2.x = p1.x - p2.x
													p2.y = p1.y - p2.y
													local dist = (p2.x * p2.x) + (p2.y * p2.y)
													if dist <= self.cursorToPointDistance then
														g:SetColor(col.r, col.g, col.b, 200)
														for i = 0, mesh:CountShapes() - 1 do
															local shape = mesh:Shape(i)
															if shape:ContainsPoint(pointID) then
																-- This part of the code is taken from A. Evseeva's AE Select Shape script
																local matrix = LM.Matrix:new_local()
																layer:GetFullTransform(moho.frame, matrix, moho.document)
																g:Push()
																g:ApplyMatrix(matrix)

																for e = 0, shape:CountEdges()-1 do
																	local c,p = shape:GetEdge(e)
																	local startPercent, endPercent = mesh:Curve(c):GetSegmentRange(p)
																	local step = (endPercent-startPercent)/10
																	local p1 = mesh:Curve(c):GetPercentLocation(startPercent)
																	for i=1,10 do
																		local nextPercent = startPercent + step * i
																	if nextPercent > endPercent then nextPercent = endPercent end
																		local p2 = mesh:Curve(c):GetPercentLocation(nextPercent)
																		g:DrawFatLine(5, p1.x, p1.y, p2.x, p2.y)
																		p1:Set(p2)
																	end
																end
																g:Pop()
																-- End of the code taken from A. Evseeva's script
															end
														end
														g:SetColor(col)
														v1:Set(pt.fPos)
														v1 = MR_Utilities:GetGlobalPos(moho, layer, v1, true)
														g:FillCirclePixelRadius(v1, radius * 0.4)
													end
												end
											end
										end
									end
								end
							end
						end
					end
				else
					local layersList = self:ScanLayers(moho, true)
					local col = LM.ColorVector:new_local()
					for l, layerIndex in ipairs(layersList) do
						local layer = moho.document:LayerByAbsoluteID(layerIndex)
						local layerFrame = layer:DocToLayerFrame(moho.frame)
						local vectorLayer = moho:LayerAsVector(layer)
						local mesh = vectorLayer:Mesh()
						local mouseVec = LM.Vector2:new_local()
						mouseVec:Set(self.dragVec)
						local layerColorChanged = false

						local pointPosList = {}
						pointPosList.handleTrue = {}
						pointPosList.handleFalse = {}
						pointPosList.point = {}

						local opacityMultiplier = 1
						local selectedRadiusMultiplier = self.selectedPointM
						radius = 18
						if self.warpMode and vectorLayer:IsCurver() then
							selectedRadiusMultiplier = self.selectedCurverM
							opacityMultiplier = self.warpOpacity
							radius = 28
						elseif self.warpMode and vectorLayer:IsWarpLayer() then
							selectedRadiusMultiplier = self.selectedWarpM
							opacityMultiplier = self.warpOpacity
							radius = 19
						else
							opacityMultiplier = self.pointsOpacity
						end

						for i = 0, mesh:CountPoints() - 1 do
							local pt = mesh:Point(i)
							if not pt.fHidden then
								if self.showHandles and self.selectPoints then
									if pt.fSelected then
										arePointsSelected = true
										if not testPos then
											testPos = MR_Utilities:GetGlobalPos(moho, layer, pt.fPos, false)
										else
											local globalPos = MR_Utilities:GetGlobalPos(moho, layer, pt.fPos, false)
											if testPos.x ~= globalPos.x or testPos.y ~= globalPos.y then
												isHandlesValid = false
											end
										end

										if not self.dragging and isHandlesValid then
											for j = 0, pt:CountCurves() - 1 do
												local curve, ptPos = pt:Curve(j, -1)

												local handlePosTrue = curve:GetControlHandle(ptPos, layerFrame, true)
												local handlePosFalse = curve:GetControlHandle(ptPos, layerFrame, false)
												local pointPos = MR_Utilities:GetGlobalPos(moho, layer, pt.fPos, true)
												if curve:GetCurvature(ptPos, layerFrame) == 0 then
													table.insert(pointPosList.handleTrue, pointPos)
													table.insert(pointPosList.handleFalse, pointPos)
												else
													table.insert(pointPosList.handleTrue, MR_Utilities:GetGlobalPos(moho, layer, handlePosTrue, true))
													table.insert(pointPosList.handleFalse, MR_Utilities:GetGlobalPos(moho, layer, handlePosFalse, true))
												end
												table.insert(pointPosList.point, pointPos)
											end
											table.insert(self.handleList, pointPosList)
										end
									end
								end

								local v = MR_Utilities:GetGlobalPos(moho, layer, pt.fPos, false)
								v = MR_Utilities:GetLocalPos(moho, moho.layer, v, false) - mouseVec
								local magInfluence = v:Mag()
								if magInfluence <= self.magnetRadius or self.ctrlPressed then
									local layerIsolated = self.isolatedLayerUUIDList[layerIndex+1]
									if not layerColorChanged or self.selectPoints then
										if not self.useSingleColor then
											local idx = (math.floor(layerIndex) % 20) + 1
											col = self["color"..idx]
										else
											col.r = self.pointsColorR
											col.g = self.pointsColorG
											col.b = self.pointsColorB
											col.a = self.pointsColorA * opacityMultiplier
										end
										layerColorChanged = true
									end
									if col then
										if self.ctrlPressed then
											if ((self.selectPoints) and not pt.fSelected) or (not self.selectPoints and ((not layerIsolated and areIsolatedLayers) or not areIsolatedLayers)) then
												g:SetColor(col.r, col.g, col.b, 150 * opacityMultiplier)
											else
												g:SetColor(col.r, col.g, col.b, 255 * opacityMultiplier)
											end
										else
											if ((self.selectPoints or self.selectedOnly) and not pt.fSelected) or ((not self.selectPoints and not layerIsolated) and areIsolatedLayers) then
												g:SetColor(col.r, col.g, col.b, 150 * opacityMultiplier)
											else
												g:SetColor(col.r, col.g, col.b, 255 * opacityMultiplier)
											end
										end
									end

									local v1 = LM.Vector2:new_local()
									v1:Set(pt.fPos)
									v1 = MR_Utilities:GetGlobalPos(moho, layer, v1, true)
									if (self.selectPoints or self.selectedOnly and not self.ctrlPressed) or self.selectPoints then
										if pt.fSelected then
											g:FillCirclePixelRadius(v1, (radius * selectedRadiusMultiplier) * self.pointsSize)
										else
											g:FillCirclePixelRadius(v1, (radius * self.nonSelectedM) * self.pointsSize)
										end
									else
										if layerIsolated then
											g:FillCirclePixelRadius(v1, (radius * selectedRadiusMultiplier) * self.pointsSize)
										else
											g:FillCirclePixelRadius(v1, (radius * self.nonSelectedM) * self.pointsSize)
										end
									end
								end
							end
						end
						if self.warpMode then
							if not self.ctrlPressed then
								if not self.useSingleColor then
									local idx = (math.floor(layerIndex) % 20) + 1
									col = self["color"..idx]
								else
									col.r = self.pointsColorR
									col.g = self.pointsColorG
									col.b = self.pointsColorB
									col.a = self.pointsColorA
								end
							end
							self:DrawCurve(moho, mouseEvent, layer, g, mesh, col, opacityMultiplier)
							local mouseVec = LM.Vector2:new_local()
							mouseVec:Set(self.dragVec)
							if layer ~= moho.layer then
								mouseVec = MR_Utilities:GetGlobalPos(moho, moho.layer, mouseVec, false)
								mouseVec = MR_Utilities:GetLocalPos(moho, layer, mouseVec, false)
							end
							local pointID = mesh:ClosestPoint(mouseVec)
							if pointID > -1 then
								local v1 = LM.Vector2:new_local()
								local pt = mesh:Point(pointID)
								local pointPos = LM.Vector2:new_local()
								pointPos:Set(pt.fPos)

								if layer ~= moho.layer then
									pointPos = MR_Utilities:GetGlobalPos(moho, layer, pointPos, false)
									pointPos = MR_Utilities:GetLocalPos(moho, moho.layer, pointPos, false)
								end

								local p1 = LM.Point:new_local()
								local p2 = LM.Point:new_local()
								moho.view:Graphics():WorldToScreen(self.dragVec, p1)
								moho.view:Graphics():WorldToScreen(pointPos, p2)
								p2.x = p1.x - p2.x
								p2.y = p1.y - p2.y
								local dist = (p2.x * p2.x) + (p2.y * p2.y)
								if dist <= self.cursorToPointDistance then
									g:SetColor(col.r, col.g, col.b, 200)
									g:SetColor(col)
									v1:Set(pt.fPos)
									v1 = MR_Utilities:GetGlobalPos(moho, layer, v1, true)
									g:FillCirclePixelRadius(v1, radius * (selectedRadiusMultiplier * 1.2))
								end
							end
						elseif self.ctrlPressed then
							local mouseVec = LM.Vector2:new_local()
							mouseVec:Set(self.dragVec)
							if layer ~= moho.layer then
								mouseVec = MR_Utilities:GetGlobalPos(moho, moho.layer, mouseVec, false)
								mouseVec = MR_Utilities:GetLocalPos(moho, layer, mouseVec, false)
							end
							local pointID = mesh:ClosestPoint(mouseVec)
							if pointID > -1 then
								local v1 = LM.Vector2:new_local()
								local pt = mesh:Point(pointID)
								local pointPos = LM.Vector2:new_local()
								pointPos:Set(pt.fPos)

								if layer ~= moho.layer then
									pointPos = MR_Utilities:GetGlobalPos(moho, layer, pointPos, false)
									pointPos = MR_Utilities:GetLocalPos(moho, moho.layer, pointPos, false)
								end

								local p1 = LM.Point:new_local()
								local p2 = LM.Point:new_local()
								moho.view:Graphics():WorldToScreen(self.dragVec, p1)
								moho.view:Graphics():WorldToScreen(pointPos, p2)
								p2.x = p1.x - p2.x
								p2.y = p1.y - p2.y
								local dist = (p2.x * p2.x) + (p2.y * p2.y)
								if dist <= self.cursorToPointDistance then
									g:SetColor(col.r, col.g, col.b, 200)
									for i = 0, mesh:CountShapes() - 1 do
										local shape = mesh:Shape(i)
										if shape:ContainsPoint(pointID) then
											-- This part of the code is taken from A. Evseeva's AE Select Shape script
											local matrix = LM.Matrix:new_local()
											layer:GetFullTransform(moho.frame, matrix, moho.document)
											g:Push()
											g:ApplyMatrix(matrix)

											for e = 0, shape:CountEdges()-1 do
												local c,p = shape:GetEdge(e)
												local startPercent, endPercent = mesh:Curve(c):GetSegmentRange(p)
												local step = (endPercent-startPercent)/10
												local p1 = mesh:Curve(c):GetPercentLocation(startPercent)
												for i=1,10 do
													local nextPercent = startPercent + step * i
												if nextPercent > endPercent then nextPercent = endPercent end
													local p2 = mesh:Curve(c):GetPercentLocation(nextPercent)
													g:DrawFatLine(5, p1.x, p1.y, p2.x, p2.y)
													p1:Set(p2)
												end
											end
											g:Pop()
											-- End of the code taken from A. Evseeva's script
										end
									end
									g:SetColor(col)
									v1:Set(pt.fPos)
									v1 = MR_Utilities:GetGlobalPos(moho, layer, v1, true)
									g:FillCirclePixelRadius(v1, radius * 0.4)
								end
							end
						end
					end
				end
			end
		end
	end

	if self.transformBoxMode and (not self.transformBoxDragging or self.mode == 111) then
		local g = view:Graphics()
		self:DrawTransformBox(moho, view, g)
	end

	if self.inProgressIcon then
		local g = view:Graphics()
		MR_Utilities:DrawInProgressIcon(moho, view, g, self.cursorPosition, self.inProgressIconRadius)
	end

	if self.axisMove > 0 then
		local g = view:Graphics()
		self:DrawArrowIcon(moho, view, g, self.axisMove)
	end

	if self.rotating and self.drawLongArrow then
		local g = view:Graphics()
		self:DrawLongArrowIcon(moho, view, g)
	end

	if self.transformBoxMode then
		if self.showHandles and self.selectPoints and isHandlesValid and self.selectedPointsCount and (not self.ctrlPressed or self.mode == 100) and self.bboxLength == 0 then
			self.handlesActive = true

			if self.transformBoxMode then
				if self.bboxLength == 0 then
					self:PrepareHandles(moho)
				else
					self.handleList = {}
				end
			end
			local g = view:Graphics()
			self:DrawHandles(moho, view, g)
		else
			self.handlesActive = false
		end
	else
		if self.showHandles and ((isHandlesValid and arePointsSelected and self.ctrlPressed) or self.rotating) then
			self.handlesActive = true

			local g = view:Graphics()
			self:DrawHandles(moho, view, g)
		else
			self.handlesActive = false
		end
	end
end

function MR_AnimatePoints:DrawTransformBox(moho, view, g)
	if self.selectedPointsCount >= 1 then
		local currentScale = g:CurrentScale(false)
		local height = g:Height() / 1080

		local min = LM.Vector2:new_local()
		local max = LM.Vector2:new_local()
		local centerVec = LM.Vector2:new_local()
		local v = LM.Vector2:new_local()
		local vc1 = LM.ColorVector:new_local()
		local vc2 = LM.ColorVector:new_local()

		vc1:Set(MOHO.MohoGlobals.SelCol)
		vc2:Set(MOHO.MohoGlobals.BackCol)
		vc1 = (vc1 + vc2) / 2
		local col = vc1:AsColorStruct()

		local bbox = self:BuildTransformBoxBounds(moho, moho.frame, view)

		min:Set(bbox.fMin.x, bbox.fMin.y)
		max:Set(bbox.fMax.x, bbox.fMax.y)

		g:Push()

		g:SetColor(self.guiColor)
		g:SetPenWidth(1)
		g:SetSmoothing(true)
		g:DrawLine(min.x, min.y, max.x, min.y)
		g:DrawLine(min.x, max.y, max.x, max.y)
		g:DrawLine(min.x, min.y, min.x, max.y)
		g:DrawLine(max.x, min.y, max.x, max.y)

		if self.selectedPointsCount >= 2 and self.bboxLength > 0 then
			g:SetPenWidth(1)
			local rotWidth = max.x - min.x
			if (max.y - min.y > rotWidth) then
				rotWidth = max.y - min.y
			end
			rotWidth = rotWidth * 0.1
			g:DrawLine(min.x - rotWidth, min.y - rotWidth, min.x - rotWidth, max.y + rotWidth)
			g:DrawLine(min.x - rotWidth, max.y + rotWidth, max.x + rotWidth, max.y + rotWidth)
			g:DrawLine(max.x + rotWidth, max.y + rotWidth, max.x + rotWidth, min.y - rotWidth)
			g:DrawLine(max.x + rotWidth, min.y - rotWidth, min.x - rotWidth, min.y - rotWidth)

			g:SetPenWidth(2)
			v:Set(min.x, min.y) g:FrameCirclePixelRadius(v, self.markerR)
			v:Set(min.x, max.y) g:FrameCirclePixelRadius(v, self.markerR)
			v:Set(max.x, min.y) g:FrameCirclePixelRadius(v, self.markerR)
			v:Set(max.x, max.y) g:FrameCirclePixelRadius(v, self.markerR)
			v:Set((min.x + max.x) / 2, min.y) g:FrameCirclePixelRadius(v, self.markerR)
			v:Set((min.x + max.x) / 2, max.y) g:FrameCirclePixelRadius(v, self.markerR)
			v:Set(min.x, (min.y + max.y) / 2) g:FrameCirclePixelRadius(v, self.markerR)
			v:Set(max.x, (min.y + max.y) / 2) g:FrameCirclePixelRadius(v, self.markerR)
			g:SetPenWidth(1)

			if (self.dragging) then
				centerVec:Set(self.centerVec)
			else
				centerVec:Set((min.x + max.x) / 2, (min.y + max.y) / 2)
				centerVec = centerVec + self.pivotOffset
			end

			g:SetSmoothing(true)
			g:DrawLine(centerVec.x - 0.02 / currentScale / height, centerVec.y, centerVec.x + 0.02 / currentScale / height, centerVec.y)
			g:DrawLine(centerVec.x, centerVec.y - 0.02 / currentScale / height, centerVec.x, centerVec.y + 0.02 / currentScale / height)
			v:Set(centerVec.x, centerVec.y) g:FrameCirclePixelRadius(v, self.markerR)

			g:SetPenWidth(2)
			if self.transformBoxExtraHandles then
				v:Set((min.x + max.x) / 2, min.y - rotWidth) g:FrameCirclePixelRadius(v, self.markerR)
				v:Set((min.x + max.x) / 2, max.y + rotWidth) g:FrameCirclePixelRadius(v, self.markerR)
				v:Set(min.x - rotWidth, (min.y + max.y) / 2) g:FrameCirclePixelRadius(v, self.markerR)
				v:Set(max.x + rotWidth, (min.y + max.y) / 2) g:FrameCirclePixelRadius(v, self.markerR)

				if self.selectedPointsCount >= 3 then
					v:Set(min.x - rotWidth, min.y - rotWidth) g:FrameCirclePixelRadius(v, self.markerR)
					v:Set(min.x - rotWidth, max.y + rotWidth) g:FrameCirclePixelRadius(v, self.markerR)
					v:Set(max.x + rotWidth, min.y - rotWidth) g:FrameCirclePixelRadius(v, self.markerR)
					v:Set(max.x + rotWidth, max.y + rotWidth) g:FrameCirclePixelRadius(v, self.markerR)
				end
			end
		end

		g:Pop()
	end
end

-- **************************************************
-- Tool options - create and respond to tool's UI
-- **************************************************

MR_AnimatePoints.CHANGE = MOHO.MSG_BASE
MR_AnimatePoints.DUMMY = MOHO.MSG_BASE + 1
MR_AnimatePoints.RESET = MOHO.MSG_BASE + 2
MR_AnimatePoints.SELECTITEM = MOHO.MSG_BASE + 3
MR_AnimatePoints.TRANSFORM_BOX_MODE = MOHO.MSG_BASE + 4
MR_AnimatePoints.WARP_MODE = MOHO.MSG_BASE + 5
MR_AnimatePoints.ISOLATE_LAYERS = MOHO.MSG_BASE + 6
MR_AnimatePoints.SELECT_POINTS = MOHO.MSG_BASE + 7
MR_AnimatePoints.LASSO_MODE = MOHO.MSG_BASE + 8
MR_AnimatePoints.SHOW_HANDLES = MOHO.MSG_BASE + 9
MR_AnimatePoints.FIXED_HANDLES = MOHO.MSG_BASE + 10
MR_AnimatePoints.SELECT_CONNECTED = MOHO.MSG_BASE + 11
MR_AnimatePoints.SELECT_CONNECTED_ALT = MOHO.MSG_BASE + 12
MR_AnimatePoints.TWOS_MODE = MOHO.MSG_BASE + 13
MR_AnimatePoints.SMARTBAKE = MOHO.MSG_BASE + 14
MR_AnimatePoints.INTERVAL_1 = MOHO.MSG_BASE + 15
MR_AnimatePoints.INTERVAL_2 = MOHO.MSG_BASE + 16
MR_AnimatePoints.INTERVAL_3 = MOHO.MSG_BASE + 17
MR_AnimatePoints.INTERVAL_4 = MOHO.MSG_BASE + 18
MR_AnimatePoints.INTERVAL_5 = MOHO.MSG_BASE + 19
MR_AnimatePoints.INTERVAL_6 = MOHO.MSG_BASE + 20
MR_AnimatePoints.UPDATE_REFERENCE_LAYERS = MOHO.MSG_BASE + 21
MR_AnimatePoints.UPDATE_CACHED_LAYERS = MOHO.MSG_BASE + 22
MR_AnimatePoints.KEYFRAMES_TO_MARKERS = MOHO.MSG_BASE + 23
MR_AnimatePoints.MARKERS_TO_KEYFRAMES = MOHO.MSG_BASE + 24
MR_AnimatePoints.COPY_FRAME = MOHO.MSG_BASE + 25
MR_AnimatePoints.PASTE_FRAME = MOHO.MSG_BASE + 26
MR_AnimatePoints.PASTE_FRAME_ALT = MOHO.MSG_BASE + 27
MR_AnimatePoints.COPY_PREVIOUS_KEY = MOHO.MSG_BASE + 28
MR_AnimatePoints.COPY_PREVIOUS_KEY_ALT = MOHO.MSG_BASE + 29
MR_AnimatePoints.CREATE_KEY = MOHO.MSG_BASE + 30
MR_AnimatePoints.CREATE_KEY_ALT = MOHO.MSG_BASE + 31
MR_AnimatePoints.COPY_NEXT_KEY = MOHO.MSG_BASE + 32
MR_AnimatePoints.COPY_NEXT_KEY_ALT = MOHO.MSG_BASE + 33
MR_AnimatePoints.RESET_POINTS = MOHO.MSG_BASE + 34
MR_AnimatePoints.RESET_POINTS_ALT = MOHO.MSG_BASE + 35
MR_AnimatePoints.DELETE_POINTS_KEYFRAME = MOHO.MSG_BASE + 36
MR_AnimatePoints.CLEAR_POINTS_ANIMATION = MOHO.MSG_BASE + 37
MR_AnimatePoints.CLEAR_POINTS_ANIMATION_ALT = MOHO.MSG_BASE + 38

MR_AnimatePoints.SELECTION_SLOT_1 = MOHO.MSG_BASE + 39
MR_AnimatePoints.SELECTION_SLOT_1_ALT = MOHO.MSG_BASE + 40
MR_AnimatePoints.SELECTION_SLOT_2 = MOHO.MSG_BASE + 41
MR_AnimatePoints.SELECTION_SLOT_2_ALT = MOHO.MSG_BASE + 42
MR_AnimatePoints.SELECTION_SLOT_3 = MOHO.MSG_BASE + 43
MR_AnimatePoints.SELECTION_SLOT_3_ALT = MOHO.MSG_BASE + 44
MR_AnimatePoints.SELECTION_SLOT_4 = MOHO.MSG_BASE + 45
MR_AnimatePoints.SELECTION_SLOT_4_ALT = MOHO.MSG_BASE + 46
MR_AnimatePoints.SELECTION_SLOT_5 = MOHO.MSG_BASE + 47
MR_AnimatePoints.SELECTION_SLOT_5_ALT = MOHO.MSG_BASE + 48
MR_AnimatePoints.OPEN_PANEL = MOHO.MSG_BASE + 49

MR_AnimatePoints.INNER_RADIUS = MOHO.MSG_BASE + 50

function MR_AnimatePoints:DoLayout(moho, layout)
	self.settingsDialog = MR_SettingsDialog:new()
	self.settingsPopup = LM.GUI.PopupDialog(self:Localize('Settings'), false, 0)
	self.settingsPopup:SetDialog(self.settingsDialog)
	layout:AddChild(self.settingsPopup, LM.GUI.ALIGN_LEFT, 0)

	if self.transformBoxMode then
		self.transformModeButton = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_transform_box", self:Localize('Transform box mode'), false, self.TRANSFORM_BOX_MODE, false)
		layout:AddChild(self.transformModeButton)
	else
		self.transformModeButton = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_magnet", self:Localize('Magnet mode'), false, self.TRANSFORM_BOX_MODE, false)
		layout:AddChild(self.transformModeButton)
	end

	self.warpModeButton = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_warp_mode", self:Localize('Warp mode'), true, self.WARP_MODE, false)
	layout:AddChild(self.warpModeButton)

	if not self.transformBoxMode then
		layout:AddChild(LM.GUI.StaticText(self:Localize('Magnet radius')))
		self.radius = LM.GUI.TextControl(45, "", self.CHANGE, LM.GUI.FIELD_UFLOAT)
		self.radius:SetWheelInc(0.01)
		self.radius:SetMaxDecimalPlaces(3)
		layout:AddChild(self.radius)

		layout:AddChild(LM.GUI.StaticText(self:Localize('Inner radius')))
		self.innerRadiusInput = LM.GUI.TextControl(45, "", self.INNER_RADIUS, LM.GUI.FIELD_UFLOAT)
		self.innerRadiusInput:SetWheelInc(0.01)
		self.innerRadiusInput:SetMaxDecimalPlaces(3)
		layout:AddChild(self.innerRadiusInput)
	end

	layout:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL)

	self.isolateLayersCheck = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_layer", self:Localize('Isolate layers'), true, self.ISOLATE_LAYERS, false)
	layout:AddChild(self.isolateLayersCheck)

	self.selectPointsCheck = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_select_points", self:Localize('Select points'), true, self.SELECT_POINTS, false)
	layout:AddChild(self.selectPointsCheck)

	if not self.transformBoxMode then
		self.selectedCheck = LM.GUI.CheckBox(self:Localize("Selected points only"), self.CHANGE)
		self.selectedCheck:SetToolTip(self:Localize("Selected points only tooltip"))
		layout:AddChild(self.selectedCheck)
	end

	self.lassoModeCheckbox = LM.GUI.CheckBox(self:Localize("Lasso mode"), self.LASSO_MODE)
	layout:AddChild(self.lassoModeCheckbox)

	self.showHandlesCheckbox = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_show_handles", self:Localize("Show handles"), true, self.SHOW_HANDLES, false)
	layout:AddChild(self.showHandlesCheckbox)

	if self.transformBoxMode then
		self.fixedHandlesCheck = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_fixed_handles", self:Localize('Fixed handles'), true, self.FIXED_HANDLES, false)
		layout:AddChild(self.fixedHandlesCheck)
	end

	self.selectConnectedCheck = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_select_connected", self:Localize('Select connected points'), true, self.SELECT_CONNECTED, false)
	self.selectConnectedCheck:SetAlternateMessage(self.SELECT_CONNECTED_ALT)
	layout:AddChild(self.selectConnectedCheck)

	layout:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL)

	self.twosModeCheckbox = LM.GUI.CheckBox(self:Localize('Twos mode'), self.TWOS_MODE)
	layout:AddChild(self.twosModeCheckbox, LM.GUI.ALIGN_LEFT, 0)

	self.smartBakeCheck = LM.GUI.CheckBox(self:Localize("Smart bake"), self.SMARTBAKE)
	layout:AddChild(self.smartBakeCheck)

	self.intervalMenu = LM.GUI.Menu(self:Localize("Interval=Interval"))
	self.intervalMenu:AddItem('1', 0, self.INTERVAL_1)
	self.intervalMenu:AddItemAlphabetically('2', 0, self.INTERVAL_2)
	self.intervalMenu:AddItemAlphabetically('3', 0, self.INTERVAL_3)
	self.intervalMenu:AddItemAlphabetically('4', 0, self.INTERVAL_4)
	self.intervalMenu:AddItemAlphabetically('5', 0, self.INTERVAL_5)
	self.intervalMenu:AddItemAlphabetically('6', 0, self.INTERVAL_6)

	self.intervalPopup = LM.GUI.PopupMenu(50, true)
	self.intervalPopup:SetMenu(self.intervalMenu)
	layout:AddChild(self.intervalPopup)

	layout:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL)

	self.updateReferenceLayersButton = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_update_ref", self:Localize('Update reference layers'), false, self.UPDATE_REFERENCE_LAYERS, false)
	layout:AddChild(self.updateReferenceLayersButton)

	self.updateCachedLayersButton = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_update_cache", self:Localize('Update cached layers'), false, self.UPDATE_CACHED_LAYERS, false)
	layout:AddChild(self.updateCachedLayersButton)

	layout:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL)

	self.keyframesSettingsDialog = KeyframseSettingsDialog:new()
	self.keyframesSettingsPopup = LM.GUI.PopupDialog(self:Localize('Keyframes settings'), false, 0)
	self.keyframesSettingsPopup:SetDialog(self.keyframesSettingsDialog)
	layout:AddChild(self.keyframesSettingsPopup, LM.GUI.ALIGN_LEFT, 0)

	self.keyframesToMarkersButton = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_keyframes_to_markers", self:Localize('Keyframes to markers'), false, self.KEYFRAMES_TO_MARKERS, false)
	layout:AddChild(self.keyframesToMarkersButton)

	self.markersToKeyframesButton = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_markers_to_keyframes", self:Localize('Markers to keyframes'), false, self.MARKERS_TO_KEYFRAMES, false)
	layout:AddChild(self.markersToKeyframesButton)

	self.convertInterpolationDialog = MR_ConvertInterpolationDialog:new()
	self.convertInterpolationPopup = LM.GUI.PopupDialog(self:Localize('Convert interpolation'), false, 0)
	self.convertInterpolationPopup:SetDialog(self.convertInterpolationDialog)
	layout:AddChild(self.convertInterpolationPopup, LM.GUI.ALIGN_LEFT, 0)

	layout:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL)

	self.copyFrameButton = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_copy", self:Localize('Copy frame'), false, self.COPY_FRAME, false)
	layout:AddChild(self.copyFrameButton)

	self.pasteFrameButton = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_paste", self:Localize('Paste frame'), false, self.PASTE_FRAME, false)
	self.pasteFrameButton:SetAlternateMessage(self.PASTE_FRAME_ALT)
	layout:AddChild(self.pasteFrameButton)

	layout:AddPadding(5)

	self.copyPreviousKeyButton = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_copy_prev", self:Localize('Copy previous key'), false, self.COPY_PREVIOUS_KEY, false)
	self.copyPreviousKeyButton:SetAlternateMessage(self.COPY_PREVIOUS_KEY_ALT)
	layout:AddChild(self.copyPreviousKeyButton)

	self.createKeyButton = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_create_key", self:Localize('Create key'), false, self.CREATE_KEY, false)
	self.createKeyButton:SetAlternateMessage(self.CREATE_KEY_ALT)
	layout:AddChild(self.createKeyButton)

	self.copyNextKeyButton = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_copy_next", self:Localize('Copy next key'), false, self.COPY_NEXT_KEY, false)
	self.copyNextKeyButton:SetAlternateMessage(self.COPY_NEXT_KEY_ALT)
	layout:AddChild(self.copyNextKeyButton)

	layout:AddPadding(5)

	self.resetPointsButton = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_reset_points", self:Localize('Reset points'), false, self.RESET_POINTS, false)
	self.resetPointsButton:SetAlternateMessage(self.RESET_POINTS_ALT)
	layout:AddChild(self.resetPointsButton)

	self.deletePointsKeyframeButton = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_delete_points_keyframe", self:Localize('Delete points keyframe'), false, self.DELETE_POINTS_KEYFRAME, false)
	layout:AddChild(self.deletePointsKeyframeButton)

	self.clearPointsAnimationButton = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_clear_points_animation", self:Localize('Clear points animation'), false, self.CLEAR_POINTS_ANIMATION, false)
	self.clearPointsAnimationButton:SetAlternateMessage(self.CLEAR_POINTS_ANIMATION_ALT)
	layout:AddChild(self.clearPointsAnimationButton)

	layout:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL)

	self.selectionSlot1Button = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_slot_button_1", self:Localize('Selection slot 1'), false, self.SELECTION_SLOT_1, false)
	self.selectionSlot1Button:SetAlternateMessage(self.SELECTION_SLOT_1_ALT)
	layout:AddChild(self.selectionSlot1Button)

	layout:AddPadding(-14)

	self.selectionSlot2Button = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_slot_button_2", self:Localize('Selection slot 2'), false, self.SELECTION_SLOT_2, false)
	self.selectionSlot2Button:SetAlternateMessage(self.SELECTION_SLOT_2_ALT)
	layout:AddChild(self.selectionSlot2Button)

	layout:AddPadding(-14)

	self.selectionSlot3Button = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_slot_button_3", self:Localize('Selection slot 3'), false, self.SELECTION_SLOT_3, false)
	self.selectionSlot3Button:SetAlternateMessage(self.SELECTION_SLOT_3_ALT)
	layout:AddChild(self.selectionSlot3Button)

	layout:AddPadding(-14)

	self.selectionSlot4Button = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_slot_button_4", self:Localize('Selection slot 4'), false, self.SELECTION_SLOT_4, false)
	self.selectionSlot4Button:SetAlternateMessage(self.SELECTION_SLOT_4_ALT)
	layout:AddChild(self.selectionSlot4Button)

	layout:AddPadding(-14)

	self.selectionSlot5Button = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_slot_button_5", self:Localize('Selection slot 5'), false, self.SELECTION_SLOT_5, false)
	self.selectionSlot5Button:SetAlternateMessage(self.SELECTION_SLOT_5_ALT)
	layout:AddChild(self.selectionSlot5Button)

	layout:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL)

	self.openPanelButton = LM.GUI.ImageButton("ScriptResources/mr_animate_points/mr_open_panel", self:Localize('Open panel'), false, self.OPEN_PANEL, false)
	layout:AddChild(self.openPanelButton)

	layout:AddChild(LM.GUI.StaticText('v'..MR_AnimatePoints:Version()))
end

function MR_AnimatePoints:UpdateWidgets(moho)
	self.transformModeButton:SetValue(self.transformBoxMode)
	self.warpModeButton:SetValue(self.warpMode)
	if not self.transformBoxMode and self.radius and self.innerRadiusInput and self.selectedCheck then
		self.radius:SetValue(self.magnetRadius)
		self.innerRadiusInput:SetValue(self.innerRadius)
		self.selectedCheck:SetValue(self.selectedOnly)
	end

	self.isolateLayersCheck:SetValue(self.isolateLayers)
	self.selectPointsCheck:SetValue(self.selectPoints)
	self.lassoModeCheckbox:SetValue(self.lassoMode)
	self.showHandlesCheckbox:SetValue(self.showHandles)
	self.showHandlesCheckbox:Enable(self.selectPoints)

	if self.transformBoxMode and self.fixedHandlesCheck then
		self.fixedHandlesCheck:SetValue(self.fixedHandles)
	end

	self.selectConnectedCheck:SetValue(self.autoConnectSelected)
	self.selectConnectedCheck:Enable(self.selectPoints)
	self.twosModeCheckbox:SetValue(self.twosMode)
	self.smartBakeCheck:SetValue(self.smartBake)
	self.smartBakeCheck:Enable(not MOHO.MohoGlobals.EditMultipleKeys)

	if self.copiedFrame then
		self.pasteFrameButton:Enable(true)
	else
		self.pasteFrameButton:Enable(false)
	end

	if self.mainCursor == nil then
		self.mainCursor = LM.GUI.Cursor(moho:UserContentDir()..'/Scripts/ScriptResources/mr_animate_points/mr_main_cursor', 1, 1)
	end
	if self.distortCursor == nil then
		self.distortCursor = LM.GUI.Cursor(moho:UserContentDir()..'/Scripts/ScriptResources/mr_animate_points/mr_cursor_distort', 1, 1)
	end
	if self.skewCursor == nil then
		self.skewCursor = LM.GUI.Cursor(moho:UserContentDir()..'/Scripts/ScriptResources/mr_animate_points/mr_cursor_skew', 1, 1)
	end

	self.intervalMenu:SetChecked(self.INTERVAL_1, false)
	self.intervalMenu:SetChecked(self.INTERVAL_2, false)
	self.intervalMenu:SetChecked(self.INTERVAL_3, false)
	self.intervalMenu:SetChecked(self.INTERVAL_4, false)
	self.intervalMenu:SetChecked(self.INTERVAL_5, false)
	self.intervalMenu:SetChecked(self.INTERVAL_6, false)
	if (self.smartBakeInterval == 1) then
		self.intervalMenu:SetChecked(self.INTERVAL_1, true)
	elseif (self.smartBakeInterval == 2) then
		self.intervalMenu:SetChecked(self.INTERVAL_2, true)
	elseif (self.smartBakeInterval == 3) then
		self.intervalMenu:SetChecked(self.INTERVAL_3, true)
	elseif (self.smartBakeInterval == 4) then
		self.intervalMenu:SetChecked(self.INTERVAL_4, true)
	elseif (self.smartBakeInterval == 5) then
		self.intervalMenu:SetChecked(self.INTERVAL_5, true)
	elseif (self.smartBakeInterval == 6) then
		self.intervalMenu:SetChecked(self.INTERVAL_6, true)
	end
	self.intervalPopup:Enable(self.smartBake)
	self.intervalPopup:Redraw()

	if not self.color1 then
		self:CreateColors(moho)
	end
	if not self.pointsColor then
		self.pointsColor = LM.rgb_color:new_local()
		self.pointsColor.r = self.pointsColorR
		self.pointsColor.g = self.pointsColorG
		self.pointsColor.b = self.pointsColorB
		self.pointsColor.a = self.pointsColorA
	end

	if not self.guiColor then
		self.guiColor = LM.rgb_color:new_local()
		self.guiColor.r = self.guiColorR
		self.guiColor.g = self.guiColorG
		self.guiColor.b = self.guiColorB
		self.guiColor.a = self.guiColorA
	end

	if next(self.isolatedLayerUUIDList) then
		local removeList = {}
		for i, layerUUID in pairs(self.isolatedLayerUUIDList) do
			local layerIndex = tonumber(i)-1
			local layer = moho.document:LayerByAbsoluteID(layerIndex)
			if not layer then
				table.insert(removeList, i)
			else
				if layer:UUID() ~= layerUUID then
					table.insert(removeList, i)
				end
			end
		end
		for _, index in pairs(removeList) do
			self.isolatedLayerUUIDList[index] = nil
		end
	end
	local frame = moho.frame

	if (self.blockOnEvenFrames and frame % 2 == 0 or self.blockOnOddFrames and not (frame % 2 == 0)) and self.twosMode and frame > 0 then
		moho.view:SetCursor(MOHO.disabledCursor)
	else
		if self.mainCursor == nil then
			self.mainCursor = LM.GUI.Cursor(moho:UserContentDir()..'/Scripts/Tool/mr_animate_points_cursor', 1, 1)
		end
		if self.transformBoxMode then
			moho.view:SetCursor(self.mainCursor)
		else
			moho.view:SetCursor(MOHO.moveCursor)
		end
	end

	if self.transformBoxMode then
		self:UpdateVectorList(moho, false)
		self:UpdateCenterVec(moho)
	end
	moho.view:DrawMe()
end

function MR_AnimatePoints:HandleMessage(moho, view, msg)
	if msg == self.RESET then
		self.magnetRadius = 0.5
		moho:UpdateUI()
	elseif msg == self.CHANGE then
		self.magnetRadius = self.radius:FloatValue()
		if (self.magnetRadius < 0.001) then
			self.magnetRadius = 0.001
		end
		self.selectedOnly = self.selectedCheck:Value()
	elseif msg == self.SELECTITEM then
		mesh:SelectNone()
		local i = msg - self.SELECTITEM
		local name = mesh:Group(i):Name()
		mesh:SelectGroup(name)
		moho:UpdateUI()
	elseif msg == self.TRANSFORM_BOX_MODE then
		self.transformBoxMode = not self.transformBoxMode
		MR_Utilities:UpdatePanel(moho)
	elseif msg == self.WARP_MODE then
		self.warpMode = self.warpModeButton:Value()
		self:UpdateWidgets(moho)
	elseif msg == self.ISOLATE_LAYERS then
		self.isolateLayers = not self.isolateLayers
		self.selectPoints = false
		self.selectPointsCheck:SetValue(false)
		if not self.selectPoints and not self.isolateLayers then
			self.isolateLayers = true
			self.isolateLayersCheck:SetValue(true)
		end
		self.selectConnectedCheck:Enable(self.selectPoints)
		self.showHandlesCheckbox:Enable(self.selectPoints)
	elseif msg == self.SELECT_POINTS then
		self.selectPoints = self.selectPointsCheck:Value()
		self.isolateLayers = false
		self.isolateLayersCheck:SetValue(false)
		if not self.isolateLayers and not self.selectPoints then
			self.selectPoints = true
			self.selectPointsCheck:SetValue(true)
		end
		self.selectConnectedCheck:Enable(self.selectPoints)
		self.showHandlesCheckbox:Enable(self.selectPoints)
	elseif msg == self.INNER_RADIUS then
		self.innerRadius = LM.Clamp(self.innerRadiusInput:FloatValue(), 0, 1)
		self.innerRadiusInput:SetValue(self.innerRadius)
	elseif msg == self.LASSO_MODE then
		self.lassoMode = self.lassoModeCheckbox:Value()
	elseif msg == self.SHOW_HANDLES then
		self.showHandles = self.showHandlesCheckbox:Value()
	elseif msg == self.FIXED_HANDLES then
		self.fixedHandles = self.fixedHandlesCheck:Value()
	elseif msg == self.SELECT_CONNECTED then
		self:SelectConnectedPoints(moho)
		self.selectConnectedCheck:SetValue(self.autoConnectSelected)
	elseif msg == self.SELECT_CONNECTED_ALT then
		self.autoConnectSelected = not self.autoConnectSelected
		self.selectConnectedCheck:SetValue(self.autoConnectSelected)
		if self.animatePointsPanelDlog then
			self.animatePointsPanelDlog:UpdateWidgets(moho)
		end
	elseif msg == self.TWOS_MODE then
		self.twosMode = self.twosModeCheckbox:Value()
		self:UpdateWidgets(moho)
	elseif msg == self.SMARTBAKE then
		self.smartBake = self.smartBakeCheck:Value()
		self:UpdateWidgets(moho)
	elseif (msg >= self.INTERVAL_1 and msg <= self.INTERVAL_6) then
		local int = 1
		if (msg == self.INTERVAL_1) then
			int = 1
		elseif (msg == self.INTERVAL_2) then
			int = 2
		elseif (msg == self.INTERVAL_3) then
			int = 3
		elseif (msg == self.INTERVAL_4) then
			int = 4
		elseif (msg == self.INTERVAL_5) then
			int = 5
		elseif (msg == self.INTERVAL_6) then
			int = 6
		end
		self.smartBakeInterval = int
		self:UpdateWidgets(moho)
	elseif msg == self.UPDATE_REFERENCE_LAYERS then
		self:UpdateReferenceLayers(moho)
	elseif msg == self.UPDATE_CACHED_LAYERS then
		self.currentQualityFlags = moho.view:QualityFlags()
		local wireframe = MOHO.hasbit(moho.view:QualityFlags(), MOHO.LDQ_WIREFRAME)
		if wireframe then
			moho.view:SetQualityFlags(self.currentQualityFlags - MOHO.LDQ_WIREFRAME)
		end
		local curLayer = moho.layer
		local layersList = {}
		local count = 0
		repeat
			local layer = moho.document:LayerByAbsoluteID(count)
			if layer then
				if layer:SecondarySelection() or layer:IsAncestorSelected() or layer == moho.layer then
					local vectorLayer = moho:LayerAsVector(layer)
					if vectorLayer then
						table.insert(layersList, count)
					end
				end
			end
			count = count + 1
		until not layer

		for i, layerIndex in ipairs(layersList) do
			local layer = moho.document:LayerByAbsoluteID(layerIndex)
			moho:SetSelLayer(layer)
			moho.view:DrawMe()
			layer:FreeCachedImage()
		end
		moho.view:SetQualityFlags(self.currentQualityFlags)

		moho:SetSelLayer(curLayer)
		moho:UpdateUI()
	elseif msg == self.KEYFRAMES_TO_MARKERS then
		self:KeyframesToMarkers(moho)
	elseif msg == self.MARKERS_TO_KEYFRAMES then
		self:MarkersToKeyframes(moho)
	elseif msg == self.COPY_FRAME then
		self.copiedFrame = moho.frame
		self.pasteFrameButton:Enable(true)
		if self.animatePointsPanelDlog then
			self.animatePointsPanelDlog:UpdateWidgets(moho)
		end
	elseif msg == self.PASTE_FRAME then
		self:PasteFrame(moho, false)
	elseif msg == self.PASTE_FRAME_ALT then
		self:PasteFrame(moho, true)
	elseif msg == self.COPY_PREVIOUS_KEY then
		self:CreateKey(moho, 0, false)
	elseif msg == self.COPY_PREVIOUS_KEY_ALT then
		self:CreateKey(moho, 0, true)
	elseif msg == self.CREATE_KEY then
		self:CreateKey(moho, 1, false)
	elseif msg == self.CREATE_KEY_ALT then
		self:CreateKey(moho, 1, true)
	elseif msg == self.COPY_NEXT_KEY then
		self:CreateKey(moho, 2, false)
	elseif msg == self.COPY_NEXT_KEY_ALT then
		self:CreateKey(moho, 2, true)
	elseif msg == self.RESET_POINTS then
		self:ResetPointsInLayers(moho, false)
	elseif msg == self.RESET_POINTS_ALT then
		self:ResetPointsInLayers(moho, true)
	elseif msg == self.DELETE_POINTS_KEYFRAME then
		self:DeletePointsKeys(moho, false)
	elseif msg == self.DELETE_POINTS_KEYFRAME_ALT then
		self:DeletePointsKeys(moho, true)
	elseif msg == self.CLEAR_POINTS_ANIMATION then
		self:ClearKeyframes(moho, false)
	elseif msg == self.CLEAR_POINTS_ANIMATION_ALT then
		self:ClearKeyframes(moho, true)
	elseif msg == self.SELECTION_SLOT_1 then
		self:SetSelection(moho, 1)
	elseif msg == self.SELECTION_SLOT_1_ALT then
		self:GetSelection(moho, 1)
	elseif msg == self.SELECTION_SLOT_2 then
		self:SetSelection(moho, 2)
	elseif msg == self.SELECTION_SLOT_2_ALT then
		self:GetSelection(moho, 2)
	elseif msg == self.SELECTION_SLOT_3 then
		self:SetSelection(moho, 3)
	elseif msg == self.SELECTION_SLOT_3_ALT then
		self:GetSelection(moho, 3)
	elseif msg == self.SELECTION_SLOT_4 then
		self:SetSelection(moho, 4)
	elseif msg == self.SELECTION_SLOT_4_ALT then
		self:GetSelection(moho, 4)
	elseif msg == self.SELECTION_SLOT_5 then
		self:SetSelection(moho, 5)
	elseif msg == self.SELECTION_SLOT_5_ALT then
		self:GetSelection(moho, 5)
	elseif msg == self.OPEN_PANEL then
		if self.animatePointsPanelDlog == nil then
			self.animatePointsPanelDlog = MR_AnimatePointsPanelDialog:new(moho)
			if self.animatePointsPanelDlog:DoModeless() == LM.GUI.MSG_CANCEL then
				return
			end
		end
	end
end

function MR_AnimatePoints:UpdateReferenceLayers(moho)
	local count = 0
	repeat
		local layer = moho.document:LayerByAbsoluteID(count)
		if layer then
			if layer:IsReferencedLayer() then
				layer:MarkReferenceOutdated()
			end
			layer:UpdateCurFrame()
			count = count + 1
		end
	until not layer

	moho.layer:UpdateCurFrame()
	moho:UpdateUI()
end

function MR_AnimatePoints:ResetPoints(moho, layer, frame, curvature)
	local visibleLayersOnly = self.visibleLayersOnly
	self.visibleLayersOnly = self.visibleLayersOnlyKeyframing

	local mesh = layer:Mesh()
	for i = 0, mesh:CountPoints() - 1 do
		local pt = mesh:Point(i)
		if (pt.fSelected and self.processSelectedPointsOnly) or not self.processSelectedPointsOnly then
			local channel = pt.fAnimPos
			if channel:Duration() > 0 then
				channel:SetValue(frame, pt.fAnimPos:GetValue(0))
			end
			if curvature then
				local curvature = 0
				local curve = nil
				local ptPos = -1
				for j = 0, pt:CountCurves() - 1 do
					curve, ptPos = pt:Curve(j, ptPos)
					local curvatureChannel = curve:Curvature(ptPos)
					local curvatureOffsetChannel1 = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, false)
					local curvatureOffsetChannel2 = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, true)
					local curvatureWeightChannel1 = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, false)
					local curvatureWeightChannel2 = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, true)

					if (curvatureChannel:Duration() > 0 or curvatureOffsetChannel1:Duration() > 0 or curvatureOffsetChannel2:Duration() > 0
					or curvatureWeightChannel1:Duration() > 0 or curvatureWeightChannel2:Duration() > 0) then
						curve:SetCurvature(ptPos, curve:GetCurvature(ptPos, 0), frame)

						curve:SetWeight(ptPos, curve:GetWeight(ptPos, 0, true), frame, true)
						curve:SetWeight(ptPos, curve:GetWeight(ptPos, 0, false), frame, false)

						curve:SetOffset(ptPos, curve:GetOffset(ptPos, 0, true), frame, true)
						curve:SetOffset(ptPos, curve:GetOffset(ptPos, 0, false), frame, false)
					end
				end
			end
		end
	end
	self.visibleLayersOnly = visibleLayersOnly
end

function MR_AnimatePoints:DrawHandles(moho, view, g)
	local currentScale = g:CurrentScale(false)
	local height = g:Height() / 1080
	
	local v1 = LM.Vector2:new_local()
	local v2 = LM.Vector2:new_local()

	local radius = 5

	g:SetSmoothing(true)
	g:SetPenWidth(2)
	g:SetColor(255, 0, 0, 255)

	for i = 1, #self.handleList do
		for j = 1, #self.handleList[i].point do
			v1:Set(self.handleList[i].handleTrue[j])
			v2:Set(self.handleList[i].point[j])
			g:DrawLine(v1.x, v1.y, v2.x, v2.y)

			g:FillCirclePixelRadius(self.handleList[i].handleTrue[j], radius)

			v1:Set(self.handleList[i].handleFalse[j])
			v2:Set(self.handleList[i].point[j])
			g:DrawLine(v1.x, v1.y, v2.x, v2.y)

			g:FillCirclePixelRadius(self.handleList[i].handleFalse[j], radius)

			g:FillCirclePixelRadius(self.handleList[i].point[j], radius)
		end
	end

	g:Pop()
end

function MR_AnimatePoints:DrawArrowIcon(moho, view, g, direction)
	local m = LM.Matrix:new_local()
	local viewAngle = g:ViewRotation()
	m:Rotate(2, -viewAngle)

	g:Push()
	g:ApplyMatrix(m)
	local currentScale = g:CurrentScale(false)
	local height = g:Height() / 1080
	local center = LM.Vector2:new_local()
	center:Set(self.mouseStartVec)
	m:Invert()
	m:Transform(center)

	local v1 = LM.Vector2:new_local()
	local v2 = LM.Vector2:new_local()

	local radius = self.inProgressIconRadius / currentScale / height

	local v = LM.Vector2:new_local()
	g:SetSmoothing(true)

	g:SetPenWidth(10)

	local offset = 0.06 / currentScale / height
	local sizeMultiplier = 0.7
	local arrowLength = (radius * 1.2) * sizeMultiplier
	local arrowWidth = (radius * 1.5) * sizeMultiplier

	if direction == 1 then
		g:SetColor(0, 0, 0, 50)
	else
		g:SetColor(0, 0, 0, 25)
	end

	--X+
	--shadow
	g:BeginShape()

	local shadowOffset = 0.005 / currentScale / height
	local shadowCenter = LM.Vector2:new_local()
	shadowCenter:Set(center.x + offset - shadowOffset, center.y - shadowOffset * 2)
	local tip = LM.Vector2:new_local()
	local base1 = LM.Vector2:new_local()
	local base2 = LM.Vector2:new_local()
	tip:Set(shadowCenter.x + arrowLength, shadowCenter.y)
	base1:Set(shadowCenter.x, shadowCenter.y - arrowWidth / 2)
	base2:Set(shadowCenter.x, shadowCenter.y + arrowWidth / 2)
	g:AddLine(base1, tip)
	g:AddLine(tip, base2)
	g:AddLine(base2, base1)
	g:EndShape()

	--arrow
	if direction == 1 then
		g:SetColor(255, 255, 255, 255)
	else
		g:SetColor(255, 255, 255, 200)
	end
	g:BeginShape()

	local arrowCenter = LM.Vector2:new_local()
	arrowCenter:Set(center.x + offset, center.y)

	local tip = LM.Vector2:new_local()
	local base1 = LM.Vector2:new_local()
	local base2 = LM.Vector2:new_local()
	tip:Set(arrowCenter.x + arrowLength, arrowCenter.y)
	base1:Set(arrowCenter.x, arrowCenter.y - arrowWidth / 2)
	base2:Set(arrowCenter.x, arrowCenter.y + arrowWidth / 2)
	g:AddLine(base1, tip)
	g:AddLine(tip, base2)
	g:AddLine(base2, base1)

	g:EndShape()

	-- X-
	--shadow
	if direction == 2 then
		g:SetColor(0, 0, 0, 50)
	else
		g:SetColor(0, 0, 0, 25)
	end

	g:BeginShape()

	local shadowOffset = 0.005 / currentScale / height
	local shadowCenter = LM.Vector2:new_local()
	shadowCenter:Set(center.x - offset + shadowOffset, center.y - shadowOffset * 2)
	local tip = LM.Vector2:new_local()
	local base1 = LM.Vector2:new_local()
	local base2 = LM.Vector2:new_local()
	tip:Set(shadowCenter.x - arrowLength, shadowCenter.y)
	base1:Set(shadowCenter.x, shadowCenter.y - arrowWidth / 2)
	base2:Set(shadowCenter.x, shadowCenter.y + arrowWidth / 2)
	g:AddLine(base1, tip)
	g:AddLine(tip, base2)
	g:AddLine(base2, base1)
	g:EndShape()

	--arrow
	if direction == 2 then
		g:SetColor(255, 255, 255, 255)
	else
		g:SetColor(255, 255, 255, 200)
	end

	g:BeginShape()

	local arrowCenter = LM.Vector2:new_local()
	arrowCenter:Set(center.x - offset, center.y)

	local tip = LM.Vector2:new_local()
	local base1 = LM.Vector2:new_local()
	local base2 = LM.Vector2:new_local()
	tip:Set(arrowCenter.x - arrowLength, arrowCenter.y)
	base1:Set(arrowCenter.x, arrowCenter.y - arrowWidth / 2)
	base2:Set(arrowCenter.x, arrowCenter.y + arrowWidth / 2)
	g:AddLine(base1, tip)
	g:AddLine(tip, base2)
	g:AddLine(base2, base1)

	g:EndShape()

	-- Y-
	--shadow
	if direction == 4 then
		g:SetColor(0, 0, 0, 50)
	else
		g:SetColor(0, 0, 0, 25)
	end
	g:BeginShape()
	
	local shadowOffset = 0.005 / currentScale / height
	local shadowCenter = LM.Vector2:new_local()
	shadowCenter:Set(center.x, center.y - offset - shadowOffset * 2)
	local tip = LM.Vector2:new_local()
	local base1 = LM.Vector2:new_local()
	local base2 = LM.Vector2:new_local()
	tip:Set(shadowCenter.x, shadowCenter.y - arrowLength)
	base1:Set(shadowCenter.x - arrowWidth / 2, shadowCenter.y)
	base2:Set(shadowCenter.x + arrowWidth / 2, shadowCenter.y)
	g:AddLine(base1, tip)
	g:AddLine(tip, base2)
	g:AddLine(base2, base1)
	g:EndShape()

	if direction == 4 then
		g:SetColor(255, 255, 255, 255)
	else
		g:SetColor(255, 255, 255, 200)
	end

	g:BeginShape()

	local arrowCenter = LM.Vector2:new_local()
	arrowCenter:Set(center.x, center.y - offset)

	local tip = LM.Vector2:new_local()
	local base1 = LM.Vector2:new_local()
	local base2 = LM.Vector2:new_local()
	tip:Set(arrowCenter.x, arrowCenter.y - arrowLength)
	base1:Set(arrowCenter.x - arrowWidth / 2, arrowCenter.y)
	base2:Set(arrowCenter.x + arrowWidth / 2, arrowCenter.y)
	g:AddLine(base1, tip)
	g:AddLine(tip, base2)
	g:AddLine(base2, base1)

	g:EndShape()

	g:Pop()
end

function MR_AnimatePoints:DrawLongArrowIcon(moho, view, g)
	local m = LM.Matrix:new_local()
	local viewAngle = g:ViewRotation()
	m:Rotate(2, -viewAngle)

	g:Push()
	g:ApplyMatrix(m)
	local currentScale = g:CurrentScale(false)
	local height = g:Height() / 1080
	local center = LM.Vector2:new_local()
	center:Set(self.mouseStartVec)
	m:Invert()
	m:Transform(center)

	local v1 = LM.Vector2:new_local()
	local v2 = LM.Vector2:new_local()

	local radius = self.inProgressIconRadius / currentScale / height

	local v = LM.Vector2:new_local()
	g:SetSmoothing(true)

	g:SetPenWidth(10)

	local offset = 0.06 / currentScale / height

	local iconSize = 0.1 / currentScale / height

	g:SetColor(255, 255, 255, 60)

	local arrowCenter = LM.Vector2:new_local()
	arrowCenter:Set(center.x, center.y)

	local height = iconSize * 0.15

	g:BeginShape()
	
	v1:Set(center.x,  center.y - height)
	v2:Set(v1.x - iconSize, v1.y)
	g:AddLine(v1, v2)

	v1:Set(v2.x, v2.y)
	v2:Set(v1.x, v1.y - height * 0.75)
	g:AddLine(v1, v2)

	v1:Set(v2.x, v2.y)
	v2:Set(v1.x - height * 1.5, v1.y + height * 1.5)
	g:AddLine(v1, v2)

	v1:Set(v2.x, v2.y)
	v2:Set(v1.x + height * 1.5, v1.y + height * 1.5)
	g:AddLine(v1, v2)

	v1:Set(v2.x, v2.y)
	v2:Set(v1.x , v1.y - height * 0.75)
	g:AddLine(v1, v2)

	v1:Set(v2.x, v2.y)
	v2:Set(v1.x + iconSize * 2, v1.y)
	g:AddLine(v1, v2)

	v1:Set(v2.x, v2.y)
	v2:Set(v1.x, v1.y + height * 0.75)
	g:AddLine(v1, v2)

	v1:Set(v2.x, v2.y)
	v2:Set(v1.x + height * 1.5, v1.y - height * 1.5)
	g:AddLine(v1, v2)

	v1:Set(v2.x, v2.y)
	v2:Set(v1.x - height * 1.5, v1.y - height * 1.5)
	g:AddLine(v1, v2)

	v1:Set(v2.x, v2.y)
	v2:Set(v1.x, v1.y + height * 0.75)
	g:AddLine(v1, v2)

	v1:Set(v2.x, v2.y)
	v2:Set(v1.x - iconSize, v1.y)
	g:AddLine(v1, v2)

	g:EndShape()

	g:Pop()
end

function MR_AnimatePoints:DrawArrow(g, center, outerRadius, angleOffset, startAngleDeg, endAngleDeg, stepDeg)
	g:BeginShape()
	local outerArcPoints = {}
	local angleStep = stepDeg or 5
	local function condition(angle)
		if startAngleDeg + angleOffset < endAngleDeg + angleOffset then
			return angle <= endAngleDeg + angleOffset
		else
			return angle >= endAngleDeg + angleOffset
		end
	end
	local angle = startAngleDeg + angleOffset
	while condition(angle) do
		local rad = math.rad(angle)
		local x = center.x + outerRadius * math.cos(rad)
		local y = center.y + outerRadius * math.sin(rad)
		local vec = LM.Vector2:new_local()
		vec:Set(x, y)
		table.insert(outerArcPoints, vec)
		if startAngleDeg + angleOffset < endAngleDeg + angleOffset then
			angle = angle + angleStep
		else
			angle = angle - angleStep
		end
	end
	local rad = math.rad(endAngleDeg + angleOffset)
	local x = center.x + outerRadius * math.cos(rad)
	local y = center.y + outerRadius * math.sin(rad)
	local vec = LM.Vector2:new_local()
	vec:Set(x, y)
	table.insert(outerArcPoints, vec)
	for i = 1, (#outerArcPoints - 1) do
		g:AddLine(outerArcPoints[i], outerArcPoints[i+1])
	end
	local arcEnd = outerArcPoints[#outerArcPoints]
	local arcEndPrev = outerArcPoints[#outerArcPoints - 1] or arcEnd
	local dx = arcEnd.x - arcEndPrev.x
	local dy = arcEnd.y - arcEndPrev.y
	local arrowAngleDeg = math.deg(math.atan2(dy, dx))
	local tipLength = outerRadius * 0.5
	local halfWidth = tipLength * 0.275
	local function offsetPoint(base, angleDeg, dist)
		local p = LM.Vector2:new_local()
		local newX = base.x + dist * math.cos(math.rad(angleDeg))
		local newY = base.y + dist * math.sin(math.rad(angleDeg))
		p:Set(newX, newY)
		return p
	end
	local tipTop = offsetPoint(arcEnd, arrowAngleDeg + 45 + angleOffset, halfWidth)
	local tipFront = offsetPoint(tipTop, arrowAngleDeg + 170 + angleOffset, tipLength)
	local tipBottom = offsetPoint(tipFront, arrowAngleDeg + 280 + angleOffset, tipLength)
	g:AddLine(arcEnd, tipTop)
	g:AddLine(tipTop, tipFront)
	g:AddLine(tipFront, tipBottom)

	local innerRadius = outerRadius * 0.7
	local innerArcPoints = {}
	angle = endAngleDeg + angleOffset
	while true do
		local rad = math.rad(angle)
		local x = center.x + innerRadius * math.cos(rad)
		local y = center.y + innerRadius * math.sin(rad)
		local vec = LM.Vector2:new_local()
		vec:Set(x, y)
		table.insert(innerArcPoints, vec)
		if startAngleDeg + angleOffset < endAngleDeg + angleOffset then
			if angle <= startAngleDeg + angleOffset then break end
			angle = angle - angleStep
		else
			if angle >= startAngleDeg + angleOffset then break end
			angle = angle + angleStep
		end
	end

	g:AddLine(tipBottom, innerArcPoints[1])
	local rad2 = math.rad(startAngleDeg + angleOffset)
	local x2 = center.x + innerRadius * math.cos(rad2)
	local y2 = center.y + innerRadius * math.sin(rad2)
	local vec2 = LM.Vector2:new_local()
	vec2:Set(x2, y2)
	table.insert(innerArcPoints, vec2)
	for i = 1, (#innerArcPoints - 1) do
		g:AddLine(innerArcPoints[i], innerArcPoints[i+1])
	end
	g:AddLine(innerArcPoints[#innerArcPoints], outerArcPoints[1])
	g:EndShape()
end

function MR_AnimatePoints:CreateColors(moho)
	self.color1 = LM.rgb_color:new_local()
	self.color1.r = 52
	self.color1.g = 206
	self.color1.b = 250
	self.color1.a = 255

	self.color2 = LM.rgb_color:new_local()
	self.color2.r = 248
	self.color2.g = 39
	self.color2.b = 123
	self.color2.a = 255

	self.color3 = LM.rgb_color:new_local()
	self.color3.r = 39
	self.color3.g = 229
	self.color3.b = 79
	self.color3.a = 255

	self.color4 = LM.rgb_color:new_local()
	self.color4.r = 70
	self.color4.g = 241
	self.color4.b = 243
	self.color4.a = 255

	self.color5 = LM.rgb_color:new_local()
	self.color5.r = 255
	self.color5.g = 206
	self.color5.b = 57
	self.color5.a = 255

	self.color6 = LM.rgb_color:new_local()
	self.color6.r = 208
	self.color6.g = 118
	self.color6.b = 255
	self.color6.a = 255

	self.color7 = LM.rgb_color:new_local()
	self.color7.r = 184
	self.color7.g = 227
	self.color7.b = 33
	self.color7.a = 255

	self.color8 = LM.rgb_color:new_local()
	self.color8.r = 255
	self.color8.g = 127
	self.color8.b = 70
	self.color8.a = 255

	self.color9 = LM.rgb_color:new_local()
	self.color9.r = 42
	self.color9.g = 229
	self.color9.b = 187
	self.color9.a = 255

	self.color10 = LM.rgb_color:new_local()
	self.color10.r = 74
	self.color10.g = 135
	self.color10.b = 248
	self.color10.a = 255

	self.color11 = LM.rgb_color:new_local()
	self.color11.r = 56
	self.color11.g = 186
	self.color11.b = 90
	self.color11.a = 255

	self.color12 = LM.rgb_color:new_local()
	self.color12.r = 245
	self.color12.g = 243
	self.color12.b = 58
	self.color12.a = 255

	self.color13 = LM.rgb_color:new_local()
	self.color13.r = 255
	self.color13.g = 138
	self.color13.b = 201
	self.color13.a = 255
	
	self.color14 = LM.rgb_color:new_local()
	self.color14.r = 152
	self.color14.g = 198
	self.color14.b = 107
	self.color14.a = 255

	self.color15 = LM.rgb_color:new_local()
	self.color15.r = 141
	self.color15.g = 106
	self.color15.b = 212
	self.color15.a = 255

	self.color16 = LM.rgb_color:new_local()
	self.color16.r = 226
	self.color16.g = 74
	self.color16.b = 78
	self.color16.a = 255

	self.color17 = LM.rgb_color:new_local()
	self.color17.r = 175
	self.color17.g = 222
	self.color17.b = 240
	self.color17.a = 255

	self.color18 = LM.rgb_color:new_local()
	self.color18.r = 148
	self.color18.g = 200
	self.color18.b = 154
	self.color18.a = 255

	self.color19 = LM.rgb_color:new_local()
	self.color19.r = 251
	self.color19.g = 232
	self.color19.b = 157
	self.color19.a = 255

	self.color20 = LM.rgb_color:new_local()
	self.color20.r = 242
	self.color20.g = 83
	self.color20.b = 165
	self.color20.a = 255
end

function MR_AnimatePoints:ResetPointsInLayers(moho, alt)
	if moho.document:CountSelectedLayers() > 1 then
		moho.document:PrepMultiUndo(false)
	else
		moho.document:PrepUndo(moho.layer, false)
	end
	moho.document:SetDirty()
	local layersList = {}

	if next(self.isolatedLayerUUIDList) and self.processIsolatedLayersOnly then
		for i, layerUUID in pairs(self.isolatedLayerUUIDList) do
			local targetLayerIndex = tonumber(i)-1
			local layer = moho.document:LayerByAbsoluteID(targetLayerIndex)
			if layer then
				if layer:UUID() == layerUUID then
					if self:IsLayerValidForWarpMode(moho, layer) or not self.considerWarpMode then
						local isLayerOk = true
						if layer == moho.layer then
							isLayerOk = true
						elseif layer:IsWarpLayer() and self.warpMode then
							local layerSkeleton = layer:ControllingSkeleton()
							isLayerOk = MR_Utilities:IsLayerActive(moho, layer, layerSkeleton)
						elseif self.visibleLayersOnly then
							local layerSkeleton = layer:ControllingSkeleton()
							isLayerOk = MR_Utilities:IsLayerVisible(moho, layer, layerSkeleton, true)
						end
						if isLayerOk then
							table.insert(layersList, targetLayerIndex)
						end
					end
				end
			end
		end
	else
		layersList = self:ScanLayers(moho, self.considerWarpMode)
	end

	for l, layerIndex in ipairs(layersList) do
		local layer = moho.document:LayerByAbsoluteID(layerIndex)
		if layer then
			local layerFrame = layer:DocToLayerFrame(moho.frame)
			local vectorLayer = moho:LayerAsVector(layer)
			if vectorLayer then
				local mesh = vectorLayer:Mesh()
				if mesh:CountPoints() > 1 and layer:AnimDuration() > 0 then
					self:ResetPoints(moho, layer, layerFrame, alt)
				end
			end
		end
	end

	for l = 0, moho.document:CountSelectedLayers()-1 do
		local layer = moho.document:GetSelectedLayer(l)
		layer:UpdateCurFrame()
	end
	moho.view:DrawMe()
	moho:UpdateUI()

	local markersChannel = moho:ChannelAsAnimString(moho.layer.fTimelineMarkers)
	if markersChannel:CountKeys() > 1 then
		self:KeyframesToMarkers(moho)
	end

	moho:UpdateSelectedChannels()
end

function MR_AnimatePoints:DeletePointsKeys(moho, alt)
	local visibleLayersOnly = self.visibleLayersOnly
	self.visibleLayersOnly = self.visibleLayersOnlyKeyframing

	if moho.document:CountSelectedLayers() > 1 then
		moho.document:PrepMultiUndo(false)
	else
		moho.document:PrepUndo(moho.layer, false)
	end
	moho.document:SetDirty()
	local layersList = {}

	if next(self.isolatedLayerUUIDList) and self.processIsolatedLayersOnly then
		for i, layerUUID in pairs(self.isolatedLayerUUIDList) do
			local targetLayerIndex = tonumber(i)-1
			local layer = moho.document:LayerByAbsoluteID(targetLayerIndex)
			if layer then
				if layer:UUID() == layerUUID then
					if self:IsLayerValidForWarpMode(moho, layer) or not self.considerWarpMode then
						local isLayerOk = true
						if layer == moho.layer then
							isLayerOk = true
						elseif layer:IsWarpLayer() and self.warpMode then
							local layerSkeleton = layer:ControllingSkeleton()
							isLayerOk = MR_Utilities:IsLayerActive(moho, layer, layerSkeleton)
						elseif self.visibleLayersOnly then
							local layerSkeleton = layer:ControllingSkeleton()
							isLayerOk = MR_Utilities:IsLayerVisible(moho, layer, layerSkeleton, true)
						end
						if isLayerOk then
							table.insert(layersList, targetLayerIndex)
						end
					end
				end
			end
		end
	else
		layersList = self:ScanLayers(moho, self.considerWarpMode)
	end

	for l, layerIndex in ipairs(layersList) do
		local layer = moho.document:LayerByAbsoluteID(layerIndex)
		if layer then
			local layerFrame = layer:DocToLayerFrame(moho.frame)
			local vectorLayer = moho:LayerAsVector(layer)
			local mesh = vectorLayer:Mesh()
			if mesh:CountPoints() > 1 and layer:AnimDuration() > 0 then
				if alt then
					layer:DeleteKeysAtFrame(false, moho.frame)
				else
					for i = 0, mesh:CountPoints() - 1 do
						local pt = mesh:Point(i)
						if (pt.fSelected and self.processSelectedPointsOnly) or not self.processSelectedPointsOnly then
							local channel = pt.fAnimPos
							if channel:Duration() > 0 then
								channel:DeleteKey(layerFrame)
							end

							local curvature = 0
							local curve = nil
							local ptPos = -1
							for j = 0, pt:CountCurves() - 1 do
								curve, ptPos = pt:Curve(j, ptPos)
								local curvatureChannel = curve:Curvature(ptPos)
								local curvatureOffsetChannel1 = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, false)
								local curvatureOffsetChannel2 = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, true)
								local curvatureWeightChannel1 = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, false)
								local curvatureWeightChannel2 = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, true)

								curvatureChannel:DeleteKey(layerFrame)
								curvatureOffsetChannel1:DeleteKey(layerFrame)
								curvatureOffsetChannel2:DeleteKey(layerFrame)
								curvatureWeightChannel1:DeleteKey(layerFrame)
								curvatureWeightChannel2:DeleteKey(layerFrame)
							end
						end
					end
				end
			end
		end
	end

	local markersChannel = moho:ChannelAsAnimString(moho.layer.fTimelineMarkers)
	if markersChannel:CountKeys() > 1 then
		self:KeyframesToMarkers(moho)
	end

	for l = 0, moho.document:CountSelectedLayers()-1 do
		local layer = moho.document:GetSelectedLayer(l)
		layer:UpdateCurFrame()
	end
	self.visibleLayersOnly = visibleLayersOnly
	moho.view:DrawMe()
	moho:UpdateUI()

	moho:UpdateSelectedChannels()
end

function MR_AnimatePoints:BakePointCurvature(moho, layer, point, prevFrame, nextFrame)
	for j = 0, point:CountCurves() - 1 do
		local curve, ptPos = point:Curve(j, -1)

		local curvatureChannel = curve:Curvature(ptPos)
		local curvatureOffsetChannel1 = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, false)
		local curvatureOffsetChannel2 = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, true)
		local curvatureWeightChannel1 = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, false)
		local curvatureWeightChannel2 = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, true)
		local curvaturePrev =  curve:GetCurvature(ptPos, prevFrame)
		local curvatureNext =  curve:GetCurvature(ptPos, nextFrame)

		local offsetTruePrev =  curve:GetOffset(ptPos, prevFrame, true)
		local offsetFalsePrev =  curve:GetOffset(ptPos, prevFrame, false)
		local offsetTrueNext =  curve:GetOffset(ptPos, nextFrame, true)
		local offsetFalseNext =  curve:GetOffset(ptPos, nextFrame, false)

		local weightTruePrev =  curve:GetWeight(ptPos, prevFrame, true)
		local weightFalsePrev =  curve:GetWeight(ptPos, prevFrame, false)
		local weightTrueNext =  curve:GetWeight(ptPos, nextFrame, true)
		local weightFalseNext =  curve:GetWeight(ptPos, nextFrame, false)

		if prevFrame > 0 then
			curve:SetCurvature(ptPos, curvaturePrev, prevFrame)
			curve:SetOffset(ptPos, offsetFalsePrev, prevFrame, false)
			curve:SetOffset(ptPos, offsetTruePrev, prevFrame, true)
			curve:SetWeight(ptPos, weightFalsePrev, prevFrame, false)
			curve:SetWeight(ptPos, weightTruePrev, prevFrame, true)
		end

		curve:SetCurvature(ptPos,curvatureNext, nextFrame)
		curve:SetOffset(ptPos, offsetFalseNext, nextFrame, false)
		curve:SetOffset(ptPos, offsetTrueNext, nextFrame, true)
		curve:SetWeight(ptPos, weightFalseNext, nextFrame, false)
		curve:SetWeight(ptPos, weightTrueNext, nextFrame, true)
	end
end

function MR_AnimatePoints:ScanLayers(moho, considerWarpMode)
	local layersList = {}
	local groupStack = {}
	
	for l = 0, moho.document:CountSelectedLayers()-1 do
		local layer = moho.document:GetSelectedLayer(l)
		if moho:LayerAsVector(layer) then
			self:ProcessVectorLayer(moho, layer, layersList, considerWarpMode)
		elseif layer:IsGroupType() then
			table.insert(groupStack, layer)
		end
	end
	
	while #groupStack > 0 do
		local currentGroup = table.remove(groupStack)
		local groupLayer = moho:LayerAsGroup(currentGroup)
		
		for i = 0, groupLayer:CountLayers()-1 do
			local layer = currentGroup:LayerByDepth(i)
			if layer:IsGroupType() then
				table.insert(groupStack, layer)
			elseif moho:LayerAsVector(layer) then
				self:ProcessVectorLayer(moho, layer, layersList, considerWarpMode)
			end
		end
	end
	
	return layersList
end

function MR_AnimatePoints:ProcessVectorLayer(moho, layer, layersList, considerWarpMode)
	local isLayerOk = true
	if layer == moho.layer then
		isLayerOk = true
	elseif layer:IsWarpLayer() and self.warpMode then
		local layerSkeleton = layer:ControllingSkeleton()
		isLayerOk = MR_Utilities:IsLayerActive(moho, layer, layerSkeleton)
	elseif self.visibleLayersOnly then
		local layerSkeleton = layer:ControllingSkeleton()
		isLayerOk = MR_Utilities:IsLayerVisible(moho, layer, layerSkeleton, true)
	end

	if isLayerOk and (layer:IsAncestorSelected() or layer == moho.layer or layer:SecondarySelection()) then
		if self:IsLayerValidForWarpMode(moho, layer) or not considerWarpMode then
			if self.ignoreReferenceLayers and not layer:IsReferencedLayer() or not self.ignoreReferenceLayers then
				table.insert(layersList, moho.document:LayerAbsoluteID(layer))
			end
		end
	end
end

function MR_AnimatePoints:SelectConnectedPoints(moho)
	if next(self.isolatedLayerUUIDList) then
		for i, layerUUID in pairs(self.isolatedLayerUUIDList) do
			local layerIndex = tonumber(i)-1
			local layer = moho.document:LayerByAbsoluteID(layerIndex)

			if layer then
				if layer:UUID() == layerUUID then
					if self:IsLayerValidForWarpMode(moho, layer) then
						local vectorLayer = moho:LayerAsVector(layer)
						local mesh = vectorLayer:Mesh()
						mesh:SelectConnected()
					end
				end
			end
		end
	else
		local layersList = self:ScanLayers(moho, true)
		for l, layerIndex in ipairs(layersList) do
			local layer = moho.document:LayerByAbsoluteID(layerIndex)
			if layer then
				local vectorLayer = moho:LayerAsVector(layer)
				local mesh = vectorLayer:Mesh()
				mesh:SelectConnected()
			end
		end
	end
	moho:UpdateSelectedChannels()
	if moho:CurrentTool() == 'MR_AnimatePoints' then
		self:UpdateWidgets(moho)
	end
	moho.view:DrawMe()
end

function MR_AnimatePoints:ClearKeyframes(moho, alt)
	local visibleLayersOnly = self.visibleLayersOnly
	self.visibleLayersOnly = self.visibleLayersOnlyKeyframing

	if moho.document:CountSelectedLayers() > 1 then
		moho.document:PrepMultiUndo(false)
	else
		moho.document:PrepUndo(moho.layer, false)
	end
	moho.document:SetDirty()
	local layersList = {}

	if next(self.isolatedLayerUUIDList) and self.processIsolatedLayersOnly then
		for i, layerUUID in pairs(self.isolatedLayerUUIDList) do
			local targetLayerIndex = tonumber(i)-1
			local layer = moho.document:LayerByAbsoluteID(targetLayerIndex)
			if layer then
				if layer:UUID() == layerUUID then
					if self:IsLayerValidForWarpMode(moho, layer) or not self.considerWarpMode then
						local isLayerOk = true
						if layer == moho.layer then
							isLayerOk = true
						elseif layer:IsWarpLayer() and self.warpMode then
							local layerSkeleton = layer:ControllingSkeleton()
							isLayerOk = MR_Utilities:IsLayerActive(moho, layer, layerSkeleton)
						elseif self.visibleLayersOnly then
							local layerSkeleton = layer:ControllingSkeleton()
							isLayerOk = MR_Utilities:IsLayerVisible(moho, layer, layerSkeleton, true)
						end
						if isLayerOk then
							table.insert(layersList, targetLayerIndex)
						end
					end
				end
			end
		end
	else
		layersList = self:ScanLayers(moho, self.considerWarpMode)
	end

	for l, layerIndex in ipairs(layersList) do
		local layer = moho.document:LayerByAbsoluteID(layerIndex)
		if layer then
			local layerFrame = layer:DocToLayerFrame(moho.frame)
			local vectorLayer = moho:LayerAsVector(layer)
			if vectorLayer then
				local mesh = vectorLayer:Mesh()
				if alt then
					layer:ClearAnimation(false, 0)
				else
					for i = 0, mesh:CountPoints() - 1 do
						local pt = mesh:Point(i)
						if (pt.fSelected and self.processSelectedPointsOnly) or not self.processSelectedPointsOnly then
							local channel = pt.fAnimPos
							if channel:Duration() > 0 then
								channel:Clear()
							end

							local curvature = 0
							local curve = nil
							local ptPos = -1
							for j = 0, pt:CountCurves() - 1 do
								curve, ptPos = pt:Curve(j, ptPos)
								local curvatureChannel = curve:Curvature(ptPos)
								local curvatureOffsetChannel1 = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, false)
								local curvatureOffsetChannel2 = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, true)
								local curvatureWeightChannel1 = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, false)
								local curvatureWeightChannel2 = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, true)

								curvatureChannel:Clear()
								curvatureOffsetChannel1:Clear()
								curvatureOffsetChannel2:Clear()
								curvatureWeightChannel1:Clear()
								curvatureWeightChannel2:Clear()
							end
						end
					end
				end
			end
		end
	end

	local markersChannel = moho:ChannelAsAnimString(moho.layer.fTimelineMarkers)
	if markersChannel:CountKeys() > 1 then
		self:KeyframesToMarkers(moho)
	end

	for l = 0, moho.document:CountSelectedLayers()-1 do
		local layer = moho.document:GetSelectedLayer(l)
		layer:UpdateCurFrame()
	end

	self.visibleLayersOnly = visibleLayersOnly

	moho.view:DrawMe()
	moho:UpdateUI()
	moho:UpdateSelectedChannels()
end

function MR_AnimatePoints:KeyframesToMarkers(moho)
	local visibleLayersOnly = self.visibleLayersOnly
	self.visibleLayersOnly = self.visibleLayersOnlyKeyframing

	local markersChannel = moho:ChannelAsAnimString(moho.layer.fTimelineMarkers)
	markersChannel:Clear()

	local framesList = {}
	local framesSet = {}
	local layersList = {}

	moho.document:PrepUndo(moho.layer, true)
	moho.document:SetDirty()

	if next(self.isolatedLayerUUIDList) and self.processIsolatedLayersOnly then
		for i, layerUUID in pairs(self.isolatedLayerUUIDList) do
			local targetLayerIndex = tonumber(i)-1
			local layer = moho.document:LayerByAbsoluteID(targetLayerIndex)
			if layer then
				if layer:UUID() == layerUUID then
					if self:IsLayerValidForWarpMode(moho, layer) or not self.considerWarpMode then
						local isLayerOk = true
						if layer == moho.layer then
							isLayerOk = true
						elseif layer:IsWarpLayer() and self.warpMode then
							local layerSkeleton = layer:ControllingSkeleton()
							isLayerOk = MR_Utilities:IsLayerActive(moho, layer, layerSkeleton)
						elseif self.visibleLayersOnly then
							local layerSkeleton = layer:ControllingSkeleton()
							isLayerOk = MR_Utilities:IsLayerVisible(moho, layer, layerSkeleton, true)
						end
						if isLayerOk then
							table.insert(layersList, targetLayerIndex)
						end
					end
				end
			end
		end
	else
		layersList = self:ScanLayers(moho, self.considerWarpMode)
	end

	for _, layerIndex in ipairs(layersList) do
		local layer = moho.document:LayerByAbsoluteID(layerIndex)
		if layer then
			local timingOffset = layer:TotalTimingOffset()
			local vectorLayer = moho:LayerAsVector(layer)
			if vectorLayer then
				local mesh = vectorLayer:Mesh()
				for p = 0, mesh:CountPoints() - 1 do
					local point = mesh:Point(p)
					if (self.processSelectedPointsOnly and point.fSelected) or not self.processSelectedPointsOnly then
						local posChannel = moho:ChannelAsAnimVec2(point.fAnimPos)
						for k = 0, posChannel:CountKeys() - 1 do
							local frame = math.floor(posChannel:GetKeyWhen(k) - timingOffset)
							if frame and not framesSet[frame] and frame > 0 then
								framesSet[frame] = true
								framesList[#framesList + 1] = frame
							end
						end
						
						for c = 0, point:CountCurves() - 1 do
							local curve, ptPos = point:Curve(c, -1)
							local curvatureChannel = curve:Curvature(ptPos)
							
							for k = 0, curvatureChannel:CountKeys() - 1 do
								local frame = math.floor(curvatureChannel:GetKeyWhen(k) - timingOffset)
								if frame and not framesSet[frame] and frame > 0 then
									framesSet[frame] = true
									framesList[#framesList + 1] = frame
								end
							end
							
							local weightTrueChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, true)
							for k = 0, weightTrueChannel:CountKeys() - 1 do
								local frame = math.floor(weightTrueChannel:GetKeyWhen(k) - timingOffset)
								if frame and not framesSet[frame] and frame > 0 then
									framesSet[frame] = true
									framesList[#framesList + 1] = frame
								end
							end
							
							local weightFalseChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, false)
							for k = 0, weightFalseChannel:CountKeys() - 1 do
								local frame = math.floor(weightFalseChannel:GetKeyWhen(k) - timingOffset)
								if frame and not framesSet[frame] and frame > 0 then
									framesSet[frame] = true
									framesList[#framesList + 1] = frame
								end
							end
							
							local offsetTrueChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, true)
							for k = 0, offsetTrueChannel:CountKeys() - 1 do
								local frame = math.floor(offsetTrueChannel:GetKeyWhen(k) - timingOffset)
								if frame and not framesSet[frame] and frame > 0 then
									framesSet[frame] = true
									framesList[#framesList + 1] = frame
								end
							end
							
							local offsetFalseChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, false)
							for k = 0, offsetFalseChannel:CountKeys() - 1 do
								local frame = math.floor(offsetFalseChannel:GetKeyWhen(k) - timingOffset)
								if frame and not framesSet[frame] and frame > 0 then
									framesSet[frame] = true
									framesList[#framesList + 1] = frame
								end
							end
						end
					end
				end
			end
		end
	end

	for i, frame in ipairs(framesList) do
		local layerFrame = moho.layer:DocToLayerFrame(frame)
		markersChannel:AddKey(layerFrame)
		local text = ' \n'..frame
		markersChannel:SetValue(layerFrame, text)

		local interp = MOHO.InterpSetting:new_local()
		markersChannel:GetKeyInterp(layerFrame, interp)
		interp.tags = 7
		markersChannel:SetKeyInterp(layerFrame, interp)
	end
	self.visibleLayersOnly = visibleLayersOnly
	moho:UpdateSelectedChannels()
	moho.view:DrawMe()
	moho:UpdateUI()
end

function MR_AnimatePoints:MarkersToKeyframes(moho)
	local visibleLayersOnly = self.visibleLayersOnly
	self.visibleLayersOnly = self.visibleLayersOnlyKeyframing

	local markersChannel = moho:ChannelAsAnimString(moho.layer.fTimelineMarkers)
	local markerLayerTimingOffset = moho.layer:TotalTimingOffset()

	local layersList = {}

	if next(self.isolatedLayerUUIDList) and self.processIsolatedLayersOnly then
		for i, layerUUID in pairs(self.isolatedLayerUUIDList) do
			local targetLayerIndex = tonumber(i)-1
			local layer = moho.document:LayerByAbsoluteID(targetLayerIndex)
			if layer then
				if layer:UUID() == layerUUID then
					if self:IsLayerValidForWarpMode(moho, layer) or not self.considerWarpMode then
						local isLayerOk = true
						if layer == moho.layer then
							isLayerOk = true
						elseif layer:IsWarpLayer() and self.warpMode then
							local layerSkeleton = layer:ControllingSkeleton()
							isLayerOk = MR_Utilities:IsLayerActive(moho, layer, layerSkeleton)
						elseif self.visibleLayersOnly then
							local layerSkeleton = layer:ControllingSkeleton()
							isLayerOk = MR_Utilities:IsLayerVisible(moho, layer, layerSkeleton, true)
						end
						if isLayerOk then
							table.insert(layersList, targetLayerIndex)
						end
					end
				end
			end
		end
	else
		layersList = self:ScanLayers(moho, self.considerWarpMode)
	end

	if moho.document:CountSelectedLayers() > 1 then
		moho.document:PrepMultiUndo(false)
		moho.document:SetDirty()
	else
		if #layersList == 1 then
			local layer = moho.document:LayerByAbsoluteID(layersList[1])
			if layer then
				moho.document:PrepUndo(layer, false)
				moho.document:SetDirty()
			else
				moho.document:PrepUndo(moho.layer, false)
				moho.document:SetDirty()
			end
		else
			moho.document:PrepUndo(moho.layer, false)
			moho.document:SetDirty()
		end
	end

	for _, layerIndex in ipairs(layersList) do
		local layer = moho.document:LayerByAbsoluteID(layerIndex)
		if layer then
			local vectorLayer = moho:LayerAsVector(layer)
			if vectorLayer then
				local pointsPosList = {}
				local pointInterpList = {}
				local curvatureList = {}
				local weightTrueList = {}
				local weightFalseList = {}
				local offsetTrueList = {}
				local offsetFalseList = {}

				local curvatureInterpList = {}
				local weightTrueInterpList = {}
				local weightFalseInterpList = {}
				local offsetTrueInterpList = {}
				local offsetFalseInterpList = {}

				local timingOffset = layer:TotalTimingOffset()

				local mesh = vectorLayer:Mesh()
				for i = 0, mesh:CountPoints() - 1 do
					local point = mesh:Point(i)

					local pointKeysList = {}
					local pointInterpKeyList = {}
					local posChannel = moho:ChannelAsAnimVec2(point.fAnimPos)
					for j = 0, posChannel:CountKeys() - 1 do
						local frame = math.floor(posChannel:GetKeyWhen(j))
						if frame > 0 then
							pointKeysList[frame] = posChannel:GetValue(frame)
							local interp = MOHO.InterpSetting:new_local()
							posChannel:GetKeyInterp(frame, interp)
							pointInterpKeyList[frame] = interp
						end
					end
					table.insert(pointsPosList, pointKeysList)
					table.insert(pointInterpList, pointInterpKeyList)

					local curveCurvatureKeysList = {}
					local curveWeightTrueKeysList = {}
					local curveWeightFalseKeysList = {}
					local curveOffsetTrueKeysList = {}
					local curveOffsetFalseKeysList = {}

					local curveCurvatureInterpKeysList = {}
					local curveWeightTrueInterpKeysList = {}
					local curveWeightFalseInterpKeysList = {}
					local curveOffsetTrueInterpKeysList = {}
					local curveOffsetFalseInterpKeysList = {}

					for j = 0, point:CountCurves() - 1 do
						local curve, ptPos = point:Curve(j, -1)

						local curvatureKeysList = {}
						local weightTrueKeysList = {}
						local weightFalseKeysList = {}
						local offsetTrueKeysList = {}
						local offsetFalseKeysList = {}

						local curvatureInterpKeysList = {}
						local weightTrueInterpKeysList = {}
						local weightFalseInterpKeysList = {}
						local offsetTrueInterpKeysList = {}
						local offsetFalseInterpKeysList = {}

						local curvatureChannel = curve:Curvature(ptPos)
						local weightTrueChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, true)
						local weightFalseChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, false)
						local offsetTrueChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, true)
						local offsetFalseChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, false)

						for k = 0, curvatureChannel:CountKeys() - 1 do
							local frame = math.floor(curvatureChannel:GetKeyWhen(k))
							if frame > 0 then
								curvatureKeysList[frame] = curvatureChannel:GetValue(frame)
								local interp = MOHO.InterpSetting:new_local()
								curvatureChannel:GetKeyInterp(frame, interp)
								curvatureInterpKeysList[frame] = interp
							end
						end

						for k = 0, weightTrueChannel:CountKeys() - 1 do
							local frame = math.floor(weightTrueChannel:GetKeyWhen(k))
							if frame > 0 then
								weightTrueKeysList[frame] = weightTrueChannel:GetValue(frame)
								local interp = MOHO.InterpSetting:new_local()
								weightTrueChannel:GetKeyInterp(frame, interp)
								weightTrueInterpKeysList[frame] = interp
							end
						end

						for k = 0, weightFalseChannel:CountKeys() - 1 do
							local frame = math.floor(weightFalseChannel:GetKeyWhen(k))
							if frame > 0 then
								weightFalseKeysList[frame] = weightFalseChannel:GetValue(frame)
								local interp = MOHO.InterpSetting:new_local()
								weightFalseChannel:GetKeyInterp(frame, interp)
								weightFalseInterpKeysList[frame] = interp
							end
						end
						
						for k = 0, offsetTrueChannel:CountKeys() - 1 do
							local frame = math.floor(offsetTrueChannel:GetKeyWhen(k))
							if frame > 0 then
								offsetTrueKeysList[frame] = offsetTrueChannel:GetValue(frame)
								local interp = MOHO.InterpSetting:new_local()
								offsetTrueChannel:GetKeyInterp(frame, interp)
								offsetTrueInterpKeysList[frame] = interp
							end
						end
						
						for k = 0, offsetFalseChannel:CountKeys() - 1 do
							local frame = math.floor(offsetFalseChannel:GetKeyWhen(k))
							if frame > 0 then
								offsetFalseKeysList[frame] = offsetFalseChannel:GetValue(frame)
								local interp = MOHO.InterpSetting:new_local()
								offsetFalseChannel:GetKeyInterp(frame, interp)
								offsetFalseInterpKeysList[frame] = interp
							end
						end

						table.insert(curveCurvatureKeysList, curvatureKeysList)
						table.insert(curveWeightTrueKeysList, weightTrueKeysList)
						table.insert(curveWeightFalseKeysList, weightFalseKeysList)
						table.insert(curveOffsetTrueKeysList, offsetTrueKeysList)
						table.insert(curveOffsetFalseKeysList, offsetFalseKeysList)

						table.insert(curveCurvatureInterpKeysList, curvatureInterpKeysList)
						table.insert(curveWeightTrueInterpKeysList, weightTrueInterpKeysList)
						table.insert(curveWeightFalseInterpKeysList, weightFalseInterpKeysList)
						table.insert(curveOffsetTrueInterpKeysList, offsetTrueInterpKeysList)
						table.insert(curveOffsetFalseInterpKeysList, offsetFalseInterpKeysList)
					end
					table.insert(curvatureList, curveCurvatureKeysList)
					table.insert(weightTrueList, curveWeightTrueKeysList)
					table.insert(weightFalseList, curveWeightFalseKeysList)
					table.insert(offsetTrueList, curveOffsetTrueKeysList)
					table.insert(offsetFalseList, curveOffsetFalseKeysList)

					table.insert(curvatureInterpList, curveCurvatureInterpKeysList)
					table.insert(weightTrueInterpList, curveWeightTrueInterpKeysList)
					table.insert(weightFalseInterpList, curveWeightFalseInterpKeysList)
					table.insert(offsetTrueInterpList, curveOffsetTrueInterpKeysList)
					table.insert(offsetFalseInterpList, curveOffsetFalseInterpKeysList)
				end

				for i = 0, markersChannel:CountKeys() - 1 do
					local layerFrame = math.floor(markersChannel:GetKeyWhen(i))
					local frame = math.floor(layerFrame - markerLayerTimingOffset)
					if layerFrame > 0 then
						local markerText = markersChannel:GetValue(layerFrame)
						local markerVal = tonumber(string.match(markerText, "%d+"))
						if not markerVal then
							if (layer:AnimDuration() > 0) then
								for i = 0, mesh:CountPoints() - 1 do
									local point = mesh:Point(i)
									if point then
										if (point.fSelected and self.processSelectedPointsOnly) or not self.processSelectedPointsOnly then
											local posChannel = moho:ChannelAsAnimVec2(point.fAnimPos)
											for j = 0, posChannel:CountKeys() - 1 do
												local frame = posChannel:GetKeyWhen(j)
												if frame > 0 then
													local val = LM.Vector2:new_local()
													val = posChannel:GetValue(layerFrame)
													posChannel:SetValue(layerFrame, val)
												end
											end
											for j = 0, point:CountCurves() - 1 do
												local curve, ptPos = point:Curve(j, -1)
												local curvatureChannel = curve:Curvature(ptPos)
												for k = 0, curvatureChannel:CountKeys() - 1 do
													local frame = curvatureChannel:GetKeyWhen(k)
													if frame > 0 then
														local val = 0
														val = curvatureChannel:GetValue(layerFrame)
														curve:SetCurvature(ptPos, val, layerFrame)
													end
												end

												local offsetTrueChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, true)
												for k = 0, offsetTrueChannel:CountKeys() - 1 do
													local frame = offsetTrueChannel:GetKeyWhen(k)
													if frame > 0 then
														local val = 0
														val = offsetTrueChannel:GetValue(layerFrame)
														offsetTrueChannel:SetValue(layerFrame, val)
													end
												end

												local offsetFalseChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, false)
												for k = 0, offsetFalseChannel:CountKeys() - 1 do
													local frame = offsetFalseChannel:GetKeyWhen(k)
													if frame > 0 then
														local val = 0
														val = offsetFalseChannel:GetValue(layerFrame)
														offsetFalseChannel:SetValue(layerFrame, val)
													end
												end

												local weightTrueChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, true)
												for k = 0, weightTrueChannel:CountKeys() - 1 do
													local frame = weightTrueChannel:GetKeyWhen(k)
													if frame > 0 then
														local val = 0
														val = weightTrueChannel:GetValue(layerFrame)
														weightTrueChannel:SetValue(layerFrame, val)
													end
												end

												local weightFalseChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, false)
												for k = 0, weightFalseChannel:CountKeys() - 1 do
													local frame = weightFalseChannel:GetKeyWhen(k)
													if frame > 0 then
														local val = 0
														val = weightFalseChannel:GetValue(layerFrame)
														weightFalseChannel:SetValue(layerFrame, val)
													end
												end
											end
										end
									end
								end
							end
						end
					end
				end

				local existingMarkerFrames = {}
				for i = 0, markersChannel:CountKeys() - 1 do
					local frame = math.floor(markersChannel:GetKeyWhen(i))
					if frame > 0 then
						existingMarkerFrames[frame - markerLayerTimingOffset] = true
					end
				end
				
				for i = 0, mesh:CountPoints() - 1 do
					local point = mesh:Point(i)
					if (self.processSelectedPointsOnly and point.fSelected) or not self.processSelectedPointsOnly then
						local posChannel = moho:ChannelAsAnimVec2(point.fAnimPos)
						local keysToDelete = {}
						
						for j = 0, posChannel:CountKeys() - 1 do
							local layerFrame = math.floor(posChannel:GetKeyWhen(j))
							local frame = math.floor(layerFrame - timingOffset)
							if layerFrame > 0 and not existingMarkerFrames[frame] then
								table.insert(keysToDelete, layerFrame)
							end
						end
						
						for k = #keysToDelete, 1, -1 do
							posChannel:DeleteKey(keysToDelete[k])
						end

						for j = 0, point:CountCurves() - 1 do
							local curve, ptPos = point:Curve(j, -1)
							local curvatureChannel = curve:Curvature(ptPos)
							local keysToDelete = {}
							
							for k = 0, curvatureChannel:CountKeys() - 1 do
								local layerFrame = math.floor(curvatureChannel:GetKeyWhen(k))
								local frame = math.floor(layerFrame - timingOffset)
								if layerFrame > 0 and not existingMarkerFrames[frame] then
									table.insert(keysToDelete, layerFrame)
								end
							end
							
							for k = #keysToDelete, 1, -1 do
								curvatureChannel:DeleteKey(keysToDelete[k])
							end

							local weightTrueChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, true)
							keysToDelete = {}
							
							for k = 0, weightTrueChannel:CountKeys() - 1 do
								local layerFrame = math.floor(weightTrueChannel:GetKeyWhen(k))
								local frame = math.floor(layerFrame - timingOffset)
								if layerFrame > 0 and not existingMarkerFrames[frame] then
									table.insert(keysToDelete, layerFrame)
								end
							end
							
							for k = #keysToDelete, 1, -1 do
								weightTrueChannel:DeleteKey(keysToDelete[k])
							end

							local weightFalseChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, false)
							keysToDelete = {}
							
							for k = 0, weightFalseChannel:CountKeys() - 1 do
								local layerFrame = math.floor(weightFalseChannel:GetKeyWhen(k))
								local frame = math.floor(layerFrame - timingOffset)
								if layerFrame > 0 and not existingMarkerFrames[frame] then
									table.insert(keysToDelete, layerFrame)
								end
							end
							
							for k = #keysToDelete, 1, -1 do
								weightFalseChannel:DeleteKey(keysToDelete[k])
							end

							local offsetTrueChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, true)
							keysToDelete = {}
							
							for k = 0, offsetTrueChannel:CountKeys() - 1 do
								local layerFrame = math.floor(offsetTrueChannel:GetKeyWhen(k))
								local frame = math.floor(layerFrame - timingOffset)
								if layerFrame > 0 and not existingMarkerFrames[frame] then
									table.insert(keysToDelete, layerFrame)
								end
							end
							
							for k = #keysToDelete, 1, -1 do
								offsetTrueChannel:DeleteKey(keysToDelete[k])
							end

							local offsetFalseChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, false)
							keysToDelete = {}
							
							for k = 0, offsetFalseChannel:CountKeys() - 1 do
								local layerFrame = math.floor(offsetFalseChannel:GetKeyWhen(k))
								local frame = math.floor(layerFrame - timingOffset)
								if layerFrame > 0 and not existingMarkerFrames[frame] then
									table.insert(keysToDelete, layerFrame)
								end
							end
							
							for k = #keysToDelete, 1, -1 do
								offsetFalseChannel:DeleteKey(keysToDelete[k])
							end
						end
					end
				end

				local posChannelCreatedList = {}
				local curvatureChannelCreatedKeys = {}
				local weightTrueChannelCreatedKeys = {}
				local weightFalseChannelCreatedKeys = {}
				local offsetTrueChannelCreatedKeys = {}
				local offsetFalseChannelCreatedKeys = {}
				
				local posChannelSourceList = {}
				local curvatureChannelSourceKeys = {}
				local weightTrueChannelSourceKeys = {}
				local weightFalseChannelSourceKeys = {}
				local offsetTrueChannelSourceKeys = {}
				local offsetFalseChannelSourceKeys = {}
				
				for i = 0, markersChannel:CountKeys() - 1 do
					local layerFrame = math.floor(markersChannel:GetKeyWhen(i))
					local frame = math.floor(layerFrame - markerLayerTimingOffset)
					if layerFrame > 0 then
						local markerText = markersChannel:GetValue(layerFrame)
						local markerVal = tonumber(string.match(markerText, "%d+"))
						if markerVal and markerVal ~= frame then
							for p = 1, #pointsPosList do
								local pointKeysList = pointsPosList[p]
								local pointInterpKeyList = pointInterpList[p]
								if pointKeysList[layer:DocToLayerFrame(markerVal)] then
									local point = mesh:Point(p-1)
										if (self.processSelectedPointsOnly and point.fSelected) or not self.processSelectedPointsOnly then
										local posChannel = moho:ChannelAsAnimVec2(point.fAnimPos)
										posChannel:SetValue(layer:DocToLayerFrame(frame), pointKeysList[layer:DocToLayerFrame(markerVal)])

										local pointInterpKey = pointInterpKeyList[layer:DocToLayerFrame(markerVal)]
										posChannel:SetKeyInterp(layer:DocToLayerFrame(frame), pointInterpKey)

										if not posChannelCreatedList[p] then
											posChannelCreatedList[p] = {}
										end
										posChannelCreatedList[p][frame] = true

										if not posChannelSourceList[p] then
											posChannelSourceList[p] = {}
										end
										posChannelSourceList[p][markerVal] = true
									end
								end
							end

							for p = 1, #curvatureList do
								local curveCurvatureKeysList = curvatureList[p]
								for c = 1, #curveCurvatureKeysList do
									local curvatureKeysList = curveCurvatureKeysList[c]
									local curvatureInterpKeysList = curvatureInterpList[p][c]

									if curvatureKeysList[layer:DocToLayerFrame(markerVal)] then
										local point = mesh:Point(p-1)
										if (self.processSelectedPointsOnly and point.fSelected) or not self.processSelectedPointsOnly then
											local curve, ptPos = point:Curve(c-1, -1)
											local curvatureChannel = curve:Curvature(ptPos)
											
											if not curvatureChannelCreatedKeys[p] then
												curvatureChannelCreatedKeys[p] = {}
											end
											if not curvatureChannelCreatedKeys[p][c] then
												curvatureChannelCreatedKeys[p][c] = {}
											end
											curvatureChannelCreatedKeys[p][c][frame] = true

											if not curvatureChannelSourceKeys[p] then
												curvatureChannelSourceKeys[p] = {}
											end
											if not curvatureChannelSourceKeys[p][c] then
												curvatureChannelSourceKeys[p][c] = {}
											end
											curvatureChannelSourceKeys[p][c][markerVal] = true
											
											curvatureChannel:SetValue(layer:DocToLayerFrame(frame), curvatureKeysList[layer:DocToLayerFrame(markerVal)])
											local curvatureInterpKey = curvatureInterpKeysList[layer:DocToLayerFrame(markerVal)]
											curvatureChannel:SetKeyInterp(layer:DocToLayerFrame(frame), curvatureInterpKey)
										end
									end
								end
							end

							for p = 1, #weightTrueList do
								local curveWeightTrueKeysList = weightTrueList[p]
								for c = 1, #curveWeightTrueKeysList do
									local weightTrueKeysList = curveWeightTrueKeysList[c]
									local weightTrueInterpKeysList = weightTrueInterpList[p][c]
									if weightTrueKeysList[layer:DocToLayerFrame(markerVal)] then
										local point = mesh:Point(p-1)
										if (self.processSelectedPointsOnly and point.fSelected) or not self.processSelectedPointsOnly then
											local curve, ptPos = point:Curve(c-1, -1)
											local weightTrueChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, true)
											
											if not weightTrueChannelCreatedKeys[p] then
												weightTrueChannelCreatedKeys[p] = {}
											end
											if not weightTrueChannelCreatedKeys[p][c] then
												weightTrueChannelCreatedKeys[p][c] = {}
											end
											weightTrueChannelCreatedKeys[p][c][frame] = true
											
											if not weightTrueChannelSourceKeys[p] then
												weightTrueChannelSourceKeys[p] = {}
											end
											if not weightTrueChannelSourceKeys[p][c] then
												weightTrueChannelSourceKeys[p][c] = {}
											end
											weightTrueChannelSourceKeys[p][c][markerVal] = true
											
											weightTrueChannel:SetValue(layer:DocToLayerFrame(frame), weightTrueKeysList[layer:DocToLayerFrame(markerVal)])
											local weightTrueInterpKey = weightTrueInterpKeysList[layer:DocToLayerFrame(markerVal)]
											weightTrueChannel:SetKeyInterp(layer:DocToLayerFrame(frame), weightTrueInterpKey)
										end
									end
								end
							end

							for p = 1, #weightFalseList do
								local curveWeightFalseKeysList = weightFalseList[p]
								for c = 1, #curveWeightFalseKeysList do
									local weightFalseKeysList = curveWeightFalseKeysList[c]
									local weightFalseInterpKeysList = weightFalseInterpList[p][c]
									if weightFalseKeysList[layer:DocToLayerFrame(markerVal)] then
										local point = mesh:Point(p-1)
										if (self.processSelectedPointsOnly and point.fSelected) or not self.processSelectedPointsOnly then
											local curve, ptPos = point:Curve(c-1, -1)
											local weightFalseChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, false)
											
											if not weightFalseChannelCreatedKeys[p] then
												weightFalseChannelCreatedKeys[p] = {}
											end
											if not weightFalseChannelCreatedKeys[p][c] then
												weightFalseChannelCreatedKeys[p][c] = {}
											end
											weightFalseChannelCreatedKeys[p][c][frame] = true
											
											if not weightFalseChannelSourceKeys[p] then
												weightFalseChannelSourceKeys[p] = {}
											end
											if not weightFalseChannelSourceKeys[p][c] then
												weightFalseChannelSourceKeys[p][c] = {}
											end
											weightFalseChannelSourceKeys[p][c][markerVal] = true
											
											weightFalseChannel:SetValue(layer:DocToLayerFrame(frame), weightFalseKeysList[layer:DocToLayerFrame(markerVal)])
											local weightFalseInterpKey = weightFalseInterpKeysList[layer:DocToLayerFrame(markerVal)]
											weightFalseChannel:SetKeyInterp(layer:DocToLayerFrame(frame), weightFalseInterpKey)
										end
									end
								end
							end

							for p = 1, #offsetTrueList do
								local curveOffsetTrueKeysList = offsetTrueList[p]
								for c = 1, #curveOffsetTrueKeysList do
									local offsetTrueKeysList = curveOffsetTrueKeysList[c]
									local offsetTrueInterpKeysList = offsetTrueInterpList[p][c]
									if offsetTrueKeysList[layer:DocToLayerFrame(markerVal)] then
										local point = mesh:Point(p-1)
										if (self.processSelectedPointsOnly and point.fSelected) or not self.processSelectedPointsOnly then
											local curve, ptPos = point:Curve(c-1, -1)
											local offsetTrueChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, true)
											
											if not offsetTrueChannelCreatedKeys[p] then
												offsetTrueChannelCreatedKeys[p] = {}
											end
											if not offsetTrueChannelCreatedKeys[p][c] then
												offsetTrueChannelCreatedKeys[p][c] = {}
											end
											offsetTrueChannelCreatedKeys[p][c][frame] = true
											
											if not offsetTrueChannelSourceKeys[p] then
												offsetTrueChannelSourceKeys[p] = {}
											end
											if not offsetTrueChannelSourceKeys[p][c] then
												offsetTrueChannelSourceKeys[p][c] = {}
											end
											offsetTrueChannelSourceKeys[p][c][markerVal] = true
											
											offsetTrueChannel:SetValue(layer:DocToLayerFrame(frame), offsetTrueKeysList[layer:DocToLayerFrame(markerVal)])
											local offsetTrueInterpKey = offsetTrueInterpKeysList[layer:DocToLayerFrame(markerVal)]
											offsetTrueChannel:SetKeyInterp(layer:DocToLayerFrame(frame), offsetTrueInterpKey)
										end
									end
								end
							end

							for p = 1, #offsetFalseList do
								local curveOffsetFalseKeysList = offsetFalseList[p]
								for c = 1, #curveOffsetFalseKeysList do
									local offsetFalseKeysList = curveOffsetFalseKeysList[c]
									local offsetFalseInterpKeysList = offsetFalseInterpList[p][c]
									if offsetFalseKeysList[layer:DocToLayerFrame(markerVal)] then
										local point = mesh:Point(p-1)
										if (self.processSelectedPointsOnly and point.fSelected) or not self.processSelectedPointsOnly then
											local curve, ptPos = point:Curve(c-1, -1)
											local offsetFalseChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, false)
											
											if not offsetFalseChannelCreatedKeys[p] then
												offsetFalseChannelCreatedKeys[p] = {}
											end
											if not offsetFalseChannelCreatedKeys[p][c] then
												offsetFalseChannelCreatedKeys[p][c] = {}
											end
											offsetFalseChannelCreatedKeys[p][c][frame] = true
											
											if not offsetFalseChannelSourceKeys[p] then
												offsetFalseChannelSourceKeys[p] = {}
											end
											if not offsetFalseChannelSourceKeys[p][c] then
												offsetFalseChannelSourceKeys[p][c] = {}
											end
											offsetFalseChannelSourceKeys[p][c][markerVal] = true
											
											offsetFalseChannel:SetValue(layer:DocToLayerFrame(frame), offsetFalseKeysList[layer:DocToLayerFrame(markerVal)])
											local offsetFalseInterpKey = offsetFalseInterpKeysList[layer:DocToLayerFrame(markerVal)]
											offsetFalseChannel:SetKeyInterp(layer:DocToLayerFrame(frame), offsetFalseInterpKey)
										end
									end
								end
							end
						end
					end
				end
				local remeList = {}
				for p = 0, mesh:CountPoints() - 1 do
					local point = mesh:Point(p)
					if (self.processSelectedPointsOnly and point.fSelected) or not self.processSelectedPointsOnly then
						local posChannel = moho:ChannelAsAnimVec2(point.fAnimPos)
						for k = 0, posChannel:CountKeys() - 1 do
							if k > 0 then
								local layerFrame = math.floor(posChannel:GetKeyWhen(k))
								local frame = math.floor(layerFrame - timingOffset)
								local isValid = false
								if posChannelCreatedList[p+1] then
									if posChannelCreatedList[p+1][frame] then
										if posChannelSourceList[p+1] then
											if posChannelSourceList[p+1][frame] then
												isValid = true
											end
										end
									end
								end
								if isValid then
									if layerFrame > 0 and not posChannelCreatedList[p+1][frame] and posChannelSourceList[p+1][frame] then
										table.insert(remeList, {p, layerFrame})
									end
								end
							end
						end
					end
				end

				for i = 1, #remeList do
					local p = remeList[i][1]
					local frame = remeList[i][2]
					local point = mesh:Point(p)
					local posChannel = moho:ChannelAsAnimVec2(point.fAnimPos)
					posChannel:DeleteKey(frame)
				end
				
				for p = 0, mesh:CountPoints() - 1 do
					local point = mesh:Point(p)
					if (self.processSelectedPointsOnly and point.fSelected) or not self.processSelectedPointsOnly then
						for c = 0, point:CountCurves() - 1 do
							local curve, ptPos = point:Curve(c, -1)
							
							local curvatureChannel = curve:Curvature(ptPos)
							local remeList = {}
							
							for k = 0, curvatureChannel:CountKeys() - 1 do
								if k > 0 then
									local layerFrame = math.floor(curvatureChannel:GetKeyWhen(k))
									local frame = math.floor(layerFrame - timingOffset)
									local isValid = false
									if curvatureChannelSourceKeys[p+1] then
										if curvatureChannelSourceKeys[p+1][c+1] then
											if curvatureChannelSourceKeys[p+1][c+1][frame] then
												isValid = true
											end
										end
									end
									if isValid then
										if layerFrame > 0 and curvatureChannelSourceKeys[p+1][c+1][frame] and not curvatureChannelCreatedKeys[p+1][c+1][frame] then
											table.insert(remeList, layerFrame)
										end
									end
								end
							end
							
							for r = 1, #remeList do
								local frame = remeList[r]
								curvatureChannel:DeleteKey(frame)
							end
							
							local weightTrueChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, true)
							remeList = {}
							
							for k = 0, weightTrueChannel:CountKeys() - 1 do
								if k > 0 then
									local layerFrame = math.floor(weightTrueChannel:GetKeyWhen(k))
									local frame = math.floor(layerFrame - timingOffset)

									local isValid = false
									if weightTrueChannelSourceKeys[p+1] then
										if weightTrueChannelSourceKeys[p+1][c+1] then
											if weightTrueChannelSourceKeys[p+1][c+1][frame] then
												isValid = true
											end
										end
									end
									if isValid then
										if layerFrame > 0 and weightTrueChannelSourceKeys[p+1][c+1][frame] and not weightTrueChannelCreatedKeys[p+1][c+1][frame] then
											table.insert(remeList, layerFrame)
										end
									end
								end
							end
							
							for r = 1, #remeList do
								local frame = remeList[r]
								weightTrueChannel:DeleteKey(frame)
							end
							
							local weightFalseChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, false)
							remeList = {}
							
							for k = 0, weightFalseChannel:CountKeys() - 1 do
								if k > 0 then
									local layerFrame = math.floor(weightFalseChannel:GetKeyWhen(k))
									local frame = math.floor(layerFrame - timingOffset)

									local isValid = false
									if weightFalseChannelSourceKeys[p+1] then
										if weightFalseChannelSourceKeys[p+1][c+1] then
											if weightFalseChannelSourceKeys[p+1][c+1][frame] then
												isValid = true
											end
										end
									end

									if isValid then
										if layerFrame > 0 and weightFalseChannelSourceKeys[p+1][c+1][frame] and not weightFalseChannelCreatedKeys[p+1][c+1][frame] then
											table.insert(remeList, layerFrame)
										end
									end
								end
							end
							
							for r = 1, #remeList do
								local frame = remeList[r]
								weightFalseChannel:DeleteKey(frame)
							end
							
							local offsetTrueChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, true)
							remeList = {}
							
							for k = 0, offsetTrueChannel:CountKeys() - 1 do
								if k > 0 then
									local layerFrame = math.floor(offsetTrueChannel:GetKeyWhen(k))
									local frame = math.floor(layerFrame - timingOffset)
									local isValid = false
									if offsetTrueChannelSourceKeys[p+1] then
										if offsetTrueChannelSourceKeys[p+1][c+1] then
											if offsetTrueChannelSourceKeys[p+1][c+1][frame] then
												isValid = true
											end
										end
									end

									if isValid then
										if layerFrame > 0 and offsetTrueChannelSourceKeys[p+1][c+1][frame] and not offsetTrueChannelCreatedKeys[p+1][c+1][frame] then
											table.insert(remeList, layerFrame)
										end
									end
								end
							end
							
							for r = 1, #remeList do
								local frame = remeList[r]
								offsetTrueChannel:DeleteKey(frame)
							end
							
							local offsetFalseChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, false)
							remeList = {}
							
							for k = 0, offsetFalseChannel:CountKeys() - 1 do
								if k > 0 then
									local layerFrame = math.floor(offsetFalseChannel:GetKeyWhen(k))
									local frame = math.floor(layerFrame - timingOffset)

									local isValid = false
									if offsetFalseChannelSourceKeys[p+1] then
										if offsetFalseChannelSourceKeys[p+1][c+1] then
											if offsetFalseChannelSourceKeys[p+1][c+1][frame] then
												isValid = true
											end
										end
									end

									if isValid then
										if layerFrame > 0 and offsetFalseChannelSourceKeys[p+1][c+1][frame] and not offsetFalseChannelCreatedKeys[p+1][c+1][frame] then
											table.insert(remeList, layerFrame)
										end
									end
								end
							end
							
							for r = 1, #remeList do
								local frame = remeList[r]
								offsetFalseChannel:DeleteKey(frame)
							end
						end
					end
				end
			end
		end
	end
	self.visibleLayersOnly = visibleLayersOnly
	moho.layer:UpdateCurFrame()
	self:KeyframesToMarkers(moho)
	moho:UpdateSelectedChannels()
	moho.view:DrawMe()
	moho:UpdateUI()
end

function MR_AnimatePoints:ConvertInterpolation(isInterval)
	local helper = MOHO.ScriptInterfaceHelper:new_local()
	local moho = helper:MohoObject()

	local markersChannel = moho:ChannelAsAnimString(moho.layer.fTimelineMarkers)
	local timingOffset = moho.layer:TotalTimingOffset()

	local layersList = {}

	if next(self.isolatedLayerUUIDList) and self.processIsolatedLayersOnly then
		for i, layerUUID in pairs(self.isolatedLayerUUIDList) do
			local targetLayerIndex = tonumber(i)-1
			local layer = moho.document:LayerByAbsoluteID(targetLayerIndex)
			if layer then
				if layer:UUID() == layerUUID then
					if self:IsLayerValidForWarpMode(moho, layer) then
						local isLayerOk = true
						if layer == moho.layer then
							isLayerOk = true
						elseif layer:IsWarpLayer() and self.warpMode then
							local layerSkeleton = layer:ControllingSkeleton()
							isLayerOk = MR_Utilities:IsLayerActive(moho, layer, layerSkeleton)
						elseif self.visibleLayersOnly then
							local layerSkeleton = layer:ControllingSkeleton()
							isLayerOk = MR_Utilities:IsLayerVisible(moho, layer, layerSkeleton, true)
						end
						if isLayerOk then
							table.insert(layersList, targetLayerIndex)
						end
					end
				end
			end
		end
	else
		layersList = self:ScanLayers(moho, true)
	end

	local targetFrames = {}

	for i = 0, markersChannel:CountKeys() - 1 do
		if markersChannel:IsKeySelectedByID(i) then
			local frame = math.floor(markersChannel:GetKeyWhen(i))
			if frame > 0 then
				local markerText = markersChannel:GetValue(frame)
				local markerVal = tonumber(string.match(markerText, "%d+"))
				markerVal = math.floor(markerVal)
				targetFrames[markerVal] = true
			end
		end
	end

	if not next(targetFrames) then
		return
	end

	if moho.document:CountSelectedLayers() > 1 then
		moho.document:PrepMultiUndo(false)
		moho.document:SetDirty()
	else
		if #layersList == 1 then
			local layer = moho.document:LayerByAbsoluteID(layersList[1])
			if layer then
				moho.document:PrepUndo(layer, false)
				moho.document:SetDirty()
			else
				moho.document:PrepUndo(moho.layer, false)
				moho.document:SetDirty()
			end
		else
			moho.document:PrepUndo(moho.layer, false)
			moho.document:SetDirty()
		end
	end

	for _, layerIndex in ipairs(layersList) do
		local layer = moho.document:LayerByAbsoluteID(layerIndex)
		if layer then
			local vectorLayer = moho:LayerAsVector(layer)
			if vectorLayer then
				local timingOffset = layer:TotalTimingOffset()
				local mesh = vectorLayer:Mesh()

				for p = 0, mesh:CountPoints() - 1 do
					local point = mesh:Point(p)
					if (self.processSelectedPointsOnly and point.fSelected) or not self.processSelectedPointsOnly then
						local posChannel = moho:ChannelAsAnimVec2(point.fAnimPos)
						for k = 0, posChannel:CountKeys() - 1 do
							if k > 0 then
								local layerFrame = math.floor(posChannel:GetKeyWhen(k))
								local frame = math.floor(layerFrame - timingOffset)
								if targetFrames[frame] then
									local interp = MOHO.InterpSetting:new_local()
									posChannel:GetKeyInterp(layerFrame, interp)
									if isInterval then
										interp.interval = self.interval
									else
										if self.smooth then
											interp.interpMode = MOHO.INTERP_SMOOTH
										elseif self.linear then
											interp.interpMode = MOHO.INTERP_LINEAR
										elseif self.step then
											interp.interpMode = MOHO.INTERP_STEP
										elseif self.noisy then
											interp.interpMode = MOHO.INTERP_NOISY
										end
									end
									posChannel:SetKeyInterp(layerFrame, interp)
								end
							end
						end
						for j = 0, point:CountCurves() - 1 do
							local curve, ptPos = point:Curve(j, -1)
							local curvatureChannel = curve:Curvature(ptPos)
							for k = 0, curvatureChannel:CountKeys() - 1 do
								if k > 0 then
									local layerFrame = math.floor(curvatureChannel:GetKeyWhen(k))
									local frame = math.floor(layerFrame - timingOffset)
									if targetFrames[frame] then
										local interp = MOHO.InterpSetting:new_local()
										curvatureChannel:GetKeyInterp(layerFrame, interp)
										if isInterval then
											interp.interval = self.interval
										else
											if self.smooth then
												interp.interpMode = MOHO.INTERP_SMOOTH
											elseif self.linear then
												interp.interpMode = MOHO.INTERP_LINEAR
											elseif self.step then
												interp.interpMode = MOHO.INTERP_STEP
											elseif self.noisy then
												interp.interpMode = MOHO.INTERP_NOISY
											end
										end
										curvatureChannel:SetKeyInterp(layerFrame, interp)
									end
								end
							end
							local weightTrueChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, true)
							for k = 0, weightTrueChannel:CountKeys() - 1 do
								if k > 0 then
									local layerFrame = math.floor(weightTrueChannel:GetKeyWhen(k))
									local frame = math.floor(layerFrame - timingOffset)
									if targetFrames[frame] then
										local interp = MOHO.InterpSetting:new_local()
										weightTrueChannel:GetKeyInterp(layerFrame, interp)
										if isInterval then
											interp.interval = self.interval
										else
											if self.smooth then
												interp.interpMode = MOHO.INTERP_SMOOTH
											elseif self.linear then
												interp.interpMode = MOHO.INTERP_LINEAR
											elseif self.step then
												interp.interpMode = MOHO.INTERP_STEP
											elseif self.noisy then
												interp.interpMode = MOHO.INTERP_NOISY
											end
										end
										weightTrueChannel:SetKeyInterp(layerFrame, interp)
									end
								end
							end
							
							local weightFalseChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, false)
							for k = 0, weightFalseChannel:CountKeys() - 1 do
								if k > 0 then
									local layerFrame = math.floor(weightFalseChannel:GetKeyWhen(k))
									local frame = math.floor(layerFrame - timingOffset)
									if targetFrames[frame] then
										local interp = MOHO.InterpSetting:new_local()
										weightFalseChannel:GetKeyInterp(layerFrame, interp)
										if isInterval then
											interp.interval = self.interval
										else
											if self.smooth then
												interp.interpMode = MOHO.INTERP_SMOOTH
											elseif self.linear then
												interp.interpMode = MOHO.INTERP_LINEAR
											elseif self.step then
												interp.interpMode = MOHO.INTERP_STEP
											elseif self.noisy then
												interp.interpMode = MOHO.INTERP_NOISY
											end
										end
										weightFalseChannel:SetKeyInterp(layerFrame, interp)
									end
								end
							end
							
							local offsetTrueChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, true)
							for k = 0, offsetTrueChannel:CountKeys() - 1 do
								if k > 0 then
									local layerFrame = math.floor(offsetTrueChannel:GetKeyWhen(k))
									local frame = math.floor(layerFrame - timingOffset)
									if targetFrames[frame] then
										local interp = MOHO.InterpSetting:new_local()
										offsetTrueChannel:GetKeyInterp(layerFrame, interp)
										if isInterval then
											interp.interval = self.interval
										else
											if self.smooth then
												interp.interpMode = MOHO.INTERP_SMOOTH
											elseif self.linear then
												interp.interpMode = MOHO.INTERP_LINEAR
											elseif self.step then
												interp.interpMode = MOHO.INTERP_STEP
											elseif self.noisy then
												interp.interpMode = MOHO.INTERP_NOISY
											end
										end
										offsetTrueChannel:SetKeyInterp(layerFrame, interp)
									end
								end
							end
							
							local offsetFalseChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, false)
							for k = 0, offsetFalseChannel:CountKeys() - 1 do
								if k > 0 then
									local layerFrame = math.floor(offsetFalseChannel:GetKeyWhen(k))
									local frame = math.floor(layerFrame - timingOffset)
									if targetFrames[frame] then
										local interp = MOHO.InterpSetting:new_local()
										offsetFalseChannel:GetKeyInterp(layerFrame, interp)
										if isInterval then
											interp.interval = self.interval
										else
											if self.smooth then
												interp.interpMode = MOHO.INTERP_SMOOTH
											elseif self.linear then
												interp.interpMode = MOHO.INTERP_LINEAR
											elseif self.step then
												interp.interpMode = MOHO.INTERP_STEP
											elseif self.noisy then
												interp.interpMode = MOHO.INTERP_NOISY
											end
										end
										offsetFalseChannel:SetKeyInterp(layerFrame, interp)
									end
								end
							end
						end
					end
				end
			end
		end
	end

	moho.layer:UpdateCurFrame()
	moho:UpdateSelectedChannels()
	moho.view:DrawMe()
	moho:UpdateUI()

	helper:delete()	
end

function MR_AnimatePoints:GetSelection(moho, slot)
	local selectionList = {}
	local selectionLayersList = {}

	local layersList = self:ScanLayers(moho, true)
	for l, layerIndex in ipairs(layersList) do
		local layer = moho.document:LayerByAbsoluteID(layerIndex)
		if layer then
			local selectedPoints = false
			local vectorLayer = moho:LayerAsVector(layer)
			local mesh = vectorLayer:Mesh()
			local pointsSelectionList = {}
			for p = 0, mesh:CountPoints() - 1 do
				local point = mesh:Point(p)
				if point.fSelected then
					selectedPoints = true
					table.insert(pointsSelectionList, p)
				end
			end
			table.insert(selectionLayersList, layerIndex)
			table.insert(selectionList, pointsSelectionList)
		end
	end

	local keyValue = ''
	local tblLength = ''
	for i, tbl in ipairs(selectionList) do
		keyValue = keyValue..MR_Utilities:TableToString(tbl)
		local length = tostring(#tbl)
		tblLength = tblLength..#length..' '..length..','
	end

	local scriptInfo = moho.layer:ScriptData()
	local selectionKey = self.scriptDataName..'_Slot_'..slot
	local selectionLengthKey = self.scriptDataName..'_Slot_Length_'..slot
	local selectionLayersKey = self.scriptDataName..'_Slot_Layers_'..slot

	scriptInfo:Set(selectionKey, keyValue)
	scriptInfo:Set(selectionLengthKey, tblLength)

	local selectionLayers = MR_Utilities:TableToString(selectionLayersList)
	scriptInfo:Set(selectionLayersKey, selectionLayers)
end

function MR_AnimatePoints:SetSelection(moho, slot)
	local selectionList = {}

	local scriptInfo = moho.layer:ScriptData()
	local selectionKey = self.scriptDataName..'_Slot_'..slot
	local selectionLengthKey = self.scriptDataName..'_Slot_Length_'..slot
	local keyValue = ''
	local lengthValue = ''
	if scriptInfo:HasKey(selectionKey) then	
		keyValue = scriptInfo:GetString(selectionKey)
	end

	if scriptInfo:HasKey(selectionLengthKey) then
		lengthValue = scriptInfo:GetString(selectionLengthKey)
	end

	local lengthList = {}
	MR_Utilities:StringToTable(lengthValue, lengthList, 'n')
	
	local valuesList = {}
	MR_Utilities:StringToTable(keyValue, valuesList, 'n')
	
	local selectionList = {}
	MR_Utilities:DistributeValuesToTables(selectionList, valuesList, lengthList)
	
	local selectionLayers = ''
	local selectionLayersList = {}
	local selectionLayersKey = self.scriptDataName..'_Slot_Layers_'..slot
	if scriptInfo:HasKey(selectionLayersKey) then
		selectionLayers = scriptInfo:GetString(selectionLayersKey)
		MR_Utilities:StringToTable(selectionLayers, selectionLayersList, 'n')
	end

	for l, layerIndex in ipairs(selectionLayersList) do
		local layer = moho.document:LayerByAbsoluteID(layerIndex)
		if layer and selectionList[l] then
			local vectorLayer = moho:LayerAsVector(layer)
			if vectorLayer then
				local mesh = vectorLayer:Mesh()
				mesh:SelectNone()
				for _, pointIndex in ipairs(selectionList[l]) do
					if pointIndex < mesh:CountPoints() then
						local point = mesh:Point(pointIndex)
						if point then
							point.fSelected = true
						end
					end
				end
			end
		end
	end
	
	return selectionList
end

function MR_AnimatePoints:ApplyPosToRelativeKeys(moho, layer, channel, delta, keysList)
	local timingOffset = layer:TotalTimingOffset()
	for k = 0, channel:CountKeys() - 1 do
		if k > 0 then
			local layerFrame = math.floor(channel:GetKeyWhen(k))
			local frame = math.floor(layerFrame - timingOffset)
			if keysList[frame] and frame ~= moho.frame then
				local val = channel:GetValue(layerFrame)
				val = val - delta
				channel:SetValue(layerFrame, val)
			end
		end
	end
end

function MR_AnimatePoints:CreateKey(moho, direction, alt)
	local visibleLayersOnly = self.visibleLayersOnly
	self.visibleLayersOnly = self.visibleLayersOnlyKeyframing

	if moho.document:CountSelectedLayers() > 1 then
		moho.document:PrepMultiUndo(false)
	else
		moho.document:PrepUndo(moho.layer, false)
	end
	moho.document:SetDirty()
	local layersList = {}

	if next(self.isolatedLayerUUIDList) and self.processIsolatedLayersOnly then
		for i, layerUUID in pairs(self.isolatedLayerUUIDList) do
			local targetLayerIndex = tonumber(i)-1
			local layer = moho.document:LayerByAbsoluteID(targetLayerIndex)
			if layer then
				if layer:UUID() == layerUUID then
					if self:IsLayerValidForWarpMode(moho, layer) or not self.considerWarpMode then
						local isLayerOk = true
						if layer == moho.layer then
							isLayerOk = true
						elseif layer:IsWarpLayer() and self.warpMode then
							local layerSkeleton = layer:ControllingSkeleton()
							isLayerOk = MR_Utilities:IsLayerActive(moho, layer, layerSkeleton)
						elseif self.visibleLayersOnly then
							local layerSkeleton = layer:ControllingSkeleton()
							isLayerOk = MR_Utilities:IsLayerVisible(moho, layer, layerSkeleton, true)
						end
						if isLayerOk then
							table.insert(layersList, targetLayerIndex)
						end
					end
				end
			end
		end
	else
		layersList = self:ScanLayers(moho, self.considerWarpMode)
	end

	for l, layerIndex in ipairs(layersList) do
		local layer = moho.document:LayerByAbsoluteID(layerIndex)
		if layer then
			local vectorLayer = moho:LayerAsVector(layer)
			if vectorLayer then
				local layerFrame = layer:DocToLayerFrame(moho.frame)
				local mesh = vectorLayer:Mesh()
				if (layer:AnimDuration() > 0 or alt) then
					for i = 0, mesh:CountPoints() - 1 do
						local point = mesh:Point(i)
						if point then
							if (point.fSelected and self.processSelectedPointsOnly) or not self.processSelectedPointsOnly then
								local posChannel = moho:ChannelAsAnimVec2(point.fAnimPos)
								for j = 0, posChannel:CountKeys() - 1 do
									local frame = posChannel:GetKeyWhen(j)
									if frame > 0 or (posChannel:Duration() == 0 and alt) then
										local val = LM.Vector2:new_local()
										if direction == 0 then
											local curFrame = layerFrame
											local currentKeyID = posChannel:GetClosestKeyID(curFrame)
											local prewKey = currentKeyID

											if(posChannel:HasKey(curFrame)) then
												prewKey = currentKeyID - 1
											end

											local prewFrame = posChannel:GetKeyWhen(prewKey)

											val:Set(posChannel:GetValue(prewFrame))
										elseif direction == 1 then
											val = posChannel:GetValue(layerFrame)
										elseif direction == 2 then
											local curFrame = layerFrame
											local currentKeyID = posChannel:GetClosestKeyID(curFrame)
											local nextKey = currentKeyID
											
											nextKey = currentKeyID + 1
											
											local nextFrame = curFrame
											if nextKey < posChannel:CountKeys() then
												nextFrame = posChannel:GetKeyWhen(nextKey)
											end

											val:Set(posChannel:GetValue(nextFrame))
										end
										posChannel:SetValue(layerFrame, val)
									end
								end
								for j = 0, point:CountCurves() - 1 do
									local curve, ptPos = point:Curve(j, -1)
									local curvatureChannel = curve:Curvature(ptPos)
									for k = 0, curvatureChannel:CountKeys() - 1 do
										local frame = curvatureChannel:GetKeyWhen(k)
										if frame > 0 or (curvatureChannel:Duration() == 0 and alt) then
											local val = 0
											if direction == 0 then
												local curFrame = layerFrame
												local currentKeyID = curvatureChannel:GetClosestKeyID(curFrame)
												local prewKey = currentKeyID

												if(curvatureChannel:HasKey(curFrame)) then
													prewKey = currentKeyID - 1
												end

												local prewFrame = curvatureChannel:GetKeyWhen(prewKey)

												val = curvatureChannel:GetValue(prewFrame)
											elseif direction == 1 then
												val = curvatureChannel:GetValue(layerFrame)
											elseif direction == 2 then
												local curFrame = layerFrame
												local currentKeyID = curvatureChannel:GetClosestKeyID(curFrame)
												local nextKey = currentKeyID
												
												if(curvatureChannel:HasKey(curFrame)) then
													nextKey = currentKeyID + 1
												end
												
												local nextFrame = curFrame

												if nextKey < curvatureChannel:CountKeys() then
													nextFrame = curvatureChannel:GetKeyWhen(nextKey)
												end

												val = curvatureChannel:GetValue(nextFrame)
											end
											curve:SetCurvature(ptPos, val, layerFrame)
										end
									end

									local offsetTrueChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, true)
									for k = 0, offsetTrueChannel:CountKeys() - 1 do
										local frame = offsetTrueChannel:GetKeyWhen(k)
										if frame > 0 or (offsetTrueChannel:Duration() == 0 and alt) then
											local val = 0
											if direction == 0 then
												local curFrame = layerFrame
												local currentKeyID = offsetTrueChannel:GetClosestKeyID(curFrame)
												local prewKey = currentKeyID

												if(offsetTrueChannel:HasKey(curFrame)) then
													prewKey = currentKeyID - 1
												end

												local prewFrame = offsetTrueChannel:GetKeyWhen(prewKey)

												val = offsetTrueChannel:GetValue(prewFrame)
											elseif direction == 1 then
												val = offsetTrueChannel:GetValue(layerFrame)
											elseif direction == 2 then
												local curFrame = layerFrame
												local currentKeyID = offsetTrueChannel:GetClosestKeyID(curFrame)
												local nextKey = currentKeyID
												
												if(offsetTrueChannel:HasKey(curFrame)) then
													nextKey = currentKeyID + 1
												end
												
												local nextFrame = curFrame

												if nextKey < offsetTrueChannel:CountKeys() then
													nextFrame = offsetTrueChannel:GetKeyWhen(nextKey)
												end

												val = offsetTrueChannel:GetValue(nextFrame)
											end
											offsetTrueChannel:SetValue(layerFrame, val)
										end
									end
									
									local offsetFalseChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, false)
									for k = 0, offsetFalseChannel:CountKeys() - 1 do
										local frame = offsetFalseChannel:GetKeyWhen(k)
										if frame > 0 or (offsetFalseChannel:Duration() == 0 and alt) then
											local val = 0
											if direction == 0 then
												local curFrame = layerFrame
												local currentKeyID = offsetFalseChannel:GetClosestKeyID(curFrame)
												local prewKey = currentKeyID

												if(offsetFalseChannel:HasKey(curFrame)) then
													prewKey = currentKeyID - 1
												end

												local prewFrame = offsetFalseChannel:GetKeyWhen(prewKey)

												val = offsetFalseChannel:GetValue(prewFrame)
											elseif direction == 1 then
												val = offsetFalseChannel:GetValue(layerFrame)
											elseif direction == 2 then
												local curFrame = layerFrame
												local currentKeyID = offsetFalseChannel:GetClosestKeyID(curFrame)
												local nextKey = currentKeyID
												
												if(offsetFalseChannel:HasKey(curFrame)) then
													nextKey = currentKeyID + 1
												end
												
												local nextFrame = curFrame

												if nextKey < offsetFalseChannel:CountKeys() then
													nextFrame = offsetFalseChannel:GetKeyWhen(nextKey)
												end

												val = offsetFalseChannel:GetValue(nextFrame)
											end
											offsetFalseChannel:SetValue(layerFrame, val)
										end
									end
									
									local weightTrueChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, true)
									for k = 0, weightTrueChannel:CountKeys() - 1 do
										local frame = weightTrueChannel:GetKeyWhen(k)
										if frame > 0 or (weightTrueChannel:Duration() == 0 and alt) then
											local val = 0
											if direction == 0 then
												local curFrame = layerFrame
												local currentKeyID = weightTrueChannel:GetClosestKeyID(curFrame)
												local prewKey = currentKeyID

												if(weightTrueChannel:HasKey(curFrame)) then
													prewKey = currentKeyID - 1
												end

												local prewFrame = weightTrueChannel:GetKeyWhen(prewKey)

												val = weightTrueChannel:GetValue(prewFrame)
											elseif direction == 1 then
												val = weightTrueChannel:GetValue(layerFrame)
											elseif direction == 2 then
												local curFrame = layerFrame
												local currentKeyID = weightTrueChannel:GetClosestKeyID(curFrame)
												local nextKey = currentKeyID
												
												if(weightTrueChannel:HasKey(curFrame)) then
													nextKey = currentKeyID + 1
												end
												
												local nextFrame = curFrame

												if nextKey < weightTrueChannel:CountKeys() then
													nextFrame = weightTrueChannel:GetKeyWhen(nextKey)
												end

												val = weightTrueChannel:GetValue(nextFrame)
											end
											weightTrueChannel:SetValue(layerFrame, val)
										end
									end
									
									local weightFalseChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, false)
									for k = 0, weightFalseChannel:CountKeys() - 1 do
										local frame = weightFalseChannel:GetKeyWhen(k)
										if frame > 0 or (weightFalseChannel:Duration() == 0 and alt) then
											local val = 0
											if direction == 0 then
												local curFrame = layerFrame
												local currentKeyID = weightFalseChannel:GetClosestKeyID(curFrame)
												local prewKey = currentKeyID

												if(weightFalseChannel:HasKey(curFrame)) then
													prewKey = currentKeyID - 1
												end

												local prewFrame = weightFalseChannel:GetKeyWhen(prewKey)

												val = weightFalseChannel:GetValue(prewFrame)
											elseif direction == 1 then
												val = weightFalseChannel:GetValue(layerFrame)
											elseif direction == 2 then
												local curFrame = layerFrame
												local currentKeyID = weightFalseChannel:GetClosestKeyID(curFrame)
												local nextKey = currentKeyID
												
												if(weightFalseChannel:HasKey(curFrame)) then
													nextKey = currentKeyID + 1
												end
												
												local nextFrame = curFrame

												if nextKey < weightFalseChannel:CountKeys() then
													nextFrame = weightFalseChannel:GetKeyWhen(nextKey)
												end

												val = weightFalseChannel:GetValue(nextFrame)
											end
											weightFalseChannel:SetValue(layerFrame, val)
										end
									end
								end
							end
						end
					end
				end
			end
		end
	end

	local markersChannel = moho:ChannelAsAnimString(moho.layer.fTimelineMarkers)
	if markersChannel:CountKeys() > 1 then
		self:KeyframesToMarkers(moho)
	end

	for l = 0, moho.document:CountSelectedLayers()-1 do
		local layer = moho.document:GetSelectedLayer(l)
		layer:UpdateCurFrame()
	end
	self.visibleLayersOnly = visibleLayersOnly
	moho.view:DrawMe()
	moho:UpdateUI()
	moho:UpdateSelectedChannels()
end

function MR_AnimatePoints:TestForClosestHandle(moho, mouseEvent, testOnly)
	self.layersList = {}
	self.selList = {}
	self.curvatureLayerList = {}
	self.bezierHandleList = {}

	self.curvatureStartList = {}
	self.offsetTrueStartList = {}
	self.offsetFalseStartList = {}
	self.weightTrueStartList = {}
	self.weightFalseStartList = {}

	self.startOffsetList = {}
	self.weightDeltaList = {}
	self.weightMultiplierList = {}
	self.flipDirectionList = {}

	self.weightStartDeltaList = {}

	local layersList = {}
	if next(self.isolatedLayerUUIDList) then
		for i, layerUUID in pairs(self.isolatedLayerUUIDList) do
			local targetLayerIndex = tonumber(i)-1
			local layer = moho.document:LayerByAbsoluteID(targetLayerIndex)
			if layer then
				if layer:UUID() == layerUUID then
					if self:IsLayerValidForWarpMode(moho, layer) then
						local isLayerOk = true
						if layer == moho.layer then
							isLayerOk = true
						elseif layer:IsWarpLayer() and self.warpMode then
							local layerSkeleton = layer:ControllingSkeleton()
							isLayerOk = MR_Utilities:IsLayerActive(moho, layer, layerSkeleton)
						elseif self.visibleLayersOnly then
							local layerSkeleton = layer:ControllingSkeleton()
							isLayerOk = MR_Utilities:IsLayerVisible(moho, layer, layerSkeleton, true)
						end
						if isLayerOk then
							table.insert(layersList, targetLayerIndex)
						end
					end
				end
			end
		end
	else
		layersList = self:ScanLayers(moho, true)
	end

	for l, layerIndex in ipairs(layersList) do
		local layer = moho.document:LayerByAbsoluteID(layerIndex)
		local vectorLayer = moho:LayerAsVector(layer)
		local mesh = vectorLayer:Mesh()
		local layerFrame = layer:DocToLayerFrame(moho.frame)

		local selID = -1
		local handleSide = 0
		local startHandle = LM.Vector2:new_local()
		local handleCurveID = -1
		local handlePointID = -1

		local layerCurvatureList = {}
		local g = mouseEvent.view:Graphics()
		local layerMatrix = LM.Matrix:new_local()
		layer:GetFullTransform(moho.frame, layerMatrix, moho.document)
		g:Push()
		g:ApplyMatrix(layerMatrix)

		local minDistance = 12
		local pt = LM.Point:new_local()

		for i = 0, mesh:CountCurves() - 1 do
			local curve = mesh:Curve(i)
			for j = 0, curve:CountPoints() - 1 do
				if (not curve:Point(j).fHidden) and (curve:Point(j).fSelected) then
					if self.smartBake and not MOHO.MohoGlobals.EditMultipleKeys then
						local pointCurvatureList = {}
						pointCurvatureList.baked = false
						table.insert(layerCurvatureList, pointCurvatureList)
					end

					if (math.abs(curve:GetCurvature(j, layerFrame)) > MOHO.PEAKED + 0.0001) then
						local testHandle = curve:GetControlHandle(j, layerFrame, true)
						mouseEvent.view:Graphics():WorldToScreen(testHandle, pt)
						if (not(j == 0 and not curve.fClosed)) then
							local distance = math.sqrt((pt.x - mouseEvent.pt.x) * (pt.x - mouseEvent.pt.x) + (pt.y - mouseEvent.pt.y) * (pt.y - mouseEvent.pt.y))
							if (distance < minDistance) then
								minDistance = distance
								selID = mesh:PointID(curve:Point(j))
								startHandle = testHandle
								handleSide = -1
								handleCurveID = i
								handlePointID = j
							end
						end

						testHandle = curve:GetControlHandle(j, layerFrame, false)
						mouseEvent.view:Graphics():WorldToScreen(testHandle, pt)
						if (not(j == curve:CountPoints() - 1 and not curve.fClosed)) then
							local distance = math.sqrt((pt.x - mouseEvent.pt.x) * (pt.x - mouseEvent.pt.x) + (pt.y - mouseEvent.pt.y) * (pt.y - mouseEvent.pt.y))
							if (distance < minDistance) then
								minDistance = distance
								selID = mesh:PointID(curve:Point(j))
								startHandle = testHandle
								handleSide = 1
								handleCurveID = i
								handlePointID = j
							end
						end
					end
				end
			end
		end

		if selID > -1 then
			local curve = mesh:Curve(handleCurveID)
			local curvatureChannel = curve:Curvature(handlePointID)
			local offsetTrueChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, handlePointID, true)
			local offsetFalseChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, handlePointID, false)
			local weightTrueChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, handlePointID, true)
			local weightFalseChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, handlePointID, false)

			local curvaturePointStartList = {}
			local offsetTruePointStartList = {}
			local offsetFalsePointStartList = {}
			local weightTruePointStartList = {}
			local weightFalsePointStartList = {}

			local curvatureCurveStartList = {}
			local offsetTrueCurveStartList = {}
			local offsetFalseCurveStartList = {}
			local weightTrueCurveStartList = {}
			local weightFalseCurveStartList = {}

			local point = mesh:Point(selID)
			for j = 0, point:CountCurves() - 1 do
				local curve, ptPos = point:Curve(j, -1)
				local curvatureChannel = curve:Curvature(ptPos)
				local offsetTrueChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, true)
				local offsetFalseChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, false)
				local weightTrueChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, true)
				local weightFalseChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, false)

				table.insert(curvatureCurveStartList, curvatureChannel:GetValue(layerFrame))
				table.insert(offsetTrueCurveStartList, offsetTrueChannel:GetValue(layerFrame))
				table.insert(offsetFalseCurveStartList, offsetFalseChannel:GetValue(layerFrame))
				table.insert(weightTrueCurveStartList, weightTrueChannel:GetValue(layerFrame))
				table.insert(weightFalseCurveStartList, weightFalseChannel:GetValue(layerFrame))
			end

			table.insert(curvaturePointStartList, curvatureCurveStartList)
			table.insert(offsetTruePointStartList, offsetTrueCurveStartList)
			table.insert(offsetFalsePointStartList, offsetFalseCurveStartList)
			table.insert(weightTruePointStartList, weightTrueCurveStartList)
			table.insert(weightFalsePointStartList, weightFalseCurveStartList)

			local curvatureValue = curvatureChannel:GetValue(layerFrame)
			local offsetTrueValue = offsetTrueChannel:GetValue(layerFrame)
			local offsetFalseValue = offsetFalseChannel:GetValue(layerFrame)
			local weightTrueValue = weightTrueChannel:GetValue(layerFrame)
			local weightFalseValue = weightFalseChannel:GetValue(layerFrame)

			table.insert(self.curvatureStartList, curvaturePointStartList)
			table.insert(self.offsetTrueStartList, offsetTruePointStartList)
			table.insert(self.offsetFalseStartList, offsetFalsePointStartList)
			table.insert(self.weightTrueStartList, weightTruePointStartList)
			table.insert(self.weightFalseStartList, weightFalsePointStartList)

			table.insert(self.layersList, moho.document:LayerAbsoluteID(layer))
			table.insert(self.curvatureLayerList, layerCurvatureList)
			table.insert(self.selList, selID)
			table.insert(self.bezierHandleList, {handleCurveID = handleCurveID, handlePointID = handlePointID, handleSide = handleSide, startHandle = startHandle})

			local startOffset = curve:GetOffset(handlePointID, layerFrame, (handleSide == -1))
			table.insert(self.startOffsetList, startOffset)

			if handleSide == -1 then
				local weightDelta = weightTrueChannel.value - weightTrueChannel:GetValue(moho.layerFrame)
				table.insert(self.weightDeltaList, weightDelta)
			else
				local weightDelta = weightFalseChannel.value - weightFalseChannel:GetValue(moho.layerFrame)
				table.insert(self.weightDeltaList, weightDelta)
			end

			local keyLength
			local resultLength
			local pp = handlePointID + handleSide
			if mesh:Curve(handleCurveID).fClosed then
				if pp < 0 then pp = mesh:Curve(handleCurveID):CountPoints()-1 end
				if pp >= mesh:Curve(handleCurveID):CountPoints() then pp = 0  end
			else
				if pp < 0 then pp = 0 end
				if pp >= mesh:Curve(handleCurveID):CountPoints() then pp = mesh:Curve(handleCurveID):CountPoints()-1 end
			end

			local lengthMultiply
			if(pp == handlePointID) then
				lengthMultiply = 1
				keyLength = 0.00001
				resultLength = 0.00001
			else
				keyLength = (mesh:Curve(handleCurveID):Point(pp).fAnimPos:GetValue(layerFrame) - mesh:Curve(handleCurveID):Point(handlePointID).fAnimPos:GetValue(layerFrame)):Mag()
				resultLength = (mesh:Curve(handleCurveID):Point(pp).fPos - mesh:Curve(handleCurveID):Point(handlePointID).fPos):Mag()
				lengthMultiply = resultLength/keyLength
			end

			local channelNumberBase = 0
			for p=0, mesh:PointID(mesh:Curve(handleCurveID):Point(handlePointID))-1 do
				local nextPoint = mesh:Point(p)
				channelNumberBase = channelNumberBase + nextPoint:CountCurves()*5
			end

			local weightChannel = moho:ChannelAsAnimVal(layer:Channel(3,channelNumberBase+1+handleSide/2+0.5, moho.document))
			local curvatureDelta = AE_Utilities:SumActionInfluences(moho, layerFrame, moho:ChannelAsAnimVal(curvatureChannel), layer)
			local weightDelta = weightChannel.value - weightChannel:GetValue(layerFrame)
			local weightMultiplier = resultLength * (mesh:Curve(handleCurveID):GetCurvature(handlePointID, layerFrame) + curvatureDelta)

			table.insert(self.weightDeltaList, weightDelta)
			table.insert(self.weightMultiplierList, weightMultiplier)

			table.insert(self.flipDirectionList, MR_Utilities:CheckFlipDirection(moho, layer, point))

			local vec = mouseEvent.vec
			local startVec = mouseEvent.startVec

			if layer ~= moho.layer then
				vec = MR_Utilities:GetGlobalPos(moho, moho.layer, vec, false)
				vec = MR_Utilities:GetLocalPos(moho, layer, vec, false)

				startVec = MR_Utilities:GetGlobalPos(moho, moho.layer, startVec, false)
				startVec = MR_Utilities:GetLocalPos(moho, layer, startVec, false)
			end

			local handlePt = startHandle + (vec - startVec)
			local newVector = handlePt - point.fPos

			local oldWeight = curve:GetWeight(handlePointID, layerFrame, (handleSide == -1))
			local newWeight = newVector:Mag()/weightMultiplier - weightDelta
			local weightStartDelta = newWeight - oldWeight
			table.insert(self.weightStartDeltaList, weightStartDelta)
		end

		g:Pop()
	end
	if testOnly then
		if self.bezierHandleList[1] then
			return self.bezierHandleList[1].handleSide
		else
			return -2
		end
	else
		return next(self.layersList)
	end
end

function MR_AnimatePoints:PasteFrame(moho, alt)
	if not self.copiedFrame then
		return
	end

	local visibleLayersOnly = self.visibleLayersOnly
	self.visibleLayersOnly = self.visibleLayersOnlyKeyframing

	if moho.document:CountSelectedLayers() > 1 then
		moho.document:PrepMultiUndo(false)
	else
		moho.document:PrepUndo(moho.layer, false)
	end
	moho.document:SetDirty()
	local layersList = {}

	if next(self.isolatedLayerUUIDList) and self.processIsolatedLayersOnly then
		for i, layerUUID in pairs(self.isolatedLayerUUIDList) do
			local targetLayerIndex = tonumber(i)-1
			local layer = moho.document:LayerByAbsoluteID(targetLayerIndex)
			if layer then
				if layer:UUID() == layerUUID then
					if self:IsLayerValidForWarpMode(moho, layer) or not self.considerWarpMode then
						local isLayerOk = true
						if layer == moho.layer then
							isLayerOk = true
						elseif layer:IsWarpLayer() and self.warpMode then
							local layerSkeleton = layer:ControllingSkeleton()
							isLayerOk = MR_Utilities:IsLayerActive(moho, layer, layerSkeleton)
						elseif self.visibleLayersOnly then
							local layerSkeleton = layer:ControllingSkeleton()
							isLayerOk = MR_Utilities:IsLayerVisible(moho, layer, layerSkeleton, true)
						end
						if isLayerOk then
							table.insert(layersList, targetLayerIndex)
						end
					end
				end
			end
		end
	else
		layersList = self:ScanLayers(moho, self.considerWarpMode)
	end

	for l, layerIndex in ipairs(layersList) do
		local layer = moho.document:LayerByAbsoluteID(layerIndex)
		if layer then
			local vectorLayer = moho:LayerAsVector(layer)
			if vectorLayer then
				local layerFrame = layer:DocToLayerFrame(moho.frame)
				local mesh = vectorLayer:Mesh()
				if layer:AnimDuration() > 0 or alt then
					local copiedFrame = layer:DocToLayerFrame(self.copiedFrame)
					for i = 0, mesh:CountPoints() - 1 do
						local point = mesh:Point(i)
						if point then
							if (point.fSelected and self.processSelectedPointsOnly) or not self.processSelectedPointsOnly then
								local posChannel = moho:ChannelAsAnimVec2(point.fAnimPos)
								if moho.frame > 0 and layerFrame > 0 and ((posChannel:Duration() > 0 and not alt) or alt) then
									local val = posChannel:GetValue(copiedFrame)
									posChannel:SetValue(layerFrame, val)
								end
								for j = 0, point:CountCurves() - 1 do
									local curve, ptPos = point:Curve(j, -1)
									local curvatureChannel = curve:Curvature(ptPos)
									if moho.frame > 0 and layerFrame > 0 and ((curvatureChannel:Duration() > 0 and not alt) or alt) then
										local val = curvatureChannel:GetValue(copiedFrame)
										curvatureChannel:SetValue(layerFrame, val)
									end

									local offsetTrueChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, true)
									if moho.frame > 0 and layerFrame > 0 and ((offsetTrueChannel:Duration() > 0 and not alt) or alt) then
										local val = offsetTrueChannel:GetValue(copiedFrame)
										offsetTrueChannel:SetValue(layerFrame, val)
									end

									local offsetFalseChannel = MR_Utilities:GetOffsetChannel(moho, layer, curve, ptPos, false)
									if moho.frame > 0 and layerFrame > 0 and ((offsetFalseChannel:Duration() > 0 and not alt) or alt) then
										local val = offsetFalseChannel:GetValue(copiedFrame)
										offsetFalseChannel:SetValue(layerFrame, val)
									end

									local weightTrueChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, true)
									if moho.frame > 0 and layerFrame > 0 and ((weightTrueChannel:Duration() > 0 and not alt) or alt) then
										local val = weightTrueChannel:GetValue(copiedFrame)
										weightTrueChannel:SetValue(layerFrame, val)
									end
									
									local weightFalseChannel = MR_Utilities:GetWeightChannel(moho, layer, curve, ptPos, false)
									if moho.frame > 0 and layerFrame > 0 and ((weightFalseChannel:Duration() > 0 and not alt) or alt) then
										local val = weightFalseChannel:GetValue(copiedFrame)
										weightFalseChannel:SetValue(layerFrame, val)
									end
								end
							end
						end
					end
				end
			end
		end
	end

	for l = 0, moho.document:CountSelectedLayers()-1 do
		local layer = moho.document:GetSelectedLayer(l)
		layer:UpdateCurFrame()
	end
	moho.view:DrawMe()
	moho:UpdateUI()

	local markersChannel = moho:ChannelAsAnimString(moho.layer.fTimelineMarkers)
	if markersChannel:CountKeys() > 1 then
		self:KeyframesToMarkers(moho)
	end
	self.visibleLayersOnly = visibleLayersOnly
	moho:UpdateSelectedChannels()
end

function MR_AnimatePoints:DrawToolSizeCircle(moho, view, centerVec, radius, fill)
	local g = view:Graphics()
	local matrix = LM.Matrix:new_local()

	moho.drawingLayer:GetFullTransform(moho.frame, matrix, moho.document)
	g:Push()
	g:ApplyMatrix(matrix)

	g:SetColor(self.guiColor)

	g:SetSmoothing(true)
	g:SetBezierTolerance(2)
	g:SetPenWidth(1)

	if (fill) then
		g:SetColor(self.guiColor.r, self.guiColor.g, self.guiColor.b, 128)
		g:FillCircle(centerVec, radius)
	else
		if (g:GPUMode()) then
			g:SetColor(255 - self.guiColor.r, 255 - self.guiColor.g, 255 - self.guiColor.b, 128)
			g:FrameCircle(centerVec, radius)
			g:SetColor(self.guiColor.r, self.guiColor.g, self.guiColor.b, 128)
			g:FrameCircle(centerVec, radius)
		else
			g:SetColor(self.guiColor.r, self.guiColor.g, self.guiColor.b, 255)
			g:FrameCircle(centerVec, radius)
			g:SetColor(255 - self.guiColor.r, 255 - self.guiColor.g, 255 - self.guiColor.b, 220)
			g:FrameCircle(centerVec, radius)
		end
	end

	g:SetSmoothing(false)

	g:Pop()
end

function MR_AnimatePoints:UpdateVectorList(moho, selectedOnly)
	self.vectorLayersList = {}

	if next(self.isolatedLayerUUIDList) then
		for i, layerUUID in pairs(self.isolatedLayerUUIDList) do
			local targetLayerIndex = tonumber(i)-1
			local layer = moho.document:LayerByAbsoluteID(targetLayerIndex)
			if layer then
				if layer:UUID() == layerUUID then
					if self:IsLayerValidForWarpMode(moho, layer) then
						local isLayerOk = true
						if layer == moho.layer then
							isLayerOk = true
						elseif layer:IsWarpLayer() and self.warpMode then
							local layerSkeleton = layer:ControllingSkeleton()
							isLayerOk = MR_Utilities:IsLayerActive(moho, layer, layerSkeleton)
						elseif self.visibleLayersOnly then
							local layerSkeleton = layer:ControllingSkeleton()
							isLayerOk = MR_Utilities:IsLayerVisible(moho, layer, layerSkeleton, true)
						end
						if isLayerOk then
							local isOk = false
								if selectedOnly then
								local vectorLayer = moho:LayerAsVector(layer)
								local mesh = vectorLayer:Mesh()
								for i = 0, mesh:CountPoints() - 1 do
									local pt = mesh:Point(i)
									if pt.fSelected then
										isOk = true
										break
									end
								end
							else
								isOk = true
							end
							if isOk then
								table.insert(self.vectorLayersList, moho.document:LayerAbsoluteID(layer))
							end
						end
					end
				end
			end
		end
	else
		self.vectorLayersList = self:ScanTransformBoxLayers(moho, selectedOnly)
	end

	self.selectedPointsCount = 0
	self.selectionBBox = LM.BBox:new_local()
	local m = LM.Matrix:new_local()
	if next(self.vectorLayersList) ~= nil then
		for i = 1, #self.vectorLayersList do
			local layer = moho.document:LayerByAbsoluteID(self.vectorLayersList[i])
			if layer ~= nil then
				local vectorLayer = moho:LayerAsVector(layer)
				if vectorLayer then
					layer:GetFullTransform(moho.frame, m, moho.document)
					local mesh = vectorLayer:Mesh()
					for p = 0, mesh:CountPoints() - 1 do
						local pt = mesh:Point(p)
						if pt.fSelected then
							self.selectedPointsCount = self.selectedPointsCount + 1

							local vec3 = LM.Vector3:new_local()
							vec3:Set(pt.fPos.x, pt.fPos.y, 0)
							m:Transform(vec3)
							self.selectionBBox:AccumulatePoint(vec3)
						end
					end
				end
			end
		end
	end

	if self.lastSelectedCount ~= self.selectedPointsCount then
		self.lastSelectedCount = self.selectedPointsCount
		self.pivotOffset:Set(0, 0)
		self.globalPivotOffset:Set(0, 0)
	end
end

function MR_AnimatePoints:ScanTransformBoxLayers(moho, selectedOnly)
	local layersList = {}
	local groupStack = {}

	for l = 0, moho.document:CountSelectedLayers()-1 do
		local layer = moho.document:GetSelectedLayer(l)
		if moho:LayerAsVector(layer) then
			self:ProcessTransformBoxVectorLayer(moho, layer, layersList)
		elseif layer:IsGroupType() then
			table.insert(groupStack, layer)
		end
	end

	while #groupStack > 0 do
		local currentGroup = table.remove(groupStack)
		local groupLayer = moho:LayerAsGroup(currentGroup)

		for i = 0, groupLayer:CountLayers()-1 do
			local layer = currentGroup:LayerByDepth(i)
			if layer:IsGroupType() then
				table.insert(groupStack, layer)
			elseif moho:LayerAsVector(layer) then
				self:ProcessTransformBoxVectorLayer(moho, layer, layersList, selectedOnly)
			end
		end
	end

	return layersList
end

function MR_AnimatePoints:ProcessTransformBoxVectorLayer(moho, layer, layersList, selectedOnly)
	local isLayerOk = true
	if layer == moho.layer then
		isLayerOk = true
	elseif layer:IsWarpLayer() and self.warpMode then
		local layerSkeleton = layer:ControllingSkeleton()
		isLayerOk = MR_Utilities:IsLayerActive(moho, layer, layerSkeleton)
	elseif self.visibleLayersOnly then
		local layerSkeleton = layer:ControllingSkeleton()
		isLayerOk = MR_Utilities:IsLayerVisible(moho, layer, layerSkeleton, true)
	end

	if isLayerOk and (layer:IsAncestorSelected() or layer == moho.layer or layer:SecondarySelection()) then
		if self:IsLayerValidForWarpMode(moho, layer) then
			if self.ignoreReferenceLayers and not layer:IsReferencedLayer() or not self.ignoreReferenceLayers then
				local isOk = true
				if selectedOnly then
					isOk = false
					local vectorLayer = moho:LayerAsVector(layer)
					local mesh = vectorLayer:Mesh()
					for i = 0, mesh:CountPoints() - 1 do
						local pt = mesh:Point(i)
						if pt.fSelected then
							isOk = true
							break
						end
					end
				end

				if isOk then
					table.insert(layersList, moho.document:LayerAbsoluteID(layer))
				end
			end
		end
	end
end

function MR_AnimatePoints:UpdateCenterVec(moho)
	self.bboxCener3d = LM.Vector3:new_local()
	self.bboxCener3d:Set(self.selectionBBox:Center())
end

function MR_AnimatePoints:BuildTransformBoxBounds(moho, frame, view)
	local bbox = LM.BBox:new_local()
	local vec = LM.Vector2:new_local()
	local m = LM.Matrix:new_local()

	for i = 1, #self.vectorLayersList do
		local layer = moho.document:LayerByAbsoluteID(self.vectorLayersList[i])
		if layer ~= nil then
			local vectorLayer = moho:LayerAsVector(layer)
			if vectorLayer then
				layer:GetFullTransform(moho.drawingFrame, m, moho.document)
				local mesh = vectorLayer:Mesh()
				for p = 0, mesh:CountPoints() - 1 do
					local pt = mesh:Point(p)
					if pt.fSelected then
						local vec = LM.Vector2:new_local()
						vec:Set(pt.fPos)
						m:Transform(vec)
						bbox:AccumulatePoint(vec)
					end
				end
			end
		end
	end

	local xLen = bbox.fMax.x - bbox.fMin.x
	local yLen = bbox.fMax.y - bbox.fMin.y
	local center
	if (xLen < yLen / 10.0) then
		center = (bbox.fMin.x + bbox.fMax.x) / 2.0
		bbox.fMin.x = center - yLen / 10.0
		bbox.fMax.x = center + yLen / 10.0
	elseif (yLen < xLen / 10.0) then
		center = (bbox.fMin.y + bbox.fMax.y) / 2.0
		bbox.fMin.y = center - xLen / 10.0
		bbox.fMax.y = center + xLen / 10.0
	end

	local minLength = 150
	local v = LM.Vector2:new_local()
	local pt1 = LM.Point:new_local()
	local pt2 = LM.Point:new_local()

	v:Set(bbox.fMin.x, bbox.fMin.y)
	view:Graphics():WorldToScreen(v, pt1)
	v:Set(bbox.fMax.x, bbox.fMax.y)
	view:Graphics():WorldToScreen(v, pt2)

	pt1 = pt2 - pt1
	local length = math.sqrt(pt1.x * pt1.x + pt1.y * pt1.y)
	self.bboxLength = length
	if length < minLength and length ~= 0 then
		center = (bbox.fMin + bbox.fMax) / 2.0
		v = bbox.fMax - center
		bbox.fMax = center + v * (minLength / length) / 2.0
		v = bbox.fMin - center
		bbox.fMin = center + v * (minLength / length) / 2.0
	end

	return bbox
end

function MR_AnimatePoints:OnMouseMovedTransformMode(moho, mouseEvent)
	if not self.transformBoxDragging then
		if os.clock() - self.updateTime > self.updateInterval then
			self:UpdateVectorList(moho, false)
			self:UpdateCenterVec(moho)
			self.updateTime = os.clock()
		end
		if self.selectedPointsCount >= 1 then
			self.mode = -2
			if self.bboxLength == 0 and self.showHandles then
				self.mode = self:TestForClosestHandle(moho, mouseEvent, true)
			end

			if self.mode == -2 then
				self.mode = self:TestMousePoint(moho, mouseEvent)
			else
				self.mode =100
			end

			local iconType = -1 -- -1 - selection, 0 - move, 1 - rotation, 2 - scale, 3 - crosshair, 4 - skew, 5 - distort

			if self.mode == 111 then
				iconType = 3
			elseif self.mode == 100 then
				iconType = 0
			elseif self.mode == 101 then
				iconType = 1
			elseif self.mode >= 102 and self.mode <= 109 then
				iconType = 2
			elseif self.mode >= 200 and self.mode <= 203 then
				iconType = 4
			elseif self.mode >= 204 and self.mode <= 207 then
				iconType = 5
			end

			if iconType == -1 then
				mouseEvent.view:SetCursor(self.mainCursor)
			elseif iconType == 0 then
				mouseEvent.view:SetCursor(MOHO.moveCursor)
			elseif iconType == 1 then
				mouseEvent.view:SetCursor(MOHO.rotateCursor)
			elseif iconType == 2 then
				mouseEvent.view:SetCursor(MOHO.scaleCursor)
			elseif iconType == 3 then
				mouseEvent.view:SetCursor(MOHO.crosshairCursor)
			elseif iconType == 4 then
				mouseEvent.view:SetCursor(self.skewCursor)
			elseif iconType == 5 then
				mouseEvent.view:SetCursor(self.distortCursor)
			end
		else
			mouseEvent.view:SetCursor(self.mainCursor)
		end
		mouseEvent.view:DrawMe()
	end

	if self.transformBoxDragging then
		if self.mode == 100 then
			self:OnMouseMovedTransformBoxMode_T(moho, mouseEvent)
		elseif self.mode == 101 then
			self:OnMouseMovedTransformBoxMode_R(moho, mouseEvent)
		elseif self.mode == 111 then
			self:OnMouseMovedTransformBoxPivotMode(moho, mouseEvent)
		elseif self.mode >= 102 and self.mode <= 109 then
			self:OnMouseMovedTransformBoxMode_S(moho, mouseEvent)
		elseif self.mode >= 200 and self.mode <= 203 then
			self:OnMouseMovedTransformBoxMode_SW(moho, mouseEvent)
		elseif self.mode >= 204 and self.mode <= 207 then
			self:OnMouseMovedTransformBoxMode_D(moho, mouseEvent)
		end
	end

	mouseEvent.view:DrawMe()
end

function MR_AnimatePoints:TestMousePoint(moho, mouseEvent)
	if (self.selectedPointsCount < 1) then
		return -1
	end

	local min = LM.Vector2:new_local()
	local max = LM.Vector2:new_local()

	local bbox = self:BuildTransformBoxBounds(moho, moho.frame, mouseEvent.view)

	min:Set(bbox.fMin.x, bbox.fMin.y)
	max:Set(bbox.fMax.x, bbox.fMax.y)

	local v = LM.Vector2:new_local()
	local pt = LM.Point:new_local()
	local m = LM.Matrix:new_local()

	if self.bboxLength == 0 then
		v:Set((min.x + max.x) / 2, (min.y + max.y) / 2)

		mouseEvent.view:Graphics():WorldToScreen(v, pt)
		if (math.abs(pt.x - mouseEvent.pt.x) < self.markerR and math.abs(pt.y - mouseEvent.pt.y) < self.markerR) then
			return 100
		else
			return -1
		end
	else
		if self.transformBoxExtraHandles then
			local rotWidth = bbox.fMax.x - bbox.fMin.x
			if (bbox.fMax.y - bbox.fMin.y > rotWidth) then
				rotWidth = bbox.fMax.y - bbox.fMin.y
			end
			rotWidth = rotWidth * 0.1

			-- test for X skew
			v:Set(bbox.fMin.x - rotWidth, (bbox.fMin.y + bbox.fMax.y) * 0.5)
			m:Transform(v)
			mouseEvent.view:Graphics():WorldToScreen(v, pt)
			if (math.abs(pt.x - mouseEvent.pt.x) < self.markerR and math.abs(pt.y - mouseEvent.pt.y) < self.markerR) then
				-- left
				return 200
			end
			v:Set(bbox.fMax.x + rotWidth, (bbox.fMin.y + bbox.fMax.y) * 0.5)
			m:Transform(v)
			mouseEvent.view:Graphics():WorldToScreen(v, pt)
			if (math.abs(pt.x - mouseEvent.pt.x) < self.markerR and math.abs(pt.y - mouseEvent.pt.y) < self.markerR) then
				-- right
				return 201
			end

			-- test for Y skew
			v:Set((bbox.fMin.x + bbox.fMax.x) * 0.5, bbox.fMin.y - rotWidth)
			m:Transform(v)
			mouseEvent.view:Graphics():WorldToScreen(v, pt)
			if (math.abs(pt.x - mouseEvent.pt.x) < self.markerR and math.abs(pt.y - mouseEvent.pt.y) < self.markerR) then
				-- bottom
				return 202
			end
			v:Set((bbox.fMin.x + bbox.fMax.x) * 0.5, bbox.fMax.y + rotWidth)
			m:Transform(v)
			mouseEvent.view:Graphics():WorldToScreen(v, pt)
			if (math.abs(pt.x - mouseEvent.pt.x) < self.markerR and math.abs(pt.y - mouseEvent.pt.y) < self.markerR) then
				-- top
				return 203
			end

			if self.selectedPointsCount >= 3 then
				-- test for Distord
				v:Set(bbox.fMin.x - rotWidth, bbox.fMin.y - rotWidth)
				m:Transform(v)
				mouseEvent.view:Graphics():WorldToScreen(v, pt)
				if (math.abs(pt.x - mouseEvent.pt.x) < self.markerR and math.abs(pt.y - mouseEvent.pt.y) < self.markerR) then
					-- bottom left
					return 204
				end
				v:Set(bbox.fMin.x - rotWidth, bbox.fMax.y + rotWidth)
				m:Transform(v)
				mouseEvent.view:Graphics():WorldToScreen(v, pt)
				if (math.abs(pt.x - mouseEvent.pt.x) < self.markerR and math.abs(pt.y - mouseEvent.pt.y) < self.markerR) then
					-- top left
					return 205
				end
				v:Set(bbox.fMax.x + rotWidth, bbox.fMax.y + rotWidth)
				m:Transform(v)
				mouseEvent.view:Graphics():WorldToScreen(v, pt)
				if (math.abs(pt.x - mouseEvent.pt.x) < self.markerR and math.abs(pt.y - mouseEvent.pt.y) < self.markerR) then
					-- top right
					return 206
				end
				v:Set(bbox.fMax.x + rotWidth, bbox.fMin.y - rotWidth)
				m:Transform(v)
				mouseEvent.view:Graphics():WorldToScreen(v, pt)
				if (math.abs(pt.x - mouseEvent.pt.x) < self.markerR and math.abs(pt.y - mouseEvent.pt.y) < self.markerR) then
					-- bottom right
					return 207
				end
			end
		end

		-- test for uniform scaling
		v:Set(bbox.fMin.x, bbox.fMin.y)
		mouseEvent.view:Graphics():WorldToScreen(v, pt)
		if (math.abs(pt.x - mouseEvent.pt.x) < self.markerR and math.abs(pt.y - mouseEvent.pt.y) < self.markerR) then
			-- bottom left
			return 104
		end
		v:Set(bbox.fMin.x, bbox.fMax.y)
		mouseEvent.view:Graphics():WorldToScreen(v, pt)
		if (math.abs(pt.x - mouseEvent.pt.x) < self.markerR and math.abs(pt.y - mouseEvent.pt.y) < self.markerR) then
			-- top left
			return 102
		end
		v:Set(bbox.fMax.x, bbox.fMax.y)
		mouseEvent.view:Graphics():WorldToScreen(v, pt)
		if (math.abs(pt.x - mouseEvent.pt.x) < self.markerR and math.abs(pt.y - mouseEvent.pt.y) < self.markerR) then
			-- top right
			return 103
		end
		v:Set(bbox.fMax.x, bbox.fMin.y)
		mouseEvent.view:Graphics():WorldToScreen(v, pt)
		if (math.abs(pt.x - mouseEvent.pt.x) < self.markerR and math.abs(pt.y - mouseEvent.pt.y) < self.markerR) then
			-- bottom right
			return 105
		end

		-- test for X scaling
		v:Set(bbox.fMin.x, (bbox.fMin.y + bbox.fMax.y) * 0.5)
		mouseEvent.view:Graphics():WorldToScreen(v, pt)
		if (math.abs(pt.x - mouseEvent.pt.x) < self.markerR and math.abs(pt.y - mouseEvent.pt.y) < self.markerR) then
			-- left
			return 106
		end
		v:Set(bbox.fMax.x, (bbox.fMin.y + bbox.fMax.y) * 0.5)
		mouseEvent.view:Graphics():WorldToScreen(v, pt)
		if (math.abs(pt.x - mouseEvent.pt.x) < self.markerR and math.abs(pt.y - mouseEvent.pt.y) < self.markerR) then
			-- right
			return 107
		end

		-- test for Y scaling
		v:Set((bbox.fMin.x + bbox.fMax.x) * 0.5, bbox.fMin.y)
		mouseEvent.view:Graphics():WorldToScreen(v, pt)
		if (math.abs(pt.x - mouseEvent.pt.x) < self.markerR and math.abs(pt.y - mouseEvent.pt.y) < self.markerR) then
			-- bottom
			return 109
		end
		v:Set((bbox.fMin.x + bbox.fMax.x) * 0.5, bbox.fMax.y)
		mouseEvent.view:Graphics():WorldToScreen(v, pt)
		if (math.abs(pt.x - mouseEvent.pt.x) < self.markerR and math.abs(pt.y - mouseEvent.pt.y) < self.markerR) then
			-- top
			return 108
		end

		-- test for pivot point
		if (self.dragging) then
			v:Set(self.centerVec)
		else
			v:Set((min.x + max.x) / 2, (min.y + max.y) / 2)
			v = v + self.pivotOffset
		end
		mouseEvent.view:Graphics():WorldToScreen(v, pt)
	
		if (math.abs(pt.x - mouseEvent.pt.x) < self.markerR and math.abs(pt.y - mouseEvent.pt.y) < self.markerR) then
			-- pivot point
			return 111
		end

		local vecPos = LM.Vector2:new_local()
		local startVecPos = LM.Vector2:new_local()
		startVecPos:Set(mouseEvent.startVec)
		vecPos:Set(mouseEvent.vec)
		vecPos = MR_Utilities:GetGlobalPos(moho, moho.layer, vecPos, true)
		startVecPos = MR_Utilities:GetGlobalPos(moho, moho.layer, startVecPos, true)

		-- test for click outside the bounding box
		local rotWidth = bbox.fMax.x - bbox.fMin.x
		if (bbox.fMax.y - bbox.fMin.y > rotWidth) then
			rotWidth = bbox.fMax.y - bbox.fMin.y
		end
		rotWidth = rotWidth * 0.1
		if (vecPos.x < bbox.fMin.x - rotWidth or vecPos.x > bbox.fMax.x + rotWidth or vecPos.y < bbox.fMin.y - rotWidth or vecPos.y > bbox.fMax.y + rotWidth) then
			return -1
		end

		-- test for rotation
		if (vecPos.x < bbox.fMin.x or vecPos.x > bbox.fMax.x or vecPos.y < bbox.fMin.y or vecPos.y > bbox.fMax.y) then
			return 101
		end

		return 100
	end
end

function MR_AnimatePoints:DrawPoints(moho, view, g)
	g:SetSmoothing(true)
	local radius = 18

	if self.vectorLayersList then
		for i, layerIndex in pairs(self.vectorLayersList) do
			local layer = moho.document:LayerByAbsoluteID(layerIndex)
			if layer then
				local layerFrame = layer:DocToLayerFrame(moho.frame)
				local vectorLayer = moho:LayerAsVector(layer)
				if vectorLayer and (self.ignoreReferenceLayers and not layer:IsReferencedLayer() or not self.ignoreReferenceLayers) then
					local mesh = vectorLayer:Mesh()
					local mouseVec = LM.Vector2:new_local()
					mouseVec:Set(self.dragVec)

					local layerColorChanged = false

					local opacityMultiplier = 1
					local selectedRadiusMultiplier = self.selectedPointM
					radius = 18
					if self.warpMode and vectorLayer:IsCurver() then
						selectedRadiusMultiplier = self.selectedCurverM
						opacityMultiplier = self.warpOpacity
						radius = 28
					elseif self.warpMode and vectorLayer:IsWarpLayer() then
						selectedRadiusMultiplier = self.selectedWarpM
						opacityMultiplier = self.warpOpacity
						radius = 19
					else
						opacityMultiplier = self.pointsOpacity
					end

					local col = LM.rgb_color:new_local()
					for i = 0, mesh:CountPoints() - 1 do
						local pt = mesh:Point(i)
						if not pt.fHidden and (pt.fSelected or self.warpMode) then
							if not layerColorChanged or self.selectPoints then
								if self.useSingleColor then
									col.r = math.floor(self.pointsColorR)
									col.g = math.floor(self.pointsColorG)
									col.b = math.floor(self.pointsColorB)
									col.a = math.floor(self.pointsColorA)
								else
									local idx = (math.floor(layerIndex) % 20) + 1
									col = self["color"..idx]
								end
								layerColorChanged = true
							end

							if col then
								if self.ctrlPressed then
									if self.selectPoints and not pt.fSelected then
										g:SetColor(col.r, col.g, col.b, self.deselectedPointsAlpha * opacityMultiplier)
									else
										g:SetColor(col.r, col.g, col.b, 255 * opacityMultiplier)
									end
								else
									if not pt.fSelected then
										g:SetColor(col.r, col.g, col.b, self.deselectedPointsAlpha * opacityMultiplier)
									else
										g:SetColor(col.r, col.g, col.b, 255 * opacityMultiplier)
									end
								end
							end

							local v1 = LM.Vector2:new_local()
							v1:Set(pt.fPos)
							v1 = MR_Utilities:GetGlobalPos(moho, layer, v1, true)
							if self.warpMode then
								if pt.fSelected then
									g:FillCirclePixelRadius(v1, (radius * selectedRadiusMultiplier) * self.pointsSize)
								else
									g:FillCirclePixelRadius(v1, (radius * self.nonSelectedM) * self.pointsSize)
								end
							elseif pt.fSelected then
								g:FillCirclePixelRadius(v1, (radius * selectedRadiusMultiplier) * self.pointsSize)
							end
						end
					end
					if self.warpMode then
						self:DrawCurve(moho, mouseEvent, layer, g, mesh, col, opacityMultiplier)
					end
				end
			end
		end
	end
end

function MR_AnimatePoints:PrepareHandles(moho)
	local radius = 18
	if self.vectorLayersList then
		for i, layerIndex in pairs(self.vectorLayersList) do
			local layer = moho.document:LayerByAbsoluteID(layerIndex)
			if layer then
				local layerFrame = layer:DocToLayerFrame(moho.frame)
				local vectorLayer = moho:LayerAsVector(layer)
				if vectorLayer and (self.ignoreReferenceLayers and not layer:IsReferencedLayer() or not self.ignoreReferenceLayers) then
					local mesh = vectorLayer:Mesh()
					local mouseVec = LM.Vector2:new_local()
					mouseVec:Set(self.dragVec)

					local layerColorChanged = false

					local pointPosList = {}
					pointPosList.handleTrue = {}
					pointPosList.handleFalse = {}
					pointPosList.point = {}

					local col = LM.ColorVector:new_local()
					for i = 0, mesh:CountPoints() - 1 do
						local pt = mesh:Point(i)
						if not pt.fHidden then
							if self.showHandles then
								if pt.fSelected then
									if not self.dragging then
										for j = 0, pt:CountCurves() - 1 do
											local curve, ptPos = pt:Curve(j, -1)

											local handlePosTrue = curve:GetControlHandle(ptPos, layerFrame, true)
											local handlePosFalse = curve:GetControlHandle(ptPos, layerFrame, false)
											local pointPos = MR_Utilities:GetGlobalPos(moho, layer, pt.fPos, true)
											if curve:GetCurvature(ptPos, layerFrame) == 0 then
												table.insert(pointPosList.handleTrue, pointPos)
												table.insert(pointPosList.handleFalse, pointPos)
											else
												table.insert(pointPosList.handleTrue, MR_Utilities:GetGlobalPos(moho, layer, handlePosTrue, true))
												table.insert(pointPosList.handleFalse, MR_Utilities:GetGlobalPos(moho, layer, handlePosFalse, true))
											end
											table.insert(pointPosList.point, pointPos)
										end
										table.insert(self.handleList, pointPosList)
									end
								end
							end
						end
					end
				end
			end
		end
	end
end

function MR_AnimatePoints:OnMouseDownTransformMode(moho, mouseEvent)
	self.mode = -1
	self.transformModeMoved = false
	self.transformPointsActive = false
	self.handleSide = 0

	self.mode = self:TestMousePoint(moho, mouseEvent)

	if self.mode > -1 then
		self:OnMouseDownTransformBoxMode(moho, mouseEvent)

		mouseEvent.view:DrawMe()
		moho:UpdateSelectedChannels()
		return
	end

	mouseEvent.view:DrawMe()
	moho:UpdateSelectedChannels()
	if self.hideCurvesWhileDragging then
		moho.view:SetQualityFlags(self.currentQualityFlags)
	end
	return
end

function MR_AnimatePoints:OnMouseDownTransformBoxMode(moho, mouseEvent)
	self.selList = {}
	self.posList = {}
	self.bezierList = {}
	self.flipDirectionList = {}
	self.clusterList = {}
	self.startPosList = {}
	self.bakedLayersList = {}

	self:UpdateVectorList(moho, true)

	if self.mode >= 100 and self.mode <= 207 and self.mode ~= 111 then
		self.transformBoxActive = true
		self.transformBoxDragging = true

		self.inProgressIcon = true
		moho.view:DrawMe()
		local layersCount = 0
		local firstLayer = -1
		local layersList = {}

		for i = 1, #self.vectorLayersList do
			local layer = moho.document:LayerByAbsoluteID(self.vectorLayersList[i])
			if layer ~= nil then
				local vectorLayer = moho:LayerAsVector(layer)
				if vectorLayer then
					table.insert(self.bakedLayersList, false)
					local selList = {}
					local mesh = vectorLayer:Mesh()
					for p = 0, mesh:CountPoints() - 1 do
						local pt = mesh:Point(p)
						if pt.fSelected then
							if not layersList[i] then
								layersCount = layersCount + 1
								layersList[i] = true
								firstLayer = self.vectorLayersList[i]
							end
							table.insert(selList, pt)
						end
					end
					self.selList[i] = selList
				end
			end
		end
		
		if layersCount == 0 then
			return
		end

		if layersCount == 1 then
			local layer = moho.document:LayerByAbsoluteID(firstLayer)
			if layer then
				moho.document:PrepUndo(layer, true)
				moho.document:SetDirty()
			end
		elseif layersCount > 1 then
			moho.document:PrepMultiUndo(false)
			moho.document:SetDirty()
		end

		self:PrepareVectorForTransform(moho)
		self.inProgressIcon = false
		moho.view:DrawMe()
	end

	self.centerVec:Set(self.selectionBBox:Center2D())
	self.centerVec = self.centerVec + self.pivotOffset
	self.startPivotOffset = LM.Vector2:new_local()
	self.startPivotOffset:Set(self.pivotOffset)
	self.startPivotOffsetPt = LM.Point:new_local()
	mouseEvent.view:Graphics():WorldToScreen(self.startPivotOffset, self.startPivotOffsetPt)
	mouseEvent.view:Graphics():WorldToScreen(self.centerVec, self.centerVecPt)

	if self.mode == 100 then -- move
	elseif self.mode == 101 then -- rotate
		self.startAngle = 0
		self.lastVec:Set(mouseEvent.vec)
		self.lastVecPt:Set(mouseEvent.pt)
		self:UpdateCenterVec(moho)
	elseif self.mode == 111 then -- pivot
		self.transformBoxActive = true
		self.transformBoxDragging = true
		if mouseEvent.doubleClick then
			self.pivotOffset:Set(0, 0)
			self.transformBoxActive = false
			self.transformBoxDragging = false
			return
		end
		self.lastVecPt:Set(mouseEvent.pt)
	elseif self.mode >= 102 and self.mode <= 109 then -- scale
		self.lastScaleX = 1.0
		self.lastScaleY = 1.0
	
		self:UpdateCenterVec(moho)

		local selectedMaxPt = LM.Point:new_local()
		local selectedMinPt = LM.Point:new_local()

		self.offsetCenterVec = LM.Vector2:new_local()

		if mouseEvent.altKey or (self.pivotOffset.x ~= 0 or self.pivotOffset.y ~= 0) then
			self.offsetCenterVec:Set(self.bboxCener3d.x + self.pivotOffset.x, self.bboxCener3d.y + self.pivotOffset.y)
			self.altScale = true
		else
			self.altScale = false
			self.selectedMin, self.selectedMax = self.selectionBBox.fMin, self.selectionBBox.fMax
			self.selectedMin.y, self.selectedMax.y = self.selectedMax.y, self.selectedMin.y

			if self.mode == 106 then -- LEFT
				self.offsetCenterVec:Set(self.selectedMax.x, (self.selectedMin.y + self.selectedMax.y) / 2.0)
			elseif self.mode == 107 then -- RIGHT
				self.offsetCenterVec:Set(self.selectedMin.x, (self.selectedMin.y + self.selectedMax.y) / 2.0)
			elseif self.mode == 108 then -- TOP
				self.offsetCenterVec:Set((self.selectedMin.x + self.selectedMax.x) / 2.0, self.selectedMax.y)
			elseif self.mode == 109 then -- BOTTOM
				self.offsetCenterVec:Set((self.selectedMin.x + self.selectedMax.x) / 2.0, self.selectedMin.y)
			elseif self.mode == 104 then -- BL
				self.offsetCenterVec:Set(self.selectedMax.x, self.selectedMin.y)
			elseif self.mode == 102 then -- TL
				self.offsetCenterVec:Set(self.selectedMax.x, self.selectedMax.y)
			elseif self.mode == 103 then -- TR
				self.offsetCenterVec:Set(self.selectedMin.x, self.selectedMax.y)
			elseif self.mode == 105 then -- BR
				self.offsetCenterVec:Set(self.selectedMin.x, self.selectedMin.y)
			end
		end
	elseif self.mode >= 200 and self.mode <= 203 then -- skew
		self:UpdateCenterVec(moho)

		local center = LM.Vector2:new_local()

		local mInv = LM.Matrix:new_local()
		self.selectedMin, self.selectedMax = self.selectionBBox.fMin, self.selectionBBox.fMax

		self.centerVec:Set(self.bboxCener3d.x + self.pivotOffset.x, self.bboxCener3d.y + self.pivotOffset.y)
	elseif self.mode >= 204 and self.mode <= 207 then -- distord
		self:UpdateCenterVec(moho)

		local mInv = LM.Matrix:new_local()

		self.selectedMin, self.selectedMax = self.selectionBBox.fMin, self.selectionBBox.fMax
		self.centerVec:Set(self.bboxCener3d.x + self.pivotOffset.x, self.bboxCener3d.y + self.pivotOffset.y)

		self.handle = 'none'
		self.bottomLeft = LM.Vector2:new_local()
		self.topLeft = LM.Vector2:new_local()
		self.bottomRight = LM.Vector2:new_local()
		self.topRight = LM.Vector2:new_local()

		self.bottomLeft.x = self.selectedMin.x
		self.bottomLeft.y = self.selectedMin.y

		self.topLeft.x = self.selectedMin.x
		self.topLeft.y = self.selectedMax.y

		self.bottomRight.x = self.selectedMax.x
		self.bottomRight.y = self.selectedMin.y

		self.topRight.x = self.selectedMax.x
		self.topRight.y = self.selectedMax.y

		self.horizonPercent = {}
		self.vertPercent = {}

		self.clickPos = LM.Vector2:new_local()
		self.clickPos = MR_Utilities:GetGlobalPos(moho, moho.layer, mouseEvent.startVec, true)

		self.horizonPercentCenter = {}
		self.vertPercentCenter = {}

		for i = 1, #self.vectorLayersList do
			local layer = moho.document:LayerByAbsoluteID(self.vectorLayersList[i])
			if layer ~= nil then
				local vectorLayer = moho:LayerAsVector(layer)
				if vectorLayer then
					local horizonPercent = {}
					local vertPercent = {}
					local mesh = vectorLayer:Mesh()
					for p = 0, mesh:CountPoints() - 1 do
						local pt = mesh:Point(p)
						if pt.fSelected then
							local maxXdistance = self.topRight.x - self.topLeft.x
							local pointPos = LM.Vector2:new_local()
							pointPos = MR_Utilities:GetGlobalPos(moho, layer, pt.fTempPos, true)
							local Xdistance = pointPos.x - self.topLeft.x
							horizonPercent[p + 1] = Xdistance/maxXdistance

							local maxYdistance = self.bottomLeft.y - self.topLeft.y
							local Ydistance = pointPos.y - self.topLeft.y
							vertPercent[p + 1] = Ydistance/maxYdistance
						end
					end

					self.horizonPercent[i] = horizonPercent
					self.vertPercent[i] = vertPercent

					local maxXdistance = self.topRight.x - self.topLeft.x
					local Xdistance = self.centerVec.x - self.topLeft.x
					self.horizonPercentCenter[i] = Xdistance / maxXdistance

					local maxYdistance = self.bottomLeft.y - self.topLeft.y
					local Ydistance = self.centerVec.y - self.topLeft.y
					self.vertPercentCenter[i] = Ydistance / maxYdistance
				end
			end
		end
	end
end

function MR_AnimatePoints:OnMouseMovedTransformBoxPivotMode(moho, mouseEvent)
	local curPt = mouseEvent.pt - mouseEvent.startPt

	if (mouseEvent.shiftKey) then
		if math.abs(curPt.x) > math.abs(curPt.y) then
			curPt.y = 0
		else
			curPt.x = 0
		end
	end

	self.pivotOffsetPt = self.startPivotOffsetPt + curPt
	mouseEvent.view:Graphics():ScreenToWorld(self.pivotOffsetPt, self.pivotOffset)
	self.centerVec = self.selectionBBox:Center2D() + self.pivotOffset

	mouseEvent.view:DrawMe()
end

function MR_AnimatePoints:OnMouseUpTransformBoxMode(moho, mouseEvent)
	if self.transformBoxDragging then
		if self.hideCurvesWhileDragging then
			moho.view:SetQualityFlags(self.currentQualityFlags)
		end

		self.transformBoxActive = false
		self.transformBoxDragging = false

		if self.mode == 101 then
			self:UpdateVectorList(moho, true)
			local vec = self.selectionBBox:Center2D()
			self.pivotOffset = self.centerVec - vec
		elseif self.mode >= 102 and self.mode <= 109 then
			self:UpdateVectorList(moho, true)
			if self.altScale then
				local vec = self.selectionBBox:Center2D()
				self.pivotOffset = self.pivotCenterVec - vec
				self.altScale = false
			else
				self.pivotOffset:Set(0, 0)
			end
		end

		local targetFrames = {}

		if (self.mode >= 100 and self.mode <= 109) or (self.mode >= 200 and self.mode <= 207) then
			if MOHO.MohoGlobals.EditMultipleKeys then
				local markersChannel = moho:ChannelAsAnimString(moho.layer.fTimelineMarkers)
				local timingOffset = moho.layer:TotalTimingOffset()

				for i = 0, markersChannel:CountKeys() - 1 do
					if markersChannel:IsKeySelectedByID(i) then
						local frame = math.floor(markersChannel:GetKeyWhen(i))
						if frame > 0 then
							local markerText = markersChannel:GetValue(frame)
							local markerVal = tonumber(string.match(markerText, "%d+"))
							markerVal = math.floor(markerVal)
							targetFrames[markerVal] = true
						end
					end
				end
			end
			for i = 1, #self.vectorLayersList do
				local layer = moho.document:LayerByAbsoluteID(self.vectorLayersList[i])
				if layer ~= nil then
					local layerFrame = layer:DocToLayerFrame(moho.frame)
					local vectorLayer = moho:LayerAsVector(layer)
					if vectorLayer then
						local mesh = vectorLayer:Mesh()
						moho:AddPointKeyframe(moho.frame, layer)

						for p, pt in ipairs(self.selList[i]) do
							local delta = self.posList[i][p] - pt.fPos
							pt.fPos = self.posList[i][p] + delta
						end
						moho:AddPointKeyframe(moho.frame, layer)

						local treshold = 0.00001
						for p, pt in ipairs(self.selList[i]) do
							if math.abs(self.posList[i][p].x - pt.fPos.x) >= treshold or math.abs(self.posList[i][p].y - pt.fPos.y) >= treshold then
								local startPos = self.startPosList[i][p]
								local delta = LM.Vector2:new_local()
								delta:Set(startPos - pt.fAnimPos:GetValue(moho.frame))
								pt.fAnimPos:SetValue(layerFrame, pt.fAnimPos:GetValue(layerFrame) + delta / 2)
							end
						end

						if MOHO.MohoGlobals.EditMultipleKeys then
							for p, pt in ipairs(self.selList[i]) do
								local startPos = self.startPosList[i][p]
								local delta = LM.Vector2:new_local()
								delta:Set(startPos - pt.fAnimPos:GetValue(layerFrame))
								local channel = moho:ChannelAsAnimVec2(pt.fAnimPos)
								self:ApplyPosToRelativeKeys(moho, layer, channel, delta, targetFrames)
							end
						end

						layer:FreeCachedImage()
					end
				end
			end

			if self.fixedHandles then
				self:RepairFixedHandles(moho)
			end

			moho.view:DrawMe()
		end
	end
	moho:UpdateUI()
end

function MR_AnimatePoints:PrepareVectorForTransform(moho)
	self.selList = {}
	self.posList = {}
	self.bezierList = {}
	self.fixedHandlesToBakeList = {}

	self.flipDirectionList = {}
	self.clusterList = {}
	self.startPosList = {}
	self.fPoses = {}
	self.inOffsets = {}
	self.outOffsets = {}

	for i = 1, #self.vectorLayersList do
		local layer = moho.document:LayerByAbsoluteID(self.vectorLayersList[i])
		if layer ~= nil then
			local vectorLayer = moho:LayerAsVector(layer)
			if vectorLayer then
				local layerFrame = layer:DocToLayerFrame(moho.frame)
				local posList = {}
				local selList = {}
				local layersPointsPosList = {}
				local startPosList = {}

				local inOffsets = {}
				local outOffsets = {}
				local fPoses = {}

				local mesh = vectorLayer:Mesh()
				mesh:PrepMovePoints()
				if self.fixedHandles then
					mesh:PrepFixedHandles(layer:DocToLayerFrame(moho.frame))
					local fixedHandlesToBake = {}

					local bezierList = {}
					local flipDirectionList = {}
					for c=0, mesh:CountCurves()-1 do
						local nextCurveArray = {}
						local curve = mesh:Curve(c)
						local curvePoints = curve:CountPoints()
						for p=0, curve:CountPoints()-1 do
							local preVect = curve:GetControlHandle(p, layerFrame, true)
							local postVect = curve:GetControlHandle(p, layerFrame, false)
							local pointArray = {pre = preVect, post = postVect}
							nextCurveArray[p] = pointArray

							if curve:IsPartiallySelected() then
								local point = curve:Point(p)
								if not point.fSelected then
									local areAdjacentPointsSelected = false
									if curve.fClosed then
										if p == 0 then
											if curve:Point(curvePoints - 1).fSelected or curve:Point(p + 1).fSelected then
												areAdjacentPointsSelected = true
											end
										elseif p == curvePoints - 1 then
											if curve:Point(0).fSelected or curve:Point(p - 1).fSelected then
												areAdjacentPointsSelected = true
											end
										else
											if curve:Point(p + 1).fSelected or curve:Point(p - 1).fSelected then
												areAdjacentPointsSelected = true
											end
										end
									else
										if p == 0 then
											if curve:Point(p + 1).fSelected then
												areAdjacentPointsSelected = true
											end
										elseif p == curvePoints - 1 then
											if curve:Point(p - 1).fSelected then
												areAdjacentPointsSelected = true
											end
										else
											if curve:Point(p + 1).fSelected or curve:Point(p - 1).fSelected then
												areAdjacentPointsSelected = true
											end
										end
									end
									if areAdjacentPointsSelected then
										local flipDirection = MR_Utilities:CheckFlipDirection(moho, layer, point)
										flipDirectionList[mesh:PointID(point)+1] = flipDirection
										table.insert(fixedHandlesToBake, point)
									end
								end
							end
						end

						bezierList[c] = nextCurveArray
					end
					table.insert(self.fixedHandlesToBakeList, fixedHandlesToBake)
					table.insert(self.bezierList, bezierList)
					table.insert(self.flipDirectionList, flipDirectionList)
				end
				local isShapesInCluster = false
				for i = 0, mesh:CountShapes() - 1 do
					local shape = mesh:Shape(i)
					if shape:IsInCluster() then
						isShapesInCluster = true
						break
					end
				end

				table.insert(self.clusterList, isShapesInCluster)

				for i = 0, mesh:CountPoints() - 1 do
					local pt = mesh:Point(i)
					if not pt.fHidden and pt.fSelected then
						local pos = LM.Vector2:new_local()
						pos:Set(pt.fPos)

						table.insert(posList, pos)
						table.insert(selList, pt)
						table.insert(startPosList, pt.fAnimPos:GetValue(layerFrame))

						if self.mode >= 204 and self.mode <= 207 then
							table.insert(fPoses, LM.Vector2:new_local())
							local ins = {}
							local outs = {}
							for c = 0, pt:CountCurves() -1 do
								local curve, where = pt:Curve(c, -1)
								ins[c] = curve:GetOffset(where, layerFrame, true)
								outs[c] = curve:GetOffset(where, layerFrame, false)
							end
							table.insert(inOffsets, ins)
							table.insert(outOffsets, outs)
						end
					end
				end

				table.insert(self.selList, selList)
				table.insert(self.posList, posList)
				table.insert(self.startPosList, startPosList)
				if self.mode >= 204 and self.mode <= 207 then
					table.insert(self.inOffsets, inOffsets)
					table.insert(self.outOffsets, outOffsets)
					table.insert(self.fPoses, fPoses)
				end
			end
		end
	end
end

function MR_AnimatePoints:OnMouseMovedTransformBoxMode_T(moho, mouseEvent)
	local vecPos = LM.Vector2:new_local()
	local startVecPos = LM.Vector2:new_local()
	startVecPos:Set(mouseEvent.startVec)
	vecPos:Set(mouseEvent.vec)

	vecPos = MR_Utilities:GetGlobalPos(moho, moho.layer, vecPos, false)
	startVecPos = MR_Utilities:GetGlobalPos(moho, moho.layer, startVecPos, false)

	local curvatureVal = 0
	if self.bboxLength == 0 then
		local curVec = MR_Utilities:GetGlobalPos(moho, moho.layer, mouseEvent.vec, false)
		if mouseEvent.altKey or mouseEvent.ctrlKey then
			if math.abs(curVec.x - self.lastVec.x) > math.abs(curVec.y - self.lastVec.y) then
				if curVec.x > self.lastVec.x then
					self.angle = self.angle + math.rad(1 * self.sensitivity)
					curvatureVal = math.rad(1 * self.sensitivity)
				else
					self.angle = self.angle - math.rad(1 * self.sensitivity)
					curvatureVal = math.rad(-1 * self.sensitivity)
				end
			end
		end

		self.lastVec:Set(curVec)
	end

	for i = 1, #self.vectorLayersList do
		local layer = moho.document:LayerByAbsoluteID(self.vectorLayersList[i])
		if layer ~= nil then
			local layerFrame = layer:DocToLayerFrame(moho.frame)
			local vectorLayer = moho:LayerAsVector(layer)
			if vectorLayer then
				if self.bboxLength == 0 and mouseEvent.ctrlKey then
					for p, pt in ipairs(self.selList[i]) do
						for j = 0, pt:CountCurves() - 1 do
							local curve, ptPos = pt:Curve(j, -1)

							local curvature = curve:GetCurvature(ptPos, layerFrame)
							local weight = (curve:GetWeight(ptPos, layerFrame, true) + curve:GetWeight(ptPos, layerFrame, false)) / 2.0
							local newVal = curvature + ((math.deg(curvatureVal) * 0.01) / weight)
							newVal = LM.Clamp(newVal, 0, 1)
							curve:SetCurvature(ptPos, newVal, layerFrame)
						end
					end
					self.drawHandles = true
				else
					local mesh = vectorLayer:Mesh()
					if self.smartBake and moho.frame > 0 and not MOHO.MohoGlobals.EditMultipleKeys and not self.bakedLayersList[i] then
						for p, pt in ipairs(self.selList[i]) do
							local prevFrame = layerFrame- self.smartBakeInterval
							local nextFrame = layerFrame + self.smartBakeInterval
							if prevFrame > 0 then
								pt.fAnimPos:SetValue(prevFrame, pt.fAnimPos:GetValue(prevFrame))
							end
							pt.fAnimPos:SetValue(nextFrame, pt.fAnimPos:GetValue(nextFrame))
						end

						if self.fixedHandles then
							for p, pt in ipairs(self.fixedHandlesToBakeList[i]) do
								local prevFrame = layerFrame- self.smartBakeInterval
								local nextFrame = layerFrame + self.smartBakeInterval
								self:BakePointCurvature(moho, layer, pt, prevFrame, nextFrame)
							end
						end

						self.bakedLayersList[i] = true
					end

					local localVec = LM.Vector2:new_local()
					localVec:Set(vecPos)
					localVec = MR_Utilities:GetLocalPos(moho, layer, localVec, false)

					local localStartVec = LM.Vector2:new_local()
					localStartVec:Set(startVecPos)
					localStartVec = MR_Utilities:GetLocalPos(moho, layer, localStartVec, false)

					local curVec = localVec - localStartVec
					if (mouseEvent.shiftKey) then
						if (math.abs(curVec.x) > math.abs(curVec.y)) then
							curVec.y = 0
						else
							curVec.x = 0
						end
					end

					if (moho.gridOn) then
						moho:SnapToGrid(curVec)
					end

					mesh:TranslatePoints(curVec)

					for p, pt in ipairs(self.selList[i]) do
						self.posList[i][p]:Set(pt.fPos)
					end

					local isWarpLayer = vectorLayer:IsWarpLayer()
					if self.fixedHandles and not isWarpLayer then
						mesh:PreserveHandlePositions(layerFrame)
					end

					if self.clusterList[i] then
						layer:UpdateCurFrame()
						for p, pt in ipairs(self.selList[i]) do
							pt.fPos = self.posList[i][p]
						end
					end
					if isWarpLayer then
						moho:AddPointKeyframe(moho.frame, layer)
						for p, pt in ipairs(self.selList[i]) do
							local delta = self.posList[i][p] - pt.fPos
							pt.fPos = self.posList[i][p] + delta
						end
						moho:AddPointKeyframe(moho.frame, layer)
					end
				end
			end
		end
	end
end

function MR_AnimatePoints:OnMouseMovedTransformBoxMode_R(moho, mouseEvent)
	local v1 = LM.Vector2:new_local()
	local v2 = LM.Vector2:new_local()
	local angle = self.startAngle
	local p1 = self.lastVecPt - self.centerVecPt
	local p2 = mouseEvent.pt - self.centerVecPt
	v1:Set(p1.x, -p1.y)
	v2:Set(p2.x, -p2.y)
	v2:Rotate(-math.atan2(v1.y, v1.x))
	angle = angle + math.atan2(v2.y, v2.x)

	self.startAngle = angle
	if (mouseEvent.shiftKey) then
		angle = angle / (math.pi / 8)
		angle = (math.pi / 8) * LM.Round(angle)
	end

	local mInv = LM.Matrix:new_local()
	local vec3 = LM.Vector3:new_local()
	local vec = LM.Vector2:new_local()

	self.pivotCenterVec:Set(self.bboxCener3d.x + self.pivotOffset.x, self.bboxCener3d.y + self.pivotOffset.y)

	self.lastVecPt:Set(mouseEvent.pt)

	for i = 1, #self.vectorLayersList do
		local layer = moho.document:LayerByAbsoluteID(self.vectorLayersList[i])
		if layer ~= nil then
			local layerFrame = layer:DocToLayerFrame(moho.frame)
			local vectorLayer = moho:LayerAsVector(layer)
			if vectorLayer then
				local mesh = vectorLayer:Mesh()

				if self.smartBake and moho.frame > 0 and not MOHO.MohoGlobals.EditMultipleKeys and not self.bakedLayersList[i] then
					for p, pt in ipairs(self.selList[i]) do
						local prevFrame = layerFrame- self.smartBakeInterval
						local nextFrame = layerFrame + self.smartBakeInterval
						if prevFrame > 0 then
							pt.fAnimPos:SetValue(prevFrame, pt.fAnimPos:GetValue(prevFrame))
						end
						pt.fAnimPos:SetValue(nextFrame, pt.fAnimPos:GetValue(nextFrame))
					end

					if self.fixedHandles then
						for p, pt in ipairs(self.fixedHandlesToBakeList[i]) do
							local prevFrame = layerFrame- self.smartBakeInterval
							local nextFrame = layerFrame + self.smartBakeInterval
							self:BakePointCurvature(moho, layer, pt, prevFrame, nextFrame)
						end
					end

					self.bakedLayersList[i] = true
				end

				layer:GetFullTransform(moho.frame, mInv, moho.document)
				mInv:Invert()

				local pointPos = LM.Vector2:new_local()
				for p, pt in ipairs(self.selList[i]) do
					pointPos = MR_Utilities:GetGlobalPos(moho, layer, pt.fTempPos, true)
					pointPos = MR_Utilities:RotateVector2(pointPos, self.pivotCenterVec, angle)
					vec3:Set(pointPos.x, pointPos.y, self.bboxCener3d.z)
					mInv:Transform(vec3)
					pointPos:Set(vec3.x, vec3.y)
					pt.fPos = pointPos
					self.posList[i][p]:Set(pt.fPos)
				end

				if self.clusterList[i] then
					layer:UpdateCurFrame()
					for p, pt in ipairs(self.selList[i]) do
						pt.fPos = self.posList[i][p]
					end
				end

				local isWarpLayer = vectorLayer:IsWarpLayer()
				if self.fixedHandles and not isWarpLayer then
					mesh:PreserveHandlePositions(layerFrame)
				end
				if isWarpLayer then
					moho:AddPointKeyframe(moho.frame, layer)
					for p, pt in ipairs(self.selList[i]) do
						local delta = self.posList[i][p] - pt.fPos
						pt.fPos = self.posList[i][p] + delta
					end
					moho:AddPointKeyframe(moho.frame, layer)
				end
			end
		end
	end
end

function MR_AnimatePoints:OnMouseMovedTransformBoxMode_S(moho, mouseEvent)
	local center = LM.Vector2:new_local()
	local scaling = LM.Vector2:new_local()

	local mouseStartVec = MR_Utilities:GetGlobalPos(moho, moho.layer, mouseEvent.startVec, true)
	local mouseVec = MR_Utilities:GetGlobalPos(moho, moho.layer,  mouseEvent.vec, true)

	local p1 = mouseStartVec - self.offsetCenterVec
	local p2 = mouseVec - self.offsetCenterVec

	scaling.x = p2.x / p1.x
	scaling.y = p2.y / p1.y

	if (self.mode == 106 or self.mode == 107) then
		scaling.y = 1
		if (mouseEvent.shiftKey) then
			scaling.y = 1 / scaling.x
		end
	elseif (self.mode == 108 or self.mode == 109) then
		scaling.x = 1
		if (mouseEvent.shiftKey) then
			scaling.x = 1 / scaling.y
		end
	else
		if (not mouseEvent.shiftKey) then
			scaling.x = (scaling.x + scaling.y) / 2
			scaling.y = scaling.x
		end
	end

	local flip = false
	if (scaling.x * self.lastScaleX < -0.0001) and (scaling.y * self.lastScaleY > 0.0001) then
		flip = true
	elseif (scaling.y * self.lastScaleY < -0.0001) and (scaling.x * self.lastScaleX > 0.0001) then
		flip = true
	end

	local mInv = LM.Matrix:new_local()
	local vec = LM.Vector2:new_local()
	local globalCenter = LM.Vector2:new_local()
	local vec3 = LM.Vector3:new_local()
	local lVec = LM.Vector2:new_local()
	local scaleVec = LM.Vector2:new_local()
	local angle

	self.lastScaling:Set(scaling.x, scaling.y)
	center:Set(self.offsetCenterVec)
	self.pivotCenterVec:Set(center)

	for i = 1, #self.vectorLayersList do
		local layer = moho.document:LayerByAbsoluteID(self.vectorLayersList[i])
		if layer ~= nil then
			local layerFrame = layer:DocToLayerFrame(moho.frame)
			local vectorLayer = moho:LayerAsVector(layer)
			if vectorLayer then
				local mesh = vectorLayer:Mesh()

				if self.smartBake and moho.frame > 0 and not MOHO.MohoGlobals.EditMultipleKeys and not self.bakedLayersList[i] then
					for p, pt in ipairs(self.selList[i]) do
						local prevFrame = layerFrame- self.smartBakeInterval
						local nextFrame = layerFrame + self.smartBakeInterval
						if prevFrame > 0 then
							pt.fAnimPos:SetValue(prevFrame, pt.fAnimPos:GetValue(prevFrame))
						end
						pt.fAnimPos:SetValue(nextFrame, pt.fAnimPos:GetValue(nextFrame))
					end

					if self.fixedHandles then
						for p, pt in ipairs(self.fixedHandlesToBakeList[i]) do
							local prevFrame = layerFrame- self.smartBakeInterval
							local nextFrame = layerFrame + self.smartBakeInterval
							self:BakePointCurvature(moho, layer, pt, prevFrame, nextFrame)
						end
					end

					self.bakedLayersList[i] = true
				end

				scaleVec:Set(scaling)
				layer:GetFullTransform(moho.frame, mInv, moho.document)
				mInv:Invert()

				lVec:Set(1, 0)
				mInv:Transform(lVec)
				angle = math.deg(math.atan2(lVec.y, lVec.x))

				vec3:Set(center.x, center.y, self.bboxCener3d.z)
				mInv:Transform(vec3)
				vec:Set(vec3.x, vec3.y)

				mesh:ScalePoints(scaleVec.x, scaleVec.y, vec, flip)
				for p, pt in ipairs(self.selList[i]) do
					local pointPos = LM.Vector2:new_local()
					pointPos = MR_Utilities:GetGlobalPos(moho, layer, pt.fTempPos, true)
					pointPos = MR_Utilities:ScaleVector2(pointPos, self.offsetCenterVec, scaleVec)

					vec3:Set(pointPos.x, pointPos.y, self.bboxCener3d.z)
					mInv:Transform(vec3)
					pointPos:Set(vec3.x, vec3.y)

					pt.fPos = pointPos
				end

				for p, pt in ipairs(self.selList[i]) do
					self.posList[i][p]:Set(pt.fPos)
				end

				if self.clusterList[i] then
					layer:UpdateCurFrame()
					for p, pt in ipairs(self.selList[i]) do
						pt.fPos = self.posList[i][p]
					end
				end

				local isWarpLayer = vectorLayer:IsWarpLayer()
				if self.fixedHandles and not isWarpLayer then
					mesh:PreserveHandlePositions(layerFrame)
				end
				if isWarpLayer then
					moho:AddPointKeyframe(moho.frame, layer)
					for p, pt in ipairs(self.selList[i]) do
						local delta = self.posList[i][p] - pt.fPos
						pt.fPos = self.posList[i][p] + delta
					end
					moho:AddPointKeyframe(moho.frame, layer)
				end
			end
		end
	end

	if (mouseEvent.altKey) then
		self.pivotOffset = self.pivotCenterVec - self.selectionBBox:Center2D()
	else
		local v = self.centerVec - center
		v.x = v.x * scaling.x
		v.y = v.y * scaling.y
		v = v + center
		self.pivotOffset = v - self.selectionBBox:Center2D()
	end

	if (flip) then
		self.lastScaleX = scaling.x
		self.lastScaleY = scaling.y
	end
end

function MR_AnimatePoints:OnMouseMovedTransformBoxMode_D(moho, mouseEvent)
	local mouseVec = LM.Vector2:new_local()
	mouseVec:Set(mouseEvent.vec)
	mouseVec = MR_Utilities:GetGlobalPos(moho, moho.layer, mouseVec, true)

	if self.mode == 205 then -- 'topLeft
		self.topLeft.x = mouseVec.x - (self.clickPos.x - self.selectedMin.x)
		self.topLeft.y = mouseVec.y - (self.clickPos.y - self.selectedMax.y)
	elseif self.mode == 206 then -- topRight
		self.topRight.x = mouseVec.x - (self.clickPos.x - self.selectedMax.x)
		self.topRight.y = mouseVec.y - (self.clickPos.y - self.selectedMax.y)
	elseif self.mode == 207 then -- bottomRight
		self.bottomRight.x = mouseVec.x - (self.clickPos.x - self.selectedMax.x)
		self.bottomRight.y = mouseVec.y - (self.clickPos.y - self.selectedMin.y)
	elseif self.mode == 204 then -- bottomLeft
		self.bottomLeft.x = mouseVec.x - (self.clickPos.x - self.selectedMin.x)
		self.bottomLeft.y = mouseVec.y - (self.clickPos.y - self.selectedMin.y)
	end

	for i = 1, #self.vectorLayersList do
		local layer = moho.document:LayerByAbsoluteID(self.vectorLayersList[i])
		if layer ~= nil then
			local vectorLayer = moho:LayerAsVector(layer)
			if vectorLayer then
				local mesh = vectorLayer:Mesh()
				local layerFrame = layer:DocToLayerFrame(moho.frame)

				if self.smartBake and moho.frame > 0 and not MOHO.MohoGlobals.EditMultipleKeys and not self.bakedLayersList[i] then
					for p, pt in ipairs(self.selList[i]) do
						local prevFrame = layerFrame- self.smartBakeInterval
						local nextFrame = layerFrame + self.smartBakeInterval
						if prevFrame > 0 then
							pt.fAnimPos:SetValue(prevFrame, pt.fAnimPos:GetValue(prevFrame))
						end
						pt.fAnimPos:SetValue(nextFrame, pt.fAnimPos:GetValue(nextFrame))
					end

					if self.fixedHandles then
						for p, pt in ipairs(self.fixedHandlesToBakeList[i]) do
							local prevFrame = layerFrame- self.smartBakeInterval
							local nextFrame = layerFrame + self.smartBakeInterval
							self:BakePointCurvature(moho, layer, pt, prevFrame, nextFrame)
						end
					end

					self.bakedLayersList[i] = true
				end

				local mInv = LM.Matrix:new_local()
				local vec3 = LM.Vector3:new_local()
				layer:GetFullTransform(moho.frame, mInv, moho.document)
				mInv:Invert()

				for p, v in ipairs(self.selList[i])do
					local k = mesh:PointID(v)+1
					local topPoint = LM.Vector2:new_local()
					local bottomPoint = LM.Vector2:new_local()
					local leftPoint = LM.Vector2:new_local()
					local rightPoint = LM.Vector2:new_local()

					local topAngle = math.atan2(self.topRight.y - self.topLeft.y, self.topRight.x - self.topLeft.x)
					local dx = self.topRight.x - self.topLeft.x
					local dy = self.topRight.y - self.topLeft.y
					local topdist = math.sqrt(dx * dx + dy * dy)
					topPoint.x = self.topLeft.x + math.cos(topAngle) * (topdist * self.horizonPercent[i][k])
					topPoint.y = self.topLeft.y + math.sin(topAngle) * (topdist * self.horizonPercent[i][k])

					local bottomAngle = math.atan2(self.bottomRight.y - self.bottomLeft.y, self.bottomRight.x - self.bottomLeft.x)
					local dx = self.bottomRight.x - self.bottomLeft.x
					local dy = self.bottomRight.y - self.bottomLeft.y
					local bottomdist = math.sqrt(dx * dx + dy * dy)
					bottomPoint.x = self.bottomLeft.x + math.cos(bottomAngle) * (bottomdist * self.horizonPercent[i][k])
					bottomPoint.y = self.bottomLeft.y + math.sin(bottomAngle) * (bottomdist * self.horizonPercent[i][k])

					local leftAngle = math.atan2(self.bottomLeft.y - self.topLeft.y, self.bottomLeft.x - self.topLeft.x)
					local dx = self.bottomLeft.x - self.topLeft.x
					local dy = self.bottomLeft.y - self.topLeft.y
					local leftdist = math.sqrt(dx * dx + dy * dy)
					leftPoint.x = self.topLeft.x + math.cos(leftAngle) * (leftdist * self.vertPercent[i][k])
					leftPoint.y = self.topLeft.y + math.sin(leftAngle) * (leftdist * self.vertPercent[i][k])

					local rightAngle = math.atan2(self.bottomRight.y - self.topRight.y, self.bottomRight.x - self.topRight.x)
					local dx = self.bottomRight.x - self.topRight.x
					local dy = self.bottomRight.y - self.topRight.y
					local rightdist = math.sqrt(dx * dx + dy * dy)
					rightPoint.x = self.topRight.x + math.cos(rightAngle) * (rightdist * self.vertPercent[i][k])
					rightPoint.y = self.topRight.y + math.sin(rightAngle) * (rightdist * self.vertPercent[i][k])

					local a1, a2, b1, b2, c1, c2

					a1 = bottomPoint.y - topPoint.y
					b1 = topPoint.x - bottomPoint.x
					c1 = bottomPoint.x * topPoint.y - topPoint.x * bottomPoint.y
					a2 = rightPoint.y - leftPoint.y
					b2 = leftPoint.x - rightPoint.x
					c2 = rightPoint.x * leftPoint.y - leftPoint.x * rightPoint.y

					local denom =a1 * b2 - a2 * b1;
					local newPos = LM.Vector2:new_local()
					newPos:Set((b1 * c2 - b2 * c1) / denom, (a2 * c1 - a1 * c2) / denom)

					vec3:Set(newPos.x, newPos.y, self.bboxCener3d.z)
					mInv:Transform(vec3)
					newPos:Set(vec3.x, vec3.y)

					v.fPos = newPos
					self.posList[i][p]:Set(v.fPos)
				end

				if self.clusterList[i] then
					layer:UpdateCurFrame()
					for p, pt in ipairs(self.selList[i]) do
						pt.fPos = self.posList[i][p]
					end
				end

				if i == #self.vectorLayersList and (self.pivotOffset.x ~= 0 or self.pivotOffset.y ~= 0) then
					local topPoint = LM.Vector2:new_local()
					local bottomPoint = LM.Vector2:new_local()
					local leftPoint = LM.Vector2:new_local()
					local rightPoint = LM.Vector2:new_local()

					local topAngle = math.atan2(self.topRight.y - self.topLeft.y, self.topRight.x - self.topLeft.x)
					local dx = self.topRight.x - self.topLeft.x
					local dy = self.topRight.y - self.topLeft.y
					local topdist = math.sqrt(dx * dx + dy * dy)
					topPoint.x = self.topLeft.x + math.cos(topAngle) * (topdist * self.horizonPercentCenter[i])
					topPoint.y = self.topLeft.y + math.sin(topAngle) * (topdist * self.horizonPercentCenter[i])

					local bottomAngle = math.atan2(self.bottomRight.y - self.bottomLeft.y, self.bottomRight.x - self.bottomLeft.x)
					local dx = self.bottomRight.x - self.bottomLeft.x
					local dy = self.bottomRight.y - self.bottomLeft.y
					local bottomdist = math.sqrt(dx * dx + dy * dy)
					bottomPoint.x = self.bottomLeft.x + math.cos(bottomAngle) * (bottomdist * self.horizonPercentCenter[i])
					bottomPoint.y = self.bottomLeft.y + math.sin(bottomAngle) * (bottomdist * self.horizonPercentCenter[i])

					local leftAngle = math.atan2(self.bottomLeft.y - self.topLeft.y, self.bottomLeft.x - self.topLeft.x)
					local dx = self.bottomLeft.x - self.topLeft.x
					local dy = self.bottomLeft.y - self.topLeft.y
					local leftdist = math.sqrt(dx * dx + dy * dy)
					leftPoint.x = self.topLeft.x + math.cos(leftAngle) * (leftdist * self.vertPercentCenter[i])
					leftPoint.y = self.topLeft.y + math.sin(leftAngle) * (leftdist * self.vertPercentCenter[i])

					local rightAngle = math.atan2(self.bottomRight.y - self.topRight.y, self.bottomRight.x - self.topRight.x)
					local dx = self.bottomRight.x - self.topRight.x
					local dy = self.bottomRight.y - self.topRight.y
					local rightdist = math.sqrt(dx * dx + dy * dy)
					rightPoint.x = self.topRight.x + math.cos(rightAngle) * (rightdist * self.vertPercentCenter[i])
					rightPoint.y = self.topRight.y + math.sin(rightAngle) * (rightdist * self.vertPercentCenter[i])

					local a1, a2, b1, b2, c1, c2

					a1 = bottomPoint.y - topPoint.y
					b1 = topPoint.x - bottomPoint.x
					c1 = bottomPoint.x * topPoint.y - topPoint.x * bottomPoint.y
					a2 = rightPoint.y - leftPoint.y
					b2 = leftPoint.x - rightPoint.x
					c2 = rightPoint.x * leftPoint.y - leftPoint.x * rightPoint.y

					local denom = a1 * b2 - a2 * b1
					local newPos = LM.Vector2:new_local()
					newPos:Set((b1 * c2 - b2 * c1) / denom, (a2 * c1 - a1 * c2) / denom)

					local selectionBBox = LM.BBox:new_local()
					local m = LM.Matrix:new_local()
					for i = 1, #self.vectorLayersList do
						local layer = moho.document:LayerByAbsoluteID(self.vectorLayersList[i])
						if layer ~= nil then
							local vectorLayer = moho:LayerAsVector(layer)
							if vectorLayer then
								layer:GetFullTransform(moho.frame, m, moho.document)
								local mesh = vectorLayer:Mesh()
								for p = 0, mesh:CountPoints() - 1 do
									local pt = mesh:Point(p)
									if pt.fSelected then
										local vec3 = LM.Vector3:new_local()
										vec3:Set(pt.fPos.x, pt.fPos.y, 0)
										m:Transform(vec3)
										selectionBBox:AccumulatePoint(vec3)
									end
								end
							end
						end
					end

					local v = selectionBBox:Center2D()
					self.pivotOffset:Set(newPos.x - v.x, newPos.y - v.y)
				end

				local isWarpLayer = vectorLayer:IsWarpLayer()
				if self.fixedHandles and not isWarpLayer then
					mesh:PreserveHandlePositions(layerFrame)
				end
				if isWarpLayer then
					moho:AddPointKeyframe(moho.frame, layer)
					for p, pt in ipairs(self.selList[i]) do
						local delta = self.posList[i][p] - pt.fPos
						pt.fPos = self.posList[i][p] + delta
					end
					moho:AddPointKeyframe(moho.frame, layer)
				end
			end
		end
	end
end

function MR_AnimatePoints:OnMouseMovedTransformBoxMode_SW(moho, mouseEvent)
	local mouseVec = MR_Utilities:GetGlobalPos(moho, moho.layer, mouseEvent.vec, true)
	local mouseStartVec = MR_Utilities:GetGlobalPos(moho, moho.layer, mouseEvent.startVec, true)
	local mInv = LM.Matrix:new_local()
	local vec3 = LM.Vector3:new_local()
	local center = LM.Vector2:new_local()
	if (mouseEvent.altKey) then
		center:Set(self.centerVec)
	else
		if (self.mode == 200) then -- LEFT
			center:Set(self.selectedMax.x, (self.selectedMin.y + self.selectedMax.y) / 2.0)
		elseif (self.mode == 201) then -- RIGHT
			center:Set(self.selectedMin.x, (self.selectedMin.y + self.selectedMax.y) / 2.0)
		elseif (self.mode == 202) then -- TOP
			center:Set((self.selectedMin.x + self.selectedMax.x) / 2.0, self.selectedMax.y)
		elseif (self.mode == 203) then -- BOTTOM
			center:Set((self.selectedMin.x + self.selectedMax.x) / 2.0, self.selectedMin.y)
		end
	end
	local scaling = LM.Vector2:new_local()
	scaling:Set(1, 1)

	local v1 = mouseStartVec
	local v2 = mouseVec

	scaling.x = v2.x - v1.x
	scaling.y = v2.y - v1.y

	for i = 1, #self.vectorLayersList do
		local layer = moho.document:LayerByAbsoluteID(self.vectorLayersList[i])
		if layer ~= nil then
			local vectorLayer = moho:LayerAsVector(layer)
			if vectorLayer then
				local mesh = vectorLayer:Mesh()
				local layerFrame = layer:DocToLayerFrame(moho.frame)

				if self.smartBake and moho.frame > 0 and not MOHO.MohoGlobals.EditMultipleKeys and not self.bakedLayersList[i] then
					for p, pt in ipairs(self.selList[i]) do
						local prevFrame = layerFrame- self.smartBakeInterval
						local nextFrame = layerFrame + self.smartBakeInterval
						if prevFrame > 0 then
							pt.fAnimPos:SetValue(prevFrame, pt.fAnimPos:GetValue(prevFrame))
						end
						pt.fAnimPos:SetValue(nextFrame, pt.fAnimPos:GetValue(nextFrame))
					end

					if self.fixedHandles then
						for p, pt in ipairs(self.fixedHandlesToBakeList[i]) do
							local prevFrame = layerFrame- self.smartBakeInterval
							local nextFrame = layerFrame + self.smartBakeInterval
							self:BakePointCurvature(moho, layer, pt, prevFrame, nextFrame)
						end
					end

					self.bakedLayersList[i] = true
				end

				layer:GetFullTransform(moho.frame, mInv, moho.document)
				mInv:Invert()

				if (self.mode == 200 or self.mode == 201) then
					scaling.x = 1
				elseif (self.mode == 202 or self.mode == 203) then
					scaling.y = 1
				end
				local curVec = v2 - v1
				local pointPos = LM.Vector2:new_local()
				for p, point in pairs(self.selList[i]) do
					local point = self.selList[i][p]
					local newX = LM.Vector2:new_local()
					local newY = LM.Vector2:new_local()
					pointPos = MR_Utilities:GetGlobalPos(moho, layer, point.fTempPos, true)
					if self.mode == 200 then
						local divisor = self.selectedMin.x - center.x
						newX = pointPos.x
						newY = pointPos.y + scaling.y * (pointPos.x - center.x) / divisor

						if math.abs(newX) == math.huge then
							newX = pointPos.x
						end

						if math.abs(newY) == math.huge then
							newY = pointPos.y
						end
					elseif self.mode == 201 then
						local divisor = self.selectedMax.x - center.x

						newX = pointPos.x
						newY = pointPos.y + scaling.y * (pointPos.x - center.x) / divisor

						if math.abs(newX) == math.huge then
							newX = pointPos.x
						end

						if math.abs(newY) == math.huge then
							newY = pointPos.y
						end
					elseif self.mode == 202 then
						local divisor = self.selectedMin.y - center.y
						newX = pointPos.x + scaling.x * (pointPos.y - center.y) / divisor
						newY = pointPos.y

						if math.abs(newX) == math.huge then
							newX = pointPos.x
						end

						if math.abs(newY) == math.huge then
							newY = pointPos.y
						end
					elseif self.mode == 203 then
						local divisor = self.selectedMax.y - center.y
						newX = pointPos.x + scaling.x * (pointPos.y - center.y) / divisor
						newY = pointPos.y

						if math.abs(newX) == math.huge then
							newX = pointPos.x
						end

						if math.abs(newY) == math.huge then
							newY = pointPos.y
						end
					end

					local newPos = LM.Vector2:new_local()
					newPos:Set(newX, newY)
					vec3:Set(newPos.x, newPos.y, self.bboxCener3d.z)
					mInv:Transform(vec3)
					newPos:Set(vec3.x, vec3.y)

					point.fPos = newPos

					self.posList[i][p]:Set(point.fPos)
				end

				if i == #self.vectorLayersList and (self.pivotOffset.x ~= 0 or self.pivotOffset.y ~= 0) then
					local selectionBBox = LM.BBox:new_local()
					local m = LM.Matrix:new_local()
					for i = 1, #self.vectorLayersList do
						local layer = moho.document:LayerByAbsoluteID(self.vectorLayersList[i])
						if layer ~= nil then
							local vectorLayer = moho:LayerAsVector(layer)
							if vectorLayer then
								layer:GetFullTransform(moho.frame, m, moho.document)
								local mesh = vectorLayer:Mesh()
								for p = 0, mesh:CountPoints() - 1 do
									local pt = mesh:Point(p)
									if pt.fSelected then
										local vec3 = LM.Vector3:new_local()
										vec3:Set(pt.fPos.x, pt.fPos.y, 0)
										m:Transform(vec3)
										selectionBBox:AccumulatePoint(vec3)
									end
								end
							end
						end
					end

					local newPos = LM.Vector2:new_local()
					local v = selectionBBox:Center2D()
					if self.mode == 200 then
						local divisor = self.selectedMin.x - center.x
						local newX = self.centerVec.x
						local newY = self.centerVec.y + scaling.y * (self.centerVec.x - center.x) / divisor
						newPos:Set(newX, newY)

						if not (math.abs(newX) == math.huge or math.abs(newY) == math.huge) then
							self.pivotOffset:Set(newPos - v)
						end
					elseif self.mode == 201 then
						local divisor = self.selectedMax.x - center.x
						local newX = self.centerVec.x
						local newY = self.centerVec.y + scaling.y * (self.centerVec.x - center.x) / divisor
						newPos:Set(newX, newY)

						if not (math.abs(newX) == math.huge or math.abs(newY) == math.huge) then
							self.pivotOffset:Set(newPos - v)
						end
					elseif self.mode == 202 then
						local divisor = self.selectedMin.y - center.y
						local newX = self.centerVec.x + scaling.x * (self.centerVec.y - center.y) / divisor
						local newY = self.centerVec.y
						newPos:Set(newX, newY)

						if not (math.abs(newX) == math.huge or math.abs(newY) == math.huge) then
							self.pivotOffset:Set(newPos - v)
						end
					elseif self.mode == 203 then
						local divisor = self.selectedMax.y - center.y
						local newX = self.centerVec.x + scaling.x * (self.centerVec.y - center.y) / divisor
						local newY = self.centerVec.y
						newPos:Set(newX, newY)

						if not (math.abs(newX) == math.huge or math.abs(newY) == math.huge) then
							self.pivotOffset:Set(newPos - v)
						end
					end
				end

				if self.clusterList[i] then
					layer:UpdateCurFrame()
					for p, pt in ipairs(self.selList[i]) do
						pt.fPos = self.posList[i][p]
					end
				end

				local isWarpLayer = vectorLayer:IsWarpLayer()
				if self.fixedHandles and not isWarpLayer then
					mesh:PreserveHandlePositions(layerFrame)
				end
				if isWarpLayer then
					moho:AddPointKeyframe(moho.frame, layer)
					for p, pt in ipairs(self.selList[i]) do
						local delta = self.posList[i][p] - pt.fPos
						pt.fPos = self.posList[i][p] + delta
					end
					moho:AddPointKeyframe(moho.frame, layer)
				end
			end
		end
	end
end

function MR_AnimatePoints:RepairFixedHandles(moho)
	if not self.bezierList then
		return
	end
	local precision = 0.0000001

	for i = 1, #self.vectorLayersList do
		local layer = moho.document:LayerByAbsoluteID(self.vectorLayersList[i])
		if layer then
			local layerFrame = layer:DocToLayerFrame(moho.frame)
			local vectorLayer = moho:LayerAsVector(layer)
			if vectorLayer then
				if not vectorLayer:IsWarpLayer() then
					local mesh = vectorLayer:Mesh()
					for k, v in pairs(self.bezierList[i]) do
						local nextCurve = mesh:Curve(k)
						if nextCurve == nil then
							return
						end
						for n,p in pairs(v) do
							local point = nextCurve:Point(n)
							if not point then return end
							if not point.fSelected then
								local preVect = nextCurve:GetControlHandle(n, layerFrame, true)
								local postVect = nextCurve:GetControlHandle(n, layerFrame, false)
								local preChanged = ((p.pre - preVect):Mag()>precision)
								local postChanged = ((p.post - postVect):Mag()>precision)
								if preChanged or postChanged then
									for ind, isChanged in pairs({preChanged, postChanged}) do
										local isPreHandle = (ind == 1)
										local targetOffset = nextCurve:GetOffset(n, layerFrame, isPreHandle)
										local targetWeight = nextCurve:GetWeight(n, layerFrame, isPreHandle)
										local currentOffset = MR_Utilities:GetOffsetChannel(moho, layer, nextCurve, n, isPreHandle).value
										local currentWeight = MR_Utilities:GetWeightChannel(moho, layer, nextCurve, n, isPreHandle).value
										local offsetDelta = currentOffset - targetOffset

										if self.flipDirectionList[i][mesh:PointID(point) + 1] then
											offsetDelta = -currentOffset + targetOffset
										end
										nextCurve:SetOffset(n, targetOffset - offsetDelta, layerFrame, isPreHandle)
										local weightDelta = currentWeight - targetWeight
										nextCurve:SetWeight(n, targetWeight - weightDelta, layerFrame, isPreHandle)
										layer:UpdateCurFrame()
									end
								end
							end
						end
					end
				end	
			end
		end
	end
end

function MR_AnimatePoints:DrawCurve(moho, mouseEvent, layer, g, mesh, col, opacityMultiplier)
	local vectorLayer = moho:LayerAsVector(layer)
	local IsCurver = vectorLayer:IsCurver()
	if vectorLayer:IsWarpLayer() then
		local matrix = LM.Matrix:new_local()
		layer:GetFullTransform(moho.frame, matrix, moho.document)
		g:Push()
		g:ApplyMatrix(matrix)
		g:SetColor(col)
		for c = 0, mesh:CountCurves()-1 do
			local curve, pt = mesh:Curve(c)
			local isCurveVisible = true
			local isCurveSelected = false
			for p=0, curve:CountPoints()-1 do
				local curvePoint = curve:Point(p)
				if curvePoint.fHidden then
					isCurveVisible = false
				end
				if curvePoint.fSelected then
					isCurveSelected = true
				end
			end
			if isCurveVisible then
				if isCurveSelected then
					g:SetColor(col.r, col.g, col.b, 255 * opacityMultiplier)
				else
					g:SetColor(col.r, col.g, col.b, 150 * opacityMultiplier)
				end
				local steps = 10
				if not vectorLayer:IsCurver() then
					steps = 2
				end
				for e = 0, curve:CountSegments()-1 do
					local startPercent, endPercent = curve:GetSegmentRange(e)
					local step = (endPercent-startPercent) / steps
					local p1 = curve:GetPercentLocation(startPercent)
					for i=1, steps do
						local nextPercent = startPercent + step * i
						if nextPercent > endPercent then
							nextPercent = endPercent
						end
						local p2 = curve:GetPercentLocation(nextPercent)
						if IsCurver then
							g:DrawFatLine(5, p1.x, p1.y, p2.x, p2.y)
						else
							g:DrawFatLine(2, p1.x, p1.y, p2.x, p2.y)
						end
						p1:Set(p2)
					end
				end
			end
		end

		g:Pop()
	end
end

function MR_AnimatePoints:IsLayerValidForWarpMode(moho, layer)
	local isValid = false
	local vectorLayer = moho:LayerAsVector(layer)
	if vectorLayer then
		if (not layer:IsWarpLayer() and not self.warpMode) or (not layer:IsWarpLayer() and self.warpMode and moho.frame == 0) or (self.warpMode and layer:IsWarpLayer()) or layer == moho.layer then
			isValid = true
		end
	end
	return isValid
end

function MR_AnimatePoints:SelectAllPoints(moho, alt)
	local layersList = {}
	if next(self.isolatedLayerUUIDList) then
		for i, layerUUID in pairs(self.isolatedLayerUUIDList) do
			local targetLayerIndex = tonumber(i)-1
			local layer = moho.document:LayerByAbsoluteID(targetLayerIndex)
			if layer then
				if layer:UUID() == layerUUID then
					if self:IsLayerValidForWarpMode(moho, layer) then
						local isLayerOk = true
						if layer == moho.layer then
							isLayerOk = true
						elseif layer:IsWarpLayer() and self.warpMode then
							local layerSkeleton = layer:ControllingSkeleton()
							isLayerOk = MR_Utilities:IsLayerActive(moho, layer, layerSkeleton)
						elseif self.visibleLayersOnly then
							local layerSkeleton = layer:ControllingSkeleton()
							isLayerOk = MR_Utilities:IsLayerVisible(moho, layer, layerSkeleton, true)
						end
						if isLayerOk then
							table.insert(layersList, targetLayerIndex)
						end
					end
				end
			end
		end
	else
		layersList = self:ScanLayers(moho, true)
	end

	for l, layerIndex in ipairs(layersList) do
		local layer = moho.document:LayerByAbsoluteID(layerIndex)
		local vectorLayer = moho:LayerAsVector(layer)
		local mesh = vectorLayer:Mesh()

		if alt then
			mesh:SelectNone()
		else
			mesh:SelectAll()
		end
	end
	self.selectionMode = false
	self.twosModeValid = false
end

function MR_AnimatePoints:IsolateAllLayers(moho, alt)
	self.isolatedLayerUUIDList = {}

	local layersList = self:ScanLayers(moho, true)
	for l, layerIndex in ipairs(layersList) do
		local layer = moho.document:LayerByAbsoluteID(layerIndex)
		if layer then
			local vectorLayer = moho:LayerAsVector(layer)
			local layerUUID = layer:UUID()
			if not alt then
				self.isolatedLayerUUIDList[layerIndex+1] = layerUUID
			end
		end
	end

	self.selectionMode = false
	self.twosModeValid = false
end

function MR_AnimatePoints:Localize(text)
	local phrase = {}

	phrase['Description'] = 'hold <alt> to adjust radius or scale, hold <alt> + <shift> to adjust inner radius, <ctrl/cmd> to select points, isolate layers or scale, <shift> to blend, <enter> to select connected points'
	phrase['UILabel'] = 'MR Animate Points '..self:Version()

	phrase['Settings'] = 'Settings'
	phrase['Transform box mode'] = 'Transform box mode'
	phrase['Warp mode'] = 'Warp mode'
	phrase['Magnet mode'] = 'Magnet mode'
	phrase['Magnet radius'] = 'Radius'
	phrase['Inner radius'] = 'Inner radius'
	phrase['Isolate layers'] = 'Isolate layers'
	phrase['Select points'] = 'Select points'
	phrase['Selected points only'] = 'Move selected'
	phrase['Selected points only tooltip'] = 'Move selected points only'
	phrase['Lasso mode'] = 'Lasso'
	phrase['Show handles'] = 'Show handles'
	phrase['Fixed handles'] = 'Fixed handles'
	phrase['Select connected points'] = 'Select connected points (Enter) (Alt + Click to toggle auto curve selection)'
	phrase['Twos mode'] = 'Twos mode'
	phrase['Smart bake'] = 'Smart bake:'
	phrase['Ignore reference layers'] = 'Ignore reference layers'
	phrase['Update reference layers'] = 'Update reference layers'
	phrase['Update cached layers'] = 'Update cached layers'
	phrase['Keyframes settings'] = 'Keyframes settings'
	phrase['Keyframes to markers'] = 'Keyframes to markers'
	phrase['Markers to keyframes'] = 'Markers to keyframes'
	phrase['Copy frame'] = 'Copy frame'
	phrase['Paste frame'] = 'Paste frame (Alt + Click to paste on non-animated channels)'
	phrase['Copy previous key'] = 'Copy previous key (Alt + Click to key non-animated channels)'
	phrase['Create key'] = 'Create key (Alt + Click to key non-animated channels)'
	phrase['Copy next key'] = 'Copy next key (Alt + Click to key non-animated channels)'
	phrase['Reset points'] = 'Reset points (Alt + Click to reset curvature as well)'
	phrase['Delete points keyframe'] = 'Delete points keyframe'
	phrase['Clear points animation'] = 'Clear points animation (Alt + Click to clear all keyframes)'

	phrase['Selection slot 1'] = 'Selection slot 1 (Alt + Click to save selection)'
	phrase['Selection slot 2'] = 'Selection slot 2 (Alt + Click to save selection)'
	phrase['Selection slot 3'] = 'Selection slot 3 (Alt + Click to save selection)'
	phrase['Selection slot 4'] = 'Selection slot 4 (Alt + Click to save selection)'
	phrase['Selection slot 5'] = 'Selection slot 5 (Alt + Click to save selection)'

	phrase['Visible layers only'] = 'Visible layers only'
	phrase['Hide curves while dragging'] = 'Hide curves while dragging'
	phrase['Extra handles'] = 'Transform box extra handles'
	phrase['GUI color:'] = 'Viewport controls color:'
	phrase['Draw points'] = 'Draw points'
	phrase['Draw points while dragging'] = 'Draw points while dragging'
	phrase['Use single color'] = 'Use single color'
	phrase['Warp opacity'] = 'Warp opacity'
	phrase['Points opacity'] = 'Regular opacity'
	phrase['Points size'] = 'Points size'
	phrase['Sensitivity'] = 'Sensitivity'
	phrase['Blend sensitivity'] = 'Blend sensitivity'
	phrase['Block on even frames'] = 'Block on even frames'
	phrase['Block on odd frames'] = 'Block on odd frames'
	phrase['Auto update reference layers'] = 'Auto update reference layers'
	phrase['Long press time'] = 'Long press time'
	phrase['Reset settings'] = 'Reset settings'
	phrase['Open panel'] = 'Open panel'

	phrase['Process selected points only'] = 'Process selected points only'
	phrase['Process isolated layers only'] = 'Process isolated layers only'
	phrase['Process visible layers only'] = 'Process visible layers only'
	phrase['Consider warp mode'] = 'Consider warp mode'

	phrase['Convert interpolation'] = 'Convert'
	phrase['Interpolation'] = 'Interpolation'
	phrase['Interval'] = 'Interval'

	phrase['Smooth'] = 'Smooth'
	phrase['Linear'] = 'Linear'
	phrase['Step'] = 'Step'
	phrase['Noisy'] = 'Noisy'
	phrase['Inteval '] = 'Inteval '
	phrase['Convert'] = 'Convert'

	return phrase[text]
end