-- **************************************************
-- Provide Moho with the name of this script object
-- **************************************************

ScriptName = "MR_CreateOverlay"

-- **************************************************
-- General information about this script
-- **************************************************

MR_CreateOverlay = {}

function MR_CreateOverlay:Name()
	return self:Localize('UILabel')
end

function MR_CreateOverlay:Version()
	return '1.0'
end

function MR_CreateOverlay:UILabel()
	return self:Localize('UILabel')
end

function MR_CreateOverlay:Creator()
	return 'Eugene Babich'
end

function MR_CreateOverlay:Description()
	return self:Localize('Description')
end


-- **************************************************
-- Is Relevant / Is Enabled
-- **************************************************

function MR_CreateOverlay:IsRelevant(moho)
	return true
end

function MR_CreateOverlay:IsEnabled(moho)
	return true
end

-- **************************************************
-- The guts of this script
-- **************************************************

function MR_CreateOverlay:Run(moho)
	if MR_Overlay then
		local helper = MOHO.ScriptInterfaceHelper:new_local()
		local moho = helper:MohoObject()
		local document = moho.document
		if document then
			MR_Overlay:CreateOverlay(moho)
			local overlayLayer = MR_Overlay:CheckExistOverlayLayer(moho)
			if overlayLayer ~= nil and moho.document:IsLayerValid(overlayLayer) then
				overlayLayer:SetVisible(true)
				moho:UpdateUI()
				moho.view:DrawMe()
			end
		end
	end
end

-- **************************************************
-- Localization
-- **************************************************

function MR_CreateOverlay:Localize(text)
	local phrase = {}

	phrase['Description'] = 'Create overlay'
	phrase['UILabel'] = 'MR Create Overlay '..self:Version()

	return phrase[text]
end