-- **************************************************
-- Provide Moho with the name of this script object
-- **************************************************

ScriptName = "MR_CreatePath"

-- **************************************************
-- General information about this script
-- **************************************************

MR_CreatePath = {}

function MR_CreatePath:Name()
	return self:Localize('UILabel')
end

function MR_CreatePath:Version()
	return '1.0'
end

function MR_CreatePath:UILabel()
	return self:Localize('UILabel')
end

function MR_CreatePath:Creator()
	return 'Eugene Babich'
end

function MR_CreatePath:Description()
	return self:Localize('Description')
end


-- **************************************************
-- Is Relevant / Is Enabled
-- **************************************************

function MR_CreatePath:IsRelevant(moho)
	return true
end

function MR_CreatePath:IsEnabled(moho)
	return true
end

-- **************************************************
-- The guts of this script
-- **************************************************

function MR_CreatePath:Run(moho)
	if MR_Path then
		MR_Path:CreatePath(moho)
	end
end

-- **************************************************
-- Localization
-- **************************************************

function MR_CreatePath:Localize(text)
	local phrase = {}

	phrase['Description'] = 'Create path'
	phrase['UILabel'] = 'MR Create Path 1.0'

	local fileWord = MOHO.Localize("/Menus/File/File=File")
	return phrase[text]
end
