-- **************************************************
-- Provide Moho with the name of this script object
-- **************************************************

ScriptName = "MR_Overlay"

-- **************************************************
-- General information about this script
-- **************************************************

MR_Overlay = {}

function MR_Overlay:Name()
	return self:Localize('UILabel')
end

function MR_Overlay:Version()
	return '2.0.1'
end

function MR_Overlay:UILabel()
	return self:Localize('UILabel')
end

function MR_Overlay:Creator()
	return 'Eugene Babich'
end

function MR_Overlay:Description()
	return self:Localize('Description')
end

-- **************************************************
-- Is Relevant / Is Enabled
-- **************************************************

function MR_Overlay:IsRelevant(moho)
	return true
end

function MR_Overlay:IsEnabled(moho)
	if not self.mohoVersion then
		if MR_Utilities then
			local v1, v2, v3 = MR_Utilities:GetMohoVersion(moho)
			self.mohoVersion = v1
			self.mohoVersion2= v2
		end
	end

	if self.mohoVersion < 14 then
		return false
	elseif self.mohoVersion == 14 and self.mohoVersion2 < 1 then	
		return false
	end

	return true
end

-- **************************************************
-- Recurring Values
-- **************************************************

MR_Overlay.opacityValue = 50
MR_Overlay.shapesOverlay = true
MR_Overlay.bonesOverlay = false
MR_Overlay.pointsOverlay = false
MR_Overlay.showLayers = false
MR_Overlay.layer_1_opacityValue = 100
MR_Overlay.layer_2_opacityValue = 100
MR_Overlay.layer_3_opacityValue = 100
MR_Overlay.layer_4_opacityValue = 100
MR_Overlay.layer_5_opacityValue = 100
MR_Overlay.strokeWidth = 6
MR_Overlay.selectNewOverlayLayer = false
MR_Overlay.replaceOverlayLayer = true
MR_Overlay.useSeparateShapes = false
MR_Overlay.recolorShadeValue = 0.2
MR_Overlay.recolorStroke = false
MR_Overlay.recolorFill = false
MR_Overlay.drawStrokes = true
MR_Overlay.drawFills = true
MR_Overlay.changeStrokeWidth = false
MR_Overlay.makeShapesPlain = true
MR_Overlay.bonesLineWidth = 2
MR_Overlay.bonesWidth = 1
MR_Overlay.drawCenterLine = false
MR_Overlay.pinBoneRadius = 1
MR_Overlay.drawPinBoneCenterLines = false
MR_Overlay.selectedBonesOnly = true
MR_Overlay.drawHiddenBones = false
MR_Overlay.pointLineWidth = 2
MR_Overlay.drawCrosshair = true
MR_Overlay.crosshairRadius = 1
MR_Overlay.drawCircle = false
MR_Overlay.circleRadius = 1
MR_Overlay.selectedPointsOnly = true
MR_Overlay.drawHiddenPoints = false
MR_Overlay.needReopen = false

MR_Overlay.strokeColorR = 225
MR_Overlay.strokeColorG = 30
MR_Overlay.strokeColorB = 30
MR_Overlay.strokeColorA = 255

MR_Overlay.fillColorR = 225
MR_Overlay.fillColorG = 236
MR_Overlay.fillColorB = 223
MR_Overlay.fillColorA = 255

MR_Overlay.boneColorR = 222
MR_Overlay.boneColorG = 188
MR_Overlay.boneColorB = 0
MR_Overlay.boneColorA = 255

MR_Overlay.pointCrosshairColorR = 13
MR_Overlay.pointCrosshairColorG = 199
MR_Overlay.pointCrosshairColorB = 216
MR_Overlay.pointCrosshairColorA = 255

MR_Overlay.pointCircleColorR = 23
MR_Overlay.pointCircleColorG = 142
MR_Overlay.pointCircleColorB = 198
MR_Overlay.pointCircleColorA = 125

MR_Overlay.layerSuffix = '_Overlay'
MR_Overlay.doNotRender = true
MR_Overlay.selectedPoints = false

MR_Overlay.convertOverlay = false
MR_Overlay.overlayLayer = nil
MR_Overlay.flipOverlay = false
MR_Overlay.mirrorFlip = false
MR_Overlay.mirrorOverlayShade = false
MR_Overlay.selectionCenter = true
MR_Overlay.layerOriginCenter = false
MR_Overlay.customCenter = false
MR_Overlay.pickCustomCenter = false
MR_Overlay.customCenterValueX = 0
MR_Overlay.customCenterValueY = 0
MR_Overlay.createOverlayFromFrame = false
MR_Overlay.frameVal1 = 1
MR_Overlay.frameVal2 = 200
MR_Overlay.frameVal3 = 400
MR_Overlay.frameVal4 = 2
MR_Overlay.frameVal5 = 2
MR_Overlay.useFrame1 = true
MR_Overlay.useFrame2 = false
MR_Overlay.useFrame3 = false
MR_Overlay.useFrame4 = false
MR_Overlay.useFrame5 = false
MR_Overlay.layersToOverlay = {}
MR_Overlay.secondarySelection = {}
MR_Overlay.autoSelectShapesPoints = true
MR_Overlay.createOverlay = true
MR_Overlay.onlyOverlaySelected = false
MR_Overlay.useShapeForPivot = false
MR_Overlay.visibleLayersOnly = true
MR_Overlay.preserveStrokeAlpha = true
MR_Overlay.preserveFillAlpha = true
MR_Overlay.numVers = {}
MR_Overlay.bonesList = {}
MR_Overlay.bonesList.base = {}
MR_Overlay.bonesList.tip = {}
MR_Overlay.bonesList.isPin = {}
MR_Overlay.activeLayer = 1
MR_Overlay.layer_1_visibility = true
MR_Overlay.layer_2_visibility = true
MR_Overlay.layer_3_visibility = true
MR_Overlay.layer_4_visibility = true
MR_Overlay.layer_5_visibility = true
MR_Overlay.layer_1_useSavedSelection = false
MR_Overlay.layer_2_useSavedSelection = false
MR_Overlay.layer_3_useSavedSelection = false
MR_Overlay.layer_4_useSavedSelection = false
MR_Overlay.layer_5_useSavedSelection = false

-- Mode current values
MR_Overlay.shapesOverlayCur = true
MR_Overlay.bonesOverlayCur = false
MR_Overlay.pointsOverlayCur = false

-- Shapes current values
MR_Overlay.drawStrokesCur = true
MR_Overlay.changeStrokeWidthCur = false
MR_Overlay.strokeWidthCur = 6
MR_Overlay.recolorStrokeCur = false

MR_Overlay.strokeColorCurR = 225
MR_Overlay.strokeColorCurG = 30
MR_Overlay.strokeColorCurB = 30
MR_Overlay.strokeColorCurA = 255

MR_Overlay.preserveStrokeAlphaCur = true
MR_Overlay.drawFillsCur = true
MR_Overlay.recolorFillCur = false

MR_Overlay.fillColorCurR = 225
MR_Overlay.fillColorCurG = 236
MR_Overlay.fillColorCurB = 223
MR_Overlay.fillColorCurA = 255

MR_Overlay.preserveFillAlphaCur = true
MR_Overlay.makeShapesPlainCur = true
MR_Overlay.autoSelectShapesPointsCur = true

-- Bnes current values
MR_Overlay.bonesLineWidthCur = 2
MR_Overlay.bonesWidthCur = 1

MR_Overlay.boneColorCurR = 222
MR_Overlay.boneColorCurG = 188
MR_Overlay.boneColorCurB = 0
MR_Overlay.boneColorCurA = 255

MR_Overlay.drawCenterLineCur = false
MR_Overlay.pinBoneRadiusCur = 1
MR_Overlay.drawPinBoneCenterLinesCur = false
MR_Overlay.selectedBonesOnlyCur = true
MR_Overlay.drawHiddenBonesCur = false

-- Points current values
MR_Overlay.pointLineWidthCur = 6
MR_Overlay.drawCrosshairCur = true
MR_Overlay.crosshairRadiusCur = 1

MR_Overlay.pointCrosshairColorCurR = 13
MR_Overlay.pointCrosshairColorCurG = 199
MR_Overlay.pointCrosshairColorCurB = 216
MR_Overlay.pointCrosshairColorCurA = 255

MR_Overlay.drawCircleCur = false
MR_Overlay.circleRadiusCur = 1

MR_Overlay.pointCircleColorCurR = 23
MR_Overlay.pointCircleColorCurG = 142
MR_Overlay.pointCircleColorCurB = 198
MR_Overlay.pointCircleColorCurA = 125

MR_Overlay.selectedPointsOnlyCur = true
MR_Overlay.drawHiddenPointsCur = false

-- **************************************************
-- Prefs
-- **************************************************

function MR_Overlay:LoadPrefs(prefs)
	self.opacityValue = prefs:GetInt("MR_Overlay.opacityValue", 50)
	self.shapesOverlay = prefs:GetBool("MR_Overlay.shapesOverlay", true)
	self.bonesOverlay = prefs:GetBool("MR_Overlay.bonesOverlay", false)
	self.pointsOverlay = prefs:GetBool("MR_Overlay.pointsOverlay", false)
	self.showLayers = prefs:GetBool("MR_Overlay.showLayers", false)
	self.strokeWidth = prefs:GetFloat("MR_Overlay.strokeWidth", 6)
	self.doNotRender = prefs:GetBool("MR_Overlay.doNotRender", true)
    self.selectNewOverlayLayer = prefs:GetBool("MR_Overlay.selectNewOverlayLayer", false)
    self.replaceOverlayLayer = prefs:GetBool("MR_Overlay.replaceOverlayLayer", false)
    self.useSeparateShapes = prefs:GetBool("MR_Overlay.useSeparateShapes", false)
	self.recolorShadeValue = prefs:GetFloat("MR_Overlay.recolorShadeValue", 0.2)
    self.recolorStroke = prefs:GetBool("MR_Overlay.recolorStroke", false)
    self.recolorFill = prefs:GetBool("MR_Overlay.recolorFill", false)
    self.drawStrokes = prefs:GetBool("MR_Overlay.drawStrokes", true)
    self.drawFills = prefs:GetBool("MR_Overlay.drawFills", true)
    self.changeStrokeWidth = prefs:GetBool("MR_Overlay.changeStrokeWidth", false)
	self.makeShapesPlain = prefs:GetBool("MR_Overlay.makeShapesPlain", true)
	self.strokeColorR = prefs:GetInt("MR_Overlay.strokeColorR", 225)
	self.strokeColorG = prefs:GetInt("MR_Overlay.strokeColorG", 30)
	self.strokeColorB = prefs:GetInt("MR_Overlay.strokeColorB", 30)
	self.strokeColorA = prefs:GetInt("MR_Overlay.strokeColorA", 255)
	self.fillColorR = prefs:GetInt("MR_Overlay.fillColorR", 225)
	self.fillColorG = prefs:GetInt("MR_Overlay.fillColorG", 236)
	self.fillColorB = prefs:GetInt("MR_Overlay.fillColorB", 223)
	self.fillColorA = prefs:GetInt("MR_Overlay.fillColorA", 255)
	self.boneColorR = prefs:GetInt("MR_Overlay.boneColorR", 222)
	self.boneColorG = prefs:GetInt("MR_Overlay.boneColorG", 188)
	self.boneColorB = prefs:GetInt("MR_Overlay.boneColorB", 0)
	self.boneColorA = prefs:GetInt("MR_Overlay.boneColorA", 255)
	self.pointCrosshairColorR = prefs:GetInt("MR_Overlay.pointCrosshairColorR", 13)
	self.pointCrosshairColorG = prefs:GetInt("MR_Overlay.pointCrosshairColorG", 199)
	self.pointCrosshairColorB = prefs:GetInt("MR_Overlay.pointCrosshairColorB", 216)
	self.pointCrosshairColorA = prefs:GetInt("MR_Overlay.pointCrosshairColorA", 255)
	self.pointCircleColorR = prefs:GetInt("MR_Overlay.pointCircleColorR", 23)
	self.pointCircleColorG = prefs:GetInt("MR_Overlay.pointCircleColorG", 142)
	self.pointCircleColorB = prefs:GetInt("MR_Overlay.pointCircleColorB", 198)
	self.pointCircleColorA = prefs:GetInt("MR_Overlay.pointCircleColorA", 255)
    self.flipOverlay = prefs:GetBool("MR_Overlay.flipOverlay", false)
    self.selectionCenter = prefs:GetBool("MR_Overlay.selectionCenter", true)
    self.layerOriginCenter = prefs:GetBool("MR_Overlay.layerOriginCenter", false)
    self.customCenter = prefs:GetBool("MR_Overlay.customCenter", false)
    self.pickCustomCenter = prefs:GetBool("MR_Overlay.pickCustomCenter", false)
    self.customCenterValueX = prefs:GetFloat("MR_Overlay.customCenterValueX", 0)
    self.customCenterValueY = prefs:GetFloat("MR_Overlay.customCenterValueY", 0)
	self.createOverlayFromFrame = prefs:GetBool("MR_Overlay.createOverlayFromFrame", false)
	self.frameVal1 = prefs:GetInt("MR_Overlay.frameVal1", 1)
	self.frameVal2 = prefs:GetInt("MR_Overlay.frameVal2", 200)
	self.frameVal3 = prefs:GetInt("MR_Overlay.frameVal3", 400)
	self.frameVal4 = prefs:GetInt("MR_Overlay.frameVal4", 2)	
	self.frameVal5 = prefs:GetInt("MR_Overlay.frameVal5", 2)
	self.useFrame1 = prefs:GetBool("MR_Overlay.useFrame1", true)
	self.useFrame2 = prefs:GetBool("MR_Overlay.useFrame2", false)
	self.useFrame3 = prefs:GetBool("MR_Overlay.useFrame3", false)
	self.useFrame4 = prefs:GetBool("MR_Overlay.useFrame4", false)
	self.useFrame5 = prefs:GetBool("MR_Overlay.useFrame5", false)
	self.autoSelectShapesPoints = prefs:GetBool("MR_Overlay.autoSelectShapesPoints", true)
	self.createOverlay = prefs:GetBool("MR_Overlay.createOverlay", true)
	self.mirrorFlip = prefs:GetBool("MR_Overlay.mirrorFlip", false)
	self.mirrorOverlayShade = prefs:GetBool("MR_Overlay.mirrorOverlayShade", false)
	self.useShapeForPivot = prefs:GetBool("MR_Overlay.useShapeForPivot", false)
	self.visibleLayersOnly = prefs:GetBool("MR_Overlay.visibleLayersOnly", true)
	self.preserveStrokeAlpha = prefs:GetBool("MR_Overlay.preserveStrokeAlpha", true)
	self.preserveFillAlpha = prefs:GetBool("MR_Overlay.preserveFillAlpha", true)
	self.bonesLineWidth = prefs:GetFloat("MR_Overlay.bonesLineWidth", 2)
	self.bonesWidth = prefs:GetFloat("MR_Overlay.bonesWidth", 1)
	self.drawCenterLine = prefs:GetBool("MR_Overlay.drawCenterLine", false)
	self.pinBoneRadius = prefs:GetFloat("MR_Overlay.pinBoneRadius", 1)
	self.drawPinBoneCenterLines = prefs:GetBool("MR_Overlay.drawPinBoneCenterLines", false)
	self.selectedBonesOnly = prefs:GetBool("MR_Overlay.selectedBonesOnly", true)
	self.drawHiddenBones = prefs:GetBool("MR_Overlay.drawHiddenBones", false)
	self.pointLineWidth = prefs:GetFloat("MR_Overlay.pointLineWidth", 2)
	self.drawCrosshair = prefs:GetBool("MR_Overlay.drawCrosshair", true)
	self.crosshairRadius = prefs:GetFloat("MR_Overlay.crosshairRadius", 1)
	self.drawCircle = prefs:GetBool("MR_Overlay.drawCircle", false)
	self.circleRadius = prefs:GetFloat("MR_Overlay.circleRadius", 1)
	self.selectedPointsOnly = prefs:GetBool("MR_Overlay.selectedPointsOnly", true)
	self.drawHiddenPoints = prefs:GetBool("MR_Overlay.drawHiddenPoints", false)
end

function MR_Overlay:SavePrefs(prefs)
	prefs:SetInt("MR_Overlay.opacityValue", self.opacityValue)
	prefs:SetBool("MR_Overlay.shapesOverlay", self.shapesOverlay)
	prefs:SetBool("MR_Overlay.bonesOverlay", self.bonesOverlay)
	prefs:SetBool("MR_Overlay.pointsOverlay", self.pointsOverlay)
	prefs:SetBool("MR_Overlay.showLayers", self.showLayers)
	prefs:SetFloat("MR_Overlay.strokeWidth", self.strokeWidth)
	prefs:SetBool("MR_Overlay.doNotRender", self.doNotRender)
    prefs:SetBool("MR_Overlay.selectNewOverlayLayer", self.selectNewOverlayLayer)
    prefs:SetBool("MR_Overlay.replaceOverlayLayer", self.replaceOverlayLayer)
    prefs:SetBool("MR_Overlay.useSeparateShapes", self.useSeparateShapes)
	prefs:SetFloat("MR_Overlay.recolorShadeValue", self.recolorShadeValue)
    prefs:SetBool("MR_Overlay.recolorStroke", self.recolorStroke)
    prefs:SetBool("MR_Overlay.recolorFill", self.recolorFill)
    prefs:SetBool("MR_Overlay.drawStrokes", self.drawStrokes)
    prefs:SetBool("MR_Overlay.drawFills", self.drawFills)
    prefs:SetBool("MR_Overlay.changeStrokeWidth", self.changeStrokeWidth)
	prefs:SetBool("MR_Overlay.makeShapesPlain", self.makeShapesPlain)
	prefs:SetInt("MR_Overlay.strokeColorR", self.strokeColorR)
	prefs:SetInt("MR_Overlay.strokeColorG", self.strokeColorG)
	prefs:SetInt("MR_Overlay.strokeColorB", self.strokeColorB)
	prefs:SetInt("MR_Overlay.strokeColorA", self.strokeColorA)
	prefs:SetInt("MR_Overlay.fillColorR", self.fillColorR)
	prefs:SetInt("MR_Overlay.fillColorG", self.fillColorG)
	prefs:SetInt("MR_Overlay.fillColorB", self.fillColorB)
	prefs:SetInt("MR_Overlay.fillColorA", self.fillColorA)
	prefs:SetInt("MR_Overlay.boneColorR", self.boneColorR)
	prefs:SetInt("MR_Overlay.boneColorG", self.boneColorG)
	prefs:SetInt("MR_Overlay.boneColorB", self.boneColorB)
	prefs:SetInt("MR_Overlay.boneColorA", self.boneColorA)
	prefs:SetInt("MR_Overlay.pointCrosshairColorR", self.pointCrosshairColorR)
	prefs:SetInt("MR_Overlay.pointCrosshairColorG", self.pointCrosshairColorG)
	prefs:SetInt("MR_Overlay.pointCrosshairColorB", self.pointCrosshairColorB)
	prefs:SetInt("MR_Overlay.pointCrosshairColorA", self.pointCrosshairColorA)
	prefs:SetInt("MR_Overlay.pointCircleColorR", self.pointCircleColorR)
	prefs:SetInt("MR_Overlay.pointCircleColorG", self.pointCircleColorG)
	prefs:SetInt("MR_Overlay.pointCircleColorB", self.pointCircleColorB)
	prefs:SetInt("MR_Overlay.pointCircleColorA", self.pointCircleColorA)
    prefs:SetBool("MR_Overlay.flipOverlay", self.flipOverlay)
    prefs:SetBool("MR_Overlay.selectionCenter", self.selectionCenter)
    prefs:SetBool("MR_Overlay.layerOriginCenter", self.layerOriginCenter)
    prefs:SetBool("MR_Overlay.customCenter", self.customCenter)
    prefs:SetBool("MR_Overlay.pickCustomCenter", self.pickCustomCenter)
    prefs:SetFloat("MR_Overlay.customCenterValueX", self.customCenterValueX)
    prefs:SetFloat("MR_Overlay.customCenterValueY", self.customCenterValueY)
	prefs:SetBool("MR_Overlay.createOverlayFromFrame", self.createOverlayFromFrame)
	prefs:SetInt("MR_Overlay.frameVal1", self.frameVal1)
	prefs:SetInt("MR_Overlay.frameVal2", self.frameVal2)
	prefs:SetInt("MR_Overlay.frameVal3", self.frameVal3)
	prefs:SetInt("MR_Overlay.frameVal4", self.frameVal4)
	prefs:SetInt("MR_Overlay.frameVal5", self.frameVal5)
	prefs:SetBool("MR_Overlay.useFrame1", self.useFrame1)
	prefs:SetBool("MR_Overlay.useFrame2", self.useFrame2)
	prefs:SetBool("MR_Overlay.useFrame3", self.useFrame3)
	prefs:SetBool("MR_Overlay.useFrame4", self.useFrame4)
	prefs:SetBool("MR_Overlay.useFrame5", self.useFrame5)
	prefs:SetBool("MR_Overlay.autoSelectShapesPoints", self.autoSelectShapesPoints)
	prefs:SetBool("MR_Overlay.createOverlay", self.createOverlay)
	prefs:SetBool("MR_Overlay.mirrorFlip", self.mirrorFlip)
	prefs:SetBool("MR_Overlay.mirrorOverlayShade", self.mirrorOverlayShade)
	prefs:SetBool("MR_Overlay.useShapeForPivot", self.useShapeForPivot)
	prefs:SetBool("MR_Overlay.visibleLayersOnly", self.visibleLayersOnly)
	prefs:SetBool("MR_Overlay.preserveStrokeAlpha", self.preserveStrokeAlpha)
	prefs:SetBool("MR_Overlay.preserveFillAlpha", self.preserveFillAlpha)
	prefs:SetFloat("MR_Overlay.bonesLineWidth", self.bonesLineWidth)
	prefs:SetFloat("MR_Overlay.bonesWidth", self.bonesWidth)
	prefs:SetBool("MR_Overlay.drawCenterLine", self.drawCenterLine)
	prefs:SetFloat("MR_Overlay.pinBoneRadius", self.pinBoneRadius)
	prefs:SetBool("MR_Overlay.drawPinBoneCenterLines", self.drawPinBoneCenterLines)
	prefs:SetBool("MR_Overlay.selectedBonesOnly", self.selectedBonesOnly)
	prefs:SetBool("MR_Overlay.drawHiddenBones", self.drawHiddenBones)
	prefs:SetFloat("MR_Overlay.pointLineWidth", self.pointLineWidth)
	prefs:SetBool("MR_Overlay.drawCrosshair", self.drawCrosshair)
	prefs:SetFloat("MR_Overlay.crosshairRadius", self.crosshairRadius)
	prefs:SetBool("MR_Overlay.drawCircle", self.drawCircle)
	prefs:SetFloat("MR_Overlay.circleRadius", self.circleRadius)
	prefs:SetBool("MR_Overlay.selectedPointsOnly", self.selectedPointsOnly)
	prefs:SetBool("MR_Overlay.drawHiddenPoints", self.drawHiddenPoints)
end

function MR_Overlay:ResetPrefs()
	self.opacityValue = 50
	self.shapesOverlay = true
	self.bonesOverlay = false
	self.pointsOverlay = false
	self.showLayers = false
	self.strokeWidth = 6
	self.doNotRender = true
    self.selectNewOverlayLayer = false
    self.replaceOverlayLayer = true
    self.useSeparateShapes = false
	self.recolorShadeValue = 0.2
    self.recolorStroke = false
    self.recolorFill = false
    self.drawStrokes = true
    self.drawFills = true
    self.changeStrokeWidth = false
	self.makeShapesPlain = true
	self.strokeColorR = 225
	self.strokeColorG = 30
	self.strokeColorB = 30
	self.strokeColorA = 255
	self.fillColorR = 225
	self.fillColorG = 236
	self.fillColorB = 223
	self.fillColorA = 255
	self.boneColorR = 222
	self.boneColorG = 188
	self.boneColorB = 0
	self.boneColorA = 255
	self.pointCrosshairColorR = 13
	self.pointCrosshairColorG = 199
	self.pointCrosshairColorB = 216
	self.pointCrosshairColorA = 255
	self.pointCircleColorR = 23
	self.pointCircleColorG = 142
	self.pointCircleColorB = 198
	self.pointCircleColorA = 125
    self.flipOverlay = false
    self.selectionCenter = true
    self.layerOriginCenter = false
    self.customCenter = false
    self.pickCustomCenter = false
    self.customCenterValueX = 0
    self.customCenterValueY = 0
    self.createOverlayFromFrame = false
    self.frameVal1 = 1
    self.frameVal2 = 200
    self.frameVal3 = 400
	self.frameVal4 = 2
	self.frameVal5 = 2
    self.useFrame1 = true
    self.useFrame2 = false
    self.useFrame3 = false
    self.useFrame4 = false
	self.useFrame5 = false
    self.autoSelectShapesPoints = true
    self.createOverlay = true
    self.mirrorFlip = false
	self.mirrorOverlayShade = false
    self.useShapeForPivot = false
    self.visibleLayersOnly = true
    self.preserveStrokeAlpha = true
    self.preserveFillAlpha = true
    self.bonesLineWidth = 2
    self.bonesWidth = 1
    self.drawCenterLine = false
    self.pinBoneRadius = 1
    self.drawPinBoneCenterLines = false
    self.selectedBonesOnly = true
    self.drawHiddenBones = false
    self.pointLineWidth = 2
    self.drawCrosshair = true
    self.crosshairRadius = 1
    self.drawCircle = false
    self.circleRadius = 1
    self.selectedPointsOnly = true
    self.drawHiddenPoints = false
end

function MR_OverlayUpdateDialog(moho)
	if MR_Overlay.overlayDlog ~= nil then
		MR_Overlay.overlayDlog:UpdateWidgets()
	end
end

table.insert(MOHO.UpdateTable, MR_OverlayUpdateDialog)

-- **************************************************
-- MR_OverlayShapesDialog
-- **************************************************

local MR_OverlayShapesDialog = {}

MR_OverlayShapesDialog.DRAW_STROKES = MOHO.MSG_BASE + 1
MR_OverlayShapesDialog.CHANGE_STROKE_WIDTH = MOHO.MSG_BASE + 2
MR_OverlayShapesDialog.STROKE_WIDTH = MOHO.MSG_BASE + 3
MR_OverlayShapesDialog.RECOLOR_STROKES = MOHO.MSG_BASE + 4
MR_OverlayShapesDialog.STROKE_COLOR = MOHO.MSG_BASE + 5
MR_OverlayShapesDialog.RANDOMIZE_STROKE_COLOR = MOHO.MSG_BASE + 6
MR_OverlayShapesDialog.RANDOMIZE_STROKE_COLOR_ALT = MOHO.MSG_BASE + 7
MR_OverlayShapesDialog.PRESERVE_STROKES_ALPHA = MOHO.MSG_BASE + 8
MR_OverlayShapesDialog.DRAW_FILLS = MOHO.MSG_BASE + 9
MR_OverlayShapesDialog.RECOLOR_FILL = MOHO.MSG_BASE + 10
MR_OverlayShapesDialog.FILL_COLOR = MOHO.MSG_BASE + 11
MR_OverlayShapesDialog.RANDOMIZE_FILL_COLOR = MOHO.MSG_BASE + 12
MR_OverlayShapesDialog.RANDOMIZE_FILL_COLOR_ALT = MOHO.MSG_BASE + 13
MR_OverlayShapesDialog.PRESERVE_FILL_ALPHA = MOHO.MSG_BASE + 14
MR_OverlayShapesDialog.MAKE_SHAPES_PLAIN = MOHO.MSG_BASE + 15
MR_OverlayShapesDialog.AUTO_SELECT_POINTS = MOHO.MSG_BASE + 16
MR_OverlayShapesDialog.RESET = MOHO.MSG_BASE + 17

function MR_OverlayShapesDialog:new(moho)
    local d = LM.GUI.SimpleDialog(MR_Overlay:Localize('UILabel'), MR_OverlayShapesDialog)
    local l = d:GetLayout()
	
	d.drawStrokesCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Draw strokes'), self.DRAW_STROKES)
	l:AddChild(d.drawStrokesCheck, LM.GUI.ALIGN_LEFT, 0)

	d.changeStrokeWidthCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Change stroke width'), self.CHANGE_STROKE_WIDTH)
	l:AddChild(d.changeStrokeWidthCheck, LM.GUI.ALIGN_LEFT, 0)
	
	d.strokeWidthInput = LM.GUI.TextControl(0, '100', self.STROKE_WIDTH, LM.GUI.FIELD_FLOAT, MR_Overlay:Localize('Stroke width'))
	l:AddChild(d.strokeWidthInput, LM.GUI.ALIGN_LEFT, 0)

	d.recolorStrokesCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Recolor strokes'), self.RECOLOR_STROKES)
	l:AddChild(d.recolorStrokesCheck, LM.GUI.ALIGN_LEFT, 0)
	
	l:PushH()
		d.strokeColorSwatch = LM.GUI.ShortColorSwatch(true, self.STROKE_COLOR)
		l:AddChild(d.strokeColorSwatch, LM.GUI.ALIGN_LEFT)
		d.strokeColorSwatch:SetToolTip(MR_Overlay:Localize('Recolor Stroke Tooltip'))

		d.randomizeStrokeColorButton = LM.GUI.Button(MR_Overlay:Localize('Randomize'), self.RANDOMIZE_STROKE_COLOR)
		d.randomizeStrokeColorButton:SetAlternateMessage(self.RANDOMIZE_STROKE_COLOR_ALT)
		l:AddChild(d.randomizeStrokeColorButton, LM.GUI.ALIGN_FILL, 0)
	l:Pop()

	d.preserveStrokesAlphaCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Preserve strokes alpha'), self.PRESERVE_STROKES_ALPHA)
	l:AddChild(d.preserveStrokesAlphaCheck, LM.GUI.ALIGN_LEFT, 0)
	
	l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

	d.drawFillsCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Draw fills'), self.DRAW_FILLS)
	l:AddChild(d.drawFillsCheck, LM.GUI.ALIGN_LEFT, 0)
	
	d.recolorFillCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Recolor fill'), self.RECOLOR_FILL)
	l:AddChild(d.recolorFillCheck, LM.GUI.ALIGN_LEFT, 0)
	
	l:PushH()
		d.fillColorSwatch = LM.GUI.ShortColorSwatch(true, self.FILL_COLOR)
		l:AddChild(d.fillColorSwatch, LM.GUI.ALIGN_LEFT)
		d.fillColorSwatch:SetToolTip(MR_Overlay:Localize('Recolor Fill Tooltip'))

		d.randomizeFillColorButton = LM.GUI.Button(MR_Overlay:Localize('Randomize'), self.RANDOMIZE_FILL_COLOR)
		d.randomizeFillColorButton:SetAlternateMessage(self.RANDOMIZE_FILL_COLOR_ALT)
		l:AddChild(d.randomizeFillColorButton, LM.GUI.ALIGN_FILL, 0)
	l:Pop()

	d.preserveFillAlphaCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Preserve fills alpha'), self.PRESERVE_FILL_ALPHA)
	l:AddChild(d.preserveFillAlphaCheck, LM.GUI.ALIGN_LEFT, 0)

	l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

	d.makeShapesPlainCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Make shapes plain'), self.MAKE_SHAPES_PLAIN)
	l:AddChild(d.makeShapesPlainCheck, LM.GUI.ALIGN_LEFT, 0)

	l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

	d.autoSelectShapesPointsCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Auto Select Points'), self.AUTO_SELECT_POINTS)
	l:AddChild(d.autoSelectShapesPointsCheck, LM.GUI.ALIGN_LEFT, 0)

	d.resetButton = LM.GUI.ShortButton(MR_Overlay:Localize('Reset'), self.RESET)
	l:AddChild(d.resetButton, LM.GUI.ALIGN_FILL, 0)

	return d
end	

function MR_OverlayShapesDialog:UpdateWidgets(moho)
	self.drawStrokesCheck:SetValue(MR_Overlay.drawStrokes)
	self.changeStrokeWidthCheck:SetValue(MR_Overlay.changeStrokeWidth)
	self.changeStrokeWidthCheck:Enable(MR_Overlay.drawStrokes)
	self.strokeWidthInput:SetValue(MR_Overlay.strokeWidth)
	self.strokeWidthInput:Enable(MR_Overlay.changeStrokeWidth and MR_Overlay.drawStrokes)
	self.recolorStrokesCheck:SetValue(MR_Overlay.recolorStroke)
	self.recolorStrokesCheck:Enable(MR_Overlay.drawStrokes)
	self.makeShapesPlainCheck:SetValue(MR_Overlay.makeShapesPlain)
	
	local strokeColor = LM.rgb_color:new_local()
	strokeColor.r = MR_Overlay.strokeColorR
	strokeColor.g = MR_Overlay.strokeColorG
	strokeColor.b = MR_Overlay.strokeColorB
	strokeColor.a = MR_Overlay.strokeColorA
	
	self.strokeColorSwatch:SetValue(strokeColor)
	self.strokeColorSwatch:Enable(MR_Overlay.recolorStroke and MR_Overlay.drawStrokes)
	self.randomizeStrokeColorButton:Enable(MR_Overlay.recolorStroke and MR_Overlay.drawStrokes)

	self.preserveStrokesAlphaCheck:SetValue(MR_Overlay.preserveStrokeAlpha)
	self.preserveStrokesAlphaCheck:Enable(MR_Overlay.recolorStroke and MR_Overlay.drawStrokes)
	
	self.drawFillsCheck:SetValue(MR_Overlay.drawFills)

	self.recolorFillCheck:SetValue(MR_Overlay.recolorFill)
	self.recolorFillCheck:Enable(MR_Overlay.drawFills)
	self.randomizeFillColorButton:Enable(MR_Overlay.recolorFill and MR_Overlay.drawFills)
	
	local fillColor = LM.rgb_color:new_local()
	fillColor.r = MR_Overlay.fillColorR
	fillColor.g = MR_Overlay.fillColorG
	fillColor.b = MR_Overlay.fillColorB
	fillColor.a = MR_Overlay.fillColorA
	
	self.fillColorSwatch:SetValue(fillColor)
	self.fillColorSwatch:Enable(MR_Overlay.recolorFill and MR_Overlay.drawFills)

	self.preserveFillAlphaCheck:SetValue(MR_Overlay.preserveFillAlpha)
	self.preserveFillAlphaCheck:Enable(MR_Overlay.recolorFill and MR_Overlay.drawFills)

	self.autoSelectShapesPointsCheck:SetValue(MR_Overlay.autoSelectShapesPoints)
end

function MR_OverlayShapesDialog:HandleMessage(msg)
	if msg == self.DRAW_STROKES then
		MR_Overlay.drawStrokes = self.drawStrokesCheck:Value()
		if not MR_Overlay.drawFills then
			MR_Overlay.drawStrokes = true
			self.drawStrokesCheck:SetValue(true)
		end
		self.changeStrokeWidthCheck:Enable(MR_Overlay.drawStrokes)
		self.strokeWidthInput:Enable(MR_Overlay.changeStrokeWidth and MR_Overlay.drawStrokes)
		self.recolorStrokesCheck:Enable(MR_Overlay.drawStrokes)
		self.strokeColorSwatch:Enable(MR_Overlay.recolorStroke and MR_Overlay.drawStrokes)
		self.preserveStrokesAlphaCheck:Enable(MR_Overlay.recolorStroke and MR_Overlay.drawStrokes)
		self.randomizeStrokeColorButton:Enable(MR_Overlay.recolorStroke and MR_Overlay.drawStrokes)
	elseif msg == self.CHANGE_STROKE_WIDTH then
		MR_Overlay.changeStrokeWidth = self.changeStrokeWidthCheck:Value()
		self.strokeWidthInput:Enable(MR_Overlay.changeStrokeWidth)
	elseif msg == self.STROKE_WIDTH then
		MR_Overlay.strokeWidth = LM.Clamp(self.strokeWidthInput:FloatValue(), 0.25, 256)
		self.strokeWidthInput:SetValue(MR_Overlay.strokeWidth)
	elseif msg == self.RECOLOR_STROKES then
		MR_Overlay.recolorStroke = self.recolorStrokesCheck:Value()
		self.preserveStrokesAlphaCheck:Enable(MR_Overlay.recolorStroke)
		self.strokeColorSwatch:Enable(MR_Overlay.recolorStroke)
		self.randomizeStrokeColorButton:Enable(MR_Overlay.recolorStroke)
	elseif msg == self.STROKE_COLOR then
		local colorSwatchValue = self.strokeColorSwatch:Value()
		MR_Overlay.strokeColorR = colorSwatchValue.r
		MR_Overlay.strokeColorG = colorSwatchValue.g
		MR_Overlay.strokeColorB = colorSwatchValue.b
		MR_Overlay.strokeColorA = colorSwatchValue.a
	elseif msg == self.RANDOMIZE_STROKE_COLOR then
		local oldColor = self.strokeColorSwatch:Value()
		local newColor = MR_Utilities:GenerateDistinctColor(oldColor)
		newColor.a = oldColor.a
		MR_Overlay.strokeColorR = newColor.r
		MR_Overlay.strokeColorG = newColor.g
		MR_Overlay.strokeColorB = newColor.b
		MR_Overlay.strokeColorA = newColor.a
		self:UpdateWidgets()
	elseif msg == self.RANDOMIZE_STROKE_COLOR_ALT then
		local oldColor = self.strokeColorSwatch:Value()
		local newColor = MR_Utilities:RandomizeBrightness(oldColor)
		newColor.a = oldColor.a
		MR_Overlay.strokeColorR = newColor.r
		MR_Overlay.strokeColorG = newColor.g
		MR_Overlay.strokeColorB = newColor.b
		MR_Overlay.strokeColorA = newColor.a
		self:UpdateWidgets()
	elseif msg == self.DRAW_FILLS then
		MR_Overlay.drawFills = self.drawFillsCheck:Value()
		if not MR_Overlay.drawStrokes then
			MR_Overlay.drawFills = true
			self.drawFillsCheck:SetValue(true)
		end
		self.recolorFillCheck:Enable(MR_Overlay.drawFills)
		self.preserveFillAlphaCheck:Enable(MR_Overlay.drawFills and  MR_Overlay.recolorFill)
		self.fillColorSwatch:Enable(MR_Overlay.drawFills and MR_Overlay.recolorFill)
		self.randomizeFillColorButton:Enable(MR_Overlay.recolorFill and MR_Overlay.drawFills)
	elseif msg == self.RECOLOR_FILL then
		MR_Overlay.recolorFill = self.recolorFillCheck:Value()
		self.preserveFillAlphaCheck:Enable(MR_Overlay.recolorFill)
		self.fillColorSwatch:Enable(MR_Overlay.recolorFill)
		self.randomizeFillColorButton:Enable(MR_Overlay.recolorFill)
	elseif msg == self.FILL_COLOR then
		local colorSwatchValue = self.fillColorSwatch:Value()
		MR_Overlay.fillColorR = colorSwatchValue.r
		MR_Overlay.fillColorG = colorSwatchValue.g
		MR_Overlay.fillColorB = colorSwatchValue.b
		MR_Overlay.fillColorA = colorSwatchValue.a
	elseif msg == self.RANDOMIZE_FILL_COLOR then
		local oldColor = self.fillColorSwatch:Value()
		local newColor = MR_Utilities:GenerateDistinctColor(oldColor)
		newColor.a = oldColor.a
		MR_Overlay.fillColorR = newColor.r
		MR_Overlay.fillColorG = newColor.g
		MR_Overlay.fillColorB = newColor.b
		MR_Overlay.fillColorA = newColor.a
		self:UpdateWidgets()
	elseif msg == self.RANDOMIZE_FILL_COLOR_ALT then
		local oldColor = self.fillColorSwatch:Value()
		local newColor = MR_Utilities:RandomizeBrightness(oldColor)
		newColor.a = oldColor.a
		MR_Overlay.fillColorR = newColor.r
		MR_Overlay.fillColorG = newColor.g
		MR_Overlay.fillColorB = newColor.b
		MR_Overlay.fillColorA = newColor.a
		self:UpdateWidgets()
	elseif msg == self.PRESERVE_STROKES_ALPHA then
		MR_Overlay.preserveStrokeAlpha = self.preserveStrokesAlphaCheck:Value()
	elseif msg == self.PRESERVE_FILL_ALPHA then
		MR_Overlay.preserveFillAlpha = self.preserveFillAlphaCheck:Value()
	elseif msg == self.MAKE_SHAPES_PLAIN then
		MR_Overlay.makeShapesPlain = self.makeShapesPlainCheck:Value()
	elseif msg == self.AUTO_SELECT_POINTS then
		MR_Overlay.autoSelectShapesPoints = self.autoSelectShapesPointsCheck:Value()
	elseif msg == self.RESET then
		MR_Overlay.recolorStroke = false
		MR_Overlay.recolorFill = false
		MR_Overlay.drawStrokes = true
		MR_Overlay.drawFills = true
		MR_Overlay.changeStrokeWidth = false
		MR_Overlay.strokeWidth = 6
		MR_Overlay.preserveStrokeAlpha = true
		MR_Overlay.preserveFillAlpha = true
		MR_Overlay.makeShapesPlain = true
		MR_Overlay.autoSelectShapesPoints = true
		MR_Overlay.strokeColorR = 225
		MR_Overlay.strokeColorG = 30
		MR_Overlay.strokeColorB = 30
		MR_Overlay.strokeColorA = 255
		MR_Overlay.fillColorR = 225
		MR_Overlay.fillColorG = 236
		MR_Overlay.fillColorB = 223
		MR_Overlay.fillColorA = 255
		self:UpdateWidgets()
	end	
end

function MR_OverlayShapesDialog:OnOK(moho)
end

-- **************************************************
-- MR_OverlayBonesDialog
-- **************************************************

local MR_OverlayBonesDialog = {}

MR_OverlayBonesDialog.LINE_WIDTH = MOHO.MSG_BASE
MR_OverlayBonesDialog.BONE_WIDTH = MOHO.MSG_BASE + 1
MR_OverlayBonesDialog.BONE_COLOR = MOHO.MSG_BASE + 2
MR_OverlayBonesDialog.RANDOMIZE_BONE_COLOR = MOHO.MSG_BASE + 3
MR_OverlayBonesDialog.RANDOMIZE_BONE_COLOR_ALT = MOHO.MSG_BASE + 4
MR_OverlayBonesDialog.DRAW_CENTER_LINE = MOHO.MSG_BASE + 5
MR_OverlayBonesDialog.PIN_BONE_RADIUS = MOHO.MSG_BASE + 6
MR_OverlayBonesDialog.DRAW_PIN_BONE_CENTER_LINES = MOHO.MSG_BASE + 7
MR_OverlayBonesDialog.SELECTED_BONES_ONLY = MOHO.MSG_BASE + 8
MR_OverlayBonesDialog.DRAW_HIDDEN_BONES = MOHO.MSG_BASE + 9
MR_OverlayBonesDialog.RESET = MOHO.MSG_BASE + 10

function MR_OverlayBonesDialog:new(moho)
    local d = LM.GUI.SimpleDialog(MR_Overlay:Localize('UILabel'), MR_OverlayBonesDialog)
    local l = d:GetLayout()

	d.bonesLineWidthInput = LM.GUI.TextControl(0, '100', self.LINE_WIDTH, LM.GUI.FIELD_FLOAT, MR_Overlay:Localize('Line width'))
	d.bonesLineWidthInput:SetWheelInc(0.1)
	l:AddChild(d.bonesLineWidthInput, LM.GUI.ALIGN_LEFT, 0)

	l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)
	
	d.bonesWidthInput = LM.GUI.TextControl(0, '100', self.BONE_WIDTH, LM.GUI.FIELD_FLOAT, MR_Overlay:Localize('Bones width'))
	d.bonesWidthInput:SetWheelInc(0.1)
	l:AddChild(d.bonesWidthInput, LM.GUI.ALIGN_LEFT, 0)
	
	l:PushH()
		d.boneColorSwatch = LM.GUI.ShortColorSwatch(true, self.BONE_COLOR)
		l:AddChild(d.boneColorSwatch, LM.GUI.ALIGN_LEFT)

		d.randomizeBoneColorButton = LM.GUI.Button(MR_Overlay:Localize('Randomize'), self.RANDOMIZE_BONE_COLOR)
		d.randomizeBoneColorButton:SetAlternateMessage(self.RANDOMIZE_BONE_COLOR_ALT)
		l:AddChild(d.randomizeBoneColorButton, LM.GUI.ALIGN_FILL, 0)
	l:Pop()

	d.drawCenterLineCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Draw center line'), self.DRAW_CENTER_LINE)
	l:AddChild(d.drawCenterLineCheck, LM.GUI.ALIGN_LEFT, 0)

	l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

	d.pinBoneRadiusInput = LM.GUI.TextControl(0, '100', self.PIN_BONE_RADIUS, LM.GUI.FIELD_FLOAT, MR_Overlay:Localize('Pin bone radius'))
	d.pinBoneRadiusInput:SetWheelInc(0.1)
	l:AddChild(d.pinBoneRadiusInput, LM.GUI.ALIGN_LEFT, 0)

	d.drawPinBoneCenterLinesCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Draw pin bone center lines'), self.DRAW_PIN_BONE_CENTER_LINES)
	l:AddChild(d.drawPinBoneCenterLinesCheck, LM.GUI.ALIGN_LEFT, 0)

	l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

	d.selectedBonesOnlyCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Selected bones only'), self.SELECTED_BONES_ONLY)
	l:AddChild(d.selectedBonesOnlyCheck, LM.GUI.ALIGN_LEFT, 0)

	d.drawHiddenBonesCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Draw hidden bones'), self.DRAW_HIDDEN_BONES)
	l:AddChild(d.drawHiddenBonesCheck, LM.GUI.ALIGN_LEFT, 0)

	d.resetButton = LM.GUI.ShortButton(MR_Overlay:Localize('Reset'), self.RESET)
	l:AddChild(d.resetButton, LM.GUI.ALIGN_FILL, 0)

	return d
end	

function MR_OverlayBonesDialog:UpdateWidgets(moho)
	self.bonesLineWidthInput:SetValue(MR_Overlay.bonesLineWidth)
	self.bonesWidthInput:SetValue(MR_Overlay.bonesWidth)
	local boneColor = LM.rgb_color:new_local()
	boneColor.r = MR_Overlay.boneColorR
	boneColor.g = MR_Overlay.boneColorG
	boneColor.b = MR_Overlay.boneColorB
	boneColor.a = MR_Overlay.boneColorA
	
	self.boneColorSwatch:SetValue(boneColor)
	self.drawCenterLineCheck:SetValue(MR_Overlay.drawCenterLine)
	self.pinBoneRadiusInput:SetValue(MR_Overlay.pinBoneRadius)
	self.drawPinBoneCenterLinesCheck:SetValue(MR_Overlay.drawPinBoneCenterLines)
	self.selectedBonesOnlyCheck:SetValue(MR_Overlay.selectedBonesOnly)
	self.drawHiddenBonesCheck:SetValue(MR_Overlay.drawHiddenBones)
	self.drawHiddenBonesCheck:Enable(not MR_Overlay.selectedBonesOnly)
end

function MR_OverlayBonesDialog:HandleMessage(msg)
	if msg == self.LINE_WIDTH then
		MR_Overlay.bonesLineWidth = LM.Clamp(self.bonesLineWidthInput:FloatValue(), 0.2, 256)
		self.bonesLineWidthInput:SetValue(MR_Overlay.bonesLineWidth)
	elseif msg == self.BONE_WIDTH then
		MR_Overlay.bonesWidth = LM.Clamp(self.bonesWidthInput:Value(), 0, 5)
		self.bonesWidthInput:SetValue(MR_Overlay.bonesWidth)
	elseif msg == self.BONE_COLOR then
		local colorSwatchValue = self.boneColorSwatch:Value()
		MR_Overlay.boneColorR = colorSwatchValue.r
		MR_Overlay.boneColorG = colorSwatchValue.g
		MR_Overlay.boneColorB = colorSwatchValue.b
		MR_Overlay.boneColorA = colorSwatchValue.a
	elseif msg == self.RANDOMIZE_BONE_COLOR then
		local oldColor = self.boneColorSwatch:Value()
		local newColor = MR_Utilities:GenerateDistinctColor(oldColor)
		newColor.a = oldColor.a
		MR_Overlay.boneColorR = newColor.r
		MR_Overlay.boneColorG = newColor.g
		MR_Overlay.boneColorB = newColor.b
		MR_Overlay.boneColorA = newColor.a
		self:UpdateWidgets()
	elseif msg == self.RANDOMIZE_BONE_COLOR_ALT then
		local oldColor = self.boneColorSwatch:Value()
		local newColor = MR_Utilities:RandomizeBrightness(oldColor)
		newColor.a = oldColor.a
		MR_Overlay.boneColorR = newColor.r
		MR_Overlay.boneColorG = newColor.g
		MR_Overlay.boneColorB = newColor.b
		MR_Overlay.boneColorA = newColor.a
		self:UpdateWidgets()
	elseif msg == self.DRAW_CENTER_LINE then
		MR_Overlay.drawCenterLine = self.drawCenterLineCheck:Value()
	elseif msg == self.PIN_BONE_RADIUS then
		MR_Overlay.pinBoneRadius = LM.Clamp(self.pinBoneRadiusInput:Value(), 0.1, 100)
		self.pinBoneRadiusInput:SetValue(MR_Overlay.pinBoneRadius)
	elseif msg == self.DRAW_PIN_BONE_CENTER_LINES then
		MR_Overlay.drawPinBoneCenterLines = self.drawPinBoneCenterLinesCheck:Value()
	elseif msg == self.SELECTED_BONES_ONLY then
		MR_Overlay.selectedBonesOnly = self.selectedBonesOnlyCheck:Value()
		self.drawHiddenBonesCheck:Enable(not MR_Overlay.selectedBonesOnly)
	elseif msg == self.DRAW_HIDDEN_BONES then
		MR_Overlay.drawHiddenBones = self.drawHiddenBonesCheck:Value()
	elseif msg == self.RESET then
		MR_Overlay.bonesLineWidth = 3
		MR_Overlay.bonesWidth = 1
		MR_Overlay.boneColorR = 222
		MR_Overlay.boneColorG = 0
		MR_Overlay.boneColorB = 0
		MR_Overlay.boneColorA = 255
		MR_Overlay.drawCenterLine = false
		MR_Overlay.pinBoneRadius = 1
		MR_Overlay.drawPinBoneCenterLines = false
		MR_Overlay.selectedBonesOnly = true
		MR_Overlay.drawHiddenBones = false
		self:UpdateWidgets()
	end
end

function MR_OverlayBonesDialog:OnOK(moho)
end

-- **************************************************
-- MR_OverlayPointsDialog
-- **************************************************

local MR_OverlayPointsDialog = {}

MR_OverlayPointsDialog.LINE_WIDTH = MOHO.MSG_BASE
MR_OverlayPointsDialog.DRAW_CROSSHAIR = MOHO.MSG_BASE + 1
MR_OverlayPointsDialog.CROSSHAIR_RADIUS = MOHO.MSG_BASE + 2
MR_OverlayPointsDialog.CROSSHAR_COLOR = MOHO.MSG_BASE + 3
MR_OverlayPointsDialog.RANDOMIZE_CROSSHAIR_COLOR = MOHO.MSG_BASE + 4
MR_OverlayPointsDialog.RANDOMIZE_CROSSHAIR_COLOR_ALT = MOHO.MSG_BASE + 5
MR_OverlayPointsDialog.DRAW_CIRCLE = MOHO.MSG_BASE + 6
MR_OverlayPointsDialog.CIRCLE_RADIUS = MOHO.MSG_BASE + 7
MR_OverlayPointsDialog.CIRCLE_COLOR = MOHO.MSG_BASE + 8
MR_OverlayPointsDialog.RANDOMIZE_CIRCLE_COLOR = MOHO.MSG_BASE + 9
MR_OverlayPointsDialog.RANDOMIZE_CIRCLE_COLOR_ALT = MOHO.MSG_BASE + 10
MR_OverlayPointsDialog.SELECTED_POINTS_ONLY = MOHO.MSG_BASE + 11
MR_OverlayPointsDialog.DRAW_HIDDEN_POINTS = MOHO.MSG_BASE + 12
MR_OverlayPointsDialog.RESET = MOHO.MSG_BASE + 13

function MR_OverlayPointsDialog:new(moho)
    local d = LM.GUI.SimpleDialog(MR_Overlay:Localize('UILabel'), MR_OverlayPointsDialog)
    local l = d:GetLayout()

	d.pointLineWidthInput = LM.GUI.TextControl(0, '100', self.LINE_WIDTH, LM.GUI.FIELD_FLOAT, MR_Overlay:Localize('Line width'))
	l:AddChild(d.pointLineWidthInput, LM.GUI.ALIGN_LEFT, 0)

	l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

	d.drawCrosshairCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Draw crosshair'), self.DRAW_CROSSHAIR)
	l:AddChild(d.drawCrosshairCheck, LM.GUI.ALIGN_LEFT, 0)
	
	d.crosshairRadiusInput = LM.GUI.TextControl(0, '100', self.CROSSHAIR_RADIUS, LM.GUI.FIELD_FLOAT, MR_Overlay:Localize('Crosshair radius'))
	d.crosshairRadiusInput:SetWheelInc(0.1)
	l:AddChild(d.crosshairRadiusInput, LM.GUI.ALIGN_LEFT, 0)
	
	l:PushH()
		d.pointCrosshairColorSwatch = LM.GUI.ShortColorSwatch(true, self.CROSSHAR_COLOR)
		l:AddChild(d.pointCrosshairColorSwatch, LM.GUI.ALIGN_LEFT)

		d.randomizeCrosshairColorButton = LM.GUI.Button(MR_Overlay:Localize('Randomize'), self.RANDOMIZE_CROSSHAIR_COLOR)
		d.randomizeCrosshairColorButton:SetAlternateMessage(self.RANDOMIZE_CROSSHAIR_COLOR_ALT)
		l:AddChild(d.randomizeCrosshairColorButton, LM.GUI.ALIGN_FILL, 0)
	l:Pop()

	l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

	d.drawCircleCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Draw circle'), self.DRAW_CIRCLE)
	l:AddChild(d.drawCircleCheck, LM.GUI.ALIGN_LEFT, 0)

	d.circleRadiusInput = LM.GUI.TextControl(0, '100', self.CIRCLE_RADIUS, LM.GUI.FIELD_FLOAT, MR_Overlay:Localize('Circle radius'))
	d.circleRadiusInput:SetWheelInc(0.1)
	l:AddChild(d.circleRadiusInput, LM.GUI.ALIGN_LEFT, 0)

	l:PushH()	
		d.pointCircleColorSwatch = LM.GUI.ShortColorSwatch(true, self.CIRCLE_COLOR)
		l:AddChild(d.pointCircleColorSwatch, LM.GUI.ALIGN_LEFT)

		d.randomizeCircleColorButton = LM.GUI.Button(MR_Overlay:Localize('Randomize'), self.RANDOMIZE_CIRCLE_COLOR)
		d.randomizeCircleColorButton:SetAlternateMessage(self.RANDOMIZE_CIRCLE_COLOR_ALT)
		l:AddChild(d.randomizeCircleColorButton, LM.GUI.ALIGN_FILL, 0)
	l:Pop()

	l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

	d.selectedPointsOnlyCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Selected points only'), self.SELECTED_POINTS_ONLY)
	l:AddChild(d.selectedPointsOnlyCheck, LM.GUI.ALIGN_LEFT, 0)

	d.drawHiddenPointsCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Draw hidden points'), self.DRAW_HIDDEN_POINTS)
	l:AddChild(d.drawHiddenPointsCheck, LM.GUI.ALIGN_LEFT, 0)

	d.resetButton = LM.GUI.ShortButton(MR_Overlay:Localize('Reset'), self.RESET)
	l:AddChild(d.resetButton, LM.GUI.ALIGN_FILL, 0)

	return d
end	

function MR_OverlayPointsDialog:UpdateWidgets(moho)
	self.pointLineWidthInput:SetValue(MR_Overlay.pointLineWidth)
	self.drawCrosshairCheck:SetValue(MR_Overlay.drawCrosshair)
	self.crosshairRadiusInput:SetValue(MR_Overlay.crosshairRadius)
	self.crosshairRadiusInput:Enable(MR_Overlay.drawCrosshair)
	self.randomizeCrosshairColorButton:Enable(MR_Overlay.drawCrosshair)

	local pointCrosshairColor = LM.rgb_color:new_local()
	pointCrosshairColor.r = MR_Overlay.pointCrosshairColorR
	pointCrosshairColor.g = MR_Overlay.pointCrosshairColorG
	pointCrosshairColor.b = MR_Overlay.pointCrosshairColorB
	pointCrosshairColor.a = MR_Overlay.pointCrosshairColorA
	
	self.pointCrosshairColorSwatch:SetValue(pointCrosshairColor)
	self.pointCrosshairColorSwatch:Enable(MR_Overlay.drawCrosshair)

	self.drawCircleCheck:SetValue(MR_Overlay.drawCircle)
	self.circleRadiusInput:SetValue(MR_Overlay.circleRadius)
	self.circleRadiusInput:Enable(MR_Overlay.drawCircle)
	self.randomizeCircleColorButton:Enable(MR_Overlay.drawCircle)

	local pointCircleColor = LM.rgb_color:new_local()
	pointCircleColor.r = MR_Overlay.pointCircleColorR
	pointCircleColor.g = MR_Overlay.pointCircleColorG
	pointCircleColor.b = MR_Overlay.pointCircleColorB
	pointCircleColor.a = MR_Overlay.pointCircleColorA
	self.pointCircleColorSwatch:SetValue(pointCircleColor)
	self.pointCircleColorSwatch:Enable(MR_Overlay.drawCircle)

	self.selectedPointsOnlyCheck:SetValue(MR_Overlay.selectedPointsOnly)
	self.drawHiddenPointsCheck:SetValue(MR_Overlay.drawHiddenPoints)
	self.drawHiddenPointsCheck:Enable(not MR_Overlay.selectedPointsOnly)
end

function MR_OverlayPointsDialog:HandleMessage(msg)
	if msg == self.LINE_WIDTH then
		MR_Overlay.pointLineWidth = LM.Clamp(self.pointLineWidthInput:FloatValue(), 0.25, 256)
		self.pointLineWidthInput:SetValue(MR_Overlay.pointLineWidth)
	elseif msg == self.DRAW_CROSSHAIR then
		MR_Overlay.drawCrosshair = self.drawCrosshairCheck:Value()
		if not MR_Overlay.drawCircle and not MR_Overlay.drawCrosshair then
			MR_Overlay.drawCrosshair = true
		end
		self.drawCrosshairCheck:SetValue(MR_Overlay.drawCrosshair)
		self.crosshairRadiusInput:Enable(MR_Overlay.drawCrosshair)
		self.pointCrosshairColorSwatch:Enable(MR_Overlay.drawCrosshair)
		self.randomizeCrosshairColorButton:Enable(MR_Overlay.drawCrosshair)
	elseif msg == self.CROSSHAIR_RADIUS then
		MR_Overlay.crosshairRadius = LM.Clamp(self.crosshairRadiusInput:Value(), 0.1, 5)
		self.crosshairRadiusInput:SetValue(MR_Overlay.crosshairRadius)
	elseif msg == self.CROSSHAR_COLOR then
		local colorSwatchValue = self.pointCrosshairColorSwatch:Value()
		MR_Overlay.pointCrosshairColorR = colorSwatchValue.r
		MR_Overlay.pointCrosshairColorG = colorSwatchValue.g
		MR_Overlay.pointCrosshairColorB = colorSwatchValue.b
		MR_Overlay.pointCrosshairColorA = colorSwatchValue.a
	elseif msg == self.RANDOMIZE_CROSSHAIR_COLOR then
		local oldColor = self.pointCrosshairColorSwatch:Value()
		local newColor = MR_Utilities:GenerateDistinctColor(oldColor)
		newColor.a = oldColor.a
		self.pointCrosshairColorSwatch:SetValue(newColor)
		MR_Overlay.pointCrosshairColorR = newColor.r
		MR_Overlay.pointCrosshairColorG = newColor.g
		MR_Overlay.pointCrosshairColorB = newColor.b
		MR_Overlay.pointCrosshairColorA = newColor.a
	elseif msg == self.RANDOMIZE_CROSSHAIR_COLOR_ALT then
		local oldColor = self.pointCrosshairColorSwatch:Value()
		local newColor = MR_Utilities:RandomizeBrightness(oldColor)
		self.pointCrosshairColorSwatch:SetValue(newColor)
	elseif msg == self.DRAW_CIRCLE then
		MR_Overlay.drawCircle = self.drawCircleCheck:Value()
		if not MR_Overlay.drawCircle and not MR_Overlay.drawCrosshair then
			MR_Overlay.drawCircle = true
		end
		self.drawCircleCheck:SetValue(MR_Overlay.drawCircle)
		self.circleRadiusInput:Enable(MR_Overlay.drawCircle)
		self.pointCircleColorSwatch:Enable(MR_Overlay.drawCircle)
		self.randomizeCircleColorButton:Enable(MR_Overlay.drawCircle)
	elseif msg == self.CIRCLE_RADIUS then
		MR_Overlay.circleRadius = LM.Clamp(self.circleRadiusInput:Value(), 0.1, 5)
		self.circleRadiusInput:SetValue(MR_Overlay.circleRadius)
	elseif msg == self.CIRCLE_COLOR then
		local colorSwatchValue = self.pointCircleColorSwatch:Value()
		MR_Overlay.pointCircleColorR = colorSwatchValue.r
		MR_Overlay.pointCircleColorG = colorSwatchValue.g
		MR_Overlay.pointCircleColorB = colorSwatchValue.b
		MR_Overlay.pointCircleColorA = colorSwatchValue.a
	elseif msg == self.RANDOMIZE_CIRCLE_COLOR then
		local oldColor = self.pointCircleColorSwatch:Value()
		local newColor = MR_Utilities:GenerateDistinctColor(oldColor)
		newColor.a = oldColor.a
		self.pointCircleColorSwatch:SetValue(newColor)
		MR_Overlay.pointCircleColorR = newColor.r
		MR_Overlay.pointCircleColorG = newColor.g
		MR_Overlay.pointCircleColorB = newColor.b
		MR_Overlay.pointCircleColorA = newColor.a
	elseif msg == self.RANDOMIZE_CIRCLE_COLOR_ALT then
		local oldColor = self.pointCircleColorSwatch:Value()
		local newColor = MR_Utilities:RandomizeBrightness(oldColor)
		newColor.a = oldColor.a
		self.pointCircleColorSwatch:SetValue(newColor)
	elseif msg == self.SELECTED_POINTS_ONLY then
		MR_Overlay.selectedPointsOnly = self.selectedPointsOnlyCheck:Value()
		self.drawHiddenPointsCheck:Enable(not MR_Overlay.selectedPointsOnly)
	elseif msg == self.DRAW_HIDDEN_POINTS then
		MR_Overlay.drawHiddenPoints = self.drawHiddenPointsCheck:Value()
	elseif msg == self.RESET then
		MR_Overlay.pointLineWidth = 6
		MR_Overlay.drawCrosshair = true
		MR_Overlay.crosshairRadius = 1
		MR_Overlay.pointCrosshairColorR = 13
		MR_Overlay.pointCrosshairColorG = 199
		MR_Overlay.pointCrosshairColorB = 216
		MR_Overlay.pointCrosshairColorA = 255
		MR_Overlay.drawCircle = false
		MR_Overlay.circleRadius = 1
		MR_Overlay.pointCircleColorR = 23
		MR_Overlay.pointCircleColorG = 142
		MR_Overlay.pointCircleColorB = 198
		MR_Overlay.pointCircleColorA = 125
		MR_Overlay.selectedPointsOnly = true
		MR_Overlay.drawHiddenPoints = false
		self:UpdateWidgets()
	end	
end

function MR_OverlayPointsDialog:OnOK(moho)
end

-- **************************************************
-- MR_OverlaySettingsDialog
-- **************************************************

local MR_OverlaySettingsDialog = {}

MR_OverlaySettingsDialog.VISIBLE_LAYERS_ONLY = MOHO.MSG_BASE
MR_OverlaySettingsDialog.DO_NOT_RENDER_OVERLAY = MOHO.MSG_BASE + 1
MR_OverlaySettingsDialog.USE_SHAPES_CENTER = MOHO.MSG_BASE + 2
MR_OverlaySettingsDialog.USE_SEPARATE_SHAPES = MOHO.MSG_BASE + 3
MR_OverlaySettingsDialog.RECOLOR_SHADE_VALUE = MOHO.MSG_BASE + 4

function MR_OverlaySettingsDialog:new(moho)
    local d = LM.GUI.SimpleDialog(MR_Overlay:Localize('UILabel'), MR_OverlaySettingsDialog)
    local l = d:GetLayout()
	
	d.visibleLayersOnlyCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Visible layers only'), self.VISIBLE_LAYERS_ONLY)
	l:AddChild(d.visibleLayersOnlyCheck, LM.GUI.ALIGN_LEFT, 0)

	d.doNotRenderOverlayCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Do not render overlay'), self.DO_NOT_RENDER_OVERLAY)
	l:AddChild(d.doNotRenderOverlayCheck, LM.GUI.ALIGN_LEFT, 0)

	d.useShapeForPivotCheckbox = LM.GUI.CheckBox(MR_Overlay:Localize('Use shapes center'), self.USE_SHAPES_CENTER)
	l:AddChild(d.useShapeForPivotCheckbox, LM.GUI.ALIGN_LEFT, 0)

	d.useSeparateShapesCheckbox = LM.GUI.CheckBox(MR_Overlay:Localize('Use separate shapes'), self.USE_SEPARATE_SHAPES)
	l:AddChild(d.useSeparateShapesCheckbox, LM.GUI.ALIGN_LEFT, 0)

	d.recolorShadeValueInput = LM.GUI.TextControl(30, '', self.RECOLOR_SHADE_VALUE, LM.GUI.FIELD_FLOAT, MR_Overlay:Localize('Mirror shade value'))
	d.recolorShadeValueInput:SetWheelInc(0.01)
	l:AddChild(d.recolorShadeValueInput, LM.GUI.ALIGN_LEFT, 0)

	return d
end	

function MR_OverlaySettingsDialog:UpdateWidgets(moho)
	self.visibleLayersOnlyCheck:SetValue(MR_Overlay.visibleLayersOnly)
	self.doNotRenderOverlayCheck:SetValue(MR_Overlay.doNotRender)
	self.useShapeForPivotCheckbox:SetValue(MR_Overlay.useShapeForPivot)
	self.useSeparateShapesCheckbox:SetValue(MR_Overlay.useSeparateShapes)
	self.recolorShadeValueInput:SetValue(MR_Overlay.recolorShadeValue)
end

function MR_OverlaySettingsDialog:HandleMessage(msg)
	if msg == self.VISIBLE_LAYERS_ONLY then
		MR_Overlay.visibleLayersOnly = self.visibleLayersOnlyCheck:Value()
	elseif msg == self.DO_NOT_RENDER_OVERLAY then
		MR_Overlay.doNotRender = self.doNotRenderOverlayCheck:Value()
	elseif msg == self.USE_SHAPES_CENTER then
		MR_Overlay.useShapeForPivot = self.useShapeForPivotCheckbox:Value()
	elseif msg == self.USE_SEPARATE_SHAPES then
		MR_Overlay.useSeparateShapes = self.useSeparateShapesCheckbox:Value()
	elseif msg == self.RECOLOR_SHADE_VALUE then
		MR_Overlay.recolorShadeValue = LM.Clamp(self.recolorShadeValueInput:Value(), 0, 1)
		self.recolorShadeValueInput:SetValue(MR_Overlay.recolorShadeValue)
	end
end

function MR_OverlaySettingsDialog:OnOK(moho)
end

-- **************************************************
-- MR_OverlayPointsDialog
-- **************************************************

local MR_OverlayFrameDialog = {}

MR_OverlayFrameDialog.FRAME_SLOT_1 = MOHO.MSG_BASE
MR_OverlayFrameDialog.FRAME_SLOT_VALUE_1 = MOHO.MSG_BASE + 1
MR_OverlayFrameDialog.FRAME_SLOT_2 = MOHO.MSG_BASE + 2
MR_OverlayFrameDialog.FRAME_SLOT_VALUE_2 = MOHO.MSG_BASE + 3
MR_OverlayFrameDialog.FRAME_SLOT_3 = MOHO.MSG_BASE + 4
MR_OverlayFrameDialog.FRAME_SLOT_VALUE_3 = MOHO.MSG_BASE + 5
MR_OverlayFrameDialog.FRAME_SLOT_4 = MOHO.MSG_BASE + 6
MR_OverlayFrameDialog.FRAME_SLOT_VALUE_4 = MOHO.MSG_BASE + 7
MR_OverlayFrameDialog.FRAME_SLOT_5 = MOHO.MSG_BASE + 8
MR_OverlayFrameDialog.FRAME_SLOT_VALUE_5 = MOHO.MSG_BASE + 9


function MR_OverlayFrameDialog:new(moho)
    local d = LM.GUI.SimpleDialog(MR_Overlay:Localize('UILabel'), MR_OverlayFrameDialog)
    local l = d:GetLayout()

	l:PushH()
		d.frame_1_RadioButton = LM.GUI.RadioButton(MR_Overlay:Localize('Frame:'), self.FRAME_SLOT_1)
		l:AddChild(d.frame_1_RadioButton, LM.GUI.ALIGN_LEFT, 0)

		d.frame_1_valueInput = LM.GUI.TextControl(0, '100000', self.FRAME_SLOT_VALUE_1, LM.GUI.FIELD_INT, '')
		l:AddChild(d.frame_1_valueInput, LM.GUI.ALIGN_LEFT, 0)
	l:Pop()

	l:PushH()
		d.frame_2_RadioButton = LM.GUI.RadioButton(MR_Overlay:Localize('Frame:'), self.FRAME_SLOT_2)
		l:AddChild(d.frame_2_RadioButton, LM.GUI.ALIGN_LEFT, 0)

		d.frame_2_valueInput = LM.GUI.TextControl(0, '100000', self.FRAME_SLOT_VALUE_2, LM.GUI.FIELD_INT, '')
		l:AddChild(d.frame_2_valueInput, LM.GUI.ALIGN_LEFT, 0)
	l:Pop()

	l:PushH()
		d.frame_3_RadioButton = LM.GUI.RadioButton(MR_Overlay:Localize('Frame:'), self.FRAME_SLOT_3)
		l:AddChild(d.frame_3_RadioButton, LM.GUI.ALIGN_LEFT, 0)

		d.frame_3_valueInput = LM.GUI.TextControl(0, '100000', self.FRAME_SLOT_VALUE_3, LM.GUI.FIELD_INT, '')
		l:AddChild(d.frame_3_valueInput, LM.GUI.ALIGN_LEFT, 0)
	l:Pop()

	l:PushH()
		d.frame_4_RadioButton = LM.GUI.RadioButton('     +    ', self.FRAME_SLOT_4)
		l:AddChild(d.frame_4_RadioButton, LM.GUI.ALIGN_LEFT, 0)

		l:AddPadding(-7)

		d.frame_4_valueInput = LM.GUI.TextControl(0, '100000', self.FRAME_SLOT_VALUE_4, LM.GUI.FIELD_INT, '')
		l:AddChild(d.frame_4_valueInput, LM.GUI.ALIGN_LEFT, 0)
	l:Pop()

	l:PushH()
		d.frame_5_RadioButton = LM.GUI.RadioButton('     -     ', self.FRAME_SLOT_5)
		l:AddChild(d.frame_5_RadioButton, LM.GUI.ALIGN_LEFT, 0)

		l:AddPadding(-7)

		d.frame_5_valueInput = LM.GUI.TextControl(0, '100000', self.FRAME_SLOT_VALUE_5, LM.GUI.FIELD_INT, '')
		l:AddChild(d.frame_5_valueInput, LM.GUI.ALIGN_LEFT, 0)
	l:Pop()

	return d
end	

function MR_OverlayFrameDialog:UpdateWidgets(moho)
	self.frame_1_RadioButton:SetValue(MR_Overlay.useFrame1)
	self.frame_2_RadioButton:SetValue(MR_Overlay.useFrame2)
	self.frame_3_RadioButton:SetValue(MR_Overlay.useFrame3)
	self.frame_4_RadioButton:SetValue(MR_Overlay.useFrame4)
	self.frame_5_RadioButton:SetValue(MR_Overlay.useFrame5)

	self.frame_1_valueInput:SetValue(MR_Overlay.frameVal1)
	self.frame_2_valueInput:SetValue(MR_Overlay.frameVal2)
	self.frame_3_valueInput:SetValue(MR_Overlay.frameVal3)
	self.frame_4_valueInput:SetValue(MR_Overlay.frameVal4)
	self.frame_5_valueInput:SetValue(MR_Overlay.frameVal5)
end

function MR_OverlayFrameDialog:HandleMessage(msg)
	if msg == self.FRAME_SLOT_1 then
		MR_Overlay.useFrame1 = true
		MR_Overlay.useFrame2 = false
		MR_Overlay.useFrame3 = false
		MR_Overlay.useFrame4 = false
		MR_Overlay.useFrame5 = false
		self.frame_1_RadioButton:SetValue(MR_Overlay.useFrame1)
		self.frame_2_RadioButton:SetValue(MR_Overlay.useFrame2)
		self.frame_3_RadioButton:SetValue(MR_Overlay.useFrame3)
		self.frame_4_RadioButton:SetValue(MR_Overlay.useFrame4)
		self.frame_5_RadioButton:SetValue(MR_Overlay.useFrame5)
	elseif msg == self.FRAME_SLOT_VALUE_1 then	
		MR_Overlay.frameVal1 = self.frame_1_valueInput:Value()
	elseif msg == self.FRAME_SLOT_2 then
		MR_Overlay.useFrame1 = false
		MR_Overlay.useFrame2 = true
		MR_Overlay.useFrame3 = false
		MR_Overlay.useFrame4 = false
		MR_Overlay.useFrame5 = false
		self.frame_1_RadioButton:SetValue(MR_Overlay.useFrame1)
		self.frame_2_RadioButton:SetValue(MR_Overlay.useFrame2)
		self.frame_3_RadioButton:SetValue(MR_Overlay.useFrame3)
		self.frame_4_RadioButton:SetValue(MR_Overlay.useFrame4)
		self.frame_5_RadioButton:SetValue(MR_Overlay.useFrame5)
	elseif msg == self.FRAME_SLOT_VALUE_2 then	
		MR_Overlay.frameVal2 = self.frame_2_valueInput:Value()
	elseif msg == self.FRAME_SLOT_3 then
		MR_Overlay.useFrame1 = false
		MR_Overlay.useFrame2 = false
		MR_Overlay.useFrame3 = true
		MR_Overlay.useFrame4 = false
		MR_Overlay.useFrame5 = false
		self.frame_1_RadioButton:SetValue(MR_Overlay.useFrame1)
		self.frame_2_RadioButton:SetValue(MR_Overlay.useFrame2)
		self.frame_3_RadioButton:SetValue(MR_Overlay.useFrame3)
		self.frame_4_RadioButton:SetValue(MR_Overlay.useFrame4)
		self.frame_5_RadioButton:SetValue(MR_Overlay.useFrame5)
	elseif msg == self.FRAME_SLOT_VALUE_3 then	
		MR_Overlay.frameVal3 = self.frame_3_valueInput:Value()
	elseif msg == self.FRAME_SLOT_4 then
		MR_Overlay.useFrame1 = false
		MR_Overlay.useFrame2 = false
		MR_Overlay.useFrame3 = false
		MR_Overlay.useFrame4 = true
		MR_Overlay.useFrame5 = false
		self.frame_1_RadioButton:SetValue(MR_Overlay.useFrame1)
		self.frame_2_RadioButton:SetValue(MR_Overlay.useFrame2)
		self.frame_3_RadioButton:SetValue(MR_Overlay.useFrame3)
		self.frame_4_RadioButton:SetValue(MR_Overlay.useFrame4)
		self.frame_5_RadioButton:SetValue(MR_Overlay.useFrame5)
	elseif msg == self.FRAME_SLOT_VALUE_4 then	
		MR_Overlay.frameVal4 = self.frame_4_valueInput:Value()
	elseif msg == self.FRAME_SLOT_5 then
		MR_Overlay.useFrame1 = false
		MR_Overlay.useFrame2 = false
		MR_Overlay.useFrame3 = false
		MR_Overlay.useFrame4 = false
		MR_Overlay.useFrame5 = true
		self.frame_1_RadioButton:SetValue(MR_Overlay.useFrame1)
		self.frame_2_RadioButton:SetValue(MR_Overlay.useFrame2)
		self.frame_3_RadioButton:SetValue(MR_Overlay.useFrame3)
		self.frame_4_RadioButton:SetValue(MR_Overlay.useFrame4)
		self.frame_5_RadioButton:SetValue(MR_Overlay.useFrame5)
	elseif msg == self.FRAME_SLOT_VALUE_5 then	
		MR_Overlay.frameVal5 = self.frame_5_valueInput:Value()
	end	
end

function MR_OverlayFrameDialog:OnOK(moho)
end

-- **************************************************
-- MR_OverlayDialog
-- **************************************************

local MR_OverlayDialog = {}
MR_OverlayDialog.CREATE_OVERLAY = MOHO.MSG_BASE
MR_OverlayDialog.CREATE_OVERLAY_ALT = MOHO.MSG_BASE + 1
MR_OverlayDialog.SET_CUSTOM_PIVOT = MOHO.MSG_BASE + 2
MR_OverlayDialog.SET_CUSTOM_PIVOT_ALT = MOHO.MSG_BASE + 3
MR_OverlayDialog.SHOW_HIDE_OVERLAY = MOHO.MSG_BASE + 4
MR_OverlayDialog.DELETE_OVERLAY = MOHO.MSG_BASE + 5
MR_OverlayDialog.OVERLAY_OPACITY = MOHO.MSG_BASE + 6
MR_OverlayDialog.SHAPES_OVERLAY = MOHO.MSG_BASE + 7
MR_OverlayDialog.SHAPES_DIALOG = MOHO.MSG_BASE + 8
MR_OverlayDialog.BONES_OVERLAY = MOHO.MSG_BASE + 9
MR_OverlayDialog.BONES_DIALOG = MOHO.MSG_BASE + 10
MR_OverlayDialog.POINTS_OVERLAY = MOHO.MSG_BASE + 11
MR_OverlayDialog.POINTS_DIALOG = MOHO.MSG_BASE + 12
MR_OverlayDialog.FLIP_OVERLAY = MOHO.MSG_BASE + 13
MR_OverlayDialog.MIRROR_OVERLAY = MOHO.MSG_BASE + 14
MR_OverlayDialog.MIRROR_OVERLAY_SHADE = MOHO.MSG_BASE + 15
MR_OverlayDialog.LAYER_ORIGIN = MOHO.MSG_BASE + 16
MR_OverlayDialog.CUSTOM_CENTER = MOHO.MSG_BASE + 17
MR_OverlayDialog.SELECTION_CENTER = MOHO.MSG_BASE + 18
MR_OverlayDialog.CREATE_FROM_FRAME = MOHO.MSG_BASE + 19
MR_OverlayDialog.FRAME_DIALOG = MOHO.MSG_BASE + 20
MR_OverlayDialog.SETTINGS_DIALOG = MOHO.MSG_BASE + 21
MR_OverlayDialog.SHOW_LAYERS = MOHO.MSG_BASE + 22

MR_OverlayDialog.LAYER_1_VISIBILITY = MOHO.MSG_BASE + 23
MR_OverlayDialog.LAYER_2_VISIBILITY = MOHO.MSG_BASE + 24
MR_OverlayDialog.LAYER_3_VISIBILITY = MOHO.MSG_BASE + 25
MR_OverlayDialog.LAYER_4_VISIBILITY = MOHO.MSG_BASE + 26
MR_OverlayDialog.LAYER_5_VISIBILITY = MOHO.MSG_BASE + 27
MR_OverlayDialog.LAYER_1 = MOHO.MSG_BASE + 28
MR_OverlayDialog.LAYER_2 = MOHO.MSG_BASE + 29
MR_OverlayDialog.LAYER_3 = MOHO.MSG_BASE + 30
MR_OverlayDialog.LAYER_4 = MOHO.MSG_BASE + 31
MR_OverlayDialog.LAYER_5 = MOHO.MSG_BASE + 32
MR_OverlayDialog.LAYER_1_OPACITY = MOHO.MSG_BASE + 33
MR_OverlayDialog.LAYER_2_OPACITY = MOHO.MSG_BASE + 34
MR_OverlayDialog.LAYER_3_OPACITY = MOHO.MSG_BASE + 35
MR_OverlayDialog.LAYER_4_OPACITY = MOHO.MSG_BASE + 36
MR_OverlayDialog.LAYER_5_OPACITY = MOHO.MSG_BASE + 37
MR_OverlayDialog.CLEAR_OVERLAY_1 = MOHO.MSG_BASE + 38
MR_OverlayDialog.CLEAR_OVERLAY_2 = MOHO.MSG_BASE + 39
MR_OverlayDialog.CLEAR_OVERLAY_3 = MOHO.MSG_BASE + 40
MR_OverlayDialog.CLEAR_OVERLAY_4 = MOHO.MSG_BASE + 41
MR_OverlayDialog.CLEAR_OVERLAY_5 = MOHO.MSG_BASE + 42
MR_OverlayDialog.CONVERT_CONVERT_1 = MOHO.MSG_BASE + 43
MR_OverlayDialog.CONVERT_CONVERT_2 = MOHO.MSG_BASE + 44
MR_OverlayDialog.CONVERT_CONVERT_3 = MOHO.MSG_BASE + 45
MR_OverlayDialog.CONVERT_CONVERT_4 = MOHO.MSG_BASE + 46
MR_OverlayDialog.CONVERT_CONVERT_5 = MOHO.MSG_BASE + 47
MR_OverlayDialog.SAVE_SELECTION_1 = MOHO.MSG_BASE + 48
MR_OverlayDialog.SAVE_SELECTION_2 = MOHO.MSG_BASE + 49
MR_OverlayDialog.SAVE_SELECTION_3 = MOHO.MSG_BASE + 50
MR_OverlayDialog.SAVE_SELECTION_4 = MOHO.MSG_BASE + 51
MR_OverlayDialog.SAVE_SELECTION_5 = MOHO.MSG_BASE + 52
MR_OverlayDialog.SAVE_SELECTION_1_ALT = MOHO.MSG_BASE + 53
MR_OverlayDialog.SAVE_SELECTION_2_ALT = MOHO.MSG_BASE + 54
MR_OverlayDialog.SAVE_SELECTION_3_ALT = MOHO.MSG_BASE + 55
MR_OverlayDialog.SAVE_SELECTION_4_ALT = MOHO.MSG_BASE + 56
MR_OverlayDialog.SAVE_SELECTION_5_ALT = MOHO.MSG_BASE + 57
MR_OverlayDialog.USE_SAVED_SELECTION_1 = MOHO.MSG_BASE + 58
MR_OverlayDialog.USE_SAVED_SELECTION_2 = MOHO.MSG_BASE + 59
MR_OverlayDialog.USE_SAVED_SELECTION_3 = MOHO.MSG_BASE + 60
MR_OverlayDialog.USE_SAVED_SELECTION_4 = MOHO.MSG_BASE + 61
MR_OverlayDialog.USE_SAVED_SELECTION_5 = MOHO.MSG_BASE + 62
MR_OverlayDialog.OPEN_LAYER_SETTINGS_1 = MOHO.MSG_BASE + 63
MR_OverlayDialog.OPEN_LAYER_SETTINGS_2 = MOHO.MSG_BASE + 64
MR_OverlayDialog.OPEN_LAYER_SETTINGS_3 = MOHO.MSG_BASE + 65
MR_OverlayDialog.OPEN_LAYER_SETTINGS_4 = MOHO.MSG_BASE + 66
MR_OverlayDialog.OPEN_LAYER_SETTINGS_5 = MOHO.MSG_BASE + 67
MR_OverlayDialog.USE_OVERLAY_SETUP_1 = MOHO.MSG_BASE + 68
MR_OverlayDialog.USE_OVERLAY_SETUP_2 = MOHO.MSG_BASE + 69
MR_OverlayDialog.USE_OVERLAY_SETUP_3 = MOHO.MSG_BASE + 70
MR_OverlayDialog.USE_OVERLAY_SETUP_4 = MOHO.MSG_BASE + 71
MR_OverlayDialog.USE_OVERLAY_SETUP_5 = MOHO.MSG_BASE + 72
MR_OverlayDialog.AUTO_GENERATE_1 = MOHO.MSG_BASE + 73
MR_OverlayDialog.AUTO_GENERATE_2 = MOHO.MSG_BASE + 74
MR_OverlayDialog.AUTO_GENERATE_3 = MOHO.MSG_BASE + 75
MR_OverlayDialog.AUTO_GENERATE_4 = MOHO.MSG_BASE + 76
MR_OverlayDialog.AUTO_GENERATE_5 = MOHO.MSG_BASE + 77

function MR_OverlayDialog:new(moho)
	local d = LM.GUI.SimpleDialog(MR_Overlay:Localize('UILabel'), MR_OverlayDialog)
	local l = d:GetLayout()

	l:PushH()
		d.createOverlayButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_create_overlay', MR_Overlay:Localize('Create overlay'), false, self.CREATE_OVERLAY, false)
		d.createOverlayButton:SetAlternateMessage(self.CREATE_OVERLAY_ALT)
		l:AddChild(d.createOverlayButton, LM.GUI.ALIGN_LEFT, 0)

		d.setCustomPivotButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_set_pivot', MR_Overlay:Localize('Set custom pivot'), false, self.SET_CUSTOM_PIVOT, false)
		d.setCustomPivotButton:SetAlternateMessage(self.SET_CUSTOM_PIVOT_ALT)
		l:AddChild(d.setCustomPivotButton, LM.GUI.ALIGN_LEFT, 0)

		d.showHideOverlayCheck = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_visibility', MR_Overlay:Localize('Show/Hide overlay'), true, self.SHOW_HIDE_OVERLAY, false)
		l:AddChild(d.showHideOverlayCheck, LM.GUI.ALIGN_LEFT, 0)

		d.deleteOverlayButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_delete_overlay', MR_Overlay:Localize('Delete overlay'), false, self.DELETE_OVERLAY, false)
		l:AddChild(d.deleteOverlayButton, LM.GUI.ALIGN_LEFT, 0)

		l:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL)

		d.shapesOverlayButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_shapes_overlay', MR_Overlay:Localize('Shapes'), true, self.SHAPES_OVERLAY, false)
		l:AddChild(d.shapesOverlayButton, LM.GUI.ALIGN_LEFT, 0)

		d.shapesDlog = MR_OverlayShapesDialog:new()
		d.shapesDlogPopup = LM.GUI.PopupDialog(MR_Overlay:Localize('Shapes'), false, d.SHAPES_DIALOG)
		d.shapesDlogPopup:SetDialog(d.shapesDlog)
		l:AddChild(d.shapesDlogPopup, LM.GUI.ALIGN_FILL, 0)

		l:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL)

		d.bonesOverlayButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_bone', MR_Overlay:Localize('Shapes'), true, self.BONES_OVERLAY, false)
		l:AddChild(d.bonesOverlayButton, LM.GUI.ALIGN_LEFT, 0)

		d.bonesDlog = MR_OverlayBonesDialog:new()
		d.bonesDlogPopup = LM.GUI.PopupDialog(MR_Overlay:Localize('Bones'), false, d.BONES_DIALOG)
		d.bonesDlogPopup:SetDialog(d.bonesDlog)
		l:AddChild(d.bonesDlogPopup, LM.GUI.ALIGN_FILL, 0)

		l:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL)

		d.pointsOverlayButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_points_overlay', MR_Overlay:Localize('Points'), true, self.POINTS_OVERLAY, false)
		l:AddChild(d.pointsOverlayButton, LM.GUI.ALIGN_LEFT, 0)

		d.pointsDlog = MR_OverlayPointsDialog:new()
		d.pointsDlogPopup = LM.GUI.PopupDialog(MR_Overlay:Localize('Points'), false, d.POINTS_DIALOG)
		d.pointsDlogPopup:SetDialog(d.pointsDlog)
		l:AddChild(d.pointsDlogPopup, LM.GUI.ALIGN_FILL, 0)

		l:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL)

		d.settingsDlog = MR_OverlaySettingsDialog:new()
		d.settingsDlogPopup = LM.GUI.PopupDialog(MR_Overlay:Localize('Settings'), false, d.SETTINGS_DIALOG)
		d.settingsDlogPopup:SetDialog(d.settingsDlog)
		l:AddChild(d.settingsDlogPopup, LM.GUI.ALIGN_FILL, 0)
	l:Pop()
	
	l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)
	
	l:PushH()
		d.overlayOpacityInput = LM.GUI.TextControl(0, '100', self.OVERLAY_OPACITY, LM.GUI.FIELD_INT, MR_Overlay:Localize('Main Opacity:'))
		l:AddChild(d.overlayOpacityInput, LM.GUI.ALIGN_LEFT, 0)

		l:AddPadding(0)

		l:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL)

		l:AddPadding(0)
		
		d.flipOverlayCheck = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_flip', MR_Overlay:Localize('Flip overlay'), true, self.FLIP_OVERLAY, false)
		l:AddChild(d.flipOverlayCheck, LM.GUI.ALIGN_LEFT, 0)
		
		d.mirrorOverlayCheck = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_mirror', MR_Overlay:Localize('Mirror overlay'), true, self.MIRROR_OVERLAY, false)
		l:AddChild(d.mirrorOverlayCheck, LM.GUI.ALIGN_LEFT, 0)

		d.mirrorOverlayShadeCheck = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_mirror_shade', MR_Overlay:Localize('Mirror overlay with shade'), true, self.MIRROR_OVERLAY_SHADE, false)
		l:AddChild(d.mirrorOverlayShadeCheck, LM.GUI.ALIGN_LEFT, 0)
		
		d.centerMenu = LM.GUI.Menu('')
		d.centerMenu:AddItem(MR_Overlay:Localize('Layer Origin'), 0, self.LAYER_ORIGIN)
		d.centerMenu:AddItem(MR_Overlay:Localize('Selection Center'), 0, self.SELECTION_CENTER)
		d.centerMenu:AddItem(MR_Overlay:Localize('Custom Center'), 0, self.CUSTOM_CENTER)

		d.centerPopup = LM.GUI.PopupMenu(130, true)
		d.centerPopup:SetMenu(d.centerMenu)

		l:AddPadding(0)

		l:AddChild(d.centerPopup)

		l:AddPadding(0)

		l:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL)

		l:AddPadding(0)

		d.createOverlayFromFrameCheck = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_create_from_frame', MR_Overlay:Localize('Create from frame'), true, self.CREATE_FROM_FRAME, false)
		l:AddChild(d.createOverlayFromFrameCheck, LM.GUI.ALIGN_LEFT, 0)

		d.frameDlog = MR_OverlayFrameDialog:new()
		d.frameDlogPopup = LM.GUI.PopupDialog(MR_Overlay:Localize('Target frame'), false, d.FRAME_DIALOG)
		d.frameDlogPopup:SetDialog(d.frameDlog)
		l:AddChild(d.frameDlogPopup, LM.GUI.ALIGN_FILL, 0)

		l:PushV()
			l:AddPadding(-3)

			d.showLayersButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_expand', MR_Overlay:Localize('Show layers'), true, d.SHOW_LAYERS, false)
			l:AddChild(d.showLayersButton, LM.GUI.ALIGN_LEFT, 0)
		l:Pop()
	l:Pop()

	if MR_Overlay.showLayers then

		l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

		l:PushH()
			d.layer_5_visibilityCheck = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_visibility', MR_Overlay:Localize('Layer')..' 5 '..MR_Overlay:Localize('visibility'), true, self.LAYER_5_VISIBILITY, false)
			l:AddChild(d.layer_5_visibilityCheck, LM.GUI.ALIGN_LEFT, 0)

			d.layer_5_RadioButton = LM.GUI.RadioButton(MR_Overlay:Localize('Layer')..' 5  ', d.LAYER_5)
			l:AddChild(d.layer_5_RadioButton, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-13)

			d.layer_5_opacityInput = LM.GUI.TextControl(0, '150', self.LAYER_5_OPACITY, LM.GUI.FIELD_INT, '')
			l:AddChild(d.layer_5_opacityInput, LM.GUI.ALIGN_LEFT, 0)

			d.layer_5_clearButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_clear_overlay', MR_Overlay:Localize('Clear overlay'), false, self.CLEAR_OVERLAY_5, false)
			l:AddChild(d.layer_5_clearButton, LM.GUI.ALIGN_LEFT, 0)

			d.layer_5_convertButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_convert', MR_Overlay:Localize('Convert'), false, self.CONVERT_CONVERT_5, false)
			l:AddChild(d.layer_5_convertButton, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-5)

			l:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL)

			l:AddPadding(-5)

			d.layer_5_openLayerSettingsButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_settings', MR_Overlay:Localize('Open layer settings'), false, self.OPEN_LAYER_SETTINGS_5, false)
			l:AddChild(d.layer_5_openLayerSettingsButton, LM.GUI.ALIGN_LEFT, 0)

			d.layer_5_useOverlaySetupCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Use layer settings'), self.USE_OVERLAY_SETUP_5)
			l:AddChild(d.layer_5_useOverlaySetupCheck, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-3)

			d.layer_5_saveSelectionButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_save', MR_Overlay:Localize('Save selection'), false, self.SAVE_SELECTION_5, false)
			d.layer_5_saveSelectionButton:SetAlternateMessage(self.SAVE_SELECTION_5_ALT)
			l:AddChild(d.layer_5_saveSelectionButton, LM.GUI.ALIGN_LEFT, 0)

			d.layer_5_useSavedSelectionCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Use saved selection'), self.USE_SAVED_SELECTION_5)
			l:AddChild(d.layer_5_useSavedSelectionCheck, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(5)

			d.layer_5_autoGenerateCheck = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_auto_generate', MR_Overlay:Localize('Auto generate'), true, self.AUTO_GENERATE_5, false)
			l:AddChild(d.layer_5_autoGenerateCheck, LM.GUI.ALIGN_LEFT, 0)
		l:Pop()

		l:PushH()
			d.layer_4_visibilityCheck = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_visibility', MR_Overlay:Localize('Layer')..' 4 '..MR_Overlay:Localize('visibility'), true, self.LAYER_4_VISIBILITY, false)
			l:AddChild(d.layer_4_visibilityCheck, LM.GUI.ALIGN_LEFT, 0)

			d.layer_4_RadioButton = LM.GUI.RadioButton(MR_Overlay:Localize('Layer')..' 4  ', d.LAYER_4)
			l:AddChild(d.layer_4_RadioButton, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-13)

			d.layer_4_opacityInput = LM.GUI.TextControl(0, '150', self.LAYER_4_OPACITY, LM.GUI.FIELD_INT, '')
			l:AddChild(d.layer_4_opacityInput, LM.GUI.ALIGN_LEFT, 0)

			d.layer_4_clearButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_clear_overlay', MR_Overlay:Localize('Clear overlay'), false, self.CLEAR_OVERLAY_4, false)
			l:AddChild(d.layer_4_clearButton, LM.GUI.ALIGN_LEFT, 0)

			d.layer_4_convertButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_convert', MR_Overlay:Localize('Convert'), false, self.CONVERT_CONVERT_4, false)
			l:AddChild(d.layer_4_convertButton, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-5)

			l:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL)

			l:AddPadding(-5)

			d.layer_4_openLayerSettingsButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_settings', MR_Overlay:Localize('Open layer settings'), false, self.OPEN_LAYER_SETTINGS_4, false)
			l:AddChild(d.layer_4_openLayerSettingsButton, LM.GUI.ALIGN_LEFT, 0)

			d.layer_4_useOverlaySetupCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Use layer settings'), self.USE_OVERLAY_SETUP_4)
			l:AddChild(d.layer_4_useOverlaySetupCheck, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-3)

			d.layer_4_saveSelectionButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_save', MR_Overlay:Localize('Save selection'), false, self.SAVE_SELECTION_4, false)
			d.layer_4_saveSelectionButton:SetAlternateMessage(self.SAVE_SELECTION_4_ALT)
			l:AddChild(d.layer_4_saveSelectionButton, LM.GUI.ALIGN_LEFT, 0)

			d.layer_4_useSavedSelectionCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Use saved selection'), self.USE_SAVED_SELECTION_4)
			l:AddChild(d.layer_4_useSavedSelectionCheck, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(6)

			d.layer_4_autoGenerateCheck = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_auto_generate', MR_Overlay:Localize('Auto generate'), true, self.AUTO_GENERATE_4, false)
			l:AddChild(d.layer_4_autoGenerateCheck, LM.GUI.ALIGN_LEFT, 0)
		l:Pop()

		l:PushH()
			d.layer_3_visibilityCheck = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_visibility', MR_Overlay:Localize('Layer')..' 3 '..MR_Overlay:Localize('visibility'), true, self.LAYER_3_VISIBILITY, false)
			l:AddChild(d.layer_3_visibilityCheck, LM.GUI.ALIGN_LEFT, 0)

			d.layer_3_RadioButton = LM.GUI.RadioButton(MR_Overlay:Localize('Layer')..' 3  ', d.LAYER_3)
			l:AddChild(d.layer_3_RadioButton, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-13)

			d.layer_3_opacityInput = LM.GUI.TextControl(0, '150', self.LAYER_3_OPACITY, LM.GUI.FIELD_INT, '')
			l:AddChild(d.layer_3_opacityInput, LM.GUI.ALIGN_LEFT, 0)

			d.layer_3_clearButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_clear_overlay', MR_Overlay:Localize('Clear overlay'), false, self.CLEAR_OVERLAY_3, false)
			l:AddChild(d.layer_3_clearButton, LM.GUI.ALIGN_LEFT, 0)

			d.layer_3_convertButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_convert', MR_Overlay:Localize('Convert'), false, self.CONVERT_CONVERT_3, false)
			l:AddChild(d.layer_3_convertButton, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-5)

			l:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL)

			l:AddPadding(-5)

			d.layer_3_openLayerSettingsButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_settings', MR_Overlay:Localize('Open layer settings'), false, self.OPEN_LAYER_SETTINGS_3, false)
			l:AddChild(d.layer_3_openLayerSettingsButton, LM.GUI.ALIGN_LEFT, 0)

			d.layer_3_useOverlaySetupCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Use layer settings'), self.USE_OVERLAY_SETUP_3)
			l:AddChild(d.layer_3_useOverlaySetupCheck, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-3)

			d.layer_3_saveSelectionButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_save', MR_Overlay:Localize('Save selection'), false, self.SAVE_SELECTION_3, false)
			d.layer_3_saveSelectionButton:SetAlternateMessage(self.SAVE_SELECTION_3_ALT)
			l:AddChild(d.layer_3_saveSelectionButton, LM.GUI.ALIGN_LEFT, 0)

			d.layer_3_useSavedSelectionCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Use saved selection'), self.USE_SAVED_SELECTION_3)
			l:AddChild(d.layer_3_useSavedSelectionCheck, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(6)

			d.layer_3_autoGenerateCheck = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_auto_generate', MR_Overlay:Localize('Auto generate'), true, self.AUTO_GENERATE_3, false)
			l:AddChild(d.layer_3_autoGenerateCheck, LM.GUI.ALIGN_LEFT, 0)
		l:Pop()

		l:PushH()
			d.layer_2_visibilityCheck = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_visibility', MR_Overlay:Localize('Layer')..' 2 '..MR_Overlay:Localize('visibility'), true, self.LAYER_2_VISIBILITY, false)
			l:AddChild(d.layer_2_visibilityCheck, LM.GUI.ALIGN_LEFT, 0)

			d.layer_2_RadioButton = LM.GUI.RadioButton(MR_Overlay:Localize('Layer')..' 2  ', d.LAYER_2)
			l:AddChild(d.layer_2_RadioButton, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-13)

			d.layer_2_opacityInput = LM.GUI.TextControl(0, '150', self.LAYER_2_OPACITY, LM.GUI.FIELD_INT, '')
			l:AddChild(d.layer_2_opacityInput, LM.GUI.ALIGN_LEFT, 0)

			d.layer_2_clearButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_clear_overlay', MR_Overlay:Localize('Clear overlay'), false, self.CLEAR_OVERLAY_2, false)
			l:AddChild(d.layer_2_clearButton, LM.GUI.ALIGN_LEFT, 0)

			d.layer_2_convertButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_convert', MR_Overlay:Localize('Convert'), false, self.CONVERT_CONVERT_2, false)
			l:AddChild(d.layer_2_convertButton, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-5)

			l:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL)

			l:AddPadding(-5)

			d.layer_2_openLayerSettingsButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_settings', MR_Overlay:Localize('Open layer settings'), false, self.OPEN_LAYER_SETTINGS_2, false)
			l:AddChild(d.layer_2_openLayerSettingsButton, LM.GUI.ALIGN_LEFT, 0)

			d.layer_2_useOverlaySetupCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Use layer settings'), self.USE_OVERLAY_SETUP_2)
			l:AddChild(d.layer_2_useOverlaySetupCheck, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-3)

			d.layer_2_saveSelectionButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_save', MR_Overlay:Localize('Save selection'), false, self.SAVE_SELECTION_2, false)
			d.layer_2_saveSelectionButton:SetAlternateMessage(self.SAVE_SELECTION_2_ALT)
			l:AddChild(d.layer_2_saveSelectionButton, LM.GUI.ALIGN_LEFT, 0)

			d.layer_2_useSavedSelectionCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Use saved selection'), self.USE_SAVED_SELECTION_2)
			l:AddChild(d.layer_2_useSavedSelectionCheck, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(6)

			d.layer_2_autoGenerateCheck = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_auto_generate', MR_Overlay:Localize('Auto generate'), true, self.AUTO_GENERATE_2, false)
			l:AddChild(d.layer_2_autoGenerateCheck, LM.GUI.ALIGN_LEFT, 0)
		l:Pop()

		l:PushH()
			d.layer_1_visibilityCheck = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_visibility', MR_Overlay:Localize('Layer')..' 1 '..MR_Overlay:Localize('visibility'), true, self.LAYER_1_VISIBILITY, false)
			l:AddChild(d.layer_1_visibilityCheck, LM.GUI.ALIGN_LEFT, 0)

			d.layer_1_RadioButton = LM.GUI.RadioButton(MR_Overlay:Localize('Layer')..' 1  ', d.LAYER_1)
			l:AddChild(d.layer_1_RadioButton, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-13)

			d.layer_1_opacityInput = LM.GUI.TextControl(0, '150', self.LAYER_1_OPACITY, LM.GUI.FIELD_INT, '')
			l:AddChild(d.layer_1_opacityInput, LM.GUI.ALIGN_LEFT, 0)

			d.layer_1_clearButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_clear_overlay', MR_Overlay:Localize('Clear overlay'), false, self.CLEAR_OVERLAY_1, false)
			l:AddChild(d.layer_1_clearButton, LM.GUI.ALIGN_LEFT, 0)

			d.layer_1_convertButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_convert', MR_Overlay:Localize('Convert'), false, self.CONVERT_CONVERT_1, false)
			l:AddChild(d.layer_1_convertButton, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-5)

			l:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL)

			l:AddPadding(-5)

			d.layer_1_openLayerSettingsButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_settings', MR_Overlay:Localize('Open layer settings'), false, self.OPEN_LAYER_SETTINGS_1, false)
			l:AddChild(d.layer_1_openLayerSettingsButton, LM.GUI.ALIGN_LEFT, 0)

			d.layer_1_useOverlaySetupCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Use layer settings'), self.USE_OVERLAY_SETUP_1)
			l:AddChild(d.layer_1_useOverlaySetupCheck, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-3)

			d.layer_1_saveSelectionButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_save', MR_Overlay:Localize('Save selection'), false, self.SAVE_SELECTION_1, false)
			d.layer_1_saveSelectionButton:SetAlternateMessage(self.SAVE_SELECTION_1_ALT)
			l:AddChild(d.layer_1_saveSelectionButton, LM.GUI.ALIGN_LEFT, 0)

			d.layer_1_useSavedSelectionCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Use saved selection'), self.USE_SAVED_SELECTION_1)
			l:AddChild(d.layer_1_useSavedSelectionCheck, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(6)

			d.layer_1_autoGenerateCheck = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_auto_generate', MR_Overlay:Localize('Auto generate'), true, self.AUTO_GENERATE_1, false)
			l:AddChild(d.layer_1_autoGenerateCheck, LM.GUI.ALIGN_LEFT, 0)
		l:Pop()
	end

	d.dummyList = LM.GUI.ImageTextList(0, 1, LM.GUI.MSG_CANCEL)
	d.dummyList:AddItem('', false)
	l:AddChild(d.dummyList, LM.GUI.ALIGN_FILL, 0)

	return d
end

function MR_OverlayDialog:UpdateWidgets()
	local helper = MOHO.ScriptInterfaceHelper:new_local()
	local moho = helper:MohoObject()
	if moho.document == nil then
		helper:delete()
		return
	end

	self.shapesOverlayButton:SetValue(MR_Overlay.shapesOverlay)
	self.bonesOverlayButton:SetValue(MR_Overlay.bonesOverlay)
	self.pointsOverlayButton:SetValue(MR_Overlay.pointsOverlay)
	
	local opacityValue = MR_Overlay.opacityValue
	local overlayGroupLayer = MR_Overlay:CheckExistOverlayLayer(moho)
	local overlayGroupLayerExist = false
	if overlayGroupLayer then
		overlayGroupLayerExist = true
		local scriptData = overlayGroupLayer:ScriptData()
		local mainOpacity = scriptData:GetInt('MR Overlay Main Opacity')
		if mainOpacity ~= nil then
			opacityValue = mainOpacity
		end
	end
	self.showHideOverlayCheck:Enable(overlayGroupLayerExist)
	if overlayGroupLayer then
		self.showHideOverlayCheck:SetValue(overlayGroupLayer:IsVisible())
		self.deleteOverlayButton:Enable(true)
	else
		self.deleteOverlayButton:Enable(false)
	end

	self.overlayOpacityInput:SetValue(opacityValue)

	self.flipOverlayCheck:SetValue(MR_Overlay.flipOverlay)
	self.mirrorOverlayCheck:SetValue(MR_Overlay.mirrorFlip)
	self.mirrorOverlayCheck:Enable(MR_Overlay.flipOverlay)
	self.mirrorOverlayShadeCheck:SetValue(MR_Overlay.mirrorOverlayShade)
	self.mirrorOverlayShadeCheck:Enable(MR_Overlay.flipOverlay and MR_Overlay.mirrorFlip)
	
	self.centerMenu:SetChecked(self.SELECTION_CENTER, MR_Overlay.selectionCenter)
	self.centerMenu:SetChecked(self.LAYER_ORIGIN, MR_Overlay.layerOriginCenter)
	self.centerMenu:SetChecked(self.CUSTOM_CENTER, MR_Overlay.customCenter)
	
	self.centerPopup:Redraw()

	self.createOverlayFromFrameCheck:SetValue(MR_Overlay.createOverlayFromFrame)

	self.showLayersButton:SetValue(MR_Overlay.showLayers)

	-- Layers
	if MR_Overlay.showLayers and self.layer_1_visibilityCheck ~= nil then
		local layer_1_opacity = MR_Overlay.layer_1_opacity
		local layer_2_opacity = MR_Overlay.layer_2_opacity
		local layer_3_opacity = MR_Overlay.layer_3_opacity
		local layer_4_opacity = MR_Overlay.layer_4_opacity
		local layer_5_opacity = MR_Overlay.layer_5_opacity

		local overlayGroupLayer = MR_Overlay:CheckExistOverlayLayer(moho)
		if overlayGroupLayer then
			local scriptData = overlayGroupLayer:ScriptData()
			if scriptData:HasKey('MR Overlay Active Layer') then
				MR_Overlay.activeLayer = scriptData:GetInt('MR Overlay Active Layer')
			else
				MR_Overlay.activeLayer = 1
			end
			if scriptData:HasKey('MR Overlay Layer 1 visibility') then
				MR_Overlay.layer_1_visibility = scriptData:GetBool('MR Overlay Layer 1 visibility')
			else
				MR_Overlay.layer_1_visibility = true
			end
			if scriptData:HasKey('MR Overlay Layer 2 visibility') then
				MR_Overlay.layer_2_visibility = scriptData:GetBool('MR Overlay Layer 2 visibility')
			else
				MR_Overlay.layer_2_visibility = true
			end
			if scriptData:HasKey('MR Overlay Layer 3 visibility') then
				MR_Overlay.layer_3_visibility = scriptData:GetBool('MR Overlay Layer 3 visibility')
			else
				MR_Overlay.layer_3_visibility = true
			end
			if scriptData:HasKey('MR Overlay Layer 4 visibility') then
				MR_Overlay.layer_4_visibility = scriptData:GetBool('MR Overlay Layer 4 visibility')
			else
				MR_Overlay.layer_4_visibility = true
			end
			if scriptData:HasKey('MR Overlay Layer 5 visibility') then
				MR_Overlay.layer_5_visibility = scriptData:GetBool('MR Overlay Layer 5 visibility')
			else
				MR_Overlay.layer_5_visibility = true
			end

			local layer1Opacity = scriptData:GetInt('MR Overlay Layer 1 opacity')
			if layer1Opacity ~= nil then
				layer_1_opacity = layer1Opacity
			end
			local layer2Opacity = scriptData:GetInt('MR Overlay Layer 2 opacity')
			if layer2Opacity ~= nil then
				layer_2_opacity = layer2Opacity
			end
			local layer3Opacity = scriptData:GetInt('MR Overlay Layer 3 opacity')
			if layer3Opacity ~= nil then
				layer_3_opacity = layer3Opacity
			end
			local layer4Opacity = scriptData:GetInt('MR Overlay Layer 4 opacity')
			if layer4Opacity ~= nil then
				layer_4_opacity = layer4Opacity
			end
			local layer5Opacity = scriptData:GetInt('MR Overlay Layer 5 opacity')
			if layer5Opacity ~= nil then
				layer_5_opacity = layer5Opacity
			end

			-- Selection
			local layer1Selection = scriptData:GetString('MR Overlay Layer Selection 1')
			if #layer1Selection > 0 then
				self.layer_1_useSavedSelectionCheck:Enable(true)
			else
				self.layer_1_useSavedSelectionCheck:Enable(false)
			end

			local layer2Selection = scriptData:GetString('MR Overlay Layer Selection 2')
			if #layer2Selection > 0 then
				self.layer_2_useSavedSelectionCheck:Enable(true)
			else
				self.layer_2_useSavedSelectionCheck:Enable(false)
			end

			local layer3Selection = scriptData:GetString('MR Overlay Layer Selection 3')
			if #layer3Selection > 0 then
				self.layer_3_useSavedSelectionCheck:Enable(true)
			else
				self.layer_3_useSavedSelectionCheck:Enable(false)
			end

			local layer4Selection = scriptData:GetString('MR Overlay Layer Selection 4')
			if #layer4Selection > 0 then
				self.layer_4_useSavedSelectionCheck:Enable(true)
			else
				self.layer_4_useSavedSelectionCheck:Enable(false)
			end

			local layer5Selection = scriptData:GetString('MR Overlay Layer Selection 5')
			if #layer5Selection > 0 then
				self.layer_5_useSavedSelectionCheck:Enable(true)
			else
				self.layer_5_useSavedSelectionCheck:Enable(false)
			end

			local layer1UseSelection = scriptData:GetBool('MR Overlay Use Layer Selection 1')
			if layer1UseSelection then
				MR_Overlay.layer_1_useSavedSelection = true
			else
				MR_Overlay.layer_1_useSavedSelection = false
			end
			self.layer_1_useSavedSelectionCheck:SetValue(MR_Overlay.layer_1_useSavedSelection)

			if MR_Overlay.layer_1_useSavedSelection and #layer1Selection > 0 then
				self.layer_1_autoGenerateCheck:Enable(true)
			else
				self.layer_1_autoGenerateCheck:Enable(false)
			end

			local layer2UseSelection = scriptData:GetBool('MR Overlay Use Layer Selection 2')
			if layer2UseSelection then
				MR_Overlay.layer_2_useSavedSelection = true
			else
				MR_Overlay.layer_2_useSavedSelection = false
			end
			self.layer_2_useSavedSelectionCheck:SetValue(MR_Overlay.layer_2_useSavedSelection)

			if MR_Overlay.layer_2_useSavedSelection and #layer2Selection > 0 then
				self.layer_2_autoGenerateCheck:Enable(true)
			else
				self.layer_2_autoGenerateCheck:Enable(false)
			end

			local layer3UseSelection = scriptData:GetBool('MR Overlay Use Layer Selection 3')
			if layer3UseSelection then
				MR_Overlay.layer_3_useSavedSelection = true
			else
				MR_Overlay.layer_3_useSavedSelection = false
			end
			self.layer_3_useSavedSelectionCheck:SetValue(MR_Overlay.layer_3_useSavedSelection)

			if MR_Overlay.layer_3_useSavedSelection and #layer3Selection > 0 then
				self.layer_3_autoGenerateCheck:Enable(true)
			else
				self.layer_3_autoGenerateCheck:Enable(false)
			end

			local layer4UseSelection = scriptData:GetBool('MR Overlay Use Layer Selection 4')
			if layer4UseSelection then
				MR_Overlay.layer_4_useSavedSelection = true
			else
				MR_Overlay.layer_4_useSavedSelection = false
			end
			self.layer_4_useSavedSelectionCheck:SetValue(MR_Overlay.layer_4_useSavedSelection)

			if MR_Overlay.layer_4_useSavedSelection and #layer4Selection > 0 then
				self.layer_4_autoGenerateCheck:Enable(true)
			else
				self.layer_4_autoGenerateCheck:Enable(false)
			end

			local layer5UseSelection = scriptData:GetBool('MR Overlay Use Layer Selection 5')
			if layer5UseSelection then
				MR_Overlay.layer_5_useSavedSelection = true
			else
				MR_Overlay.layer_5_useSavedSelection = false
			end
			self.layer_5_useSavedSelectionCheck:SetValue(MR_Overlay.layer_5_useSavedSelection)

			if MR_Overlay.layer_5_useSavedSelection and #layer5Selection > 0 then
				self.layer_5_autoGenerateCheck:Enable(true)
			else
				self.layer_5_autoGenerateCheck:Enable(false)
			end

			-- Overlay Setup
			local mode1 = scriptData:GetString('MR Overlay Setup Mode 1')
			if #mode1 > 0 then
				self.layer_1_useOverlaySetupCheck:Enable(true)
			else
				self.layer_1_useOverlaySetupCheck:Enable(false)
			end

			local mode2 = scriptData:GetString('MR Overlay Setup Mode 2')
			if #mode2 > 0 then
				self.layer_2_useOverlaySetupCheck:Enable(true)
			else
				self.layer_2_useOverlaySetupCheck:Enable(false)
			end

			local mode3 = scriptData:GetString('MR Overlay Setup Mode 3')
			if #mode3 > 0 then
				self.layer_3_useOverlaySetupCheck:Enable(true)
			else
				self.layer_3_useOverlaySetupCheck:Enable(false)
			end

			local mode4 = scriptData:GetString('MR Overlay Setup Mode 4')
			if #mode4 > 0 then
				self.layer_4_useOverlaySetupCheck:Enable(true)
			else
				self.layer_4_useOverlaySetupCheck:Enable(false)
			end

			local mode5 = scriptData:GetString('MR Overlay Setup Mode 5')
			if #mode5 > 0 then
				self.layer_5_useOverlaySetupCheck:Enable(true)
			else
				self.layer_5_useOverlaySetupCheck:Enable(false)
			end

			local layer1UseOverlaySetup = scriptData:GetBool('MR Overlay Use Overlay Setup 1')
			if layer1UseOverlaySetup then
				MR_Overlay.layer_1_useOverlaySetup = true
			else
				MR_Overlay.layer_1_useOverlaySetup = false
			end
			self.layer_1_useOverlaySetupCheck:SetValue(MR_Overlay.layer_1_useOverlaySetup)

			local layer2UseOverlaySetup = scriptData:GetBool('MR Overlay Use Overlay Setup 2')
			if layer2UseOverlaySetup then
				MR_Overlay.layer_2_useOverlaySetup = true
			else
				MR_Overlay.layer_2_useOverlaySetup = false
			end
			self.layer_2_useOverlaySetupCheck:SetValue(MR_Overlay.layer_2_useOverlaySetup)

			local layer3UseOverlaySetup = scriptData:GetBool('MR Overlay Use Overlay Setup 3')
			if layer3UseOverlaySetup then
				MR_Overlay.layer_3_useOverlaySetup = true
			else
				MR_Overlay.layer_3_useOverlaySetup = false
			end
			self.layer_3_useOverlaySetupCheck:SetValue(MR_Overlay.layer_3_useOverlaySetup)

			local layer4UseOverlaySetup = scriptData:GetBool('MR Overlay Use Overlay Setup 4')
			if layer4UseOverlaySetup then
				MR_Overlay.layer_4_useOverlaySetup = true
			else
				MR_Overlay.layer_4_useOverlaySetup = false
			end
			self.layer_4_useOverlaySetupCheck:SetValue(MR_Overlay.layer_4_useOverlaySetup)

			local layer5UseOverlaySetup = scriptData:GetBool('MR Overlay Use Overlay Setup 5')
			if layer5UseOverlaySetup then
				MR_Overlay.layer_5_useOverlaySetup = true
			else
				MR_Overlay.layer_5_useOverlaySetup = false
			end
			self.layer_5_useOverlaySetupCheck:SetValue(MR_Overlay.layer_5_useOverlaySetup)

			local autoGenerate1 = scriptData:GetBool('MR Overlay Auto Generate 1')
			self.layer_1_autoGenerateCheck:SetValue(autoGenerate1)

			local autoGenerate2 = scriptData:GetBool('MR Overlay Auto Generate 2')
			self.layer_2_autoGenerateCheck:SetValue(autoGenerate2)

			local autoGenerate3 = scriptData:GetBool('MR Overlay Auto Generate 3')
			self.layer_3_autoGenerateCheck:SetValue(autoGenerate3)

			local autoGenerate4 = scriptData:GetBool('MR Overlay Auto Generate 4')
			self.layer_4_autoGenerateCheck:SetValue(autoGenerate4)

			local autoGenerate5 = scriptData:GetBool('MR Overlay Auto Generate 5')
			self.layer_5_autoGenerateCheck:SetValue(autoGenerate5)

			self.layer_1_saveSelectionButton:Enable(true)
			self.layer_2_saveSelectionButton:Enable(true)
			self.layer_3_saveSelectionButton:Enable(true)
			self.layer_4_saveSelectionButton:Enable(true)
			self.layer_5_saveSelectionButton:Enable(true)

			self.layer_1_opacityInput:SetValue(layer_1_opacity)
			self.layer_2_opacityInput:SetValue(layer_2_opacity)
			self.layer_3_opacityInput:SetValue(layer_3_opacity)
			self.layer_4_opacityInput:SetValue(layer_4_opacity)
			self.layer_5_opacityInput:SetValue(layer_5_opacity)

			self.layer_5_openLayerSettingsButton:Enable(true)
			self.layer_4_openLayerSettingsButton:Enable(true)
			self.layer_3_openLayerSettingsButton:Enable(true)
			self.layer_2_openLayerSettingsButton:Enable(true)
			self.layer_1_openLayerSettingsButton:Enable(true)
		elseif not MR_Overlay.activeLayer then
			self.activeLayer = 1
			MR_Overlay.layer_1_visibility = true
			MR_Overlay.layer_2_visibility = true
			MR_Overlay.layer_3_visibility = true
			MR_Overlay.layer_4_visibility = true
			MR_Overlay.layer_5_visibility = true
		else
			self.layer_1_saveSelectionButton:Enable(false)
			self.layer_2_saveSelectionButton:Enable(false)
			self.layer_3_saveSelectionButton:Enable(false)
			self.layer_4_saveSelectionButton:Enable(false)
			self.layer_5_saveSelectionButton:Enable(false)

			self.layer_1_useSavedSelectionCheck:Enable(false)
			self.layer_2_useSavedSelectionCheck:Enable(false)
			self.layer_3_useSavedSelectionCheck:Enable(false)
			self.layer_4_useSavedSelectionCheck:Enable(false)
			self.layer_5_useSavedSelectionCheck:Enable(false)

			self.layer_1_useSavedSelectionCheck:SetValue(false)
			self.layer_2_useSavedSelectionCheck:SetValue(false)
			self.layer_3_useSavedSelectionCheck:SetValue(false)
			self.layer_4_useSavedSelectionCheck:SetValue(false)
			self.layer_5_useSavedSelectionCheck:SetValue(false)

			self.layer_1_openLayerSettingsButton:Enable(false)
			self.layer_2_openLayerSettingsButton:Enable(false)
			self.layer_3_openLayerSettingsButton:Enable(false)
			self.layer_4_openLayerSettingsButton:Enable(false)
			self.layer_5_openLayerSettingsButton:Enable(false)

			self.layer_1_useOverlaySetupCheck:Enable(false)
			self.layer_2_useOverlaySetupCheck:Enable(false)
			self.layer_3_useOverlaySetupCheck:Enable(false)
			self.layer_4_useOverlaySetupCheck:Enable(false)
			self.layer_5_useOverlaySetupCheck:Enable(false)

			self.layer_1_useOverlaySetupCheck:SetValue(false)
			self.layer_2_useOverlaySetupCheck:SetValue(false)
			self.layer_3_useOverlaySetupCheck:SetValue(false)
			self.layer_4_useOverlaySetupCheck:SetValue(false)
			self.layer_5_useOverlaySetupCheck:SetValue(false)

			self.layer_1_autoGenerateCheck:Enable(false)
			self.layer_2_autoGenerateCheck:Enable(false)
			self.layer_3_autoGenerateCheck:Enable(false)
			self.layer_4_autoGenerateCheck:Enable(false)
			self.layer_5_autoGenerateCheck:Enable(false)
			
			self.layer_1_autoGenerateCheck:SetValue(false)
			self.layer_2_autoGenerateCheck:SetValue(false)
			self.layer_3_autoGenerateCheck:SetValue(false)
			self.layer_4_autoGenerateCheck:SetValue(false)
			self.layer_5_autoGenerateCheck:SetValue(false)
		end

		self.layer_1_visibilityCheck:SetValue(MR_Overlay.layer_1_visibility)
		self.layer_2_visibilityCheck:SetValue(MR_Overlay.layer_2_visibility)
		self.layer_3_visibilityCheck:SetValue(MR_Overlay.layer_3_visibility)
		self.layer_4_visibilityCheck:SetValue(MR_Overlay.layer_4_visibility)
		self.layer_5_visibilityCheck:SetValue(MR_Overlay.layer_5_visibility)

		if overlayGroupLayer then
			for l=1, 5 do
				for i=0, moho:LayerAsGroup(overlayGroupLayer):CountLayers()-1 do
					local layer = overlayGroupLayer:Layer(i)
					local layerScriptData = layer:ScriptData()
					if layerScriptData:HasKey('MR Overlay Layer '..math.floor(l)) then
						local meshLayer = moho:LayerAsVector(layer)
						if meshLayer then
							local mesh = meshLayer:Mesh()
							if mesh then
								local points = mesh:CountPoints()
								if points > 0 then
									self['layer_'..math.floor(l)..'_visibilityCheck']:Enable(true)
									self['layer_'..math.floor(l)..'_clearButton']:Enable(true)
									self['layer_'..math.floor(l)..'_convertButton']:Enable(true)
								else
									self['layer_'..math.floor(l)..'_visibilityCheck']:Enable(false)
									self['layer_'..math.floor(l)..'_visibilityCheck']:SetValue(false)
									self['layer_'..math.floor(l)..'_clearButton']:Enable(false)
									self['layer_'..math.floor(l)..'_convertButton']:Enable(false)
								end
							end
						end
					end
				end
			end
		else
			for l=1, 5 do
				self['layer_'..math.floor(l)..'_visibilityCheck']:Enable(false)
				self['layer_'..math.floor(l)..'_visibilityCheck']:SetValue(false)
				self['layer_'..math.floor(l)..'_clearButton']:Enable(false)
				self['layer_'..math.floor(l)..'_convertButton']:Enable(false)
			end
		end

		if MR_Overlay.activeLayer == 1 then
			self.layer_1_RadioButton:SetValue(true)
			self.layer_2_RadioButton:SetValue(false)
			self.layer_3_RadioButton:SetValue(false)
			self.layer_4_RadioButton:SetValue(false)
			self.layer_5_RadioButton:SetValue(false)
		elseif MR_Overlay.activeLayer == 2 then
			self.layer_1_RadioButton:SetValue(false)
			self.layer_2_RadioButton:SetValue(true)
			self.layer_3_RadioButton:SetValue(false)
			self.layer_4_RadioButton:SetValue(false)
			self.layer_5_RadioButton:SetValue(false)
		elseif MR_Overlay.activeLayer == 3 then
			self.layer_1_RadioButton:SetValue(false)
			self.layer_2_RadioButton:SetValue(false)
			self.layer_3_RadioButton:SetValue(true)
			self.layer_4_RadioButton:SetValue(false)
			self.layer_5_RadioButton:SetValue(false)
		elseif MR_Overlay.activeLayer == 4 then
			self.layer_1_RadioButton:SetValue(false)
			self.layer_2_RadioButton:SetValue(false)
			self.layer_3_RadioButton:SetValue(false)
			self.layer_4_RadioButton:SetValue(true)
			self.layer_5_RadioButton:SetValue(false)
		elseif MR_Overlay.activeLayer == 5 then
			self.layer_1_RadioButton:SetValue(false)
			self.layer_2_RadioButton:SetValue(false)
			self.layer_3_RadioButton:SetValue(false)
			self.layer_4_RadioButton:SetValue(false)
			self.layer_5_RadioButton:SetValue(true)
		end
	end

	helper:delete()
end

function MR_OverlayDialog:OnOK(moho)
	MR_Overlay.overlayDlog = nil
	if MR_Overlay.needReopen then
		MR_Overlay:Run(moho)
		MR_Overlay.needReopen = false
	else
		MR_Overlay.overlayDlog = nil
		MR_Overlay.needReopen = false
	end
end

function MR_OverlayDialog:HandleMessage(msg)
	if MR_ActivityTimeTracker then
		MR_ActivityTimeTracker.propogateTool = 'MR_Overlay'
	end
	
	local helper = MOHO.ScriptInterfaceHelper:new_local()
	local moho = helper:MohoObject()
	local document = moho.document
	
	if msg == self.CREATE_OVERLAY then
		if document then
			MR_Overlay:CreateOverlay(moho)
			local overlayLayer = MR_Overlay:CheckExistOverlayLayer(moho)
			if overlayLayer ~= nil and moho.document:IsLayerValid(overlayLayer) then
				overlayLayer:SetVisible(true)
				moho:UpdateUI()
				moho.view:DrawMe()
			end
		end
	elseif msg == self.CREATE_OVERLAY_ALT then
		if document then
			local overlayGroupLayer = MR_Overlay:CheckExistOverlayLayer(moho)
			if overlayGroupLayer == nil then
				moho.document:PrepUndo(nil)
				moho.document:SetDirty()
				local curLayer = moho.layer
				local curFrame = moho.frame
				local curAction = moho.document:CurrentDocAction()
				local secondarySelectionList = {}
				local primarySelectedLayer = moho.layer
				for l = 0, moho.document:CountSelectedLayers()-1 do
					local layer = moho.document:GetSelectedLayer(l)
					if layer:SecondarySelection() then
						table.insert(secondarySelectionList, layer)
					end
				end
				local topLayer = moho.document:Layer(moho.document:CountLayers()-1)
				moho:SetSelLayer(topLayer)
				MR_Overlay:GetOverlayLayer(moho, topLayer)
				MR_Overlay:ReturnToAction(moho, curAction, curLayer, curFrame)
				moho:SetSelLayer(primarySelectedLayer)
				for _, layer in ipairs(secondarySelectionList) do
					layer:SetSecondarySelection(true)
				end

				moho:UpdateUI() 
				moho.view:DrawMe()
			end
		end
	elseif msg == self.SET_CUSTOM_PIVOT then
		if document then
			MR_Overlay.customCenterValueX, MR_Overlay.customCenterValueY = MR_Overlay:SetCustomCenter(moho, false)
		end
	elseif msg == self.SET_CUSTOM_PIVOT_ALT then
		if document then
			self.customCenterValueX, self.customCenterValueY = MR_Overlay:SetCustomCenter(moho, true)
		end
	elseif msg == self.SHOW_HIDE_OVERLAY then
		if document then
			local overlayLayer = MR_Overlay:CheckExistOverlayLayer(moho)
			if overlayLayer ~= nil and moho.document:IsLayerValid(overlayLayer) then
				overlayLayer:SetVisible(self.showHideOverlayCheck:Value())
				moho:UpdateUI()
				moho.view:DrawMe()
			end
		end
	elseif msg == self.DELETE_OVERLAY then
		if document then
			local overlayLayer = MR_Overlay:CheckExistOverlayLayer(moho)
			if overlayLayer then
				MR_Overlay:DeleteOverlayLayer(moho, overlayLayer)
				self:UpdateWidgets()
			end
		end
	elseif msg == self.SHAPES_OVERLAY then
		MR_Overlay.shapesOverlay = true
		self.shapesOverlayButton:SetValue(true)
		MR_Overlay.bonesOverlay = false
		self.bonesOverlayButton:SetValue(false)
		MR_Overlay.pointsOverlay = false
		self.pointsOverlayButton:SetValue(false)
	elseif msg == self.BONES_OVERLAY then
		MR_Overlay.shapesOverlay = false
		self.shapesOverlayButton:SetValue(false)
		MR_Overlay.bonesOverlay = true
		self.bonesOverlayButton:SetValue(true)
		MR_Overlay.pointsOverlay = false
		self.pointsOverlayButton:SetValue(false)
	elseif msg == self.POINTS_OVERLAY then
		MR_Overlay.shapesOverlay = false
		self.shapesOverlayButton:SetValue(false)
		MR_Overlay.bonesOverlay = false
		self.bonesOverlayButton:SetValue(false)
		MR_Overlay.pointsOverlay = true
		self.pointsOverlayButton:SetValue(true)
	elseif msg == self.OVERLAY_OPACITY then
		if document then
			MR_Overlay.opacityValue = LM.Clamp(self.overlayOpacityInput:Value(), 0, 100)
			self.overlayOpacityInput:SetValue(MR_Overlay.opacityValue)

			local overlayGroupLayer = MR_Overlay:CheckExistOverlayLayer(moho)
			if overlayGroupLayer then
				local opacityValue = MR_Overlay.opacityValue

				local scriptData = overlayGroupLayer:ScriptData()
				scriptData:Set("MR Overlay Main Opacity", opacityValue)
				moho.document:SetDirty()
				moho.document:PrepUndo(overlayGroupLayer, true)
				overlayGroupLayer.fAlpha:SetValue(0, opacityValue/100)
				moho:UpdateUI()
				moho.view:DrawMe()
				overlayGroupLayer:UpdateCurFrame()
			end
		end
	elseif msg == self.FLIP_OVERLAY then
		MR_Overlay.flipOverlay = self.flipOverlayCheck:Value()
		self.mirrorOverlayCheck:Enable(MR_Overlay.flipOverlay)
		self.mirrorOverlayShadeCheck:Enable(MR_Overlay.flipOverlay and MR_Overlay.mirrorFlip)
	elseif msg == self.MIRROR_OVERLAY then
		MR_Overlay.mirrorFlip = self.mirrorOverlayCheck:Value()
		self.mirrorOverlayShadeCheck:Enable(MR_Overlay.flipOverlay and MR_Overlay.mirrorFlip)
	elseif msg == self.MIRROR_OVERLAY_SHADE then
		MR_Overlay.mirrorOverlayShade = self.mirrorOverlayShadeCheck:Value()
	elseif msg == self.SELECTION_CENTER then
		MR_Overlay.selectionCenter = true
		MR_Overlay.layerOriginCenter = false
		MR_Overlay.customCenter = false
	elseif msg == self.CREATE_FROM_FRAME then
		MR_Overlay.createOverlayFromFrame = self.createOverlayFromFrameCheck:Value()
	elseif msg == self.LAYER_ORIGIN then
		MR_Overlay.selectionCenter = false
		MR_Overlay.layerOriginCenter = true
		MR_Overlay.customCenter = false
	elseif msg == self.CUSTOM_CENTER then
		MR_Overlay.selectionCenter = false
		MR_Overlay.layerOriginCenter = false
		MR_Overlay.customCenter = true
	elseif msg == self.SHOW_LAYERS then
		MR_Overlay.showLayers = self.showLayersButton:Value()
		self.dummyList:SetSelItem(self.dummyList:GetItem(0), false)
		if MR_Overlay.overlayDlog then
			MR_Overlay.overlayDlog = nil
			MR_Overlay.needReopen = true
		end
	elseif msg == self.LAYER_1 then
		if document then
			MR_Overlay.activeLayer = 1
			self.layer_1_RadioButton:SetValue(true)
			self.layer_2_RadioButton:SetValue(false)
			self.layer_3_RadioButton:SetValue(false)
			self.layer_4_RadioButton:SetValue(false)
			self.layer_5_RadioButton:SetValue(false)
			local overlayGroupLayer = MR_Overlay:CheckExistOverlayLayer(moho)
			if overlayGroupLayer then
				local scriptData = overlayGroupLayer:ScriptData()
				scriptData:Set('MR Overlay Active Layer', MR_Overlay.activeLayer)
			end
		end
	elseif msg == self.LAYER_2 then
		if document then
			MR_Overlay.activeLayer = 2
			self.layer_1_RadioButton:SetValue(false)
			self.layer_2_RadioButton:SetValue(true)
			self.layer_3_RadioButton:SetValue(false)
			self.layer_4_RadioButton:SetValue(false)
			self.layer_5_RadioButton:SetValue(false)
			local overlayGroupLayer = MR_Overlay:CheckExistOverlayLayer(moho)
			if overlayGroupLayer then
				local scriptData = overlayGroupLayer:ScriptData()
				scriptData:Set('MR Overlay Active Layer', MR_Overlay.activeLayer)
			end
		end
	elseif msg == self.LAYER_3 then
		if document then
			MR_Overlay.activeLayer = 3
			self.layer_1_RadioButton:SetValue(false)
			self.layer_2_RadioButton:SetValue(false)
			self.layer_3_RadioButton:SetValue(true)
			self.layer_4_RadioButton:SetValue(false)
			self.layer_5_RadioButton:SetValue(false)
			local overlayGroupLayer = MR_Overlay:CheckExistOverlayLayer(moho)
			if overlayGroupLayer then
				local scriptData = overlayGroupLayer:ScriptData()
				scriptData:Set('MR Overlay Active Layer', MR_Overlay.activeLayer)
			end
		end
	elseif msg == self.LAYER_4 then
		if document then
			MR_Overlay.activeLayer = 4
			self.layer_1_RadioButton:SetValue(false)
			self.layer_2_RadioButton:SetValue(false)
			self.layer_3_RadioButton:SetValue(false)
			self.layer_4_RadioButton:SetValue(true)
			self.layer_5_RadioButton:SetValue(false)
			local overlayGroupLayer = MR_Overlay:CheckExistOverlayLayer(moho)
			if overlayGroupLayer then
				local scriptData = overlayGroupLayer:ScriptData()
				scriptData:Set('MR Overlay Active Layer', MR_Overlay.activeLayer)
			end
		end
	elseif msg == self.LAYER_5 then
		if document then
			MR_Overlay.activeLayer = 5
			self.layer_1_RadioButton:SetValue(false)
			self.layer_2_RadioButton:SetValue(false)
			self.layer_3_RadioButton:SetValue(false)
			self.layer_4_RadioButton:SetValue(false)
			self.layer_5_RadioButton:SetValue(true)
			local overlayGroupLayer = MR_Overlay:CheckExistOverlayLayer(moho)
			if overlayGroupLayer then
				local scriptData = overlayGroupLayer:ScriptData()
				scriptData:Set('MR Overlay Active Layer', MR_Overlay.activeLayer)
			end
		end
	elseif msg >= self.LAYER_1_VISIBILITY and msg <= self.LAYER_5_VISIBILITY then
		if document then
			MR_Overlay.layer_1_visibility = self.layer_1_visibilityCheck:Value()
			MR_Overlay.layer_2_visibility = self.layer_2_visibilityCheck:Value()
			MR_Overlay.layer_3_visibility = self.layer_3_visibilityCheck:Value()
			MR_Overlay.layer_4_visibility = self.layer_4_visibilityCheck:Value()
			MR_Overlay.layer_5_visibility = self.layer_5_visibilityCheck:Value()
			local overlayGroupLayer = MR_Overlay:CheckExistOverlayLayer(moho)
			if overlayGroupLayer then
				local scriptData = overlayGroupLayer:ScriptData()
				scriptData:Set("MR Overlay Layer 1 visibility", MR_Overlay.layer_1_visibility)
				scriptData:Set("MR Overlay Layer 2 visibility", MR_Overlay.layer_2_visibility)
				scriptData:Set("MR Overlay Layer 3 visibility", MR_Overlay.layer_3_visibility)
				scriptData:Set("MR Overlay Layer 4 visibility", MR_Overlay.layer_4_visibility)
				scriptData:Set("MR Overlay Layer 5 visibility", MR_Overlay.layer_5_visibility)
				for l=1, 5 do
					for i=0, moho:LayerAsGroup(overlayGroupLayer):CountLayers()-1 do
						local layer = overlayGroupLayer:Layer(i)
						local layerScriptData = layer:ScriptData()
						if layerScriptData:HasKey('MR Overlay Layer '..math.floor(l)) then
							layer:SetVisible(MR_Overlay['layer_'..math.floor(l)..'_visibility'])
						end
					end
				end
				moho:UpdateUI()
				moho.view:DrawMe()
			end
		end
	elseif msg >= self.LAYER_1_OPACITY and msg <= self.LAYER_5_OPACITY then
		if document then
			MR_Overlay.layer_1_opacityValue = LM.Clamp(self.layer_1_opacityInput:Value(), 0, 100)
			MR_Overlay.layer_2_opacityValue = LM.Clamp(self.layer_2_opacityInput:Value(), 0, 100)
			MR_Overlay.layer_3_opacityValue = LM.Clamp(self.layer_3_opacityInput:Value(), 0, 100)
			MR_Overlay.layer_4_opacityValue = LM.Clamp(self.layer_4_opacityInput:Value(), 0, 100)
			MR_Overlay.layer_5_opacityValue = LM.Clamp(self.layer_5_opacityInput:Value(), 0, 100)
			self.layer_1_opacityInput:SetValue(MR_Overlay.layer_1_opacityValue)
			self.layer_2_opacityInput:SetValue(MR_Overlay.layer_2_opacityValue)
			self.layer_3_opacityInput:SetValue(MR_Overlay.layer_3_opacityValue)
			self.layer_4_opacityInput:SetValue(MR_Overlay.layer_4_opacityValue)
			self.layer_5_opacityInput:SetValue(MR_Overlay.layer_5_opacityValue)
			local overlayGroupLayer = MR_Overlay:CheckExistOverlayLayer(moho)
			if overlayGroupLayer then
				local scriptData = overlayGroupLayer:ScriptData()
				scriptData:Set("MR Overlay Layer 1 opacity", MR_Overlay.layer_1_opacityValue)
				scriptData:Set("MR Overlay Layer 2 opacity", MR_Overlay.layer_2_opacityValue)
				scriptData:Set("MR Overlay Layer 3 opacity", MR_Overlay.layer_3_opacityValue)
				scriptData:Set("MR Overlay Layer 4 opacity", MR_Overlay.layer_4_opacityValue)
				scriptData:Set("MR Overlay Layer 5 opacity", MR_Overlay.layer_5_opacityValue)
				for l=1, 5 do
					for i=0, moho:LayerAsGroup(overlayGroupLayer):CountLayers()-1 do
						local layer = overlayGroupLayer:Layer(i)
						local layerScriptData = layer:ScriptData()
						if layerScriptData:HasKey('MR Overlay Layer '..math.floor(l)) then
							layer.fAlpha:SetValue(0, MR_Overlay['layer_'..math.floor(l)..'_opacityValue']/100)
							layer:UpdateCurFrame()
						end
					end
				end
				moho:UpdateUI()
				moho.view:DrawMe()
			end
		end
	elseif msg >= self.CLEAR_OVERLAY_1 and msg <= self.CLEAR_OVERLAY_5 then
		if document then
			local overlayGroupLayer = MR_Overlay:CheckExistOverlayLayer(moho)
			if overlayGroupLayer then
				local overlayLayerKey = ''
				if msg == self.CLEAR_OVERLAY_1 then
					overlayLayerKey = 'MR Overlay Layer 1'
				elseif msg == self.CLEAR_OVERLAY_2 then
					overlayLayerKey = 'MR Overlay Layer 2'
				elseif msg == self.CLEAR_OVERLAY_3 then
					overlayLayerKey = 'MR Overlay Layer 3'
				elseif msg == self.CLEAR_OVERLAY_4 then
					overlayLayerKey = 'MR Overlay Layer 4'
				elseif msg == self.CLEAR_OVERLAY_5 then
					overlayLayerKey = 'MR Overlay Layer 5'
				end
				if overlayLayerKey == '' then
					return
				end

				for i=0, moho:LayerAsGroup(overlayGroupLayer):CountLayers()-1 do
					local layer = overlayGroupLayer:Layer(i)
					local layerScriptData = layer:ScriptData()
					if layerScriptData:HasKey(overlayLayerKey) then
						local meshLayer = moho:LayerAsVector(layer)
						if meshLayer then
							local mesh = meshLayer:Mesh()
							if mesh then
								moho.document:PrepUndo(layer, true)
								moho.document:SetDirty()
								mesh:Clear()
								layer:UpdateCurFrame()
								moho.view:DrawMe()
								break
							end
						end
					end
				end
				self:UpdateWidgets()
			end
		end
	elseif msg >= self.CONVERT_CONVERT_1 and msg <= self.CONVERT_CONVERT_5 then
		if document then
			local overlayGroupLayer = MR_Overlay:CheckExistOverlayLayer(moho)
			if overlayGroupLayer then
				local overlayLayerKey = ''
				if msg == self.CONVERT_CONVERT_1 then
					overlayLayerKey = 'MR Overlay Layer 1'
				elseif msg == self.CONVERT_CONVERT_2 then
					overlayLayerKey = 'MR Overlay Layer 2'
				elseif msg == self.CONVERT_CONVERT_3 then
					overlayLayerKey = 'MR Overlay Layer 3'
				elseif msg == self.CONVERT_CONVERT_4 then
					overlayLayerKey = 'MR Overlay Layer 4'
				elseif msg == self.CONVERT_CONVERT_5 then
					overlayLayerKey = 'MR Overlay Layer 5'
				end
				if overlayLayerKey == '' then
					return
				end

				moho.document:PrepUndo(nil)
				moho.document:SetDirty()

				local curLayer = moho.layer
				local secondarySelectionList = {}
				local primarySelectedLayer = nil
				for l = 0, moho.document:CountSelectedLayers()-1 do
					local layer = moho.document:GetSelectedLayer(l)
					if layer:SecondarySelection() then
						table.insert(secondarySelectionList, layer)
					else
						primarySelectedLayer = layer
					end
				end

				local curAction = moho.layer:CurrentAction()
				local curFrame = moho.frame
				for i=0, moho:LayerAsGroup(overlayGroupLayer):CountLayers()-1 do
					local layer = overlayGroupLayer:Layer(i)
					local layerScriptData = layer:ScriptData()
					if layerScriptData:HasKey(overlayLayerKey) then
						local meshLayer = moho:LayerAsVector(layer)
						if meshLayer then
							local mesh = meshLayer:Mesh()
							if mesh then
								local totalPoints = mesh:CountPoints()
								if totalPoints > 0 then
									moho.document:PrepUndo(layer, true)
									moho.document:SetDirty()
									mesh:SelectAll()
									moho:Copy(mesh)
									local targetLayer = moho.document:Layer(moho.document:LayerID(overlayGroupLayer)-1)
									moho:SetSelLayer(targetLayer)
									local newLayer = moho:CreateNewLayer(MOHO.LT_VECTOR, false)
									newLayer:SetName(layer:Name()..' (converted)')
									moho:Paste()
									newLayer:UpdateCurFrame()
									if curAction ~= '' then
										MR_Overlay:ReturnToAction(moho, curAction, curLayer, curFrame)
									else
										moho:SetSelLayer(curLayer)
									end

									moho:SetSelLayer(primarySelectedLayer)
									for _, layer in ipairs(secondarySelectionList) do
										layer:SetSecondarySelection(true)
									end

									moho.view:DrawMe()
									moho:UpdateUI()
									break
								end
							end
						end
					end
				end
				self:UpdateWidgets()
			end
		end
	elseif msg >= self.SAVE_SELECTION_1 and msg <= self.SAVE_SELECTION_5 then
		if document then
			local overlayGroupLayer = MR_Overlay:CheckExistOverlayLayer(moho)
			if overlayGroupLayer then
				local savedSelectionKey = ''
				local savedSelectionBonesKey = ''
				local useSavedSelectionKey = ''
				if msg == self.SAVE_SELECTION_1 then
					savedSelectionKey = 'MR Overlay Layer Selection 1'
					savedSelectionBonesKey = 'MR Overlay Layer Selection Bones 1'
					useSavedSelectionKey = 'MR Overlay Use Layer Selection 1'
				elseif msg == self.SAVE_SELECTION_2 then
					savedSelectionKey = 'MR Overlay Layer Selection 2'
					savedSelectionBonesKey = 'MR Overlay Layer Selection Bones 2'
					useSavedSelectionKey = 'MR Overlay Use Layer Selection 2'
				elseif msg == self.SAVE_SELECTION_3 then
					savedSelectionKey = 'MR Overlay Layer Selection 3'
					savedSelectionBonesKey = 'MR Overlay Layer Selection Bones 3'
					useSavedSelectionKey = 'MR Overlay Use Layer Selection 3'
				elseif msg == self.SAVE_SELECTION_4 then
					savedSelectionKey = 'MR Overlay Layer Selection 4'
					savedSelectionBonesKey = 'MR Overlay Layer Selection Bones 4'
					useSavedSelectionKey = 'MR Overlay Use Layer Selection 4'
				elseif msg == self.SAVE_SELECTION_5 then
					savedSelectionKey = 'MR Overlay Layer Selection 5'
					savedSelectionBonesKey = 'MR Overlay Layer Selection Bones 5'
					useSavedSelectionKey = 'MR Overlay Use Layer Selection 5'
				end
				if savedSelectionKey == '' then
					return
				end

				local selectedLayersList = {}
				for l = 0, moho.document:CountSelectedLayers()-1 do
					local layer = moho.document:GetSelectedLayer(l)
					table.insert(selectedLayersList, layer:UUID())
				end
				local scriptData = overlayGroupLayer:ScriptData()
				local selectedLayersString = MR_Utilities:TableToString(selectedLayersList)
				scriptData:Set(savedSelectionKey, selectedLayersString)
				local selectedBonesList = {}
				local skel = moho:Skeleton()
				if skel then
					for l = 0, skel:CountBones()-1 do
						local bone = skel:Bone(l)
						if bone.fSelected then
							table.insert(selectedBonesList, bone:Name())
						end
					end
					local selectedBonesString = MR_Utilities:TableToString(selectedBonesList)
					scriptData:Set(savedSelectionBonesKey, selectedBonesString)
				else
					scriptData:Set(savedSelectionBonesKey, '')
				end

				scriptData:Set(useSavedSelectionKey, true)
				self:UpdateWidgets()
			end
		end
	elseif msg >= self.SAVE_SELECTION_1_ALT and msg <= self.SAVE_SELECTION_5_ALT then
		if document then
			local overlayGroupLayer = MR_Overlay:CheckExistOverlayLayer(moho)
			if overlayGroupLayer then
				local savedSelectionKey = ''
				local useSavedSelectionKey = ''
				local savedSelectionBonesKey = ''
				local autoGenerateKey = ''
				if msg == self.SAVE_SELECTION_1_ALT then
					savedSelectionKey = 'MR Overlay Layer Selection 1'
					useSavedSelectionKey = 'MR Overlay Use Layer Selection 1'
					savedSelectionBonesKey = 'MR Overlay Layer Selection Bones 1'
					autoGenerateKey = 'MR Overlay Auto Generate 1'
				elseif msg == self.SAVE_SELECTION_2_ALT then
					savedSelectionKey = 'MR Overlay Layer Selection 2'
					useSavedSelectionKey = 'MR Overlay Use Layer Selection 2'
					savedSelectionBonesKey = 'MR Overlay Layer Selection Bones 2'
					autoGenerateKey = 'MR Overlay Auto Generate 2'
				elseif msg == self.SAVE_SELECTION_3_ALT then
					savedSelectionKey = 'MR Overlay Layer Selection 3'
					useSavedSelectionKey = 'MR Overlay Use Layer Selection 3'
					savedSelectionBonesKey = 'MR Overlay Layer Selection Bones 3'
					autoGenerateKey = 'MR Overlay Auto Generate 3'
				elseif msg == self.SAVE_SELECTION_4_ALT then
					savedSelectionKey = 'MR Overlay Layer Selection 4'
					useSavedSelectionKey = 'MR Overlay Use Layer Selection 4'
					savedSelectionBonesKey = 'MR Overlay Layer Selection Bones 4'
					autoGenerateKey = 'MR Overlay Auto Generate 4'
				elseif msg == self.SAVE_SELECTION_5_ALT then
					savedSelectionKey = 'MR Overlay Layer Selection 5'
					useSavedSelectionKey = 'MR Overlay Use Layer Selection 5'
					savedSelectionBonesKey = 'MR Overlay Layer Selection Bones 5'
					autoGenerateKey = 'MR Overlay Auto Generate 5'
				end
				if savedSelectionKey == '' then
					return
				end

				local scriptData = overlayGroupLayer:ScriptData()
				scriptData:Set(savedSelectionKey, '')
				scriptData:Set(useSavedSelectionKey, false)
				scriptData:Set(savedSelectionBonesKey, '')
				scriptData:Set(autoGenerateKey, false)
				self:UpdateWidgets()
			end
		end
	elseif msg >= self.USE_SAVED_SELECTION_1 and msg <= self.USE_SAVED_SELECTION_5 then
		if document then
			local overlayGroupLayer = MR_Overlay:CheckExistOverlayLayer(moho)
			if overlayGroupLayer then
				local useSavedSelectionKey = ''
				local bool = false
				if msg == self.USE_SAVED_SELECTION_1 then
					useSavedSelectionKey = 'MR Overlay Use Layer Selection 1'
					bool = self.layer_1_useSavedSelectionCheck:Value()
				elseif msg == self.USE_SAVED_SELECTION_2 then
					useSavedSelectionKey = 'MR Overlay Use Layer Selection 2'
					bool = self.layer_2_useSavedSelectionCheck:Value()
				elseif msg == self.USE_SAVED_SELECTION_3 then
					useSavedSelectionKey = 'MR Overlay Use Layer Selection 3'
					bool = self.layer_3_useSavedSelectionCheck:Value()
				elseif msg == self.USE_SAVED_SELECTION_4 then
					useSavedSelectionKey = 'MR Overlay Use Layer Selection 4'
					bool = self.layer_4_useSavedSelectionCheck:Value()
				elseif msg == self.USE_SAVED_SELECTION_5 then
					useSavedSelectionKey = 'MR Overlay Use Layer Selection 5'
					bool = self.layer_5_useSavedSelectionCheck:Value()
				end
				if useSavedSelectionKey == '' then
					return
				end

				local scriptData = overlayGroupLayer:ScriptData()
				scriptData:Set(useSavedSelectionKey, bool)
				self:UpdateWidgets()
			end
		end
	elseif msg >= self.OPEN_LAYER_SETTINGS_1 and msg <= self.OPEN_LAYER_SETTINGS_5 then
		if document then
			local overlayGroupLayer = MR_Overlay:CheckExistOverlayLayer(moho)
			if overlayGroupLayer then
				local layerIndex = 1
				if msg == self.OPEN_LAYER_SETTINGS_1 then
					layerIndex = 1
				elseif msg == self.OPEN_LAYER_SETTINGS_2 then
					layerIndex = 2
				elseif msg == self.OPEN_LAYER_SETTINGS_3 then
					layerIndex = 3
				elseif msg == self.OPEN_LAYER_SETTINGS_4 then
					layerIndex = 4
				elseif msg == self.OPEN_LAYER_SETTINGS_5 then
					layerIndex = 5
				end
				MR_Overlay.layerIndex = layerIndex
				MR_Overlay:BuildLayerSettingsDialog(moho, layerIndex)
			end
		end
	elseif msg >= self.USE_OVERLAY_SETUP_1 and msg <= self.USE_OVERLAY_SETUP_5 then
		if document then
			local overlayGroupLayer = MR_Overlay:CheckExistOverlayLayer(moho)
			if overlayGroupLayer then
				local useOverlaySetupKey = ''
				local bool = false
				if msg == self.USE_OVERLAY_SETUP_1 then
					useOverlaySetupKey = 'MR Overlay Use Overlay Setup 1'
					bool = self.layer_1_useOverlaySetupCheck:Value()
				elseif msg == self.USE_OVERLAY_SETUP_2 then
					useOverlaySetupKey = 'MR Overlay Use Overlay Setup 2'
					bool = self.layer_2_useOverlaySetupCheck:Value()
				elseif msg == self.USE_OVERLAY_SETUP_3 then
					useOverlaySetupKey = 'MR Overlay Use Overlay Setup 3'
					bool = self.layer_3_useOverlaySetupCheck:Value()
				elseif msg == self.USE_OVERLAY_SETUP_4 then
					useOverlaySetupKey = 'MR Overlay Use Overlay Setup 4'
					bool = self.layer_4_useOverlaySetupCheck:Value()
				elseif msg == self.USE_OVERLAY_SETUP_5 then
					useOverlaySetupKey = 'MR Overlay Use Overlay Setup 5'
					bool = self.layer_5_useOverlaySetupCheck:Value()
				end
				if useOverlaySetupKey == '' then
					return
				end

				local scriptData = overlayGroupLayer:ScriptData()
				scriptData:Set(useOverlaySetupKey, bool)
				self:UpdateWidgets()
			end
		end
	elseif msg >= self.AUTO_GENERATE_1 and msg <= self.AUTO_GENERATE_5 then
		if document then
			local overlayGroupLayer = MR_Overlay:CheckExistOverlayLayer(moho)
			if overlayGroupLayer then
				local autoGenerateKey = ''
				local bool = false
				if msg == self.AUTO_GENERATE_1 then
					autoGenerateKey = 'MR Overlay Auto Generate 1'
					bool = self.layer_1_autoGenerateCheck:Value()
				elseif msg == self.AUTO_GENERATE_2 then
					autoGenerateKey = 'MR Overlay Auto Generate 2'
					bool = self.layer_2_autoGenerateCheck:Value()
				elseif msg == self.AUTO_GENERATE_3 then
					autoGenerateKey = 'MR Overlay Auto Generate 3'
					bool = self.layer_3_autoGenerateCheck:Value()
				elseif msg == self.AUTO_GENERATE_4 then
					autoGenerateKey = 'MR Overlay Auto Generate 4'
					bool = self.layer_4_autoGenerateCheck:Value()
				elseif msg == self.AUTO_GENERATE_5 then
					autoGenerateKey = 'MR Overlay Auto Generate 5'
					bool = self.layer_5_autoGenerateCheck:Value()
				end
				if autoGenerateKey == '' then
					return
				end

				local scriptData = overlayGroupLayer:ScriptData()
				scriptData:Set(autoGenerateKey, bool)
				self:UpdateWidgets()
			end
		end
	end

	helper:delete()
end

-- **************************************************
-- The guts of this script
-- **************************************************

function MR_Overlay:Run(moho)
	if self.overlayDlog == nil then
		self.overlayDlog = MR_OverlayDialog:new()
		if (self.overlayDlog:DoModeless() == LM.GUI.MSG_CANCEL) then
			return
		end
	end
end

function MR_Overlay:CreateNewLayer(moho)
	local overlayGroupLayer = moho:CreateNewLayer(MOHO.LT_GROUP, false)
	
	local scriptData = overlayGroupLayer:ScriptData()
	scriptData:Set("MR Overlay Group", true)
	scriptData:Set("MR Overlay Active Layer", self.activeLayer)
	scriptData:Set("MR Overlay Main Opacity", MR_Overlay.opacityValue)
	scriptData:Set("MR Overlay Layer 1 visibility", self.layer_1_visibility)
	scriptData:Set("MR Overlay Layer 2 visibility", self.layer_2_visibility)
	scriptData:Set("MR Overlay Layer 3 visibility", self.layer_3_visibility)
	scriptData:Set("MR Overlay Layer 4 visibility", self.layer_4_visibility)
	scriptData:Set("MR Overlay Layer 5 visibility", self.layer_5_visibility)
	scriptData:Set("MR Overlay Layer 1 opacity", self.layer_1_opacityValue)
	scriptData:Set("MR Overlay Layer 2 opacity", self.layer_2_opacityValue)
	scriptData:Set("MR Overlay Layer 3 opacity", self.layer_3_opacityValue)
	scriptData:Set("MR Overlay Layer 4 opacity", self.layer_4_opacityValue)
	scriptData:Set("MR Overlay Layer 5 opacity", self.layer_5_opacityValue)
	scriptData:Set("MR Overlay Layer Selection 1", '')
	scriptData:Set("MR Overlay Layer Selection 2", '')
	scriptData:Set("MR Overlay Layer Selection 3", '')
	scriptData:Set("MR Overlay Layer Selection 4", '')
	scriptData:Set("MR Overlay Layer Selection 5", '')
	scriptData:Set("MR Overlay Use Layer Selection 1", false)
	scriptData:Set("MR Overlay Use Layer Selection 2", false)
	scriptData:Set("MR Overlay Use Layer Selection 3", false)
	scriptData:Set("MR Overlay Use Layer Selection 4", false)
	scriptData:Set("MR Overlay Use Layer Selection 5", false)

	local opacityValue = MR_Overlay.opacityValue
	local scriptData = overlayGroupLayer:ScriptData()
	scriptData:Set("MR Overlay Main Opacity", opacityValue)
	overlayGroupLayer.fAlpha:SetValue(0, opacityValue/100)
	overlayGroupLayer:UpdateCurFrame()

	overlayGroupLayer:SetName('Overlay')
	
	overlayGroupLayer:SetIgnoredByLayerPicker(true)	
	
	local overlayLayer1 = moho:CreateNewLayer(MOHO.LT_VECTOR, false)
	local scriptDataL1 = overlayLayer1:ScriptData()
	scriptDataL1:Set("MR Overlay Layer 1", true)
	overlayLayer1:SetName('Overlay layer 1')
	moho:PlaceLayerInGroup(overlayLayer1, overlayGroupLayer, true, false)
	overlayLayer1:SetIgnoredByLayerPicker(true)	
	self:CopyMainSettingsToLayer(moho, 1)
	
	local overlayLayer2 = moho:CreateNewLayer(MOHO.LT_VECTOR, false)
	local scriptDataL2 = overlayLayer2:ScriptData()
	scriptDataL2:Set("MR Overlay Layer 2", true)
	overlayLayer2:SetName('Overlay layer 2')
	moho:PlaceLayerInGroup(overlayLayer2, overlayGroupLayer, true, false)
	overlayLayer2:SetIgnoredByLayerPicker(true)
	self:CopyMainSettingsToLayer(moho, 2)
	
	local overlayLayer3 = moho:CreateNewLayer(MOHO.LT_VECTOR, false)
	local scriptDataL3 = overlayLayer3:ScriptData()
	scriptDataL3:Set("MR Overlay Layer 3", true)
	overlayLayer3:SetName('Overlay layer 3')
	moho:PlaceLayerInGroup(overlayLayer3, overlayGroupLayer, true, false)
	overlayLayer3:SetIgnoredByLayerPicker(true)	
	self:CopyMainSettingsToLayer(moho, 3)

	local overlayLayer4 = moho:CreateNewLayer(MOHO.LT_VECTOR, false)
	local scriptDataL4 = overlayLayer4:ScriptData()
	scriptDataL4:Set("MR Overlay Layer 4", true)
	overlayLayer4:SetName('Overlay layer 4')
	moho:PlaceLayerInGroup(overlayLayer4, overlayGroupLayer, true, false)
	overlayLayer4:SetIgnoredByLayerPicker(true)	
	self:CopyMainSettingsToLayer(moho, 4)

	local overlayLayer5 = moho:CreateNewLayer(MOHO.LT_VECTOR, false)
	local scriptDataL5 = overlayLayer5:ScriptData()
	scriptDataL5:Set("MR Overlay Layer 5", true)
	overlayLayer5:SetName('Overlay layer 5')
	moho:PlaceLayerInGroup(overlayLayer5, overlayGroupLayer, true, false)
	overlayLayer5:SetIgnoredByLayerPicker(true)
	self:CopyMainSettingsToLayer(moho, 5)
	
	moho:LayerAsGroup(overlayGroupLayer):Expand(false)
	return overlayGroupLayer
end

function MR_Overlay:CheckExistOverlayLayer(moho)
	local topLayer = moho.document:Layer(moho.document:CountLayers()-1)
	local overlayLayer = nil
	local scriptData = topLayer:ScriptData()
	if (scriptData:HasKey("MR Overlay Group")) then
		overlayLayer = topLayer
	elseif (scriptData:HasKey("MR Guides Layer")) then
		topLayer = moho.document:Layer(moho.document:CountLayers()-2)
		scriptData = topLayer:ScriptData()
		if (scriptData:HasKey("MR Overlay Group")) then
			overlayLayer = topLayer
		elseif (scriptData:HasKey("MR Path Layer")) then
			topLayer = moho.document:Layer(moho.document:CountLayers()-3)
			scriptData = topLayer:ScriptData()
			if (scriptData:HasKey("MR Overlay Group")) then
				overlayLayer = topLayer
			end
		end		
	elseif (scriptData:HasKey("MR Path Layer")) then
		topLayer = moho.document:Layer(moho.document:CountLayers()-2)
		scriptData = topLayer:ScriptData()
		if (scriptData:HasKey("MR Overlay Group")) then
			overlayLayer = topLayer
		end	
	end

	return overlayLayer
end

function MR_Overlay:DeleteOverlayLayer(moho, overlLayer)
	local curLayer = moho.layer
	local curAction = moho.layer:CurrentAction()
	local curFrame = moho.frame
	local onlyOverlaySelected = false
	local overlayLayer = overlLayer

	local secondarySelectionList = {}
	local primarySelectedLayer = nil
	for l = 0, moho.document:CountSelectedLayers()-1 do
		local layer = moho.document:GetSelectedLayer(l)
		if layer:SecondarySelection() then
			table.insert(secondarySelectionList, layer)
		else
			primarySelectedLayer = layer
		end
	end

	if overlayLayer ~= nil then
		moho.document:PrepUndo(nil)
		moho.document:SetDirty()
		local scriptData = curLayer:ScriptData()
		if (scriptData:HasKey("MR Overlay Group")) or scriptData:HasKey('MR Overlay Layer 1') 
		or scriptData:HasKey('MR Overlay Layer 2') or scriptData:HasKey('MR Overlay Layer 3') 
		or scriptData:HasKey('MR Overlay Layer 4') or scriptData:HasKey('MR Overlay Layer 5') then
			onlyOverlaySelected = true
		end

		if not onlyOverlaySelected then
			moho:DeleteLayer(overlayLayer)
			if curAction ~= '' then
				self:ReturnToAction(moho, curAction, curLayer, curFrame)
			else
				moho:SetSelLayer(curLayer)
			end	
			if curFrame > 0 then
				moho:SetCurFrame(0)
				moho:SetCurFrame(curFrame)
			elseif curFrame == 0 then
				moho:SetCurFrame(1)
				moho:SetCurFrame(curFrame)
			end
			curLayer:UpdateCurFrame()
		else
			moho:DeleteLayer(overlayLayer)
		end

		moho:SetSelLayer(primarySelectedLayer)
		for _, layer in ipairs(secondarySelectionList) do
			layer:SetSecondarySelection(true)
		end

		moho.view:DrawMe()
		moho:UpdateUI()
		moho:UpdateSelectedChannels()
	end
end

function MR_Overlay:SetCustomCenter(moho, alt)
	local mesh = moho:Mesh()
	local skel = moho:Skeleton()
	local centerPos = LM.Vector2:new_local()
	local centerFound = false
	local layer = moho.layer
	if mesh then
		if self.useShapeForPivot and mesh:CountShapes() > 0 then
			local minAll = LM.Vector2:new_local()
            local maxAll = LM.Vector2:new_local()
			minAll:Set(math.huge, math.huge)
			maxAll:Set(-math.huge, -math.huge)
			for i = 0, mesh:CountShapes() - 1 do
				local shape = mesh:Shape(i)
				local min = LM.Vector2:new_local()
				local max = LM.Vector2:new_local()
                shape:ShapeBounds(min, max, 0)
				if min.x < minAll.x then
					minAll.x = min.x
				end
				if min.y < minAll.y then
					minAll.y = min.y
				end
				if max.x > maxAll.x then
					maxAll.x = max.x
				end
				if max.y > maxAll.y then
					maxAll.y = max.y
				end
			end
			centerFound = true
			local center = LM.Vector2:new_local()
			center:Set(minAll.x + ((maxAll.x - minAll.x) / 2), minAll.y + ((maxAll.y - minAll.y) / 2))
			centerPos:Set(MR_Utilities:GetGlobalPos(moho, layer, center, false))
		else
			local selectedPoints = false
			for i = 0, mesh:CountPoints() - 1 do
				local pt = mesh:Point(i)
				if (pt.fSelected) then
					selectedPoints = true
					break
				end
			end
			if selectedPoints then
				centerFound = true
				centerPos:Set(MR_Utilities:GetGlobalPos(moho, layer, mesh:SelectedCenter(), false))
			end
		end	
	end

	if skel ~= nil then
		local posList = {}
		for i = 0, skel:CountBones() - 1 do
			local bone = skel:Bone(i)
			if bone.fSelected and bone.fHidden == false then
				local bone = skel:Bone(i)
				local localPos = LM.Vector2:new_local()
				centerFound = true

				if alt then
					if bone:IsZeroLength() then
						localPos:Set(0.1, 0)
					else
						localPos:Set(bone.fLength, 0)
					end
					if moho.frame == 0 then
						bone.fRestMatrix:Transform(localPos)
					else
						bone.fMovedMatrix:Transform(localPos)
					end
				else
					localPos:Set(0, 0)
					if moho.frame == 0 then
						bone.fRestMatrix:Transform(localPos)
					else
						bone.fMovedMatrix:Transform(localPos)
					end
				end

				local pos = MR_Utilities:GetGlobalPos(moho, moho.layer, localPos, false)
				table.insert(posList, pos)
			end
		end
		if #posList > 0 then
			local minX = math.huge
			local minY = math.huge
			local maxX = -math.huge
			local maxY = -math.huge

			for _, pos in ipairs(posList) do
				if pos.x and pos.y then
					minX = math.min(minX, pos.x)
					minY = math.min(minY, pos.y)
					maxX = math.max(maxX, pos.x)
					maxY = math.max(maxY, pos.y)
				end
			end

			local centerX = (minX + maxX) / 2
			local centerY = (minY + maxY) / 2

			centerPos:Set(centerX, centerY)
		end
	end
	
	if not centerFound then
		centerPos:Set(MR_Utilities:GetGlobalPos(moho, layer, layer:Origin(), false))
	end
	
	return centerPos.x, centerPos.y
end

function MR_Overlay:ScanLayers(moho, autoSelect)
	self.layersToOverlay = {}
	self.secondarySelection = {}
	
	for l = 0, moho.document:CountSelectedLayers()-1 do
		local layer = moho.document:GetSelectedLayer(l)
		table.insert(self.secondarySelection, layer)
	end	
	
	local count = 0
	repeat
		local layer = moho.document:LayerByAbsoluteID(count)
		if layer then
			count = count + 1
			if (moho:LayerAsVector(layer) and layer:IsAncestorSelected()) or layer == moho.layer or layer:SecondarySelection() then
				local isLayerOk = true
				if self.visibleLayersOnly then
					local layerSkeleton = layer:ControllingSkeleton()
					isLayerOk = self:IsLayerVisible(moho, layer, layerSkeleton)

					if layer:SecondarySelection() then
						isLayerOk = true
					end
				end

				if isLayerOk then
					local vectorLayer = moho:LayerAsVector(layer)
					if vectorLayer then
						local mesh = vectorLayer:Mesh()
						local selectedPoints = false
						local pointsCount = mesh:CountPoints()
						if autoSelect and pointsCount > 1 then
							selectedPoints = true
						end
						if not selectedPoints then
							for i = 0, pointsCount - 1 do
								local pt = mesh:Point(i)
								if (pt.fSelected) then
									selectedPoints = true
									break
								end
							end	
						end
						if selectedPoints then
							local isLayerNew = true
							for k, id in ipairs(self.layersToOverlay) do
								if layer == moho.document:LayerByAbsoluteID(id) then
									isLayerNew = false
								end
							end
							if isLayerNew and layer ~= self.overlayLayer then
								table.insert(self.layersToOverlay, moho.document:LayerAbsoluteID(layer))
							end	
						end
					end
				end
			end
		end
	until not layer
end

function MR_Overlay:ReturnToAction(moho, returnAction, returnLayer, frame)
	if returnAction ~= '' and returnLayer ~= nil then
		local parentGroup = returnLayer:Parent()
		local skelLayer = nil
		
		if returnLayer:LayerType() == MOHO.LT_BONE and returnLayer:HasAction(returnAction) then
			skelLayer = returnLayer
		elseif parentGroup ~= nil then
			local targetGroup = parentGroup
			repeat
				if targetGroup:LayerType() == MOHO.LT_BONE then
					if targetGroup:HasAction(returnAction) then
						skelLayer = targetGroup
					end	
				end
				targetGroup = targetGroup:Parent()
			until targetGroup == nil
		end	
		moho:SetSelLayer(skelLayer)
		moho.document:SetCurrentDocAction(returnAction)
		skelLayer:ActivateAction(returnAction)
		if skelLayer ~= returnLayer then
			moho:SetSelLayer(returnLayer)
			returnLayer:ActivateAction(returnAction)
		end
		moho:SetCurFrame(frame)
	end
end

function MR_Overlay:IsLayerVisible(moho, layer, skel)
	local layerVisibility = true

	if skel then
		local parentBoneID = layer:LayerParentBone()
		if parentBoneID == -1 then
			for i=0, skel:CountGroups()-1 do
				local group = skel:Group(i)
				for b=0, group:CountBones()-1 do
					local bone = group:Bone(b)
					if not bone:IsGroupVisible() then
						if layer:IsIncludedInFlexiBoneSubset(skel:BoneID(bone)) then
							return false
						end
					end
				end
			end
		end

		if parentBoneID >= 0 then
			local skelL = layer:ControllingSkeleton()
			if skelL then
				local bone = skelL:Bone(parentBoneID)
				if not bone:IsGroupVisible() then
					return false
				end
			end
		end
	end	
	
	if not layer.fVisibility.value or not layer:IsVisible() then
		layerVisibility = false
	elseif layer:IsRenderOnly() then
		layerVisibility = false
	elseif layer:MaskingMode() == 5 then
		layerVisibility = false
	else
		local targetLayer = layer:Parent()
		local lastLayer = layer
		if targetLayer then
			repeat
				if not targetLayer.fVisibility.value or not targetLayer:IsVisible() then
					layerVisibility = false
					break
				end
				
				local skel = targetLayer:ControllingSkeleton()
				
				if moho:LayerAsBone(targetLayer) then
					local parentLayer = targetLayer:Parent()
					if parentLayer then
						skel = parentLayer:ControllingSkeleton()
					end
				end
				
				if skel then
					local parentBoneID = targetLayer:LayerParentBone()
					if parentBoneID >= 0 then
						local bone = skel:Bone(parentBoneID)
						if not bone:IsGroupVisible() then
							layerVisibility = false
							break
						end
					end
				end
				
				if targetLayer:LayerType() == MOHO.LT_SWITCH then
					local switchLayer = moho:LayerAsSwitch(targetLayer)
					local switchChannel = switchLayer:SwitchValues()
					local switchValue = switchChannel.value:Buffer()
					
					local isSwitchValueCorrect = false
					for i=0, targetLayer:CountLayers() - 1 do
						if targetLayer:Layer(i):Name() == switchValue then
							isSwitchValueCorrect = true
							break
						end	
					end
					
					if switchValue ~= lastLayer:Name() then
						if not isSwitchValueCorrect then
							local targetSwitchLayer = switchLayer:Layer(switchLayer:CountLayers() - 1):Name()
							if targetSwitchLayer ~= lastLayer:Name() then
								layerVisibility = false
								break
							end
						else
							layerVisibility = false
							break
						end
					end
				end
				lastLayer = targetLayer
				targetLayer = targetLayer:Parent()
			until targetLayer == nil 
		end	
	end

	if layerVisibility then
		local skel = layer:ControllingSkeleton()
		if not skel then
			return layerVisibility
		end
		
		local IsInvisibleBoneInSubset = false
		local IsVisibleBoneInSubset = false
		local IsParentBone = false
		local IsParentBoneVisible = false
		for i=0, skel:CountBones()-1 do 
			local bone = skel:Bone(i)
			if layer:IsIncludedInFlexiBoneSubset(i) then
				if bone:IsGroupVisible() then
					IsVisibleBoneInSubset = true
				else
					IsInvisibleBoneInSubset = true
				end
			end
		end	
		if IsInvisibleBoneInSubset and not IsVisibleBoneInSubset then
			layerVisibility = false
		end
	end
	
	return layerVisibility
end

function MR_Overlay:GetShapeOrderChannel(moho, layer)
	local maxChannel = layer:CountChannels()-1
	local chInfo = MOHO.MohoLayerChannel:new_local()
	local orderChannel = nil
	for i=0, maxChannel do
		layer:GetChannelInfo(i, chInfo)
		if chInfo.channelID == CHANNEL_SHAPE_ORDER then
			return moho:ChannelAsAnimString(layer:Channel(i, 0, moho.document))
		end
	end
end

function MR_Overlay:CreateOverlay(moho)
	self.overlayGroupLayer = self:CheckExistOverlayLayer(moho)
	if self.overlayGroupLayer then
		self.overlayGroupLayerUUID = self.overlayGroupLayer:UUID()
	else
		self.overlayGroupLayerUUID = nil
	end

	local curLayerScriptData = moho.layer:ScriptData()
	if (curLayerScriptData:HasKey("MR Overlay Group")) or curLayerScriptData:HasKey('MR Overlay Layer 1')
	or curLayerScriptData:HasKey('MR Overlay Layer 2') or curLayerScriptData:HasKey('MR Overlay Layer 3')
	or curLayerScriptData:HasKey('MR Overlay Layer 4') or curLayerScriptData:HasKey('MR Overlay Layer 5') then
		return
	end

	local secondarySelectionList = {}
	local primarySelectedLayerID = moho.layer:UUID()
	for l = 0, moho.document:CountSelectedLayers()-1 do
		local layer = moho.document:GetSelectedLayer(l)
		if layer:SecondarySelection() then
			table.insert(secondarySelectionList, layer:UUID())
		end
	end
	self.undoDone = false
	self.currentActiveLayer = 0
	local layersList = {}
	if self.overlayGroupLayer then
		local scriptData = self.overlayGroupLayer:ScriptData()
		if scriptData:HasKey('MR Overlay Active Layer') then
			local activeLayerValue = scriptData:GetInt('MR Overlay Active Layer')
			if activeLayerValue ~= nil then
				self.currentActiveLayer = math.floor(activeLayerValue)
				table.insert(layersList, self.currentActiveLayer)
				local autoGenerate1 = scriptData:GetBool('MR Overlay Auto Generate 1')
				local layer1UseSelection = scriptData:GetBool('MR Overlay Use Layer Selection 1')
				local layer1Selection = scriptData:GetString('MR Overlay Layer Selection 1')
				if autoGenerate1 and layer1UseSelection and #layer1Selection > 0 and activeLayerValue ~= 1 then
					table.insert(layersList, 1)
				end
				local autoGenerate2 = scriptData:GetBool('MR Overlay Auto Generate 2')
				local layer2UseSelection = scriptData:GetBool('MR Overlay Use Layer Selection 2')
				local layer2Selection = scriptData:GetString('MR Overlay Layer Selection 2')
				if autoGenerate2 and layer2UseSelection and #layer2Selection > 0 and activeLayerValue ~= 2 then
					table.insert(layersList, 2)
				end
				local autoGenerate3 = scriptData:GetBool('MR Overlay Auto Generate 3')
				local layer3UseSelection = scriptData:GetBool('MR Overlay Use Layer Selection 3')
				local layer3Selection = scriptData:GetString('MR Overlay Layer Selection 3')
				if autoGenerate3 and layer3UseSelection and #layer3Selection > 0 and activeLayerValue ~= 3 then
					table.insert(layersList, 3)
				end
				local autoGenerate4 = scriptData:GetBool('MR Overlay Auto Generate 4')
				local layer4UseSelection = scriptData:GetBool('MR Overlay Use Layer Selection 4')
				local layer4Selection = scriptData:GetString('MR Overlay Layer Selection 4')
				if autoGenerate4 and layer4UseSelection and #layer4Selection > 0 and activeLayerValue ~= 4 then
					table.insert(layersList, 4)
				end
				local autoGenerate5 = scriptData:GetBool('MR Overlay Auto Generate 5')
				local layer5UseSelection = scriptData:GetBool('MR Overlay Use Layer Selection 5')
				local layer5Selection = scriptData:GetString('MR Overlay Layer Selection 5')
				if autoGenerate5 and layer5UseSelection and #layer5Selection > 0 and activeLayerValue ~= 5 then
					table.insert(layersList, 5)
				end
			end
		end
	else
		table.insert(layersList, MR_Overlay.activeLayer)
	end

	for i = 1, #layersList do
		-- Mode current values
		self.shapesOverlayCur = self.shapesOverlay
		self.bonesOverlayCur = self.bonesOverlay
		self.pointsOverlayCur = self.pointsOverlay

		-- Shapes current values
		self.drawStrokesCur = self.drawStrokes
		self.changeStrokeWidthCur = self.changeStrokeWidth
		self.strokeWidthCur = self.strokeWidth
		self.recolorStrokeCur = self.recolorStroke

		self.strokeColorCurR = self.strokeColorR
		self.strokeColorCurG = self.strokeColorG
		self.strokeColorCurB = self.strokeColorB
		self.strokeColorCurA = self.strokeColorA

		self.preserveStrokeAlphaCur = self.preserveStrokeAlpha
		self.drawFillsCur = self.drawFills
		self.recolorFillCur = self.recolorFill

		self.fillColorCurR = self.fillColorR
		self.fillColorCurG = self.fillColorG
		self.fillColorCurB = self.fillColorB
		self.fillColorCurA = self.fillColorA

		self.preserveFillAlphaCur = self.preserveFillAlpha
		self.makeShapesPlainCur = self.makeShapesPlain
		self.autoSelectShapesPointsCur = self.autoSelectShapesPoints

		-- Bones current values
		self.bonesLineWidthCur = self.bonesLineWidth
		self.bonesWidthCur = self.bonesWidth

		self.boneColorCurR = self.boneColorR
		self.boneColorCurG = self.boneColorG
		self.boneColorCurB = self.boneColorB
		self.boneColorCurA = self.boneColorA

		self.drawCenterLineCur = self.drawCenterLine
		self.pinBoneRadiusCur = self.pinBoneRadius
		self.drawPinBoneCenterLinesCur = self.drawPinBoneCenterLines
		self.selectedBonesOnlyCur = self.selectedBonesOnly
		self.drawHiddenBonesCur = self.drawHiddenBones

		-- Points current values
		self.pointLineWidthCur = self.pointLineWidth
		self.drawCrosshairCur = self.drawCrosshair
		self.crosshairRadiusCur = self.crosshairRadius

		self.pointCrosshairColorCurR = self.pointCrosshairColorR
		self.pointCrosshairColorCurG = self.pointCrosshairColorG
		self.pointCrosshairColorCurB = self.pointCrosshairColorB
		self.pointCrosshairColorCurA = self.pointCrosshairColorA

		self.drawCircleCur = self.drawCircle
		self.circleRadiusCur = self.circleRadius

		self.pointCircleColorCurR = self.pointCircleColorR
		self.pointCircleColorCurG = self.pointCircleColorG
		self.pointCircleColorCurB = self.pointCircleColorB
		self.pointCircleColorCurA = self.pointCircleColorA

		self.selectedPointsOnlyCur = self.selectedPointsOnly
		self.drawHiddenPointsCur = self.drawHiddenPoints

		-- Other
		self.flipOverlayCur = self.flipOverlay
		self.mirrorFlipCur = self.mirrorFlip
		self.mirrorOverlayShadeCur = self.mirrorOverlayShade
		self.selectionCenterCur = self.selectionCenter
		self.layerOriginCenterCur = self.layerOriginCenter
		self.customCenterCur = self.customCenter
		self.customCenterValueXCur = self.customCenterValueX
		self.customCenterValueYCur = self.customCenterValueY

		self.createOverlayFromFrameCur = self.createOverlayFromFrame

		if self.useFrame1 then
			self.overlayFrameCur = self.frameVal1
		elseif self.useFrame2 then
			self.overlayFrameCur = self.frameVal2
		elseif self.useFrame3 then
			self.overlayFrameCur = self.frameVal3
		elseif self.useFrame4 then
			self.overlayFrameCur = moho.frame + self.frameVal4
		elseif self.useFrame5 then
			self.overlayFrameCur = moho.frame - self.frameVal5
		else
			self.overlayFrameCur = moho.frame
		end

		self.currentActiveLayer = layersList[i]
		if self.overlayGroupLayer then
			local activeLayerValue = layersList[i]
			local scriptData = self.overlayGroupLayer:ScriptData()
			if scriptData:GetBool('MR Overlay Use Overlay Setup '..math.floor(activeLayerValue)) and scriptData:HasKey("MR Overlay Setup Mode 1") then
				local modeVal = scriptData:GetString('MR Overlay Setup Mode '..math.floor(activeLayerValue))
				if modeVal == 'Shapes' then
					self.shapesOverlayCur = true
					self.bonesOverlayCur = false
					self.pointsOverlayCur = false
				elseif modeVal == 'Bones' then
					self.bonesOverlayCur = true
					self.shapesOverlayCur = false
					self.pointsOverlayCur = false
				elseif modeVal == 'Points' then
					self.pointsOverlayCur = true
					self.bonesOverlayCur = false
					self.shapesOverlayCur = false
				end

				-- Shapes
				self.drawStrokesCur = scriptData:GetBool('MR Overlay Setup drawStrokes '..math.floor(activeLayerValue))
				self.changeStrokeWidthCur = scriptData:GetBool('MR Overlay Setup changeStrokeWidth '..math.floor(activeLayerValue))
				self.strokeWidthCur = scriptData:GetFloat('MR Overlay Setup strokeWidth '..math.floor(activeLayerValue))
				self.recolorStrokeCur = scriptData:GetBool('MR Overlay Setup recolorStroke '..math.floor(activeLayerValue))

				local strokeColor = scriptData:GetString('MR Overlay Setup strokeColor '..math.floor(activeLayerValue))

				local r, g, b, a = MR_Utilities:HexToRgba(strokeColor)
				self.strokeColorCurR = r
				self.strokeColorCurG = g
				self.strokeColorCurB = b
				self.strokeColorCurA = a

				self.preserveStrokeAlphaCur = scriptData:GetBool('MR Overlay Setup preserveStrokeAlpha '..math.floor(activeLayerValue))

				self.drawFillsCur = scriptData:GetBool('MR Overlay Setup drawFills '..math.floor(activeLayerValue))
				self.recolorFillCur = scriptData:GetBool('MR Overlay Setup recolorFill '..math.floor(activeLayerValue))

				local fillColor = scriptData:GetString('MR Overlay Setup fillColor '..math.floor(activeLayerValue))
				r, g, b, a = MR_Utilities:HexToRgba(fillColor)
				self.fillColorCurR = r
				self.fillColorCurG = g
				self.fillColorCurB = b
				self.fillColorCurA = a

				self.preserveFillAlphaCur = scriptData:GetBool('MR Overlay Setup preserveFillAlpha '..math.floor(activeLayerValue))
				self.makeShapesPlainCur = scriptData:GetBool('MR Overlay Setup makeShapesPlain '..math.floor(activeLayerValue))
				self.autoSelectShapesPointsCur = scriptData:GetBool('MR Overlay Setup autoSelectShapesPoints '..math.floor(activeLayerValue))

				-- Bones
				self.bonesLineWidthCur = scriptData:GetFloat('MR Overlay Setup bonesLineWidth '..math.floor(activeLayerValue))
				self.bonesWidthCur = scriptData:GetFloat('MR Overlay Setup bonesWidth '..math.floor(activeLayerValue))

				local boneColor = scriptData:GetString('MR Overlay Setup boneColor '..math.floor(activeLayerValue))
				r, g, b, a = MR_Utilities:HexToRgba(boneColor)
				self.boneColorCurR = r
				self.boneColorCurG = g
				self.boneColorCurB = b
				self.boneColorCurA = a

				self.drawCenterLineCur = scriptData:GetBool('MR Overlay Setup drawCenterLine '..math.floor(activeLayerValue))
				self.pinBoneRadiusCur = scriptData:GetFloat('MR Overlay Setup pinBoneRadius '..math.floor(activeLayerValue))
				self.drawPinBoneCenterLinesCur = scriptData:GetBool('MR Overlay Setup drawPinBoneCenterLines '..math.floor(activeLayerValue))
				self.selectedBonesOnlyCur = scriptData:GetBool('MR Overlay Setup selectedBonesOnly '..math.floor(activeLayerValue))
				self.drawHiddenBonesCur = scriptData:GetBool('MR Overlay Setup drawHiddenBones '..math.floor(activeLayerValue))

				-- Points
				self.pointLineWidthCur = scriptData:GetFloat('MR Overlay Setup pointLineWidth '..math.floor(activeLayerValue))
				self.drawCrosshairCur = scriptData:GetBool('MR Overlay Setup drawCrosshair '..math.floor(activeLayerValue))
				self.crosshairRadiusCur = scriptData:GetFloat('MR Overlay Setup crosshairRadius '..math.floor(activeLayerValue))

				local pointCrosshairColor = scriptData:GetString('MR Overlay Setup pointCrosshairColor '..math.floor(activeLayerValue))
				r, g, b, a = MR_Utilities:HexToRgba(pointCrosshairColor)
				self.pointCrosshairColorCurR = r
				self.pointCrosshairColorCurG = g
				self.pointCrosshairColorCurB = b
				self.pointCrosshairColorCurA = a

				self.drawCircleCur = scriptData:GetBool('MR Overlay Setup drawCircle '..math.floor(activeLayerValue))
				self.circleRadiusCur = scriptData:GetFloat('MR Overlay Setup circleRadius '..math.floor(activeLayerValue))

				local pointCircleColor = scriptData:GetString('MR Overlay Setup pointCircleColor '..math.floor(activeLayerValue))
				r, g, b, a = MR_Utilities:HexToRgba(pointCircleColor)
				self.pointCircleColorCurR = r
				self.pointCircleColorCurG = g
				self.pointCircleColorCurB = b
				self.pointCircleColorCurA = a

				self.selectedPointsOnlyCur = scriptData:GetBool('MR Overlay Setup selectedPointsOnly '..math.floor(activeLayerValue))
				self.drawHiddenPointsCur = scriptData:GetBool('MR Overlay Setup drawHiddenPoints '..math.floor(activeLayerValue))

				-- Other
				if scriptData:HasKey('MR Overlay Setup useFlipSettings '..math.floor(activeLayerValue)) then
					if scriptData:GetBool('MR Overlay Setup useFrameSettings '..math.floor(activeLayerValue)) then
						self.flipOverlayCur = scriptData:GetBool('MR Overlay Setup flipOverlay '..math.floor(activeLayerValue))
						self.mirrorFlipCur = scriptData:GetBool('MR Overlay Setup mirrorFlip '..math.floor(activeLayerValue))
						self.mirrorOverlayShadeCur = scriptData:GetBool('MR Overlay Setup mirrorOverlayShade '..math.floor(activeLayerValue))
						self.selectionCenterCur = scriptData:GetBool('MR Overlay Setup selectionCenter '..math.floor(activeLayerValue))
						self.layerOriginCenterCur = scriptData:GetBool('MR Overlay Setup layerOriginCenter '..math.floor(activeLayerValue))
						self.customCenterCur = scriptData:GetBool('MR Overlay Setup customCenter '..math.floor(activeLayerValue))
						self.customCenterValueXCur = scriptData:GetFloat('MR Overlay Setup customCenterValueX '..math.floor(activeLayerValue))
						self.customCenterValueYCur = scriptData:GetFloat('MR Overlay Setup customCenterValueY '..math.floor(activeLayerValue))
					end
				end

				if scriptData:HasKey('MR Overlay Setup useFrameSettings '..math.floor(activeLayerValue)) then
					if scriptData:GetBool('MR Overlay Setup useFrameSettings '..math.floor(activeLayerValue)) then
						self.createOverlayFromFrameCur = scriptData:GetBool('MR Overlay Setup createFromFrame '..math.floor(activeLayerValue))
						self.useFrame1Cur = scriptData:GetBool('MR Overlay Setup useFrame1 '..math.floor(activeLayerValue))
						self.useFrame2Cur = scriptData:GetBool('MR Overlay Setup useFrame2 '..math.floor(activeLayerValue))
						self.useFrame3Cur = scriptData:GetBool('MR Overlay Setup useFrame3 '..math.floor(activeLayerValue))
						self.useFrame4Cur = scriptData:GetBool('MR Overlay Setup useFrame4 '..math.floor(activeLayerValue))
						self.useFrame5Cur = scriptData:GetBool('MR Overlay Setup useFrame5 '..math.floor(activeLayerValue))

						self.frameVal1Cur = scriptData:GetInt('MR Overlay Setup frameVal1 '..math.floor(activeLayerValue))
						self.frameVal2Cur = scriptData:GetInt('MR Overlay Setup frameVal2 '..math.floor(activeLayerValue))
						self.frameVal3Cur = scriptData:GetInt('MR Overlay Setup frameVal3 '..math.floor(activeLayerValue))
						self.frameVal4Cur = scriptData:GetInt('MR Overlay Setup frameVal4 '..math.floor(activeLayerValue))
						self.frameVal5Cur = scriptData:GetInt('MR Overlay Setup frameVal5 '..math.floor(activeLayerValue))

						if self.useFrame1Cur then
							self.overlayFrameCur = self.frameVal1Cur
						elseif self.useFrame2Cur then
							self.overlayFrameCur = self.frameVal2Cur
						elseif self.useFrame3Cur then
							self.overlayFrameCur = self.frameVal3Cur
						elseif self.useFrame4Cur then
							self.overlayFrameCur = moho.frame + self.frameVal4Cur
						elseif self.useFrame5Cur then
							self.overlayFrameCur = moho.frame - self.frameVal5Cur
						else
							self.overlayFrameCur = moho.frame
						end
					end
				end
			end
		end

		if self.shapesOverlayCur then
			self:CreateShapesOverlay(moho)
		elseif self.bonesOverlayCur then
			self:CreateBonesOverlay(moho)
		elseif self.pointsOverlayCur then
			self:CreatePointsOverlay(moho)
		end

		local primarySelectedLayer = MR_Utilities:GetLayerByUUID(moho, primarySelectedLayerID)
		moho:SetSelLayer(primarySelectedLayer, false)

		for _, layerUUID in ipairs(secondarySelectionList) do
			local layer = MR_Utilities:GetLayerByUUID(moho, layerUUID)
			if layer ~= nil then
				layer:SetSecondarySelection(true)
			end
		end
		MR_Overlay:CheckExistOverlayLayer(moho)
		if MR_Overlay.overlayDlog then
			MR_Overlay.overlayDlog:UpdateWidgets()
		end
		moho:UpdateUI()
		moho.view:DrawMe()
	end
end

function MR_Overlay:FindOverlayVectorLayer(moho, overlayerGroup)
	local group = moho:LayerAsGroup(overlayerGroup)
	if group then
		overlayerGroup = group
	else
		return nil
	end

	local overlayVectorLayer = nil
	if self.currentActiveLayer == nil then
		self.currentActiveLayer = self.activeLayer
	end

	for i=0, overlayerGroup:CountLayers()-1 do
		local layer = overlayerGroup:Layer(i)
		local layerScriptData = layer:ScriptData()
		if layerScriptData:HasKey('MR Overlay Layer '..math.floor(self.currentActiveLayer)) then
			overlayVectorLayer = layer
			break
		end
	end

	return overlayVectorLayer
end

function MR_Overlay:CreateShapesOverlay(moho)
	local curLayer = moho.layer
	local curLayerUUID = curLayer:UUID()
	local curFrame = moho.frame

	if self.overlayGroupLayer and moho.document:IsLayerValid(self.overlayGroupLayer) then
		local scriptData = self.overlayGroupLayer:ScriptData()
		local activeLayerValue = self.currentActiveLayer
		if activeLayerValue ~= nil then
			local savedLayers = scriptData:GetString('MR Overlay Layer Selection '..math.floor(activeLayerValue))
			local layerUseSelection = scriptData:GetBool('MR Overlay Use Layer Selection '..math.floor(activeLayerValue))
			local first = true
			if #savedLayers > 0 and layerUseSelection then
				local savedLayersList = {}
				MR_Utilities:StringToTable(savedLayers, savedLayersList, 's')
				for _, uuid in ipairs(savedLayersList) do
					local layer = MR_Utilities:GetLayerByUUID(moho, uuid)
					if layer then
						if first then
							moho:SetSelLayer(layer)
							curLayer = layer
							first = false
							layer:UpdateCurFrame()
						else
							layer:SetSecondarySelection(true)
							layer:UpdateCurFrame()
						end
					end
				end
			end
		end
	end

	if self.createOverlayFromFrameCur and self.overlayFrameCur ~= curFrame then
		moho:SetCurFrame(self.overlayFrameCur)
	end
	
	local skelControl = false
	local skelLayer = moho:LayerAsBone(curLayer)
	local skel = nil
	if skelLayer then
		skel = skelLayer:Skeleton()
	else
		skelLayer = curLayer:ControllingBoneLayer()
	end

	self:ScanLayers(moho, self.autoSelectShapesPointsCur)
	
	if self.layersToOverlay[1] == nil then
		moho:SetCurFrame(curFrame)
		return
	end
	
	if self.overlayGroupLayerUUID then
		self.overlayGroupLayer = self:ValidateLayer(moho, self.overlayGroupLayer, self.overlayGroupLayerUUID)
	end

	if self.overlayGroupLayer and self.replaceOverlayLayer then
		if not self.undoDone then
			moho.document:PrepUndo(self.overlayGroupLayer)
			moho.document:SetDirty()
			self.undoDone = true
		end
		self.overlayGroupLayer:SetVisible(true)
	else
		moho.document:PrepUndo(nil)
		moho.document:SetDirty()
	end
	
	local curName = moho.layer:Name()
	local curAction = moho.document:CurrentDocAction()
	
	local currentQualityFlags = moho.view:QualityFlags()
	local wireframe = MOHO.hasbit(moho.view:QualityFlags(), MOHO.bit(MOHO.LDQ_WIREFRAME))
	if wireframe then
		moho.view:SetQualityFlags(currentQualityFlags - MOHO.LDQ_WIREFRAME)
	end

	local posList = {}
	local curveList = {}
	local exposureList = {}

	local selectedPointsList = {}

	for k, id in ipairs(self.layersToOverlay) do
		local layer = moho:LayerAsVector(moho.document:LayerByAbsoluteID(id))
		if layer == nil then
			return
		end

		local layerMesh = layer:Mesh()
		if self.autoSelectShapesPointsCur then
			local layerSelectedPointsList = {}
			for i=0, layerMesh:CountPoints() - 1 do
				local pt = layerMesh:Point(i)
				layerSelectedPointsList[i + 1] = pt.fSelected
			end
			selectedPointsList[k] = layerSelectedPointsList
		end	
		local layerPosList = {}
		if self.autoSelectShapesPointsCur then
			layerMesh:SelectAll()
		else	
			layerMesh:SelectConnected()
		end
		for i = 0, layerMesh:CountPoints() - 1 do
			local pt = layerMesh:Point(i)
			if (pt.fSelected) then
				local globalPointPos = LM.Vector2:new_local()
				globalPointPos:Set(pt.fPos)
				globalPointPos = MR_Utilities:GetGlobalPos(moho, layer, globalPointPos, false)
				table.insert(layerPosList, globalPointPos)
			end
		end
		table.insert(posList, layerPosList)
	end

	for k, id in ipairs(self.layersToOverlay) do
		local layer = moho:LayerAsVector(moho.document:LayerByAbsoluteID(id))
		local layerMesh = layer:Mesh()
		local layerCurveList = {}
		local layerExposureList = {}
		layerExposureList.startValue = {}
		layerExposureList.endValue = {}
		for i = 0, layerMesh:CountCurves() - 1 do
			local curve = layerMesh:Curve(i)

			table.insert(layerExposureList.startValue, curve.fStartPercent.value)
			table.insert(layerExposureList.endValue, curve.fEndPercent.value)

			local handlePosList = {}
			handlePosList.inV = {}
			handlePosList.outV = {}
			local isCurveSelected = false
			for j = 0, curve:CountPoints() - 1 do
				if curve:Point(j).fSelected then
					isCurveSelected = true
					local handlePosIn =	curve:GetControlHandle(j, moho.frame, true)
					local handlePosOut = curve:GetControlHandle(j, moho.frame, false)
					handlePosIn = MR_Utilities:GetGlobalPos(moho, layer, handlePosIn, false)
					handlePosOut = MR_Utilities:GetGlobalPos(moho, layer, handlePosOut, false)
					table.insert(handlePosList.inV, handlePosIn)
					table.insert(handlePosList.outV, handlePosOut)
				end	
			end
			if isCurveSelected then
				table.insert(layerCurveList, handlePosList)
			end	
		end
		table.insert(curveList, layerCurveList)
		table.insert(exposureList, layerExposureList)
	end

	if curAction ~= '' then
		moho.document:SetCurrentDocAction(nil)
		moho.layer:ActivateAction(nil)
	end

	local topLayer = moho.document:Layer(moho.document:CountLayers()-1)

	moho:SetSelLayer(topLayer)
	
	local overlayLayer = self:GetOverlayLayer(moho, topLayer)

	if overlayLayer ~= nil then
		local overlayMeshLayer = moho:LayerAsVector(overlayLayer)
		if overlayMeshLayer then
			local overlayLayerMesh = overlayMeshLayer:Mesh()
			if overlayLayerMesh ~= nil then
				overlayLayerMesh:Clear()
				overlayLayer:SetVisible(true)
				moho.view:DrawMe()
			end
		end
	else
		curLayer = self:ValidateLayer(moho, curLayer, curLayerUUID)
		moho:SetSelLayer(curLayer)
		return
	end

	if self.overlayGroupLayerUUID then
		self.overlayGroupLayer = self:ValidateLayer(moho, self.overlayGroupLayer, self.overlayGroupLayerUUID)
	end

	if self.overlayGroupLayer and self.currentActiveLayer > 0 then
		local scriptData = self.overlayGroupLayer:ScriptData()
		if self.currentActiveLayer == 1 then
			local layerOpacity = self.layer_1_opacityValue
			local layer1Opacity = scriptData:GetInt('MR Overlay Layer 1 opacity')
			if layer1Opacity ~= nil then
				layerOpacity = layer1Opacity
			end
			overlayLayer.fAlpha:SetValue(0, layerOpacity / 100)
			self.layer_1_visibility = true
			scriptData:Set("MR Overlay Layer 1 visibility", true)
		elseif self.currentActiveLayer == 2 then
			local layerOpacity = self.layer_2_opacityValue
			local layer2Opacity = scriptData:GetInt('MR Overlay Layer 2 opacity')
			if layer2Opacity ~= nil then
				layerOpacity = layer2Opacity
			end
			overlayLayer.fAlpha:SetValue(0, layerOpacity / 100)
			self.layer_2_visibility = true
			scriptData:Set("MR Overlay Layer 2 visibility", true)
		elseif self.currentActiveLayer == 3 then
			local layerOpacity = self.layer_3_opacityValue
			local layer3Opacity = scriptData:GetInt('MR Overlay Layer 3 opacity')
			if layer3Opacity ~= nil then
				layerOpacity = layer3Opacity
			end
			overlayLayer.fAlpha:SetValue(0, layerOpacity / 100)
			self.layer_3_visibility = true
			scriptData:Set("MR Overlay Layer 3 visibility", true)
		elseif self.currentActiveLayer == 4 then
			local layerOpacity = self.layer_4_opacityValue
			local layer4Opacity = scriptData:GetInt('MR Overlay Layer 4 opacity')
			if layer4Opacity ~= nil then
				layerOpacity = layer4Opacity
			end
			overlayLayer.fAlpha:SetValue(0, layerOpacity / 100)
			self.layer_4_visibility = true
			scriptData:Set("MR Overlay Layer 4 visibility", true)
		elseif self.currentActiveLayer == 5 then
			local layerOpacity = self.layer_5_opacityValue
			local layer5Opacity = scriptData:GetInt('MR Overlay Layer 5 opacity')
			if layer5Opacity ~= nil then
				layerOpacity = layer5Opacity
			end
			overlayLayer.fAlpha:SetValue(0, layerOpacity / 100)
			self.layer_5_visibility = true
			scriptData:Set("MR Overlay Layer 5 visibility", true)
		end
	end
	if self.doNotRender then
		overlayLayer:SetEditOnly(true)
	else
		overlayLayer:SetEditOnly(false)
	end
	
	local newMesh = moho:LayerAsVector(overlayLayer):Mesh()
	local layerCounter = 1
	local blackColorRGB = LM.rgb_color:new_local()
	blackColorRGB.r = 0
	blackColorRGB.g = 0
	blackColorRGB.b = 0
	blackColorRGB.a = 255
	local shapeCounter = 0

	for k, id in ipairs(self.layersToOverlay) do
		local layer = moho.document:LayerByAbsoluteID(id)
		local vectorLayer = moho:LayerAsVector(layer)
		
		moho:SetSelLayer(layer)
		if curAction ~= '' then
			moho.document:SetCurrentDocAction(curAction)
			layer:ActivateAction(curAction)
		end
		
		local layerMesh = vectorLayer:Mesh()
		
		if self.autoSelectShapesPointsCur then
			layerMesh:SelectAll()
		else
			layerMesh:SelectConnected()
		end
		
		local shapesOrderList = {} 
		local shapesList = {} 
		shapesList.shapeIDs = {} 
		shapesList.originalNames = {}
		shapesList.names = {}
		shapesList.colorsStroke = {}
		shapesList.colorsFill = {}
		
		if layerMesh:AnimatedShapeOrder() then
			local orderChannel = self:GetShapeOrderChannel(moho, layer)
			local orderValue
			orderValue = orderChannel.value:Buffer()
			local lastId = -1
			
			layerMesh = vectorLayer:Mesh()
			
			for n in string.gmatch(orderValue, "[^|]+") do
				local shapeId = tonumber(n)
				if shapeId ~= lastId then
					local shape = layerMesh:ShapeByID(shapeId)
					if shape then
						table.insert(shapesOrderList, shapeId)
					end	
					lastId = shapeId
				end	
			end
		else
			for i = 0, layerMesh:CountShapes() - 1 do
				local shape = layerMesh:Shape(i)
				if shape then
					table.insert(shapesOrderList, shape:ShapeID())
				end	
			end
		end
		
		for i, id in pairs(shapesOrderList) do
			local shapeId = id
			local shape = layerMesh:ShapeByID(shapeId)
			if shape then
				for p = 0, layerMesh:CountPoints()-1 do
					local point = layerMesh:Point(p)
					if point.fSelected and shape:ContainsPoint(p) then
						local newName = 'Layer '..layerCounter..' '..moho.layer:Name()..'   Shape '..shapeCounter
						shapeCounter = shapeCounter + 1
						table.insert(shapesList.shapeIDs, shapeId)
						table.insert(shapesList.originalNames, shape:Name())
						table.insert(shapesList.names, newName)
						if shape.fHasFill then
							local color = LM.rgb_color:new_local()
							color.r = shape.fMyStyle.fFillCol.value.r
							color.g = shape.fMyStyle.fFillCol.value.g
							color.b = shape.fMyStyle.fFillCol.value.b
							color.a = shape.fMyStyle.fFillCol.value.a	
							table.insert(shapesList.colorsFill, color)
						else	
							table.insert(shapesList.colorsFill, blackColorRGB)
						end	
						if shape.fHasOutline then
							local color = LM.rgb_color:new_local()
							color.r = shape.fMyStyle.fLineCol.value.r
							color.g = shape.fMyStyle.fLineCol.value.g
							color.b = shape.fMyStyle.fLineCol.value.b
							color.a = shape.fMyStyle.fLineCol.value.a
							table.insert(shapesList.colorsStroke, color)
						else
							table.insert(shapesList.colorsStroke, blackColorRGB)
						end
						shape:SetName(newName)
						break
					end	
				end
			end	
		end
	
		layerCounter = layerCounter + 1
		
		local offset = LM.Vector2:new_local()
		offset:Set(0, 1)
		local zeroOffset = LM.Vector2:new_local()
		zeroOffset:Set(0, 0)
		offset = MR_Utilities:GetGlobalPos(moho, layer, offset, false)
		zeroOffset = MR_Utilities:GetGlobalPos(moho, layer, zeroOffset, false)
		local layerTransfotmation = MR_Utilities:GetDistance(offset, zeroOffset)
		local scaleNormalization = layer:ScaleNormalization()

		moho:Copy(layerMesh)
		moho:SetSelLayer(overlayLayer)
		local layerPoints = newMesh:CountPoints()
		local layerCurves = newMesh:CountCurves()
		moho:Paste()

		for i = layerCurves, newMesh:CountCurves() - 1 do
			local curve = newMesh:Curve(i)
			if curve then
				curve.fStartPercent:SetValue(0, exposureList[k].startValue[i - layerCurves + 1])
				curve.fEndPercent:SetValue(0, exposureList[k].endValue[i - layerCurves + 1])
			end
		end

		overlayLayer:ClearAnimation(true, 0, false)
		
		if curAction ~= '' then
			moho.document:SetCurrentDocAction(nil)
			layer:ActivateAction(nil)
		end
		
		newMesh = moho:LayerAsVector(overlayLayer):Mesh()
		
		for i = 1, #shapesList.shapeIDs do
			local newShape = newMesh:ShapeByName(shapesList.names[i])
			local newShapeID = newMesh:ShapeID(newShape)
			
			if newShape then
				newMesh:RaiseShape(newShapeID, true)
				if newShape.fHasOutline then
					newShape.fMyStyle.fLineCol:SetValue(0, shapesList.colorsStroke[i])
					newShape.fMyStyle.fLineWidth = newShape.fMyStyle.fLineWidth * layerTransfotmation * scaleNormalization
					if self.makeShapesPlainCur then
						newShape:MakePlain()
					end
				end	
				
				if newShape.fHasFill then
					newShape.fMyStyle.fFillCol:SetValue(0, shapesList.colorsFill[i])
				end
			end
			local originalShape = layerMesh:ShapeByID(shapesList.shapeIDs[i])
			originalShape:SetName(shapesList.originalNames[i])
		end
	
		for i, a in pairs(posList[k]) do
			local pointID = i-1 + layerPoints
			if pointID <= newMesh:CountPoints() then
				local pt = newMesh:Point(pointID)
				if (pt.fSelected) then
					pt.fAnimPos:SetValue(0, posList[k][i])
				end
			end	
		end
		
		overlayLayer:ClearAnimation(true, 0, false)
		overlayLayer:UpdateCurFrame()

		for i, a in pairs(curveList[k]) do
			local curveID = i - 1 + layerCurves
			if curveID <= newMesh:CountCurves() then
				local curve = newMesh:Curve(i - 1 + layerCurves)
				for e, b in pairs(curveList[k][i].inV) do
					local pn = e-1
					curve:SetControlHandle(e -1, curveList[k][i].inV[e], moho.frame, true, false)
					curve:SetControlHandle(e-1, curveList[k][i].outV[e], moho.frame, false, false)
				end
			end	
		end
		
		local curvature = 0
		local curve = nil
		local ptPos = -1
		local newMeshPoints = newMesh:CountPoints()
		for i = 0, newMeshPoints - 1 do
			local pointID = i + layerPoints
			if pointID <= newMeshPoints - 1 then
				local pt = newMesh:Point(i + layerPoints)
				if pt then
					for j = 0, pt:CountCurves() - 1 do
						curve, ptPos = pt:Curve(j + layerPoints, ptPos)
						curve:SetCurvature(ptPos, curve:GetCurvature(ptPos, moho.frame), 0)
								
						curve:SetWeight(ptPos, curve:GetWeight(ptPos, moho.frame, true), 0, true)
						curve:SetWeight(ptPos, curve:GetWeight(ptPos, moho.frame, false), 0, false)
						
						curve:SetOffset(ptPos, curve:GetOffset(ptPos, moho.frame, true), 0, true)
						curve:SetOffset(ptPos, curve:GetOffset(ptPos, moho.frame, false), 0, false)
					end
				end	
			end	
		end
	end
	
	if not self.drawFillsCur then
		for i = 0, newMesh:CountShapes() - 1 do
			local shape = newMesh:Shape(i)
			if (shape ~= nil) then
				shape.fHasFill = false
			end
		end
	end

	if not self.drawStrokesCur then
		for i = 0, newMesh:CountShapes() - 1 do
			local shape = newMesh:Shape(i)
			if (shape ~= nil) then
				shape.fHasOutline = false
			end
		end
	end
	
	if self.recolorStrokeCur and self.drawStrokesCur then
		local color = LM.rgb_color:new_local()
		color.r = self.strokeColorCurR
		color.g = self.strokeColorCurG
		color.b = self.strokeColorCurB
		color.a = self.strokeColorCurA
		if (style ~= nil) then
			style.fLineCol:SetValue(0, color)
		end
		for i = 0, newMesh:CountShapes() - 1 do
			local shape = newMesh:Shape(i)
			if (shape ~= nil) then
				if self.preserveStrokeAlphaCur then
					color.a = shape.fMyStyle.fLineCol.value.a
				else
					color.a = self.strokeColorCurA
				end
				shape.fMyStyle.fLineCol:SetValue(0, color)
			end
		end
	end

	if self.recolorFillCur and self.drawFillsCur then
		local color = LM.rgb_color:new_local()
		color.r = self.fillColorCurR
		color.g = self.fillColorCurG
		color.b = self.fillColorCurB
		color.a = self.fillColorCurA
		if (style ~= nil) then
			style.fFillCol:SetValue(0, color)
		end
		for i = 0, newMesh:CountShapes() - 1 do
			local shape = newMesh:Shape(i)
			if (shape ~= nil) then
				if self.preserveFillAlphaCur then
					color.a = shape.fMyStyle.fFillCol.value.a
				else
					color.a = self.fillColorCurA
				end
				shape.fMyStyle.fFillCol:SetValue(0, color)
			end
		end
	end
	
	if self.changeStrokeWidthCur and self.drawStrokesCur then
		local lineWidth = self.strokeWidthCur
		lineWidth = LM.Clamp(lineWidth, 0.25, 256)
		for i = 0, newMesh:CountShapes() - 1 do
			local shape = newMesh:Shape(i)
			if (shape ~= nil) then
				shape.fMyStyle.fLineWidth = lineWidth / moho.document:Height()
			end
		end
	end
	
	if self.flipOverlayCur then
		curLayer = self:ValidateLayer(moho, curLayer, curLayerUUID)
		self:FlipOverlay(moho, curLayer, newMesh, overlayLayer)
	end
	
	if newMesh:CountPoints() > 0 then
		local firstPoint = newMesh:Point(0)
		firstPoint.fAnimPos:SetValue(1, firstPoint.fAnimPos:GetValue(0))
	end
	
	overlayLayer:ClearAnimation(true, 0, false)

	if self.autoSelectShapesPointsCur then
		for k, id in ipairs(self.layersToOverlay) do
			local layer = moho:LayerAsVector(moho.document:LayerByAbsoluteID(id))
			local layerMesh = layer:Mesh()
			if selectedPointsList[k] then
				for i = 0, layerMesh:CountPoints() - 1 do
					local pt = layerMesh:Point(i)
					pt.fSelected = selectedPointsList[k][i+1]
				end
			end
		end
	end

	if wireframe then
		moho.view:SetQualityFlags(currentQualityFlags)
	end

	moho.view:DrawMe()

	local actionsToRemove = {}
	local actions = overlayLayer:CountActions()
	local actionName
	if actions > 0 then
		for a=0, actions-1 do
			actionName = overlayLayer:ActionName(a)
			table.insert(actionsToRemove, actionName)
		end
		for _,name in ipairs(actionsToRemove) do
			overlayLayer:DeleteAction(name)
		end
	end	
	
	curLayer = self:ValidateLayer(moho, curLayer, curLayerUUID)
	if curAction ~= '' then
		self:ReturnToAction(moho, curAction, curLayer, curFrame)
	end
	
	moho:SetSelLayer(curLayer)

	for _, layer in ipairs(self.secondarySelection) do
		layer:SetSecondarySelection(true)
	end
	
	if self.createOverlayFromFrameCur then
		moho:SetCurFrame(curFrame)
	end	
	
	overlayLayer:UpdateCurFrame()
	curLayer:UpdateCurFrame()
end

function MR_Overlay:CreateBonesOverlay(moho)
	local curLayer = moho.layer
	local curLayerUUID = curLayer:UUID()
	local curFrame = moho.frame
	local curName = moho.layer:Name()
	local curAction = moho.document:CurrentDocAction()
	local selectedBonesList = {}

	local skelControl = false
	local skelLayer = moho:LayerAsBone(curLayer)
	local skel = nil
	if skelLayer then
		skel = skelLayer:Skeleton()
	else
		skelLayer = curLayer:ControllingBoneLayer()
	end
	local skel = nil
	if skelLayer ~= nil then
		skel = skelLayer:Skeleton()
		skelControl = true
	end

	if self.overlayGroupLayer then
		local scriptData = self.overlayGroupLayer:ScriptData()
		local activeLayerValue = self.currentActiveLayer
		if activeLayerValue ~= nil then
			local savedLayers = scriptData:GetString('MR Overlay Layer Selection '..math.floor(activeLayerValue))
			local layerUseSelection = scriptData:GetBool('MR Overlay Use Layer Selection '..math.floor(activeLayerValue))
			local savedSelectionBones = scriptData:GetString('MR Overlay Layer Selection Bones '..math.floor(activeLayerValue))
			local first = true
			if #savedLayers > 0 and layerUseSelection then
				local savedLayersList = {}
				MR_Utilities:StringToTable(savedLayers, savedLayersList, 's')
				for _, uuid in ipairs(savedLayersList) do
					local layer = MR_Utilities:GetLayerByUUID(moho, uuid)
					if layer then
						if first then
							moho:SetSelLayer(layer)
							curLayer = layer
							first = false
							layer:UpdateCurFrame()
						else
							layer:SetSecondarySelection(true)
							layer:UpdateCurFrame()
						end
					end
				end
				local savedSelectedBonesList = {}
				MR_Utilities:StringToTable(savedSelectionBones, savedSelectedBonesList, 's')
				if skel then
					if #savedSelectedBonesList > 0 then
						for i=0, skel:CountBones()-1 do
							local bone = skel:Bone(i)
							selectedBonesList[i] = bone.fSelected
						end
					end
					skel:SelectNone()
					for _, boneName in ipairs(savedSelectedBonesList) do
						local bone = skel:BoneByName(boneName)
						if bone then
							bone.fSelected = true
						end
					end
				end
			end
		end
	end

	local currentQualityFlags = moho.view:QualityFlags()
	local wireframe = MOHO.hasbit(moho.view:QualityFlags(), MOHO.bit(MOHO.LDQ_WIREFRAME))
	if wireframe then
		moho.view:SetQualityFlags(currentQualityFlags - MOHO.LDQ_WIREFRAME)
	end

	if self.createOverlayFromFrameCur and self.overlayFrameCur ~= curFrame then
		moho:SetCurFrame(self.overlayFrameCur)
	end

	self.layersToOverlay = {}
	self.secondarySelection = {}
	local selectedCount = moho.document:CountSelectedLayers()
	for i=0, selectedCount-1 do
		local selectedLayer = moho.document:GetSelectedLayer(i)
		if selectedLayer then
			local skelLayer = moho:LayerAsBone(selectedLayer)
			if skelLayer then
				local skel = skelLayer:Skeleton()
				if skel:CountBones() > 0 then
					local found = false
					for _, id in ipairs(self.layersToOverlay) do
						if id == moho.document:LayerAbsoluteID(selectedLayer) then
							found = true
							break
						end
					end
					if not found then
						table.insert(self.layersToOverlay, moho.document:LayerAbsoluteID(selectedLayer))
					end
				end
			end
		end
	end

	if self.layersToOverlay[1] == nil then
		moho:SetCurFrame(curFrame)
		if wireframe then
			moho.view:SetQualityFlags(currentQualityFlags)
		end
		return
	end

	if self.overlayGroupLayer and self.replaceOverlayLayer then
		if not self.undoDone then
			moho.document:PrepUndo(self.overlayGroupLayer)
			moho.document:SetDirty()
			self.undoDone = true
		end
		self.overlayGroupLayer:SetVisible(true)
	else
		moho.document:PrepUndo(nil)
		moho.document:SetDirty()
	end

	local bonesList = {}
	bonesList.base = {}
	bonesList.tip = {}
	bonesList.isPin = {}

	for k, id in ipairs(self.layersToOverlay) do
		local skelLayer = moho:LayerAsBone(moho.document:LayerByAbsoluteID(id))
		if skelLayer then
			local skel = skelLayer:Skeleton()
			for i=0, skel:CountBones()-1 do
				local bone = skel:Bone(i)
				if bone.fSelected or not self.selectedBonesOnlyCur then
					if (not self.drawHiddenBonesCur and not bone.fHidden and bone:IsGroupVisible()) or self.drawHiddenBonesCur then
						local basePos = LM.Vector2:new_local()
						local baseTip = LM.Vector2:new_local()
						basePos:Set(0, 0)
						if bone:IsZeroLength() then
							baseTip:Set(0.1, 0)
						else
							baseTip:Set(bone.fLength, 0)
						end
						if moho.frame == 0 then
							bone.fRestMatrix:Transform(basePos)
							bone.fRestMatrix:Transform(baseTip)
						else
							bone.fMovedMatrix:Transform(basePos)
							bone.fMovedMatrix:Transform(baseTip)
						end
						basePos = MR_Utilities:GetGlobalPos(moho, skelLayer, basePos, false)
						baseTip = MR_Utilities:GetGlobalPos(moho, skelLayer, baseTip, false)
						table.insert(bonesList.base, basePos)
						table.insert(bonesList.tip, baseTip)
						table.insert(bonesList.isPin, bone:IsZeroLength())
					end
				end
			end
		end
	end

	if #bonesList.base == 0 then
		moho:SetCurFrame(curFrame)
		if wireframe then
			moho.view:SetQualityFlags(currentQualityFlags)
		end
		return
	end

	if curAction ~= '' then
		moho.document:SetCurrentDocAction(nil)
		moho.layer:ActivateAction(nil)
	end

	local topLayer = moho.document:Layer(moho.document:CountLayers()-1)
	moho:SetSelLayer(topLayer)

	local overlayLayer = self:GetOverlayLayer(moho, topLayer)

	if overlayLayer ~= nil then
		local overlayMeshLayer = moho:LayerAsVector(overlayLayer)
		if overlayMeshLayer then
			local overlayLayerMesh = overlayMeshLayer:Mesh()
			if overlayLayerMesh ~= nil then
				overlayLayerMesh:Clear()
				overlayLayer:SetVisible(true)
				moho.view:DrawMe()
			end
		end
	else
		moho:SetCurFrame(curFrame)
		if wireframe then
			moho.view:SetQualityFlags(currentQualityFlags)
		end
		return
	end

	if self.overlayGroupLayerUUID then
		self.overlayGroupLayer = self:ValidateLayer(moho, self.overlayGroupLayer, self.overlayGroupLayerUUID)
	end

	if self.overlayGroupLayer and self.currentActiveLayer > 0 then
		local scriptData = self.overlayGroupLayer:ScriptData()
		if self.currentActiveLayer == 1 then
			local layerOpacity = self.layer_1_opacityValue
			local layer1Opacity = scriptData:GetInt('MR Overlay Layer 1 opacity')
			if layer1Opacity ~= nil then
				layerOpacity = layer1Opacity
			end
			overlayLayer.fAlpha:SetValue(0, layerOpacity / 100)
			self.layer_1_visibility = true
			scriptData:Set("MR Overlay Layer 1 visibility", true)
		elseif self.currentActiveLayer == 2 then
			local layerOpacity = self.layer_2_opacityValue
			local layer2Opacity = scriptData:GetInt('MR Overlay Layer 2 opacity')
			if layer2Opacity ~= nil then
				layerOpacity = layer2Opacity
			end
			overlayLayer.fAlpha:SetValue(0, layerOpacity / 100)
			self.layer_2_visibility = true
			scriptData:Set("MR Overlay Layer 2 visibility", true)
		elseif self.currentActiveLayer == 3 then
			local layerOpacity = self.layer_3_opacityValue
			local layer3Opacity = scriptData:GetInt('MR Overlay Layer 3 opacity')
			if layer3Opacity ~= nil then
				layerOpacity = layer3Opacity
			end
			overlayLayer.fAlpha:SetValue(0, layerOpacity / 100)
			self.layer_3_visibility = true
			scriptData:Set("MR Overlay Layer 3 visibility", true)
		elseif self.currentActiveLayer == 4 then
			local layerOpacity = self.layer_4_opacityValue
			local layer4Opacity = scriptData:GetInt('MR Overlay Layer 4 opacity')
			if layer4Opacity ~= nil then
				layerOpacity = layer4Opacity
			end
			overlayLayer.fAlpha:SetValue(0, layerOpacity / 100)
			self.layer_4_visibility = true
			scriptData:Set("MR Overlay Layer 4 visibility", true)
		elseif self.currentActiveLayer == 5 then
			local layerOpacity = self.layer_5_opacityValue
			local layer5Opacity = scriptData:GetInt('MR Overlay Layer 5 opacity')
			if layer5Opacity ~= nil then
				layerOpacity = layer5Opacity
			end
			overlayLayer.fAlpha:SetValue(0, layerOpacity / 100)
			self.layer_5_visibility = true
			scriptData:Set("MR Overlay Layer 5 visibility", true)
		end
	end
	if self.doNotRender then
		overlayLayer:SetEditOnly(true)
	else
		overlayLayer:SetEditOnly(false)
	end

	moho:SetSelLayer(overlayLayer)
	local newMesh = moho:LayerAsVector(overlayLayer):Mesh()

	local color = LM.rgb_color:new_local()
	color.r = self.boneColorCurR
	color.g = self.boneColorCurG
	color.b = self.boneColorCurB
	color.a = self.boneColorCurA
	if (style ~= nil) then
		style.fLineCol:SetValue(0, color)
	end

	for i=1, #bonesList.base do
		newMesh:SelectNone()
		if bonesList.isPin[i] then
			local vec = LM.Vector2:new_local()
			local angle = MR_Utilities:GetAngle(bonesList.base[i], bonesList.tip[i])
			local n = newMesh:CountPoints()
			local radius = 0.01 * self.pinBoneRadiusCur

			vec:Set(bonesList.base[i].x + radius, bonesList.base[i].y)
			vec = MR_Utilities:RotateVector2(vec, bonesList.base[i], angle)
			newMesh:AddLonePoint(vec, 0)
			
			vec = MR_Utilities:RotateVector2(vec, bonesList.base[i], math.rad(90))
			newMesh:AppendPoint(vec, 0)
			
			vec = MR_Utilities:RotateVector2(vec, bonesList.base[i], math.rad(90))
			newMesh:AppendPoint(vec, 0)
			
			vec = MR_Utilities:RotateVector2(vec, bonesList.base[i], math.rad(90))
			newMesh:AppendPoint(vec, 0)
			
			vec = MR_Utilities:RotateVector2(vec, bonesList.base[i], math.rad(90))
			newMesh:AppendPoint(vec, 0)
			newMesh:WeldPoints(n + 4, n, 0)

			newMesh:Point(n):SetCurvature(0.391379, 0)
			newMesh:Point(n + 1):SetCurvature(0.391379, 0)
			newMesh:Point(n + 2):SetCurvature(0.391379, 0)
			newMesh:Point(n + 3):SetCurvature(0.391379, 0)

			newMesh:SelectConnected()

			if self.useSeparateShapes then
				local shapeID = moho:CreateShape(false, false, 0)
				if shapeID >= 0 then
					local shape = newMesh:Shape(shapeID)	
					local lineWidth = self.bonesLineWidthCur
					lineWidth = LM.Clamp(lineWidth, 0.25, 256)
					shape.fMyStyle.fLineWidth = lineWidth / moho.document:Height()
					shape.fMyStyle.fLineCol:SetValue(0, color)
					shape.fMyStyle.fLineCaps = 0
					shape:MakePlain()
				end
			end

			if self.drawPinBoneCenterLinesCur then
				newMesh:SelectNone()
				vec:Set(bonesList.base[i].x + radius, bonesList.base[i].y)
				vec = MR_Utilities:RotateVector2(vec, bonesList.base[i], angle)
				newMesh:AddLonePoint(vec, 0)
				vec = MR_Utilities:RotateVector2(vec, bonesList.base[i], -math.rad(180))
				newMesh:AppendPoint(vec, 0)
				newMesh:SelectConnected()


				if self.useSeparateShapes then
					shapeID = moho:CreateShape(false, false, 0)
					if shapeID >= 0 then
						local shape = newMesh:Shape(shapeID)	
						local lineWidth = self.bonesLineWidthCur
						lineWidth = LM.Clamp(lineWidth, 0.25, 256)
						shape.fMyStyle.fLineWidth = lineWidth / moho.document:Height()
						shape.fMyStyle.fLineCol:SetValue(0, color)
						shape.fMyStyle.fLineCaps = 0
						shape:MakePlain()
					end
				end
				newMesh:SelectNone()
				
				vec:Set(bonesList.base[i].x + radius, bonesList.base[i].y)
				vec = MR_Utilities:RotateVector2(vec, bonesList.base[i], angle + math.rad(90))
				newMesh:AddLonePoint(vec, 0)
				vec = MR_Utilities:RotateVector2(vec, bonesList.base[i], -math.rad(180))
				newMesh:AppendPoint(vec, 0)
				newMesh:SelectConnected()

				if self.useSeparateShapes then
					shapeID = moho:CreateShape(false, false, 0)
					if shapeID >= 0 then
						local shape = newMesh:Shape(shapeID)	
						local lineWidth = self.bonesLineWidthCur
						lineWidth = LM.Clamp(lineWidth, 0.25, 256)
						shape.fMyStyle.fLineWidth = lineWidth / moho.document:Height()
						shape.fMyStyle.fLineCol:SetValue(0, color)
						shape.fMyStyle.fLineCaps = 0
						shape:MakePlain()
					end
				end
			end
		else
			if self.bonesWidthCur == 0 then
				newMesh:AddLonePoint(bonesList.base[i], 0)
				newMesh:AppendPoint(bonesList.tip[i], 0)
			else
				local basePos = bonesList.base[i]
				local tipPos = bonesList.tip[i]
				local sideL = LM.Vector2:new_local()
				local sideR = LM.Vector2:new_local()
				local sidePos = LM.Vector2:new_local()
				local n = newMesh:CountPoints()

				sidePos:Set(basePos.x + ((tipPos.x - basePos.x) * (0.025 * self.bonesWidthCur)), basePos.y + ((tipPos.y - basePos.y) * (0.025 * self.bonesWidthCur)))

				sideL = MR_Utilities:RotateVector2(basePos, sidePos, math.rad(-90))
				sideR = MR_Utilities:RotateVector2(basePos, sidePos, math.rad(90))

				newMesh:AddLonePoint(basePos, 0)
				newMesh:AppendPoint(sideL, 0)
				newMesh:AppendPoint(tipPos, 0)
				newMesh:AppendPoint(sideR, 0)
				newMesh:AppendPoint(basePos, 0)

				if self.drawCenterLineCur then
					newMesh:AppendPoint(tipPos, 0)
					newMesh:Point(n+4):SetCurvature(0, 0)
				else
					newMesh:WeldPoints(n + 4, n, 0)	
				end

				newMesh:Point(n):SetCurvature(0, 0)
				newMesh:Point(n+1):SetCurvature(0, 0)
				newMesh:Point(n+2):SetCurvature(0, 0)
				newMesh:Point(n+3):SetCurvature(0, 0)
			end

			local lastPoint = newMesh:Point(newMesh:CountPoints() - 1)
			lastPoint.fSelected = true
			newMesh:SelectConnected()

			if self.useSeparateShapes then
				local shapeID = moho:CreateShape(false, false, 0)
				if shapeID >= 0 then
					local shape = newMesh:Shape(shapeID)	
					local lineWidth = self.bonesLineWidthCur
					lineWidth = LM.Clamp(lineWidth, 0.25, 256)
					shape.fMyStyle.fLineWidth = lineWidth / moho.document:Height()
					shape.fMyStyle.fLineCol:SetValue(0, color)
					shape.fMyStyle.fLineCaps = 0
					shape:MakePlain()
				end
			end
		end
	end

	if not self.useSeparateShapes then
		newMesh:SelectAll()
		local shapeID = moho:CreateShape(false, false, 0)
		if shapeID >= 0 then
			local shape = newMesh:Shape(shapeID)	
			local lineWidth = self.bonesLineWidthCur
			lineWidth = LM.Clamp(lineWidth, 0.25, 256)
			shape.fMyStyle.fLineWidth = lineWidth / moho.document:Height()
			shape.fMyStyle.fLineCol:SetValue(0, color)
			shape.fMyStyle.fLineCaps = 0
			shape:MakePlain()
		end
	end

	newMesh:SelectNone()
	curLayer = self:ValidateLayer(moho, curLayer, curLayerUUID)
	if self.flipOverlayCur then
		self:FlipOverlay(moho, curLayer, newMesh, overlayLayer)
	end
	
	overlayLayer:ClearAnimation(true, 0, false)
	
	if newMesh:CountPoints() > 0 then
		local firstPoint = newMesh:Point(0)
		firstPoint.fAnimPos:SetValue(1, firstPoint.fAnimPos:GetValue(0))
	end
	
	if wireframe then
		moho.view:SetQualityFlags(currentQualityFlags)
	end

	moho.view:DrawMe()

	local actionsToRemove = {}
	local actions = overlayLayer:CountActions()
	local actionName
	if actions > 0 then
		for a=0, actions-1 do
			actionName = overlayLayer:ActionName(a)
			table.insert(actionsToRemove, actionName)
		end
		for _,name in ipairs(actionsToRemove) do
			overlayLayer:DeleteAction(name)
		end
	end	

	curLayer = self:ValidateLayer(moho, curLayer, curLayerUUID)

	if curAction ~= '' then
		self:ReturnToAction(moho, curAction, curLayer, curFrame)
	end
	
	if not self.selectNewOverlayLayer then
		moho:SetSelLayer(curLayer)
		for _, layer in ipairs(self.secondarySelection) do
			layer:SetSecondarySelection(true)
		end
	end

	if self.overlayGroupLayerUUID then
		self.overlayGroupLayer = self:ValidateLayer(moho, self.overlayGroupLayer, self.overlayGroupLayerUUID)
	end

	if self.overlayGroupLayer then
		self.overlayGroupLayer:SetVisible(true)
	end
	
	if self.createOverlayFromFrameCur then
		moho:SetCurFrame(curFrame)
	end	
	
	if #selectedBonesList > 0 and skel then
		for i=0, skel:CountBones()-1 do
			local bone = skel:Bone(i)
			bone.fSelected = selectedBonesList[i]
		end
	end

	overlayLayer:UpdateCurFrame()
	curLayer:UpdateCurFrame()
end

function MR_Overlay:GetOverlayLayer(moho, topLayer)
	local scriptData = topLayer:ScriptData()
	local overlayLayer = nil
	if (scriptData:HasKey("MR Overlay Group")) then
		local topLayerGroup = moho:LayerAsGroup(topLayer)
		overlayLayer = self:FindOverlayVectorLayer(moho, topLayerGroup)
	else
		if (scriptData:HasKey("MR Guides Layer")) then
			topLayer = moho.document:Layer(moho.document:CountLayers()-2)
			scriptData = topLayer:ScriptData()
			moho:SetSelLayer(topLayer)
			if (scriptData:HasKey("MR Overlay Group")) then
				overlayLayer = self:FindOverlayVectorLayer(moho, topLayer)
			elseif (scriptData:HasKey("MR Path Layer")) then
				topLayer = moho.document:Layer(moho.document:CountLayers()-3)
				scriptData = topLayer:ScriptData()
				moho:SetSelLayer(topLayer)
				if (scriptData:HasKey("MR Overlay Group")) then
					overlayLayer = self:FindOverlayVectorLayer(moho, topLayer)
				else
					local overlayGroupLayer = self:CreateNewLayer(moho)
				overlayLayer = self:FindOverlayVectorLayer(moho, overlayGroupLayer)
				end
			else
				local overlayGroupLayer = self:CreateNewLayer(moho)
				overlayLayer = self:FindOverlayVectorLayer(moho, overlayGroupLayer)
			end
		elseif (scriptData:HasKey("MR Path Layer")) then
			topLayer = moho.document:Layer(moho.document:CountLayers()-2)
			scriptData = topLayer:ScriptData()
			moho:SetSelLayer(topLayer)
			if (scriptData:HasKey("MR Overlay Group")) then
				overlayLayer = self:FindOverlayVectorLayer(moho, topLayer)
			else
				local overlayGroupLayer = self:CreateNewLayer(moho)
				overlayLayer = self:FindOverlayVectorLayer(moho, overlayGroupLayer)
			end		
		else
			local overlayGroupLayer = self:CreateNewLayer(moho)
			overlayLayer = self:FindOverlayVectorLayer(moho, overlayGroupLayer)
		end
	end
	return overlayLayer
end

function MR_Overlay:CreatePointsOverlay(moho)
	local curLayer = moho.layer
	local curLayerUUID = curLayer:UUID()
	local curFrame = moho.frame

	if self.overlayGroupLayer then
		local scriptData = self.overlayGroupLayer:ScriptData()
		local activeLayerValue = self.currentActiveLayer
		if activeLayerValue ~= nil then
			local savedLayers = scriptData:GetString('MR Overlay Layer Selection '..math.floor(activeLayerValue))
			local layerUseSelection = scriptData:GetBool('MR Overlay Use Layer Selection '..math.floor(activeLayerValue))
			local first = true
			if #savedLayers > 0 and layerUseSelection then
				local savedLayersList = {}
				MR_Utilities:StringToTable(savedLayers, savedLayersList, 's')
				for _, uuid in ipairs(savedLayersList) do
					local layer = MR_Utilities:GetLayerByUUID(moho, uuid)
					if layer then
						if first then
							moho:SetSelLayer(layer)
							curLayer = layer
							first = false
							layer:UpdateCurFrame()
						else
							layer:SetSecondarySelection(true)
							layer:UpdateCurFrame()
						end
					end
				end
			end
		end
	end

	if self.createOverlayFromFrameCur and self.overlayFrameCur ~= curFrame then
		moho:SetCurFrame(self.overlayFrameCur)
	end

	local skelControl = false
	local skelLayer = moho:LayerAsBone(curLayer)
	local skel = nil
	if skelLayer then
		skel = skelLayer:Skeleton()
	else
		skelLayer = curLayer:ControllingBoneLayer()
	end

	self:ScanLayers(moho, not self.selectedPointsOnlyCur)
	
	if self.layersToOverlay[1] == nil then
		moho:SetCurFrame(curFrame)
		return
	end

	if self.overlayGroupLayerUUID then
		self.overlayGroupLayer = self:ValidateLayer(moho, self.overlayGroupLayer, self.overlayGroupLayerUUID)
	end

	if self.overlayGroupLayer and self.replaceOverlayLayer then
		if not self.undoDone then
			moho.document:PrepUndo(self.overlayGroupLayer)
			moho.document:SetDirty()
			self.undoDone = true
		end
		self.overlayGroupLayer:SetVisible(true)
	else
		moho.document:PrepUndo(nil)
		moho.document:SetDirty()
	end
	
	local curName = moho.layer:Name()
	local curAction = moho.document:CurrentDocAction()
	
	local currentQualityFlags = moho.view:QualityFlags()
	local wireframe = MOHO.hasbit(moho.view:QualityFlags(), MOHO.bit(MOHO.LDQ_WIREFRAME))
	if wireframe then
		moho.view:SetQualityFlags(currentQualityFlags - MOHO.LDQ_WIREFRAME)
	end

	local pointsPosList = {}

	for k, id in ipairs(self.layersToOverlay) do
		local layer = moho:LayerAsVector(moho.document:LayerByAbsoluteID(id))
		if layer ~= nil then
			local layerMesh = layer:Mesh()
			for i = 0, layerMesh:CountPoints() - 1 do
				local pt = layerMesh:Point(i)
				if pt.fSelected or not self.selectedPointsOnlyCur then
					if (not self.drawHiddenPointsCur and not pt.fHidden) or self.drawHiddenPointsCur then
						local pointPos = LM.Vector2:new_local()
						pointPos:Set(pt.fPos)
						pointPos = MR_Utilities:GetGlobalPos(moho, layer, pointPos, false)
						local isValueNew = true
						local pointPosRoundedX = MR_Utilities:Round(pointPos.x, 5)
						local pointPosRoundedY = MR_Utilities:Round(pointPos.y, 5)
						for key, val in pairs(pointsPosList) do
							local valRoundedX = MR_Utilities:Round(val.x, 5)
							local valRoundedY = MR_Utilities:Round(val.y, 5)
							if valRoundedX == pointPosRoundedX and valRoundedY == pointPosRoundedY then
								isValueNew = false
								break
							end
						end

						if isValueNew then
							table.insert(pointsPosList, pointPos)
						end
					end
				end
			end
		end
	end

	if #pointsPosList == 0 then
		moho:SetCurFrame(curFrame)
		
		return
	end

	if curAction ~= '' then
		moho.document:SetCurrentDocAction(nil)
		moho.layer:ActivateAction(nil)
	end

	local topLayer = moho.document:Layer(moho.document:CountLayers()-1)
	moho:SetSelLayer(topLayer)

	local overlayLayer = self:GetOverlayLayer(moho, topLayer)

	if overlayLayer ~= nil then
		local overlayMeshLayer = moho:LayerAsVector(overlayLayer)
		if overlayMeshLayer then
			local overlayLayerMesh = overlayMeshLayer:Mesh()
			if overlayLayerMesh ~= nil then
				overlayLayerMesh:Clear()
				overlayLayer:SetVisible(true)
				moho.view:DrawMe()
			end
		end
	else
		moho:SetCurFrame(curFrame)
		if wireframe then
			moho.view:SetQualityFlags(currentQualityFlags)
		end
		return
	end

	if self.overlayGroupLayerUUID then
		self.overlayGroupLayer = self:ValidateLayer(moho, self.overlayGroupLayer, self.overlayGroupLayerUUID)
	end

	if self.overlayGroupLayer and self.currentActiveLayer ~= 0 then
		local scriptData = self.overlayGroupLayer:ScriptData()

		if self.currentActiveLayer == 1 then
			local layerOpacity = self.layer_1_opacityValue
			local layer1Opacity = scriptData:GetInt('MR Overlay Layer 1 opacity')
			if layer1Opacity ~= nil then
				layerOpacity = layer1Opacity
			end
			overlayLayer.fAlpha:SetValue(0, layerOpacity / 100)
			self.layer_1_visibility = true
			scriptData:Set("MR Overlay Layer 1 visibility", true)
		elseif self.currentActiveLayer == 2 then
			local layerOpacity = self.layer_2_opacityValue
			local layer2Opacity = scriptData:GetInt('MR Overlay Layer 2 opacity')
			if layer2Opacity ~= nil then
				layerOpacity = layer2Opacity
			end
			overlayLayer.fAlpha:SetValue(0, layerOpacity / 100)
			self.layer_2_visibility = true
			scriptData:Set("MR Overlay Layer 2 visibility", true)
		elseif self.currentActiveLayer == 3 then
			local layerOpacity = self.layer_3_opacityValue
			local layer3Opacity = scriptData:GetInt('MR Overlay Layer 3 opacity')
			if layer3Opacity ~= nil then
				layerOpacity = layer3Opacity
			end
			overlayLayer.fAlpha:SetValue(0, layerOpacity / 100)
			self.layer_3_visibility = true
			scriptData:Set("MR Overlay Layer 3 visibility", true)
		elseif self.currentActiveLayer == 4 then
			local layerOpacity = self.layer_4_opacityValue
			local layer4Opacity = scriptData:GetInt('MR Overlay Layer 4 opacity')
			if layer4Opacity ~= nil then
				layerOpacity = layer4Opacity
			end
			overlayLayer.fAlpha:SetValue(0, layerOpacity / 100)
			self.layer_4_visibility = true
			scriptData:Set("MR Overlay Layer 4 visibility", true)
		elseif self.currentActiveLayer == 5 then
			local layerOpacity = self.layer_5_opacityValue
			local layer5Opacity = scriptData:GetInt('MR Overlay Layer 5 opacity')
			if layer5Opacity ~= nil then
				layerOpacity = layer5Opacity
			end
			overlayLayer.fAlpha:SetValue(0, layerOpacity / 100)
			self.layer_5_visibility = true
			scriptData:Set("MR Overlay Layer 5 visibility", true)
		end
	end
	if self.doNotRender then
		overlayLayer:SetEditOnly(true)
	else
		overlayLayer:SetEditOnly(false)
	end

	moho:SetSelLayer(overlayLayer)

	local newMesh = moho:LayerAsVector(overlayLayer):Mesh()
	if self.drawCircleCur then
		local circleColor = LM.rgb_color:new_local()
		circleColor.r = self.pointCircleColorR
		circleColor.g = self.pointCircleColorG
		circleColor.b = self.pointCircleColorB
		circleColor.a = self.pointCircleColorA
		if (style ~= nil) then
			style.fFillCol:SetValue(0, circleColor)
		end

		for i=1, #pointsPosList do
			local radius = 0.01 * self.circleRadiusCur
			local vec = LM.Vector2:new_local()
			local n = newMesh:CountPoints()

			newMesh:SelectNone()

			vec:Set(pointsPosList[i].x - radius, pointsPosList[i].y)
			newMesh:AddLonePoint(vec, 0)
			
			vec:Set(pointsPosList[i].x, pointsPosList[i].y + radius)
			newMesh:AppendPoint(vec, 0)
			
			vec:Set(pointsPosList[i].x + radius, pointsPosList[i].y)
			newMesh:AppendPoint(vec, 0)
			
			vec:Set(pointsPosList[i].x, pointsPosList[i].y - radius)
			newMesh:AppendPoint(vec, 0)
			
			vec:Set(pointsPosList[i].x - radius, pointsPosList[i].y)
			newMesh:AppendPoint(vec, 0)

			newMesh:WeldPoints(n + 4, n, 0)

			newMesh:Point(n):SetCurvature(0.391379, 0)
			newMesh:Point(n + 1):SetCurvature(0.391379, 0)
			newMesh:Point(n + 2):SetCurvature(0.391379, 0)
			newMesh:Point(n + 3):SetCurvature(0.391379, 0)

			newMesh:SelectConnected()

			local shapeID = moho:CreateShape(true, false, 0)
			if shapeID >= 0 then
				local shape = newMesh:Shape(shapeID)	
				shape.fMyStyle.fFillCol:SetValue(0, circleColor)
				shape.fHasOutline = false
			end
		end
	end

	if self.drawCrosshairCur then
		local pointsCount = newMesh:CountPoints() - 1
		local crosshairColor = LM.rgb_color:new_local()
		crosshairColor.r = self.pointCrosshairColorCurR
		crosshairColor.g = self.pointCrosshairColorCurG
		crosshairColor.b = self.pointCrosshairColorCurB
		crosshairColor.a = self.pointCrosshairColorCurA
		if (style ~= nil) then
			style.fLineCol:SetValue(0, crosshairColor)
		end

		for i=1, #pointsPosList do
			local radius = 0.01 * self.crosshairRadiusCur
			local vec = LM.Vector2:new_local()

			newMesh:SelectNone()
			vec:Set(pointsPosList[i].x + radius, pointsPosList[i].y)
			newMesh:AddLonePoint(vec, 0)
			vec:Set(pointsPosList[i].x - radius, pointsPosList[i].y)
			newMesh:AppendPoint(vec, 0)
			newMesh:SelectConnected()

			if self.useSeparateShapes then
				local shapeID = moho:CreateShape(false, false, 0)
				if shapeID >= 0 then
					local shape = newMesh:Shape(shapeID)	
					local lineWidth = self.pointLineWidthCur
					lineWidth = LM.Clamp(lineWidth, 0.25, 256)
					shape.fMyStyle.fLineWidth = lineWidth / moho.document:Height()
					shape.fMyStyle.fLineCol:SetValue(0, crosshairColor)
					shape.fMyStyle.fLineCaps = 0
					shape:MakePlain()
				end
			end

			newMesh:SelectNone()
			vec:Set(pointsPosList[i].x, pointsPosList[i].y + radius)
			newMesh:AddLonePoint(vec, 0)
			vec:Set(pointsPosList[i].x, pointsPosList[i].y - radius)
			newMesh:AppendPoint(vec, 0)
			newMesh:SelectConnected()

			if self.useSeparateShapes then
				local shapeID = moho:CreateShape(false, false, 0)
				if shapeID >= 0 then
					local shape = newMesh:Shape(shapeID)	
					local lineWidth = self.pointLineWidthCur
					lineWidth = LM.Clamp(lineWidth, 0.25, 256)
					shape.fMyStyle.fLineWidth = lineWidth / moho.document:Height()
					shape.fMyStyle.fLineCol:SetValue(0, crosshairColor)
					shape.fMyStyle.fLineCaps = 0
					shape:MakePlain()
				end
			end
		end

		if not self.useSeparateShapes then
			newMesh:SelectNone()
			for i=0, newMesh:CountPoints() - 1 do
				if i > pointsCount then
					local point = newMesh:Point(i)
					point.fSelected = true
				end
			end
			local shapeID = moho:CreateShape(false, false, 0)
			if shapeID >= 0 then
				local shape = newMesh:Shape(shapeID)	
				local lineWidth = self.pointLineWidthCur
				lineWidth = LM.Clamp(lineWidth, 0.25, 256)
				shape.fMyStyle.fLineWidth = lineWidth / moho.document:Height()
				shape.fMyStyle.fLineCol:SetValue(0, crosshairColor)
				shape.fMyStyle.fLineCaps = 0
				shape:MakePlain()
			end
		end
	end

	newMesh:SelectNone()

	curLayer = self:ValidateLayer(moho, curLayer, curLayerUUID)

	if self.flipOverlayCur then
		self:FlipOverlay(moho, curLayer, newMesh, overlayLayer)
	end

	overlayLayer:ClearAnimation(true, 0, false)
	
	if newMesh:CountPoints() > 0 then
		local firstPoint = newMesh:Point(0)
		firstPoint.fAnimPos:SetValue(1, firstPoint.fAnimPos:GetValue(0))
	end
	
	if wireframe then
		moho.view:SetQualityFlags(currentQualityFlags)
	end

	moho.view:DrawMe()

	local actionsToRemove = {}
	local actions = overlayLayer:CountActions()
	local actionName
	if actions > 0 then
		for a=0, actions-1 do
			actionName = overlayLayer:ActionName(a)
			table.insert(actionsToRemove, actionName)
		end
		for _,name in ipairs(actionsToRemove) do
			overlayLayer:DeleteAction(name)
		end
	end	

	curLayer = self:ValidateLayer(moho, curLayer, curLayerUUID)
	
	if curAction ~= '' then
		self:ReturnToAction(moho, curAction, curLayer, curFrame)
	end
	
	if not self.selectNewOverlayLayer then
		moho:SetSelLayer(curLayer)
		for _, layer in ipairs(self.secondarySelection) do
			layer:SetSecondarySelection(true)
		end
	end
	
	if self.createOverlayFromFrameCur then
		moho:SetCurFrame(curFrame)
	end	
	
	overlayLayer:UpdateCurFrame()
	curLayer:UpdateCurFrame()
end

function MR_Overlay:FlipOverlay(moho, layer, mesh, overlayLayer)
	if layer == nil then
		return
	end

	if mesh == nil then
		return
	end

	local shapesCount = mesh:CountShapes()
	local layerPoints = mesh:CountPoints()
	local pointsDif = 0
	if self.mirrorFlipCur then
		pointsDif = layerPoints
		mesh:SelectAll()
		moho:Copy(mesh)
		moho:Paste()
	end	

	local centerVec = LM.Vector2:new_local()
	if self.selectionCenterCur then
		local minAll = LM.Vector2:new_local()
		local maxAll = LM.Vector2:new_local()
		minAll:Set(1000000, 1000000)
		maxAll:Set(-1000000, -1000000)
		for i = 0, mesh:CountShapes() - 1 do
			local shape = mesh:Shape(i)
			local min = LM.Vector2:new_local()
			local max = LM.Vector2:new_local()
			shape:ShapeBounds(min, max, 0)
			if min.x < minAll.x then
				minAll.x = min.x
			end
			if min.y < minAll.y then
				minAll.y = min.y
			end
			if max.x > maxAll.x then
				maxAll.x = max.x
			end
			if max.y > maxAll.y then
				maxAll.y = max.y
			end
		end
		
		local center = LM.Vector2:new_local()
		center:Set(minAll.x + ((maxAll.x - minAll.x) / 2), minAll.y + ((maxAll.y - minAll.y) / 2))
		centerVec:Set(MR_Utilities:GetGlobalPos(moho, overlayLayer, center, false))
	elseif self.layerOriginCenterCur then
		centerVec:Set(MR_Utilities:GetGlobalPos(moho, layer, layer:Origin(), false))
	elseif self.customCenterCur then
		centerVec:Set(self.customCenterValueXCur, self.customCenterValueYCur)
	end
	for i = 0 + pointsDif, mesh:CountPoints() - 1 do
		local pt = mesh:Point(i)
		local dif = LM.Vector2:new_local()
		local newPos = LM.Vector2:new_local()
		dif:Set(centerVec.x - pt.fAnimPos:GetValue(0).x, 0)
		newPos:Set(centerVec.x + dif.x, pt.fAnimPos:GetValue(0).y)
		pt.fAnimPos:SetValue(0, newPos)
		pt:FlipControlHandles(0)
	end	

	if self.mirrorOverlayShadeCur and self.flipOverlayCur and self.mirrorFlipCur then
		for i = 0, mesh:CountShapes() - 1 do
			if i >= shapesCount then
				local shape = mesh:Shape(i)
				if shape ~= nil then
					if shape.fHasFill then
						if (self.shapesOverlayCur and self.recolorFillCur) or not self.shapesOverlayCur then
							local fillCol = shape.fMyStyle.fFillCol.value
							local h, s, v = MR_Utilities:RgbToHsb(fillCol.r, fillCol.g, fillCol.b)
							v = v / 100
							local newBrightness = v
							if v >= 0.5 then
								newBrightness = v * (1 - self.recolorShadeValue)
							else
								newBrightness = v * (1 + self.recolorShadeValue)
							end
							local r, g, b = MR_Utilities:HsbToRgb(h, s, newBrightness * 100)
							local newFillCol = LM.rgb_color:new_local()
							newFillCol.r = r
							newFillCol.g = g
							newFillCol.b = b
							newFillCol.a = fillCol.a
							shape.fMyStyle.fFillCol:SetValue(0, newFillCol)
						end
					end

					if shape.fHasOutline then
						if (self.shapesOverlayCur and self.recolorStrokeCur) or not self.shapesOverlayCur then
							local lineCol = shape.fMyStyle.fLineCol.value
							local h, s, v = MR_Utilities:RgbToHsb(lineCol.r, lineCol.g, lineCol.b)
							v = v / 100
							local newBrightness = v
							if v >= 0.5 then
								newBrightness = v * (1 - self.recolorShadeValue)
							else
								newBrightness = v * (1 + self.recolorShadeValue)
							end
							local r, g, b = MR_Utilities:HsbToRgb(h, s, newBrightness * 100)
							local newLineCol = LM.rgb_color:new_local()
							newLineCol.r = r
							newLineCol.g = g
							newLineCol.b = b
							newLineCol.a = lineCol.a
							shape.fMyStyle.fLineCol:SetValue(0, newLineCol)
						end
					end
				end
			end
		end
	end
end

function MR_Overlay:ValidateLayer(moho, layer, uuid)
	local testLayer = layer
	if testLayer == nil or not moho.document:IsLayerValid(testLayer) then
		testLayer = moho.document:LayerByUUID(uuid)
	end
	return testLayer
end

local MR_OverlayLayerSettingsDialog = {}

-- Modes
MR_OverlayLayerSettingsDialog.SHAPES_OVERLAY = MOHO.MSG_BASE
MR_OverlayLayerSettingsDialog.BONES_OVERLAY = MOHO.MSG_BASE + 1
MR_OverlayLayerSettingsDialog.POINTS_OVERLAY = MOHO.MSG_BASE + 2

-- Shapes
MR_OverlayLayerSettingsDialog.DRAW_STROKES = MOHO.MSG_BASE + 3
MR_OverlayLayerSettingsDialog.CHANGE_STROKE_WIDTH = MOHO.MSG_BASE + 4
MR_OverlayLayerSettingsDialog.STROKE_WIDTH = MOHO.MSG_BASE + 5
MR_OverlayLayerSettingsDialog.RECOLOR_STROKES = MOHO.MSG_BASE + 6
MR_OverlayLayerSettingsDialog.STROKE_COLOR = MOHO.MSG_BASE + 7
MR_OverlayLayerSettingsDialog.RANDOMIZE_STROKE_COLOR = MOHO.MSG_BASE + 8
MR_OverlayLayerSettingsDialog.RANDOMIZE_STROKE_COLOR_ALT = MOHO.MSG_BASE + 9
MR_OverlayLayerSettingsDialog.PRESERVE_STROKES_ALPHA = MOHO.MSG_BASE + 10
MR_OverlayLayerSettingsDialog.DRAW_FILLS = MOHO.MSG_BASE + 11
MR_OverlayLayerSettingsDialog.RECOLOR_FILL = MOHO.MSG_BASE + 12
MR_OverlayLayerSettingsDialog.FILL_COLOR = MOHO.MSG_BASE + 13
MR_OverlayLayerSettingsDialog.RANDOMIZE_FILL_COLOR = MOHO.MSG_BASE + 14
MR_OverlayLayerSettingsDialog.RANDOMIZE_FILL_COLOR_ALT = MOHO.MSG_BASE + 15
MR_OverlayLayerSettingsDialog.PRESERVE_FILL_ALPHA = MOHO.MSG_BASE + 16
MR_OverlayLayerSettingsDialog.MAKE_SHAPES_PLAIN = MOHO.MSG_BASE + 17
MR_OverlayLayerSettingsDialog.AUTO_SELECT_POINTS = MOHO.MSG_BASE + 18
MR_OverlayLayerSettingsDialog.RESET_OVERLAY = MOHO.MSG_BASE + 19

-- Bones
MR_OverlayLayerSettingsDialog.BONE_LINE_WIDTH = MOHO.MSG_BASE + 20
MR_OverlayLayerSettingsDialog.BONE_WIDTH = MOHO.MSG_BASE + 21
MR_OverlayLayerSettingsDialog.BONE_COLOR = MOHO.MSG_BASE + 22
MR_OverlayLayerSettingsDialog.RANDOMIZE_BONE_COLOR = MOHO.MSG_BASE + 23
MR_OverlayLayerSettingsDialog.RANDOMIZE_BONE_COLOR_ALT = MOHO.MSG_BASE + 24
MR_OverlayLayerSettingsDialog.DRAW_CENTER_LINE = MOHO.MSG_BASE + 25
MR_OverlayLayerSettingsDialog.PIN_BONE_RADIUS = MOHO.MSG_BASE + 26
MR_OverlayLayerSettingsDialog.DRAW_PIN_BONE_CENTER_LINES = MOHO.MSG_BASE + 27
MR_OverlayLayerSettingsDialog.SELECTED_BONES_ONLY = MOHO.MSG_BASE + 28
MR_OverlayLayerSettingsDialog.DRAW_HIDDEN_BONES = MOHO.MSG_BASE + 29
MR_OverlayLayerSettingsDialog.RESET_BONES = MOHO.MSG_BASE + 30

-- Points
MR_OverlayLayerSettingsDialog.POINT_LINE_WIDTH = MOHO.MSG_BASE + 31
MR_OverlayLayerSettingsDialog.DRAW_CROSSHAIR = MOHO.MSG_BASE + 32
MR_OverlayLayerSettingsDialog.CROSSHAIR_RADIUS = MOHO.MSG_BASE + 33
MR_OverlayLayerSettingsDialog.CROSSHAR_COLOR = MOHO.MSG_BASE + 34
MR_OverlayLayerSettingsDialog.RANDOMIZE_CROSSHAIR_COLOR = MOHO.MSG_BASE + 35
MR_OverlayLayerSettingsDialog.RANDOMIZE_CROSSHAIR_COLOR_ALT = MOHO.MSG_BASE + 36
MR_OverlayLayerSettingsDialog.DRAW_CIRCLE = MOHO.MSG_BASE + 37
MR_OverlayLayerSettingsDialog.CIRCLE_RADIUS = MOHO.MSG_BASE + 38
MR_OverlayLayerSettingsDialog.CIRCLE_COLOR = MOHO.MSG_BASE + 39
MR_OverlayLayerSettingsDialog.RANDOMIZE_CIRCLE_COLOR = MOHO.MSG_BASE + 40
MR_OverlayLayerSettingsDialog.RANDOMIZE_CIRCLE_COLOR_ALT = MOHO.MSG_BASE + 41
MR_OverlayLayerSettingsDialog.SELECTED_POINTS_ONLY = MOHO.MSG_BASE + 42
MR_OverlayLayerSettingsDialog.DRAW_HIDDEN_POINTS = MOHO.MSG_BASE + 43
MR_OverlayLayerSettingsDialog.RESET_POINTS = MOHO.MSG_BASE + 44

-- Other
MR_OverlayLayerSettingsDialog.USE_FLIP_SETTINGS = MOHO.MSG_BASE + 45
MR_OverlayLayerSettingsDialog.FLIP_OVERLAY = MOHO.MSG_BASE + 46
MR_OverlayLayerSettingsDialog.MIRROR_OVERLAY = MOHO.MSG_BASE + 47
MR_OverlayLayerSettingsDialog.MIRROR_OVERLAY_SHADE = MOHO.MSG_BASE + 48
MR_OverlayLayerSettingsDialog.LAYER_ORIGIN = MOHO.MSG_BASE + 49
MR_OverlayLayerSettingsDialog.CUSTOM_CENTER = MOHO.MSG_BASE + 50
MR_OverlayLayerSettingsDialog.SELECTION_CENTER = MOHO.MSG_BASE + 51
MR_OverlayLayerSettingsDialog.CUSTOM_CENTER_VALUE_X = MOHO.MSG_BASE + 52
MR_OverlayLayerSettingsDialog.CUSTOM_CENTER_VALUE_Y = MOHO.MSG_BASE + 53
MR_OverlayLayerSettingsDialog.SET_CUSTOM_PIVOT = MOHO.MSG_BASE + 54
MR_OverlayLayerSettingsDialog.SET_CUSTOM_PIVOT_ALT = MOHO.MSG_BASE + 55

MR_OverlayLayerSettingsDialog.USE_FRAME_SETTINGS = MOHO.MSG_BASE + 56
MR_OverlayLayerSettingsDialog.CREATE_FROM_FRAME = MOHO.MSG_BASE + 57
MR_OverlayLayerSettingsDialog.TARGET_FRAME_1 = MOHO.MSG_BASE + 58
MR_OverlayLayerSettingsDialog.TARGET_FRAME_2 = MOHO.MSG_BASE + 59
MR_OverlayLayerSettingsDialog.TARGET_FRAME_3 = MOHO.MSG_BASE + 60
MR_OverlayLayerSettingsDialog.TARGET_FRAME_4 = MOHO.MSG_BASE + 61
MR_OverlayLayerSettingsDialog.TARGET_FRAME_5 = MOHO.MSG_BASE + 62
MR_OverlayLayerSettingsDialog.TARGET_FRAME_VALUE_1 = MOHO.MSG_BASE + 63
MR_OverlayLayerSettingsDialog.TARGET_FRAME_VALUE_2 = MOHO.MSG_BASE + 64
MR_OverlayLayerSettingsDialog.TARGET_FRAME_VALUE_3 = MOHO.MSG_BASE + 65
MR_OverlayLayerSettingsDialog.TARGET_FRAME_VALUE_4 = MOHO.MSG_BASE + 66
MR_OverlayLayerSettingsDialog.TARGET_FRAME_VALUE_5 = MOHO.MSG_BASE + 67

MR_OverlayLayerSettingsDialog.GET_MAIN_SETTINGS = MOHO.MSG_BASE + 68
MR_OverlayLayerSettingsDialog.GET_MAIN_SETTINGS_ALT = MOHO.MSG_BASE + 69
MR_OverlayLayerSettingsDialog.SET_MAIN_SETTINGS = MOHO.MSG_BASE + 70
MR_OverlayLayerSettingsDialog.SET_MAIN_SETTINGS_ALT = MOHO.MSG_BASE + 71

function MR_OverlayLayerSettingsDialog:new(moho)
	local d = LM.GUI.SimpleDialog('Overlay layer '..MR_Overlay.layerIndex..' settings', MR_OverlayLayerSettingsDialog)
	local l = d:GetLayout()

	l:PushH()

		-- Shapes
		l:PushV()
			d.shapesOverlayButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_shapes_overlay', MR_Overlay:Localize('Shapes'), true, self.SHAPES_OVERLAY, false)
			l:AddChild(d.shapesOverlayButton, LM.GUI.ALIGN_CENTER, 0)

			l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

			l:AddPadding(-15)

			l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

			l:AddPadding(-10)

			d.drawStrokesCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Draw strokes'), self.DRAW_STROKES)
			l:AddChild(d.drawStrokesCheck, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-10)

			d.changeStrokeWidthCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Change stroke width'), self.CHANGE_STROKE_WIDTH)
			l:AddChild(d.changeStrokeWidthCheck, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-10)

			d.strokeWidthInput = LM.GUI.TextControl(0, '100', self.STROKE_WIDTH, LM.GUI.FIELD_FLOAT, MR_Overlay:Localize('Stroke width'))
			l:AddChild(d.strokeWidthInput, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-10)

			d.recolorStrokesCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Recolor strokes'), self.RECOLOR_STROKES)
			l:AddChild(d.recolorStrokesCheck, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-10)

			l:PushH()
				d.strokeColorSwatch = LM.GUI.ShortColorSwatch(true, self.STROKE_COLOR)
				l:AddChild(d.strokeColorSwatch, LM.GUI.ALIGN_LEFT)
				d.strokeColorSwatch:SetToolTip(MR_Overlay:Localize('Recolor Stroke Tooltip'))

				d.randomizeStrokeColorButton = LM.GUI.Button(MR_Overlay:Localize('Randomize'), self.RANDOMIZE_STROKE_COLOR)
				d.randomizeStrokeColorButton:SetAlternateMessage(self.RANDOMIZE_STROKE_COLOR_ALT)
				l:AddChild(d.randomizeStrokeColorButton, LM.GUI.ALIGN_FILL, 0)
			l:Pop()

			l:AddPadding(-10)

			d.preserveStrokesAlphaCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Preserve strokes alpha'), self.PRESERVE_STROKES_ALPHA)
			l:AddChild(d.preserveStrokesAlphaCheck, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-10)

			l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

			l:AddPadding(-10)

			d.drawFillsCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Draw fills'), self.DRAW_FILLS)
			l:AddChild(d.drawFillsCheck, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-10)

			d.recolorFillCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Recolor fill'), self.RECOLOR_FILL)
			l:AddChild(d.recolorFillCheck, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-10)

			l:PushH()
				d.fillColorSwatch = LM.GUI.ShortColorSwatch(true, self.FILL_COLOR)
				l:AddChild(d.fillColorSwatch, LM.GUI.ALIGN_LEFT)
				d.fillColorSwatch:SetToolTip(MR_Overlay:Localize('Recolor Fill Tooltip'))

				d.randomizeFillColorButton = LM.GUI.Button(MR_Overlay:Localize('Randomize'), self.RANDOMIZE_FILL_COLOR)
				d.randomizeFillColorButton:SetAlternateMessage(self.RANDOMIZE_FILL_COLOR_ALT)
				l:AddChild(d.randomizeFillColorButton, LM.GUI.ALIGN_FILL, 0)
			l:Pop()

			l:AddPadding(-10)

			d.preserveFillAlphaCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Preserve fills alpha'), self.PRESERVE_FILL_ALPHA)
			l:AddChild(d.preserveFillAlphaCheck, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-10)

			l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

			l:AddPadding(-10)

			d.makeShapesPlainCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Make shapes plain'), self.MAKE_SHAPES_PLAIN)
			l:AddChild(d.makeShapesPlainCheck, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-10)

			l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

			l:AddPadding(-10)

			d.autoSelectShapesPointsCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Auto Select Points'), self.AUTO_SELECT_POINTS)
			l:AddChild(d.autoSelectShapesPointsCheck, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-10)

			d.resetOverlayButton = LM.GUI.ShortButton(MR_Overlay:Localize('Reset'), self.RESET_OVERLAY)
			l:AddChild(d.resetOverlayButton, LM.GUI.ALIGN_FILL, 0)

			l:AddPadding(-10)
		l:Pop()

		l:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL)

		-- Bones
		l:PushV()
			d.bonesOverlayButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_bone', MR_Overlay:Localize('Shapes'), true, self.BONES_OVERLAY, false)
			l:AddChild(d.bonesOverlayButton, LM.GUI.ALIGN_CENTER, 0)

			l:AddPadding(-10)

			l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

			l:AddPadding(-15)

			l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

			l:AddPadding(-10)

			d.bonesLineWidthInput = LM.GUI.TextControl(0, '100', self.BONE_LINE_WIDTH, LM.GUI.FIELD_FLOAT, MR_Overlay:Localize('Line width'))
			d.bonesLineWidthInput:SetWheelInc(0.1)
			l:AddChild(d.bonesLineWidthInput, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-10)

			l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

			l:AddPadding(-10)

			d.bonesWidthInput = LM.GUI.TextControl(0, '100', self.BONE_WIDTH, LM.GUI.FIELD_FLOAT, MR_Overlay:Localize('Bones width'))
			d.bonesWidthInput:SetWheelInc(0.1)
			l:AddChild(d.bonesWidthInput, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-10)

			l:PushH()
				d.boneColorSwatch = LM.GUI.ShortColorSwatch(true, self.BONE_COLOR)
				l:AddChild(d.boneColorSwatch, LM.GUI.ALIGN_LEFT)

				d.randomizeBoneColorButton = LM.GUI.Button(MR_Overlay:Localize('Randomize'), self.RANDOMIZE_BONE_COLOR)
				d.randomizeBoneColorButton:SetAlternateMessage(self.RANDOMIZE_BONE_COLOR_ALT)
				l:AddChild(d.randomizeBoneColorButton, LM.GUI.ALIGN_FILL, 0)
			l:Pop()

			l:AddPadding(-10)

			d.drawCenterLineCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Draw center line'), self.DRAW_CENTER_LINE)
			l:AddChild(d.drawCenterLineCheck, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-10)

			l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

			l:AddPadding(-10)

			d.pinBoneRadiusInput = LM.GUI.TextControl(0, '100', self.PIN_BONE_RADIUS, LM.GUI.FIELD_FLOAT, MR_Overlay:Localize('Pin bone radius'))
			d.pinBoneRadiusInput:SetWheelInc(0.1)
			l:AddChild(d.pinBoneRadiusInput, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-10)

			d.drawPinBoneCenterLinesCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Draw pin bone center lines'), self.DRAW_PIN_BONE_CENTER_LINES)
			l:AddChild(d.drawPinBoneCenterLinesCheck, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-10)

			l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

			l:AddPadding(-10)

			d.selectedBonesOnlyCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Selected bones only'), self.SELECTED_BONES_ONLY)
			l:AddChild(d.selectedBonesOnlyCheck, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-10)

			d.drawHiddenBonesCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Draw hidden bones'), self.DRAW_HIDDEN_BONES)
			l:AddChild(d.drawHiddenBonesCheck, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(107)

			d.resetBonesButton = LM.GUI.ShortButton(MR_Overlay:Localize('Reset'), self.RESET_BONES)
			l:AddChild(d.resetBonesButton, LM.GUI.ALIGN_FILL, 0)

			l:AddPadding(-10)
		l:Pop()

		l:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL)

		-- Points
		l:PushV()
			d.pointsOverlayButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_points_overlay', MR_Overlay:Localize('Points'), true, self.POINTS_OVERLAY, false)
			l:AddChild(d.pointsOverlayButton, LM.GUI.ALIGN_CENTER, 0)

			l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

			l:AddPadding(-15)

			l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

			l:AddPadding(-10)

			d.pointLineWidthInput = LM.GUI.TextControl(0, '100', self.POINT_LINE_WIDTH, LM.GUI.FIELD_FLOAT, MR_Overlay:Localize('Line width'))
			l:AddChild(d.pointLineWidthInput, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-10)

			l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

			l:AddPadding(-10)

			d.drawCrosshairCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Draw crosshair'), self.DRAW_CROSSHAIR)
			l:AddChild(d.drawCrosshairCheck, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-10)

			d.crosshairRadiusInput = LM.GUI.TextControl(0, '100', self.CROSSHAIR_RADIUS, LM.GUI.FIELD_FLOAT, MR_Overlay:Localize('Crosshair radius'))
			d.crosshairRadiusInput:SetWheelInc(0.1)
			l:AddChild(d.crosshairRadiusInput, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-10)

			l:PushH()
				d.pointCrosshairColorSwatch = LM.GUI.ShortColorSwatch(true, self.CROSSHAR_COLOR)
				l:AddChild(d.pointCrosshairColorSwatch, LM.GUI.ALIGN_LEFT)

				d.randomizeCrosshairColorButton = LM.GUI.Button(MR_Overlay:Localize('Randomize'), self.RANDOMIZE_CROSSHAIR_COLOR)
				d.randomizeCrosshairColorButton:SetAlternateMessage(self.RANDOMIZE_CROSSHAIR_COLOR_ALT)
				l:AddChild(d.randomizeCrosshairColorButton, LM.GUI.ALIGN_FILL, 0)
			l:Pop()

			l:AddPadding(-10)

			l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

			l:AddPadding(-10)

			d.drawCircleCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Draw circle'), self.DRAW_CIRCLE)
			l:AddChild(d.drawCircleCheck, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-10)

			d.circleRadiusInput = LM.GUI.TextControl(0, '100', self.CIRCLE_RADIUS, LM.GUI.FIELD_FLOAT, MR_Overlay:Localize('Circle radius'))
			d.circleRadiusInput:SetWheelInc(0.1)
			l:AddChild(d.circleRadiusInput, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-10)

			l:PushH()
				d.pointCircleColorSwatch = LM.GUI.ShortColorSwatch(true, self.CIRCLE_COLOR)
				l:AddChild(d.pointCircleColorSwatch, LM.GUI.ALIGN_LEFT)

				d.randomizeCircleColorButton = LM.GUI.Button(MR_Overlay:Localize('Randomize'), self.RANDOMIZE_CIRCLE_COLOR)
				d.randomizeCircleColorButton:SetAlternateMessage(self.RANDOMIZE_CIRCLE_COLOR_ALT)
				l:AddChild(d.randomizeCircleColorButton, LM.GUI.ALIGN_FILL, 0)
			l:Pop()

			l:AddPadding(-10)

			l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

			l:AddPadding(-10)

			d.selectedPointsOnlyCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Selected points only'), self.SELECTED_POINTS_ONLY)
			l:AddChild(d.selectedPointsOnlyCheck, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(-10)

			d.drawHiddenPointsCheck = LM.GUI.CheckBox(MR_Overlay:Localize('Draw hidden points'), self.DRAW_HIDDEN_POINTS)
			l:AddChild(d.drawHiddenPointsCheck, LM.GUI.ALIGN_LEFT, 0)

			l:AddPadding(74)

			d.resetPointsButton = LM.GUI.ShortButton(MR_Overlay:Localize('Reset'), self.RESET_POINTS)
			l:AddChild(d.resetPointsButton, LM.GUI.ALIGN_FILL, 0)

			l:AddPadding(-10)
		l:Pop()
	l:Pop()

	l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

	-- Other
	l:PushH()
		d.useFlipSettingsCheck = LM.GUI.CheckBox('', self.USE_FLIP_SETTINGS)
		d.useFlipSettingsCheck:SetToolTip (MR_Overlay:Localize('Use flip settings'))
		l:AddChild(d.useFlipSettingsCheck, LM.GUI.ALIGN_LEFT, 0)

		l:AddPadding(-10)

		d.flipOverlayCheck = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_flip', MR_Overlay:Localize('Flip overlay'), true, self.FLIP_OVERLAY, false)
		l:AddChild(d.flipOverlayCheck, LM.GUI.ALIGN_LEFT, 0)

		l:AddPadding(-10)

		d.mirrorOverlayCheck = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_mirror', MR_Overlay:Localize('Mirror overlay'), true, self.MIRROR_OVERLAY, false)
		l:AddChild(d.mirrorOverlayCheck, LM.GUI.ALIGN_LEFT, 0)

		l:AddPadding(-10)

		d.mirrorOverlayShadeCheck = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_mirror_shade', MR_Overlay:Localize('Mirror overlay with shade'), true, self.MIRROR_OVERLAY_SHADE, false)
		l:AddChild(d.mirrorOverlayShadeCheck, LM.GUI.ALIGN_LEFT, 0)

		d.layer_origin_RadioButton = LM.GUI.RadioButton('Layer', self.LAYER_ORIGIN)
		l:AddChild(d.layer_origin_RadioButton, LM.GUI.ALIGN_LEFT, 0)

		d.selection_center_RadioButton = LM.GUI.RadioButton('Selection', self.SELECTION_CENTER)
		l:AddChild(d.selection_center_RadioButton, LM.GUI.ALIGN_LEFT, 0)

		d.custom_center_RadioButton = LM.GUI.RadioButton('Custom', self.CUSTOM_CENTER) 
		l:AddChild(d.custom_center_RadioButton, LM.GUI.ALIGN_LEFT, 0)

		d.setCustomPivotButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_set_pivot', MR_Overlay:Localize('Set custom pivot'), false, self.SET_CUSTOM_PIVOT, false)
		d.setCustomPivotButton:SetAlternateMessage(self.SET_CUSTOM_PIVOT_ALT)
		l:AddChild(d.setCustomPivotButton, LM.GUI.ALIGN_LEFT, 0)

		d.custom_center_value_x_Input = LM.GUI.TextControl(0, '100000', self.CUSTOM_CENTER_VALUE_X, LM.GUI.FIELD_FLOAT, 'X:')
		l:AddChild(d.custom_center_value_x_Input, LM.GUI.ALIGN_LEFT, 0)

		l:AddPadding(-10)

		d.custom_center_value_y_Input = LM.GUI.TextControl(0, '100000', self.CUSTOM_CENTER_VALUE_Y, LM.GUI.FIELD_FLOAT, 'Y:')
		l:AddChild(d.custom_center_value_y_Input, LM.GUI.ALIGN_LEFT, 0)
	l:Pop()

	l:PushH()
		local inputWidth = 56

		d.useFrameSettingsCheck = LM.GUI.CheckBox('', self.USE_FRAME_SETTINGS)
		d.useFrameSettingsCheck:SetToolTip(MR_Overlay:Localize('Use frame settings'))
		l:AddChild(d.useFrameSettingsCheck, LM.GUI.ALIGN_LEFT, 0)

		l:AddPadding(-10)

		d.createOverlayFromFrameCheck = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_create_from_frame', MR_Overlay:Localize('Create from frame'), true, self.CREATE_FROM_FRAME, false)
		l:AddChild(d.createOverlayFromFrameCheck, LM.GUI.ALIGN_LEFT, 0)

		d.frame_1_RadioButton = LM.GUI.RadioButton('', self.FRAME_1)
		l:AddChild(d.frame_1_RadioButton, LM.GUI.ALIGN_LEFT, 0)

		l:AddPadding(-16)

		d.frame_1_valueInput = LM.GUI.TextControl(inputWidth, '', self.TARGET_FRAME_VALUE_1, LM.GUI.FIELD_INT, '')
		l:AddChild(d.frame_1_valueInput, LM.GUI.ALIGN_LEFT, 0)
		
		d.frame_2_RadioButton = LM.GUI.RadioButton('', self.FRAME_2)
		l:AddChild(d.frame_2_RadioButton, LM.GUI.ALIGN_LEFT, 0)

		l:AddPadding(-16)

		d.frame_2_valueInput = LM.GUI.TextControl(inputWidth, '', self.TARGET_FRAME_VALUE_2, LM.GUI.FIELD_INT, '')
		l:AddChild(d.frame_2_valueInput, LM.GUI.ALIGN_LEFT, 0)

		d.frame_3_RadioButton = LM.GUI.RadioButton('', self.FRAME_3)
		l:AddChild(d.frame_3_RadioButton, LM.GUI.ALIGN_LEFT, 0)

		l:AddPadding(-16)

		d.frame_3_valueInput = LM.GUI.TextControl(inputWidth, '', self.TARGET_FRAME_VALUE_3, LM.GUI.FIELD_INT, '')
		l:AddChild(d.frame_3_valueInput, LM.GUI.ALIGN_LEFT, 0)

		d.frame_4_RadioButton = LM.GUI.RadioButton('+', self.FRAME_4)
		l:AddChild(d.frame_4_RadioButton, LM.GUI.ALIGN_LEFT, 0)

		l:AddPadding(-15)

		d.frame_4_valueInput = LM.GUI.TextControl(inputWidth, '', self.TARGET_FRAME_VALUE_4, LM.GUI.FIELD_INT, '')
		l:AddChild(d.frame_4_valueInput, LM.GUI.ALIGN_LEFT, 0)

		d.frame_5_RadioButton = LM.GUI.RadioButton('-', self.FRAME_5)
		l:AddChild(d.frame_5_RadioButton, LM.GUI.ALIGN_LEFT, 0)

		l:AddPadding(-15)

		d.frame_5_valueInput = LM.GUI.TextControl(inputWidth, '', self.TARGET_FRAME_VALUE_5, LM.GUI.FIELD_INT, '')
		l:AddChild(d.frame_5_valueInput, LM.GUI.ALIGN_LEFT, 0)
	l:Pop()

	l:AddChild(LM.GUI.Divider(false), LM.GUI.ALIGN_FILL)

	l:PushH()
		d.getMainSettingsSettingsButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_get_main_settings', MR_Overlay:Localize('Set main settings to layer'), false, self.GET_MAIN_SETTINGS, false)
		d.getMainSettingsSettingsButton:SetAlternateMessage(self.GET_MAIN_SETTINGS_ALT)
		l:AddChild(d.getMainSettingsSettingsButton, LM.GUI.ALIGN_LEFT, 0)

		d.setMainSettingsSettingsButton = LM.GUI.ImageButton('ScriptResources/mr_overlay/mr_set_main_settings', MR_Overlay:Localize('Set layer settings as main'), false, self.SET_MAIN_SETTINGS, false)
		d.setMainSettingsSettingsButton:SetAlternateMessage(self.SET_MAIN_SETTINGS_ALT)
		l:AddChild(d.setMainSettingsSettingsButton, LM.GUI.ALIGN_LEFT, 0)
	l:Pop()

	return d
end

function MR_OverlayLayerSettingsDialog:UpdateWidgets()
	local helper = MOHO.ScriptInterfaceHelper:new_local()
	local moho = helper:MohoObject()
	self.overlayGroupLayer = MR_Overlay:CheckExistOverlayLayer(moho)
	helper:delete()
	local layerIndex = MR_Overlay.layerIndex
	if self.overlayGroupLayer then
		local scriptData = self.overlayGroupLayer:ScriptData()
		-- Mode
		local mode = scriptData:GetString('MR Overlay Setup Mode '..layerIndex)
		if mode == 'Shapes' then
			self.shapesOverlayButton:SetValue(true)
			self.bonesOverlayButton:SetValue(false)
			self.pointsOverlayButton:SetValue(false)
		elseif mode == 'Bones' then
			self.shapesOverlayButton:SetValue(false)
			self.bonesOverlayButton:SetValue(true)
			self.pointsOverlayButton:SetValue(false)
		elseif mode == 'Points' then
			self.shapesOverlayButton:SetValue(false)
			self.bonesOverlayButton:SetValue(false)
			self.pointsOverlayButton:SetValue(true)
		end

		-- Shapes
		local drawStrokes = scriptData:GetBool('MR Overlay Setup drawStrokes '..layerIndex)
		self.drawStrokesCheck:SetValue(drawStrokes)
		local changeStrokeWidth = scriptData:GetBool('MR Overlay Setup changeStrokeWidth '..layerIndex)
		self.changeStrokeWidthCheck:SetValue(changeStrokeWidth)

		self.changeStrokeWidthCheck:Enable(drawStrokes)
		self.strokeWidthInput:Enable(changeStrokeWidth and drawStrokes)
		self.recolorStrokesCheck:Enable(drawStrokes)

		self.strokeWidthInput:SetValue(scriptData:GetFloat('MR Overlay Setup strokeWidth '..layerIndex))

		local recolorStroke = scriptData:GetBool('MR Overlay Setup recolorStroke '..layerIndex)
		self.recolorStrokesCheck:SetValue(recolorStroke)

		local r, g, b, a = MR_Utilities:HexToRgba(scriptData:GetString('MR Overlay Setup strokeColor '..layerIndex))
		local strokeColor = LM.rgb_color:new_local()
		strokeColor.r = r
		strokeColor.g = g
		strokeColor.b = b
		strokeColor.a = a

		self.strokeColorSwatch:SetValue(strokeColor)
		self.strokeColorSwatch:Enable(recolorStroke and drawStrokes)

		self.randomizeStrokeColorButton:Enable(recolorStroke and drawStrokes)

		self.preserveStrokesAlphaCheck:SetValue(scriptData:GetBool('MR Overlay Setup preserveStrokeAlpha '..layerIndex))
		self.preserveStrokesAlphaCheck:Enable(recolorStroke and drawStrokes)

		local drawFills = scriptData:GetBool('MR Overlay Setup drawFills '..layerIndex)
		self.drawFillsCheck:SetValue(drawFills)

		local recolorFill = scriptData:GetBool('MR Overlay Setup recolorFill '..layerIndex)
		self.recolorFillCheck:SetValue(recolorFill)
		self.recolorFillCheck:Enable(drawFills)

		self.randomizeFillColorButton:Enable(recolorFill and drawFills)

		local r, g, b, a = MR_Utilities:HexToRgba(scriptData:GetString('MR Overlay Setup fillColor '..layerIndex))
		local fillColor = LM.rgb_color:new_local()
		fillColor.r = r
		fillColor.g = g
		fillColor.b = b
		fillColor.a = a

		self.fillColorSwatch:SetValue(fillColor)
		self.fillColorSwatch:Enable(recolorFill and drawFills)

		self.preserveFillAlphaCheck:SetValue(scriptData:GetBool('MR Overlay Setup preserveFillAlpha '..layerIndex))
		self.preserveFillAlphaCheck:Enable(recolorFill and drawFills)

		self.makeShapesPlainCheck:SetValue(scriptData:GetBool('MR Overlay Setup makeShapesPlain '..layerIndex))
		self.autoSelectShapesPointsCheck:SetValue(scriptData:GetBool('MR Overlay Setup autoSelectShapesPoints '..layerIndex))

		-- Bones
		self.bonesLineWidthInput:SetValue(scriptData:GetFloat('MR Overlay Setup bonesLineWidth '..layerIndex))
		self.bonesWidthInput:SetValue(scriptData:GetFloat('MR Overlay Setup bonesWidth '..layerIndex))

		local r, g, b, a = MR_Utilities:HexToRgba(scriptData:GetString('MR Overlay Setup boneColor '..layerIndex))
		local boneColor = LM.rgb_color:new_local()
		boneColor.r = r
		boneColor.g = g
		boneColor.b = b
		boneColor.a = a

		self.boneColorSwatch:SetValue(boneColor)
		self.drawCenterLineCheck:SetValue(scriptData:GetBool('MR Overlay Setup drawCenterLine '..layerIndex))
		self.pinBoneRadiusInput:SetValue(scriptData:GetFloat('MR Overlay Setup pinBoneRadius '..layerIndex))
		self.drawPinBoneCenterLinesCheck:SetValue(scriptData:GetBool('MR Overlay Setup drawPinBoneCenterLines '..layerIndex))

		local selectedBonesOnly = scriptData:GetBool('MR Overlay Setup selectedBonesOnly '..layerIndex)
		self.selectedBonesOnlyCheck:SetValue(selectedBonesOnly)
		self.drawHiddenBonesCheck:SetValue(scriptData:GetBool('MR Overlay Setup drawHiddenBones '..layerIndex))
		self.drawHiddenBonesCheck:Enable(not selectedBonesOnly)

		-- Points
		self.pointLineWidthInput:SetValue(scriptData:GetFloat('MR Overlay Setup pointLineWidth '..layerIndex))

		local drawCrosshair = scriptData:GetBool('MR Overlay Setup drawCrosshair '..layerIndex)
		self.drawCrosshairCheck:SetValue(drawCrosshair)
		self.crosshairRadiusInput:SetValue(scriptData:GetFloat('MR Overlay Setup crosshairRadius '..layerIndex))
		self.crosshairRadiusInput:Enable(drawCrosshair)
		self.randomizeCrosshairColorButton:Enable(drawCrosshair)

		local r, g, b, a = MR_Utilities:HexToRgba(scriptData:GetString('MR Overlay Setup pointCrosshairColor '..layerIndex))
		local pointCrosshairColor = LM.rgb_color:new_local()
		pointCrosshairColor.r = r
		pointCrosshairColor.g = g
		pointCrosshairColor.b = b
		pointCrosshairColor.a = a

		self.pointCrosshairColorSwatch:SetValue(pointCrosshairColor)
		self.pointCrosshairColorSwatch:Enable(drawCrosshair)

		local drawCircle = scriptData:GetBool('MR Overlay Setup drawCircle '..layerIndex)
		self.drawCircleCheck:SetValue(drawCircle)
		self.circleRadiusInput:SetValue(scriptData:GetFloat('MR Overlay Setup circleRadius '..layerIndex))
		self.circleRadiusInput:Enable(drawCircle)
		self.randomizeCircleColorButton:Enable(drawCircle)

		local r, g, b, a = MR_Utilities:HexToRgba(scriptData:GetString('MR Overlay Setup pointCircleColor '..layerIndex))
		local pointCircleColor = LM.rgb_color:new_local()
		pointCircleColor.r = r
		pointCircleColor.g = g
		pointCircleColor.b = b
		pointCircleColor.a = a

		self.pointCircleColorSwatch:SetValue(pointCircleColor)
		self.pointCircleColorSwatch:Enable(drawCircle)

		self.selectedPointsOnlyCheck:SetValue(scriptData:GetBool('MR Overlay Setup selectedPointsOnly '..layerIndex))
		self.drawHiddenPointsCheck:SetValue(scriptData:GetBool('MR Overlay Setup drawHiddenPoints '..layerIndex))
		self.drawHiddenPointsCheck:Enable(not selectedPointsOnly)

		-- Other
		self.useFlipSettingsCheck:SetValue(scriptData:GetBool('MR Overlay Setup useFlipSettings '..layerIndex))
		local flipOverlay = scriptData:GetBool('MR Overlay Setup flipOverlay '..layerIndex)
		local mirrorFlip = scriptData:GetBool('MR Overlay Setup mirrorFlip '..layerIndex)
		self.flipOverlayCheck:SetValue(flipOverlay)
		self.mirrorOverlayCheck:SetValue(mirrorFlip)
		self.mirrorOverlayCheck:Enable(flipOverlay)

		self.mirrorOverlayShadeCheck:SetValue(scriptData:GetBool('MR Overlay Setup mirrorOverlayShade '..layerIndex))
		self.mirrorOverlayShadeCheck:Enable(flipOverlay and mirrorFlip)

		self.custom_center_RadioButton:SetValue(scriptData:GetBool('MR Overlay Setup customCenter '..layerIndex))
		self.layer_origin_RadioButton:SetValue(scriptData:GetBool('MR Overlay Setup layerOriginCenter '..layerIndex))
		self.selection_center_RadioButton:SetValue(scriptData:GetBool('MR Overlay Setup selectionCenter '..layerIndex))

		self.custom_center_value_x_Input:SetValue(scriptData:GetFloat('MR Overlay Setup customCenterValueX '..layerIndex))
		self.custom_center_value_y_Input:SetValue(scriptData:GetFloat('MR Overlay Setup customCenterValueY '..layerIndex))

		self.useFrameSettingsCheck:SetValue(scriptData:GetBool('MR Overlay Setup useFrameSettings '..layerIndex))
		self.createOverlayFromFrameCheck:SetValue(scriptData:GetBool('MR Overlay Setup createFromFrame '..layerIndex))

		self.frame_1_RadioButton:SetValue(scriptData:GetBool('MR Overlay Setup useFrame1 '..layerIndex))
		self.frame_2_RadioButton:SetValue(scriptData:GetBool('MR Overlay Setup useFrame2 '..layerIndex))
		self.frame_3_RadioButton:SetValue(scriptData:GetBool('MR Overlay Setup useFrame3 '..layerIndex))
		self.frame_4_RadioButton:SetValue(scriptData:GetBool('MR Overlay Setup useFrame4 '..layerIndex))
		self.frame_5_RadioButton:SetValue(scriptData:GetBool('MR Overlay Setup useFrame5 '..layerIndex))

		self.frame_1_valueInput:SetValue(scriptData:GetInt('MR Overlay Setup frameVal1 '..layerIndex))
		self.frame_2_valueInput:SetValue(scriptData:GetInt('MR Overlay Setup frameVal2 '..layerIndex))
		self.frame_3_valueInput:SetValue(scriptData:GetInt('MR Overlay Setup frameVal3 '..layerIndex))
		self.frame_4_valueInput:SetValue(scriptData:GetInt('MR Overlay Setup frameVal4 '..layerIndex))
		self.frame_5_valueInput:SetValue(scriptData:GetInt('MR Overlay Setup frameVal5 '..layerIndex))
	end
end

function MR_OverlayLayerSettingsDialog:OnOK(moho)
	if self.overlayGroupLayer then
		local scriptData = self.overlayGroupLayer:ScriptData()
		local layerIndex = MR_Overlay.layerIndex

		-- Mode
		if self.shapesOverlayButton:Value() then
			scriptData:Set('MR Overlay Setup Mode '..layerIndex, 'Shapes')
		elseif self.bonesOverlayButton:Value() then
			scriptData:Set('MR Overlay Setup Mode '..layerIndex, 'Bones')
		elseif self.pointsOverlayButton:Value() then
			scriptData:Set('MR Overlay Setup Mode '..layerIndex, 'Points')
		end

		-- Shapes
		scriptData:Set('MR Overlay Setup drawStrokes '..layerIndex, self.drawStrokesCheck:Value())
		scriptData:Set('MR Overlay Setup changeStrokeWidth '..layerIndex, self.changeStrokeWidthCheck:Value())
		scriptData:Set('MR Overlay Setup strokeWidth '..layerIndex, self.strokeWidthInput:Value())
		scriptData:Set('MR Overlay Setup recolorStroke '..layerIndex, self.recolorStrokesCheck:Value())

		local colorSwatchValue = self.strokeColorSwatch:Value()
		local strokeColor = MR_Utilities:RgbaToHex(colorSwatchValue.r, colorSwatchValue.g, colorSwatchValue.b, colorSwatchValue.a)

		scriptData:Set('MR Overlay Setup strokeColor '..layerIndex, strokeColor)
		scriptData:Set('MR Overlay Setup preserveStrokeAlpha '..layerIndex, self.preserveStrokesAlphaCheck:Value())
		scriptData:Set('MR Overlay Setup drawFills '..layerIndex, self.drawFillsCheck:Value())
		scriptData:Set('MR Overlay Setup recolorFill '..layerIndex, self.recolorFillCheck:Value())

		local colorSwatchValue = self.fillColorSwatch:Value()
		local fillColor = MR_Utilities:RgbaToHex(colorSwatchValue.r, colorSwatchValue.g, colorSwatchValue.b, colorSwatchValue.a)
		scriptData:Set('MR Overlay Setup fillColor '..layerIndex, fillColor)
		scriptData:Set('MR Overlay Setup preserveFillAlpha '..layerIndex, self.preserveFillAlphaCheck:Value())
		scriptData:Set('MR Overlay Setup makeShapesPlain '..layerIndex, self.makeShapesPlainCheck:Value())
		scriptData:Set('MR Overlay Setup autoSelectShapesPoints '..layerIndex, self.autoSelectShapesPointsCheck:Value())

		-- Bones
		scriptData:Set('MR Overlay Setup bonesLineWidth '..layerIndex, self.bonesLineWidthInput:Value())
		scriptData:Set('MR Overlay Setup bonesWidth '..layerIndex, self.bonesWidthInput:Value())

		local colorSwatchValue = self.boneColorSwatch:Value()
		local boneColor = MR_Utilities:RgbaToHex(colorSwatchValue.r, colorSwatchValue.g, colorSwatchValue.b, colorSwatchValue.a)
		scriptData:Set('MR Overlay Setup boneColor '..layerIndex, boneColor)

		scriptData:Set('MR Overlay Setup drawCenterLine '..layerIndex, self.drawCenterLineCheck:Value())
		scriptData:Set('MR Overlay Setup pinBoneRadius '..layerIndex, self.pinBoneRadiusInput:Value())
		scriptData:Set('MR Overlay Setup drawPinBoneCenterLines '..layerIndex, self.drawPinBoneCenterLinesCheck:Value())
		scriptData:Set('MR Overlay Setup selectedBonesOnly '..layerIndex, self.selectedBonesOnlyCheck:Value())
		scriptData:Set('MR Overlay Setup drawHiddenBones '..layerIndex, self.drawHiddenBonesCheck:Value())

		-- Points
		scriptData:Set('MR Overlay Setup pointLineWidth '..layerIndex, self.pointLineWidthInput:Value())
		scriptData:Set('MR Overlay Setup drawCrosshair '..layerIndex, self.drawCrosshairCheck:Value())
		scriptData:Set('MR Overlay Setup crosshairRadius '..layerIndex, self.crosshairRadiusInput:Value())

		local colorSwatchValue = self.pointCrosshairColorSwatch:Value()
		local pointCrosshairColor = MR_Utilities:RgbaToHex(colorSwatchValue.r, colorSwatchValue.g, colorSwatchValue.b, colorSwatchValue.a)
		scriptData:Set('MR Overlay Setup pointCrosshairColor '..layerIndex, pointCrosshairColor)

		scriptData:Set('MR Overlay Setup drawCircle '..layerIndex, self.drawCircleCheck:Value())
		scriptData:Set('MR Overlay Setup circleRadius '..layerIndex, self.circleRadiusInput:Value())

		local colorSwatchValue = self.pointCircleColorSwatch:Value()
		local pointCircleColor = MR_Utilities:RgbaToHex(colorSwatchValue.r, colorSwatchValue.g, colorSwatchValue.b, colorSwatchValue.a)
		scriptData:Set('MR Overlay Setup pointCircleColor '..layerIndex, pointCircleColor)

		scriptData:Set('MR Overlay Setup selectedPointsOnly '..layerIndex, self.selectedPointsOnlyCheck:Value())
		scriptData:Set('MR Overlay Setup drawHiddenPoints '..layerIndex, self.drawHiddenPointsCheck:Value())

		-- Other
		scriptData:Set('MR Overlay Setup useFlipSettings '..layerIndex, self.useFlipSettingsCheck:Value())
		scriptData:Set('MR Overlay Setup flipOverlay '..layerIndex, self.flipOverlayCheck:Value())
		scriptData:Set('MR Overlay Setup mirrorFlip '..layerIndex, self.mirrorOverlayCheck:Value())
		scriptData:Set('MR Overlay Setup mirrorOverlayShade '..layerIndex, self.mirrorOverlayShadeCheck:Value())

		scriptData:Set('MR Overlay Setup customCenter '..layerIndex, self.custom_center_RadioButton:Value())
		scriptData:Set('MR Overlay Setup layerOriginCenter '..layerIndex, self.layer_origin_RadioButton:Value())
		scriptData:Set('MR Overlay Setup selectionCenter '..layerIndex, self.selection_center_RadioButton:Value())

		scriptData:Set('MR Overlay Setup customCenterValueX '..layerIndex, self.custom_center_value_x_Input:Value())
		scriptData:Set('MR Overlay Setup customCenterValueY '..layerIndex, self.custom_center_value_y_Input:Value())

		scriptData:Set('MR Overlay Setup useFrameSettings '..layerIndex, self.useFrameSettingsCheck:Value())
		scriptData:Set('MR Overlay Setup createFromFrame '..layerIndex, self.createOverlayFromFrameCheck:Value())

		scriptData:Set('MR Overlay Setup useFrame1 '..layerIndex, self.frame_1_RadioButton:Value())
		scriptData:Set('MR Overlay Setup useFrame2 '..layerIndex, self.frame_2_RadioButton:Value())
		scriptData:Set('MR Overlay Setup useFrame3 '..layerIndex, self.frame_3_RadioButton:Value())
		scriptData:Set('MR Overlay Setup useFrame4 '..layerIndex, self.frame_4_RadioButton:Value())
		scriptData:Set('MR Overlay Setup useFrame5 '..layerIndex, self.frame_5_RadioButton:Value())

		scriptData:Set('MR Overlay Setup frameVal1 '..layerIndex, self.frame_1_valueInput:Value())
		scriptData:Set('MR Overlay Setup frameVal2 '..layerIndex, self.frame_2_valueInput:Value())
		scriptData:Set('MR Overlay Setup frameVal3 '..layerIndex, self.frame_3_valueInput:Value())
		scriptData:Set('MR Overlay Setup frameVal4 '..layerIndex, self.frame_4_valueInput:Value())
		scriptData:Set('MR Overlay Setup frameVal5 '..layerIndex, self.frame_5_valueInput:Value())
	end
end

function MR_OverlayLayerSettingsDialog:HandleMessage(msg)
	if msg == self.SHAPES_OVERLAY then
		self.shapesOverlayButton:SetValue(true)
		self.bonesOverlayButton:SetValue(false)
		self.pointsOverlayButton:SetValue(false)
	elseif msg == self.BONES_OVERLAY then
		self.shapesOverlayButton:SetValue(false)
		self.bonesOverlayButton:SetValue(true)
		self.pointsOverlayButton:SetValue(false)
	elseif msg == self.POINTS_OVERLAY then
		self.shapesOverlayButton:SetValue(false)
		self.bonesOverlayButton:SetValue(false)
		self.pointsOverlayButton:SetValue(true)
	elseif msg == self.DRAW_STROKES then
		local drawStrokes = self.drawStrokesCheck:Value()
		local drawFills = self.drawFillsCheck:Value()
		if not drawFills then
			drawStrokes = true
			self.drawStrokesCheck:SetValue(true)
		end
		local changeStrokeWidth = self.changeStrokeWidthCheck:Value()
		local recolorStroke = self.recolorStrokesCheck:Value()

		self.changeStrokeWidthCheck:Enable(drawStrokes)
		self.strokeWidthInput:Enable(changeStrokeWidth and drawStrokes)
		self.recolorStrokesCheck:Enable(drawStrokes)
		self.strokeColorSwatch:Enable(recolorStroke and drawStrokes)
		self.preserveStrokesAlphaCheck:Enable(recolorStroke and drawStrokes)
		self.randomizeStrokeColorButton:Enable(recolorStroke and drawStrokes)
	elseif msg == self.CHANGE_STROKE_WIDTH then
		local changeStrokeWidth = self.changeStrokeWidthCheck:Value()
		self.strokeWidthInput:Enable(changeStrokeWidth)
	elseif msg == self.STROKE_WIDTH then
		local strokeWidth = LM.Clamp(self.strokeWidthInput:FloatValue(), 0.25, 256)
		self.strokeWidthInput:SetValue(strokeWidth)
	elseif msg == self.RECOLOR_STROKES then
		local recolorStroke = self.recolorStrokesCheck:Value()
		self.preserveStrokesAlphaCheck:Enable(recolorStroke)
		self.strokeColorSwatch:Enable(recolorStroke)
		self.randomizeStrokeColorButton:Enable(recolorStroke)
	elseif msg == self.STROKE_COLOR then
	elseif msg == self.RANDOMIZE_STROKE_COLOR then
		local oldColor = self.strokeColorSwatch:Value()
		local newColor = MR_Utilities:GenerateDistinctColor(oldColor)
		newColor.a = oldColor.a
		self.strokeColorSwatch:SetValue(newColor)
	elseif msg == self.RANDOMIZE_STROKE_COLOR_ALT then
		local oldColor = self.strokeColorSwatch:Value()
		local newColor = MR_Utilities:RandomizeBrightness(oldColor)
		newColor.a = oldColor.a
		self.strokeColorSwatch:SetValue(newColor)
	elseif msg == self.DRAW_FILLS then
		local drawFills = self.drawFillsCheck:Value()
		local drawStrokes = self.drawStrokesCheck:Value()
		if not drawStrokes then
			drawFills = true
			self.drawFillsCheck:SetValue(true)
		end
		local recolorFill = self.recolorFillCheck:Value()
		self.recolorFillCheck:Enable(drawFills)
		self.preserveFillAlphaCheck:Enable(drawFills and recolorFill)
		self.fillColorSwatch:Enable(drawFills and recolorFill)
		self.randomizeFillColorButton:Enable(recolorFill and drawFills)
	elseif msg == self.RECOLOR_FILL then
		local recolorFill = self.recolorFillCheck:Value()
		local drawFills = self.drawFillsCheck:Value()
		self.preserveFillAlphaCheck:Enable(drawFills and recolorFill)
		self.fillColorSwatch:Enable(recolorFill and drawFills)
		self.randomizeFillColorButton:Enable(recolorFill and drawFills)
	elseif msg == self.FILL_COLOR then
	elseif msg == self.RANDOMIZE_FILL_COLOR then
		local oldColor = self.fillColorSwatch:Value()
		local newColor = MR_Utilities:GenerateDistinctColor(oldColor)
		newColor.a = oldColor.a
		self.fillColorSwatch:SetValue(newColor)
	elseif msg == self.RANDOMIZE_FILL_COLOR_ALT then
		local oldColor = self.fillColorSwatch:Value()
		local newColor = MR_Utilities:RandomizeBrightness(oldColor)
		newColor.a = oldColor.a
		self.fillColorSwatch:SetValue(newColor)
	elseif msg == self.PRESERVE_STROKES_ALPHA then
	elseif msg == self.PRESERVE_FILL_ALPHA then
	elseif msg == self.MAKE_SHAPES_PLAIN then
	elseif msg == self.AUTO_SELECT_POINTS then
	elseif msg == self.RESET_OVERLAY then
		self.drawStrokesCheck:SetValue(true)
		self.changeStrokeWidthCheck:SetValue(false)
		self.strokeWidthInput:SetValue(6)
		self.recolorStrokesCheck:SetValue(false)
		self.recolorFillCheck:SetValue(false)
		self.drawFillsCheck:SetValue(true)
		self.preserveStrokesAlphaCheck:SetValue(true)
		self.preserveFillAlphaCheck:SetValue(true)
		self.makeShapesPlainCheck:SetValue(true)
		self.autoSelectShapesPointsCheck:SetValue(true)

		local strokeColor = LM.rgb_color:new_local()
		strokeColor.r = 225
		strokeColor.g = 30
		strokeColor.b = 30
		strokeColor.a = 255

		self.strokeColorSwatch:SetValue(strokeColor)

		local fillColor = LM.rgb_color:new_local()
		fillColor.r = 225
		fillColor.g = 236
		fillColor.b = 223
		fillColor.a = 255

		self.fillColorSwatch:SetValue(fillColor)
		
		local drawStrokes = true
		local changeStrokeWidth = false
		local recolorStroke = false
		local drawFills = true
		local recolorFill = false

		self.changeStrokeWidthCheck:Enable(drawStrokes)
		self.strokeWidthInput:Enable(changeStrokeWidth and drawStrokes)
		self.recolorStrokesCheck:Enable(drawStrokes)
		self.strokeColorSwatch:Enable(recolorStroke and drawStrokes)
		self.randomizeStrokeColorButton:Enable(recolorStroke and drawStrokes)
		self.preserveStrokesAlphaCheck:Enable(recolorStroke and drawStrokes)
		self.recolorFillCheck:Enable(drawFills)
		self.randomizeFillColorButton:Enable(recolorFill and drawFills)
		self.fillColorSwatch:Enable(recolorFill and drawFills)
		self.preserveFillAlphaCheck:Enable(recolorFill and drawFills)
		self.drawHiddenBonesCheck:Enable(not selectedBonesOnly)
	elseif msg == self.BONE_LINE_WIDTH then
		local bonesLineWidth = LM.Clamp(self.bonesLineWidthInput:FloatValue(), 0.2, 256)
		self.bonesLineWidthInput:SetValue(bonesLineWidth)
	elseif msg == self.BONE_WIDTH then
		local bonesWidth = LM.Clamp(self.bonesWidthInput:Value(), 0, 5)
		self.bonesWidthInput:SetValue(bonesWidth)
	elseif msg == self.BONE_COLOR then
	elseif msg == self.RANDOMIZE_BONE_COLOR then
		local oldColor = self.boneColorSwatch:Value()
		local newColor = MR_Utilities:GenerateDistinctColor(oldColor)
		newColor.a = oldColor.a
		self.boneColorSwatch:SetValue(newColor)
	elseif msg == self.RANDOMIZE_BONE_COLOR_ALT then
		local oldColor = self.boneColorSwatch:Value()
		local newColor = MR_Utilities:RandomizeBrightness(oldColor)
		newColor.a = oldColor.a
		self.boneColorSwatch:SetValue(newColor)
	elseif msg == self.DRAW_CENTER_LINE then
	elseif msg == self.PIN_BONE_RADIUS then
		local pinBoneRadius = LM.Clamp(self.pinBoneRadiusInput:Value(), 0.1, 100)
		self.pinBoneRadiusInput:SetValue(pinBoneRadius)
	elseif msg == self.DRAW_PIN_BONE_CENTER_LINES then
	elseif msg == self.SELECTED_BONES_ONLY then
		local selectedBonesOnly = self.selectedBonesOnlyCheck:Value()
		self.drawHiddenBonesCheck:Enable(not selectedBonesOnly)
	elseif msg == self.DRAW_HIDDEN_BONES then
	elseif msg == self.RESET_BONES then
		local boneColor = LM.rgb_color:new_local()
		boneColor.r = 222
		boneColor.g = 0
		boneColor.b = 0
		boneColor.a = 255
		
		self.bonesLineWidthInput:SetValue(3)
		self.bonesWidthInput:SetValue(1)
		self.boneColorSwatch:SetValue(boneColor)
		self.drawCenterLineCheck:SetValue(false)
		self.pinBoneRadiusInput:SetValue(1)
		self.drawPinBoneCenterLinesCheck:SetValue(false)
		self.selectedBonesOnlyCheck:SetValue(true)
		self.drawHiddenBonesCheck:SetValue(false)
	elseif msg == self.POINT_LINE_WIDTH then
		local pointLineWidth = LM.Clamp(self.pointLineWidthInput:FloatValue(), 0.25, 256)
		self.pointLineWidthInput:SetValue(pointLineWidth)
	elseif msg == self.DRAW_CROSSHAIR then
		local drawCrosshair = self.drawCrosshairCheck:Value()
		local drawCircle = self.drawCircleCheck:Value()
		if not drawCircle and not drawCrosshair then
			drawCrosshair = true
		end
		self.drawCrosshairCheck:SetValue(drawCrosshair)
		self.crosshairRadiusInput:Enable(drawCrosshair)
		self.pointCrosshairColorSwatch:Enable(drawCrosshair)
		self.randomizeCrosshairColorButton:Enable(drawCrosshair)
	elseif msg == self.CROSSHAIR_RADIUS then
		local crosshairRadius = LM.Clamp(self.crosshairRadiusInput:Value(), 0.1, 5)
		self.crosshairRadiusInput:SetValue(crosshairRadius)
	elseif msg == self.CROSSHAR_COLOR then
	elseif msg == self.RANDOMIZE_CROSSHAIR_COLOR then
		local oldColor = self.pointCrosshairColorSwatch:Value()
		local newColor = MR_Utilities:GenerateDistinctColor(oldColor)
		newColor.a = oldColor.a
		self.pointCrosshairColorSwatch:SetValue(newColor)
	elseif msg == self.RANDOMIZE_CROSSHAIR_COLOR_ALT then
		local oldColor = self.pointCrosshairColorSwatch:Value()
		local newColor = MR_Utilities:RandomizeBrightness(oldColor)
		newColor.a = oldColor.a
		self.pointCrosshairColorSwatch:SetValue(newColor)
	elseif msg == self.DRAW_CIRCLE then
		local drawCircle = self.drawCircleCheck:Value()
		local drawCrosshair = self.drawCrosshairCheck:Value()
		if not drawCircle and not drawCrosshair then
			drawCircle = true
		end
		self.drawCircleCheck:SetValue(drawCircle)
		self.circleRadiusInput:Enable(drawCircle)
		self.pointCircleColorSwatch:Enable(drawCircle)
		self.randomizeCircleColorButton:Enable(drawCircle)
	elseif msg == self.CIRCLE_RADIUS then
		local circleRadius = LM.Clamp(self.circleRadiusInput:Value(), 0.1, 5)
		self.circleRadiusInput:SetValue(circleRadius)
	elseif msg == self.CIRCLE_COLOR then
	elseif msg == self.RANDOMIZE_CIRCLE_COLOR then
		local oldColor = self.pointCircleColorSwatch:Value()
		local newColor = MR_Utilities:GenerateDistinctColor(oldColor)
		newColor.a = oldColor.a
		self.pointCircleColorSwatch:SetValue(newColor)
	elseif msg == self.RANDOMIZE_CIRCLE_COLOR_ALT then
		local oldColor = self.pointCircleColorSwatch:Value()
		local newColor = MR_Utilities:RandomizeBrightness(oldColor)
		newColor.a = oldColor.a
		self.pointCircleColorSwatch:SetValue(newColor)
	elseif msg == self.SELECTED_POINTS_ONLY then
		local selectedPointsOnly = self.selectedPointsOnlyCheck:Value()
		self.drawHiddenPointsCheck:Enable(not selectedPointsOnly)
	elseif msg == self.DRAW_HIDDEN_POINTS then
	elseif msg == self.RESET_POINTS then
		self.pointLineWidthInput:SetValue(6)
		self.drawCrosshairCheck:SetValue(true)
		self.crosshairRadiusInput:SetValue(1)

		local pointCrosshairColor = LM.rgb_color:new_local()
		pointCrosshairColor.r = 13
		pointCrosshairColor.g = 199
		pointCrosshairColor.b = 216
		pointCrosshairColor.a = 255

		self.pointCrosshairColorSwatch:SetValue(pointCrosshairColor)
		self.drawCircleCheck:SetValue(false)
		self.circleRadiusInput:SetValue(1)

		local pointCircleColor = LM.rgb_color:new_local()
		pointCircleColor.r = 23
		pointCircleColor.g = 142
		pointCircleColor.b = 198
		pointCircleColor.a = 125

		self.pointCircleColorSwatch:SetValue(pointCircleColor)
		self.selectedPointsOnlyCheck:SetValue(true)
		self.drawHiddenPointsCheck:SetValue(false)
	elseif msg == self.FLIP_OVERLAY then
		local flipOverlay = self.flipOverlayCheck:Value()
		local mirrorFlip = self.mirrorOverlayCheck:Value()
		self.mirrorOverlayCheck:Enable(flipOverlay)
		self.mirrorOverlayShadeCheck:Enable(flipOverlay and mirrorFlip)
	elseif msg == self.MIRROR_OVERLAY then
		local flipOverlay = self.flipOverlayCheck:Value()
		local mirrorFlip = self.mirrorOverlayCheck:Value()
		self.mirrorOverlayShadeCheck:Enable(flipOverlay and mirrorFlip)
	elseif msg == self.SET_CUSTOM_PIVOT then
		local helper = MOHO.ScriptInterfaceHelper:new_local()
		local moho = helper:MohoObject()
		local x, y = MR_Overlay:SetCustomCenter(moho, false)
		helper:delete()
		self.custom_center_value_x_Input:SetValue(x)
		self.custom_center_value_y_Input:SetValue(y)
	elseif msg == self.SET_CUSTOM_PIVOT_ALT then
		local helper = MOHO.ScriptInterfaceHelper:new_local()
		local moho = helper:MohoObject()
		local x, y = MR_Overlay:SetCustomCenter(moho, true)
		helper:delete()
		local x, y = MR_Overlay:SetCustomCenter(moho, true)
		self.custom_center_value_x_Input:SetValue(x)
		self.custom_center_value_y_Input:SetValue(y)
	elseif msg == self.GET_MAIN_SETTINGS then
		local layerIndex = MR_Overlay.layerIndex

		-- Mode
		self.shapesOverlayButton:SetValue(MR_Overlay.shapesOverlay)
		self.bonesOverlayButton:SetValue(MR_Overlay.bonesOverlay)
		self.pointsOverlayButton:SetValue(MR_Overlay.pointsOverlay)

		-- Shapes
		self.drawStrokesCheck:SetValue(MR_Overlay.drawStrokes)
		self.changeStrokeWidthCheck:SetValue(MR_Overlay.changeStrokeWidth)
		self.strokeWidthInput:SetValue(MR_Overlay.strokeWidth)
		self.recolorStrokesCheck:SetValue(MR_Overlay.recolorStroke)

		self.changeStrokeWidthCheck:Enable(MR_Overlay.drawStrokes)
		self.strokeWidthInput:Enable(MR_Overlay.changeStrokeWidth and MR_Overlay.drawStrokes)
		self.recolorStrokesCheck:Enable(MR_Overlay.drawStrokes)

		local strokeColor = LM.rgb_color:new_local()
		strokeColor.r = MR_Overlay.strokeColorR
		strokeColor.g = MR_Overlay.strokeColorG
		strokeColor.b = MR_Overlay.strokeColorB
		strokeColor.a = MR_Overlay.strokeColorA

		self.strokeColorSwatch:SetValue(strokeColor)
		self.strokeColorSwatch:Enable(MR_Overlay.recolorStroke and MR_Overlay.drawStrokes)

		self.randomizeStrokeColorButton:Enable(MR_Overlay.recolorStroke and MR_Overlay.drawStrokes)

		self.preserveStrokesAlphaCheck:SetValue(MR_Overlay.preserveStrokeAlpha)
		self.preserveStrokesAlphaCheck:Enable(MR_Overlay.recolorStroke and MR_Overlay.drawStrokes)
		self.drawFillsCheck:SetValue(MR_Overlay.drawFills)
		self.recolorFillCheck:SetValue(MR_Overlay.recolorFill)
		self.recolorFillCheck:Enable(MR_Overlay.drawFills)

		self.randomizeFillColorButton:Enable(MR_Overlay.recolorFill and MR_Overlay.drawFills)

		local fillColor = LM.rgb_color:new_local()
		fillColor.r = MR_Overlay.fillColorR
		fillColor.g = MR_Overlay.fillColorG
		fillColor.b = MR_Overlay.fillColorB
		fillColor.a = MR_Overlay.fillColorA

		self.fillColorSwatch:SetValue(fillColor)
		self.fillColorSwatch:Enable(MR_Overlay.recolorFill and MR_Overlay.drawFills)

		self.preserveFillAlphaCheck:SetValue(MR_Overlay.preserveFillAlpha)
		self.preserveFillAlphaCheck:Enable(MR_Overlay.recolorFill and MR_Overlay.drawFills)
		self.makeShapesPlainCheck:SetValue(MR_Overlay.makeShapesPlain)
		self.autoSelectShapesPointsCheck:SetValue(MR_Overlay.autoSelectShapesPoints)

		-- Bones
		self.bonesLineWidthInput:SetValue(MR_Overlay.bonesLineWidth)
		self.bonesWidthInput:SetValue(MR_Overlay.bonesWidth)

		local colorSwatchValue = LM.rgb_color:new_local()
		colorSwatchValue.r = MR_Overlay.boneColorR
		colorSwatchValue.g = MR_Overlay.boneColorG
		colorSwatchValue.b = MR_Overlay.boneColorB
		colorSwatchValue.a = MR_Overlay.boneColorA
		self.boneColorSwatch:SetValue(colorSwatchValue)

		self.drawCenterLineCheck:SetValue(MR_Overlay.drawCenterLine)
		self.pinBoneRadiusInput:SetValue(MR_Overlay.pinBoneRadius)
		self.drawPinBoneCenterLinesCheck:SetValue(MR_Overlay.drawPinBoneCenterLines)
		self.selectedBonesOnlyCheck:SetValue(MR_Overlay.selectedBonesOnly)
		self.drawHiddenBonesCheck:SetValue(MR_Overlay.drawHiddenBones)
		self.drawHiddenBonesCheck:Enable(not MR_Overlay.selectedBonesOnly)

		-- Points
		self.pointLineWidthInput:SetValue(MR_Overlay.pointLineWidth)
		self.drawCrosshairCheck:SetValue(MR_Overlay.drawCrosshair)
		self.crosshairRadiusInput:SetValue(MR_Overlay.crosshairRadius)
		self.crosshairRadiusInput:Enable(MR_Overlay.drawCrosshair)
		self.randomizeCrosshairColorButton:Enable(MR_Overlay.drawCrosshair)

		local colorSwatchValue = LM.rgb_color:new_local()
		colorSwatchValue.r = MR_Overlay.pointCrosshairColorR
		colorSwatchValue.g = MR_Overlay.pointCrosshairColorG
		colorSwatchValue.b = MR_Overlay.pointCrosshairColorB
		colorSwatchValue.a = MR_Overlay.pointCrosshairColorA
		self.pointCrosshairColorSwatch:SetValue(colorSwatchValue)
		self.pointCrosshairColorSwatch:Enable(MR_Overlay.drawCrosshair)

		self.drawCircleCheck:SetValue(MR_Overlay.drawCircle)
		self.circleRadiusInput:SetValue(MR_Overlay.circleRadius)
		self.circleRadiusInput:Enable(MR_Overlay.drawCircle)
		self.randomizeCircleColorButton:Enable(MR_Overlay.drawCircle)

		local colorSwatchValue = LM.rgb_color:new_local()
		colorSwatchValue.r = MR_Overlay.pointCircleColorR
		colorSwatchValue.g = MR_Overlay.pointCircleColorG
		colorSwatchValue.b = MR_Overlay.pointCircleColorB
		colorSwatchValue.a = MR_Overlay.pointCircleColorA
		self.pointCircleColorSwatch:SetValue(colorSwatchValue)
		self.pointCircleColorSwatch:Enable(MR_Overlay.drawCircle)

		self.selectedPointsOnlyCheck:SetValue(MR_Overlay.selectedPointsOnly)
		self.drawHiddenPointsCheck:SetValue(MR_Overlay.drawHiddenPoints)
		self.drawHiddenPointsCheck:Enable(not MR_Overlay.selectedPointsOnly)

		-- Other
		self.flipOverlayCheck:SetValue(MR_Overlay.flipOverlay)
		self.mirrorOverlayCheck:SetValue(MR_Overlay.mirrorFlip)
		self.mirrorOverlayCheck:Enable(MR_Overlay.flipOverlay)

		self.mirrorOverlayShadeCheck:SetValue(MR_Overlay.mirrorOverlayShade)
		self.mirrorOverlayShadeCheck:Enable(MR_Overlay.flipOverlay and MR_Overlay.mirrorFlip)

		self.custom_center_RadioButton:SetValue(MR_Overlay.customCenter)
		self.layer_origin_RadioButton:SetValue(MR_Overlay.layerOriginCenter)
		self.selection_center_RadioButton:SetValue(MR_Overlay.selectionCenter)
 
		self.custom_center_value_x_Input:SetValue(MR_Overlay.customCenterValueX)
		self.custom_center_value_y_Input:SetValue(MR_Overlay.customCenterValueY)

		self.createOverlayFromFrameCheck:SetValue(MR_Overlay.createFromFrame)

		self.frame_1_RadioButton:SetValue(MR_Overlay.useFrame1)
		self.frame_2_RadioButton:SetValue(MR_Overlay.useFrame2)
		self.frame_3_RadioButton:SetValue(MR_Overlay.useFrame3)
		self.frame_4_RadioButton:SetValue(MR_Overlay.useFrame4)
		self.frame_5_RadioButton:SetValue(MR_Overlay.useFrame5)

		self.frame_1_valueInput:SetValue(MR_Overlay.frameVal1)
		self.frame_2_valueInput:SetValue(MR_Overlay.frameVal2)
		self.frame_3_valueInput:SetValue(MR_Overlay.frameVal3)
		self.frame_4_valueInput:SetValue(MR_Overlay.frameVal4)
		self.frame_5_valueInput:SetValue(MR_Overlay.frameVal5)
	elseif msg == self.GET_MAIN_SETTINGS_ALT then
		local layerIndex = MR_Overlay.layerIndex

		if self.shapesOverlayButton:Value() then
			self.drawStrokesCheck:SetValue(MR_Overlay.drawStrokes)
			self.changeStrokeWidthCheck:SetValue(MR_Overlay.changeStrokeWidth)
			self.strokeWidthInput:SetValue(MR_Overlay.strokeWidth)
			self.recolorStrokesCheck:SetValue(MR_Overlay.recolorStroke)

			self.changeStrokeWidthCheck:Enable(MR_Overlay.drawStrokes)
			self.strokeWidthInput:Enable(MR_Overlay.changeStrokeWidth and MR_Overlay.drawStrokes)
			self.recolorStrokesCheck:Enable(MR_Overlay.drawStrokes)

			local strokeColor = LM.rgb_color:new_local()
			strokeColor.r = MR_Overlay.strokeColorR
			strokeColor.g = MR_Overlay.strokeColorG
			strokeColor.b = MR_Overlay.strokeColorB
			strokeColor.a = MR_Overlay.strokeColorA

			self.strokeColorSwatch:SetValue(strokeColor)
			self.strokeColorSwatch:Enable(MR_Overlay.recolorStroke and MR_Overlay.drawStrokes)

			self.randomizeStrokeColorButton:Enable(MR_Overlay.recolorStroke and MR_Overlay.drawStrokes)

			self.preserveStrokesAlphaCheck:SetValue(MR_Overlay.preserveStrokeAlpha)
			self.preserveStrokesAlphaCheck:Enable(MR_Overlay.recolorStroke and MR_Overlay.drawStrokes)
			self.drawFillsCheck:SetValue(MR_Overlay.drawFills)
			self.recolorFillCheck:SetValue(MR_Overlay.recolorFill)
			self.recolorFillCheck:Enable(MR_Overlay.drawFills)

			self.randomizeFillColorButton:Enable(MR_Overlay.recolorFill and MR_Overlay.drawFills)

			local fillColor = LM.rgb_color:new_local()
			fillColor.r = MR_Overlay.fillColorR
			fillColor.g = MR_Overlay.fillColorG
			fillColor.b = MR_Overlay.fillColorB
			fillColor.a = MR_Overlay.fillColorA

			self.fillColorSwatch:SetValue(fillColor)
			self.fillColorSwatch:Enable(MR_Overlay.recolorFill and MR_Overlay.drawFills)

			self.preserveFillAlphaCheck:SetValue(MR_Overlay.preserveFillAlpha)
			self.preserveFillAlphaCheck:Enable(MR_Overlay.recolorFill and MR_Overlay.drawFills)
			self.makeShapesPlainCheck:SetValue(MR_Overlay.makeShapesPlain)
			self.autoSelectShapesPointsCheck:SetValue(MR_Overlay.autoSelectShapesPoints)
		end

		-- Bones
		if self.bonesOverlayButton:Value() then
			self.bonesLineWidthInput:SetValue(MR_Overlay.bonesLineWidth)
			self.bonesWidthInput:SetValue(MR_Overlay.bonesWidth)

			local colorSwatchValue = LM.rgb_color:new_local()
			colorSwatchValue.r = MR_Overlay.boneColorR
			colorSwatchValue.g = MR_Overlay.boneColorG
			colorSwatchValue.b = MR_Overlay.boneColorB
			colorSwatchValue.a = MR_Overlay.boneColorA
			self.boneColorSwatch:SetValue(colorSwatchValue)

			self.drawCenterLineCheck:SetValue(MR_Overlay.drawCenterLine)
			self.pinBoneRadiusInput:SetValue(MR_Overlay.pinBoneRadius)
			self.drawPinBoneCenterLinesCheck:SetValue(MR_Overlay.drawPinBoneCenterLines)
			self.selectedBonesOnlyCheck:SetValue(MR_Overlay.selectedBonesOnly)
			self.drawHiddenBonesCheck:SetValue(MR_Overlay.drawHiddenBones)
			self.drawHiddenBonesCheck:Enable(not MR_Overlay.selectedBonesOnly)
		end

		-- Points
		if self.pointsOverlayButton:Value() then
			self.pointLineWidthInput:SetValue(MR_Overlay.pointLineWidth)
			self.drawCrosshairCheck:SetValue(MR_Overlay.drawCrosshair)
			self.crosshairRadiusInput:SetValue(MR_Overlay.crosshairRadius)
			self.crosshairRadiusInput:Enable(MR_Overlay.drawCrosshair)
			self.randomizeCrosshairColorButton:Enable(MR_Overlay.drawCrosshair)

			local colorSwatchValue = LM.rgb_color:new_local()
			colorSwatchValue.r = MR_Overlay.pointCrosshairColorR
			colorSwatchValue.g = MR_Overlay.pointCrosshairColorG
			colorSwatchValue.b = MR_Overlay.pointCrosshairColorB
			colorSwatchValue.a = MR_Overlay.pointCrosshairColorA
			self.pointCrosshairColorSwatch:SetValue(colorSwatchValue)
			self.pointCrosshairColorSwatch:Enable(MR_Overlay.drawCrosshair)

			self.drawCircleCheck:SetValue(MR_Overlay.drawCircle)
			self.circleRadiusInput:SetValue(MR_Overlay.circleRadius)
			self.circleRadiusInput:Enable(MR_Overlay.drawCircle)
			self.randomizeCircleColorButton:Enable(MR_Overlay.drawCircle)

			local colorSwatchValue = LM.rgb_color:new_local()
			colorSwatchValue.r = MR_Overlay.pointCircleColorR
			colorSwatchValue.g = MR_Overlay.pointCircleColorG
			colorSwatchValue.b = MR_Overlay.pointCircleColorB
			colorSwatchValue.a = MR_Overlay.pointCircleColorA
			self.pointCircleColorSwatch:SetValue(colorSwatchValue)
			self.pointCircleColorSwatch:Enable(MR_Overlay.drawCircle)

			self.selectedPointsOnlyCheck:SetValue(MR_Overlay.selectedPointsOnly)
			self.drawHiddenPointsCheck:SetValue(MR_Overlay.drawHiddenPoints)
			self.drawHiddenPointsCheck:Enable(not MR_Overlay.selectedPointsOnly)
		end

		-- Other
		if self.useFlipSettingsCheck:Value() then
			self.flipOverlayCheck:SetValue(MR_Overlay.flipOverlay)
			self.mirrorOverlayCheck:SetValue(MR_Overlay.mirrorFlip)
			self.mirrorOverlayCheck:Enable(MR_Overlay.flipOverlay)

			self.mirrorOverlayShadeCheck:SetValue(MR_Overlay.mirrorOverlayShade)
			self.mirrorOverlayShadeCheck:Enable(MR_Overlay.flipOverlay and MR_Overlay.mirrorFlip)

			self.custom_center_RadioButton:SetValue(MR_Overlay.customCenter)
			self.layer_origin_RadioButton:SetValue(MR_Overlay.layerOriginCenter)
			self.selection_center_RadioButton:SetValue(MR_Overlay.selectionCenter)

			self.custom_center_value_x_Input:SetValue(MR_Overlay.customCenterValueX)
			self.custom_center_value_y_Input:SetValue(MR_Overlay.customCenterValueY)
		end

		if self.useFrameSettingsCheck:Value() then
			self.createOverlayFromFrameCheck:SetValue(MR_Overlay.createFromFrame)

			self.frame_1_RadioButton:SetValue(MR_Overlay.useFrame1)
			self.frame_2_RadioButton:SetValue(MR_Overlay.useFrame2)
			self.frame_3_RadioButton:SetValue(MR_Overlay.useFrame3)
			self.frame_4_RadioButton:SetValue(MR_Overlay.useFrame4)
			self.frame_5_RadioButton:SetValue(MR_Overlay.useFrame5)

			self.frame_1_valueInput:SetValue(MR_Overlay.frameVal1)
			self.frame_2_valueInput:SetValue(MR_Overlay.frameVal2)
			self.frame_3_valueInput:SetValue(MR_Overlay.frameVal3)
			self.frame_4_valueInput:SetValue(MR_Overlay.frameVal4)
			self.frame_5_valueInput:SetValue(MR_Overlay.frameVal5)
		end
	elseif msg == self.SET_MAIN_SETTINGS then
		local layerIndex = MR_Overlay.layerIndex

		-- Mode
		MR_Overlay.shapesOverlay = self.shapesOverlayButton:Value()
		MR_Overlay.bonesOverlay = self.bonesOverlayButton:Value()
		MR_Overlay.pointsOverlay = self.pointsOverlayButton:Value()

		-- Shapes
		MR_Overlay.drawStrokes = self.drawStrokesCheck:Value()
		MR_Overlay.changeStrokeWidth = self.changeStrokeWidthCheck:Value()
		MR_Overlay.strokeWidth = self.strokeWidthInput:Value()
		MR_Overlay.recolorStroke = self.recolorStrokesCheck:Value()

		local colorSwatchValue = self.strokeColorSwatch:Value()
		MR_Overlay.strokeColorR = colorSwatchValue.r
		MR_Overlay.strokeColorG = colorSwatchValue.g
		MR_Overlay.strokeColorB = colorSwatchValue.b
		MR_Overlay.strokeColorA = colorSwatchValue.a

		MR_Overlay.preserveStrokeAlpha = self.preserveStrokesAlphaCheck:Value()
		MR_Overlay.drawFills = self.drawFillsCheck:Value()
		MR_Overlay.recolorFill = self.recolorFillCheck:Value()

		local colorSwatchValue = self.fillColorSwatch:Value()
		MR_Overlay.fillColorR = colorSwatchValue.r
		MR_Overlay.fillColorG = colorSwatchValue.g
		MR_Overlay.fillColorB = colorSwatchValue.b
		MR_Overlay.fillColorA = colorSwatchValue.a

		MR_Overlay.preserveFillAlpha = self.preserveFillAlphaCheck:Value()
		MR_Overlay.makeShapesPlain = self.makeShapesPlainCheck:Value()
		MR_Overlay.autoSelectShapesPoints = self.autoSelectShapesPointsCheck:Value()

		-- Bones
		MR_Overlay.bonesLineWidth = self.bonesLineWidthInput:Value()
		MR_Overlay.bonesWidth = self.bonesWidthInput:Value()

		local colorSwatchValue = self.boneColorSwatch:Value()
		MR_Overlay.boneColorR = colorSwatchValue.r
		MR_Overlay.boneColorG = colorSwatchValue.g
		MR_Overlay.boneColorB = colorSwatchValue.b
		MR_Overlay.boneColorA = colorSwatchValue.a

		MR_Overlay.drawCenterLine = self.drawCenterLineCheck:Value()
		MR_Overlay.pinBoneRadius = self.pinBoneRadiusInput:Value()
		MR_Overlay.drawPinBoneCenterLines = self.drawPinBoneCenterLinesCheck:Value()
		MR_Overlay.selectedBonesOnly = self.selectedBonesOnlyCheck:Value()
		MR_Overlay.drawHiddenBones = self.drawHiddenBonesCheck:Value()

		-- Points
		MR_Overlay.pointLineWidth = self.pointLineWidthInput:Value()
		MR_Overlay.drawCrosshair = self.drawCrosshairCheck:Value()
		MR_Overlay.crosshairRadius = self.crosshairRadiusInput:Value()

		local colorSwatchValue = self.pointCrosshairColorSwatch:Value()
		MR_Overlay.pointCrosshairColorR = colorSwatchValue.r
		MR_Overlay.pointCrosshairColorG = colorSwatchValue.g
		MR_Overlay.pointCrosshairColorB = colorSwatchValue.b
		MR_Overlay.pointCrosshairColorA = colorSwatchValue.a

		MR_Overlay.drawCircle = self.drawCircleCheck:Value()
		MR_Overlay.circleRadius = self.circleRadiusInput:Value()

		local colorSwatchValue = self.pointCircleColorSwatch:Value()
		MR_Overlay.pointCircleColorR = colorSwatchValue.r
		MR_Overlay.pointCircleColorG = colorSwatchValue.g
		MR_Overlay.pointCircleColorB = colorSwatchValue.b
		MR_Overlay.pointCircleColorA = colorSwatchValue.a

		MR_Overlay.selectedPointsOnly = self.selectedPointsOnlyCheck:Value()
		MR_Overlay.drawHiddenPoints = self.drawHiddenPointsCheck:Value()

		-- Other
		MR_Overlay.flipOverlay = self.flipOverlayCheck:Value()
		MR_Overlay.mirrorFlip = self.mirrorOverlayCheck:Value()
		MR_Overlay.mirrorOverlayShade = self.mirrorOverlayShadeCheck:Value()

		MR_Overlay.customCenter = self.custom_center_RadioButton:Value()
		MR_Overlay.layerOriginCenter = self.layer_origin_RadioButton:Value()
		MR_Overlay.selectionCenter = self.selection_center_RadioButton:Value()

		MR_Overlay.customCenterValueX = self.custom_center_value_x_Input:Value()
		MR_Overlay.customCenterValueY = self.custom_center_value_y_Input:Value()

		MR_Overlay.createFromFrame = self.createOverlayFromFrameCheck:Value()

		MR_Overlay.useFrame1 = self.frame_1_RadioButton:Value()
		MR_Overlay.useFrame2 = self.frame_2_RadioButton:Value()
		MR_Overlay.useFrame3 = self.frame_3_RadioButton:Value()
		MR_Overlay.useFrame4 = self.frame_4_RadioButton:Value()
		MR_Overlay.useFrame5 = self.frame_5_RadioButton:Value()

		MR_Overlay.frameVal1 = self.frame_1_valueInput:Value()
		MR_Overlay.frameVal2 = self.frame_2_valueInput:Value()
		MR_Overlay.frameVal3 = self.frame_3_valueInput:Value()
		MR_Overlay.frameVal4 = self.frame_4_valueInput:Value()
		MR_Overlay.frameVal5 = self.frame_5_valueInput:Value()

		MR_Overlay.overlayDlog:UpdateWidgets()
	elseif msg == self.SET_MAIN_SETTINGS_ALT then
		local layerIndex = MR_Overlay.layerIndex

		-- Mode
		MR_Overlay.shapesOverlay = self.shapesOverlayButton:Value()
		MR_Overlay.bonesOverlay = self.bonesOverlayButton:Value()
		MR_Overlay.pointsOverlay = self.pointsOverlayButton:Value()

		-- Shapes
		if self.shapesOverlayButton:Value() then
			MR_Overlay.drawStrokes = self.drawStrokesCheck:Value()
			MR_Overlay.changeStrokeWidth = self.changeStrokeWidthCheck:Value()
			MR_Overlay.strokeWidth = self.strokeWidthInput:Value()
			MR_Overlay.recolorStroke = self.recolorStrokesCheck:Value()

			local colorSwatchValue = self.strokeColorSwatch:Value()
			MR_Overlay.strokeColorR = colorSwatchValue.r
			MR_Overlay.strokeColorG = colorSwatchValue.g
			MR_Overlay.strokeColorB = colorSwatchValue.b
			MR_Overlay.strokeColorA = colorSwatchValue.a

			MR_Overlay.preserveStrokeAlpha = self.preserveStrokesAlphaCheck:Value()
			MR_Overlay.drawFills = self.drawFillsCheck:Value()
			MR_Overlay.recolorFill = self.recolorFillCheck:Value()

			local colorSwatchValue = self.fillColorSwatch:Value()
			MR_Overlay.fillColorR = colorSwatchValue.r
			MR_Overlay.fillColorG = colorSwatchValue.g
			MR_Overlay.fillColorB = colorSwatchValue.b
			MR_Overlay.fillColorA = colorSwatchValue.a

			MR_Overlay.preserveFillAlpha = self.preserveFillAlphaCheck:Value()
			MR_Overlay.makeShapesPlain = self.makeShapesPlainCheck:Value()
			MR_Overlay.autoSelectShapesPoints = self.autoSelectShapesPointsCheck:Value()
		end

		-- Bones
		if self.bonesOverlayButton:Value() then
			MR_Overlay.bonesLineWidth = self.bonesLineWidthInput:Value()
			MR_Overlay.bonesWidth = self.bonesWidthInput:Value()

			local colorSwatchValue = self.boneColorSwatch:Value()
			MR_Overlay.boneColorR = colorSwatchValue.r
			MR_Overlay.boneColorG = colorSwatchValue.g
			MR_Overlay.boneColorB = colorSwatchValue.b
			MR_Overlay.boneColorA = colorSwatchValue.a

			MR_Overlay.drawCenterLine = self.drawCenterLineCheck:Value()
			MR_Overlay.pinBoneRadius = self.pinBoneRadiusInput:Value()
			MR_Overlay.drawPinBoneCenterLines = self.drawPinBoneCenterLinesCheck:Value()
			MR_Overlay.selectedBonesOnly = self.selectedBonesOnlyCheck:Value()
			MR_Overlay.drawHiddenBones = self.drawHiddenBonesCheck:Value()
		end

		-- Points
		if self.pointsOverlayButton:Value() then
			MR_Overlay.pointLineWidth = self.pointLineWidthInput:Value()
			MR_Overlay.drawCrosshair = self.drawCrosshairCheck:Value()
			MR_Overlay.crosshairRadius = self.crosshairRadiusInput:Value()

			local colorSwatchValue = self.pointCrosshairColorSwatch:Value()
			MR_Overlay.pointCrosshairColorR = colorSwatchValue.r
			MR_Overlay.pointCrosshairColorG = colorSwatchValue.g
			MR_Overlay.pointCrosshairColorB = colorSwatchValue.b
			MR_Overlay.pointCrosshairColorA = colorSwatchValue.a

			MR_Overlay.drawCircle = self.drawCircleCheck:Value()
			MR_Overlay.circleRadius = self.circleRadiusInput:Value()

			local colorSwatchValue = self.pointCircleColorSwatch:Value()
			MR_Overlay.pointCircleColorR = colorSwatchValue.r
			MR_Overlay.pointCircleColorG = colorSwatchValue.g
			MR_Overlay.pointCircleColorB = colorSwatchValue.b
			MR_Overlay.pointCircleColorA = colorSwatchValue.a

			MR_Overlay.selectedPointsOnly = self.selectedPointsOnlyCheck:Value()
			MR_Overlay.drawHiddenPoints = self.drawHiddenPointsCheck:Value()
		end

		-- Other
		if self.useFlipSettingsCheck:Value() then
			MR_Overlay.flipOverlay = self.flipOverlayCheck:Value()
			MR_Overlay.mirrorFlip = self.mirrorOverlayCheck:Value()
			MR_Overlay.mirrorOverlayShade = self.mirrorOverlayShadeCheck:Value()

			MR_Overlay.customCenter = self.custom_center_RadioButton:Value()
			MR_Overlay.layerOriginCenter = self.layer_origin_RadioButton:Value()
			MR_Overlay.selectionCenter = self.selection_center_RadioButton:Value()

			MR_Overlay.customCenterValueX = self.custom_center_value_x_Input:Value()
			MR_Overlay.customCenterValueY = self.custom_center_value_y_Input:Value()
		end

		if self.useFrameSettingsCheck:Value() then
			MR_Overlay.createFromFrame = self.createOverlayFromFrameCheck:Value()

			MR_Overlay.useFrame1 = self.frame_1_RadioButton:Value()
			MR_Overlay.useFrame2 = self.frame_2_RadioButton:Value()
			MR_Overlay.useFrame3 = self.frame_3_RadioButton:Value()
			MR_Overlay.useFrame4 = self.frame_4_RadioButton:Value()
			MR_Overlay.useFrame5 = self.frame_5_RadioButton:Value()

			MR_Overlay.frameVal1 = self.frame_1_valueInput:Value()
			MR_Overlay.frameVal2 = self.frame_2_valueInput:Value()
			MR_Overlay.frameVal3 = self.frame_3_valueInput:Value()
			MR_Overlay.frameVal4 = self.frame_4_valueInput:Value()
			MR_Overlay.frameVal5 = self.frame_5_valueInput:Value()
		end

		MR_Overlay.overlayDlog:UpdateWidgets()
	end
end

function MR_Overlay:BuildLayerSettingsDialog(moho, layerIndex)
	local dlog = MR_OverlayLayerSettingsDialog:new(moho)
	if dlog then
		if (dlog:DoModal() == LM.GUI.MSG_CANCEL) then
			return false
		end
	end
end

function MR_Overlay:CopyMainSettingsToLayer(moho, layerIndex)
	local overlayGroupLayer = MR_Overlay:CheckExistOverlayLayer(moho)
	if overlayGroupLayer then
		local scriptData = overlayGroupLayer:ScriptData()
		-- Mode
		if MR_Overlay.shapesOverlay then
			scriptData:Set('MR Overlay Setup Mode '..layerIndex, 'Shapes')
		elseif MR_Overlay.bonesOverlay then
			scriptData:Set('MR Overlay Setup Mode '..layerIndex, 'Bones')
		elseif MR_Overlay.pointsOverlay then
			scriptData:Set('MR Overlay Setup Mode '..layerIndex, 'Points')
		end

		-- Shapes
		scriptData:Set('MR Overlay Setup drawStrokes '..layerIndex, MR_Overlay.drawStrokes)
		scriptData:Set('MR Overlay Setup changeStrokeWidth '..layerIndex, MR_Overlay.changeStrokeWidth)
		scriptData:Set('MR Overlay Setup strokeWidth '..layerIndex, MR_Overlay.strokeWidth)
		scriptData:Set('MR Overlay Setup recolorStroke '..layerIndex, MR_Overlay.recolorStroke)
		local strokeColor = MR_Utilities:RgbaToHex(MR_Overlay.strokeColorR, MR_Overlay.strokeColorG, MR_Overlay.strokeColorB, MR_Overlay.strokeColorA)
		scriptData:Set('MR Overlay Setup strokeColor '..layerIndex, strokeColor)
		scriptData:Set('MR Overlay Setup preserveStrokeAlpha '..layerIndex, MR_Overlay.preserveStrokeAlpha)
		scriptData:Set('MR Overlay Setup drawFills '..layerIndex, MR_Overlay.drawFills)
		scriptData:Set('MR Overlay Setup recolorFill '..layerIndex, MR_Overlay.recolorFill)
		local fillColor = MR_Utilities:RgbaToHex(MR_Overlay.fillColorR, MR_Overlay.fillColorG, MR_Overlay.fillColorB, MR_Overlay.fillColorA)
		scriptData:Set('MR Overlay Setup fillColor '..layerIndex, fillColor)
		scriptData:Set('MR Overlay Setup preserveFillAlpha '..layerIndex, MR_Overlay.preserveFillAlpha)
		scriptData:Set('MR Overlay Setup makeShapesPlain '..layerIndex, MR_Overlay.makeShapesPlain)
		scriptData:Set('MR Overlay Setup autoSelectShapesPoints '..layerIndex, MR_Overlay.autoSelectShapesPoints)

		-- Bones
		scriptData:Set('MR Overlay Setup bonesLineWidth '..layerIndex, MR_Overlay.bonesLineWidth)
		scriptData:Set('MR Overlay Setup bonesWidth '..layerIndex, MR_Overlay.bonesWidth)
		local boneColor = MR_Utilities:RgbaToHex(MR_Overlay.boneColorR, MR_Overlay.boneColorG, MR_Overlay.boneColorB, MR_Overlay.boneColorA)
		scriptData:Set('MR Overlay Setup boneColor '..layerIndex, boneColor)
		scriptData:Set('MR Overlay Setup drawCenterLine '..layerIndex, MR_Overlay.drawCenterLine)
		scriptData:Set('MR Overlay Setup pinBoneRadius '..layerIndex, MR_Overlay.pinBoneRadius)
		scriptData:Set('MR Overlay Setup drawPinBoneCenterLines '..layerIndex, MR_Overlay.drawPinBoneCenterLines)
		scriptData:Set('MR Overlay Setup selectedBonesOnly '..layerIndex, MR_Overlay.selectedBonesOnly)
		scriptData:Set('MR Overlay Setup drawHiddenBones '..layerIndex, MR_Overlay.drawHiddenBones)

		-- Points
		scriptData:Set('MR Overlay Setup pointLineWidth '..layerIndex, MR_Overlay.pointLineWidth)
		scriptData:Set('MR Overlay Setup drawCrosshair '..layerIndex, MR_Overlay.drawCrosshair)
		scriptData:Set('MR Overlay Setup crosshairRadius '..layerIndex, MR_Overlay.crosshairRadius)
		local pointCrosshairColor = MR_Utilities:RgbaToHex(MR_Overlay.pointCrosshairColorR, MR_Overlay.pointCrosshairColorG, MR_Overlay.pointCrosshairColorB, MR_Overlay.pointCrosshairColorA)
		scriptData:Set('MR Overlay Setup pointCrosshairColor '..layerIndex, pointCrosshairColor)
		scriptData:Set('MR Overlay Setup drawCircle '..layerIndex, MR_Overlay.drawCircle)
		scriptData:Set('MR Overlay Setup circleRadius '..layerIndex, MR_Overlay.circleRadius)
		local pointCircleColor = MR_Utilities:RgbaToHex(MR_Overlay.pointCircleColorR, MR_Overlay.pointCircleColorG, MR_Overlay.pointCircleColorB, MR_Overlay.pointCircleColorA)
		scriptData:Set('MR Overlay Setup pointCircleColor '..layerIndex, pointCircleColor)
		scriptData:Set('MR Overlay Setup selectedPointsOnly '..layerIndex, MR_Overlay.selectedPointsOnly)
		scriptData:Set('MR Overlay Setup drawHiddenPoints '..layerIndex, MR_Overlay.drawHiddenPoints)

		-- Other
		if not scriptData:HasKey('MR Overlay Setup useFlipSettings '..layerIndex) then
			scriptData:Set('MR Overlay Setup useFlipSettings '..layerIndex, true)
		end

		scriptData:Set('MR Overlay Setup flipOverlay '..layerIndex, MR_Overlay.flipOverlay)
		scriptData:Set('MR Overlay Setup mirrorFlip '..layerIndex, MR_Overlay.mirrorFlip)
		scriptData:Set('MR Overlay Setup mirrorOverlayShade '..layerIndex, MR_Overlay.mirrorOverlayShade)
		scriptData:Set('MR Overlay Setup layerOriginCenter '..layerIndex, MR_Overlay.layerOriginCenter)
		scriptData:Set('MR Overlay Setup customCenter '..layerIndex, MR_Overlay.customCenter)
		scriptData:Set('MR Overlay Setup selectionCenter '..layerIndex, MR_Overlay.selectionCenter)
		scriptData:Set('MR Overlay Setup customCenterValueX '..layerIndex, MR_Overlay.customCenterValueX)
		scriptData:Set('MR Overlay Setup customCenterValueY '..layerIndex, MR_Overlay.customCenterValueY)

		if not scriptData:HasKey('MR Overlay Setup useFrameSettings '..layerIndex) then
			scriptData:Set('MR Overlay Setup useFrameSettings '..layerIndex, true)
		end

		scriptData:Set('MR Overlay Setup createFromFrame '..layerIndex, MR_Overlay.createFromFrame)
		scriptData:Set('MR Overlay Setup useFrame1 '..layerIndex, MR_Overlay.useFrame1)
		scriptData:Set('MR Overlay Setup useFrame2 '..layerIndex, MR_Overlay.useFrame2)
		scriptData:Set('MR Overlay Setup useFrame3 '..layerIndex, MR_Overlay.useFrame3)
		scriptData:Set('MR Overlay Setup useFrame4 '..layerIndex, MR_Overlay.useFrame4)
		scriptData:Set('MR Overlay Setup useFrame5 '..layerIndex, MR_Overlay.useFrame5)

		scriptData:Set('MR Overlay Setup frameVal1 '..layerIndex, MR_Overlay.frameVal1)
		scriptData:Set('MR Overlay Setup frameVal2 '..layerIndex, MR_Overlay.frameVal2)
		scriptData:Set('MR Overlay Setup frameVal3 '..layerIndex, MR_Overlay.frameVal3)
		scriptData:Set('MR Overlay Setup frameVal4 '..layerIndex, MR_Overlay.frameVal4)
		scriptData:Set('MR Overlay Setup frameVal5 '..layerIndex, MR_Overlay.frameVal5)
	end
end

-- **************************************************
-- Localization
-- **************************************************

function MR_Overlay:Localize(text)
	local phrase = {}

	phrase['Description'] = 'Script allows you to create an “overlay” -  a new layer that can be used as a visual reference. The content of the layer is based on the selected points or vector layers. You can choose the color and line width, turn off the fills and mirror the overlay.'
	phrase['UILabel'] = 'MR Overlay '..self:Version()
	
	phrase['Create overlay'] = 'Create overlay (Alt + click to create overlay layer)'
	phrase['Set custom pivot'] = 'Set custom pivot (Alt + click to set center from bone tip)'
	phrase['Show/Hide overlay'] = 'Show/Hide overlay'
	phrase['Delete overlay'] = 'Delete overlay'
	phrase['Opacity:'] = 'Opacity:'
	phrase['Main Opacity:'] = 'Main Opacity:'
	phrase['Change stroke width'] = 'Change stroke width'
	phrase['Stroke width'] = 'Stroke width'
	phrase['Recolor strokes'] = 'Recolor strokes'
	phrase['Recolor Stroke Tooltip'] = 'The color of the strokes in the newly created overlay layer.'
	phrase['Preserve strokes alpha'] = 'Preserve strokes alpha'
	phrase['Preserve fills alpha'] = 'Preserve fills alpha'
	phrase['Draw strokes'] = 'Draw strokes'
	phrase['Draw fills'] = 'Draw fills'
	phrase['Make shapes plain'] = 'Make shapes plain'
	phrase['Flip overlay'] = 'Flip overlay'
	phrase['Mirror overlay'] = 'Mirror overlay'
	phrase['Mirror overlay with shade'] = 'Mirror overlay with shade'
	phrase['Layer Origin'] = 'Layer Origin'
	phrase['Custom Center'] = 'Custom Pivot'
	phrase['Selection Center'] = 'Selection Center'
	phrase['Create from frame'] = 'Create from frame'
    phrase['Target frame'] = 'Target frame'
	phrase['Frame:'] = 'Frame:'
	phrase['Layers'] = 'Layers'
	phrase['Settings'] = 'Settings'
	phrase['Layer'] = 'Layer'
	phrase['visibility'] = 'visibility'
	phrase['Visible layers only'] = 'Visible layers only'
    phrase['Auto Select Points'] = 'Auto Select Points'
	phrase['Do not render overlay'] = 'Do not render overlay'
    phrase['Use shapes center'] = 'Use shapes center'
	phrase['Use separate shapes'] = 'Use separate shapes'
	phrase['Mirror shade value'] = 'Mirror shade value:'
	phrase['Clear overlay'] = 'Clear overlay'
	phrase['Convert'] = 'Convert to a normal layer'
	phrase['Save selection'] = 'Save selection (Alt + click to clear)'
	phrase['Use saved selection'] = 'Use saved selection'
	phrase['Open layer settings'] = 'Open layer settings'
	phrase['Set main settings to layer'] = 'Set main settings to layer (Alt + click to set only active settings)'
	phrase['Set layer settings as main'] = 'Set layer settings as main (Alt + click to set only active settings)'
	phrase['Use layer settings'] = 'Use layer settings'
	phrase['Recolor fill'] = 'Recolor fill'
	phrase['Shapes'] = 'Shapes'
	phrase['Bones'] = 'Bones'
	phrase['Points'] = 'Points'
	phrase['Draw center line'] = 'Draw center line'
	phrase['Pin bone radius'] = 'Pin bone radius'
	phrase['Draw pin bone center lines'] = 'Draw pin bone center lines'
	phrase['Selected bones only'] = 'Selected bones only'
	phrase['Draw hidden bones'] = 'Draw hidden bones'
	phrase['Show layers'] = 'Show layers'

	phrase['Line width'] = 'Line width:'
	phrase['Bones width'] = 'Bones width:'
	phrase['Draw crosshair'] = 'Draw crosshair'
	phrase['Crosshair radius'] = 'Crosshair radius:'
	phrase['Draw circle'] = 'Draw circle'
	phrase['Circle radius'] = 'Circle radius:'
	phrase['Selected points only'] = 'Selected points only'
	phrase['Draw hidden points'] = 'Draw hidden points'
	phrase['Reset'] = 'Reset'
	phrase['Randomize'] = 'Randomize'
	phrase['Auto generate'] = 'Auto generate'
	phrase['Use frame settings'] = 'Use frame settings'
	phrase['Use flip settings'] = 'Use flip settings'

	return phrase[text]
end