-- **************************************************
-- Provide Moho with the name of this script object
-- **************************************************

ScriptName = "SS_RefLayerUpdate"

-- **************************************************
-- Reference Layer Update - Same a bulit-in, but remembers settings and shortcut-keyable
-- version:	01.00 AS11+ #520914
-- by Sam Cogheil (SimplSam)
-- **************************************************

--[[ ***** Licence & Warranty *****

    __NONE__  -- Use and Abuse freely

]]

--[[
    ***** SPECIAL THANKS to:
	*    Stan (and team) @ MOHO Scripting -- https://mohoscripting.com
	*    The friendly faces @ Lost Marble / Moho Forum -- https://www.lostmarble.com/forum
]]

-- **************************************************
-- General information about this script
-- **************************************************

SS_RefLayerUpdate = {}

function SS_RefLayerUpdate:Name()
    return 'Reference Layer Update'
end

function SS_RefLayerUpdate:Version()
    return '1.0 #5209'
end

function SS_RefLayerUpdate:UILabel()
    return 'Update Reference Layer'
end

function SS_RefLayerUpdate:Creator()
    return "Sam Cogheil (SimplSam)"
end

function SS_RefLayerUpdate:Description()
    return "Update Reference Layer/s"
end

function SS_RefLayerUpdate:ColorizeIcon()
    return true
end


-- **************************************************
-- Is Relevant / Is Enabled
-- **************************************************

function SS_RefLayerUpdate:IsRelevant(moho)
    return moho.layer:IsReferencedLayer()
end

function SS_RefLayerUpdate:IsEnabled(moho)
    return true
end


-- **************************************************
-- Recurring Values
-- **************************************************

SS_RefLayerUpdate.addNewLayers = true
SS_RefLayerUpdate.removeLayers = true
SS_RefLayerUpdate.replaceVectors = false
SS_RefLayerUpdate.replaceBones = true


-- **************************************************
-- Prefs
-- **************************************************

function SS_RefLayerUpdate:LoadPrefs(prefs)
    self.addNewLayers = prefs:GetBool("SS_RefLayerUpdate.addNewLayers", true)
    self.removeLayers = prefs:GetBool("SS_RefLayerUpdate.removeLayers", true)
    self.replaceVectors = prefs:GetBool("SS_RefLayerUpdate.replaceVectors", false)
    self.replaceBones = prefs:GetBool("SS_RefLayerUpdate.replaceBones", true)
end

function SS_RefLayerUpdate:SavePrefs(prefs)
    prefs:SetBool("SS_RefLayerUpdate.addNewLayers", self.addNewLayers)
    prefs:SetBool("SS_RefLayerUpdate.removeLayers", self.removeLayers)
    prefs:SetBool("SS_RefLayerUpdate.replaceVectors", self.replaceVectors)
    prefs:SetBool("SS_RefLayerUpdate.replaceBones", self.replaceBones)
end

function SS_RefLayerUpdate:ResetPrefs()
    self.addNewLayers = true
    self.removeLayers = true
    self.replaceVectors = false
    self.replaceBones = true
end

-- **************************************************
-- SS_RefLayerUpdateDialog
-- **************************************************

local SS_RefLayerUpdateDialog = {}

SS_RefLayerUpdateDialog.ADD_NEWMISSING_LAYERS = MOHO.MSG_BASE
SS_RefLayerUpdateDialog.REMOVE_LAYERS = MOHO.MSG_BASE + 1
SS_RefLayerUpdateDialog.REPLACE_MISMATCHED_VECTORS = MOHO.MSG_BASE + 2
SS_RefLayerUpdateDialog.REPLACE_MISMATCHED_BONES = MOHO.MSG_BASE + 3

function SS_RefLayerUpdateDialog:new()
    local d = LM.GUI.SimpleDialog('Reference Layer Update', SS_RefLayerUpdateDialog)
    local l = d:GetLayout()

    d.dynamicText1Text = LM.GUI.DynamicText('Layer differences:', 0)
    l:AddChild(d.dynamicText1Text, LM.GUI.ALIGN_LEFT, 0)

    d.addNewLayersCheckbox = LM.GUI.CheckBox('Add new/missing layers from source', d.ADD_NEWMISSING_LAYERS)
    l:AddChild(d.addNewLayersCheckbox, LM.GUI.ALIGN_LEFT, 0)

    d.removeLayersCheckbox = LM.GUI.CheckBox('Remove layers that don\'t exist at source', d.REMOVE_LAYERS)
    l:AddChild(d.removeLayersCheckbox, LM.GUI.ALIGN_LEFT, 0)

    d.dynamicText2Text = LM.GUI.DynamicText('Vector differences:', 0)
    l:AddChild(d.dynamicText2Text, LM.GUI.ALIGN_LEFT, 0)

    d.replaceVectorsCheckbox = LM.GUI.CheckBox('Replace mismatched vectors', d.REPLACE_MISMATCHED_VECTORS)
    l:AddChild(d.replaceVectorsCheckbox, LM.GUI.ALIGN_LEFT, 0)

    d.dynamicText3Text = LM.GUI.DynamicText('Bone differences:', 0)
    l:AddChild(d.dynamicText3Text, LM.GUI.ALIGN_LEFT, 0)

    d.replaceBonesCheckbox = LM.GUI.CheckBox('Replace mismatched bones', d.REPLACE_MISMATCHED_BONES)
    l:AddChild(d.replaceBonesCheckbox, LM.GUI.ALIGN_LEFT, 0)
    return d
end

function SS_RefLayerUpdateDialog:UpdateWidgets(moho)
    self.addNewLayersCheckbox:SetValue(SS_RefLayerUpdate.addNewLayers)
    self.removeLayersCheckbox:SetValue(SS_RefLayerUpdate.removeLayers)
    self.replaceVectorsCheckbox:SetValue(SS_RefLayerUpdate.replaceVectors)
    self.replaceBonesCheckbox:SetValue(SS_RefLayerUpdate.replaceBones)
end

function SS_RefLayerUpdateDialog:OnOK(moho)
    SS_RefLayerUpdate.addNewLayers = self.addNewLayersCheckbox:Value()
    SS_RefLayerUpdate.removeLayers = self.removeLayersCheckbox:Value()
    SS_RefLayerUpdate.replaceVectors = self.replaceVectorsCheckbox:Value()
    SS_RefLayerUpdate.replaceBones = self.replaceBonesCheckbox:Value()
end


-- **************************************************
-- The guts of this script
-- **************************************************

function SS_RefLayerUpdate:Run(moho)
    local mohodoc = moho.document

    local dlog = SS_RefLayerUpdateDialog:new(moho)
    if (dlog:DoModal() == LM.GUI.MSG_CANCEL) then
        return
    end

    local refSyncOpts = MOHO.MohoLayerRefSyncOptions:new_local()
    refSyncOpts.fAddNewLayers = self.addNewLayers
    refSyncOpts.fRemoveMissingLayers = self.removeLayers
    refSyncOpts.fReplaceMismatchedBones = self.replaceBones
    refSyncOpts.fReplaceMismatchedVectors = self.replaceVectors

    mohodoc:PrepUndo()
    mohodoc:SetDirty()

    for i = 0, mohodoc:CountSelectedLayers() -1 do
        local layer = mohodoc:GetSelectedLayer(i)
        if (layer:IsReferencedLayer()) then
            layer:UpdateReferencedLayer(refSyncOpts)
        end
    end
end
