-- **************************************************
-- Provide Moho with the name of this script object
-- **************************************************

ScriptName = "SZ_CopyLayerParameters"

-- **************************************************
-- General information about this script
-- **************************************************

SZ_CopyLayerParameters = {}

function SZ_CopyLayerParameters:Name()
    return self:Localize("CopyLayerParameters")
end

function SZ_CopyLayerParameters:Version()
    return "2.2"
end

function SZ_CopyLayerParameters:Description()
    return self:Localize("Description")
end

function SZ_CopyLayerParameters:Creator()
    return "Stan from 2danimator.ru"
end

function SZ_CopyLayerParameters:UILabel()
    return self:Localize("UILabel")
end

-- **************************************************
-- Recurring values
-- **************************************************
SZ_CopyLayerParameters.doVisibility = false
SZ_CopyLayerParameters.doBlur = false
SZ_CopyLayerParameters.doOpacity = false
SZ_CopyLayerParameters.doFlipH = false
SZ_CopyLayerParameters.doFlipV = false

SZ_CopyLayerParameters.doTranslate = false
SZ_CopyLayerParameters.doScale = false
SZ_CopyLayerParameters.doRotateX = false
SZ_CopyLayerParameters.doRotateY = false
SZ_CopyLayerParameters.doRotateZ = false

SZ_CopyLayerParameters.doOutline = false
SZ_CopyLayerParameters.doShadow = false
SZ_CopyLayerParameters.doShading = false
SZ_CopyLayerParameters.doPerspectiveShading = false
SZ_CopyLayerParameters.doMotionBlur = false
SZ_CopyLayerParameters.doFollowPath = false


-- **************************************************
-- Dialog:
-- **************************************************
local SZ_CopyLayerParametersDialog = {}

function SZ_CopyLayerParametersDialog:new(moho)
    local name = moho.layer:Name()
    local d = LM.GUI.SimpleDialog(SZ_CopyLayerParameters:Localize("CopyLayerParameters") .. SZ_CopyLayerParameters:Localize("VersionText") .. SZ_CopyLayerParameters:Version(), SZ_CopyLayerParametersDialog)
    local l = d:GetLayout()
    
    l:PushV()
        l:AddChild(LM.GUI.StaticText(SZ_CopyLayerParameters:Localize("guiText1")..name..SZ_CopyLayerParameters:Localize("guiText2")), LM.GUI.ALIGN_LEFT)
        l:AddPadding(5)
    l:Pop()
    l:PushH()
        l:PushV()
            d.doVisibility = LM.GUI.CheckBox(SZ_CopyLayerParameters:Localize("Visibility"));
            l:AddChild(d.doVisibility, LM.GUI.ALIGN_LEFT)
            
            d.doBlur = LM.GUI.CheckBox(SZ_CopyLayerParameters:Localize("Blur"));
            l:AddChild(d.doBlur, LM.GUI.ALIGN_LEFT)
            
            d.doOpacity = LM.GUI.CheckBox(SZ_CopyLayerParameters:Localize("Opacity"));
            l:AddChild(d.doOpacity, LM.GUI.ALIGN_LEFT)
            
            d.doFlipH = LM.GUI.CheckBox(SZ_CopyLayerParameters:Localize("FlipH"));
            l:AddChild(d.doFlipH, LM.GUI.ALIGN_LEFT)
            
            d.doFlipV = LM.GUI.CheckBox(SZ_CopyLayerParameters:Localize("FlipV"));
            l:AddChild(d.doFlipV, LM.GUI.ALIGN_LEFT)
        l:Pop()
        l:AddPadding(20)
        l:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL)
        l:PushV()
            
            d.doTranslate = LM.GUI.CheckBox(SZ_CopyLayerParameters:Localize("Translation"));
            l:AddChild(d.doTranslate, LM.GUI.ALIGN_LEFT)
            
            d.doScale = LM.GUI.CheckBox(SZ_CopyLayerParameters:Localize("Scale"));
            l:AddChild(d.doScale, LM.GUI.ALIGN_LEFT)
            
            d.doRotateX = LM.GUI.CheckBox(SZ_CopyLayerParameters:Localize("RotationX"));
            l:AddChild(d.doRotateX, LM.GUI.ALIGN_LEFT)
            
            d.doRotateY = LM.GUI.CheckBox(SZ_CopyLayerParameters:Localize("RotationY"));
            l:AddChild(d.doRotateY, LM.GUI.ALIGN_LEFT)
            
            d.doRotateZ = LM.GUI.CheckBox(SZ_CopyLayerParameters:Localize("RotationZ"));
            l:AddChild(d.doRotateZ, LM.GUI.ALIGN_LEFT)
        l:Pop()
        l:AddPadding(20)
        l:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL)
        l:PushV()
            d.doOutline = LM.GUI.CheckBox(SZ_CopyLayerParameters:Localize("Outline"));
            l:AddChild(d.doOutline, LM.GUI.ALIGN_LEFT)
            
            d.doShadow = LM.GUI.CheckBox(SZ_CopyLayerParameters:Localize("Shadow"));
            l:AddChild(d.doShadow, LM.GUI.ALIGN_LEFT)
            
            d.doShading = LM.GUI.CheckBox(SZ_CopyLayerParameters:Localize("Shading"));
            l:AddChild(d.doShading, LM.GUI.ALIGN_LEFT)
            
            d.doPerspectiveShading = LM.GUI.CheckBox(SZ_CopyLayerParameters:Localize("3DShadow"));
            l:AddChild(d.doPerspectiveShading, LM.GUI.ALIGN_LEFT)
            
            d.doMotionBlur = LM.GUI.CheckBox(SZ_CopyLayerParameters:Localize("MotionBlur"));
            l:AddChild(d.doMotionBlur, LM.GUI.ALIGN_LEFT)
        l:Pop()
        l:AddPadding(20)
        l:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL)
        l:PushV()			
            d.doFollowPath = LM.GUI.CheckBox(SZ_CopyLayerParameters:Localize("FollowPath"));
            l:AddChild(d.doFollowPath, LM.GUI.ALIGN_LEFT)
        l:Pop()
        l:AddPadding(20)
    l:Pop()
    return d
end

function SZ_CopyLayerParametersDialog:UpdateWidgets()
    self.doVisibility:SetValue(SZ_CopyLayerParameters.doVisibility)
    self.doBlur:SetValue(SZ_CopyLayerParameters.doBlur)
    self.doOpacity:SetValue(SZ_CopyLayerParameters.doOpacity)
    self.doFlipH:SetValue(SZ_CopyLayerParameters.doFlipH)
    self.doFlipV:SetValue(SZ_CopyLayerParameters.doFlipV)
    
    self.doTranslate:SetValue(SZ_CopyLayerParameters.doTranslate)
    self.doScale:SetValue(SZ_CopyLayerParameters.doScale)
    self.doRotateX:SetValue(SZ_CopyLayerParameters.doRotateX)
    self.doRotateY:SetValue(SZ_CopyLayerParameters.doRotateY)
    self.doRotateZ:SetValue(SZ_CopyLayerParameters.doRotateZ)
    
    self.doOutline:SetValue(SZ_CopyLayerParameters.doOutline)
    self.doShadow:SetValue(SZ_CopyLayerParameters.doShadow)
    self.doShading:SetValue(SZ_CopyLayerParameters.doShading)
    self.doPerspectiveShading:SetValue(SZ_CopyLayerParameters.doPerspectiveShading)
    self.doMotionBlur:SetValue(SZ_CopyLayerParameters.doMotionBlur)
    self.doFollowPath:SetValue(SZ_CopyLayerParameters.doFollowPath)
end

function SZ_CopyLayerParametersDialog:OnOK()
    SZ_CopyLayerParameters.doVisibility = self.doVisibility:Value()
    SZ_CopyLayerParameters.doBlur = self.doBlur:Value()
    SZ_CopyLayerParameters.doOpacity = self.doOpacity:Value()
    SZ_CopyLayerParameters.doFlipH = self.doFlipH:Value()
    SZ_CopyLayerParameters.doFlipV = self.doFlipV:Value()
    
    SZ_CopyLayerParameters.doTranslate = self.doTranslate:Value()
    SZ_CopyLayerParameters.doScale = self.doScale:Value()
    SZ_CopyLayerParameters.doRotateX = self.doRotateX:Value()
    SZ_CopyLayerParameters.doRotateY = self.doRotateY:Value()
    SZ_CopyLayerParameters.doRotateZ = self.doRotateZ:Value()
    
    SZ_CopyLayerParameters.doOutline = self.doOutline:Value()
    SZ_CopyLayerParameters.doShadow = self.doShadow:Value()
    SZ_CopyLayerParameters.doShading = self.doShading:Value()
    SZ_CopyLayerParameters.doPerspectiveShading = self.doPerspectiveShading:Value()
    SZ_CopyLayerParameters.doMotionBlur = self.doMotionBlur:Value()
    SZ_CopyLayerParameters.doFollowPath = self.doFollowPath:Value()
end


-- **************************************************
-- The guts of this script
-- **************************************************


function SZ_CopyLayerParameters:IsEnabled(moho)
    return true
end

function SZ_CopyLayerParameters:IsRelevant(moho)
    return true
end

function SZ_CopyLayerParameters:Localize(text)
    local fileWord = MOHO.Localize("/Menus/File/File=File")
    
    local phrase = {}
    
    phrase["CopyLayerParameters"] = "Copy Layer Parameters"
    phrase["VersionText"] = " - Version "
    phrase["Description"] = "Copy transformation (scale, position, rotation, outline, shadows) from one layer to others"
    phrase["UILabel"] = "Copy Layer Parameters"
    phrase["guiText1"] = "The following parameters will be copied from <"
    phrase["guiText2"] = "> to the other selected layers:"

    phrase["Visibility"] = "Visibility"
    phrase["Blur"] = "Blur"
    phrase["Opacity"] = "Opacity"
    phrase["AutoShading"] = "Auto Shading"
    phrase["Threshold"] = "Threshold"
    phrase["FlipH"] = "Horizontal Flip"
    phrase["FlipV"] = "Vertical Flip"
    
    phrase["Translation"] = "Translation"
    phrase["Scale"] = "Scale"
    phrase["RotationX"] = "Rotation X"
    phrase["RotationY"] = "Rotation Y"
    phrase["RotationZ"] = "Rotation Z"
    
    phrase["Outline"] = "Outline"
    phrase["Shadow"] = "Shadow"
    phrase["Shading"] = "Shading"
    phrase["3DShadow"] = "3D Shadow"
    phrase["MotionBlur"] = "Motion Blur"
    phrase["FollowPath"] = "Follow Path"
    
    phrase["ParametersCopied"] = "Parameters copied successfully"
    phrase["OK"] = "OK"
    
    
    if fileWord == "Файл" then
        phrase["CopyLayerParameters"] = "Скопировать параметры слоя"
        phrase["VersionText"] = " - Версия "
        phrase["Description"] = "Копирует параметры (трансформация, обводка, тени) с одного слоя на другие"
        phrase["UILabel"] = "Скопировать параметры слоя"
        phrase["guiText1"] = "Следующие параметры слоя <"
        phrase["guiText2"] = "> будут скопированы на остальные выделенные слои:"
    
        phrase["Visibility"] = "Видимость"
        phrase["Blur"] = "Размытие"
        phrase["Opacity"] = "Прозрачность"
        phrase["AutoShading"] = "Авто-затенение"
        phrase["Threshold"] = "Постеризация"
        phrase["FlipH"] = "Горизонтальное отражение"
        phrase["FlipV"] = "Вертикальное отражение"
        
        phrase["Translation"] = "Перемещение"
        phrase["Scale"] = "Масштаб"
        phrase["RotationX"] = "Вращение вокруг оси X"
        phrase["RotationY"] = "Вращение вокруг оси Y"
        phrase["RotationZ"] = "Вращение вокруг оси Z"
        
        phrase["Outline"] = "Обводка"
        phrase["Shadow"] = "Тень"
        phrase["Shading"] = "Затенение"
        phrase["3DShadow"] = "3D тень"
        phrase["3DShadow"] = "Размытие движения"
        phrase["FollowPath"] = "Движение по вектору"
        
        phrase["ParametersCopied"] = "Параметры успешно скопированы"
        phrase["OK"] = "OK"
    end
    
    return phrase[text];
end

function SZ_CopyLayerParameters:Run(moho)
    
    local selLayers = moho.document:CountSelectedLayers()
    if  selLayers <= 1 then
        return false
    end
    
    local dlog = SZ_CopyLayerParametersDialog:new(moho)
    if (dlog:DoModal() == LM.GUI.MSG_CANCEL) then
        return
    end
    
    local primaryLayer = moho.layer
    
    moho.document:PrepMultiUndo()
    moho.document:SetDirty()
    
    for i=0, moho.document:CountSelectedLayers()-1 do
        local secondaryLayer = moho.document:GetSelectedLayer(i)
        if secondaryLayer ~= primaryLayer then
            
            if self.doVisibility then
                local visibility = primaryLayer.fVisibility:GetValue(moho.layerFrame)
                secondaryLayer.fVisibility:SetValue(moho.layerFrame, visibility)
            end

            if self.doBlur then
                local blur = primaryLayer.fBlur:GetValue(moho.layerFrame)
                secondaryLayer.fBlur:SetValue(moho.layerFrame, blur)
            end

            if self.doOpacity then
                local alpha = primaryLayer.fAlpha:GetValue(moho.layerFrame)
                secondaryLayer.fAlpha:SetValue(moho.layerFrame, alpha)
            end

            if self.doFlipH then
                local flipH = primaryLayer.fFlipH:GetValue(moho.layerFrame)
                secondaryLayer.fFlipH:SetValue(moho.layerFrame, flipH)
            end

            if self.doFlipV then
                local flipV = primaryLayer.fFlipV:GetValue(moho.layerFrame)
                secondaryLayer.fFlipV:SetValue(moho.layerFrame, flipV)
            end
            
            if self.doTranslate then
                local translation = primaryLayer.fTranslation:GetValue(moho.layerFrame)
                secondaryLayer.fTranslation:SetValue(moho.layerFrame, translation)
            end
            
            if self.doScale then
                local scale = primaryLayer.fScale:GetValue(moho.layerFrame)
                secondaryLayer.fScale:SetValue(moho.layerFrame, scale)
            end
            
            if self.doRotateX then
                local rotationX = primaryLayer.fRotationX:GetValue(moho.layerFrame)
                secondaryLayer.fRotationX:SetValue(moho.layerFrame, rotationX)
            end
            
            if self.doRotateY then
                local rotationY = primaryLayer.fRotationY:GetValue(moho.layerFrame)
                secondaryLayer.fRotationY:SetValue(moho.layerFrame, rotationY)
            end
            
            if self.doRotateZ then
                local rotationZ = primaryLayer.fRotationZ:GetValue(moho.layerFrame)
                secondaryLayer.fRotationZ:SetValue(moho.layerFrame, rotationZ)
            end
            
            if self.doOutline then
                local outline = primaryLayer.fLayerOutline:GetValue(moho.layerFrame)
                local color = primaryLayer.fOutlineColor:GetValue(moho.layerFrame)
                local width = primaryLayer.fOutlineWidth:GetValue(moho.layerFrame)

                secondaryLayer.fLayerOutline:SetValue(moho.layerFrame, outline)
                secondaryLayer.fOutlineColor:SetValue(moho.layerFrame, color)
                secondaryLayer.fOutlineWidth:SetValue(moho.layerFrame, width)
            end
            
            if self.doShadow then
                local shadow = primaryLayer.fLayerShadow:GetValue(moho.layerFrame)
                local angle = primaryLayer.fShadowAngle:GetValue(moho.layerFrame)
                local blur = primaryLayer.fShadowBlur:GetValue(moho.layerFrame)
                local color = primaryLayer.fShadowColor:GetValue(moho.layerFrame)
                local expansion = primaryLayer.fShadowExpansion:GetValue(moho.layerFrame)
                local noise = primaryLayer.fShadowNoiseAmp:GetValue(moho.layerFrame)
                local scale = primaryLayer.fShadowNoiseScale:GetValue(moho.layerFrame)
                local offset = primaryLayer.fShadowOffset:GetValue(moho.layerFrame)
                
                secondaryLayer.fLayerShadow:SetValue(moho.layerFrame, shadow)
                secondaryLayer.fShadowAngle:SetValue(moho.layerFrame, angle)
                secondaryLayer.fShadowBlur:SetValue(moho.layerFrame, blur)
                secondaryLayer.fShadowColor:SetValue(moho.layerFrame, color)
                secondaryLayer.fShadowExpansion:SetValue(moho.layerFrame, expansion)
                secondaryLayer.fShadowNoiseAmp:SetValue(moho.layerFrame, noise)
                secondaryLayer.fShadowNoiseScale:SetValue(moho.layerFrame, scale)
                secondaryLayer.fShadowOffset:SetValue(moho.layerFrame, offset)
            end

            if self.doShading then
                local shading = primaryLayer.fLayerShading:GetValue(moho.layerFrame)
                local angle = primaryLayer.fShadingAngle:GetValue(moho.layerFrame)
                local blur = primaryLayer.fShadingBlur:GetValue(moho.layerFrame)
                local color = primaryLayer.fShadingColor:GetValue(moho.layerFrame)
                local contraction = primaryLayer.fShadingContraction:GetValue(moho.layerFrame)
                local noise = primaryLayer.fShadingNoiseAmp:GetValue(moho.layerFrame)
                local scale = primaryLayer.fShadingNoiseScale:GetValue(moho.layerFrame)
                local offset = primaryLayer.fShadingOffset:GetValue(moho.layerFrame)
                
                secondaryLayer.fLayerShading:SetValue(moho.layerFrame, shading)
                secondaryLayer.fShadingAngle:SetValue(moho.layerFrame, angle)
                secondaryLayer.fShadingBlur:SetValue(moho.layerFrame, blur)
                secondaryLayer.fShadingColor:SetValue(moho.layerFrame, color)
                secondaryLayer.fShadingContraction:SetValue(moho.layerFrame, contraction)
                secondaryLayer.fShadingNoiseAmp:SetValue(moho.layerFrame, noise)
                secondaryLayer.fShadingNoiseScale:SetValue(moho.layerFrame, scale)
                secondaryLayer.fShadingOffset:SetValue(moho.layerFrame, offset)
            end
            
            if self.doPerspectiveShading then
                local shadow = primaryLayer.fPerspectiveShadow:GetValue(moho.layerFrame)
                local blur = primaryLayer.fPerspectiveBlur:GetValue(moho.layerFrame)
                local color = primaryLayer.fPerspectiveColor:GetValue(moho.layerFrame)
                local scale = primaryLayer.fPerspectiveScale:GetValue(moho.layerFrame)
                local shear = primaryLayer.fShadingOffset:GetValue(moho.layerFrame)
                
                secondaryLayer.fPerspectiveShadow:SetValue(moho.layerFrame, shadow)
                secondaryLayer.fPerspectiveBlur:SetValue(moho.layerFrame, blur)
                secondaryLayer.fPerspectiveColor:SetValue(moho.layerFrame, color)
                secondaryLayer.fPerspectiveScale:SetValue(moho.layerFrame, scale)
                secondaryLayer.fPerspectiveShear:SetValue(moho.layerFrame, shear)
            end
            
            if self.doMotionBlur then
                local fMotionBlur = primaryLayer.fMotionBlur:GetValue(moho.layerFrame)
                local fMotionBlurAlphaStart = primaryLayer.fMotionBlurAlphaStart:GetValue(moho.layerFrame)
                local fMotionBlurAlphaEnd = primaryLayer.fMotionBlurAlphaEnd:GetValue(moho.layerFrame)
                local fMotionBlurExtendedFrames = primaryLayer.fMotionBlurExtendedFrames:GetValue(moho.layerFrame)
                local fMotionBlurFramePercentage = primaryLayer.fMotionBlurFramePercentage:GetValue(moho.layerFrame)
                local fMotionBlurFrames = primaryLayer.fMotionBlurFrames:GetValue(moho.layerFrame)
                local fMotionBlurRadius = primaryLayer.fMotionBlurRadius:GetValue(moho.layerFrame)
                local fMotionBlurSkip = primaryLayer.fMotionBlurSkip:GetValue(moho.layerFrame)
                local fMotionBlurSubframes = primaryLayer.fMotionBlurSubframes:GetValue(moho.layerFrame)
                
                secondaryLayer.fMotionBlur:SetValue(moho.layerFrame, fMotionBlur)
                secondaryLayer.fMotionBlurAlphaStart:SetValue(moho.layerFrame, fMotionBlurAlphaStart)
                secondaryLayer.fMotionBlurAlphaEnd:SetValue(moho.layerFrame, fMotionBlurAlphaEnd)
                secondaryLayer.fMotionBlurExtendedFrames:SetValue(moho.layerFrame, fMotionBlurExtendedFrames)
                secondaryLayer.fMotionBlurFramePercentage:SetValue(moho.layerFrame, fMotionBlurFramePercentage)
                secondaryLayer.fMotionBlurFrames:SetValue(moho.layerFrame, fMotionBlurFrames)
                secondaryLayer.fMotionBlurRadius:SetValue(moho.layerFrame, fMotionBlurRadius)
                secondaryLayer.fMotionBlurSkip:SetValue(moho.layerFrame, fMotionBlurSkip)
                secondaryLayer.fMotionBlurSubframes:SetValue(moho.layerFrame, fMotionBlurSubframes)				
            end
            
            if self.doFollowPath then
                local fFollowing = primaryLayer.fFollowing:GetValue(moho.layerFrame)
                if fFollowing then
                    secondaryLayer.fFollowing:SetValue(moho.layerFrame, fFollowing)
                end
            end
        end -- end IF
    end -- end FOR
    
    LM.GUI.Alert(
        LM.GUI.ALERT_INFO,
        self:Localize("ParametersCopied"),
        nil,
        nil,
        self:Localize("OK"),
        nil,
        nil
    )
    
end

