-- **************************************************
-- Provide Moho with the name of this script object
-- **************************************************

ScriptName = "SZ_LayerCopiesRun"

-- **************************************************
-- General information about this script
-- **************************************************

SZ_LayerCopiesRun = {}

function SZ_LayerCopiesRun:Name()
    return self:Localize("Name")
end

function SZ_LayerCopiesRun:Version()
    return "1.3"
end

function SZ_LayerCopiesRun:UILabel()
    return self:Localize("UILabel")
end

function SZ_LayerCopiesRun:Creator()
    return "Stan from 2danimator.ru"
end

function SZ_LayerCopiesRun:Description()
    return self:Localize("Description")
end




-- **************************************************
-- Recurring values
-- **************************************************

-- SZ_LayerCopiesRun.value1 = false

-- **************************************************
-- Is Enabled
-- **************************************************

function SZ_LayerCopiesRun:IsEnabled(moho)
    if SZ_LayerCopies then
        return true
    end
    return false
end


-- **************************************************
-- The guts of this script
-- **************************************************

function SZ_LayerCopiesRun:Run(moho)
    local layers = SZ_LayerCopies:GetSelectedLayers(moho)
    for _, layer in ipairs(layers) do
        SZ_LayerCopies:RunSilently(moho, layer)
    end
end


-- **************************************************
-- Localization
-- **************************************************

function SZ_LayerCopiesRun:Localize(text)
    local fileWord = MOHO.Localize("/Menus/File/File=File")	
    local phrase = {}	
    phrase["Name"] = "Run Layer Copies"
    phrase["Description"] = "Silentry run the Layer Copies script"
    phrase["UILabel"] = "Run Layer Copies with last settings"
        
    if fileWord == "Файл" then
        phrase["Name"] = "Запустить Копии Слоя"
        phrase["Description"] = "Запускает скрипт Копии Слоя с последними настройками"
        phrase["UILabel"] = "Запустить скрипт Копии Слоя с последними настройками"
    end
    return phrase[text];
end

