-- **************************************************
-- Provide Moho with the name of this script object
-- **************************************************

ScriptName = "SZ_SwapViewMode"

-- **************************************************
-- General information about this script
-- **************************************************

SZ_SwapViewMode = {}

function SZ_SwapViewMode:Name()
    return self:Localize('UILabel')
end

function SZ_SwapViewMode:Version()
    return '1.01'
end

function SZ_SwapViewMode:UILabel()
    return self:Localize('UILabel')
end

function SZ_SwapViewMode:Creator()
    return 'Stan'
end

function SZ_SwapViewMode:Description()
    return self:Localize('Description')
end

-- **************************************************
-- Is Relevant / Is Enabled
-- **************************************************

function SZ_SwapViewMode:IsRelevant(moho)
    return true
end

function SZ_SwapViewMode:IsEnabled(moho)
    return true
end

-- **************************************************
-- Recurring values
-- **************************************************

-- Change this to whatever mode you like (see http://mohoscripting.com/methods/4):
-- For example: SZ_SwapViewMode.modeToSwap = MOHO.LDQ_FILLS + MOHO.LDQ_OUTLINES
SZ_SwapViewMode.modeToSwap = MOHO.LDQ_WIREFRAME

-- This is the variable to store the original mode to return to:
SZ_SwapViewMode.originalMode = 0

-- **************************************************
-- The guts of this script
-- **************************************************

function SZ_SwapViewMode:Run(moho)
    local currentMode = moho.view:QualityFlags()
    if currentMode ~= self.modeToSwap then
        self.originalMode = currentMode
        moho.view:SetQualityFlags(self.modeToSwap)
    else 
        moho.view:SetQualityFlags(self.originalMode)
    end
    
    -- local currentMode = moho.layer:QualityFlags()
    -- if currentMode ~= self.modeToSwap then
        -- self.originalMode = currentMode
        -- moho.layer:SetQualityFlags(self.modeToSwap)
    -- else 
        -- moho.layer:SetQualityFlags(self.originalMode)
    -- end
    
end

-- **************************************************
-- Localization
-- **************************************************

function SZ_SwapViewMode:Localize(text)
    local phrase = {}

    phrase['Description'] = 'Change the view mode with a hotkey'
    phrase['UILabel'] = 'Swap View Mode'


    local fileWord = MOHO.Localize("/Menus/File/File=File")
    if fileWord == "Файл" then
        phrase['Description'] = 'Сменить режим отображения в рабочем окне'
        phrase['UILabel'] = 'Сменить режим отображения'

    end

    return phrase[text]
end