-- **************************************************
-- Provide Moho with the name of this script object
-- **************************************************

ScriptName = "SZ_TimelineNavigator"

-- **************************************************
-- General information about this script
-- **************************************************

SZ_TimelineNavigator = {}

function SZ_TimelineNavigator:Name()
    return self:Localize('UILabel')
end

function SZ_TimelineNavigator:Version()
    return '1.0'
end

function SZ_TimelineNavigator:UILabel()
    return self:Localize('UILabel')
end

function SZ_TimelineNavigator:Creator()
    return 'Stan from 2danimator.ru'
end

function SZ_TimelineNavigator:Description()
    return self:Localize('Description')
end

-- **************************************************
-- Is Relevant / Is Enabled
-- **************************************************

function SZ_TimelineNavigator:IsRelevant(moho)
    return true
end

function SZ_TimelineNavigator:IsEnabled(moho)
    return true
end

-- **************************************************
-- Keyboard/Mouse Control
-- **************************************************

function SZ_TimelineNavigator:OnMouseDown(moho, mouseEvent)
    
end

function SZ_TimelineNavigator:OnMouseMoved(moho, mouseEvent)
    
end

function SZ_TimelineNavigator:OnMouseUp(moho, mouseEvent)
    
end

function SZ_TimelineNavigator:OnKeyDown(moho, keyEvent)
    
end

-- **************************************************
-- Recurring Values
-- **************************************************

SZ_TimelineNavigator.frames = 1
SZ_TimelineNavigator.seconds = 1
SZ_TimelineNavigator.timeMinutes = 0
SZ_TimelineNavigator.timeSeconds = 0
SZ_TimelineNavigator.timeFrames = 0


-- **************************************************
-- Tool options - create and respond to tool's UI
-- **************************************************

SZ_TimelineNavigator.FRAMES_BACK = MOHO.MSG_BASE
SZ_TimelineNavigator.FRAMES_INPUT = MOHO.MSG_BASE + 1
SZ_TimelineNavigator.FRAMES_FORWARD = MOHO.MSG_BASE + 2
SZ_TimelineNavigator.SECONDS_BACK = MOHO.MSG_BASE + 3
SZ_TimelineNavigator.SECONDS_INPUT = MOHO.MSG_BASE + 4
SZ_TimelineNavigator.SECONDS_FORWARD = MOHO.MSG_BASE + 5
SZ_TimelineNavigator.TIME_MINUTES_INPUT = MOHO.MSG_BASE + 6
SZ_TimelineNavigator.TIME_SECONDS_INPUT = MOHO.MSG_BASE + 7
SZ_TimelineNavigator.TIME_FRAMES_INPUT = MOHO.MSG_BASE + 8
SZ_TimelineNavigator.TIME_GO = MOHO.MSG_BASE + 9

-- **************************************************
-- Tool Panel Layout
-- **************************************************

function SZ_TimelineNavigator:DoLayout(moho, layout)
    self.framesTxt = LM.GUI.DynamicText(self:Localize('Frames:'), 0)
    layout:AddChild(self.framesTxt, LM.GUI.ALIGN_LEFT, 2)

    self.framesBackBtn = LM.GUI.Button(self:Localize('Back'), self.FRAMES_BACK)
    layout:AddChild(self.framesBackBtn, LM.GUI.ALIGN_LEFT, 0)

    self.framesInput = LM.GUI.TextControl(48, '1', self.FRAMES_INPUT, LM.GUI.FIELD_UINT)
    layout:AddChild(self.framesInput, LM.GUI.ALIGN_LEFT, 3)

    self.framesForwardBtn = LM.GUI.Button(self:Localize('Forward'), self.FRAMES_FORWARD)
    layout:AddChild(self.framesForwardBtn, LM.GUI.ALIGN_LEFT, 0)

    layout:AddPadding(20)

    layout:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL)

    layout:AddPadding(20)

    self.secondsTxt = LM.GUI.DynamicText(self:Localize('Seconds:'), 0)
    layout:AddChild(self.secondsTxt, LM.GUI.ALIGN_LEFT, 2)

    self.BackBtn = LM.GUI.Button(self:Localize('Back'), self.SECONDS_BACK)
    layout:AddChild(self.BackBtn, LM.GUI.ALIGN_LEFT, 0)

    self.secondsInput = LM.GUI.TextControl(48, '1', self.SECONDS_INPUT, LM.GUI.FIELD_UFLOAT)
    layout:AddChild(self.secondsInput, LM.GUI.ALIGN_LEFT, 3)

    self.secondsForwardBtn = LM.GUI.Button(self:Localize('Forward'), self.SECONDS_FORWARD)
    layout:AddChild(self.secondsForwardBtn, LM.GUI.ALIGN_LEFT, 0)

    layout:AddPadding(20)

    layout:AddChild(LM.GUI.Divider(true), LM.GUI.ALIGN_FILL)

    layout:AddPadding(20)
    
    self.timeText = LM.GUI.DynamicText(self:Localize('MM:SS:FF:'), 0)
    layout:AddChild(self.timeText, LM.GUI.ALIGN_LEFT, 2)
    
    self.timeMinutesInput = LM.GUI.TextControl(28, '0', self.TIME_MINUTES_INPUT, LM.GUI.FIELD_UINT)
    layout:AddChild(self.timeMinutesInput, LM.GUI.ALIGN_LEFT, 3)
    
    layout:AddPadding(-15)
    layout:AddChild(LM.GUI.StaticText(':'), LM.GUI.ALIGN_LEFT, 3)
    layout:AddPadding(-19)
    
    self.timeSecondsInput = LM.GUI.TextControl(28, '0', self.TIME_SECONDS_INPUT, LM.GUI.FIELD_UINT)
    layout:AddChild(self.timeSecondsInput, LM.GUI.ALIGN_LEFT, 3)
    
    layout:AddPadding(-15)
    layout:AddChild(LM.GUI.StaticText(':'), LM.GUI.ALIGN_LEFT, 3)
    layout:AddPadding(-19)
    
    self.timeFramesInput = LM.GUI.TextControl(28, '0', self.TIME_FRAMES_INPUT, LM.GUI.FIELD_UINT)
    layout:AddChild(self.timeFramesInput, LM.GUI.ALIGN_LEFT, 3)

    self.goBtn = LM.GUI.Button(self:Localize('Go'), self.TIME_GO)
    layout:AddChild(self.goBtn, LM.GUI.ALIGN_LEFT, 0)
end


function SZ_TimelineNavigator:UpdateWidgets(moho)
    self.framesInput:SetValue(self.frames)
    self.secondsInput:SetValue(self.seconds)
    self.timeMinutesInput:SetValue(self.timeMinutes)
    self.timeSecondsInput:SetValue(self.timeSeconds)
    self.timeFramesInput:SetValue(self.timeFrames)
end


function SZ_TimelineNavigator:HandleMessage(moho, view, msg)
    local curFrame = moho.frame
    local fps = moho.document:Fps()
    
    self.frames = self.framesInput:IntValue()
    self.seconds = self.secondsInput:FloatValue()
    self.timeMinutes = self.timeMinutesInput:IntValue()
    self.timeSeconds = LM.Clamp(self.timeSecondsInput:IntValue(), 0, 59)
    self.timeFrames = self.timeFramesInput:IntValue()
        
    if msg == self.FRAMES_BACK then
        local newFrame = curFrame - self.frames
        if newFrame < 0 then newFrame = 0 end
        moho:SetCurFrame(newFrame)
    elseif msg == self.FRAMES_FORWARD then
        moho:SetCurFrame(curFrame + self.frames)
    elseif msg == self.SECONDS_BACK then
        local frames = self.seconds * fps
        local newFrame = curFrame - math.floor(frames)
        if newFrame < 0 then newFrame = 0 end
        moho:SetCurFrame(newFrame)
    elseif msg == self.SECONDS_FORWARD then
        local frames = self.seconds * fps
        moho:SetCurFrame(curFrame + math.floor(frames))
    elseif msg == self.TIME_GO then
        local newFrame = (self.timeMinutes * 60 * fps) + (self.timeSeconds * fps) + self.timeFrames
        moho:SetCurFrame(newFrame)
    elseif msg == self.TIME_SECONDS_INPUT then
        self.timeSecondsInput:SetValue(LM.Clamp(self.timeSecondsInput:IntValue(), 0, 59))
    end
end

-- **************************************************
-- Localization
-- **************************************************

function SZ_TimelineNavigator:Localize(text)
    local phrase = {}

    phrase['Description'] = 'Navigates the timeline by frame or time intervals'
    phrase['UILabel'] = 'Timeline Navigator'

    phrase['Frames:'] = 'Frames:'
    phrase['Back'] = ' < Back    '
    phrase['Forward'] = 'Forward >'
    phrase['Seconds:'] = 'Seconds:'
    phrase['MM:SS:FF:'] = 'MM:SS:FF:'
    phrase['Go'] = '    Go    '

    local fileWord = MOHO.Localize("/Menus/File/File=File")
    if fileWord == "Файл" then
        phrase['Description'] = 'Навигация по таймлайну, используя интервалы в кадрах или секундах'
        phrase['UILabel'] = 'Навигация по таймлайну'

        phrase['Frames:'] = 'Кадры:'
        phrase['Back'] = ' < Назад  '
        phrase['Forward'] = 'Вперед >'
        phrase['Seconds:'] = 'Секунды:'
        phrase['MM:SS:FF:'] = 'ММ:СС:КК:'
        phrase['Go'] = '   Перейти   '
    end

    return phrase[text]
end