HS_CardSuits = {}

local thisUUT = "D"


function HS_CardSuits:Name()
	return "Card Suits"
end


function HS_CardSuits:Version()
	return "vers 1.04"
end

function HS_CardSuits:Description()
	return "Plug in for HS_Shape to draw card suit shapes."
end


function HS_CardSuits:Shape()
-- 	return: One word Tag; tooltip; icon file name
	return "Suits", "Click and drag for a shape.", "hs_card_suit"
end

function HS_CardSuits:About()
--	HS_Test_harness:tracePrint (thisUUT, self:Name(), self:Version(), "About")

	local body = [==[
This tool draws card suit shapes -- club, diamond, heart, spade.

There is one checkbox to use a fill/stroke that is usual for the suit
(red fill for dimaond/heart, black fill for club/spade).

For club there is a "rotundness" value which adjusts the overall shape:
-- 0 is most spread out, 10 is the most compact

For diamond, there is a "curvature" value which adjusts the straightness of the edges:
-- 0 is straight, 10 is maximum curvature.

For heart and spade there is a "roundness" which adjusts the overall shape:
-- 0 is "pointy", 10 is roundest
]==]

	return body .. "\n" .. self:Name() .. " " .. self:Version()

end

HS_CardSuits.clubCurv = 5
HS_CardSuits.diamondCurv = 5
HS_CardSuits.heartCurv = 5
HS_CardSuits.spadeCurv = 5
HS_CardSuits.Opt = 0
HS_CardSuits.SuitColours = true  

local doClub = 0
local doDiamond = 1
local doHeart = 2
local doSpade = 3
local ctOpts = 4

local labels = {"Club", "Diamond", "Heart", "Spade"}

local lastMouseDown


function HS_CardSuits:SavePrefs(prefs)
	prefs:SetInt("HS_CardSuits.Opt", self.Opt)
	prefs:SetFloat("HS_CardSuits.clubCurv", self.clubCurv)
	prefs:SetFloat("HS_CardSuits.diamondCurv", self.diamondCurv)
	prefs:SetFloat("HS_CardSuits.heartCurv", self.heartCurv)
	prefs:SetFloat("HS_CardSuits.spadeCurv", self.spadeCurv)
	prefs:SetBool("HS_CardSuits.SuitColours", self.SuitColours)

end

function HS_CardSuits:LoadPrefs(prefs)
	self.Opt = prefs:GetInt("HS_CardSuits.Opt", 0) 
	self.clubCurv = prefs:GetFloat("HS_CardSuits.clubCurv", 5)
	self.diamondCurv = prefs:GetFloat("HS_CardSuits.diamondCurv", 5)
	self.heartCurv = prefs:GetFloat("HS_CardSuits.heartCurv", 5)
	self.spadeCurv = prefs:GetFloat("HS_CardSuits.spadeCurv", 5)
	self.SuitColours = prefs:GetBool("HS_CardSuits.SuitColours", true)
end


function HS_CardSuits:ResetPrefs()
	self.Opt = 0
	self.clubCurv = 5
	self.diamondCurv = 5
	self.heartCurv = 5
	self.spadeCurv = 5
	self.SuitColours = true
end





function HS_CardSuits:Labels ()

	local buttText = labels[self.Opt+1]

	if self.Opt == doClub then
		HS_Shape:SetFloat ("Rotundness", self.clubCurv, 0.5)
	elseif self.Opt == doDiamond then
		HS_Shape:SetFloat ("Curvature", self.diamondCurv, 0.5)
	elseif self.Opt == doHeart then
		HS_Shape:SetFloat ("Roundness", self.heartCurv, 0.5)
	elseif self.Opt == doSpade then
		HS_Shape:SetFloat ("Roundness", self.spadeCurv, 0.5)
	end

	HS_Shape:SetButton (buttText)

	HS_Shape:SetCheckBox ("Use Suit Colours?", self.SuitColours)


end

function HS_CardSuits:Scale (moho, view, value)
	local rtx
	if self.Opt == doClub then
		self.clubCurv = LM.Clamp(value, 0, 10)
		rtx = self.clubCurv
	elseif self.Opt == doDiamond then
		self.diamondCurv = LM.Clamp(value, 0, 10)
		rtx = self.diamondCurv
	elseif self.Opt == doHeart then
		self.heartCurv = LM.Clamp(value, 0, 10)
		rtx = self.heartCurv
	elseif self.Opt == doSpade then
		self.spadeCurv = LM.Clamp(value, 0, 10)
		rtx = self.spadeCurv
	end
	return rtx
end



function HS_CardSuits:Button (moho, view, value)
	self.Opt = math.fmod(self.Opt + value + ctOpts, ctOpts)
end

function HS_CardSuits:CheckBox (moho, view, value)
	self.SuitColours = value
	return self.SuitColours
end



function HS_CardSuits:OnMouseDown (moho, mouseEvent, mesh, drawingFrame)

	local p, shape, blackSuit

	local fillCol = LM.ColorVector:new_local()
	local lineCol = LM.ColorVector:new_local()

	if self.Opt == doClub then
		p, shape = HS_CardSuits:OnMouseDown_Club(moho, mouseEvent, mesh, drawingFrame)
		blackSuit = true

	elseif self.Opt == doDiamond then
		p, shape = HS_CardSuits:OnMouseDown_Diamond(moho, mouseEvent, mesh, drawingFrame)
		blackSuit = false

	elseif self.Opt == doHeart then
		p, shape = HS_CardSuits:OnMouseDown_Heart(moho, mouseEvent, mesh, drawingFrame)
		blackSuit = false

	elseif self.Opt == doSpade then
		p, shape = HS_CardSuits:OnMouseDown_Spade(moho, mouseEvent, mesh, drawingFrame)
		blackSuit = true

	end

	lastMouseDown = self.Opt


--	HS_Test_harness:diagnosePrint (thisUUT, shape, self.SuitColours, blackSuit)


-->> consider using a style -- when can be created / edited from script (not poss in 13.5.5 and earlier)

	if self.SuitColours and shape then
		if blackSuit then
			fillCol:Set(0,0,0,1)
			lineCol:Set(1,1,1,1)
		else
			fillCol:Set(1,0,0,1)
			lineCol:Set(0,0,0,1)
		end
--		HS_Test_harness:diagnosePrint (thisUUT, {"fill", fillCol}, {"line", lineCol})
			
		shape.fMyStyle.fFillCol:SetValue(drawingFrame, fillCol)
		shape.fMyStyle.fLineCol:SetValue(drawingFrame, lineCol)

	end

	return p

end


function HS_CardSuits:OnMouseMoved (moho, mouseEvent, mesh, drawingFrame, drawnPoints)

	if lastMouseDown ~= self.Opt then
		return -- might happen with edit mode
	end

	if self.Opt == doClub then
		HS_CardSuits:OnMouseMoved_Club(moho, mouseEvent, mesh, drawingFrame, drawnPoints)

	elseif self.Opt == doDiamond then
		HS_CardSuits:OnMouseMoved_Diamond(moho, mouseEvent, mesh, drawingFrame, drawnPoints)

	elseif self.Opt == doHeart then
		HS_CardSuits:OnMouseMoved_Heart(moho, mouseEvent, mesh, drawingFrame, drawnPoints)

	elseif self.Opt == doSpade then
		HS_CardSuits:OnMouseMoved_Spade(moho, mouseEvent, mesh, drawingFrame, drawnPoints)

	end


end







--********************************************************************
--****************************************************************************************************************************************	CLUB
--********************************************************************



local thisUUT = "D"

startVec = LM.Vector2:new_local()
local startPt
local mainCircPts = 7
local stemCircPts = 4
local points =  3*mainCircPts + 2*stemCircPts - 4 -- those at the junctions appear in both circles...



local radius = 1
local overlap = 0.1
local stemRadius = 0.7
local stemWidth = 0.15


--
--	for "compactness"
--
--local radiusLo = 1		-- most spread out
local overlapLo = 0.1
--local stemRadiusLo = 0.7
local stemWidthLo = 0.15

--local radiusHi = 1		-- blobby
local overlapHi = 0.45
--local stemRadiusHi = 0.7
local stemWidthHi = 0.33



local rad60 = math.rad (60)
local sin60 = math.sin (rad60)

--
-- the centres of the five circles
--
-- local topL = {0.0} all centres wrt this {0,0}
--
local c1 = LM.Vector2:new_local()
local c2L = LM.Vector2:new_local()
local c2R = LM.Vector2:new_local()
local c3L = LM.Vector2:new_local()
local c3R = LM.Vector2:new_local()
local p3L = LM.Vector2:new_local()
local p3R = LM.Vector2:new_local()

--
-- 	the c1 / c2 overlap points
--

local alpha 
local thetaHeadLc1 	-- the left as a polar on C1
local thetaHeadLc2 	-- and on C2L
local thetaHeadRc1	-- the right as a polar on C1
local thetaHeadRc2 	-- and on C2R


--
--	intersection of the C3/C2 circles (L and R)
--


local vec = LM.Vector2:new_local()

local dC3C2L 		-- distance between the centres
local aL 
local hL 
local thetaStemLc3 		 -- a polar on c3
local thetaStemLc2 		 -- a polar on c2


local dC3C2R 
local aR 
local hR 
local thetaStemRc3 
local thetaStemRc2 


--
--	where the stem stops
--

local thetaStemBaseL
local thetaStemBaseR 


local xFacLow 
local xFacHi 	-- the highest x value

local yFacLow
local yFacHi 	-- the lowest y value

local startC1 = 0
local startC2R = mainCircPts + startC1 - 1
local startC3R = mainCircPts + startC2R - 1
local startC3L = stemCircPts + startC3R		-- for the "bar" across the base
local startC2L = stemCircPts + startC3L - 1


local circ = {centre = LM.Vector2:new_local(), startPt = 0, points = 0, r = 0, startTheta = 0, endTheta=0}

local drawingData = {}





local function setDrawingData ()

	local roundness = HS_CardSuits.clubCurv / 10

	overlap = overlapHi - ((overlapHi - overlapLo) * (1 - roundness))
	stemWidth = stemWidthHi - ((stemWidthHi - stemWidthLo) * (1 - roundness))


	c1:Set(2*radius-overlap, -radius)

	c2L:Set(radius, c1.y-(2*(radius-overlap))*sin60)
	c2R:Set(3*radius-2*overlap, c1.y-(2*(radius-overlap))*sin60)

	c3L:Set(c1.x-stemRadius-(stemWidth/2), c2L.y-radius)
	c3R:Set(c1.x+stemRadius+(stemWidth/2), c2R.y-radius)


--
-- 	work out the c1 / c2 overlap points
--

	alpha = math.acos((radius-overlap)/radius)

	thetaHeadLc1 = 1.5*math.pi-alpha-(rad60/2) 	-- the left as a polar on C1
	thetaHeadLc2 = alpha+rad60 			-- and on C2L


	thetaHeadRc1 = -0.5*math.pi+alpha+(rad60/2)	-- the right as a polar on C1
	thetaHeadRc2 = math.pi - thetaHeadLc2		-- and on C2R


--
--	work out the points of intersection of the C3/C2 circles
--	(the L and R variants are actually symmetrical in the default version, but calc'd separately for clarity)
--	[this version of intersect calc. needed because the C3/C2 radii are different, unlike the C1/C2 case]
--

	vec = c3L - c2L
	dC3C2L = vec:Mag() -- distance between the centres

	aL = (radius*radius - stemRadius*stemRadius + dC3C2L*dC3C2L) / (2* dC3C2L)
	hL = math.sqrt (radius*radius - aL*aL)

	vec.x = c2L.x + aL * (c3L.x - c2L.x) / dC3C2L -- vec has the mid point of the line between the two points of intersection 
	vec.y = c2L.y + aL * (c3L.y - c2L.y) / dC3C2L

-- for Left the intercept we want is the rightmost one (larger x)

	p3L.x = vec.x - hL * (c3L.y - c2L.y) / dC3C2L
	p3L.y = vec.y + hL * (c3L.x - c2L.x) / dC3C2L

	thetaStemLc3 = math.acos((p3L.x-c3L.x)/stemRadius) -- that coord as a polar on c3
	thetaStemLc2 = 2*math.pi - math.acos((p3L.x-c2L.x)/radius) -- that coord as a polar on c2


	vec = c3R - c2R
	dC3C2R = vec:Mag()
	aR = (radius*radius - stemRadius*stemRadius + dC3C2R*dC3C2R) / (2* dC3C2R)
	hR = math.sqrt (radius*radius - aR*aR)

	vec.x = c2R.x + aR * (c3R.x - c2R.x) / dC3C2R
	vec.y = c2R.y + aR * (c3R.y - c2R.y) / dC3C2R

-- for Right the intercept we want is the leftmost one (smaller x)

	p3R.x = vec.x + hR * (c3R.y - c2R.y) / dC3C2R
	p3R.y = vec.y - hR * (c3R.x - c2R.x) / dC3C2R

	thetaStemRc3 = math.acos((p3R.x-c3R.x)/stemRadius) -- that coord as a polar on c3
	thetaStemRc2 = - math.acos((p3R.x-c2R.x)/radius) -- that coord as a polar on c2


--
--	where the stem stops
--

	thetaStemBaseL = -0.5 * math.pi
	thetaStemBaseR = 1.5 * math.pi

	xFacLow = 0
	xFacHi = c2R.x + radius		-- the highest x value

	yFacLow = 0
	yFacHi = c3R.y-stemRadius 	-- the lowest y value

--
--	populate the drawing table
--

	drawingData = {}

	circ = {centre = c1, startPt = startC1, points = mainCircPts, r = radius, startTheta = thetaHeadLc1, endTheta=thetaHeadRc1}
	table.insert (drawingData, circ)

	circ = {centre = c2R, startPt = startC2R, points = mainCircPts, r = radius, startTheta = thetaHeadRc2, endTheta=thetaStemRc2}
	table.insert (drawingData, circ)

	circ = {centre = c3R, startPt = startC3R, points = stemCircPts, r = stemRadius, startTheta = thetaStemRc3, endTheta=thetaStemBaseR}
	table.insert (drawingData, circ)

	circ = {centre = c3L, startPt = startC3L, points = stemCircPts, r = stemRadius, startTheta = thetaStemBaseL, endTheta=thetaStemLc3}
	table.insert (drawingData, circ)

	circ = {centre = c2L, startPt = startC2L, points = mainCircPts, r = radius, startTheta = thetaStemLc2, endTheta=thetaHeadLc2}
	table.insert (drawingData, circ)

	circ = {centre = nil, startPt = points, points = nil, r = nil, startTheta = nil, endTheta=nil}  -- end marker
	table.insert (drawingData, circ)

	return
end



function HS_CardSuits:OnMouseDown_Club (moho, mouseEvent, mesh, drawingFrame)

	local i, j, shape


	startVec:Set(HS_Shape:DrawingPos(moho, mouseEvent))

	curv = 0.4 -- a bit rounder than 4pt circle

	startPt, shape = HS_Shape:MakeLoop(moho, startVec, drawingFrame, points, curv)

	local pkPts = {startC1, startC2R, startC3R, startC3L-1, startC3L, startC2L} -- where the circles join and across the base (6)

	for j = 1, #pkPts do 
		mesh:Point(startPt + pkPts[j]):SetCurvature(MOHO.PEAKED, drawingFrame)
	end

	return points, shape
end

function HS_CardSuits:OnMouseMoved_Club(moho, mouseEvent, mesh, drawingFrame, drawnPoints)
	local vec1 = LM.Vector2:new_local() -- start
	local vec2 = LM.Vector2:new_local() -- mouse now

	vec1, vec2 = HS_Shape:DrawingBounds (moho, mouseEvent)

	local i, j, y
	local pt
	local theta = 0

	setDrawingData ()

	local xScale = (vec2.x-vec1.x) / (xFacHi - xFacLow)
	local xOffset = vec1.x
	local yScale = (vec2.y-vec1.y) / (yFacHi - yFacLow)
	local yOffset = vec1.y


	local st, last, step, ptsToMove
	for i = 1, #drawingData - 1 do
		theta = drawingData[i].startTheta
		last = drawingData[i].endTheta
		step = (last-theta) / (drawingData[i].points-1)
		ptsToMove = drawingData[i+1].startPt - drawingData[i].startPt

		for j = 0, ptsToMove - 1 do
			pt = mesh:Point(startPt + drawingData[i].startPt + j)
			pt.fPos.x = xOffset + xScale * (drawingData[i].centre.x + drawingData[i].r * math.cos(theta))
			pt.fPos.y = yOffset + yScale * (drawingData[i].centre.y + drawingData[i].r * math.sin(theta))
			theta = theta + step
		end

	end

end






--********************************************************************
--****************************************************************************************************************************************	DIAMOND
--********************************************************************




startVec = LM.Vector2:new_local()
local startPt

local points =  8


function HS_CardSuits:OnMouseDown_Diamond(moho, mouseEvent, mesh, drawingFrame)

	local i, j, shape

	startVec:Set(HS_Shape:DrawingPos(moho, mouseEvent))

	curv = 0.4 -- a bit rounder than 4pt circle

	startPt, shape = HS_Shape:MakeLoop(moho, startVec, drawingFrame, points, curv)


	for j = 0, points-1, 2 do 
		mesh:Point(startPt + j):SetCurvature(MOHO.PEAKED, drawingFrame) -- every other one peaked
	end

	return points, shape
end

function HS_CardSuits:OnMouseMoved_Diamond (moho, mouseEvent, mesh, drawingFrame, drawnPoints)
	local vec1 = LM.Vector2:new_local() -- start
	local vec2 = LM.Vector2:new_local() -- mouse now

	vec1, vec2 = HS_Shape:DrawingBounds (moho, mouseEvent)

	local i, j, y
	local pt
	local radius = HS_CardSuits.diamondCurv / 100


	local xCurv = radius * (vec2.x-vec1.x)
	local yCurv = radius * (vec2.y-vec1.y)

	local X0 = vec1.x 
	local X1by4 = vec1.x + xCurv + (vec2.x-vec1.x)/4 
	local X1by2 = vec1.x + (vec2.x-vec1.x)/2 
	local X3by4 = vec1.x - xCurv + 3*(vec2.x-vec1.x)/4 
	local X1 = vec2.x 

	local Y0 = vec1.y 
	local Y1by4 = vec1.y + yCurv + (vec2.y-vec1.y)/4 
	local Y1by2 = vec1.y + (vec2.y-vec1.y)/2 
	local Y3by4 = vec1.y - yCurv +  3*(vec2.y-vec1.y)/4 
	local Y1 = vec2.y 



	local ptBase = {{x=X1by2, y=Y0}, {x=X3by4, y=Y1by4}, {x=X1, y=Y1by2}, {x=X3by4, y=Y3by4}, {x=X1by2, y=Y1}, {x=X1by4, y=Y3by4}, {x=X0, y=Y1by2}, {x=X1by4, y=Y1by4}}

	for i = 1, points do
		pt = mesh:Point(startPt + i - 1)
		pt.fPos.x = ptBase[i].x
		pt.fPos.y = ptBase[i].y
	end


end






--********************************************************************
--****************************************************************************************************************************************	HEART
--********************************************************************

startVec = LM.Vector2:new_local()
local startPt
local points =  16

local yFac = {1, -0.36, -0.15, -0.08}


local yFacRound = {1, -0.36, -0.15, -0.08}
local yFacPoint = {.7, -.5, 0, -.08}


local yFacLow 
local yFacHi


function HS_CardSuits:OnMouseDown_Heart(moho, mouseEvent, mesh, drawingFrame)

	local i, j, shape

	startVec:Set(HS_Shape:DrawingPos(moho, mouseEvent))

	curv = 0.4 -- a bit rounder than 4pt circle

	startPt, shape = HS_Shape:MakeLoop(moho, startVec, drawingFrame, points, curv)

	mesh:Point(startPt):SetCurvature(MOHO.PEAKED, drawingFrame)
	mesh:Point(startPt + (points/2)):SetCurvature(MOHO.PEAKED, drawingFrame)



	local roundness = 1				-- set the bounds for roundest shape

	for i = 1, #yFac do
		yFac[i] = yFacRound[i] - ((yFacRound[i] - yFacPoint[i]) * (1 - roundness))
	end



	yFacLow = (-yFac[1] + yFac[2] - yFac[3] + yFac[4]) -- at theta = Pi

	yFacHi = 0 -- at peak of the heart
	for j = 1, #yFac do 
		yFacHi = yFacHi + (yFac[j] * math.cos(j*0.908))
	end
	return points, shape
end

function HS_CardSuits:OnMouseMoved_Heart(moho, mouseEvent, mesh, drawingFrame, drawnPoints)
	local vec1 = LM.Vector2:new_local() -- start
	local vec2 = LM.Vector2:new_local() -- mouse now

	vec1, vec2 = HS_Shape:DrawingBounds (moho, mouseEvent)

	local i, j, y
	local pt
	local theta = 0
	local step = 2*math.pi/points
	local xScale = (vec2.x-vec1.x)/2
	local xOffset = (vec2.x+vec1.x)/2
	local yScale = (vec2.y-vec1.y) / (yFacLow - yFacHi)
	local yOffset = vec2.y - (yScale * yFacLow) 

	local roundness = HS_CardSuits.heartCurv / 10

	for i = 1, #yFac do
		yFac[i] = yFacRound[i] - ((yFacRound[i] - yFacPoint[i]) * (1 - roundness))
	end


	for i = 0, points - 1 do
		pt = mesh:Point(startPt + i)
		pt.fPos.x = xOffset + xScale*math.sin(theta)*math.sin(theta)*math.sin(theta)
		y = 0
		for j = 1, #yFac do 
			y = y + yFac[j] * math.cos(j*theta)
		end
		pt.fPos.y = yOffset + (yScale * y)
		theta = theta + step
	end

end




--********************************************************************
--****************************************************************************************************************************************	SPADE
--********************************************************************

local stemPts = 4  -- must be 4

--local stemPts = 6  -- must be even and matched to thetaStem ((improve this later!!))
local headPts = 15 -- must be odd

local points =  stemPts + headPts


local yFac = {-1, 0.385, 0.154, 0.077}

local yFacRound = {-1, .22, .20, .077}
local yFacPoint = {-1, 0.385, 0.154, 0.077}


local yStem = {-0.7, 0.5, -0.3, 0.95}

local thetaHead = 0.38
local thetaStemLow = 0.6
local thetaStemHi = 0.85

local stemHeadP = 0.38
local stemLowP = 0.6
local stemHiP = 0.85

local stemHeadR = 0.45
local stemLowR = 0.58
local stemHiR = 0.7

local thetaStem = {math.pi * 2 - thetaStemLow, math.pi * 2 - thetaStemHi, thetaStemHi, thetaStemLow}

local yFacLow
local yFacHi


function HS_CardSuits:OnMouseDown_Spade(moho, mouseEvent, mesh, drawingFrame)
	local i, j, shape

	startVec:Set(HS_Shape:DrawingPos(moho, mouseEvent))

	curv = 0.4 -- a bit rounder than 4pt circle

	startPt, shape = HS_Shape:MakeLoop(moho, startVec, drawingFrame, points, curv)

	local pkPts = {0, (headPts-1)/2, headPts-1, headPts - 1 + stemPts/2, headPts + stemPts/2}

	for j = 1, #pkPts do 
		mesh:Point(startPt + pkPts[j]):SetCurvature(MOHO.PEAKED, drawingFrame)
	end

	local roundness = 0 -- default for scale is pointy

	for i = 1, #yFac do
		yFac[i] = yFacRound[i] - ((yFacRound[i] - yFacPoint[i]) * (1 - roundness))
	end


	yFacHi = (-yFac[1] + yFac[2] - yFac[3] + yFac[4]) -- at theta = Pi (at the point of the spade)

	yFacLow = 0 -- at base of the stem
	for j = 1, #yStem do 
		yFacLow = yFacLow + (yStem[j] * math.cos(j*stemHiP))
	end

	return points, shape
end

function HS_CardSuits:OnMouseMoved_Spade(moho, mouseEvent, mesh, drawingFrame, drawnPoints)
	local vec1 = LM.Vector2:new_local() -- start
	local vec2 = LM.Vector2:new_local() -- mouse now

	vec1, vec2 = HS_Shape:DrawingBounds (moho, mouseEvent)

	local i, j, y
	local pt
	local theta = thetaHead
	local step = (2*(math.pi-thetaHead))/(headPts-1)

	local xScale = (vec2.x-vec1.x)/2
	local xOffset = (vec2.x+vec1.x)/2

	local yScale = (vec2.y-vec1.y) / (yFacLow - yFacHi)
	local yOffset = vec2.y - (yScale * yFacLow) 


	local roundness = HS_CardSuits.spadeCurv / 10

	for i = 1, #yFac do
		yFac[i] = yFacRound[i] - ((yFacRound[i] - yFacPoint[i]) * (1 - roundness))
	end

	thetaHead = stemHeadR - ((stemHeadR - stemHeadP) * (1 - roundness))
	thetaStemLow = stemLowR - ((stemLowR - stemLowP) * (1 - roundness))
	thetaStemHi = stemHiR - ((stemHiR - stemHiP) * (1 - roundness))

	local thetaStem = {math.pi * 2 - thetaStemLow, math.pi * 2 - thetaStemHi, thetaStemHi, thetaStemLow}


	for i = 0, headPts - 1 do
		pt = mesh:Point(startPt + i)
		pt.fPos.x = xOffset + xScale*math.sin(theta)*math.sin(theta)*math.sin(theta)
		y = 0
		for j = 1, #yFac do 
			y = y + yFac[j] * math.cos(j*theta)
		end
		pt.fPos.y = yOffset + (yScale * y)
		theta = theta + step
	end

	for i = 1, #thetaStem do
		pt = mesh:Point(startPt + headPts + i - 1)
		theta = thetaStem[i]
		pt.fPos.x = xOffset + xScale*math.sin(theta)*math.sin(theta)*math.sin(theta)
		y = 0
		for j = 1, #yStem do 
			y = y + yStem[j] * math.cos(j*theta)
		end
		pt.fPos.y = yOffset + (yScale * y)
	end

end





